/* LOADER.C
 * Data loader routines for mule.
 *************
 * 29.08.2000 : Toni Rsnen
 *              modifications/documentation for open source
 *
 */

#include <stdlib.h>
#include <stdio.h>
#include "mpack.h"
#include "gfx2.h"
#include "pakfile.h"

char *mapsprites[50];
char *mapbacksprites[50];
char *prodsprites[50];
char *selsprites[20];
char *racesprites[10][12];
char *animspr[20][25];
char *racesmall[10][12];
int mapsprc;

void load_animsprites()
{  FILE *tied = ffopen ("anim.dat", "rb");
   int size,xsize,ysize,maj,min;

   fread ( &xsize, 4,1, tied);
   maj = 0;
   while ( xsize != 0)
     {  fread ( &ysize, 4,1, tied);
        fread ( &size, 4,1, tied); min = 0;
        while ( size != 0)
           {  fread ( ruutu2, size,1, tied);
              animspr[maj][min] = (char*) malloc( ysize*xsize+8 );
              sunpackmem (ruutu2, animspr[maj][min++], size);
              fread ( &size, 4,1, tied);
           }
        animspr[maj][min] = NULL;
        fread ( &xsize, 4,1, tied); maj++;
     }

   ffclose (tied);
}

void load_mapsprites()
{  int size, i;
   FILE *tied = ffopen ("mapspr.dat", "rb");

   panic ( tied==NULL, "mapspr.dat" );

   fread ( &size, 4,1, tied);
   i = 0;
   while (size)
     {  fread (ruutu2, size,1, tied);
        mapsprites[i] = (char*) malloc (22*22+16);

        size = sunpackmem (ruutu2, mapsprites[i], size);

        i++;
        fread ( &size, 4,1, tied);
     }
   mapsprc = i-1;

   ffclose (tied);
}

void load_mapspeedsprites()
{  int size, i;
   FILE *tied = ffopen ("mapbspr.dat", "rb");

   panic ( tied==NULL, "mapbspr.dat" );

   fread ( &size, 4,1, tied);
   i = 0;
   while (size)
     {  fread (ruutu2, size,1, tied);
        mapbacksprites[i] = (char*) malloc (22*22+16);

        size = sunpackmem (ruutu2, mapbacksprites[i], size);

        i++;
        fread ( &size, 4,1, tied);
     }

   ffclose (tied);
}

void load_prodsprites()
{  int size, i;
   FILE *tied = ffopen ("prods.dat", "rb");

   panic ( tied==NULL, "prods.dat" );

   fread ( &size, 4,1, tied);
   i = 0;
   while (size)
     {  fread (ruutu2, size,1, tied);
        prodsprites[i] = (char*) malloc (22*22+16);

        size = sunpackmem (ruutu2, prodsprites[i], size);

        i++;
        fread ( &size, 4,1, tied);
     }
   mapsprc = i-1;

   ffclose (tied);
}

void load_selsprites()
{  int size, i;
   FILE *tied = ffopen ("sels.dat", "rb");

   panic ( tied==NULL, "sels.dat" );

   fread ( &size, 4,1, tied);
   i = 0;
   while (size)
     {  fread (ruutu2, size,1, tied);
        selsprites[i] = (char*) malloc (22*22+16);

        size = sunpackmem (ruutu2, selsprites[i], size);

        i++;
        fread ( &size, 4,1, tied);
     }
   mapsprc = i-1;

   ffclose (tied);
}

void load_racesprites()
{  int size, i,r;
   FILE *tied = ffopen ("races.dat", "rb");

   panic ( tied==NULL, "races.dat" );

   fread ( &size, 4,1, tied);
   i = 0; r = 0;
   while (size)
     {  fread (ruutu2, size,1, tied);
        racesprites[r][i] = (char*) malloc (25*25+16);

        size = sunpackmem (ruutu2, racesprites[r][i], size);

        i++; if (i == 12) { r++; i = 0; }
        fread ( &size, 4,1, tied);
     }

   ffclose (tied);
}

void load_smallracesprites()
{  int size, i,r;
   FILE *tied = ffopen ("racess.dat", "rb");

   panic ( tied==NULL, "racess.dat" );

   fread ( &size, 4,1, tied);
   i = 0; r = 0;
   while (size)
     {  fread (ruutu2, size,1, tied);
        racesmall[r][i] = (char*) malloc (9*9+16);

        size = sunpackmem (ruutu2, racesmall[r][i], size);

        i++; if (i == 12) { r++; i = 0; }
        fread ( &size, 4,1, tied);
     }

   ffclose (tied);
}




