/*   LBM2TFF.C - copyright (c) Toni Rsnen, 1998
 *   --------------------------------------------
 *   Routine to convert LBM (dp 2.3 format) files to imagination's
 *   own generic graphics file format ("TFF")
 *   NOTE: This program CAN NOT unpack other formats than dp2.3
 *   format; output is all shit if attempted to load old format LBMs.
 *
 *   Files required: GFX.C/H, MPACK.C/H
 *
 *   Revision history:
 *       1.0:   20.06.98: + Added headers
 *                        - Graphics mode removed - textmode only now
 *       1.1:   28.07.98: + Added multi-res LBM support - now up to 640x480
 *
 *
 */

#include <stdio.h>
#include "mpack.h"
#include "gfx2.h"

char *k1,*k2;
int i;
FILE *tied;
int size;
int xsize,ysize;
int a,b;
int i,c;


int main (int arc, char *argv[])
{
    printf ("LBM2TFF /DJGPP v1.1 -- Copyright (c) Hw/img 1998\n");
    if (arc < 2)
      { printf ("Usage: LBM2TFF [source.lbm] [target.tff] [-y]\n"); exit(0); }

    if ( (tied = fopen ( argv[1], "rb" )) == NULL)
      { printf ("Source file '%s' not found.\n",argv[1]); exit (0); }
    fclose (tied);

    if ( ( (tied = fopen ( argv[2], "rb" )) != NULL) && (strcmp(argv[3],"-y")) )
      { fclose (tied);
        printf ("Overwrite '%s?'\n",argv[2]);
        if (toupper(getch()) != 'Y')
          { exit(0); }
      }

#ifdef picture
    set320();
#endif

    k1 = (char*) malloc (640*480);
    k2 = (char*) malloc (640*480);
    ruutu = (char*) malloc (640*480);

    size = UnpackLBM ( argv[1], k1);
    tied = fopen (argv[1], "rb");
    fseek (tied, 20, SEEK_SET);
    fread ( &a, 1,1, tied); fread ( &b, 1,1, tied);
    xsize = (int)(b) + ((int)(a) << 8);
    fread ( &a, 1,1, tied); fread ( &b, 1,1, tied);
    ysize = (int)(b) + ((int)(a) << 8);
    
//    dosmemput (k1, 64000, 0xA0000);
    i = spackmem(k1,k2,size);

    tied = fopen ( argv[2], "wb" );

    fwrite ( &gen_palette, 768, 1, tied );
    fwrite ( &i, 4, 1, tied);
    fwrite ( k2, i, 1, tied);

    fclose (tied);

#ifdef picture
    memset (ruutu,0,64000);
    if (ysize > 200) ysize = 200;
    for (i = 0; i < ysize; i++)
      {  if (xsize > 320) c = 320; else c = xsize;
         memmove ( ((char*)(ruutu))+i*320, k1+i*xsize, c);
      }
    flip();
    setpale (64,64,64);
    getch();
    textmode (0x03);
#endif

}

