/* KEYS.C
 * Enhanced keyboard routines for mule
 *************
 * 29.08.2000 : Toni Rsnen
 *              modifications/documentation for open source
 *
 */

/*   KEYS.C/H - copyright (c) Toni Rsnen, 1998
 *   -------------------------------------------
 *   Enhanced keyboard routines - allows many keys to be
 *   pressed simuntaneously.
 *
 *   Files required: KEYS.C, KEYS.H
 *
 *   Revision history:
 *       20.06.98: Added headers
 *
 */


#include <go32.h>
#include <dpmi.h>
#include <pc.h>
#include "keys.h"

volatile char keybuffer[128], keyinstalled;
_go32_dpmi_seginfo info, keyoriginal;

void keyhandler(void)
{   register unsigned char tavu=inportb(0x60);

    if(tavu<128)
      keybuffer[tavu]=1;
    else
      keybuffer[tavu-128]=0;

    outportb(0x20, 0x20);
}

int initkeys()
{   int c;
    for(c=0; c<0x80; c++) keybuffer[c]=0; /* nollataan napit */
    if(!keyinstalled)
      { _go32_dpmi_get_protected_mode_interrupt_vector(0x0009, &keyoriginal);
        info.pm_offset=(unsigned long int)keyhandler;
        info.pm_selector=_my_cs();
        _go32_dpmi_allocate_iret_wrapper(&info);
        _go32_dpmi_set_protected_mode_interrupt_vector(0x0009, &info);
        keyinstalled=1;
        return 0;
      }
    else
        return 1;
}

int disablekeys()
{   if(keyinstalled)
      { _go32_dpmi_set_protected_mode_interrupt_vector(0x0009, &keyoriginal);
	keyinstalled=0;
	return 0;
      }
    else
        return 1;
}


