
#ifndef __GUS_H
#define __GUS_H

typedef 	void 	(*PFV)();
typedef 	int 	(*PFI)();

#define MIDI_CONTROL           0x100
#define MIDI_DATA_REG          0x101
#define VOICE_REG              0x102
#define DATA_LO_REG            0x104
#define DATA_HI_REG            0x105
#define IRQ_STATUS_REG         0x006
#define TIMER_CONTROL_REG      0x008
#define TIMER_DATA_REG         0x009
#define DRAM_IO_REG            0x107
#define MIX_CTRL_REG           0x000
#define IRQ_CTRL_REG           0x00b
#define SPC_SELECT_REG         0x103
#define SPC_DATA_REG           0x107
#define SPC_DMA_CTRL            0x41
#define SPC_DMA_START_ADX       0x42
#define SPC_DRAM_IO_ADX_LO      0x43
#define SPC_DRAM_IO_ADX_HI      0x44
#define SPC_TIMER_CTRL          0x45
#define SPC_TIMER_1_COUNT       0x46
#define SPC_TIMER_2_COUNT       0x47
#define SPC_SAMPLE_FREQ         0x48
#define SPC_SAMPLE_CTRL         0x49
#define SPC_JOYSTIC_TRIM        0x4B
#define SPC_RESET               0x4C

  // voicecontrols: write=given value, read=given+80h
#define VCE_CTRL                0x00
#define VCE_FREQ_CONTROL        0x01
#define VCE_START_ADX_HI        0x02
#define VCE_START_ADX_LO        0x03
#define VCE_END_ADX_HI          0x04
#define VCE_END_ADX_LO          0x05
#define VCE_VOL_RAMP_RATE       0x06
#define VCE_VOL_RAMP_START      0x07
#define VCE_VOL_RAMP_END        0x08
#define VCE_VOLUME              0x09
#define VCE_CURR_ADX_HI         0x0A
#define VCE_CURR_ADX_LO         0x0B
#define VCE_BALANCE             0x0C
#define VCE_VOL_CTRL            0x0D
#define VCE_ACT_VOICES          0x0E
#define VCE_IRQ_STATUS          0x0F

void gus_stoptimer(char timer);
char gus_pokedata(int adx, char data);
void gus_setbalance (char voice, char data);
void gus_disable_linein();
void gus_enable_linein();
void gus_disable_micin();
void gus_enable_micin();
void gus_disable_output();
void gus_enable_output();
void gus_clearvoice (char v);
int gus_reset (char avoices, short ioadx, char irq, char midiirq, char dma1, char dma2);
void gus_close(void);
void gus_primevoice (char v, int beg, int loop, int end, char mode);
void gus_startvoice (char v, char m);
void gus_stopvoice (char v);
void gus_setfrequency (char v, int freq);
void gus_playvoice (char v, int beg, int loop, int end, char mode, int freq);
void gus_setvolume (char v, char vol);
void gus_set_address (char v, int adx);
void gus_set_address (char v, int adx);
void gus_starttimer (char timer, char time);
unsigned short gus_adx_low (int adx);
unsigned short gus_adx_high (int adx);

extern unsigned char IntFromVoice;
extern unsigned char gus_volume;
extern unsigned char gus_maxvoices;
extern unsigned char gus_mix;
extern unsigned char GUSchanvol[32];
extern unsigned short gus_divisor;
extern unsigned short gus_hidata,gus_lodata,gus_select;
extern unsigned short gus_baseadx;

extern PFV girq_dma,girq_miditx,girq_midirx,girq_timer1,
           girq_timer2,girq_wave,girq_envelope;

#endif
