; flip.asm,     v1.0,   copyright (c) Toni Rsnen, 1998
; flipping

; first  dw param; ebp+8
; second dw param; ebp+12 ... etc

         BITS      32
         GLOBAL    _VBE2flip
         GLOBAL    _flip_banked
         GLOBAL    _maptransf
         GLOBAL    _clear_linearscreen
         GLOBAL    _clearmem
         GLOBAL    _movemem
         EXTERN    _VBESelector
         EXTERN    _ruutu
         SECTION   .text

; ==========================================================================

; void flip_banked(int offs, int size)
; copies a block of data (size*4 bytes) from ruutu+offs
_flip_banked:
         push   ebp
         mov    ebp,esp

         pushad

         mov    ecx,[ebp+12]
         mov    ax,[_VBESelector]
         mov    esi,[ebp+8]
         mov    fs,ax
         xor    edi,edi
         add    esi,[_ruutu]


.loopfb
         mov    eax,[esi]
         mov    [fs:edi],eax
         add    esi,4
         add    edi,4

         dec    ecx
         jnz    .loopfb

         popad

         pop    ebp
         ret


; ==========================================================================
; void clearmem(void *area, int size)
; dups a memory region with size*8 zeros
_clearmem:
         push   ebp
         mov    ebp,esp

         pushad

         mov    edi,[ebp+8]
         mov    ecx,[ebp+12]

         xor    eax,eax
.cloopfb
         mov    [edi],eax
         mov    [edi+4],eax
         add    edi,8
         dec    ecx
         jnz    .cloopfb

         popad

         pop    ebp
         ret

; ==========================================================================

; void VBE2flip(int size)
; copy data from 'ruutu' to selector specified by VBESelector, size brought
; size in qwords (640x480x8bpp = 38400)
_VBE2flip:
         push   ebp
         mov    ebp,esp
         pushad
         mov    ecx, [ebp+8]
         mov    ax,[_VBESelector]
         mov    fs,ax
         xor    edi,edi
         mov    esi,[_ruutu]

.loopa   mov    eax,[esi]
         mov    [fs:edi],eax
         mov    eax,[esi+4]
         mov    [fs:edi+4],eax
         add    edi,8
         add    esi,8
         dec    ecx
         jnz    .loopa

         popad
         pop    ebp
         ret

; ==========================================================================

; void maptransf (char *src, char *trg)
; transfer screen map (500x480 out of 640x480) from src to trg
_maptransf:
         push   ebp
         mov    ebp,esp

         pushad

         mov    esi,[ebp+8]            ; char *source
         mov    edx,480

         mov    edi,[ebp+12]           ; char *target

.yloop   mov    ecx,125                ; 500 pix

.xloop   mov    eax,[esi]
         mov    [edi],eax
         add    esi,4
         add    edi,4
         dec    ecx
         jnz    .xloop

         add    edi,140
         add    esi,140

         dec    edx
         jnz    .yloop

         popad

         pop    ebp
         ret

; ==========================================================================

; void clearscreen(void)
; clears the graphics memory (screen)
_clear_linearscreen:
         push   ebp
         mov    ebp,esp
         pushad
         mov    ecx, 38400
         mov    ax,[_VBESelector]
         mov    fs,ax
         xor    edi,edi
         xor    eax,eax


.loopa   mov    [fs:edi],eax
         mov    [fs:edi+4],eax
         add    edi,8
         dec    ecx
         jnz    .loopa

         popad
         pop    ebp
         ret

; ==========================================================================

; void movemem (char *src, char *trg, int count)
; count=amount / 4
_movemem:
         push   ebp
         mov    ebp,esp
         pushad

         mov    esi,[ebp+8]            ; char *source
         mov    edx,480

         mov    edi,[ebp+12]           ; char *target

         mov    ecx, [ebp+16]

.cloop
         mov    eax,[esi]
         mov    [edi],eax
         add    esi,4
         add    edi,4
         dec    ecx
         jnz    .cloop

         popad
         pop    ebp
         ret

; ==========================================================================
