CODE    SEGMENT
        JMP MAIN

Black      EQU 0
Blue       EQU 1
Green      EQU 2
Cyan       EQU 3
Red        EQU 4
Magenta    EQU 5
Brown      EQU 6
Gold       EQU 6
White      EQU 7
Gray       EQU 8
Grey       EQU 8
Lt_Blue    EQU 9
Lt_Green   EQU 10
Lt_Cyan    EQU 11
Orange     EQU 12
Lt_Magenta EQU 13
Yellow     EQU 14
Br_White   EQU 15
Lt_White   EQU 15

CDB     MACRO
#CX1
##IF '#X' NE '%'
        DW CURRENTCOLOR BY '#X'
##ELSE
        DW CURRENTCOLOR BY 39  ; apostrophe
##ENDIF
#EM

SETCOLOR MACRO
        CURRENTCOLOR = (#2 SHL 4) OR #1
        CDB #3
#EM

NORM    MACRO
        SETCOLOR Gray,Br_White,#1
#EM
BOLD    MACRO
        SETCOLOR Black,Br_White,#1
#EM

MAN_TEXT:
SETCOLOR Br_White,Black
CDB  '                                                                '
CDB  '                           ADVENTURE                            '
CDB  '                                                                '
SETCOLOR Yellow,Black
CDB  '                                     ֿ                        '
CDB  '                         GAME PROGRAM                           '
CDB  '                         INSTRUCTIONS                           '
SETCOLOR Br_White,Black
CDB  '                                                                '
CDB  '                                                                '
CDB  '                                                                '
CDB  '                                                                '
CDB  '                                                                '
CDB  '                                                                '
CDB  '                                                                '
CDB  '                        Model CX-2613                           '
CDB  '                                                                '
CDB  '                                                             '
CDB  '                                                           '
CDB  '                                                           '
CDB  '                                                           '
CDB  '                                  (R)                           '
CDB  '                             ATARI                              '
CDB  '                A Warner Communications Company                 '
CDB  '                                                                '
CDB  ' (c) 1980 ATARI, INC.                                           '
CDB  '                                                                '
MAN_FIRSTPAGE:
NORM '                                                                '
CDB  'Use your Joystick Controller with this       '
                        SETCOLOR Br_White,Lt_Blue,'                   '
NORM 'ATARI(R) Game Program(tm).  Be sure the      '
                        SETCOLOR Br_White,Lt_Blue,'                '
NORM 'Controller is firmly plugged into the        '
                        SETCOLOR Br_White,Lt_Blue,'                '
NORM 'LEFT CONTROLLER jack at the rear of          '
                        SETCOLOR Br_White,Lt_Blue,'                '
NORM 'your ATARI Video Computer System(tm).        '
                        SETCOLOR Br_White,Lt_Blue,'   _ '
                                 SETCOLOR Black,Br_White,'ɳ '
                                    SETCOLOR Br_White,Lt_Blue,'     '
NORM 'Hold the Controller with the red button      '
                        SETCOLOR Br_White,Lt_Blue,'   '
                             SETCOLOR Black,Br_White,'__  ͼ  __'
                                        SETCOLOR Br_White,Lt_Blue,'   '
NORM 'to your upper left toward the television     '
                        SETCOLOR Br_White,Lt_Blue,'   '
                               SETCOLOR Black,Br_White,'__ __'
                                      SETCOLOR Br_White,Lt_Blue,'   '
NORM 'screen.  See Section 3 of your Owner%s       '
                        SETCOLOR Br_White,Lt_Blue,'       '
                                   SETCOLOR Black,Br_White,''
                                  SETCOLOR Br_White,Lt_Blue,'       '
NORM 'Manual for further details.                  '
                           SETCOLOR White,Lt_Blue,'                   '
NORM '                                                                '
BOLD 'Note:'
NORM      '  Always turn the console power switch OFF when in-        '
CDB  'serting or removing an ATARI Game Program.  This will pro-      '
CDB  'tect the electronic components and prolong the life of your     '
CDB  'ATARI Video Computer System.                                    '
CDB  '                                                                '
BOLD 'Note:'
NORM      '  For more enjoyment of the ADVENTURE Game Pro-            '
CDB  'gram, please read all instructions carefully before begin-      '
CDB  'ning play.  Keep this instruction booklet handy for quick       '
CDB  'reference.                                                      '
CDB  '                                                                '
SETCOLOR Black,Lt_Green
CDB  '  HOW TO PLAY                                                   '
NORM
CDB  '                                                                '
SETCOLOR Yellow,Cyan,'                    '
NORM                     '  An evil magician has stolen the En-       '
SETCOLOR Yellow,Cyan,'                  '
NORM                     '  chanted Chalice and has hidden it         '
SETCOLOR Yellow,Cyan,'            '
NORM                     '  somewhere in the Kingdom.  The ob-        '
SETCOLOR Yellow,Cyan,'              '
NORM                     '  ject of the game is to rescue the En-     '
SETCOLOR Yellow,Cyan,'                  '
NORM                     '  chanted Chalice and place it inside       '
SETCOLOR Yellow,Cyan,'              '
NORM                     '  the Golden Castle where it belongs.       '
SETCOLOR Cyan,Br_White,''
NORM                     '                                            '
CDB  'This is no easy task, as the Evil Magi-     '
                        SETCOLOR Orange,Br_White,'                  '
NORM 'cian has created three Dragons to           '
                        SETCOLOR Orange,Br_White,'              '
NORM 'hinder you in your quest for the            '
                        SETCOLOR Orange,Br_White,'                '
NORM 'Golden Chalice.  There is Yorgle, the       '
                        SETCOLOR Orange,Br_White,'               '
NORM 'Yellow Dragon, who is just plain            '
                        SETCOLOR Orange,Br_White,'               '
NORM 'mean;  there is Grundle, the Green          '
                        SETCOLOR Orange,Br_White,'              '
NORM 'Dragon, who is mean and ferocious;          '
                        SETCOLOR Orange,Br_White,'             '
NORM 'and there is Rhindle, the Orange Dragon,    '
                        SETCOLOR Orange,Br_White,'             '
NORM 'who is the most ferocious of all.  Rhin-    '
                        SETCOLOR Orange,Br_White,'               '
NORM 'dle is also the fastest Dragon and is       '
                        SETCOLOR Orange,Br_White,'               '
NORM 'the most difficult to outmaneuver.          '
                        SETCOLOR Orange,Br_White,'                 '
NORM '                                                                '
CDB  'There are three castles in the Kindgom:  the White Castle,      '
CDB  'the Black Castle, and the Golden Castle.  Each castle has a     '
CDB  'Gate over the entrance.  The Gate can be opened with the        '
CDB  'corresponding colored key.  Inside each castle are rooms        '
CDB  '(or dungeons, depending at which Skill Level you are play-      '
CDB  'ing).                                                           '
CDB  '                                                                '
CDB  'The Castles are separated by rooms, pathways and laby-          '
CDB  'rinths.  Common to all the Skill Levels is the Blue Labyrinth   '
CDB  'through which you must find your way to the Black Castle.       '
CDB  'Skill Levels 2 and 3 have a more complicated Kingdom (see       '
CDB  'SKILL LEVELS section).                                          '
CDB  '                                                                '
SETCOLOR Black,Lt_Blue
CDB  '  USING THE CONTROLLER                                          '
NORM '                                                                '
CDB  'You can move in any of                      MOVE UP             '
CDB  'eight directions with the          MOVE    '
DW ((Br_White SHL 4) OR Orange) BY 24
CDB                                              '                    '
CDB  'joystick in that direction         LEFT  '
                        SETCOLOR Orange,Br_White,'\  /'
                                              NORM '    MOVE          '
CDB  '(see diagram).  Each area              '
SETCOLOR Orange,Br_White
DW CURRENTCOLOR BY 27
CDB                                          '-- '
DW CURRENTCOLOR BY 9
CDB                                              ' --'
DW CURRENTCOLOR BY 26
NORM                                                 '  RIGHT         '
CDB  'shown on your television                 '
                        SETCOLOR Orange,Br_White,'/  \                  '
NORM 'screen will have one of                    '
DW ((Br_White SHL 4) OR Orange) BY 25
CDB                                              ' MOVE DOWN          '
CDB  'more barriers or walls,                                         '
CDB  'through which you CANNOT pass.  There are one or more           '
CDB  'openings.  To move from one area to an adjacent area, move      '
CDB  '"off" the television screen through one of the openings, the    '
CDB  'adjacent area will be shown on your television screen.          '
CDB  '                                                                '
CDB  '        '
DW 020,09DC,09DC,09DC,09DC,03DC,09DC,03DC,09DC,03DC,09DC
DW 09DC,03DC,09DC,03DC,09DC,03DC,09DC,09DC,09DC,09DC,020
CDB  '    '
DW 020,8 DUP 0EDC,4 DUP 03DC,8 DUP 0EDC,020
CDB  '        '
CDB  '        '
DW 020,03DB,03DB,03DB,09DB,03DB,09DB,03DB,09DB,03DB,03DB
DW 03DB,03DB,09DB,03DB,09DB,03DB,09DB,03DB,03DB,03DB,020
CDB  '    '
DW 020,0EDB,03DB,03DB,03DB,0EDB,0EDB,0EDB,0EDB,03DB,03DB
DW 03DB,03DB,0EDB,0EDB,0EDB,0EDB,03DB,03DB,03DB,0EDB,020
CDB  '        '
CDB  '        '
DW 020,09DB,09DB,03DB,09DB,03DB,09DB,03DB,09DB,09DB,09DB
DW 09DB,09DB,09DB,03DB,09DB,03DB,09DB,03DB,09DB,09DB,020
CDB  '    '
DW 020,0EDB,03DB,03DB,03DB,12 DUP 0EDB,03DB,03DB,03DB,0EDB,020
CDB  '        '
CDB  '        '
DW 020,03DB,03DB,03DB,09DB,03DB,09DB,03DB,03DB,03DB,03DB
DW 03DB,03DB,03DB,03DB,09DB,03DB,09DB,03DB,03DB,03DB,020
CDB  '    '
DW 020,0EDB,4 DUP 03DB,10 DUP 0EDB,4 DUP 03DB,0EDB,020
CDB  '        '
CDB  '        '
DW 020,09DB,09DB,09DB,09DB,03DB,09DB,09DB,09DB,09DB,09DB
DW 09DB,09DB,09DB,09DB,09DB,03DB,09DB,09DB,09DB,09DB,020
CDB  '    '
DW 020,0EDB,4 DUP 03DB,4 DUP 0EDB,03DB,03418,4 DUP 0EDB,4 DUP 03DB,0EDB,020
CDB  '        '
CDB  '        '
DW 020,5 DUP 03DB,03411,4 DUP 034C4
DW 034C2,034C4,034C4,034C4,03410,5 DUP 03DB,020
CDB  '    '
DW 020,0EDB,9 DUP 03DB,034B3,8 DUP 03DB,0EDB,020
CDB  '        '
CDB  '        '
DW 020,8 DUP 09DF,03DF,03DF,0419,03DF,8 DUP 09DF,020
CDB  '    '
DW 020,8 DUP 0EDF,03DF,03DF,0419,03DF,8 DUP 0EDF,020
CDB  '        '
CDB  '                                                                '
CDB  '        '
DW 020,8 DUP 02DC,4 DUP 03DC,8 DUP 02DC,020
CDB  '    '
DW 020,8 DUP 02DC,4 DUP 03DC,8 DUP 02DC,020
CDB  '        '
CDB  '        '
DW 020,03DB,03EB3,8 DUP 03DB,03418,9 DUP 03DB,020
CDB  '    '
DW 020,10 DUP 03DB,03418,9 DUP 03DB,020
CDB  '        '
CDB  '        '
DW 020,03DB,03EB3,8 DUP 03DB,034B3,9 DUP 03DB,020
CDB  '    '
DW 020,10 DUP 03DB,034B3,9 DUP 03DB,020
CDB  '        '
CDB  '        '
DW 020,03DB,03EB3,8 DUP 03DB,034C0,4 DUP 034C4,03410,4 DUP 03DB,020
CDB  '    '
DW 020,4 DUP 03DB,03411,5 DUP 034C4,034C1,4 DUP 034C4,03410,4 DUP 03DB,020
CDB  '        '
CDB  '        '
DW 020,03DB,03EB3,18 DUP 03DB,020
CDB  '    '
DW 020,20 DUP 03DB,020
CDB  '        '
CDB  '        '
DW 020,03DB,03EB3,18 DUP 03DB,020
CDB  '    '
DW 020,20 DUP 03DB,020
CDB  '        '
CDB  '        '
DW 020,20 DUP 02DF,020
CDB  '    '
DW 020,20 DUP 02DF,020
CDB  '        '
CDB  '                                                                '
CDB  'Scattered throughout the Kingdom are certain objects to         '
CDB  'help you in your search for the Enchanted Chalice.  To pick     '
CDB  'up an object, all that is necessary is to touch it.  You will   '
CDB  'hear a sound that will notify you that you have the object in   '
CDB  'in tow. To drop the object, press the red controller button. You'
CDB  'will hear a different sound that will tell you that the object  '
CDB  'has been released.                                              '
CDB  '                                                                '
CDB  'To open any castle, touch the Gate with that Castle%s cor-      '
CDB  'responding colored key.  The Gate will slide open and you       '
CDB  'can enter the Castle by moving upward through the Gate.  If     '
CDB  'you are leaving the Castle, it is advisable to push the Key     '
CDB  'out first or you may inadvertently close the Castle Gate        '
CDB  'behind you.                                                     '
CDB  '                                                                '
SETCOLOR Black,Yellow
CDB  '  CONSOLE CONTROLS                                              '
NORM '                                                                '
CDB  'Choose the Skill Level you wish to play by depressing the       '
BOLD 'game select'
NORM            ' switch.  To begin play depress the '
BOLD                                                'game reset       '
NORM 'switch.                                                         '
CDB  '                                                                '
CDB  'If you get "eaten" by one of the Dragons, do not despair!       '
CDB  'Just depress the '
BOLD                  'game reset'
NORM                            ' switch and you will be "rein-       '
CDB  'carnated" and placed back in front of the Golden Castle.        '
CDB  'Unfortunately, and Dragons you may have slain (see GOOD         '
CDB  'MAGIC) will also be reincarnated.  If you were carrying any     '
CDB  'object with you, it will remain where it was.                   '
CDB  '                                                                '
CDB  'If you have finished one game and wish to begin another         '
CDB  'depress either the '
BOLD                    'game reset'
NORM                              ' or the '
BOLD                                      'game select'
NORM                                                 ' switch.        '
CDB  'The number of the skill level at which you were playing will    '
CDB  'appear on the television screen.  Depress the '
BOLD                                               'game reset        '
NORM 'switch and begin play.                                          '
CDB  '                                                                '
SETCOLOR Black,Brown
CDB  '  DIFFICULTY SWITCHES                                           '
NORM '                                                                '
CDB  'By using the '
BOLD              'difficulty'
NORM                        ' switches you can increase or            '
CDB  'decrease the difficulty of the game at each Skill Level.        '
CDB  '                                                                '
CDB  'When the '
BOLD          'left difficulty'
NORM                         ' switch is in the '
BOLD                                           'b'
NORM                                            ' position, the       '
CDB  'Dragons will hesitate before they bite you.  Therefore, when    '
CDB  'the '
BOLD     'left difficulty'
NORM                    ' switch is in the '
BOLD                                      'a'
NORM                                       ' position, it is more dif-'
CDB  'ficult to escape them.                                          '
CDB  '                                                                '
SETCOLOR Black,Orange
CDB  '  GOOD MAGIC                                                    '
NORM '                                                                '
CDB  'While the Evil Magician has created many hazards to slow        '
CDB  'you in your quest to rescue the Enchanted Chalice, there is     '
CDB  'some Good Magic on your side:                                   '
CDB  '                                          '
                    SETCOLOR Lt_Green,Br_White,'                    '
NORM
DW CURRENTCOLOR BY 7
CDB   '  You have a Sword that you can          '
                    SETCOLOR Lt_Green,Br_White,'                    '
NORM '   use to slay the Dragons.  To do        '
                    SETCOLOR Lt_Green,Br_White,'                 '
NORM '   this, you must touch him with it.      '
                    SETCOLOR Lt_Green,Br_White,'              '
NORM '                                          '
                    SETCOLOR Lt_Green,Br_White,'     '
                                 SETCOLOR White,Br_White,'         '
NORM
DW CURRENTCOLOR BY 7
CDB   '  If the '
BOLD           'right difficulty'
NORM                           ' switch is in   '
                    SETCOLOR Lt_Green,Br_White,'    '
                                 SETCOLOR White,Br_White,'         '
NORM '   the '
BOLD        'a'
NORM         ' position all Dragons will        '
                    SETCOLOR Lt_Green,Br_White,'                 '
NORM '   run from the Sword.                    '
                    SETCOLOR Lt_Green,Br_White,'      '
                                SETCOLOR Yellow,Br_White,'          '
NORM '                                          '
                    SETCOLOR Lt_Green,Br_White,'    '
                               SETCOLOR Yellow,Br_White,'     '
NORM '                                                     '
                                 SETCOLOR Yellow,Br_White,'          '
NORM
DW CURRENTCOLOR BY 7
CDB   '  There is a Bridge that can be used to pass over the          '
CDB  '   walls of any portion of the Kingdom.  The Bridge CAN-        '
CDB  '   NOT be used to pass through any barrier into the next        '
CDB  '   portion, nor can it be used to move from right to left or    '
CDB  '   left to right over a barrier or wall.  It also CANNOT be     '
CDB  '   used to get past a locked Castle Gate.                       '
CDB  '                                                                '
CDB  '   Pick up the Bridge the same as you would any other ob-       '
CDB  '   ject.  Place the Bridge across the wall that you wish to     '
CDB  '   pass over and release it by pushing the red controller       '
CDB  '   button.  The ends of the Bridge must be visible on both      '
CDB  '   sides of the wall for it to work.  After releasing the       '
CDB  '   Bridge you can then pass through it to the other side of     '
CDB  '   the wall or barrier.                                         '
CDB  '                                                                '
CDB  '   If you should happen to touch the inside of the Bridge       '
CDB  '   while you are passing over the barrier, the Bridge will      '
CDB  '   close and you may become trapped in the wall.                '
CDB  '                                                                '
CDB  '   To release yourself, press the       '
                         SETCOLOR Black,Cyan,'                        '
NORM '   red controller button.  If, for      '
                         SETCOLOR Black,Cyan,'     '
                          SETCOLOR Black,Magenta,'    '
                                 SETCOLOR Black,Cyan,'        '
                                      SETCOLOR Black,Magenta,'    '
                                             SETCOLOR Black,Cyan,'   '
NORM '   some reason, your magic should       '
                         SETCOLOR Black,Cyan,'       '
                            SETCOLOR Black,Magenta,'  '
                                 SETCOLOR Black,Cyan,'        '
                                      SETCOLOR Black,Magenta,'  '
                                           SETCOLOR Black,Cyan,'     '
NORM '   fail and you still cannot release    '
                         SETCOLOR Black,Cyan,'       '
                            SETCOLOR Black,Magenta,'  '
                                 SETCOLOR Black,Cyan,'        '
                                      SETCOLOR Black,Magenta,'  '
                                           SETCOLOR Black,Cyan,'     '
NORM '   yourself, press '
BOLD                    'game reset'
NORM                              ' and       '
                         SETCOLOR Black,Cyan,'       '
                            SETCOLOR Black,Magenta,'  '
                                 SETCOLOR Black,Cyan,'        '
                                      SETCOLOR Black,Magenta,'  '
                                           SETCOLOR Black,Cyan,'     '
NORM '   "reincarnate".  Use reincarnation    '
                         SETCOLOR Black,Cyan,'       '
                            SETCOLOR Black,Magenta,'  '
                                 SETCOLOR Black,Cyan,'        '
                                      SETCOLOR Black,Magenta,'  '
                                           SETCOLOR Black,Cyan,'     '
NORM '   as a last resort, especially if you  '
                         SETCOLOR Black,Cyan,'     '
                          SETCOLOR Black,Magenta,'    '
                                 SETCOLOR Black,Cyan,'        '
                                      SETCOLOR Black,Magenta,'    '
                                             SETCOLOR Black,Cyan,'   '
NORM '   have slain one or more Dragons.      '
                         SETCOLOR Black,Cyan,'                        '
NORM '                                        '
                         SETCOLOR Black,Cyan,'                        '
NORM
DW CURRENTCOLOR BY 7
CDB   '  In all games, Yorgle, the Yellow Dragon, is afraid of the    '
CDB  '   Gold Key and will run from it.  He will also stay away       '
CDB  '   from whatever room or area of the Kingdom in which it        '
CDB  '   may be.                                                      '
CDB  '                                                                '
DW CURRENTCOLOR BY 7
CDB   '  To remove objects that are stuck in a wall and out of        '
CDB  '   reach, there is a Magnet that affects all inanimate ob-      '
CDB  '   jects, including the Bridge.  The Magnet can also be         '
CDB  '   used to move objects in an adja-        '
                        SETCOLOR Black,Br_White,'               '
NORM '   cent part of the kingdom by put-        '
                        SETCOLOR Black,Br_White,'               '
NORM '   ting it in front of you before          '
                        SETCOLOR Black,Br_White,'                 '
NORM '   entering that part of the               '
                        SETCOLOR Black,Br_White,'                 '
NORM '   Kingdom.                                '
                       SETCOLOR Yellow,Br_White,'                  '
CDB  '                                           '
                       SETCOLOR Yellow,Br_White,'             '
NORM '                                                                '
SETCOLOR Black,Lt_Green
CDB  '  BAD MAGIC                                                     '
NORM '                                                                '
CDB  'The Evil Magician has cast a spell to make it difficult for     '
CDB  'you to succeed in rescuing the Enchanted Chalice.  Not only     '
CDB  'do the Dragons rally around and try to stop you from get-       '
CDB  'ting the Enchanted Chalice, they guard other objects in the     '
CDB  'Kingdom:                                                        '
CDB  '                                                                '
DW CURRENTCOLOR BY 7
CDB   '  Grundle, the Green Dragon, guards the Magnet, the            '
CDB  '   Bridge, and the Black Key.                                   '
CDB  '                                                                '
DW CURRENTCOLOR BY 7
CDB   '  Rhindle, the Red Dragon, guards the White Key.               '
CDB  '                                                                '
DW CURRENTCOLOR BY 7
CDB   '  When not guarding the Enchanted Chalice, Yorgle, the         '
CDB  '   Yellow Dragon, roams freely about the Kingdom.               '
CDB  '   Sometimes he will assist Grundle or Rhindle in guarding      '
CDB  '   whatever it may be that they are guarding.                   '
CDB  '                                                                '
CDB  'There is other Bad Magic that you must overcome in order        '
CDB  'to rescue the Enchanted Chalice:                                '
CDB  '                                                                '
DW CURRENTCOLOR BY 7
CDB   '  You cannot pick up and carry a slain dragon.                 '
CDB  '                                                                '
DW CURRENTCOLOR BY 7
CDB   '  In Skill Levels 2 and 3 (see SKILL LEVEL descriptions),      '
CDB  '   besides the Dragons, the Evil Magician has created a         '
CDB  '   Black Bat that carries objects around throughout the         '
CDB  '   Kingdom and trades them for an object that you may be        '
CDB  '   carrying.  The Black Bat may trade a live Dragon for the     '
CDB  '   Sword and leave you defenseless, or it may trade you         '
CDB  '   something for the Enchanted Chalice just as you are          '
CDB  '   ready to put it into the Golden Castle.                      '
CDB  '                                                                '
SETCOLOR Black,Lt_Blue
CDB  '  GOOD OR BAD MAGIC                                             '
NORM '                                                                '
CDB  'Some Magic can be good or bad,           '
                         SETCOLOR Yellow,Cyan,'                       '
NORM 'depending on the situation:              '
                         SETCOLOR Yellow,Cyan,'                       '
NORM '                                         '
                         SETCOLOR Yellow,Cyan,'                       '
NORM
DW CURRENTCOLOR BY 7
CDB   '  You can catch the Black Bat and       '
                         SETCOLOR Yellow,Cyan,'                     '
NORM '   carry it and whatever the Black       '
                         SETCOLOR Yellow,Cyan,'               '
NORM '   Bat may be carrying.  However,        '
                         SETCOLOR Yellow,Cyan,'                 '
NORM '   sometimes the Black Bat will          '
                         SETCOLOR Yellow,Cyan,'                     '
NORM '   escape (usually at the most in-       '
                         SETCOLOR Yellow,Cyan,'                 '
NORM '   opportune times).                     '
                          SETCOLOR Black,Cyan,'                     '
NORM '                                         '
                          SETCOLOR Black,Cyan,'                     '
NORM
DW CURRENTCOLOR BY 7
CDB   '  If there are four or more objects     '
                          SETCOLOR Black,Cyan,'                 '
NORM '   (including the Castle Gates) in       '
                          SETCOLOR Black,Cyan,'                 '
NORM '   your area of the Kingdom, your        '
                          SETCOLOR Black,Cyan,'                     '
NORM '   magic may or may not work.            '
                          SETCOLOR Black,Cyan,'                     '
NORM '   Sometimes you can slay a              '
                          SETCOLOR Green,Cyan,'                    '
NORM '   a Dragon, sometimes you can%t.        '
                          SETCOLOR Green,Cyan,'                    '
NORM '   However, it is easier to avoid        '
                         SETCOLOR Yellow,Cyan,'                       '
NORM '   being swallowed by a Dragon.          '
                         SETCOLOR Yellow,Cyan,'                       '
NORM '                                                                '
CDB  'If you have slain a Dragon, and he is blocking your path so     '
CDB  'you cannot get through, you can use this to your advantage      '
CDB  'by placing one or two objects in the same area and then         '
CDB  'move through the slain Dragon.                                  '
CDB  '                                                                '
CDB  'Sometimes the Black Bat can be used to your advantage by        '
CDB  'getting it to swap for an object you need that may be stuck     '
CDB  'in a wall.                                                      '
CDB  '                                                                '
SETCOLOR Black,Yellow
CDB  '  SKILL LEVELS                                                  '
BOLD '                                                                '
CDB  'Level 1                                                         '
NORM '                                                                '
CDB  'This is the simplest Skill Level.  When you depress the         '
CDB  'game reset switch to begin play, you will see the Key to        '
CDB  'the Golden Castle.  Unlock the Castle and enter.  You will      '
CDB  'find the Sword inside the Golden Castle.  The Key to the        '
CDB  'Black Castle is being guarded by Grundle, the Green             '
CDB  'Dragon.  Yorgle, the Yellow Dragon is roaming free and may      '
CDB  'or may not be found guarding the Enchanted Chalice,             '
CDB  'which is hidden with the Magnet inside the Black Castle.        '
BOLD '                                                                '
CDB  '                                                                '
CDB  'Level 2                                                         '
NORM '                                                                '
CDB  'This Kingdom is much larger than Level 1.  There are            '
CDB  'Catacombs (in which you can see only part way).  The Key to     '
CDB  'the Golden Castle is hidden here.  You must pass through        '
CDB  'the Catacombs to reach the White Castle.  The Key to the        '
CDB  'White Castle is hidden in the Blue Labyrinth.  Inside the       '
CDB  'White Castle is the Red Dungeon.  There is a Secret Room        '
CDB  'in the Red Dungeon where the Key to the Black Castle is         '
CDB  'hidden.  To get to the Secret Room you must use the Bridge.     '
CDB  'To get to the Black Castle you must pass through the Blue       '
CDB  'Labyrinth.  Behind the first room of the Black Castle is the    '
CDB  'Grey Dungeon, which is similar to the Catacombs.  The En-       '
CDB  'chanted Chalice is hidden here, guarded by Rhindle, the         '
CDB  'Red Dragon.                                                     '
CDB  '                                                                '
CDB  'All objects, the Dragons, and the Black Bat will start in the   '
CDB  'same place in the Kingdom each time you play the game at        '
CDB  'Level 2.                                                        '
CDB  '                                                                '
BOLD '                                                                '
CDB  '                                                                '
CDB  'Level 3                                                         '
NORM '                                                                '
CDB  'The Kingdom is the same as Level 2, but is more difficult to    '
CDB  'play as the Evil Magician has placed all the objects and the    '
CDB  'dragons randomly within the Kingdom.  You will never know       '
CDB  'for sure what is in the next area of the Kingdom until you      '
CDB  'enter it, nor will you know for sure where the Enchanted        '
CDB  'Chalice may be hidden.  The Dragons could be inside any of      '
CDB  'the Castles.                                                    '
CDB  '                                                                '
CDB  '                                                                '
CDB  '                                                                '
CDB  '                                                                '
CDB  '                                                                '
CDB  '                                                                '
CDB  '                                                                '
CDB  '                                                                '
CDB  '                                                                '
CDB  '                                                                '
CDB  '                                                                '
CDB  'C011402-13 Rev. 2                                               '
CDB  '                                                                '
END_MAN_TEXT:
SETCOLOR Magenta,Black
CDB  'Online Adventure manual programmed by Craig Pell       June 1994'
SETCOLOR Blue,Black
CDB  'Atari, the Atari symbol, Game Program, and Atari Video Computer '
CDB  'System are trademarks of Atari Corp.                            '
END_MY_TEXT:

CURRENT_POS DW MAN_TEXT
LINELENGTH EQU 64
MAIN:
        MOV AX,3
        INT 010
        MOV AL,9                ;  16-color char backgrounds (CGA)
        MOV DX,03D8             ;
        OUT DX,AL               ;
        MOV AX,01003            ;  16-color char backgrounds (EGA/VGA)
        MOV BL,0                ;
        INT 010                 ;
        MOV AH,2
        MOV BH,0
        MOV DX,01900
        INT 010          ;move cursor to upper left
        MOV ES,AX,0B800
        MOV DL,0DB
DRAWSCREEN:
        MOV SI,CURRENT_POS
        MOV DI,010
        MOV CX,25
     L1:
        PUSH CX
        MOV CX,LINELENGTH
        MOV DH,0F
        CMP SI,END_MY_TEXT
        JAE >L2
        PUSH SI
        REP MOVSW
        POP AX
        CMP AX,MAN_FIRSTPAGE
        JB >L3
        CMP AX,END_MAN_TEXT
        JAE >L3
        JMP >L4
     L2:
        MOV AX,0720
        REP STOSW      ; blank line
     L3:
        MOV DH,0
     L4:
        MOV [ES:DI],DX
        MOV [ES:DI+2],DX
        MOV [ES:DI-LINELENGTH*2-2],DX
        MOV [ES:DI-LINELENGTH*2-4],DX
        POP CX
        ADD DI,160-LINELENGTH*2
        LOOP L1
;
        MOV AH,0
        INT 016
        CMP AH,1  ; ESC?
        JNE >K1
        MOV AX,3
        INT 010
        MOV AX,04C00
        INT 021   ; done
     K1:
        CMP AH,'H'  ; up arrow?
        JNE >K2
        SUB CURRENT_POS,LINELENGTH*2
        CMP CURRENT_POS,MAN_TEXT
        JNB >L5
     L4:
        MOV CURRENT_POS,MAN_TEXT
     L5:
        JMP DRAWSCREEN
     K2:
        CMP AH,'P'  ; down arrow?
        JNE >K3
        CMP CURRENT_POS,END_MAN_TEXT - LINELENGTH*2
        JAE L5
        ADD CURRENT_POS,LINELENGTH*2
     K3:
        CMP AH,'I'   ; PgUp?
        JNE >K4
        CMP CURRENT_POS,MAN_TEXT+LINELENGTH*2*24
        JB L4
        SUB CURRENT_POS,LINELENGTH*2*24
        JMP DRAWSCREEN
     K4:
        CMP AH,'Q'   ; PgDn?
        JNE L5
        ADD CURRENT_POS,LINELENGTH*2*24
        CMP CURRENT_POS,END_MAN_TEXT - LINELENGTH*2
        JB L5
        MOV CURRENT_POS,END_MAN_TEXT - LINELENGTH*2
        JMP DRAWSCREEN
