GAME_TEXT_COUNT EQU 60
SOUND:
        CMP SOUND_PTR,0
        JE SOUND_OFF
        CMP SOUND_START,0
        JNE >L1
        CMP SOUND_PTR,SOUND_smooth
        JAE >S0
     L1:
        MOV AL,0B6
        OUT 043,AL
     S0:MOV BX,SOUND_PTR
        MOV AX,[BX]
        CMP AX,SILENCE
        JE >S2
        OUT 042,AL
        MOV AL,AH
        OUT 042,AL
        CMP SOUND_START,0
        JE >S1
        MOV SOUND_START,0
        CMP SOUND?,0
        JE >S1
        IN AL,061
        OR AL,3
        OUT 061,AL
     S1:
        ADD SOUND_PTR,2
        CMP W[BX+2],0
        JNE RET
        MOV SOUND_PTR,0
        MOV SOUND_START,0
        RET
     S2:CALL SOUND_OFF
        MOV SOUND_START,-1
        JMP S1
SOUND_OFF:
        IN AL,061
        AND AL,0FC
        OUT 061,AL
        RET
BB_LOC  EQU TEMP ;DW 0
BETWEEN_BRIDGE?:      ; Z flag set = yes
        PUSH AX
        MOV AX,PL_AD
     B0:
        MOV BB_LOC,AX
        PUSH CX
        MOV AX,ROOM
        CMP AX,[OBJECT+OSZ*7]
        JNE BB_NO
        CMP CARRYING,OBJECT+OSZ*7
        JE BB_NO
        MOV AX,[OBJECT+OSZ*7+2]
        CMP BB_LOC,AX
        JB BB_NO
        MOV CX,AX
        ADD CX,160*5+30
        CMP BB_LOC,CX
        JA BB_NO
        DIV v_160
        MOV CH,AH
        ADD CH,8
        MOV AX,BB_LOC
        DIV v_160
        SUB AH,CH
        JB BB_NO
        CMP AH,16
        JAE BB_NO
        MOV AL,1   ;yes, on the bridge
        JMP >B1
  BB_NO:
        MOV AL,0
     B1:
        DEC AL
        POP CX,AX
        RET
BETWEEN_BR_LG:
        PUSH AX
        MOV AX,LASTGOOD_AD
        JMP B0
RANDNUM:               ;into AX
        MOV AX,RNDCNT
        XCHG AL,AH
        INC AX
        MOV RNDCNT,AX
;        PUSH ES
;        MOV ES,AX,040
;        MOV AX,[ES:06C]     ;sec & sec/60
;        POP ES
        MOV AL,0
        OUT 043,AL  ; freeze timer temporarily
        JMP >R1
     R1:
        IN AL,040   ; low byte of timer
        MOV AH,AL
        JMP >R2
     R2:
        IN AL,040   ; high byte of timer
        XOR AX,LCNT
        SUB AX,RNDCNT
        PUSH BP
        MOV BP,SP
        XOR AX,[BP-9]
        POP BP
        XOR RNDCNT,AX
        RET
GETTIME:  ;  returns AX = multiple of 215 microseconds
        PUSH CX,DX
        MOV AH,0
        INT 01A    ; get tick count
        MOV AH,DL   ; lowest bite of tick
        POP DX,CX
        MOV AL,0
        OUT 043,AL  ; freeze timer temporarily
        JMP >G1     ; delay
     G1:
        IN AL,040   ; low byte of timer (unused, here)
        JMP >G2     ; delay
     G2:
        IN AL,040   ; high byte of timer
        NEG AL      ; now timer seems to increase, not decrease
        RET
LOOPWAIT:
;CYCLETIME  EQU (256*215)
;CYCLETIMEW EQU (384*215)
CYCLETIMEH  EQU 0
CYCLETIMEL  EQU 0D700
CYCLETIMEWH EQU 1
CYCLETIMEWL EQU 04280
        CMP ROMDELAYPRESENT?,0
        JE >W1
     W0:
        TEST ROMDELAY,080
        JZ W0
        PUSH CX,DX
        CALL SETROMTIMER
        POP DX,CX
        RET
     W1:
        MOV BX,CYCLETIMEL/215  ; in 215-microsecond ticks
        CMP JUSTWON?,0
        JE >L0
        CMP JUSTWON?,MAX_JUSTWON?
        JA >L0
        MOV BX,CYCLETIMEWL/215
     L0:
        CALL GETTIME
        SUB AX,LOOP_TIMER
        IF C INC AH    ; the low byte may be 00 when the high byte hasn't
                       ; yet been incremented
        CMP AX,BX
        JB L0
        RET
SETROMTIMER:
        MOV AX,08300
        LEA BX,ROMDELAY
        MOV [BX],AL
        MOV ES,DS
        MOV CX,CYCLETIMEH
        MOV DX,CYCLETIMEL
        CMP JUSTWON?,0
        JE >L0
        CMP JUSTWON?,MAX_JUSTWON?
        JA >L0
        MOV CX,CYCLETIMEWH
        MOV DX,CYCLETIMEWL
     L0:
        INT 015
        RET
OBJ_OFFBOTTOM:  ; entry: SI & DI (use AX,CX)
        SUB LOC,160*24
        MOV AX,[DI+6]
        XCHG [SI],AX
        MOV ES,CS
        MOV DI,CASTLE_1STRM
        MOV CX,5
        REPNE SCASW
        JNE RET
        SUB DI,CASTLE_1STRM+2
        SHR DI,1
        CMP GATE[DI],0
        JE >L1
        MOV AX,15*160
        XCHG AX,LOC
        DIV v_160
        MOV AL,AH
        MOV AH,0
        CMP AL,72
        IF B MOV AL,72
        CMP AL,88
        IF AE MOV AL,86
        ADD LOC,AX
        RET
     L1:
        SHL DI,1
        MOV AX,CASTLE_LOCKEDIN[DI]
        MOV [SI],AX
        RET
THIRDCYCLE?:   ; returns Z = yes (3rd cycle)
        PUSH AX,BX,DX
        MOV AX,LCNT
        MOV DX,0
        MOV BX,3
        DIV BX
        CMP DX,1
        POP DX,BX,AX
        RET
CHECKBLINK:   ; Z set = no blink (ie, show object)
;             ; NZ = erase object only; do not draw
        CMP BLINK_CTR,3
        JB >C2
        JE >C0
        CMP BLINK_CTR,4
        JNE >C1
        TEST LCNT,1     ; 4 objects in room
        RET
     C0:
;        TEST LCNT,3     ; 3 objects in room
        CALL THIRDCYCLE?
        JNZ >C2
        PUSH AX
        OR AL,1   ; force NZ
        POP AX
        RET
     C1:
        CMP BLINK_CTR,5
        JE THIRDCYCLE?
        CMP BLINK_CTR,6
        JE THIRDCYCLE?
        TEST LCNT,3
        RET
     C2:
        CMP AL,AL       ; 0, 1 or 2 objects in room
        RET
SIZEOFOBJ:  ;Entry: SI points to object, dragon or bat
;            Exit: [BX] = horizontal size, [BX+1] = vertical size
        PUSH AX
        MOV AX,SI
        CMP AX,DRAGON
        JAE >L1
        SUB AX,OBJECT
        MOV BL,OSZ
        DIV BL
        CBW
        SHL AX,1
        ADD AX,OBJSIZE_TABLE
        MOV BX,AX
        POP AX
        RET
     L1:
        CMP AX,BAT
        JE >L4
        MOV BX,DR_DIM
        CMP DR_STATUS,BITING
        JGE >L2
        CMP VGA,0
        JE >L3
        TEST LOC,08000
        JZ >L3
     L2:ADD BX,2
     L3:POP AX
        RET
     L4:
        MOV BX,BAT_DIM
        POP AX
        RET
GETMAPADDR:    ;Entry: BX=Room #     Exit:  [BX] to [BX+6] is Map
        CMP BX,-1
        JE >L2
        SHL BX,1
        SHL BX,1
        SHL BX,1
        CMP GAMENO,1
        JE >L1
     L0:ADD BX,MAP
        RET
     L1:
        CMP BX,(23 SHL 3)
        JA L0
        ADD BX,MAP_GAME1
        RET
     L2:
        MOV BX,MAP_TITLE
        RET
GETROOMBELOW:
;   expects:  AX=current room, BX points to location in MAP
;   returns:  AX=room, Z=0 if not leaving castle, else Z=1
        PUSH ES
        MOV ES,CS
        MOV DI,CASTLE_1STRM
        MOV CX,5
        REPNE SCASW
        POP ES
        JNE >G1   ; return with NZ
        SUB DI,CASTLE_1STRM+2
        SHR DI,1
        CMP GATE[DI],0    ; gate open?
        JNE >G2           ; yes
        SHL DI,1                     ; no
        CMP GAMENO,1
        IF E ADD DI,5*2
        MOV AX,CASTLE_LOCKEDIN[DI]
        PUSH AX
        OR AL,1   ; force NZ
        POP AX
        RET
     G1:
        MOV AX,[BX+6]
        RET
     G2:
        CMP AL,AL   ; leaving a castle -- return with Z
        JMP G1
SWCARBYBAT_ERASE:
        MOV ES,AX,VIDSEG_MAIN
        MOV DI,LASTGOOD_AD
        MOV AX,LASTGOOD_RM
        CMP AX,ROOM
        JNE RET
        MOV AH,CAT           ;
        CMP ROOMCOLOR,AH     ;  AH = background color
        IF E MOV AH,0C0      ;
        CMP SWCARBYBAT_BG,0       ; if in wall
        IF NZ MOV AH,ROOMCOLOR    ; then AH = wall color
        MOV AL,[ES:DI+1]
        AND AL,0F
        OR AL,AH
        MOV [ES:DI+1],AL
        CMP DI,160*24-2
        JAE >N1
        MOV AH,CAT
        CMP ROOMCOLOR,AH
        JNE >Z1
        MOV AH,0C0
        CMP COLOR?,0
        IF E MOV AH,BWOffWhite*16
     Z1:
        CMP SWCARBYBAT_BG[1],0
        IF NZ MOV AH,ROOMCOLOR
        MOV AL,[ES:DI+3]
        AND AL,0F
        OR AL,AH
        MOV [ES:DI+3],AL
     N1:
        RET
;
     X0:
        CMP AL,AL
        RET
OBJONOPENCASTLE?:   ;Entry: [BX] = horizontal size, [BX+1] = vertical size
;                           SI = object descriptor
;                    Exit: NZ = yes, Z = no
        MOV AX,ROOM
        CMP AX,RM
        JNE X0
        CMP CARRYING,SI
        JE RET
        CMP BAT_CARRYING,SI
        JE RET
        TEST LC_FLAG,020  ; castle?
        JZ RET
        MOV AL,COPEN_CNT
        OR AL,CCLOSE_CNT  ; if castle's opening/closing, ignore gate status
        JNZ >G1
        TEST LC_FLAG,010  ; castle closed?
        JZ RET
     G1:
        MOV AL,0
        CMP AL,COPEN_CNT
        JE >G2
        CMP COPEN_CNT,-1
        JE >G2
        MOV AL,COPEN_CNT
        INC AL
        SHR AL,1
        JMP >G3
     G2:
        OR AL,CCLOSE_CNT
        JZ >G3
        MOV AL,7
        SUB AL,CCLOSE_CNT
        SHR AL,1
     G3:
        ADD AL,14
        MOV AH,160
        MUL AH
        ADD AX,82
        CMP LOC,AX
        JA >O1
;
        MOV AX,LOC
;        CMP AX,(160*14)+82    ;too far down?
;        JA >O1
        DIV v_160
        PUSH AX
        ADD AL,[BX+1]
        CMP AL,15             ;too far up?
        POP AX
        JB >O1
        CMP AH,82             ;too far right?
        JA >O1
        PUSH AX
        ADD AH,[BX]
        ADD AH,[BX]   ;*2 -- 2 bytes per char position
        CMP AH,78             ;too far left?
        POP AX
        JB >O1
        CMP SI,OBJECT+7*OSZ  ;bridge?
        JE >O2
        OR AL,1     ; return "YES"
        RET
     O1:
        CMP AL,AL   ; return "NO"
        RET
     O2:       ; bridge
        CMP AH,60
        JB >O3
        CMP AH,68
        JBE O1
     O3:
        CMP AL,14
        JE >O5
        CMP AL,9
        JE >O5
     O4:
        CMP AH,76
        JAE O1
        CMP AH,48
        JBE O1
     O5:OR AL,1
        RET
REDEFCHARS:
        MOV AX,01100
        MOV BX,0800
        MOV CX,CHARDEF1_CNT
        MOV DX,080
        MOV ES,CS
        MOV BP,CHARDEF1
        INT 010
        MOV AX,01100
        MOV BX,0800
        MOV CX,CHARDEF2_CNT
        MOV DX,0B2
        MOV BP,CHARDEF2
        INT 010
        MOV AX,01100
        MOV BX,0800
        MOV CX,CHARDEF3_CNT
        MOV DX,0BA
        MOV BP,CHARDEF3
        INT 010
        MOV AX,01100
        MOV BX,0800
        MOV CX,CHARDEF4_CNT
        MOV DX,0CF
        MOV BP,CHARDEF4
        INT 010
        MOV AX,01100
        MOV BX,0800
        MOV CX,CHARDEF5_CNT
        MOV DX,0E0
        MOV BP,CHARDEF5
        INT 010
        MOV AX,01100
        MOV BX,0800
        MOV CX,CHARDEF6_CNT
        MOV DX,0F6
        MOV BP,CHARDEF6
        INT 010
        MOV AX,01100
        MOV BX,0800
        MOV CX,CHARDEF7_CNT
        MOV DX,0FB
        MOV BP,CHARDEF7
        INT 010
        MOV AX,01100
        MOV BX,0800
        MOV CX,CHARDEF8_CNT
        MOV DX,1
        MOV BP,CHARDEF8
        INT 010
        MOV AX,01100
        MOV BX,0800
        MOV CX,CHARDEF9_CNT
        MOV DX,10
        MOV BP,CHARDEF9
        INT 010
        RET
WON_DONE:
        CMP JUSTWON?,MAX_JUSTWON?+1
        JA RET
        INC JUSTWON?
        PUSH DS
        MOV ES,AX,VIDSEG_MAIN
        MOV DS,AX
        MOV SI,01000*WON_SAVEPG
        MOV DI,0
        MOV CX,80*24
        REP MOVSW
        POP DS
#IF REGISTERED
        CMP GAMENO,4
        JNE RET
     S3:
        CALL RANDNUM
  #IF GAME4_TEXT_COUNT LT 64
        AND AX,63
  #ELSE
        AND AX,127
  #ENDIF
        CMP AL,GAME4_TEXT_COUNT
        JAE S3
        CLR AH
        MOV GAME4_SUPERWIN_PICK,AX
#ENDIF
        RET
WONFLASH:
        CMP JUSTWON?,MAX_JUSTWON?
        JA WON_DONE
        MOV ES,AX,VIDSEG
        MOV BX,JUSTWON?
        DEC BX
        AND BL,0FE
        ADD BX,OFFSET WON_TABLE
        PUSH SI
        MOV DX,[BX]
        MOV DI,01000*WON_SCRATCHPG
        MOV SI,01000*WON_SAVEPG
        MOV CX,80*24
     L1:
        LODS W[ES:SI]
        PUSH AX
        AND AH,0F0
        CMP AH,CAT
        POP AX
        JE >L2
        AND AH,0F
        OR AH,DH   ; new BG color
        CMP DL,020
        JE >L2
        MOV AX,DX  ; new char (and char-color)
     L2:STOSW
        LOOP L1
        PUSH DS
        MOV DS,ES
        MOV DI,0
        MOV SI,01000*WON_SCRATCHPG
        MOV CX,80*24
        REP MOVSW
        POP DS
        POP SI
        INC JUSTWON?
        RET
#IF REGISTERED
SECRETMESSAGE:
        CMP W[OBJECT+OSZ*n_TOKEN1],22
        JNE RET
        CMP W[OBJECT+OSZ*n_TOKEN2],22
        JNE RET
        CMP W[OBJECT+OSZ*n_TOKEN3],22
        JNE RET
        CMP W[OBJECT+OSZ*n_TOKEN4],22
        JNE RET
        MOV SI,ATARI_STR
        ADD SI,VGA
        MOV DI,4*160+37*2
        MOV ES,AX,VIDSEG_MAIN
        MOV DL,0B
        MOV BL,3
     S1:
        MOV CX,6
     S2:
        LODSB
        MOV AH,[ES:DI+1]
        CALL NEW_CHR_COLOR
        STOSW
        LOOP S2
        ADD DI,160-6*2
        DEC BL
        JNZ S1
        CMP GAMENO,3
        JNA RET
        CMP GAMENO,4
        JNE SCM1
        MOV SI,GAME4_SUPERWIN_TEXT
        MOV CX,GAME4_SUPERWIN_PICK
        JCXZ >S5
     S4:
        LODSB
        CALL CHAR_DECODE
        CMP AL,'_'
        JNE S4
        LOOP S4
     S5:
        MOV BX,SI
     S6:
        LODSB
        CALL CHAR_DECODE
        CMP AL,'_'
        JNE S6
        LEA CX,[SI-1]
        SUB CX,BX      ; char count
        MOV SI,BX
        MOV DI,160*8+80    ;
        SUB DI,CX          ;  center
        AND DI,0FFFE       ;
     S7:               ; write string
        LODSB
        CALL CHAR_DECODE
        MOV AH,[ES:DI+1]
        CALL NEW_CHR_COLOR
        STOSW
        LOOP S7
        RET
    SCM1:       ; print code number and win message
        MOV SI,REGNUM
        MOV DI,160*8+36*2
        MOV CX,8
     L0:
        LODSB
        CALL CHAR_DECODE
        MOV AH,[ES:DI+1]
        CALL NEW_CHR_COLOR
        STOSW
        LOOP L0
        MOV SI,GAME5_WIN_TEXT
        MOV DI,160*10+6*2
        MOV DL,0
    SCM2:
        CMP B[SI],0
        JE SCM3
        MOV CX,68
     L1:
        LODSB
        CALL CHAR_DECODE
        MOV AH,[ES:DI+1]
        CALL NEW_CHR_COLOR
        STOSW
        LOOP L1
        ADD DI,160-68*2
        JMP SCM2
    SCM3:
        RET
CHAR_DECODE:  ; convert AL
        PUSH BX,CX
        MOV CX,8
     N1:
        ROR AL,1
        RCL BL,1
        LOOP N1
        MOV AL,BL
        POP CX,BX
        CMP AL,"`"
        IF E MOV AL,"'"
        RET
PUTTOKEN:   ; Entry: SI = addr in OBJECT
        MOV AX,ROOM
        CMP W[SI],AX
        JNE RET
        MOV ES,AX,VIDSEG_MAIN
        MOV DI,LOC
        LEA AX,[SI-(OBJECT+OSZ*9)]
        MOV DL,OSZ
        DIV DL
        MOV AH,6
        MUL AH
        PUSH SI
        MOV SI,GAMENO_STR
        ADD SI,AX
        ADD SI,VGA
        MOV DL,OBJ_COLORBW[n_TOKEN1]
        CMP COLOR?,0
        IF NE LDFLASHCOLOR DL
        MOV AX,DI
        DIV v_160
        MOV DH,AH
        MOV CX,2
;        ADD SI,2
;        SUB DI,160
;        JS PT3
;        SUB SI,2
    PT1:
        PUSH CX
        MOV CX,3
    PT2:
        MOV AH,[ES:DI+1]
        CALL NEW_CHR_COLOR
        LODSB
        CMP AL,020
        JE >P2
        CMP ROOMCOLOR,CAT
        JNE >P1
        PUSH SI,CX
        MOV SI,DI
        CALL CHECKWALL_SI
        POP CX,SI
        JNZ >P2
     P1:
        CMP DH,160
        JAE >P2
        CMP DI,160*24
        IF B MOV [ES:DI],AX
     P2:
        ADD DI,2
        ADD DH,2
        LOOP PT2
        SUB DI,6
        SUB DH,6
        POP CX
    PT3:ADD DI,160
        LOOP PT1
        POP SI
        RET
#ENDIF
PUTGAMENO:
        MOV ES,AX,VIDSEG_MAIN
        MOV DI,160*10+78
        MOV AL,GAMENO
        DEC AL
        MOV AH,6
        MUL AH
        MOV SI,GAMENO_STR
        ADD SI,AX
        ADD SI,VGA
        MOV AH,030
        CMP COLOR?,0
        IF NE MOV AH,032
        CALL PGN1
        IF NE MOV [ES:DI],AX
        CALL PGN1
        IF NE MOV [ES:DI+2],AX
        CALL PGN1
        IF NE MOV [ES:DI+4],AX
        CALL PGN1
        IF NE MOV [ES:DI+0A0],AX
        CALL PGN1
        IF NE MOV [ES:DI+0A2],AX
        CALL PGN1
        IF NE MOV [ES:DI+0A4],AX
        RET
PGN1:
        LODSB
        CMP AL,020
        RET
TITLEPG:
        MOV ROOMCOLOR,040
        MOV ES,AX,VIDSEG_MAIN
        MOV DI,0
        MOV AX,0720 ;black space
        MOV CX,80*25
        REP STOSW  ;clear screen
        MOV DI,0
        MOV SI,TITLE_COLORS
        MOV CX,10*40
    TL1:
        LODSB
        MOV AH,020
        XCHG AL,AH
        STOSW
        STOSW
        LOOP TL1
        MOV AX,04020  ;red row
        MOV CX,80
        REP STOSW
        MOV AX,021DC  ;green/blue rows
        MOV CX,80
        REP STOSW
        MOV AH,0B7    ;L.cyan/white rows
        MOV CX,80
        REP STOSW
; rim of cup & cup features
        MOV DI,160*14+64
        PUSH DI
        MOV SI,TITLECUP_STR
        MOV CX,11
    TL2:
        PUSH CX
        MOV CX,18
        REP MOVSW
        POP CX
        ADD DI,160-36
        LOOP TL2
        POP DI
        CMP VGA,0
        JE >L0
        MOV B[ES:DI+160*8+14],0D9
        MOV B[ES:DI+160*8+16],0DA
        MOV B[ES:DI+160*8+18],0D9
        MOV B[ES:DI+160*8+20],0DA
     L0:
; text
#IF ADVENTURE
        MOV DI,160*17+10
        MOV SI,TITLETEXT1
    TL3:
        MOV CX,12
        MOV AH,2
    TL4:
        LODSB
        STOSW
        LOOP TL4
        ADD DI,160-2*12
        CMP DI,160*21
        JB TL3
        CMP VGA,0
        IF NE MOV B[ES:DI-320],0D8   ; copyright symbol
#ENDIF
;
        MOV DI,160*17+126
        MOV SI,TITLETEXT2
    TL3A:
        MOV CX,17
        MOV AH,3
    TL4A:
        LODSB
        STOSW
        LOOP TL4A
        ADD DI,160-2*17
        CMP DI,160*21
        JB TL3A
        CMP VGA,0
        IF NE MOV B[ES:DI-160*3],0D8   ; copyright symbol
;
#IF ADVENTURE
        MOV DI,160*15+134
        MOV SI,TITLETEXT3A
        MOV CX,11
#ELSE
        MOV DI,160*17+10
        MOV SI,TITLETEXT3
        MOV CX,17
#ENDIF
        MOV AH,5
    TL4B:
        LODSB
        STOSW
        LOOP TL4B
;
        MOV AL,0
        CMP SHOWDIF_CNT,0
        IF NE CALL PRINTDIFS
        RET
TITLE_COLORS:
#IF ADVENTURE
  DB 13 DUP 0B0,4 DUP 070
#ELSE
  DB 17 DUP 0B0
#ENDIF
  DB 070,070,9 DUP 0B0,070,0E0,0E0,0E0,8 DUP 070
#IF ADVENTURE
  DB 12 DUP 010,4 DUP 0B0
#ELSE
  DB 0B0,7 DUP 010,0B0,7 DUP 010
#ENDIF
  DB 4 DUP 0B0,7 DUP 010,0B0,5 DUP 070,7 DUP 0B0
#IF ADVENTURE
  DB 010,10 DUP 020,4 DUP 010
#ELSE
  DB 010,010,5 DUP 020,010,0B0,010,5 DUP 020
#ENDIF
  DB 4 DUP 010,0B0,010,5 DUP 020,010,7 DUP 0B0,6 DUP 010
#IF ADVENTURE
  DB 010,020,040,040,040,020,020,040,040,040,020,020,020,020
#ELSE
  DB 010,020,020,040,040,040,020,010,010,010,020,040,040,040
#ENDIF
  DB 4 DUP 020,010,010,010,020,040,040,040,020,9 DUP 010,5 DUP 020
#IF ADVENTURE
  DB 020,020,040,030,040,040,020,040,030,5 DUP 040
#ELSE
  DB 010,020,040,040,030,040,5 DUP 020,040,030,040
#ENDIF
  DB 3 DUP 040,5 DUP 020,040,030,040,11 DUP 020,040,040,040,020
#IF ADVENTURE
  DB 020,040,040,030,030,040,040,040,030,040,030,040,030,040
#ELSE
  DB 010,020,040,030,030,7 DUP 040,030,040
#ENDIF
  DB 040,030,7 DUP 040,030,6 DUP 040,7 DUP 040,030,040,040
#IF ADVENTURE
  DB 020,040,030,040,030,040,040,030,030,040,030,040,030,040
#ELSE
  DB 020,020,040,030,030,040,030,030,030,040,040,030,030,040
#ENDIF
  DB 030,040,030,040,030,030,030,040
  DB 030,030,030,040,030,040,030,040,040,030,030,030,040,040,030,040,030,040
#IF ADVENTURE
  DB 020,040,030,030
  DB 030,040,030,040,030,040,030,040,030,030,
#ELSE
  DB 040,040,040,030,030,040,030,040,030,040,030,040,030,040
#ENDIF
  DB 3 DUP 030,040,030,040,030,040,040,030,040,040,030,040,030,040,040,030
  DB 040,030,030,040,030,030,030,040
#IF ADVENTURE
  DB 040,040,030,040,030,3 DUP (040,030),030,030,040
#ELSE
  DB 040,030,040,030,040,040,030,040,030,040,030,040,030,030
#ENDIF
  DB 030,040,040,040,030,040,030,040,030,030
  DB 040,040,030,040,030,040,040,030,040,040,030,040,030,040,040,040
#IF ADVENTURE
  DB 040,030,040,040
  DB 8 DUP 030,040,040
#ELSE
  DB 040,6 DUP 030,040,5 DUP 030,040
#ENDIF
  DB 5 DUP 030,040,12 DUP 030,040,040,6 DUP 030
TITLECUP_STR:
  DW 020,020,020,0FDC,0FDC,0FDC,06FDF,06FDF,4 DUP 0FDF,0FDC,0FDC,0FDC,020,020,020
  DW 0FDC,0FDB,06FDF,7 DUP 06DB,06DC,06DC,020,020,020,0FDF,0FDB,0FDC
  DW 0FDF,0FDB,6FDC,10 DUP 06DB,06DC,020,0FDC,0FDB,0FDF
  DW 0DC,0FF9,0F2E,0FDF,0FDF,0FDF,6 DUP 06FDC,0FDF,0FDF,0FDF,0F2E,0FF9,0DC
  DW 020,0DC,020,020,0FF9,4 DUP (020,0F2E),020,0FF9,020,0DC,020
  DW 020,020,020,0DC,0DC,8 DUP 020,0DC,0DC,020,020,020
  DW 18 DUP 020
  DW 7 DUP 020,4 DUP 06F4,7 DUP 020
  DW 5 DUP 020,0DF,0DF,06B4,06C3,06B4,06C3,0DF,0DF,5 DUP 020
  DW 7 DUP 020,4 DUP 06F5,7 DUP 020
  DW 5 DUP 020,8 DUP 0DC,5 DUP 020
TITLECUP_FLASHAREA:  ;offsets from upper-left corner
TCUPDAT MACRO
  #RX2L
        DW #1+#X
  #ER
#EM
  TCUPDAT 0,    0,34
  TCUPDAT 0A0,  0,2,4,6,8,10,24,26,28,30,32,34
  TCUPDAT 0140, 2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32
  TCUPDAT 01E0, 6,8,10,12,14,16,18,20,22,24,26,28
  TCUPDAT 0280, 14,16,18,20
  TCUPDAT 0320, 14,16,18,20
  TCUPDAT 03C0, 10,12,14,16,18,20,22,24
  TCUPDAT 0460, 6,8,10,12,14,16,18,20,22,24,26,28
  TCUPDAT 0500, 10,12,14,16,18,20,22,24
TCUP_FLASH_CNT EQU ($-TITLECUP_FLASHAREA) SHR 1
TITLETEXT1: DB 'GAME CONCEPT& GRAPHICS  c 1978 AtariCorp.       '
TITLETEXT2: DB 'DOS program      c 1991 Craig PellMost rights      reserved.        '
TITLETEXT3: DB 'Press '
TITLETEXT3A: DB 'F1 for help'
;
#IF REGISTERED
LOADMSG DB ' Enter name of file to load:',0
LOADINGMSG  DB 'Loading...                 ',0
NOTFOUNDMSG DB 'File not found.            ',0
LOADFAILMSG DB '  Load failed.             ',0
PRESSAKEYMSG DB 'Press any key',0
SAVEMSG DB 'Enter name of file to save to:',0
SAVINGMSG DB 'Saving...',0
PATHNOTFOUNDMSG DB "Can't find path.           ",0
CANNOTOPENMSG   DB 'Cannot open file.          ',0
SAVEFAILMSG     DB 'Save failed.               ',0
DISKFULLMSG     DB 'Disk full.                 ',0
DEFAULT_EXTENSION DB '.ADV',0
#ENDIF
;
PRINTDIFS:
     P1:
        CMP AL,0
        JNE >P2
        CMP SHOWDIF_CNT,-1
        IF NE MOV SHOWDIF_CNT,SHOWDIF_CNT_length
     P2:
        MOV ES,AX,VIDSEG_MAIN
        MOV AH,7   ;attribute
        MOV DI,0F08+8
        MOV SI,LDIFSTR
        MOV CX,7
        CALL PASTR
        CMP LDIF,0
        IF E MOV SI,LDIFSTR_B
        MOV CX,16
        CALL PASTR
        MOV DI,0F00+78+18
        MOV SI,RDIFSTR
        MOV CX,8
        CALL PASTR
        CMP RDIF,0
        IF E MOV SI,RDIFSTR_B
        MOV CX,22 ;33
        CALL PASTR
        PUSH BX
        MOV BX,MOVEMODESTR
        MOV AL,MOVEMODE
        XLATB
        POP BX
        MOV AH,9
        MOV [ES:0F00],AX
        MOV AX,050E
        CMP SOUND?,0
        IF E MOV AL,0FA
        MOV [ES:0F04],AX
        CMP ROOMCOLOR,CAT
        JNE >P3
        CMP SHOWDIF_CNT,0
        JE >P3
        PUSH DS
        MOV DS,ES
        MOV SI,0F00
        MOV DI,03F00
        MOV CX,80
        REP MOVSW
        POP DS
     P3:
        RET
PASTR:   ;entry: ES:DI, SI, CX, AH
        LODSB
        STOSW
        LOOP PASTR
        RET
MOVEMODESTR: DB 'SKJA'
LDIFSTR: DB 'Left = '
LDIFSTR_A: DB 'A : Fast bite!  '
LDIFSTR_B: DB 'B : Regular bite'
RDIFSTR: DB 'Right = '
RDIFSTR_A: DB 'A : Dragons fear sword'
RDIFSTR_B: DB 'B : Fearless dragons  '
;
SHOWHELP:
        IN AL,061
        AND AL,0FC
        OUT 061,AL
        PUSH DS
        MOV DS,AX,VIDSEG_MAIN
        MOV ES,AX
        MOV SI,0
        MOV DI,01000*HELP_TXTPG    ; addr of page 2
        MOV CX,80*25
        REP MOVSW
        POP DS
        MOV W[ES:01000*HELP_TXTPG+160+36],0    ; UL corner
        MOV DI,01000*HELP_TXTPG+160+38
        MOV CX,42
        MOV AX,03DC
        REP STOSW             ; top edge
        MOV W[ES:DI],0               ; UR corner
        MOV W[ES:01000*HELP_TXTPG+160*22+36],0  ; LL corner
        MOV DI,01000*HELP_TXTPG+160*22+38
        MOV CX,42
        MOV AX,03DF
        REP STOSW             ; bottom edge
        MOV W[ES:DI],0        ; LR corner
        MOV DI,01000*HELP_TXTPG+160*2+36
        MOV CX,20
        MOV AX,03DB
     H1:
        MOV W[ES:DI],0
        MOV [ES:DI+2],AX      ; left edge
        MOV [ES:DI+42*2],AX   ; right edge
        MOV W[ES:DI+43*2],0
        ADD DI,160
        LOOP H1
        MOV SI,HELP_TEXT      ; text offset
        MOV AX,5 BY HELP_TXTPG  ; text page 2
        INT 010
        MOV AH,2
        MOV BH,HELP_TXTPG
        MOV DX,2 BY 20
        INT 010       ; move cursor
DRAWHELPTEXT:
        PUSH SI
        MOV CX,20
        MOV DI,01000*HELP_TXTPG+160*2+20*2
        MOV AX,04E00  ; text color & init AL
     H2:
        PUSH DI
        MOV BL,40
     Z1:
        CMP AL,0FF
        JE >H3
        LODSB
        CMP AL,128
        JE >H3
        STOSW
        DEC BL    ; count characters placed
        JMP Z1
     H3:
        CMP BL,0
        JLE >H4
        PUSH CX
        PUSH AX
        MOV CL,BL
        MOV CH,0
        MOV AL,020
        REP STOSW
        POP AX
        POP CX
     H4:
        POP DI
        ADD DI,160
        LOOP H2
        POP SI
     L0:
        CMP CTRL_BRK_PRESSED?,0
        IF NE JMP EXIT_PROGRAM
        MOV AH,0
        INT 016   ; get key
        CMP AH,sc_UpArrow
        JNE >L1
        CALL >H10
        JMP DRAWHELPTEXT
     L1:
        CMP AL,13   ; Enter?
        JE >E1
        CMP AH,sc_DownArrow
        JNE >L2
     E1:
        CALL >H11
        JMP DRAWHELPTEXT
     L2:
        CMP AH,sc_PgUp
        JNE >L4
        MOV CX,19
     L3:CALL >H10
        LOOP L3
        JMP DRAWHELPTEXT
     L4:
        CMP AH,sc_PgDn
        JNE >L6
        MOV CX,19
     L5:CALL >H11
        LOOP L5
        JMP DRAWHELPTEXT
     L6:
        CMP AH,sc_ESC
        JE >L7
        CMP AH,sc_F1
        JNE L0
     L7:
        CMP SOUND?,0
        JE >S1
        CMP SOUND_PTR,0
        JE >S1
        IN AL,061
        OR AL,3
        OUT 061,AL
     S1:
        MOV AX,5 BY MAIN_TXTPG
        INT 010     ; back to text page 0
        RET
     H10:
        CMP SI,HELP_TEXT
        JBE RET
        DEC SI
     L1:
        CMP SI,HELP_TEXT
        JBE RET
        DEC SI
        CMP B[SI],128
        JNE L1
        INC SI
        RET
     H11:
        PUSH SI
     H12:
        CMP B[SI],128
        JE >H13
        INC SI
        JMP H12
     H13:
        INC SI
        CMP B[SI],255
        JE >H14
        ADD SP,2
        RET
     H14:
        POP SI
        RET
