FREEWARE EQU 1          ; Atari Corp. sucks
#IF R
REGISTERED EQU 1
#ENDIF
#IF FW
FREEWARE EQU 1
#ENDIF
#IF FREEWARE
REGISTERED EQU 1
#ENDIF
ADVENTURE EQU 0         ; use "Indenture"
DBVERSION MACRO
  DB '1.7'
#EM
DATA SEGMENT
        ORG 0F000
ROOM    DW ?
PL_AD   DW ?
LASTMOVE DB ?
JOYVALS DW
HMOV    DW ?
VMOV    DW ?
LASTGOOD_RM DW ?
LASTGOOD_AD DW ?
BUTTONS DB ?
MOVEMODE DB ?
v_StickyKeys EQU 0
v_KeyInt     EQU 1
v_Joystick   EQU 2
v_AtariJoy   EQU 3
GAMENO  DB ?
SOUND?  DB ?
COLOR?  DB ?
ENTERRM0_CNT DB ?
ENTERRM0_THRESHOLD EQU 32
LDIF    DB ?   ;   difficulty switches: 0 = "b" setting, 0FF = "a" setting
RDIF    DB ?   ;
SHOWDIF_CNT DB ?
SHOWDIF_CNT_length EQU 50
RMSZ    EQU TYPE(ROOM)
ROOMCOLOR DB ?
LASTKEY DB ?
LC_FLAG DB ?   ;bit 7=Left line, 6=Right line, 5=castle, 4=open gate, 3=flashing message
GATE    DB 5 DUP ?    ;0=CLOSED
TOUCHED_OBJ DW ?
CARRYING DW ?   ; -1 = nothing
CARRY_DISTANCE DW ?      ;relative position of object to player
STILLTOUCHING DW ?    ; 0=nothing
        STRUC [SI]
RM      DW ?
LOC     DW ?
DR_STATUS DB
HINC    DB ?
VINC    DB ?
        ENDS
ROMDELAY DB ?
ROMDELAYPRESENT? DB ?
VGA     DW ?
BROWNDAC DB 02A,0,015       ;VGA's RGB settings for Brown
OSZ     EQU 2+RMSZ
OBJECT: DB 16 DUP (OSZ DUP (?))  ; For each object, a room & an address
DRSZ    EQU 4+RMSZ
DRAGON: DB 4 DUP (DRSZ DUP (?))   ; Same, plus incr (direction): H-byte & V-byte
; special incr values (H-byte)
BITING    EQU 020  ; and up
DEAD      EQU 080
HAS_EATEN EQU 090
;
BAT:    DB (4+RMSZ) DUP ?      ; same as dragon, plus
BAT_CARRYING DW ?              ; Carrying word
BAT_CD  DW ?                   ; and carry distance
BAT_HOLDCNT DB ?
BAT_OBJINSIGHTS DW ?   ;addr of object in bat's sights
SWCARBYBAT_BG DB ?,?  ;SWallowed and CARried BY BAT : 0 = empty, else wall
SWALLOWED DW ?  ; address of dragon's data, 0 for none
REPEL   DB ?
v_160   DB ?
PUTCAT_DRAWN DB ?
LCNT    DW ?
TEMPB   DB
TEMP    DW ?
        DW ?,?,?
TEMP_RM DW ?
TEMP_AD DW ?
;TMP_HBLOCKED_BY_OBJ? DW ?
COPEN_CNT DB ?
CCLOSE_CNT DB ?
SOUND_PTR DW ?
SOUND_START DB ?
RNDCNT  DW ?
BLINK_CTR DB ?
MAX_BLINK_CTR EQU 7
LINE_OBJ_PTR DW ?
LINE_COLOR_PTR DW ?
LOOP_TIMER DW ?
JUSTWON? DW ?
MAX_JUSTWON? EQU 64
#IF REGISTERED
GAME4_SUPERWIN_PICK DW ?
#ENDIF
PROG_JUST_STARTED? DB ?
v_TIMERLOOPSIZE EQU 040
v_JOYSTICK_TIMEOUT EQU 0200
JLEFT   DW ?
JRIGHT  DW ?
JUP     DW ?
JDOWN   DW ?
START_JOYVALS DW ?,?
BUTTON2STILLDOWN DB 0
MULTIPORT DW ?
AJ_INDEX DB ?,?,?,?,?
AJ_BIT   DB ?,?,?,?,?
BIOSJOYSTICK DB ?
FORCENOVGA   DB ?
ORIGINAL_MODE DB ?
CURSORROWONEXIT DB 0
SHIFTCTRLALTA DB 0              ; my revenge
VIDSEG  EQU 0B800
MAIN_TXTPG    EQU 0
CAT_TXTPG     EQU 1
SCRATCH_TXTPG EQU 2
HELP_TXTPG    EQU 2
ALLGRAY_TXTPG EQU 3
WON_SAVEPG    EQU 1
WON_SCRATCHPG EQU 3
VIDSEG_MAIN   EQU VIDSEG+0100*MAIN_TXTPG
SOLID   EQU 0DB
LINE_MARGIN EQU 10
CAT     EQU 030   ;  Catacomb
SILENCE EQU -1
v_RDIST_REG     EQU -2    ; regular room distribution (original 30)
v_RDIST_EXTONLY EQU -3    ; extended rooms only
v_RDIST_EXT     EQU -4    ; all rooms
v_RDIST_REG_CASTLE EQU -5 ; regular, but only inside a castle
v_RDIST_EXT_CASTLE EQU -6 ; inside any castle
DATEND:
;
BWWhite    EQU 15
BWOffWhite EQU 7
BWMGray    EQU 8
BWDGray    EQU 6
;
n_SWORD        EQU 0
n_KEY_YELLOW   EQU 1
n_KEY_BLACK    EQU 2
n_KEY_WHITE    EQU 3
n_KEY_GREEN    EQU 4
n_KEY_FLASHING EQU 5
n_CHALICE      EQU 6
n_BRIDGE       EQU 7
n_MAGNET       EQU 8
n_TOKEN1       EQU 9
n_TOKEN2       EQU 10
n_TOKEN3       EQU 11
n_TOKEN4       EQU 12
n_WHISTLE      EQU 13
n_DOT          EQU 14
n_BDOT         EQU 15
;  Scan codes
sc_F1   EQU 59
sc_F2   EQU 60
sc_F3   EQU 61
sc_F4   EQU 62
sc_F5   EQU 63
sc_F6   EQU 64
sc_F7   EQU 65
sc_F8   EQU 66
sc_F9   EQU 67
sc_F10  EQU 68
sc_ESC  EQU 1
sc_Home       EQU 71
sc_UpArrow    EQU 72
sc_PgUp       EQU 73
sc_LeftArrow  EQU 75
sc_Keypad5    EQU 76
sc_RightArrow EQU 77
sc_End        EQU 79
sc_DownArrow  EQU 80
sc_PgDn       EQU 81
sc_Insert     EQU 82
sc_A          EQU 30
sc_B          EQU 48
sc_D          EQU 32
sc_R          EQU 19
sc_S          EQU 31
sc_W          EQU 17
sc_X          EQU 45
sc_Space      EQU 57
sc_Shift_F1   EQU 84
sc_Shift_F2   EQU 85
;
CODE SEGMENT
WWMOV   MACRO
        PUSH WORD #2
        POP WORD #1
#EM
DMOV    MACRO   ; mem-to-mem dword move
        PUSH #2
        POP #1
        PUSH #2[2]
        POP #1[2]
#EM
CLR     MACRO
        XOR #1,#1
#EM
LDFLASHCOLOR MACRO
        MOV BX,LCNT
        SHR BX,1
        AND BX,3
        MOV #1,CBCOLOR[BX]
        CMP COLOR?,0
        IF E MOV #1,CBCOLORBW[BX]
#EM
DEBUGPAUSE MACRO
        PUSH AX
        MOV AH,2
        INT 016
        TEST AL,010
        JZ >R1
        MOV AH,0
        INT 016
     R1:
        POP AX
#EM
        EXTRN MAP:NEAR,MAP_GAME1:NEAR,KEYINT:NEAR
        CLD
;check for INT 15h interrupt
        MOV AX,08300
        LEA BX,ROMDELAYPRESENT?
        CLR CX
        MOV DX,5
        MOV [BX],AL
        INT 015         ; test with a 5-microsecond delay
        MOV v_160,160
        MOV AH,0F
        INT 010         ; get display mode
        MOV ORIGINAL_MODE,AL
        MOV VGA,0
        MOV COLOR?,0FF
#IF
        MOV CX,6
        CMP CL,[CS:080]  ; command tail has length of 6?
        JNE >T1          ; no
        MOV DI,081  ; command tail address
        LEA SI,PSTR_NOVGA_UPPER
        PUSH CX,DI
        REPE CMPSB ; check for "NOVGA" command tail
        POP DI,CX
        JE >T0
        LEA SI,PSTR_NOVGA_LOWER
        REPE CMPSB ; check for "novga" command tail
        JNE >T1
     T0:
        MOV AL,0   ; prevent VGA text-character redefinition
        JMP >T2
PSTR_NOVGA_UPPER DB ' NOVGA'
PSTR_NOVGA_LOWER DB ' novga'
#ELSE
        MOV BIOSJOYSTICK,0
        MOV FORCENOVGA,0
        MOV CL,[CS:080]
        XOR CH,CH               ; command tail character count
        JCXZ >T0
        MOV ES,CS
        MOV DI,081
        MOV AL,'-'
     O1:
        REPNE SCASB
        JNE >T0
        CMP B[DI],'J'
        JE >O2
        CMP B[DI],'j'
        JE >O2
        CMP B[DI],'V'
        JE >O3
        CMP B[DI],'v'
        JE >O3
        CMP B[DI],'?'
        JE >O4
        JMP O1
     O2:
        MOV BIOSJOYSTICK,-1
        JMP O1
     O3:
        MOV FORCENOVGA,-1
        JMP O1
     O4:
        JMP CMDLINEHELP
     T0:
#ENDIF
        MOV AL,0
        CMP AL,FORCENOVGA
        JNE >T2
     T1:
        MOV AX,01200
        MOV BL,030
        INT 010        ;VGA: set to 200-scanline text
     T2:CMP AL,012     ;no VGA?
        PUSHF
        JNE >X1
        MOV VGA,VGASTR_DIFF
        MOV B HELPCOPYRIGHT,0D8
     X1:MOV AX,3
        INT 010
        POPF
        JNE >T3
        CALL REDEFCHARS
        MOV AX,01010
        MOV BX,3
        MOV CX,02020
        MOV DH,CH
        INT 010     ; change cyan to light gray
     T3:
;
        CALL DISABLEBLINK
        CALL GETTIME
        MOV RNDCNT,AX
        MOV W[OFFSET LDIF],0   ; start both at easy difficulty
        MOV SHOWDIF_CNT,-1  ; = "Always show difficulties & settings"
        MOV MOVEMODE,v_KeyInt
        MOV GAMENO,1
        MOV JUSTWON?,0
        MOV SOUND?,0FF
        MOV PROG_JUST_STARTED?,0FF
HIDE_CURSOR MACRO
        MOV AH,2
        MOV BH,#1
        MOV DX,01900
        INT 010          ;remove cursor
#EM
        HIDE_CURSOR MAIN_TXTPG
        HIDE_CURSOR ALLGRAY_TXTPG
;
USEMYINT MACRO
        PUSH DS
        MOV AX,035 BY 0#1
        INT 021
        MOV CS:ORIGINAL_INT#1[2],ES
        MOV CS:ORIGINAL_INT#1,BX
        MOV AX,025 BY 0#1
        MOV DS,CS
        MOV DX,#2
        CLI
        INT 021
        STI
        POP DS
#EM
        CLI
        MOV AL,036         ;
        OUT 043,AL         ;
        MOV AX,v_TIMERLOOPSIZE
        OUT 040,AL         ;
        MOV AL,AH          ;
        OUT 040,AL         ;
        STI
        USEMYINT  0,DIV_INT
   CMP BIOSJOYSTICK,0
   IF E USEMYINT  8,TIMERINT
        USEMYINT  9,KEYINT
        USEMYINT 1B,CTRL_BRK_INT
        USEMYINT 24,ABORTRETRYFAIL_INT
        CALL JOYSTICK_INIT
        CALL ATARIJOYSTICK_INIT
;
        MOV ROOM,-1
        MOV LASTGOOD_RM,-1
        MOV AX,14*160+4
        JMP >R1
SELECTGAME:
        MOV PROG_JUST_STARTED?,0
        MOV JUSTWON?,0
        MOV AL,GAMENO
        DEC AL
        CALL LOADALL
        MOV ES,DS
        MOV DI,OFFSET GATE
        MOV CX,5
        MOV AL,0
        REP STOSB   ; all gates closed
        MOV ENTERRM0_CNT,0
        MOV ROOM,0
        MOV LASTGOOD_RM,0
        CMP SHOWDIF_CNT,0
        JE >L1
        MOV AL,0FF
        CALL PRINTDIFS
     L1:
        MOV AX,160*23+60
        JMP >R1
RESET:
        MOV JUSTWON?,0
        MOV ROOM,1
        MOV LASTGOOD_RM,1
        MOV AX,160*19+80
    R1: MOV PL_AD,AX
        MOV LASTGOOD_AD,AX
        MOV TOUCHED_OBJ,-1
        MOV CARRYING,-1
        CALL PUTROOM
        CLR AX
        MOV LCNT,AX
        MOV SOUND_PTR,AX
        MOV SWALLOWED,AX
        MOV REPEL,AL
        MOV BAT_HOLDCNT,1
        MOV BLINK_CTR,AL
        MOV STILLTOUCHING,AX
        MOV BUTTON2STILLDOWN,AL
        CALL GETTIME
        MOV LOOP_TIMER,AX
        CMP ROMDELAYPRESENT?,0
        IF NZ CALL SETROMTIMER
        MOV LASTKEY,'_'
        DMOV JOYVALS,START_JOYVALS
;  revive dragons
        MOV DI,DRAGON+3*DRSZ+4
     L1:
        CMP B[DI],DEAD
        JE >L2
        CMP B[DI],HAS_EATEN
        JNE >L3
     L2:
        MOV B[DI],0
     L3:
        SUB DI,DRSZ
        CMP DI,DRAGON+4
        JAE L1
MAIN:
        CMP PROG_JUST_STARTED?,0
        JNE >W1
        CMP JUSTWON?,0
        JNE >W1
        CMP W[OBJECT+6*OSZ],22   ;chalice in yellow castle?
        JNE >W1
        MOV JUSTWON?,1
        MOV SOUND_PTR,OFFSET WON_SOUND
        MOV SOUND_START,-1
        CALL PUTPLAYER
        PUSH DS
        MOV ES,AX,VIDSEG
        MOV DS,AX
        MOV SI,0
        MOV DI,01000*WON_SAVEPG
        MOV CX,80*24
     W0:
        LODSW
        MOV AL,' '
        STOSW
        LOOP W0
        POP DS
     W1:
        INC LCNT
        CMP PROG_JUST_STARTED?,0
        IF NE JMP PLAYER
; Blink setup
        MOV CL,0
        TEST LC_FLAG,028
        IF NZ INC CL
        CMP ROOMCOLOR,CAT
        IF E INC CL
        MOV BX,ROOM
        MOV SI,OBJECT
     B1:
        CMP BX,[SI]
        JNE >B2
        INC CL
     B2:
        ADD SI,OSZ
        CMP SI,DRAGON
        IF A INC SI,2
        CMP SI,BAT
        JBE B1
     B3:
        CMP CL,MAX_BLINK_CTR
        IF A MOV CL,MAX_BLINK_CTR
        MOV BLINK_CTR,CL
; DONE_BLINK:
        CMP JUSTWON?,0
        JE >W1
        JMP LONG >A1
     W1:
        CMP STILLTOUCHING,0
        JE >L1
        MOV SI,STILLTOUCHING
        WWMOV W COBJ_LOC,LASTGOOD_AD
        CALL CONTACT_OBJ?
        JZ >L1
        MOV STILLTOUCHING,0
     L1:
;  Check to see if come in contact with object
        MOV SI,TOUCHED_OBJ
        CMP SI,-1
        JNE >K0
        MOV SI,OBJECT
CONTACTLOOP:
        WWMOV COBJ_LOC,PL_AD
        CALL CONTACT_OBJ?
        JZ >K0
        MOV AX,LASTGOOD_RM
        CMP AX,ROOM
        JNE >K1
        WWMOV COBJ_LOC,LASTGOOD_AD
        CALL CONTACT_OBJ?
        JNZ >K1
     K0:
        CMP BAT_CARRYING,SI
        JNE >Z0
        MOV CARRYING,-1
        JMP >L2
     Z0:
;        CMP STILLTOUCHING,SI
;        JE >Z1
        MOV CARRYING,SI
        MOV STILLTOUCHING,SI
        CALL ERASE_OBJ
;        CALL PICKUP_BUMPOBJ  ;returns with "boundless" loc addr in AX
;                            (   MOV AX,[SI+1]   )
     Z1:
;        SUB AX,COBJ_LOC
        MOV DX,LASTGOOD_AD
        MOV AX,RM
        CMP AX,LASTGOOD_RM
        JE >Z3
        CALL CALC_LASTGOOD
     Z3:
;  compute (LOC - LASTGOOD_AD) + (PL_AD - LASTGOOD_AD)
        MOV AX,LOC
        SUB AX,DX
        ADD AX,PL_AD
        SUB AX,DX
     Z4:
        MOV CARRY_DISTANCE,AX
;
;        PUSH LASTGOOD_AD
;        POP PL_AD
;        MOV AX,LASTGOOD_RM
;        XCHG AX,ROOM
;        CMP AX,ROOM
;        IF NE CALL PUTROOM
     L2:
        MOV SOUND_PTR,SOUND_PICKUP
        MOV SOUND_START,-1
        CMP SI,BAT
        IF E CALL PICKED_UP_BAT
        JMP >A1
     K1:
        CMP SI,BAT
        JE >A1
        ADD SI,OSZ
        CMP SI,DRAGON
        IF B JMP CONTACTLOOP
        MOV SI,BAT
        JMP CONTACTLOOP
     A1:
        CMP JUSTWON?,0
        IF NE JMP PLAYER
        MOV DX,[OBJECT+(8*OSZ)]
        MOV SI,OBJECT
MAGNETISM:
        CMP SI,OBJECT+n_MAGNET*OSZ
        JNE >L1
     L0:JMP LONG >M4
     L1:CMP DX,[SI]
        JNE L0
        CMP CARRYING,SI
        IF E JMP LONG >M5
        CALL ERASE_OBJ
        MOV AX,[OBJECT+(OSZ*8)+2]
        DIV v_160
        ADD AL,2
        MOV DX,AX
        MOV AX,LOC
        DIV v_160
        CMP AH,DH
        JNB >M1
        ADD LOC,2
        JMP >M2
     M1:
        JNA >M2
        SUB LOC,2
     M2:
        CMP AL,DL
        JNA >M3
        TEST LCNT,1
        IF Z SUB LOC,160
        JMP >M5
     M3:
        JNB >M5
        TEST LCNT,1
        IF Z ADD LOC,160
        CMP LOC,160*24
        JB >M5
        SUB LOC,160*24
        MOV BX,[OBJECT+(n_MAGNET*OSZ)]
        PUSH BX
        CALL GETMAPADDR
        POP AX
        CALL GETROOMBELOW
;        MOV AX,[BX+6]
;        XCHG [SI],AX
;        MOV ES,CS
;        MOV DI,CASTLE_1STRM
;        MOV CX,5
;        REPNE SCASW
;        JNE >M5
;        SUB DI,CASTLE_1STRM+2
;        SHR DI,1
;        CMP GATE[DI],0    ; gate open?
;        JNE >L2           ; yes
;        SHL DI,1                     ; no
;        MOV AX,CASTLE_LOCKEDIN[DI]
        MOV [SI],AX
;        JMP >M5
        JNZ >M5
;     L2:
        MOV LOC,(15*160)+76
        JMP >M5
     M4:
        ADD SI,OSZ
        CMP SI,OBJECT+13*OSZ
        IF BE JMP MAGNETISM
     M5:
#IF REGISTERED
BATSOBJ_MOVE:
        MOV SI,BAT_CARRYING
        CMP SI,-1
        JE >J0
        CALL ERASE_OBJ
        CALL BOMOVE1
;        MOV SI,BAT_CARRYING
;        CMP SI,SWALLOWED
;        JE >L1
     J0:JMP BATSOBJMOVE_DONE
     L1:
        MOV AH,CAT
        CMP ROOMCOLOR,AH
        JNE >Q1
        MOV AH,0C0
        CMP COLOR?,0
        IF E MOV AH,BWOffWhite
     Q1:
;        PUSH SI
;        PUSH LASTGOOD_AD
;        CALL CHECKWALL
        CMP SWCARBYBAT_BG,0
        IF NZ MOV AH,ROOMCOLOR
;        ADD LASTGOOD_AD,2
;        PUSH AX
;        CALL CHECKWALL
;        POP AX
;        POP LASTGOOD_AD
;        POP SI
        MOV AX,[SI]
        XCHG ROOM,AX
;        MOV LASTGOOD_RM,AX
        MOV AX,LOC
        ADD AX,322
        XCHG PL_AD,AX
;        MOV LASTGOOD_AD,AX
        PUSH SI
        MOV W[OFFSET SWCARBYBAT_BG],0
        CALL CHECKACTUAL
        IF A DEC SWCARBYBAT_BG    ; if NZ and NC
        ADD PL_AD,2
        CALL CHECKACTUAL
        IF A DEC SWCARBYBAT_BG[1]
        SUB PL_AD,2
;        MOV LASTGOOD_AD,AX
        POP SI
        MOV DX,[SI]
        MOV AX,LOC
        DIV v_160
        CMP AH,158
        JB >L2
        SUB PL_AD,160
;        SUB LASTGOOD_AD,160
        MOV BX,[SI]
        CALL GETMAPADDR
        MOV AX,[BX+2]
        MOV ROOM,AX
        MOV DX,AX
     L2:
        CMP LOC,160*22
        JB >L3
        SUB PL_AD,160*24
;        SUB LASTGOOD_AD,160*24
        MOV BX,DX
        CALL GETMAPADDR
        MOV AX,[BX+6]
        MOV ROOM,AX
     L3:
;        MOV AX,ROOM
;        XCHG LASTGOOD_RM,AX
        MOV AX,LASTGOOD_RM
        CMP AX,ROOM
        JE >L4
        CALL PUTROOM
        CMP JUSTWON?,0
        IF E CALL PUTPLAYER
     L4:
        JMP BATSOBJMOVE_DONE
BOMOVE1:
        MOV BX,[BAT]
        CALL GETMAPADDR
        MOV AX,[BAT+2]
        PUSH AX
        DIV v_160
        MOV CX,AX      ; CH,CL := H & V of Bat
        POP AX
        ADD AX,BAT_CD
        PUSH AX
        PUSHF
        IF S ADD AX,160*24
        DIV v_160      ; AH,AL := H & V of object
        POPF
        IF S SUB AL,24
        MOV DX,AX
        POP AX
        CMP DH,CH
        JA >B29  ;no problem
        MOV BX,[BX+2]   ;object is in room on right (but still held by Bat)
        MOV [SI],BX
        CALL GETMAPADDR  ;in case object must be also be moved UP a room
        SUB AX,160
        JS >B2901
        CMP AX,160*24
        JAE >B3001
        JMP >B31
    B29:
        CMP AX,0
        JGE >B30
 B2901:
        WWMOV [SI],[BX+4]   ;object is in room above
        ADD AX,160*24
        JMP >B31
    B30:
        CMP AX,160*24
        JB >B32
  B3001:PUSH AX       ;object is in room below
        MOV AX,[BAT]
        CALL GETROOMBELOW
;        MOV ES,CS
;        MOV DI,CASTLE_1STRM
;        MOV CX,5
;        REPNE SCASW
;        MOV AX,[BX+6]
;        JNE >B3002
;        SUB DI,CASTLE_1STRM+2
;        SHR DI,1
;        CMP GATE[DI],0          ; gate open?
;        JNE >B3002              ; yes
;        SHL DI,1
;        MOV AX,CASTLE_LOCKEDIN[DI]  ; no
;    B3002:
        MOV [SI],AX
        POP AX
        SUB AX,160*24
    B31:
        MOV LOC,AX
        RET
    B32:
        WWMOV [SI],[BAT]
        JMP SHORT B31
BATSOBJMOVE_DONE:
#ENDIF
        MOV SI,OBJECT
     O1:
        CALL SIZEOFOBJ
        CALL OBJONOPENCASTLE?
        JZ >O2
        CALL ERASE_OBJ
        MOV AX,LOC
        DIV v_160
        MOV BX,160*23
        ADD BL,AH
        ADC BH,0
        MOV LOC,BX
        MOV AX,[SI]
        MOV ES,CS
        MOV DI,CASTLE_TABLE
        MOV CX,5
        REPNE SCASW
        MOV AX,[DI-2][CTBLDIF]
        MOV [SI],AX
     O2:
        ADD SI,OSZ
        CMP SI,DRAGON
        JBE O1
        ADD SI,DRSZ-OSZ
        CMP SI,BAT
        JBE O1
 PLAYER:
        MOV PUTCAT_DRAWN,0
        CALL CHECKACTUAL
        IF NZ CALL PUTCAT
;        MOV BX,LASTGOOD_AD
;;        MOV PL_AD,BX
;        MOV AX,LASTGOOD_RM
;        CMP AX,ROOM
;;        MOV ROOM,AX
;        JE >L1
;        PUSH ROOM
;        MOV ROOM,AX
;        CALL PUTROOM
;        POP ROOM
;     L1:
        CMP PUTCAT_DRAWN,0
        IF E CALL PUTCAT
        CMP PROG_JUST_STARTED?,0
        JNE >X1
        CMP JUSTWON?,0
        JNE >X1
        MOV DI,LASTGOOD_AD
        CALL PUTPL1  ;PUTPLAYER
     X1:
        CMP ROOM,-1
        JNE >L2
        MOV ES,AX,VIDSEG_MAIN
        LDFLASHCOLOR DL
        MOV CL,4
        SHL DL,CL
        MOV SI,TITLECUP_FLASHAREA
        MOV CX,TCUP_FLASH_CNT
    TL6:
        MOV DI,[SI]
        ADD SI,2
        ADD DI,160*16+64
        MOV AL,[ES:DI+1]
        AND AL,0F
        OR AL,DL
        MOV [ES:DI+1],AL
        LOOP TL6
     T0:JMP NOCB
     L2:
#IF REGISTERED
        MOV BX,4
        MOV DI,79
        CMP ROOM,21
        JNE >L3
        MOV SI,PBSTRING
        CMP SHIFTCTRLALTA,0
        JE >C0
        DEC SHIFTCTRLALTA
        MOV SI,ALT_PBSTRING
        JMP >C0
     L3:
        CMP ROOM,5
        IF NE JMP NOCB
        MOV SI,CBSTRING
        ADD SI,VGA
        CMP VGA,0
        JE >C0
        MOV BL,2
        MOV BP,4
        MOV DI,77
     C0:
        MOV CX,24
        MOV ES,AX,VIDSEG_MAIN
        PUSH BX
        XOR DL,DL
        CMP COLOR?,0
        IF NE LDFLASHCOLOR DL
        POP BX
        CALL CHECKBLINK
        IF NZ MOV DL,3
     C1:
        CMP ROOM,21
        JNE >L1
        CMP CL,1
        JE >L0
        CMP CL,24
        JNE >L1
     L0:MOV AL,DL
        MOV DH,16
        MUL DH
        OR AL,(CAT SHR 4)
        MOV AH,'G'
        MOV W[ES:DI],AX
;        MOV B[ES:DI+1],'G'
;        MOV B[ES:DI],AL
        MOV B[ES:DI+2],AL
        MOV B[ES:DI+4],AL
        JMP >L2
     L1:
;        MOV AL,[ES:DI]
;        AND AL,0F0
;        OR AL,DL
;        MOV [ES:DI],AL
;        MOV AL,[ES:DI+BX]
;        AND AL,0F0
;        OR AL,DL
;        MOV [ES:DI+BX],AL
        MOV AH,[ES:DI]
        CALL NEW_CHR_COLOR
        MOV [ES:DI],AH
        MOV AH,[ES:DI+BX]
        CALL NEW_CHR_COLOR
        MOV [ES:DI+BX],AH
     L2:LODSB
        CMP AL,' '
        IF NE MOV [ES:DI-1],AL
        LODSB
        CMP AL,' '
        IF NE MOV [ES:DI-1+BX],AL
        CMP ROOM,5
        JNE >C3
        CMP VGA,0
        JE >C2
        ADD DI,BP
        NEG BP
        JS L1
        JMP >C3
     C2:
        CMP CL,6
        JA >C3
        MOV [ES:DI+1],AL
;        MOV AL,[ES:DI+2]
;        AND AL,0F0
;        OR AL,DL
;        MOV [ES:DI+2],AL
        MOV AH,[ES:DI+2]
        CALL NEW_CHR_COLOR
        MOV [ES:DI+2],AH
     C3:
        ADD DI,160
        LOOP C1
#ENDIF
   NOCB:
        CMP PROG_JUST_STARTED?,0
        IF NE JMP DONE_BAT
        MOV DI,LASTGOOD_AD
        CMP JUSTWON?,0
        IF E CALL PUTPL1   ; do again, so player won't blink
        CMP COPEN_CNT,0
        JNE >L0
        CMP BLINK_CTR,3
        JB >K0
     L0:
        CMP COPEN_CNT,-1
        IF E INC COPEN_CNT
        CALL ERAGATE
     K0:
;
        CMP JUSTWON?,0
        JE >Q1
        CALL WONFLASH
     Q1:
        CMP ROOMCOLOR,-1
        JNE >F3
; FLASHING ROOM!!!
        TEST LCNT,1
        JNZ >F3
        LDFLASHCOLOR DL
        MOV CL,4
        SHL DL,CL
        PUSH DS
        MOV AX,VIDSEG_MAIN
        MOV ES,AX
        MOV DS,AX
        MOV DI,0
        MOV SI,DI
        MOV CX,80*24
     F1:
        CMPSB     ;just increment both registers, to skip char byte
        LODSB    ;get attribute byte
        PUSH AX
        AND AL,0F0
        CMP AL,CAT
        POP AX
        JE >F2
        AND AL,0F  ;clear background color
        OR AL,DL  ;new color
     F2:STOSB
        LOOP F1
        POP DS
     F3:
; Objects
        MOV ES,AX,VIDSEG_MAIN
        MOV AX,ROOM
        CMP AX,[OBJECT+OSZ*n_SWORD]
        JNE >O2           ;   Sword
        CALL CHECKBLINK
        JZ >L1
        MOV SI,OBJECT
        CALL ERASE_OBJ
        JMP >O2
     L1:
        MOV DL,OBJ_COLOR[n_SWORD]  ;yellow
        CMP COLOR?,0
        IF E MOV DL,OBJ_COLORBW[n_SWORD]
        MOV DI,[OBJECT+OSZ*n_SWORD+2]
        CMP DI,160*24
        JAE >O2
        MOV AX,DI
        DIV v_160
        MOV DH,AH
        MOV SI,SWORD_STRING
        ADD SI,VGA
        MOV CX,2
     O0:
        PUSH CX,DX,DI,SI
        CMP DI,160*24
        JAE >P3
        MOV CX,4
     O1:
        LODSB
        MOV AH,[ES:DI+1]
        CALL NEW_CHR_COLOR
        CMP ROOMCOLOR,CAT
        JNE >P1
        PUSH SI
        MOV SI,DI
        CALL CHECKWALL_SI
        POP SI
        JNZ >P2
     P1:
        MOV [ES:DI],AX
     P2:
        ADD DI,2
        ADD DH,2
        CMP DH,160
        JAE >P3
        LOOP O1
     P3:
        POP SI
        ADD SI,4
        POP DI
        ADD DI,160
        POP DX
        POP CX
        LOOP O0
     O2:
        MOV SI,OBJECT+OSZ*n_KEY_YELLOW    ; Keys
     O3:
        MOV AX,ROOM
        CMP AX,[SI]
        JNE >L0
        CALL CHECKBLINK
        JZ >L1
        CALL ERASE_OBJ
     L0:JMP LONG >O5
     L1:
        MOV AX,SI
        SUB AX,OBJECT+OSZ*n_KEY_YELLOW
        MOV BL,OSZ
        DIV BL
        MOV BL,AL
        MOV BH,0
        MOV DL,CASTLEKEY_COLOR[BX]
        CMP COLOR?,0
        IF E MOV DL,CASTLEKEY_COLORBW[BX]
        CMP DL,-1
        JNE >L2
        LDFLASHCOLOR DL
     L2:MOV DI,LOC
        CMP DI,160*24
        JAE >O5
        MOV AX,DI
        DIV v_160
        MOV DH,AH
        MOV BX,KEY_STRING
        ADD BX,VGA
        MOV CX,4
     O4:
        MOV AH,[ES:DI+1]
        CALL NEW_CHR_COLOR
        MOV AL,[BX]
        CMP ROOMCOLOR,CAT
        JNE >P1
        PUSH SI
        MOV SI,DI
        CALL CHECKWALL_SI
        POP SI
        JNZ >P2
     P1:
        MOV [ES:DI],AX
     P2:
        ADD DI,2
        INC BX
        ADD DH,2
        CMP DH,160
        JAE >O5
        MOV AL,0CD
        LOOP O4
     O5:
        ADD SI,OSZ
        CMP SI,OBJECT+OSZ*(n_KEY_YELLOW+5)
        IF B JMP O3
        MOV AX,ROOM
        CMP AX,[OBJECT+OSZ*n_CHALICE]
        IF NE JMP LONG >O8   ; Chalice
        CALL CHECKBLINK
        JZ >L1
        MOV SI,OBJECT+OSZ*n_CHALICE
        CALL ERASE_OBJ
        JMP >O8
     L1:
        MOV SI,CHALICE_STRING
        ADD SI,VGA
        MOV DL,OBJ_COLORBW[n_CHALICE]
        CMP COLOR?,0
        IF NE LDFLASHCOLOR DL
        MOV DI,[OBJECT+(OSZ*n_CHALICE)+2]
        CMP DI,160*24
        JAE >O8
        MOV AX,DI
        DIV v_160
        MOV TEMPB,AH
        MOV CX,3
     O6:
        MOV DH,TEMPB
        MOV BL,4
     O7:
        MOV AH,[ES:DI+1]
        CALL NEW_CHR_COLOR
        LODSB
        CMP ROOMCOLOR,CAT
        JNE >P1
        PUSH SI
        MOV SI,DI
        CALL CHECKWALL_SI
        POP SI
        JNZ >P2
     P1:
        CMP DH,160
        JAE >P2
        CMP DI,160*24
        IF B MOV [ES:DI],AX
     P2:
        ADD DI,2
        ADD DH,2
        DEC BL
        JNZ O7
        ADD DI,152
        LOOP O6
     O8:
        MOV AX,ROOM
        CMP AX,[OBJECT+OSZ*n_BRIDGE]
        JE >L1
     J1:JMP DONE_BRIDGE
     L1:
        MOV DL,OBJ_COLOR[n_BRIDGE]       ;      Bridge
        CMP COLOR?,0
        IF E MOV DL,OBJ_COLORBW[n_BRIDGE]
        MOV DI,[OBJECT+OSZ*n_BRIDGE+2]
        CMP DI,160*24
        JAE J1
        CALL CHECKBLINK
        JZ >L2
        MOV SI,OBJECT+OSZ*n_BRIDGE
        CALL ERASE_OBJ
        JMP SHORT J1
     L2:
        MOV AX,DI
        DIV v_160
        MOV TEMPB,AH
        MOV AL,0DB
        MOV CX,6
     O9:
        CMP CX,6
        JE >O10
        CMP CX,1
        JNE >O11
    O10:
        MOV SI,DI
        CALL PUTOBJ_CHAR
        CMP TEMPB,158
        JAE >O13
        ADD SI,2
        CALL PUTOBJ_CHAR
    O11:
        CMP TEMPB,156
        JAE >O13
        LEA SI,[DI+4]
        CALL PUTOBJ_CHAR
        CMP TEMPB,154
        JAE >O13
        ADD SI,2
        CALL PUTOBJ_CHAR
        CMP TEMPB,136
        JAE >O13
        LEA SI,[DI+24]
        CALL PUTOBJ_CHAR
        CMP TEMPB,134
        JAE >O13
        ADD SI,2
        CALL PUTOBJ_CHAR
        CMP TEMPB,132
        JAE >O13
        CMP CX,6
        JE >O12
        CMP CX,1
        JNE >O13
    O12:
        ADD SI,2
        CALL PUTOBJ_CHAR
        CMP TEMPB,130
        JAE >O13
        ADD SI,2
        CALL PUTOBJ_CHAR
    O13:
        ADD DI,160
        CMP DI,160*24
        JAE >O14
        LOOP O9
    O14:
DONE_BRIDGE:
;Magnet
        MOV AX,ROOM
        CMP AX,[OBJECT+OSZ*n_MAGNET]
        JE >L0
     J1:JMP DONE_MAGNET
     L0:
        MOV DI,[OBJECT+OSZ*n_MAGNET+2]
        CMP DI,160*24
        JAE J1
        CALL CHECKBLINK
        JZ >K0
        MOV SI,OBJECT+OSZ*n_MAGNET
        CALL ERASE_OBJ
        JMP J1
     K0:
        MOV BX,MAGNET_STRING
        ADD BX,VGA
        MOV AX,DI
        DIV v_160
        MOV DL,OBJ_COLOR[n_MAGNET]
        CMP COLOR?,0
        IF E MOV DL,OBJ_COLORBW[n_MAGNET]
        MOV DH,AH
        CMP ROOMCOLOR,CAT
        JNE >K1
        MOV SI,DI
        CALL CHECKWALL_SI
        JNZ >L1
     K1:
        PUSH AX
        MOV AH,B[ES:DI+1]
        CALL NEW_CHR_COLOR
        MOV AL,[BX]
        MOV [ES:DI],AX
        POP AX
     L1:
        CMP DH,158
        JE >O15
        CMP ROOMCOLOR,CAT
        JNE >K2
        ADD SI,2
        CALL CHECKWALL_SI
        JNZ >L2
     K2:
        MOV AH,B[ES:DI+3]
        CALL NEW_CHR_COLOR
        MOV AL,[BX+1]
        MOV [ES:DI+2],AX
     L2:
        CMP DH,156
        JAE >O15
        CMP ROOMCOLOR,CAT
        JNE >K3
        ADD SI,2
        CALL CHECKWALL_SI
        JNZ >L3
     K3:
        MOV AH,[ES:DI+5]
        CALL NEW_CHR_COLOR
        MOV AL,[CS:BX+2]
        MOV [ES:DI+4],AX
     L3:
        CMP DH,154
        JAE >O15
        CMP ROOMCOLOR,CAT
        JNE >K4
        ADD SI,2
        CALL CHECKWALL_SI
        JNZ >O15
     K4:
        MOV AH,[ES:DI+7]
        CALL NEW_CHR_COLOR
        MOV AL,[CS:BX+3]
        MOV [ES:DI+6],AX
    O15:
        CMP DI,160*23
        JAE DONE_MAGNET
        CMP ROOMCOLOR,CAT
        JNE >K5
        LEA SI,[DI+0A0]
        CALL CHECKWALL_SI
        JNZ >L4
     K5:
        MOV AH,[ES:DI+0A1]
        CALL NEW_CHR_COLOR
        MOV AL,0DB
        MOV [ES:DI+0A0],AX
     L4:
        CMP DH,154
        JAE DONE_MAGNET
        CMP ROOMCOLOR,CAT
        JNE >K6
        ADD SI,6
        CALL CHECKWALL_SI
        JNZ DONE_MAGNET
     K6:
        MOV AH,[ES:DI+0A7]
        CALL NEW_CHR_COLOR
        MOV AL,0DB
        MOV [ES:DI+0A6],AX
DONE_MAGNET:
#IF REGISTERED
;Tokens
        MOV SI,OBJECT+OSZ*n_TOKEN1
    O16:
        MOV AX,ROOM
        CMP AX,[SI]
        JNE >O17
        CALL CHECKBLINK
        JZ >L1
        CALL ERASE_OBJ
        JMP >O17
     L1:
        CALL PUTTOKEN
    O17:
        ADD SI,OSZ
        CMP SI,OBJECT+OSZ*(n_TOKEN1+4)
        JB O16
;Whistle
        MOV ES,AX,VIDSEG_MAIN
        MOV AX,ROOM
        CMP AX,[OBJECT+OSZ*n_WHISTLE]
        JNE >O19
        CALL CHECKBLINK
        JZ >L1
        MOV SI,OBJECT+OSZ*n_WHISTLE
        CALL ERASE_OBJ
        JMP >O19
     L1:
        MOV DL,OBJ_COLOR[n_WHISTLE]       ;blue
        CMP COLOR?,0
        IF E MOV DL,OBJ_COLORBW[n_WHISTLE]
        MOV DI,[OBJECT+OSZ*n_WHISTLE+2]
        CMP DI,160*24
        JAE >O19
        MOV AX,DI
        DIV v_160
        MOV DH,AH
        MOV SI,WHISTLE_STRING
        ADD SI,VGA
        MOV CX,4
    O18:
        LODS B[CS:SI]
        MOV AH,[ES:DI+1]
        CALL NEW_CHR_COLOR
        CMP ROOMCOLOR,CAT
        JNE >P1
        PUSH SI
        MOV SI,DI
        CALL CHECKWALL_SI
        POP SI
        JNZ >P2
     P1:
        MOV [ES:DI],AX
     P2:
        ADD DI,2
        ADD DH,2
        CMP DH,160
        JAE >O19
        LOOP O18
     O19:
;Dot
        MOV AX,ROOM
        CMP AX,[OBJECT+OSZ*n_DOT]
        JNE >O40
        MOV DI,[OBJECT+OSZ*n_DOT+2]
        MOV DL,CAT SHR 4
        MOV AH,[ES:DI+1]
        CALL NEW_CHR_COLOR
        CALL CHECKBLINK
        MOV AL,0F9
        IF NZ MOV AL,020
        STOSW
    O40:
;Left-dot
        MOV AX,ROOM
        CMP AX,[OBJECT+OSZ*n_BDOT]
        JNE >O41
        MOV DI,[OBJECT+OSZ*n_BDOT+2]
        MOV DL,CAT SHR 4
        MOV AH,[ES:DI+1]
        CALL NEW_CHR_COLOR
        CALL CHECKBLINK
        MOV AL,7
        IF NZ MOV AL,020
        STOSW
    O41:
#ENDIF
;Game select number
        CMP ROOM,0
        IF E CALL PUTGAMENO
;Dragons
        MOV SI,DRAGON
        MOV ES,AX,VIDSEG_MAIN
     D1:
;        LEA DI,PL_AD[-2]
        LEA DI,LASTGOOD_AD[-2]
        MOV AX,[SI]
        CMP RDIF,0
        JE >A1
        CMP AX,[OBJECT]   ; if sword is present,
        JE DRG_FLEESWORD  ; then flee
     A1:CMP SI,DRAGON        ; For yellow dragon only:
        JNE >L0              ;
        CMP AX,[OBJECT+OSZ]  ; If in same room as yellow key,
        JE DRG_REPEL         ; then run away
     L0:
        MOV REPEL,0
        CMP AX,ROOM          ; player in the room?
        JE DRG_DOGEM
        LEA AX,[SI-DRAGON]
        MOV BL,DRSZ
        DIV BL
        CBW
        SHL AX,1
        MOV DI,AX
        MOV BX,OBJ_PRIORITY[DI]
        MOV AX,[SI]
     L1:
        MOV DL,[BX]
        MOV DH,0
        MOV DI,OBJECT
        ADD DI,DX
        CMP AX,[DI]        ; object to guard?
        JE DRG_DOGEM
        INC BX
        CMP B[BX],-1
        JB L1
        CMP SI,DRAGON
        JNE >A4                 ; only if yellow dragon...
        CALL RANDNUM
        TEST AX,0FF80     ; chance of helping another dragon
        JNZ >A4
        MOV CX,3                ; for other 3 dragons,
        LEA BP,OBJ_PRIORITY[2]  ; check to see if they're guarding something
        MOV AX,[SI]
     A2:
        MOV BX,[DS:BP]
     A3:
        MOV DL,[BX]
        MOV DH,0
        MOV DI,OBJECT
        ADD DI,DX
        CMP AX,[DI]
        JE DRG_DOGEM
        INC BX
        CMP B[BX],-1
        JB A3
        ADD BP,2
        LOOP A2
     A4:JMP DRG_NOTINRM
DRG_FLEESWORD:
        MOV DI,OBJECT
        JMP >A2
DRG_REPEL:
        MOV DI,OBJECT+OSZ  ;yellow key
     A2:MOV REPEL,-1
DRG_DOGEM:
        PUSH W[DI+2]
        MOV AX,ROOM
        CMP AX,[SI]
        IF NE JMP LONG >D3
        MOV CX,5
        MOV BX,DRAGON_STR1
        MOV DI,LOC
        TEST DI,08000  ; half-down?
        IF NZ MOV BX,DRAGON_STR2
        CMP DR_STATUS,BITING
        JL >L2
        MOV BX,DRAGON_BITE
        INC CX
     L2:
        CMP DR_STATUS,DEAD
        IF E MOV BX,DRAGON_CORPSE
        ADD BX,VGA
        CMP BX,VGA_DRAGON_STR2
        IF E INC CX
        AND DI,07FFF
        MOV AX,DI
        DIV v_160
        MOV DH,AH
     D2:
        CMP B[BX],020
        IF NE MOV B[ES:DI],020
        CMP DH,158
        JAE >L1
        CMP B[BX+1],020
        IF NE MOV B[ES:DI+2],020
        CMP DH,156
        JAE >L1
        CMP B[BX+2],020
        IF NE MOV B[ES:DI+4],020
        CMP DH,154
        JAE >L1
        CMP B[BX+3],020
        IF NE MOV B[ES:DI+6],020
     L1:
        ADD DI,160
        ADD BX,4
        CMP DI,160*24
        JAE >D3
        LOOP D2
     D3:
        POP BX
        CMP JUSTWON?,0
        JNE >J1
        PUSH BX
        CALL KILLDRAGON
        CALL BITE  ;check for player contact
        POP BX
;        CMP SWALLOWED,0
;        JE >L2
        CMP DR_STATUS,HAS_EATEN
        JNE >L2
     J1:JMP LONG >D7
     L2:
        CMP BAT_CARRYING,SI
        JE J1
        MOV AL,DR_STATUS
        CMP AL,HAS_EATEN
        JE J1
        DEC AL   ; to include DEAD
        CMP AL,BITING-1
        JGE J1
        MOV AX,LOC
        AND AH,07F
        DIV v_160
        MOV DX,AX
        MOV AX,BX  ; addr dragon is following
        DIV v_160
        MOV BP,2
        CMP SI,DRAGON+DRSZ*2
        IF AE SHL BP,1
        MOV TEMP,BP
;  if yellow dragon + yellow key, then switch so dragon will flee
        MOV W[SI+4],0
        CMP REPEL,0
        JE >L3
;        MOV BX,[SI]
;        CALL GETMAPADDR
        MOV REPEL,0
        CMP AH,DH     ; object left of dragon?
        JNB >R1       ; no
        MOV HINC,2    ; yes -- make dragon move right
        JMP >R2
     R1:
        JNA >R2       ; object right of dragon?
        MOV HINC,-2   ; yes -- make dragon move left
     R2:
        CMP AL,DL     ; object above dragon?
        JA >R5        ; no
        MOV VINC,1    ; yes -- make dragon move down
        JMP DRG_MOVE
     R5:
        MOV VINC,-1   ; object below dragon, so move up
        JMP DRG_MOVE
     L3:
;
        CMP AH,DH     ; object left of dragon?
        JNB >D4       ; no
        MOV HINC,-2   ; yes -- make dragon move left
        JMP >D5
     D4:
        JNA >D5       ; object right of dragon?
        MOV HINC,2    ; yes -- make dragon move right
     D5:
        CMP AL,DL     ; object above dragon?
        JA >D6        ; no
        JNE >L0       ; object directly left or right of dragon?
        JMP DRG_MOVE  ; yes
     L0:
        MOV VINC,-1   ; object above dragon, so make dragon move up
        JMP DRG_MOVE
     D6:
        MOV VINC,1    ; object below dragon, so make dragon move down
        JMP DRG_MOVE
DRG_NOTINRM:
        CMP DR_STATUS,DEAD
        JE >J2
        CMP DR_STATUS,HAS_EATEN
        JE >J2
        CMP DR_STATUS,BITING
        JL >D13
    J1: CALL DECBITE
    J2: JMP DRG_LOOPEND
     J3:
        CMP DR_STATUS,BITING
        JL J2
        JMP SHORT J1
    D13:
        CMP BAT_CARRYING,SI
        JE J2
;        CMP SWALLOWED,SI
        CMP DR_STATUS,HAS_EATEN
        JE J2
; randomly move dragon
        CALL RANDNUM
        TEST AX,0FF80
        JNZ DRG_MOVE
        MOV HINC,2       ; move right
        TEST AL,4        ; or...
        IF E NEG HINC    ; ...move left
        MOV VINC,-1      ; move up
        TEST AH,4        ; or...
        IF E NEG VINC    ; move down
DRG_MOVE:
        CMP JUSTWON?,0
        IF NE JMP LONG >D7
        MOV BX,[SI]
        CALL GETMAPADDR
        MOV CX,1
        CMP SI,DRAGON+DRSZ*2  ; red or blue dragon?
        IF AE INC CX          ; yes, so move twice as far
    D20:
        CMP HINC,0
        JE >D21
        MOV DH,0
        MOV AL,HINC
        CMP AL,0
        IF L MOV DH,158
        CBW
        ADD LOC,AX
        MOV AX,LOC
        AND AH,07F
        DIV v_160
        CMP AH,DH
        JNE >D21
        MOV AX,160
        CMP HINC,0
        PUSHF
        IF G NEG AX
        ADD LOC,AX
        MOV DI,BX
        POPF
        IF G ADD DI,2
        MOV BX,[DI]
        MOV [SI],BX
        CALL GETMAPADDR
    D21:
        LOOP D20
        CMP VINC,0
        JLE >D23
        CMP SI,DRAGON+DRSZ*2 ; red or blue?
        JAE >D22             ; yes, so can't move half a character-row
        XOR B[SI+3],080
        JS >D26
    D22:
        ADD LOC,160
        CMP LOC,160*24
        JB >D26
        SUB LOC,160*24
;        PUSH ES
        MOV AX,[SI]
        CALL GETROOMBELOW
;        MOV ES,CS
;        MOV DI,CASTLE_1STRM
;        MOV CX,5
;        REPNE SCASW
;        POP ES
;        JNE >L1
;        SUB DI,CASTLE_1STRM+2
;        SHR DI,1
;        CMP GATE[DI],0  ;gate open?
;        JNE >L0         ;yes
;        SHL DI,1
;        MOV AX,CASTLE_LOCKEDIN[DI]   ; no
;        JMP >D25
        JNZ >D25
     L0:MOV LOC,(15*160)+76
;     L1:
;        MOV AX,[BX+6]
        JMP >D25
    D23:
        JE >D26
        CMP SI,DRAGON+DRSZ*2 ;red/blue?
        JAE >D24
        XOR B[SI+3],080
        JNS >D26
    D24:
        MOV AX,LOC
        AND AH,07F
        SUB LOC,160
        SUB AX,160
        JNS >D26
        ADD LOC,160*24
        MOV AX,[BX+4]
    D25:
        MOV [SI],AX
    D26: ;JMP D7
D7:
        MOV AX,ROOM
        CMP AX,[SI]
        IF NE JMP LONG J3
        LEA AX,[SI-DRAGON]
        MOV BL,DRSZ
        DIV BL
        MOV BX,AX
        MOV DL,DRAGON_COLOR[BX]
        CMP COLOR?,0
        IF E MOV DL,DRAGON_COLORBW[BX]
        MOV CX,5
        MOV BX,DRAGON_STR1
        MOV DI,LOC
        TEST DI,08000
        IF NZ MOV BX,DRAGON_STR2
        CMP DR_STATUS,BITING
        JL >L3
        PUSHF
        CALL DECBITE
        POPF
        JE >L3
        MOV BX,DRAGON_BITE
        INC CX
     L3:
        CMP DR_STATUS,DEAD
        IF E MOV BX,DRAGON_CORPSE
        ADD BX,VGA
        CMP BX,VGA_DRAGON_STR2
        IF E INC CX
        CALL CHECKBLINK
        IF NZ JMP DRG_LOOPEND
        AND DI,07FFF
        MOV AX,DI
        DIV v_160
        MOV DH,AH
        PUSH SI
    D11:
        MOV AH,[ES:DI+1]
        CALL NEW_CHR_COLOR
        MOV SI,DI
        CMP ROOMCOLOR,CAT
        JNE >P1
        CALL CHECKWALL_SI
        JNZ >P2
     P1:
        MOV AL,[BX]
        CMP AL,020
        IF NE MOV [ES:DI],AX
     P2:
        CMP DH,158
        JAE >L1
        MOV AH,[ES:DI+3]
        CALL NEW_CHR_COLOR
        CMP ROOMCOLOR,CAT
        JNE >P1
        ADD SI,2
        CALL CHECKWALL_SI
        JNZ >P2
     P1:
        MOV AL,[BX+1]
        CMP AL,020
        IF NE MOV [ES:DI+2],AX
     P2:
        CMP DH,156
        JAE >L1
        MOV AH,[ES:DI+5]
        CALL NEW_CHR_COLOR
        CMP ROOMCOLOR,CAT
        JNE >P1
        ADD SI,2
        CALL CHECKWALL_SI
        JNZ >P2
     P1:
        MOV AL,[BX+2]
        CMP AL,020
        IF NE MOV [ES:DI+4],AX
     P2:
        CMP DH,154
        JAE >L1
        MOV AH,[ES:DI+7]
        CALL NEW_CHR_COLOR
        CMP ROOMCOLOR,CAT
        JNE >P1
        ADD SI,2
        CALL CHECKWALL_SI
        JNZ >L1
     P1:
        MOV AL,[BX+3]
        CMP AL,020
        IF NE MOV [ES:DI+6],AX
     L1:
        ADD DI,160
        ADD BX,4
        CMP DI,160*24
        JAE >D12
        LOOP >J0
    D12:
        POP SI
        JMP DRG_LOOPEND
    J0: JMP D11
DRG_LOOPEND:
        ADD SI,DRSZ
        CMP SI,DRAGON+DRSZ*4
        IF B JMP D1
