/*
** Test Speaker by Neil C. Obremski                           [ Magenta's Maze ]
** 2017 Gibdon Moon Productions                   [ http://magsmaze.gibdon.com ]
**
** This is free and unencumbered software released into the public domain.
**
** Anyone is free to copy, modify, publish, use, compile, sell, or
** distribute this software, either in source code form or as a compiled
** binary, for any purpose, commercial or non-commercial, and by any
** means.
**
** In jurisdictions that recognize copyright laws, the author or authors
** of this software dedicate any and all copyright interest in the
** software to the public domain. We make this dedication for the benefit
** of the public at large and to the detriment of our heirs and
** successors. We intend this dedication to be an overt act of
** relinquishment in perpetuity of all present and future rights to this
** software under copyright law.
**
** THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
** EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
** MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
** IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR
** OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
** ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
** OTHER DEALINGS IN THE SOFTWARE.
**
** Tested w/ DOSBox 0.74, Microsoft C 5.10
 */
#include <stdio.h>
#include <stdlib.h>

#include "mag-bios.h"
#include "mag-spkr.h"

void beep(void)
{
	sound(100, 2);
}

void main(int argc, char *argv[])
{
	int i;
	unsigned char far *sample;
	unsigned int loops, diff, hertz = 8000;
	char loopit = 0;

	#define int_arg(n,def) (argc > n ? ((argv[n][0] >= 48 && argv[n][0] <= 57) ? atoi(argv[n]) : def) : def)
	#define uint_arg(n,def) (argc > n ? (unsigned int)atol(argv[n]) : def)

	if (argc < 2 || !stricmp(argv[1], "PITWAIT")) {
		hertz = uint_arg(2, hertz);
		loops = pitwait((unsigned int)(1193180L / hertz), &diff);
		printf("pitwait(1193180 / %d = %u) = %u (%u)\n",
			hertz, (unsigned int)(1193180L / hertz), loops, diff);
		return;
	}

	if (!stricmp(argv[1], "SOUND")) {
		int frequency = int_arg(2, 100);
		int delay = int_arg(3, 2);
		sound(frequency, delay);
		return;
	} else if (!stricmp(argv[1], "SFX")) {
		initemb(exefn(argv[0], __FILE__));
		for (i = 0; embwav[i]; i++) {
			voice(embwav[i], hertz);
		}
		quitemb();
		return;
	}

	if (argc > 2) {
		hertz = uint_arg(2, hertz);
	}

	if (argc > 3 && !stricmp(argv[3], "LOOP")) {
		loopit = 1;
	}

	loops = pitwait((unsigned int)(1193180L / hertz), &diff);
	printf("pitwait(1193180 / %d = %u) = %u (%u)\n",
		hertz, (unsigned int)(1193180L / hertz), loops, diff);

	sample = loadsample(argv[1]);

	if (sample) {
		unsigned long ms = microsec(1);
		do {
			printf("Playing %s at %u HZ\n", argv[1], hertz);
			voice(sample, hertz);
		} while (loopit && 'q' != (char)getch());
		printf("Finished: %lu - %lu microseconds\n", ms, microsec(0));
	}

	_ffree(sample);
}
