/*
** Test Puzzles by Neil C. Obremski                           [ Magenta's Maze ]
** 2017 Gibdon Moon Productions                   [ http://magsmaze.gibdon.com ]
**
** This is free and unencumbered software released into the public domain.
**
** Anyone is free to copy, modify, publish, use, compile, sell, or
** distribute this software, either in source code form or as a compiled
** binary, for any purpose, commercial or non-commercial, and by any
** means.
**
** In jurisdictions that recognize copyright laws, the author or authors
** of this software dedicate any and all copyright interest in the
** software to the public domain. We make this dedication for the benefit
** of the public at large and to the detriment of our heirs and
** successors. We intend this dedication to be an overt act of
** relinquishment in perpetuity of all present and future rights to this
** software under copyright law.
**
** THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
** EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
** MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
** IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR
** OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
** ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
** OTHER DEALINGS IN THE SOFTWARE.
**
** Tested w/ DOSBox 0.74, Microsoft C 5.10
 */
#include <stdlib.h>
#include <stdio.h>
#include <conio.h>
#include <dos.h>
#include <math.h>

#include "mag-cga.h"
#include "mag-bios.h"
#include "mag-math.h"

#include "mag-3d.h"		/* need CGA before including */

#include "mag-puzz.h"

int main(int argc, char *argv[])
{
	int oldmode;
	int deg = 0, i = 0, x1, z1, x2, z2;
	int x = 0, z = 150;
	int r = 30, bigr = 90, r2 = 120;

	printf("Magic Size = %d bytes\n", sizeof(magic));

	if (argc > 1) {
		puzzle(argv[1], 1);
		printf("PLAYR: X=%d, Y=%d, FACING=%d\n",
			(int)pos.x, (int)pos.y, pos.facing);
		printf("MAGIC: X=%d, Y=%d, RAD=%d, ROT=%d\n",
			(int)magic.x, (int)magic.y, magic.radius, magic.rotation);
		printf("SEED: %u, SPELL: [%s]\n", magic.seed, magic.spell);
		printf("%s\n", magic.equation);
		return 0;
	}

	oldmode = screen(4);

	do {
		cls(BLACK);

		circley3d(x,-50,z, r, MAGENTA);

		for (i = 0; i < 3; i++) {
			x1 = x + MUL_SIN_DEG(r, deg);
			z1 = z + MUL_COS_DEG(r, deg);
			x2 = x + MUL_SIN_DEG(bigr, deg);
			z2 = z + MUL_COS_DEG(bigr, deg);

			liney3d(x1,z1, x2,z2, -50, CYAN);

			x1 = x + MUL_SIN_DEG(r2, deg);
			z1 = z + MUL_COS_DEG(r2, deg);

			circley3d(x1,-50,z1, r, WHITE);

			deg += 120;
			if (deg >= 360) {
				deg -= 360;
			}
		}

		deg += 10;
		if (deg >= 360) {
			deg -= 360;
		}

	} while ('q' != (char)getch());

	screen(oldmode);

	return 0;
}