/*
** Test Input & System by Neil C. Obremski                    [ Magenta's Maze ]
** 2017 Gibdon Moon Productions                   [ http://magsmaze.gibdon.com ]
**
** This is free and unencumbered software released into the public domain.
**
** Anyone is free to copy, modify, publish, use, compile, sell, or
** distribute this software, either in source code form or as a compiled
** binary, for any purpose, commercial or non-commercial, and by any
** means.
**
** In jurisdictions that recognize copyright laws, the author or authors
** of this software dedicate any and all copyright interest in the
** software to the public domain. We make this dedication for the benefit
** of the public at large and to the detriment of our heirs and
** successors. We intend this dedication to be an overt act of
** relinquishment in perpetuity of all present and future rights to this
** software under copyright law.
**
** THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
** EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
** MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
** IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR
** OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
** ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
** OTHER DEALINGS IN THE SOFTWARE.
**
** Tested w/ DOSBox 0.74, Microsoft C 5.10
*/
#include <conio.h>
#include <stdio.h>
#include <stdlib.h>

#include "mag-bios.h"
#include "mag-inp.h"

int testjoy(void);
int testkbd(void);

int main(int argc, char *argv[])
{
	if (argc < 2 || argv[1][0] == '?') {
		unsigned char far *psp = (unsigned char far*)((long)_psp<<16);
		char cmdline[0x80];
		char *wp = cmdline;

		memset(cmdline, 0, sizeof(cmdline));

		printf("System Information:\n");
		printf("8087 co-processor: %s\n", has8087() ? "TRUE" : "FALSE");
		printf("Tandy 1000:        %s\n", tandy1000() ? "TRUE" : "FALSE");
		printf("EXE (__FILE__):    %s\n", exefn(0, __FILE__));
		printf("EXE FILENAME:      %s\n", exefn(argv[0], __FILE__));
		printf("EXE (cached):      %s\n", exefn(0,0));
		printf("ARGV[0]:           %s\n", argv[0]);
		printf("Program Segment Prefix ...\n");
		puts("");
		psp += 0x81;
		while (wp < cmdline + 0x7F) {
			*wp++ = *psp++;
		}
		puts(cmdline);

	} else if (!stricmp(argv[1], "joystick")) {
		testjoy();
	} else if (!stricmp(argv[1], "keyboard")) {
		testkbd();
	} else if (!stricmp(argv[1], "getch")) {
		int key;
		do {
			key = getch();
			printf("0x%04X (%c)\n", key, (char)key);
		} while (key != (int)'q');
	} else if (!stricmp(argv[1], "action")) {
		int act;
		do {
			int mask = 0x80;
			act = action(1);
			while (mask) {
				putchar((act & mask) ? '1' : '0');
				mask >>= 1;
			}
			printf(" (0x%02X)\n", act);

		} while (!(act & ACT_ESC));
	} else {
		printf("Unrecognized input test: %s\n", argv[1]);
		return -1;
	}
	return 0;
}

int testjoy(void)
{
	unsigned charge;

	joystart(JOY_STICK1 | JOY_STICK2);

	if (JOY_MAX == joystick()) {
		joystart(JOY_STICK1);
		if (JOY_MAX == joystick()) {
			printf("No joystick found\n");
			return 1;
		}
	}

	while (!kbhit()) {
		locate(0,0);
		charge = joystick();
		printf("BASE: LO=%3d, HI=%3d, RANGE=%3d, START=%3d       \n",
			JOY_LO, JOY_HI, JOY_RANGE, JOY_START);
		printf("JOY1: LEFT=%d, RIGHT=%d, UP=%d, DOWN=%d (%4d,%4d) A=%d, B=%d\n",
			JOY_LEFT(JOY_X1), JOY_RIGHT(JOY_X1),
			JOY_UP(JOY_Y1), JOY_DOWN(JOY_Y1),
			JOY_X1, JOY_Y1, JOY_B1, JOY_B2);
		printf("JOY2: LEFT=%d, RIGHT=%d, UP=%d, DOWN=%d (%4d,%4d) A=%d, B=%d\n",
			JOY_LEFT(JOY_X2), JOY_RIGHT(JOY_X2),
			JOY_UP(JOY_Y2), JOY_DOWN(JOY_Y2),
			JOY_X2, JOY_Y2, JOY_B3, JOY_B4);
	}

	return 0;
}

int testkbd(void)
{
	int scancode = 0;

	/* slow down keyboard rate to prevent overfilling key buffer */
	typematic(TYPE_DELAY_SLOW, TYPE_REPEAT_SLOW);

	while (1 != (scancode >> 8)) {
		while (_bios_keybrd(_KEYBRD_READY)) {
			scancode = _bios_keybrd(_KEYBRD_READ);
			printf("KEY: 0x%x (code 0x%x)\n", (scancode>>8), scancode);
		}
	}

	/* restore keyboard rate */
	typematic(TYPE_DELAY_DEFAULT, TYPE_REPEAT_DEFAULT);

	return 0;
}
