/*
** Title & Logo Routines by Neil C. Obremski                  [ Magenta's Maze ]
** 2017 Gibdon Moon Productions                   [ http://magsmaze.gibdon.com ]
**
** This is free and unencumbered software released into the public domain.
**
** Anyone is free to copy, modify, publish, use, compile, sell, or
** distribute this software, either in source code form or as a compiled
** binary, for any purpose, commercial or non-commercial, and by any
** means.
**
** In jurisdictions that recognize copyright laws, the author or authors
** of this software dedicate any and all copyright interest in the
** software to the public domain. We make this dedication for the benefit
** of the public at large and to the detriment of our heirs and
** successors. We intend this dedication to be an overt act of
** relinquishment in perpetuity of all present and future rights to this
** software under copyright law.
**
** THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
** EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
** MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
** IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR
** OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
** ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
** OTHER DEALINGS IN THE SOFTWARE.
**
** Tested w/ DOSBox 0.74, Microsoft C 5.10
 */
#ifndef __MAG_LOGO
#define __MAG_LOGO

#include "mag-bios.h"
#include "mag-cga.h"
#include "mag-math.h"

void avatar(int, int);
void logo(int, int, int, int, unsigned);
int titles(void);

char logo_tri[] = {
	0,54, 15,54, 8,40,
	8,40, 15,54, 15,39,
	15,39, 3,39, 17,23,
	17,23, 24,32, 33,22,
	33,22, 5,28, 24,18,
	24,18, 5,28, 16,5,
	16,5, 15,20, 24,18,
	24,18, 37,0, 33,22,
	33,22, 37,0, 47,15,
	47,15, 51,22, 36,15,
	36,15, 45,21, 33,22,
	33,22, 33,41, 45,22,
	45,22, 36,15, 33,22,
	33,41, 53,40, 45,22,
	45,22, 58,39, 40,33,
	40,33, 50,34, 53,40,
	53,40, 33,41, 40,33,
	53,40, 63,57, 33,41,
	33,41, 63,57, 30,57,
};

unsigned char avat_tri[] = {
	40,11,
	48,15,
	55,24,
	57,33,
	57,46,
	53,54,
	45,58,
	49,60,
	53,66,
	67,102,	/* right arm */
	51,86,
	57,108,
	67,128,
	53,112,
	43,110,
	30,116,
	20,131,
	24,111,
	30,84,
	9,109, /* left arm */
	19,68,
	27,59,
	32,59,
	27,53,
	23,42,
	21,33,
	23,22,
	32,13,
};

unsigned char hood_tri[] = {
	39,32,
	44,54,
	48,46,
	49,38,
	50,22,
	47,15,
	40,12,
};

void avatar(int x, int y)
{
	int i;
	for (i = 2; i < sizeof(avat_tri); i+=2) {
		line(x+avat_tri[i-2], y+avat_tri[i-1],
			x+avat_tri[i+0], y+avat_tri[i+1],
			MAGENTA);
	}
	i -= 2;
	line(x+avat_tri[i], y+avat_tri[i+1],
		x+avat_tri[0], y+avat_tri[1],
		MAGENTA);
	for (i = 2; i < sizeof(hood_tri); i+=2) {
		line(x+hood_tri[i-2], y+hood_tri[i-1],
			x+hood_tri[i+0], y+hood_tri[i+1],
			MAGENTA);
	}
	/* circley3d(0,-50,100,30,MAGENTA); */
}

void logo(int x, int y, int scalex, int scaley, unsigned c)
{
	int i;

	border(0);

	for (i = 0; i < sizeof(logo_tri); i += 6) {
		trifill(x+logo_tri[i+0]*scalex, y+logo_tri[i+1]*scaley,
				x+logo_tri[i+2]*scalex, y+logo_tri[i+3]*scaley,
				x+logo_tri[i+4]*scalex, y+logo_tri[i+5]*scaley,
				c);
	}
}

/* render title screen and returns MILLISECONDS taken */
int titles(void)
{
	unsigned long ms = microsec(TRUE);
	cls(BLACK);
	logo(31,13, 4,3, MAGENTA);
	color(WHITE, MAGENTA);
	titleblit(88, 72, "MAGENTA'S MAZE", 14);
	tinyblit(160,190, "2017 Gibdon Moon Productions");

	return (int)((microsec(FALSE) - ms) / 1000);
}

#endif
