/*
** Cube Modeling by Neil C. Obremski                          [ Magenta's Maze ]
** 2017 Gibdon Moon Productions                   [ http://magsmaze.gibdon.com ]
**
** This is free and unencumbered software released into the public domain.
**
** Anyone is free to copy, modify, publish, use, compile, sell, or
** distribute this software, either in source code form or as a compiled
** binary, for any purpose, commercial or non-commercial, and by any
** means.
**
** In jurisdictions that recognize copyright laws, the author or authors
** of this software dedicate any and all copyright interest in the
** software to the public domain. We make this dedication for the benefit
** of the public at large and to the detriment of our heirs and
** successors. We intend this dedication to be an overt act of
** relinquishment in perpetuity of all present and future rights to this
** software under copyright law.
**
** THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
** EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
** MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
** IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR
** OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
** ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
** OTHER DEALINGS IN THE SOFTWARE.
**
** Tested w/ DOSBox 0.74, Microsoft C 5.10
 */
#ifndef __MAG_CUBE
#define __MAG_CUBE

#include "mag-3d.h"
#include "mag-map.h"

void model_cube(struct mesh *, int, int, int);
void model_panel(struct mesh *, int, int, int);
char tile_cube(char,char);

void model_cube(struct mesh *po, int w, int h, int d)
{
	reset(po, A_QUADB, BLACK, WHITE);

	/* front face */
	addquad(po, -w,h,-d, w,h,-d, w,-h,-d, -w,-h,-d);

	/* back face */
	addquad(po, w,h,d, -w,h,d, -w,-h,d, w,-h,d);

	/* top face */
	addquad(po, -w,h,d, w,h,d, w,h,-d, -w,h,-d);

	/* bottom face */
	addquad(po, -w,-h,-d, w,-h,-d, w,-h,d, -w,-h,d);

	/* left face */
	addquad(po, -w,h,d, -w,h,-d, -w,-h,-d, -w,-h,d);

	/* right face */
	addquad(po, w,h,-d, w,h,d, w,-h,d, w,-h,-d);

	normals(po);
}

void model_panel(struct mesh *po, int w, int h, int d)
{
	reset(po, A_QUADB, WHITE, BLACK);
	addquad(po, -w,-h,d, w,-h,d, w,-h,-d, -w,-h,-d);
	normals(po);
}

/* intializes a tree tile using models B=bottom, L=leaves, T=tree */
char tile_cube(char value, char lowdetail)
{
	struct mesh *cube = addmodel('C');
	char ch[2];
	ch[0] = value ? (char)(48 + value) : '\0';
	ch[1] = '\0';
	model_cube(cube, 20, 20, 20);

	if (lowdetail) {
		cube->a = A_QUADW;
		cube->stroke = WHITE;
		cube->fill = BLACK;
	}

	translate(cube, 0, -30, 0);
	return addtile(cube, 0, 0, (char)(value ? 48 + value : 'c'), ch, value);
}

#endif
