/*
 * This file is part of the Zmiy project.
 * Copyright (C) 2013 Mateusz Viste
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */


#ifndef LEVELS_H_SENTINEL
#define LEVELS_H_SENTINEL

enum snakedirenum {
  SNAKEDIR_UP,
  SNAKEDIR_RIGHT,
  SNAKEDIR_DOWN,
  SNAKEDIR_LEFT
};

enum gameexitstatus {
  EXITGAME_SUCCESS = 0,
  EXITGAME_GAMEOVER = 1,
  EXITGAME_ESCAPE = 2,
  EXITGAME_RESTART = 3
};

#define BLOCK_REFRESH_FLAG (1 << 8)
#define BLOCK_TYPE         (3 << 9)
#define BLOCK_VALUE        0xFF

enum blocktypes {
  BLOCK_EMPTY  = 0, /* note that ITEMS are in EMPTY blocks (but with a value) */
  BLOCK_WALL   = (1 << 9),
  BLOCK_SNAKE1 = (2 << 9),
  BLOCK_SNAKE2 = (3 << 9)
};

struct gamestruct {
  unsigned short playfield[80][50];
  int snakeposx[2];
  int snakeposy[2];
  int snakelen[2];
  int snakespeed[2];
  int level;
  long snakescore[2];
  enum snakedirenum snakedirection[2];
  int playfieldvoffset;
  int playfieldwidth;
  int playfieldheight;
};

void LoadLevel(struct gamestruct *game, int lev);
void PutItem(struct gamestruct *game, int itemnum);

#endif
