\LOADLBM.XPL	6-Jul-2012
\Load a 640x480x16 .LBM file into video memory
\Loren Blaney

\REVISIONS:
\SEP-29-94, Original.
\06-Jul-2012, Cleaned up code.

inc	C:\CXPL\CODESI.XPL;

int	CpuReg;			\Address of CPU register array (from GetReg)
def	AX, BX, CX, DX, DI, SI, BP, CF, CS, DS, SS, ES;		\GetReg regs
def	IntSize= 2;		\Number of bytes in an integer (2 or 4)

\===============================================================================

public proc LoadLBM(FileName);	\Load a 640x480x16 .LBM file into video memory
\Reference: Amiga ROM Kernel Reference Manual, p I-27.
\Palette registers must be aligned. This does not call AlignPalette so
\ that the palette registers can be set to 0, and the image can be loaded
\ without being displayed.
char	FileName;	\Name of file to load (path optional; .LBM required)
int	HaveBMHD,	\Flag: Bit map header chunk has been read in
	Width, Height, Depth,	\Image dimensions in pixels
	Compression,	\Compression algorithm used (0= none, 1=ByteRun1)
	Handle,		\Input file handle
	H0, H1, H2, H3;	\Header characters (e.g: "FORM")
seg addr VideoMem;	\Video memory segment address for VGA graphics ($A000)



proc	Fatal(Str);	\Display fatal error message and exit program
char	Str;
int	I;
begin
SetVid(3);		\Set text mode (and make sure colors are on)
Text(0,"
Oops, ");
Text(0, Str);
CrLf(0);
CrLf(0);
ChOut(0, $07);		\Bell
OpenI(1);		\Wait for keystroke in case we're running under Windows
repeat until ChkKey;
exit;
end;	\Fatal



func	HexWord;	\Read in 2 bytes and return the value of the word
return Swap(ChIn(3)) + ChIn(3);



proc	EatChunk;	\Read in and dispose of a chunk
int	CkSize, N, I;
begin
CkSize:= HexWord;			\Get chunk size; discard high word
CkSize:= (HexWord+1) & $FFFE;		\Every chunk is padded to an even length
for N:= 0, CkSize-1 do I:= ChIn(3);
end;	\EatChunk



proc	DoBMHD;		\Read in BitMap Header chunk
int	I, J,		\Scratch
	CkSize,		\Chunk size (bytes)
	XOffset, YOffset,
	Masking,	\The following parameters are read in but are not used
	Pad1,
	Transparent,
	XAspect, YAspect,
	PageWidth, PageHeight;
begin
CkSize:= HexWord;	\Get chunk size; discard high word
CkSize:= HexWord;

Width:= HexWord;	\Image width and height in pixels
Height:= HexWord;
XOffset:= HexWord;	\Offset (in pixels) for this image (not used here)
YOffset:= HexWord;
Depth:= ChIn(3);	\Number of bit planes (can be 0)
Masking:= ChIn(3);	\Masking technique ("no mask" is assumed here)
Compression:= ChIn(3);	\Compression algorithm (0=none, 1=byte run)
Pad1:= ChIn(3);		\(not used)
Transparent:= HexWord;	\Transparent color (only used with masking)
XAspect:= ChIn(3);	\Aspect ratio (1:1 is assumed here)
YAspect:= ChIn(3);
PageWidth:= HexWord;	\Source page size (not used here)
PageHeight:= HexWord;

HaveBMHD:= true;	\Indicate that essential BMHD chunk has been read in

\Skip remainder of chunk, if any
CkSize:= (CkSize+1) & $FFFE;	\Every chunk is padded to an even length
for I:= 20, CkSize-1 do J:= ChIn(3);
end;	\DoBMHD



proc	DoCMAP;		\Color Map, set up color registers
int	CkSize,		\Number of bytes in CMAP field
	ColRegs,	\Number of color registers to use
	N,
	R, G, B;
begin
CkSize:= HexWord;	\Get chunk size; discard high word
CkSize:= HexWord;
ColRegs:= CkSize /3;
if ColRegs >256 then ColRegs:= 256;	\Limit maximum number of color registers

for N:= 0, ColRegs-1 do
	begin
	R:= ChIn(3)>>2;   G:= ChIn(3)>>2;   B:= ChIn(3)>>2;
	CpuReg(AX):= $1010;		\Function $10, subfunction $10
	CpuReg(BX):= N;			\Select color register
	CpuReg(CX):= G<<8 ! B&$ff;	\Green<<8 blue
	CpuReg(DX):= R<<8;		\Red<<8
	SoftInt($10);			\Call BIOS routine
	end;

\Eat remainder of chunk, if any. Every chunk is padded to an even length.
CkSize:= (CkSize+1) & $FFFE;
for N:= ColRegs*3, CkSize-1 do R:= ChIn(3);
end;	\DoCMAP

\-------------------------------------------------------------------------------

proc	DoBODY;		\Image data
int	Wid,		\Image Width in bytes (and rounded up to next word)
	Y,		\Vertical scan line in pixels (0..HEIGHT-1)
	D,		\Bit plane depth (0..DEPTH-1)
	CkSize;
int	J,		\Index into VideoMem
	X,		\Horizontal position (0..Width-1)
	X1;



proc	DoLine;		\Read a single line for one bit plane (compressed data)
int	N,		\Byte from input file
	M,		\Byte to replicate
	End;		\Last byte in VideoMem for line (+1)
begin
End:= J +Wid;
repeat	N:= ChIn(3);
	if N <= $7F then
		begin			\Copy the next N+1 bytes literally
		X:= J;   X1:= J +N +1;
		repeat	VideoMem(0, X):= ChIn(3);
			X:= X +1;
		until X = X1;
		J:= X;
		end
	else if N = $80 then []		\Ignore
	else	begin			\N is in the range: $81..$FF
		\Replicate the next byte -Extend(N)+1 times
		M:= ChIn(3);		\Read next byte
		X:= J;   X1:= J -Extend(N) +1;
		repeat	VideoMem(0, X):= M;
			X:= X +1;
		until X = X1;
		J:= X;
		end;
until J = End;
end;	\DoLine



begin	\DoBODY
if ~HaveBMHD then Fatal("^"BMHD^" is missing.");

CkSize:= HexWord;
CkSize:= HexWord;

Wid:= Width /8;		\Width in bytes
for Y:= 0, Height-1 do
	begin
	for D:= 0, Depth-1 do
		begin
		POut(2, $3C4, 0);	\Enable appropriate bit plane
		POut(1<<D, $3C5, 0);
		J:= Y *Wid;
		if Compression then
			DoLine
		else	begin		\Read in a scan line
			X:= J;   X1:= J +Wid;
			repeat	VideoMem(0, X):= ChIn(3);
				X:= X +1;
			until X = X1;
			end;
		end;
	end;

POut(2, $3C4, 0);	\Enable all planes
POut($0F, $3C5, 0);
end;	\DoBODY

\-------------------------------------------------------------------------------

begin	\LoadLBM
VideoMem:= Reserve(IntSize);
VideoMem(0):= $A000;

HaveBMHD:= false;
Handle:= FOpen(FileName, 0);		\Open file for input
FSet(Handle, ^I);
OpenI(3);

if ChIn(3)=^F & ChIn(3)=^O & ChIn(3)=^R & ChIn(3)=^M then
	begin
	H0:= HexWord;   H0:= HexWord;	\Skip past FORM size
	if ChIn(3)#^I ! ChIn(3)#^L ! ChIn(3)#^B ! ChIn(3)#^M then
		Fatal("^"ILBM^" is missing.")
	end
else Fatal("file did not start with ^"FORM^".");

\WARNING: BODY is assumed to be the last chunk in the file.
\ If BODY is missing this will read beyond the end of the input file.
loop	begin
	\Read chunk header
	H0:= ChIn(3);   H1:= ChIn(3);   H2:= ChIn(3);   H3:= ChIn(3);
	     if H0=^B & H1=^M & H2=^H & H3=^D then DoBMHD
	else if H0=^C & H1=^M & H2=^A & H3=^P then DoCMAP
	else if H0=^B & H1=^O & H2=^D & H3=^Y then [DoBODY;   quit]
	else EatChunk;		\Ignore any unrecognized chunks
	end;
end;	\LoadLBM
