\WINDOZE.XPL	JUL-20-95
\Falling Icons Game by Lenny Boreal
\Based on code by Loren Blaney

\REVISIONS:
\OCT-03-94, Original.
\JUL-20-95, Modified for version 2.3 XPL (standard library definitions changed).

def	AX, BX, CX, DX, DI, SI, BP, CF, CS, DS, SS, ES;	\Getreg Cpureg names

inc	\CXPL\STDDEF.XPL; \Include library routines and standard definitions
eproc	LoadLBM;	\Load 640x480x16 .LBM file
ext	MovImage;	\Move Image (X0, Y0, X1, Y1, Width, Height)
ext	SetPal;		\Set Palette Registers from array of 16 values

\Coordinates of upper-left corner of graphic images:
def	SourceX=0, SourceY=480,		\Source for icon images (video page 2)
	FieldX=224, FieldY=41,		\Playfield inside icon window
	ViewX=160, ViewY=41;		\Preview window
def	ScoreX=63, ScoreY=8,		\Score window (character coords)
	PointsX=63, PointsY=14,		\Points window
	HiScoreX=23, HiScoreY=9;	\Hall-of-Fame window
def	VGA2YMax=338;			\Maximum Y value on 2nd VGA page
def	FieldWidth=6, FieldHeight=13;	\Playfield dimensions in 32x32-pixel cells
def	WildIcon= 7;			\Symbol number of wild icon
def	DemoDelay=20;			\Seconds before automatic key stroke

int	DataSeg,	\Data segment address that this program executes from
	Dropping,	\Flag: Drop fast
	DoSound,	\Flag: Sound on/off (S key)
	Field,		\Playfield Array(Width,Height)
	GroupX, GroupY,	\Cell coordinates of top of 3-icon Group within Field
	Mark,		\Array to mark icons to be removed from Field
	Mode,		\Initial video mode to be restored upon exit
	Points,		\Score for current group
	Score,		\Total accumulative score
	Speed,		\Speed of play (larger is slower)
	SpeedTable,	\Table of speeds (determines speed of falling objects)
	Step,		\Step size (in pixels) of falling objects
	StepTable,	\Table of step sizes (Step also affects speed of falling)
	TableMax,	\Maximum index of above tables
	II;		\Scratch for Main
char	Group;		\Array: Contents of falling 3-icon Group
char	FontTable;	\8x14 font, for 256 characters
def	FontSize=256*16;\Space required for 8x16 font
char	Palette;	\Array: copy of palette registers (0-15)



proc	Exit;		\Make a graceful exit
begin
SetVid(Mode);		\Restore original video mode
Text(0, "
Thanks for playing Windoze!

");
exit;
end;	\Exit



proc	Click;		\Make a click sound
begin
Sound(false, 1, 300);	\Sync to system clock so click always sounds the same
Sound(DoSound, 1, 300);
end;	\Click



proc	MovClipImage(X0, Y0, X1, Y1, W, H);
\MovImage with clipping above FieldY
int	X0, Y0, X1, Y1, W, H;
int	C;
begin
C:= FieldY -Y1;		\Amount to clip off at top of field
if C < 0 then C:= 0;
if H-C > 0 then
	MovImage(X0, Y0+C, X1, Y1+C, W, H-C);
end;	\MovClipImage



proc	CyclePalette;	\Periodically cycle palette registers
\This is called every vertical blank.
int	C, T, N;
begin
return;
C:= [0];		\Set up 'static' type variable
if C(0) < 6 then [C(0):= C(0) +1;   return];
C(0):= 0;

\Cycle registers 3 through 11:
T:= Palette(3);
for N:= 3, 11-1 do
	Palette(N):= Palette(N+1);
Palette(11):= T;
SetPal(Palette);	\Call assembly routine to set registers (BIOS is too slow)
end;	\CyclePalette



proc	Fatal(Str);	\Fatal error handler: Display message and exit program
addr	Str;
int	I;
begin
SetVid(Mode);		\Restore original video mode
Text(0,"
Oops, ");
Text(0, Str);
Crlf(0);
Crlf(0);
Chout(0, Bel);
WaitKey;		\In case it's run from Windows
exit;
end;	\Fatal

\======================================================================

proc	LoadFont;	\Load the font table
\This loads a 14-byte-high font and kludges it into a standard 16-byte-high font
int	H, I, Ch, L;
begin
Trap(false);
H:= Fopen("WINDOZE.F14", 0);
Fset(H, ^I);
Openi(3);
if Geterr then Fatal("I can't find WINDOZE.F14 file.");
Trap(true);

I:= 0;					\Index into font table
for Ch:= 0, 255 do			\For 256 characters...
	begin
	for L:= 0, 14-1 do		\14 bytes per character
		[FontTable(I):= Chin(3);   I:= I +1];
	FontTable(I):= 0;   I:= I +1;	\Kludge on two blank bytes
	FontTable(I):= 0;   I:= I +1;
	end;
FontTable($DB*16+14):= $FF;		\Fix up block character $DB
FontTable($DB*16+15):= $FF;		\ (required for background colors)

Fclose(H);
end;	\LoadFont



proc	GetFld(Field, N, X, Y);	\Input a field (string) of chars
char	Field;	\Address of field
int	N,	\Number of characters in field
	X, Y;	\Field position on screen
int	Ch,
	M,	\Maximum index of Field
	I, J;
begin
M:= N -1;
\Fill field with underlines. Unused spaces in the field are converted to
\ underlines, which are converged from both ends.
I:= 0;   while Field(I)=SP & I<=M do [Field(I):= ^_;   I:= I +1];
I:= M;   while Field(I)=SP & I>=0 do [Field(I):= ^_;   I:= I -1];

J:= 0;				\Our position in the field
loop	begin
	Cursor(X, Y);		\Display what we have
	TextN(6, Field, N);

	Attrib($9F\Red\);	\Use background color to make a cursor for
	Cursor(X+J, Y);		\ a graphic display mode
	Chout(6, Field(J));
	Ch:= GetKey;		\Wait for keystroke
	Attrib($F9\Red\);	\Turn cursor off (background is bright white)
	Cursor(X+J, Y);
	Chout(6, Field(J));

	case Ch of
	  -LfArrow,-UpArrow:if J > 0 then J:= J -1;
	  -RtArrow,-DnArrow:if J < M then J:= J +1;
	  -Home:J:= 0;
	  -End:	J:= M;
	  FF:	[for I:= 0, M do Field(I):= ^_;	\Clear the entire field
		J:= 0];				\Our position in the field
	  -Delete:
		begin
		for I:= J, M-1 do		\Shift field left
			Field(I):= Field(I+1);
		Field(M):= ^_;
		end;
	  BS:	begin
		if J > 0 then
			[J:= J -1;
			for I:= J, M-1 do	\Shift field left
				Field(I):= Field(I+1);
			Field(M):= ^_];
		end;
	  CR:	quit;
	  Esc:	quit
	other	begin
		if Ch >= $20 then		\Ignore control chars
			begin
			for I:= -(M-1), -J do	\Shift rest of line right
				Field(-I+1):= Field(-I);
			Field(J):= Ch;
			if J < M then J:= J +1;	\Move cursor right
			end;
		end;
	end;

J:= 0;				\Put spaces back in place of underlines
while J<=M & Field(J)=^_ do [Field(J):= SP;	J:= J +1];
J:= M;
while J>=0 & Field(J)=^_ do [Field(J):= SP;	J:= J -1];

Cursor(X, Y);			\Re-display field without underlines
TextN(6, Field, N);
end;	\GetFld



proc	Explode(X0, Y0, X1, Y1, Steps, W, H);	\Explode a window
int	X0, Y0, X1, Y1, Steps, W, H;
int	SW, SH, SX0, SY0, SX1, SY1, S;
begin
for S:= 1, Steps do
	begin
	SW:= S *W /Steps;
	SH:= S *H /Steps;
	SX0:= X0 + (W-SW)/2;
	SY0:= Y0 + (H-SH)/2;
	SX1:= X1 + (W-SW)/2;
	SY1:= Y1 + (H-SH)/2;
	WaitVB;
	MovImage(SX0, SY0, SX1, SY1, SW, SH);
	end;
end;	\Explode

\----------------------------------------------------------------------

proc	HighScores;	\Show high scores (Hall of Fame)
\Inputs Score
def	ListSize=10,	\Number of items in list
	NameSize=20;	\Number of characters allowed for name
int	ListScore,	\Array
	ListName;	\Array
int	H, I, J, K;
char	Str;
begin
ListScore:= Reserve(ListSize*IntSize);
ListName:= Reserve(ListSize*IntSize);
for I:= 0, ListSize-1 do
	ListName(I):= Reserve(NameSize);

\Show list with new score (if any) in its place
for I:= 0, 16-1 do Palette(I):= I;	\Restore colors after cycling
SetPal(Palette);
Explode(0, 480+51, HiScoreX*8, HiScoreY*16-3, 8, 272, 226);

\Read list from disk
Trap(false);
H:= Fopen("WINDOZE.DAT", 0);
Fset(H, ^I);
Openi(3);
if Geterr then Fatal("I can't find WINDOZE.DAT file.");
Trap(true);
for I:= 0, ListSize-1 do
	begin
	ListScore(I):= Intin(3);
	Str:= ListName(I);
	for J:= 0, NameSize-1 do
		Str(J):= Chin(3);
	end;
Fclose(H);

\Scan down for first entry that is less than or equal to Score
K:= -1;
for I:= 0, ListSize-1 do
    if ListScore(I) <= Score then	\If on list then insert new score
	begin
	Str:= ListName(ListSize-1);	\Save pointer to new name at bottom of list
	for J:= -(ListSize-2), -I do	\Shift existing scores down one
		[ListScore(1-J):= ListScore(-J);
		ListName(1-J):= ListName(-J)];
	ListScore(I):= Score;
	ListName(I):= Str;
	StrNFill(Str, NameSize, ^_);
	K:= I;				\Save index to new entry
	I:= ListSize;			\Exit 'for' loop
	end;

for J:= 0, ListSize-1 do
	begin
	Attrib(if J = K then BWhite<<4!9\Red\ else BWhite<<4!Black);
	Cursor(HiScoreX+2, HiScoreY+2+J);
	Justout(6, ListScore(J), 5, Sp);
	Cursor(HiScoreX+9, HiScoreY+2+J);
	TextN(6, ListName(J), NameSize);
	end;

\Get player's name if Score was added to the list
if K >= 0 then
	begin
	Attrib(BWhite<<4!9\Red\);
	GetFld(Str, NameSize, HiScoreX+9, HiScoreY+2+K);

	\Write list to disk
	H:= FOPEN("WINDOZE.DAT", 1);
	Fset(H, ^O);
	Openo(3);
	for I:= 0, ListSize-1 do
		begin
		Intout(3, ListScore(I));
		Chout(3, Sp);
		Str:= ListName(I);
		for J:= 0, NameSize-1 do
			Chout(3, Str(J));
		Crlf(3);
		end;
	Close(3);
	Fclose(H);
	end
else	begin				\Wait for keystroke
	Openi(1);
	I:= 60 *DemoDelay;
	loop	begin
		WaitVB;
		if Chkkey then
			if GetKey = Esc then Exit else quit;
		I:= I -1;
		if I <= 0 then quit;
		end;
	end;
end;	\HighScores

\----------------------------------------------------------------------

proc	GameOver;	\Drop "Game Over" sign
int	I, Y;
\Game Over sign is 128x128 and located at: 304, 480+52
begin
MovImage(FieldX+32, FieldY, 432, FieldY+480, 128, VGA2YMax+1-FieldY); \Save bkgnd

for Y:= FieldY-128, FieldY+(FieldHeight-4)*32 do
	begin
	MovClipImage(432, Y-Step+480, FieldX+32, Y-Step, 128, Step); \Show bkgnd
	MovClipImage(304, 480+52, FieldX+32, Y, 128, 128);	\Show Game Over

	if Chkkey then
		if GetKey = Esc then Exit;

	for I:= 1, Speed do [WaitVB;   CyclePalette];
	Y:= Y +Step -1;
	end;
Click;
\[OK]
MovImage(336, 480+185, FieldX+64, FieldY+(FieldHeight-4)*32+85, 64, 29);

Openi(1);
I:= 60 *DemoDelay;
loop	begin
	WaitVB;				\Wait for keystroke while cycling colors
	CyclePalette;
	if Chkkey then
		if GetKey = Esc then Exit else quit;
	I:= I -1;
	if I <= 0 then [Score:= -1;  quit];	\Make sure not a high score
	end;
end;	\GameOver

\======================================================================

proc	ShowScore;	\Show total Score
begin
Cursor(ScoreX, ScoreY);
Attrib(BWhite<<4!Black);
Justout(6, Score, 5, Sp);
end;	\ShowScore



proc	ShowPoints;	\Show Points for current move
begin
Cursor(PointsX, PointsY);
Attrib(BWhite<<4!Black);
Justout(6, Points, 5, Sp);
end;	\ShowPoints

\----------------------------------------------------------------------

func	Fall;		\If there is nothing under an icon, it falls
int	Fell,		\Returned flag: Something fell
	I, J, L, Y;
int	Falling;	\Array to mark icons that are falling
begin
Falling:= Reserve(FieldWidth*Intsize);
for I:= 0, FieldWidth-1 do
	begin
	Falling(I):= Reserve(FieldHeight*Intsize);
	for J:= 0, FieldHeight-1 do Falling(I,J):= 0;
	end;

\Scan entire Field for a icon with nothing under it
Fell:= false;
for J:= -(FieldHeight-2), 0 do			\Scan from the bottom up because
    for I:= 0, FieldWidth-1 do			\ icons are moved down
	begin
	L:= Field(I,-J);
	if L#0 & Field(I,1-J)=0 then
		begin
		Fell:= true;			\Indicate that something fell
		Field(I,1-J):= L;		\Move icon down
		Field(I,-J):= 0;
		Falling(I,-J):= L;		\Mark icon that is falling
		end;
	end;

if Fell then
	begin			\Move image down for each icon that is falling
	for Y:= 0, 31 do
		begin
		for J:= -(FieldHeight-2), 0 do	\Scan from the bottom up
		    for I:= 0, FieldWidth-1 do
			begin
			L:= Falling(I,-J);
			if L # 0 then
				begin		\Show falling icon
				MovClipImage(SourceX, SourceY, FieldX+I*32,
					FieldY-J*32+Y, 32, Step);	\Blank
				MovClipImage(SourceX+32*L, SourceY, FieldX+I*32,
					FieldY-J*32+Y+Step, 32, 32);	\icon
				end;
			end;

		if Chkkey then
			if GetKey = Esc then Exit;

		for I:= 1, Speed do [WaitVB;   CyclePalette];
		Y:= Y +Step -1;
		end;	\for
	end;

return Fell;
end;	\Fall

\----------------------------------------------------------------------

proc	Remove;		\Remove marked icons
int	I, J, K, L;
begin
for K:= -5, -1 do			\Flash icons about to be removed
	begin
	for J:= 0, FieldHeight-1 do	\Flash icons off
	    for I:= 0, FieldWidth-1 do
		if Mark(I,J) then
		    MovClipImage(SourceX, SourceY, FieldX+I*32, FieldY+J*32, 32, 32);

	Sound(DoSound, 1, -3000*K);
	for J:= 0, FieldHeight-1 do	\Flash icons on
	    for I:= 0, FieldWidth-1 do
		if Mark(I,J) then
		    begin
		    L:= Field(I,J);
		    MovClipImage(SourceX+32*L, SourceY, FieldX+I*32,
		    	FieldY+J*32, 32, 32);
		    end;
	Sound(DoSound, 1, -150*K);
	end;

for J:= 0, FieldHeight-1 do		\Remove marked locations
    for I:= 0, FieldWidth-1 do
	if Mark(I,J) then
	    begin
	    Field(I,J):= 0;
	    MovClipImage(SourceX, SourceY, FieldX+I*32, FieldY+J*32, 32, 32);
	    end;
end;	\Remove



proc	Wild(L);	\Mark icons for removal that were hit by wild group
int	L;		\Character that the wild group hit (=0 if none)
int	I, J;
begin
for J:= 0, FieldHeight-1 do
    for I:= 0, FieldWidth-1 do
	if Field(I,J) = L then
		[Mark(I,J):= true;		\Mark for removal
		Points:= Points +10]
	else	Mark(I,J):= false;

for J:= 0, 2 do Mark(GroupX,GroupY+J):= true;	\Mark wild group for removal
Points:= Points +30;
ShowPoints;
Remove;
end;	\Wild



proc	Check;	\Check for 3 or more icons in a row: up, down, and diagonally
		\ remove them, and tally points
int	P0,	\Initial points (determines if there were 3 or more in a row)
	I, J, L;
begin
P0:= Points;					\Save initial Points

for I:= 0, FieldWidth-1 do			\Initialize mark-for-removal array
	for J:= 0, FieldHeight-1 do
		Mark(I,J):= false;

for J:= 0, FieldHeight-1 do			\3 in row horizontally? -
    for I:= 0, FieldWidth-3 do
	begin
	L:= Field(I,J);				\Get icon type
	if L # 0 then
	    if Field(I+1,J)=L & Field(I+2,J)=L then
		begin
		Points:= Points +30;		\Tally points
		Mark(I,J):= true;		\Mark for removal
		Mark(I+1,J):= true;
		Mark(I+2,J):= true;
		end;
	end;

for J:= 0, FieldHeight-3 do			\3 in row diagonally? \
    for I:= 0, FieldWidth-3 do
	begin
	L:= Field(I,J);
	if L # 0 then
	    if Field(I+1,J+1)=L & Field(I+2,J+2)=L then
		begin
		Points:= Points +30;
		Mark(I,J):= true;
		Mark(I+1,J+1):= true;
		Mark(I+2,J+2):= true;
		end;
	end;

for J:= 0, FieldHeight-3 do			\3 in row vertically? |
    for I:= 0, FieldWidth-1 do
	begin
	L:= Field(I,J);
	if L # 0 then
	    if Field(I,J+1)=L & Field(I,J+2)=L then
		begin
		Points:= Points +30;
		Mark(I,J):= true;
		Mark(I,J+1):= true;
		Mark(I,J+2):= true;
		end;
	end;

for J:= 0, FieldHeight-3 do			\3 in row diagonally? /
    for I:= 2, FieldWidth-1 do
	begin
	L:= Field(I,J);
	if L # 0 then
	    if Field(I-1,J+1)=L & Field(I-2,J+2)=L then
		begin
		Points:= Points +30;
		Mark(I,J):= true;
		Mark(I-1,J+1):= true;
		Mark(I-2,J+2):= true;
		end;
	end;

if Points # P0 then				\Got some points?
	[ShowPoints;   Remove];
end;	\Check

\----------------------------------------------------------------------

proc	MoveGroup;	\Move a 3-icon group down one cell (32 pixels)
int	I, J, T, Y;
begin
Y:= 0;
loop	begin
	for J:= 0, 2 do					\Erase 3-icon group
		begin					\ (because it may jump
		if GroupY+J >= 0 then			\ to another column)
			Field(GroupX,GroupY+J):= 0;
		MovClipImage(SourceX, SourceY, FieldX+GroupX*32,
			FieldY+(GroupY+J)*32+Y, 32, 32);
		end;

	if Chkkey then
		begin
		case GetKey of					\Key command
		  ^J,^j,^4,-LfArrow:
			begin					\Left
			if GroupX > 0 &
			   Field(GroupX-1,GroupY+3) = 0 then
				GroupX:= GroupX -1;
			end;
		  ^L,^l,^6,-RtArrow:
			begin					\Right
			if GroupX < FieldWidth-1 &
			   Field(GroupX+1,GroupY+3) = 0 then
				GroupX:= GroupX +1;
			end;
		  ^K,^k,^5,-UpArrow:
			begin					\Rotate
			T:= Group(2);
			Group(2):= Group(1);
			Group(1):= Group(0);
			Group(0):= T;
			end;
		  ^I,^i,^8:
			begin					\Flip
			T:= Group(0);
			Group(0):= Group(2);
			Group(2):= T;
			end;
		  Sp,^0,^2,-DnArrow:
			Dropping:= true;			\Drop
		  ^S, ^s:
			DoSound:= not DoSound;
		  Esc:
			Exit
		other	Click;
		end;

	Y:= Y +Step;
	if Dropping then
		Y:= if Y < 16 then 16 else 32;

	for J:= 0, 2 do				\Draw 3-icon group at new location
		begin
		if GroupY+J >= 0 then
			Field(GroupX,GroupY+J):= Group(J);
		MovClipImage(SourceX+32*Group(J), SourceY, FieldX+GroupX*32,
			FieldY+(GroupY+J)*32+Y, 32, 32);
		end;

	WaitVB;   CyclePalette;
	if ~Dropping then
	    for I:= 2, Speed do
		[WaitVB;   CyclePalette];

	if Y >= 32 then quit;
	end;	\loop

\Put 3-icon group at new location
if GroupY >= 0 then
	Field(GroupX,GroupY):= 0;
GroupY:= GroupY +1;
for J:= 0, 2 do
    if GroupY+J >= 0 then
	Field(GroupX,GroupY+J):= Group(J);
end;	\MoveGroup

\----------------------------------------------------------------------

proc	PlayGame;	\Play one round of the game
char	PGroup;		\Array: 3-icon Preview Group
int	I, J;
begin
PGroup:= Reserve(3);

for J:= 0, FieldHeight-1 do			\Clear play field
    for I:= 0, FieldWidth-1 do
	Field(I,J):= 0;

Score:= 0;   ShowScore;
Points:= 0;   ShowPoints;

for J:= 0, 2 do Group(J):= Ran(6) +1;		\Generate initial group

loop	begin					\Main game loop
	\The higher the score, the faster it goes
	I:= Score/1000;
	if I > TableMax then I:= TableMax;
	Speed:= SpeedTable(I);
	Step:= StepTable(I);

	\Generate next group and show it for preview
	if Group(0) # WildIcon then
	    for J:= 0, 2 do
		begin
		PGroup(J):= Ran(6) +1;
		MovClipImage(SourceX+32*PGroup(J), SourceY, ViewX, ViewY+32*J,
			32, 32);		\X0, Y0, X1, Y1, Width, Height
		end;

	GroupX:= Ran(FieldWidth);		\Start group falling
	GroupY:= -3;
	Dropping:= false;
	Points:= 0;
	Openi(1);

	loop	begin
		if Field(GroupX,GroupY+3) \#0\ then quit; \Group hit something
		if GroupY+3 >= FieldHeight then quit;	  \Group hit bottom
		MoveGroup;				  \Fall 32 pixels
		if Dropping then			  \ (= 1 cell)
			[Points:= Points +5;		  \Points for fast fall
			ShowPoints];
		end;
	Click;						\Sound for hitting something

	\Fall at a moderate speed
	if Score < 5000 then				\But don't go slower than
		begin					\ the rest of the action
		Speed:= SpeedTable(5);
		Step:= StepTable(5);
		end;

	if GroupY < 0 then				\Group must be completely
		begin					\ on screen otherwise the
		Score:= Score + Points;			\ game is over
		ShowScore;
		quit;
		end;

	if Group(0) = WildIcon then			\Wild group
		begin
		I:= Field(GroupX,GroupY+3);		\Get icon hit by wild group
		if GroupY+3 >= FieldHeight then I:= -1;	\Didn't hit a icon
		Wild(I);				\Remove icons (if any)
		end;

	loop	begin
		Check;					\Check for & remove 3 in row
		if ~Fall then quit;			\Loop until nothing falls
		end;

	I:= Rem(Score/1000);				\Did a thousand digit
	if I+Points >= 1000 then			\ roll over?
		for J:= 0, 2 do Group(J):= WildIcon	\Start a wild group
	else	for J:= 0, 2 do Group(J):= PGroup(J);	\Start the preview group

	Score:= Score + Points;				\Add points for this group
	ShowScore;
	end;
end;	\PlayGame

\----------------------------------------------------------------------

begin	\Main
Cpureg:= Getreg;
DataSeg:= Cpureg(12);

FontTable:= Reserve(FontSize);
Palette:= Reserve(16);
Group:= Reserve(3);
Field:= Reserve(FieldWidth*Intsize);
Mark:=  Reserve(FieldWidth*Intsize);
for II:= 0, FieldWidth-1 do
	begin
	Field(II):= Reserve(FieldHeight*Intsize);
	Mark(II):=  Reserve(FieldHeight*Intsize);
	end;

\Actual speed of falling icons = Speed / Step
\	      0  1  2  3  4  5  6  7  8  9 10 11 12
SpeedTable:= [4, 3, 5, 2, 3, 1, 3, 1, 3, 1, 1, 1, 1];
StepTable:=  [1, 1, 2, 1, 2, 1, 4, 2, 8, 4, 8,16,32]; \must div evenly into 32
TableMax:= 12;

II:= Equip;				\Note WaitVB also requires color display
if (II(2)&$08) = 0 then
	[Text(0, "

This program requires a VGA display.
");   exit];

Trapc(true);				\Ignore Ctrl+C if struck on keyboard
DoSound:= true;				\Default is sound on
II:= Ran(-1);					\Randomize

Mode:= GetVid;
LoadFont;		\Set up font immediately after setting display mode
Setvid($12);		\640x480x16
Cpureg(AX):= $1121;	\Set up font; i.e. set up interrupt vector $43
Cpureg(BX):= 0;		\ (should immediately follow Setvid)
Cpureg(CX):= 16;	\Bytes per char
Cpureg(DX):= 30;	\Character rows per screen (480/16 = 30)
Cpureg(ES):= DataSeg;
Cpureg(BP):= FontTable;
Softint($10);		\Call BIOS

for II:= 0, 16-1 do Palette(II):= 0;	\Hide images while they are loading
SetPal(Palette);			\Turn colors off
LoadLBM("WINDOZE2.LBM");			\Load icon images, Game Over sign, etc.
MovImage(0, 0, 0, 480, 640, VGA2YMax);	\Move images into undisplayed video memory

loop	begin
	LoadLBM("WINDOZE1.LBM");		\Load main screen image
	for II:= 0, 16-1 do Palette(II):= II; \Turn colors on (and align palette)
	SetPal(Palette);
	PlayGame;
	GameOver;
	HighScores;
	end;
end;	\Main
