\solo.xpl By Ed DeWan, 1/8/7.
\Uses mouse, keyboard, and video routines from 8across.xpl by Loren Blaney.

inc C:\CXPL\CODESI; \Include code definitions for intrinsic routines.

eproc LoadLBM; \External procedure to load an .LBM file.

ext ImageSize(X0, Y0, X1, Y1, Z),			\Get size of image (paragraphs).
	DrawImage(X, Y, BufSeg, Op),			\Draw image in BufSeg at X,Y.
		\Op: 0 COPY, 1 AND, 2 OR.
	SaveImage(X0, Y0, X1, Y1, Z, BufSeg),	\Copy image at X,Y into BufSeg.
	SaveMask(X0, Y0, X1, Y1, Z, MaskBuf);	\Save copy of mask for the image.

int Cpureg; \Address of CPU register array (Getreg). This must be
			\ declared first, in same location as in LOADLBM.

\Dimensions:

def
	ScreenHeight = 600,	\Pixels.
	ScreenWidth = 800,

	PointerWidth = 15,	\Mouse pointer dimensions.
	PointerHeight = 25,
	TokenWidth = 27,	\Token dimensions.
	TokenHeight = 27,
	TokenStandard = 1,
	HexWidth = 27, HexHeight = 27,	\Same image as yellow token.
	QuarterWidth = 27, QuarterHeight = 27,
	SnowWidth = 14, SnowHeight = 15,
	OctWidth = 24, OctHeight = 24,
	SoloWidth = 102, SoloHeight = 64,
	ButtonWidth = 63,	\Pushbutton dimensions.
	ButtonHeight = 23,
	ButtonSpacing = 28,	\(Center-to-center spacing, not space between).
	DotWidth = 1,
	DotHeight = 1,
	MovesX = 70,
	SavedX = 40,

	Black = 1,			\Token colors.
	Maroon = 2,
	Blue = 3,
	Red = 4,
	Purple = 5,
	Azure = 6,
	Green = 7,
	Maroon2 = 8,
	Grey = 9,
	Yellow = 10,

	ButtonN = 6,		\Number of buttons.
	TokenN = 11,		\Number of Tokens (two game tokens, seven smiley
						\ faces, and two yellow hexes, one with exclam.
	HexN = 16,			\Hex,
	QuarterN = 16,		\Quarter,
	DotN = 13,			\Dot,
	SnowN = 9,			\and Snow(flake) images images in solo.lbm.
	OctN = 3,			\Big snowflakes (not used).
	HelpP = ^1,			\The last help page.

	Esc = $1B,
	CR = $0D,			\Carriage return.
	LF = $0A,			\Line feed.
	FF = $0C,			\Form feed.
	EOF = $1A,			\End of file (Ctrl-Z).
	LeftArrow = -$4B,	\Scan codes for key presses.
	RightArrow = -$4D,
	BackSpace = 8,
	Space = ^ ,
	Delete = -$53,
	AltDown = $38,
	AltUp = $B8,

	Source, Target, Other, \Only "Target" is explicitly tested for.
	;

\Locations:

def
	UndoX = 37, UndoY = 300,	\Buttons.
	MsgX = 2,	MsgY = 0,		\Messages; 2 avoids the left edge.
	MsgW = 50 - MsgX,
	;

int BackImageBuf,	\Background images overwritten by mouse pointers.
	MouseX0,		\Mouse coordinates used for displaying pointer.
	MouseY0,
	PointerBuf,		\Buffer holding mouse pointer image.
	PointerMaskBuf,	\Buffer holding mask for pointer image.
	PointerSize,	\Number of paragraphs required to hold a pointer image.

	TokenBuf(TokenN+1),		\Buffer array holding Token images. +1 allows
							\1-based indexing.

	HexBuf(HexN),			\0-based indexing. These are the "win" images.
	QuarterBuf(QuarterN),	\More images; quarter circles, sixteen in all.
	BullsEyeBuf,				\A full circle, colored.
	SnowBuf(SnowN),
	SnowSize,
	OctBuf(OctN),
	OctSize,
	SoloBuf,					\"SOLO" text image.
	SoloSize,

	ButtonBuf(ButtonN*2),	\Array of buffers holding button images.
	ButtonMaskBuf,	 		\Buffer holding image mask for button.
	ButtonSize,	   			\Number of paragraphs required to hold a button image.
	EraserBuf,		   		\Buffer holding blank area for an eraser.
	EraserSize,		  		\Number of paragraphs required to hold blank area.
	QEraserBuf,				\Eraser buffer for quarter-rounds.
	HaveMouse,		   		\Flag: Mouse driver installed and mouse works.

	VidMode,		\Initial video mode to be restored upon exit.

	TextDevice,
	M, N, O, P, Q,
	GameCount,
	;

def
	Tw = TokenWidth, Th = TokenHeight, \Width and height of game tokens.
	LineColor = 3,
	BoardN = 7,	\Board size.
	MoveN = 32, \Maximum number of possible moves (there are 33 tokens).
	SaveCoords = 4,
	;

int
	SaveMove(MoveN, SaveCoords),
	MoveI,						\Move index, ranges from 0 to MoveN-1.
	Board(BoardN, BoardN),		\Token array.
	Boardx(BoardN, BoardN),		\Coordinates of game squares
	Boardy(BoardN, BoardN),		\ (upper-left corners).
	BoardFlag,					\True when board is shown.
	EraserWidth,
	EraserHeight,
	Trx(BoardN, BoardN),		\Offset coordinates for tokens.
	Try(BoardN, BoardN),
	Bw, Bh,						\Lattice box width and height.
	Tx0, Ty0,					\Top-left coordinates of lattice.
	Tx1, Ty1,					\Botom-right coordinates of lattice.
	Qx(4), Qy(4),				\Corner coordinates for quarter-rounds.
	MN(MoveN),					\Stores coordinates for the active parts
								\of the game array.
	Dots(DotN),					\Single-pixel images in 13 different colors.
	MoveCount,
	QuitWin,
	;

int Hour, Minute, Second;



\===============================================================================


\The following list was generated by getproc.prl:

\The following list was generated by anyproc.prl:
fproc Exit;
fproc Undo;
fproc DrawButton;
fproc DrawToken;
fproc HandleKeyCommands;
fproc Beep;
fproc Click;
fproc ShowMoveCount;
fproc RestoreGame;
fproc SaveGame;
fproc EraseToken;
fproc ShowHelp;
fproc ShowWin;
fproc EraseBoard;
fproc SmileyFaces;
fproc ShowBoard;
fproc BoardErase;
fproc ToggleBoardFlag;
fproc BuildScreen;
fproc PlayGame;


\===============================================================================


func CallInt(Int, AX, BX, CX, DX, BP, DS, ES); \Call software interrupt.
int Int, AX, BX, CX, DX, BP, DS, ES; \(Unused arguments need not be passed.)
begin
	Cpureg(0) := AX;
	Cpureg(1) := BX;
	Cpureg(2) := CX;
	Cpureg(3) := DX;
	Cpureg(6) := BP;
	Cpureg(9) := DS;
	Cpureg(11) := ES;
	Softint(Int);
	return Cpureg(0); \Return AX register.
end; \CallInt


func GetVid; \Return the current video mode.
	return CallInt($10, $0F00) & $FF; \Function $0F


proc AlignPalette; \Make palette registers correspond to VGA DAC registers.
int N;
for N := 0, 15 do
	CallInt($10, $1000, N << 8 ! N); \Function $10, subfunction $00.


\------------------------------- MOUSE ROUTINES --------------------------------


func OpenMouse; \Initialize mouse; return 'false' if it fails.
begin \Pointer is set to center of screen but is hidden.
	CallInt($21, $3533); \Make sure mouse vector ($33) points to something.
	HaveMouse := false;
	if Cpureg(1) = 0 & Cpureg(11) = 0 then return false;
	HaveMouse := CallInt($33, $0000);	 \Reset mouse and get status.
	if HaveMouse then HaveMouse := true; \(Beware of 'not' operator in 32-bit XPL).
	return HaveMouse;					 \Return 'false' if failure.
end; \OpenMouse


func GetMousePosition(N); \Return position of specified mouse coordinate
int N; \0 = X coordinate; 1 = Y coordinate
\For video modes $0-$E and $13 the maximum coordinates are 639x199, minus
\ the size of the pointer. For modes $F-$12 the coordinates are the same as
\ the pixels. For 80-column text modes divide the mouse coordinates by 8 to
\ get the character cursor position.
\For mode $6A (800x600) BIOS returns the correct X coordinate, but the Y
\ coordinate must be multiplied by 3.
begin
	if ~HaveMouse then return 0;
	CallInt($33, $0003);
	return if N\#0\ then Cpureg(3)*3 else Cpureg(2);
end; \GetMousePosition


func GetMouseButton(N); \Return 'true' if specified mouse button is down.
int N; \Button number: 0 = left; 1 = right (or middle).
begin
	if ~HaveMouse then return false;
	CallInt($33, $0003);
	return if N then (Cpureg(1)&2) = 2 else (Cpureg(1)&1) = 1;
end; \GetMouseButton


proc MoveMouse(X, Y); \Move mouse pointer to X,Y.
int X, Y;
if HaveMouse then CallInt($33, $0004, 0, X, Y);


proc DrawMousePointer; \At MouseX0, MouseY0 (BIOS doesn't do mode $6A).
begin
	\Save background image at mouse position
	SaveImage(MouseX0, MouseY0, MouseX0+PointerWidth-1, MouseY0+PointerHeight-1,
		$0F, BackImageBuf);
	\Draw mouse pointer at mouse position
	DrawImage(MouseX0, MouseY0, PointerMaskBuf, 1\AND\); \Mask out a hole.
	DrawImage(MouseX0, MouseY0, PointerBuf, 2\OR\);		 \Draw in the pointer.
end; \DrawMousePointer


proc ShowMouse(On); \Turn mouse pointer on or off.
\The video mode should be set before calling this routine. The pointer should
\ be turned off before drawing over it.
int On; \Flag: True = pointer on; False = pointer off.
begin
	if On then DrawMousePointer
	else DrawImage(MouseX0, MouseY0, BackImageBuf, 0\COPY\); \Restore background.
end; \ShowMouse


proc SetMouseLimits; \Limit the travel of the mouse pointer on screen.
begin
	\BIOS thinks the mouse ranges from 0 to 799 horizontally and 0 to 199 vertically.
	CallInt($33, $07, 0, 0, ScreenWidth-PointerWidth);
	CallInt($33, $08, 0, 0, (ScreenHeight-PointerHeight)/3);
end; \MouseLimits


proc HandleMousePointer; \Display mouse pointer.
int MX, MY;
begin
	MX := GetMousePosition(0);
	MY := GetMousePosition(1);
	if MX # MouseX0 ! MY # MouseY0 then
	begin \Mouse moved
		\Restore background at old mouse position.
		DrawImage(MouseX0, MouseY0, BackImageBuf, 0\COPY\);
		MouseX0 := MX;   MouseY0 := MY; \Get new mouse position.
		DrawMousePointer;
	end;
end; \HandleMousePointer


proc GetMouseClick(Mode); \Wait for the mouse to click on something.
int Mode;
int SB, Pressed;
int AltKeyDown;

	func GetSB;
	int N;
	begin \GetSB
		for N := 0, ButtonN-1 do
		\Locates which soft button, if any, the pointer is on during a click.
		begin
			if MouseX0 >= UndoX & MouseX0 <= UndoX+ButtonWidth-1 &
					MouseY0 >= UndoY+N*ButtonSpacing &
							MouseY0 <= UndoY+N*ButtonSpacing+ButtonHeight-1 then
			return N;
		end;
		return ButtonN;
	end; \GetSB

begin \GetMouseClick
	loop begin
		ShowMouse(true);
		repeat begin
			HandleMousePointer;
			HandleKeyCommands;
		end;
		until GetMouseButton(0) ! GetMouseButton(1); \A mouse button is pressed.

		\We have to wait for the mouse button that was pressed to be released,
		\and process the soft-button images in the meantime; i.e., if one
		\was clicked on, then whenever the mouse hovers over it, we have to
		\show it as being pressed.

		\DrawButton=No-op if a non-existent button (>=ButtonN) is specified.
		Pressed := ButtonN;
		repeat begin
			HandleMousePointer;
			HandleKeyCommands;
			SB := GetSB;
			if SB # Pressed & SB < ButtonN then
			begin
				DrawButton(Pressed, false);
				Pressed := SB;
				DrawButton(SB, true);
			end
			else if SB = ButtonN & Pressed < ButtonN then
			begin
				DrawButton(Pressed, false);
				Pressed := ButtonN;
			end;
		end;
		until not GetMouseButton(0) & not GetMouseButton(1); \Both buttons released.

		\If a soft button is down then execute its function.
		if SB < ButtonN then
		begin
			DrawButton(SB, false); \Display unpressed button.
			ShowMouse(false); \(Necessary for Undo command).
			case SB of
					0:	Undo;
					1:	PlayGame;
					2:	Exit;
					3:	ShowHelp;
					4:	SaveGame;
					5:	RestoreGame
					other	[];
		end
		else
		begin
			DrawButton(Pressed, false);
			quit;
		end;
	end; \loop

	ShowMouse(false);
end; \GetMouseClick


\-------------------------------------------------------------------------------


\Not sure if this works correctly. @
proc GetTime;
int CpuReg;
begin \GetTime
	CpuReg:= GetReg;                \Copy of hardware registers
	CpuReg(0):= $2C00;              \Set AH to $2C
	SoftInt($21);                   \Call DOS function
	Hour:= Swap(CpuReg(2)) & $FF;   \Read returned values
	Minute:= CpuReg(2) & $FF;
	Second:= Swap(CpuReg(3)) & $FF;
end; \GetTime


proc Exit; \Make a clean exit.
begin
	SetVid(VidMode); \Restore original video mode (clears screen).
	exit;
end; \Exit


func GetKey; \Get character from keyboard (wait if necessary).
int SC, Ch;  \This is a low-level routine with no echo or cursor.
begin
	SC := CallInt($16, $0000); \Function $00.
	Ch := SC & $FF;
	if Ch = 0 then Ch := -(SC >> 8); \Return non-ascii chars as negative scan code.
	if Ch = $03 \Ctrl-C\ then Exit;
	return Ch;
end; \GetKey


proc WaitVB; \Wait for beginning of monitor's next vertical blank.
int SR;
begin
	SR := Peek($40, $63) + $306;	\Port address of status register.
	if (SR & $39A) # $39A then return;
	while Pin(SR, 0) & $08 do;		\Wait for no vertical blank.
	repeat until Pin(SR, 0) & $08;	\Wait for vertical blank.
end; \WaitVB;


\===============================================================================


proc Exch(A, B); \Exchange the contents of locations A and B.
int A, B;
int T;
begin
	T := A(0); \Swaps pointers to A and B, not contents.
	A(0) := B(0);
	B(0) := T;
end; \Exch


proc Undo; \Undo last move (toggles).
int I, J, K, L;
begin
	if MoveI = 0 then [ Beep(1); return ];
	MoveI := MoveI - 1;

	I := SaveMove(MoveI,0); \Source Row.
	J := SaveMove(MoveI,1); \Source Column.
	K := SaveMove(MoveI,2); \Target Row.
	L := SaveMove(MoveI,3); \Target Column.

	\Swap original target and source.
	DrawToken(Black,I,J);
	Board(I,J) := 1;
	EraseToken(K,L);
	Board(K,L) := 0;

	\Restore the token jumped over.
	if      L = J - 2 then [ Board(I,J-1) := 1; DrawToken(Black,I,J-1) ]  \Left.
	else if L = J + 2 then [ Board(I,J+1) := 1; DrawToken(Black,I,J+1) ]  \Right.
	else if K = I + 2 then [ Board(I+1,J) := 1; DrawToken(Black,I+1,J) ]  \Down.
	else                   [ Board(I-1,J) := 1; DrawToken(Black,I-1,J) ]; \Up.

	ShowMoveCount;

	if BoardFlag then ShowBoard;

end; \Undo


proc DrawButton(N, Down); \Draw button N in either its up or down position.
int N, Down;
\ N  Button
\----------
\ 0  Undo
\ 1  Deal
\ 2  Exit
\ 3  ShowHelp
\ 4  Sav
\ 5  Res

begin \DrawButton
	if N >= ButtonN then return; \No-op if the button doesn't exist.
	ShowMouse(false);
	DrawImage(UndoX, UndoY+ButtonSpacing*N,
		ButtonBuf(N*2+(if Down then 1 else 0)), 0\COPY\);
	ShowMouse(true);
end; \DrawButton


proc DrawTokenXY(N, TkX, TkY);
int N, TkX, TkY;
begin \DrawTokenXY
	\Draw Token at Token position. See DrawPointer.
	DrawImage(TkX, TkY, TokenBuf(N), 2\OR\);
end; \DrawTokenXY


proc DrawToken(N, O, P);
int N, O, P;
begin \DrawToken
	DrawTokenXY(N, Trx(O,P), Try(O,P));
end; \DrawToken


proc HandleKeyCommands; \Check for and handle shortcut keystrokes.
int Ch;
begin
	if Chkkey then
	begin
		Ch := GetKey;
		ShowMouse(false); \(Necessary for keyboard "U" command).
		case Ch of
		^B, ^b:		ToggleBoardFlag;
		^G,^g,-32:	PlayGame;			\Alt+D = -32.
		^H,^h,^?:	ShowHelp;	  		\Show help screen.
		^Q,^q:		Exit;
		^R,^r:		RestoreGame;
		^S,^s:		SaveGame;
		^U,^u,-22:	Undo;				\Alt+U = -22.
		^#:			[ ShowWin; PlayGame ];
		^X,^x,-45:	Exit;
		Esc:		QuitWin := true
		other		[];
		ShowMouse(true);
	end;
end; \HandleKeyCommands


proc Wait(T); \Wait T 60ths of a second or until a mouse click.
int T;
begin
	ShowMouse(true);
	loop begin
		HandleMousePointer;
		HandleKeyCommands;
		WaitVB;
		T := T -1;
		if T <= 0 then quit;
		if GetMouseButton(0) ! GetMouseButton(1) then quit;
	end;
	ShowMouse(false);
end; \Wait


\-------------------------------------------------------------------------------


proc Beep(N); \A not-too-obnoxious beep
int N;
begin
	while N > 0 do
	begin
		Sound(false, 1, 1000); \Synchronize with system timer to make tone a
		Sound(true, 1, 3000);  \consistent duration and a consistent sound.
		Wait(1); N := N - 1;
	end;
end; \Beep


proc ClearMsgArea; \Clear out the message area.
int I;
begin \ClearMsgArea
	Cursor(MsgX, MsgY);
	for I := 1, MsgW do Text(TextDevice," ");
	Cursor(MsgX, MsgY);
end; \ClearMsgArea


proc ClearTop;
int I;
begin \ClearTop
	Cursor(0,0);
	for I := 1, 99 do Text(TextDevice, " ");
end; \ClearTop


proc ShowMsg(Str); \Display a message.
char Str;
begin \ShowMsg
	ClearMsgArea;
	Text(TextDevice, Str);
end; \ShowMsg


proc ErrorMsg(Str); \Display an error message.
char Str;
begin
	Beep(5);
	ShowMsg(Str);
	Wait(60);
end; \ErrorMsg


\Diagnostics.
proc Click;
	[ Beep(1); GetMouseClick(Other) ];


proc D1(Txt,N);
char Txt;
int N;
begin \D1
	ClearMsgArea;
	Text(TextDevice,"      ");
	Text(TextDevice,Txt);
	Text(TextDevice,"=");
	IntOut(TextDevice,N);
	Click;
end; \D1


proc D2(Txt1,N, Txt2, M);
char Txt1; int N;
char Txt2; int M;
begin \D2
	ClearMsgArea;
	Text(TextDevice,"      ");
	Text(TextDevice,Txt1);
	Text(TextDevice,"=");
	IntOut(TextDevice,N);
	Text(TextDevice,", ");
	Text(TextDevice,Txt2);
	Text(TextDevice,"=");
	IntOut(TextDevice,M);
	Click;
end; \D2


proc Dd(Txt);
char Txt;
begin;
	ClearMsgArea;
	Text(TextDevice,Txt);
	Click;
end;


\-------------------------------------------------------------------------------


proc ShowMoveCount;
begin \ShowMoveCount
	Cursor(MovesX,0);
	Text(0,"                   ");
	Cursor(MovesX,0);
	Text(0,"Moves completed: ");
	IntOut(0,MoveI);
end; \ShowMoveCount


proc RestoreGame;
int I, J;
begin \RestoreGame
	J := MoveI;
	for I := 1, MoveI-MoveCount do Undo;
	Beep(1);
	Cursor(SavedX,0);
	Text(0,"Game restored.");
	Wait(60);
	Cursor(SavedX,0);
	Text(0,"              ");
	ShowMoveCount;
end; \RestoreGame


proc SaveGame;
begin \SaveGame
	MoveCount := MoveI;
	Beep(1);
	Cursor(SavedX,0);
	Text(0,"Game saved.");
	Wait(60);
	Cursor(SavedX,0);
	Text(0,"           ");
end; \SaveGame


proc EraseToken(M,N);
int M, N;
begin \EraseToken
	DrawImage(Boardx(M,N)+2, Boardy(M,N)+2, EraserBuf, 0);
end; \EraseToken


proc CheckToken(M,N);
int M, N;
begin \CheckToken
	\Check to the RIGHT.
	if (M>4 ! M<2) & N=2 ! M<5 & M>1 & N<5 then
		[ if Board(M,N+1) = 1 & Board(M,N+2) = 0 then return true ];
	\Check to the LEFT.
	if (M>4 ! M<2) & N=4 ! M<5 & M>1 & N>1 then
		[ if Board(M,N-1) = 1 & Board(M,N-2) = 0 then return true ];
	\Check DOWN.
	if M=2 & (N>4 ! N<2) ! M<5 & N<5 & N>1 then
		[ if Board(M+1,N) = 1 & Board(M+2,N) = 0 then return true ];
	\Check UP.
	if M=4 & (N>4 ! N<2) ! M>1 & N<5 & N>1 then
		[ if Board(M-1,N) = 1 & Board(M-2,N) = 0 then return true ];
	return false;
end; \CheckToken


proc ShowHelp;
int I, J, N, Leader;
int HelpCounter;
int HelpN;
char KeyPressed;
char Ch, HelpIn;
int HelpFileHandle;
int HelpDevice;

	func int OpenHelpFile;
	char FileName;
	begin \OpenHelpFile
		Trap(false);
		HelpFileHandle := FOpen("solo.hlp",0); \Get FileHandle
		if Geterr # 0 then \If file missing, blow your horn.
		begin
			ErrorMsg("SORRY, FILE solo.hlp NOT PRESENT IN CURRENT DIRECTORY");
			FClose(HelpFileHandle); \Close out the Help FileHandle
			return false;
		end;
		FSet(HelpFileHandle, ^I);
		OpenI(3);
		Trap(true);
		return true;
	end; \OpenHelpFile

	proc CloseHelp;
	begin \CloseHelp
		Clear;
		WaitVB; \Avoid any possible screen glitch.
		for N := 0, ButtonN-1 do \Show buttons.
			DrawImage(UndoX, UndoY+ButtonSpacing*N, ButtonBuf(N*2), 0\COPY\);
		Move(0, 18);
		Line(ScreenWidth-1, 18, 3\black\);
		ClearMsgArea;
		BuildScreen;
		\@ Got to do some more here.
	end; \CloseHelp

	func int GetHelpIn;
	begin
		HelpIn := ChIn(3);
		if HelpIn = EOF then return false else return true;
	end;

	func DoLeader;
	int I;
		for I := 1, Leader do ChOut(HelpDevice,^ );

	func int DoHelp;
	int HCounter;
	int LineCount, InputLine;
    int X, Y, K;
	begin \DoHelp
		if ~OpenHelpFile then return false;
		Clear;
		InputLine := 0;
		CrLf(HelpDevice);
		LineCount := 1;
		DoLeader;
		repeat
			if ~GetHelpIn then return false;
			if HelpIn # FF then
			begin
				if HelpIn = CR then
				begin
					ChOut(HelpDevice,CR); ChOut(HelpDevice,LF);
					DoLeader;
					LineCount := LineCount + 1;
					\This allows up to 33 lines of text, counting from the
					\header line (not counting the blank at the top).
					if LineCount > 33 then HelpIn := FF; \Stop the loop.
				end
				else if HelpIn # LF then ChOut(HelpDevice,HelpIn)
			end
			else if HelpIn # FF then ChOut(HelpDevice,HelpIn)
		until HelpIn = FF;
		FClose(HelpFileHandle); \Close out the Help FileHandle
		CrLf(HelpDevice); CrLf(HelpDevice); DoLeader;
		Text(HelpDevice,"   *** Q, X, or Esc to quit Help ***");
		return true;
		end; \DoHelp

		proc RestoreBanners;
		begin \RestoreBanners
			ShowMoveCount;
			ShowMsg("Click on a token to move");
		end; \RestoreBanners

begin \ShowHelp

	HelpDevice := 1;
	HelpN := HelpP;
	HelpCounter := ^0;
	Leader := 8;
	if HelpCounter < ^0 ! HelpCounter > HelpN then return;
	while HelpCounter <= HelpN do
	begin
		Clear;
		if ~DoHelp(HelpCounter) then [ CloseHelp; RestoreBanners; return ];
		loop begin
			if Chkkey then
			begin
				Ch := GetKey;
				if Ch = ^Q ! Ch = ^q ! Ch = ^X ! Ch = ^x ! Ch = Esc then
					[ CloseHelp; RestoreBanners; return ];
			end;
		end;
	end;
	Dd("Exiting ShowHelp through bottom");
	CloseHelp;
	ShowMoveCount;
end; \ShowHelp


proc ShowWin;
int	M, N, O,
	I, J,
	QQRan,
	Qindex(4),
	Sindex(4,4),
	QDavail(5),
	X, Y,
	SnowCounter,
	;

	proc DoQuadrant;
	int SQ, SQn;
	int X, Y;
	int I, J;
	int Count;
	int QQ;
	int RR;
	begin \DoQuadrant
		\Choose a quadrant and sub-quadrant at random.
		Q := Ran(4);
  		SQ := Ran(4);
   		X := Qx(Q); Y := Qy(Q);
   		case SQ of
   			0: [ X := X - Bw/2; Y := Y - Bh/2 ];
	  		1: Y := Y - Bh/2;
	  		2: X := X - Bw/2;
   			3: []
  			other Dd("BAD CASE IN DoQuadrant");
   		DrawImage(X, Y, QEraserBuf, 0);
		QQ := Qindex(SQ);
		QQRan := Ran(4);
   		DrawImage(X, Y, QuarterBuf(QQ(QQRan)), 0);

		\Draw the large color circle at random.
		if Ran(10) = 0 then
		begin
			X := Qx(Q) - Bw/2;
			Y := Qy(Q) - Bh/2;
   			DrawImage(X, Y, EraserBuf, 0);
			DrawImage(X, Y, BullsEyeBuf, 0);
		end;

	end; \DoQuadrant

begin \ShowWin
	QuitWin := false;
	\Qindex is read-only. The values are indices into QuarterBuf.
	Qindex(0) := [0,2,8,10];	\Upper lefts.
	Qindex(1) := [1,3,9,11];	\Upper rights.
	Qindex(2) := [4,6,12,14];	\Lower lefts.
	Qindex(3) := [5,7,13,15];	\Lower rights.

	EraseBoard; \Erase all token images.
	BoardErase; \Remove board diagnostic if present.
	ClearMsgArea;
	Text(0, "YOU WIN!   Click anywhere to resume play."); Beep(1);
	Cursor(MovesX, 0);
	Text(0, "                           ");
	SnowCounter := 0;
	O := 0;
	loop begin
		ShowMouse(true);
		HandleMousePointer;
		HandleKeyCommands;
		WaitVB;
		if GetMouseButton(0) ! GetMouseButton(1) then quit;
		ShowMouse(false);
		if SnowCounter < 800 then
		begin
			if O = 0 then
			begin
				EraseToken(3,3);
				DrawToken(10,3,3);
			end
			else if O = 30 then
			begin
				EraseToken(3,3);
				DrawToken(11,3,3);
			end;
			O := Rem((O+1)/60);
			repeat begin M := Ran(7); N := Ran(7) end
				until Board(M,N) # 2 & ~(M=3 & N=3);
			EraseToken(M,N);
			DrawImage(Trx(M,N), Try(M,N), HexBuf(Ran(16)), 2);
			Wait(1);
		end;
		if SnowCounter < 900 then DoQuadrant;
		\SnowCounter holds off the snow for a while.
		SnowCounter := SnowCounter + 1;
		if SnowCounter > 250 then for J := 1, SnowCounter/10 do
		begin
			repeat begin
				X := Ran(ScreenWidth);
				Y := Ran(ScreenHeight);
				\Outside the grid:
			end until Y > 15 & ( X < (Tx0-1) ! X > Tx1 ! Y < (Ty0-2) ! Y > Ty1
				\Inside the corners:
				! ( X < (Tx0+2*Bw-1) & Y < (Ty0+2*Bh-1) )  		\Upper left.
				! ( X < (Tx0+2*Bw-1) & Y > (Ty1-2*Bh+0) )  		\Lower left.
				! ( X > (Tx1-2*Bw+0) & Y < (Ty0+2*Bh-1) ) 		\Upper right.
				! ( X > (Tx1-2*Bw+0) & Y > (Ty1-2*Bh+0) ) );	\Lower right.

			\After a while put them everywhere!
			if SnowCounter > 500 then
			begin
				X := Ran(ScreenWidth);
				Y := Ran(ScreenHeight);
			end;	
			if Ran(5) = 0 then DrawImage(X, Y, SnowBuf(Ran(SnowN)), 0);
		end;
		if QuitWin then quit;
	end;
	MoveI := MoveN-1; \Stops the repeat in PlayGame.
end; \ShowWin


proc MakeMove;	\Make a (legal) move.
int MX, MY,		\Mouse position in pixel coordinates.
	X, Y,  		\Temps.
	M, N, 		\Array coordinates.
	MM, NN,		\Coordinates of clicked source token.
	ValidCount, TokenCount,
	;

	proc GetSource;
	int Jiggle;
	\Loops until a valid token is selected.

	begin \GetSource
		Jiggle := 0;
		loop begin \Source loop - repeats until valid token is selected.
			if Jiggle = 1 then ShowMsg("      Click on a token to move")
			else ShowMsg("Click on a token to move");
			GetMouseClick(Source);
			MX := GetMousePosition(0);
			MY := GetMousePosition(1);
			\Ignore click if it's not on the board.
			if MX <= Tx0 ! MX >= Tx0 + 7*Bw ! MY <= Ty0 ! MY >= Ty0 + 7*Bh then []
			else begin \Clicked on board.
				\Scan board array to locate the clicked square and see if the
				\click is on a token (check only squares with valid tokens).
				for M := 0, BoardN-1 do
				begin
					for N := 0, BoardN-1 do
					begin
						if Board(M,N) = 1 then
						begin
							if MX > Boardx(M,N) & MX < Boardx(M,N)+Bw
							& MY > Boardy(M,N) & MY < Boardy(M,N)+Bh
							& CheckToken(M,N) then
							begin
								MM := M; NN := N;
								\Erase the existing token first.
								EraseToken(M,N);
								DrawToken(Maroon, M, N);
								quit;
							end;
						end;
					end;
				end;
			end; \Clicked on board.
			Jiggle := 1 - Jiggle;
		end; \Source loop.
	end; \GetSource

begin \MakeMove

	loop begin	\Target loop.

		\We enter GetSource only when there is a valid move to make.
		GetSource; \Source loop.

		ShowMsg("Click on an empty square to jump to");
		GetMouseClick(Target);
		MX := GetMousePosition(0);
		MY := GetMousePosition(1);

		\Ignore click if it's not on the board.
		if MX < Tx0 ! MX > Tx0 + 7*Bw ! MY < Ty0 ! MY > Ty0 + 7*Bh then
		begin
			EraseToken(MM,NN, MM,NN);
			DrawToken(Black, MM ,NN);
		end
		else
		begin \Clicked on board.
			\Scan board array to locate the clicked square and see if the
			\click is on a blank square.
			for M := 0, BoardN-1 do
			begin \Board scan outer for-loop.
				for N := 0, BoardN-1 do
				begin \Board scan inner for-loop.
					if Board(M,N) = 0 then \Examine blank squares only.
					begin
						if MX >= Boardx(M,N) & MX <= Boardx(M,N)+Bw
							& MY >= Boardy(M,N) & MY <= Boardy(M,N)+Bh then
						begin \Clicked empty target square.
							\Next we must verify that the target is exactly two
							\squares away from the source token, in one of the
							\cardinal directions.

							if ( M=MM-2 & N=NN ! M=MM+2 & N=NN !
								N=NN-2 & M=MM ! N=NN+2 & M=MM ) then
							begin
								\Erase original token.
								EraseToken(MM,NN);
								Board(MM,NN) := 0;
								\Show token in new position.
								DrawToken(Black, M, N);
								Board(M,N) := 1;
								\Locate and erase token jumped over.
								if M < MM then
								begin
									EraseToken(M+1,N);
									Board(M+1,N) := 0;
								end else if M > MM then
								begin
									EraseToken(M-1,N);
									Board(M-1,N) := 0;
								end else if N < NN then
								begin
									EraseToken(M,N+1);
									Board(M,N+1) := 0;
								end else if N > NN then
								begin
									EraseToken(M,N-1);
									Board(M,N-1) := 0;
								end else ErrorMsg("***CALL THE PLUMBER***");
								quit;
							end;
						end; \Clicked empty target square.
					end; \Board(M,N) = 0.
				end; \Board scan inner for-loop.
			end; \Board scan outer for-loop.
		end; \Clicked on board.
		\If no quit, change the original token from red to black.
		if Board(MM,NN) = 1 then
		begin
			EraseToken(MM,NN);
			DrawToken(Black, MM ,NN);
		end;
	end; \Target loop - repeat until valid move is made.

	ShowBoard;

	SaveMove(MoveI, 0) := MM;
	SaveMove(MoveI, 1) := NN;
	SaveMove(MoveI, 2) := M;
	SaveMove(MoveI, 3) := N;
	if MoveI < MoveN-1 then MoveI := MoveI + 1
	else ErrorMsg("Exceeded Maximum Move Count");

	\Count valid tokens.
	ValidCount := 0;
	TokenCount := 0;
	for M := 0, BoardN-1 do for N := 0, BoardN-1 do
	begin
		if Board(M,N) = 1 then
		begin
			TokenCount := TokenCount + 1;
			if CheckToken(M,N) then
				ValidCount := ValidCount + 1;
		end;
	end;
	if TokenCount = 1 & Board(3,3) = 1 then
		ShowWin
	else if ValidCount = 0 then
	begin
		ClearMsgArea;
		Text(0,"GAME OVER -- NO MORE VALID MOVES"); Beep(1);
		SmileyFaces;
		MoveI := MoveN-1; \Stops the repeat in PlayGame.
	end;
	Cursor(MovesX,0);
	Text(0,"Moves completed: ");
	IntOut(0,MoveI);
end; \MakeMove


\-------------------------------------------------------------------------------


proc FillBoard;
int M, N;
begin \FillBoard
	for M := 2, 4 do for N := 0, BoardN-1 do Board(M,N) := 1;
	for N := 2, 4 do for M := 0, BoardN-1 do Board(M,N) := 1;
	Board(3,3) := 0;
end; \FillBoard


proc EmptyBoard;
int M,N;
begin \EmptyBoard
	for M := 2, 4 do for N := 0, BoardN-1 do Board(M,N) := 0;
	for N := 2, 4 do for M := 0, BoardN-1 do Board(M,N) := 0;
end; \EmptyBoard


proc EraseBoard;
int M,N;
begin \EraseBoard
	for M := 2, 4 do for N := 0, BoardN-1 do EraseToken(M,N);
	for N := 2, 4 do for M := 0, BoardN-1 do EraseToken(M,N);
end; \EraseBoard


proc SmileyFaces;
int K, M, N, Q, P(2);
begin \SmileyFaces

	\Replace remaining tokens with random faces.
	for K := 0, MoveN do
	begin
		P := MN(K);
		if Board( P(0), P(1) ) = 1 then
		begin
	  		Q := Ran(TokenN-4) + 3;
			EraseToken(P(0),P(1));
			DrawToken(Q,P(0),P(1));
		end;
	end;

	\Select remaining tokens at random and replace with random faces, until the
	\user intervenes by clicking the mouse, or pressing an appropriate key.
	loop begin
   		ShowMouse(true);
   		HandleMousePointer;
   		HandleKeyCommands;
  		WaitVB;
  		if GetMouseButton(0) ! GetMouseButton(1) then quit;
  		ShowMouse(false);
		P := MN(Ran(MoveN+1));
		if Board( P(0), P(1) ) = 1 then
		begin
	 		Q := Ran(TokenN-4) + 3;
			EraseToken(P(0),P(1));
			DrawToken(Q,P(0),P(1));
		end;
	end;
	ShowMouse(false);

end; \SmileyFaces


proc ShowBoard;	\Diagnostic.
int M, N;
begin \ShowBoard
	if ~BoardFlag then return;
	Cursor(0,0);
	Text(0,"

");
	\Outer loop (rows).
	for M := 0, BoardN-1 do
	begin
		Text(0," ");
		if M < 2 ! M > 4 then Text(0,"  ");
		for N := 0, BoardN-1 do
		begin
			if ( Board(M,N) = 2 ) then Text(0," ")
	  		else [ IntOut(0,Board(M,N)); Text(0," ") ];
		end;
		Text(0,"
");
	end;
end; \ShowBoard


proc BoardErase;
begin \BoardErase
	Cursor(0,0);
	Text(0,"

");
	\Outer loop (rows).
	for M := 0, BoardN-1 do
	begin
		Text(0," ");
		if M < 2 ! M > 4 then Text(0,"  ");
		for N := 0, BoardN-1 do
		begin
			if ( Board(M,N) = 2 ) then Text(0," ")
	  		else Text(0,"  ");
		end;
		Text(0,"
");
	end;
end; \BoardErase


proc ToggleBoardFlag;
	if BoardFlag then
	begin
		BoardFlag := false;
		BoardErase;
	end
	else
	begin
		BoardFlag := true;
		ShowBoard;
	end;


proc BuildScreen; \Restore the screen.
int M, N;
int X, Y
X1, Y1, X2, Y2;
int Lx, Ly;
def BoxColor = 3,
	BoxOffset = 1,
	CornerL = 1,
	;

begin \BuildScreen
	Clear;
	FillBoard;

	Lx := 7 * Bw;
	Ly := 7 * Bh;

	\Establish message area at top.
	Move(0, 18);
	Line(ScreenWidth-1, 18, LineColor);

	\Show buttons.
	for N := 0, ButtonN-1 do
	    DrawImage(UndoX, UndoY+ButtonSpacing*N, ButtonBuf(N*2), 0);

	\Draw lattice for game tokens.
	\Long horizontals.
	X := Tx0;
	Y := Ty0 + 2*Bh;
	for N := 1, 4 do
	begin
		Move(X, Y);
		Line(X+Lx, Y, LineColor);
		Y := Y + Bh;
	end;

	\Long verticals.
	X := Tx0 + 2*Bw;
	Y := Ty0;
	for N := 1, 4 do
	begin
		Move(X, Y);
		Line(X, Y+Ly, LineColor);
		X := X + Bw;
	end;

	\Short stuff.
	X := Tx0;
	Y := Ty0 + 2*Bh;
	Move(X, Y);
	Line(X, Y + 3*Bh, LineColor);
	Move(X+Bw, Y);
	Line(X+Bw, Y + 3*Bh, LineColor);

	X := Tx0 + 6*Bw;
	Move(X, Y);
	Line(X, Y + 3*Bh, LineColor);
	Move(X+Bw, Y);
	Line(X+Bw, Y + 3*Bh, LineColor);

	X := Tx0 + 2*Bw;
	Y := Ty0;
	Move(X, Y);
	Line(X + 3*Bw, Y, LineColor);
	Move(X, Y + Bh);
	Line(X + 3*Bw, Y + Bh, LineColor);

	Y := Ty0 + 6*Bh;
	Move(X, Y);
	Line(X + 3*Bw, Y, LineColor);
	Move(X, Y+Bh);
	Line(X + 3*Bw, Y + Bh, LineColor);

	X1 := Tx0 + 3*Bh + BoxOffset;
	Y1 := Ty0 + 3*Bw + BoxOffset;
	X2 := X1 + Bh - BoxOffset*2;
	Y2 := Y1 + Bw - BoxOffset*2;

	\Top left.
	Move(X1, Y1);
	Line(X1+CornerL, Y1, BoxColor);
	Move(X1, Y1);
	Line(X1, Y1+CornerL, BoxColor);

	\Lower right.
	Move(X2, Y2);
	Line(X2-CornerL, Y2, BoxColor);
	Move(X2, Y2);
	Line(X2, Y2-CornerL, BoxColor);

	\Top right.
	Move(X2, Y1);
	Line(X2-CornerL, Y1, BoxColor);
	Move(X2, Y1);
	Line(X2, Y1+CornerL, BoxColor);

	\Lower left.
	Move(X1, Y2);
	Line(X1, Y2-CornerL, BoxColor);
	Move(X1, Y2);
	Line(X1+CornerL, Y2, BoxColor);

	\Put in tokens.
	for M := 0, BoardN-1 do
	begin
		for N := 0, BoardN-1 do
			if ( Board(M,N) = 1 ) then
				DrawToken(Black, M, N);
	end;

	\Put in Solo legend.
	DrawImage(Tx0+2*Bw+(3*Bw-SoloWidth)/2, Ty1+20, SoloBuf, 0);

end; \BuildScreen


proc PlayGame; \Play one game of Solitaire.
begin \PlayGame
    BuildScreen;
	\Make sure Undo command before first game doesn't restore garbage.
	GameCount := GameCount + 1;
	\We may need Savestate, but kill it for now.
	if GameCount = 1 then ; \SaveState;
	MoveI := 0;
	repeat MakeMove until MoveI = MoveN-1;
end; \PlayGame


\-------------------------------------------------------------------------------


proc Initialize;
int I, X, Y, X0, Y0, TokenSize, QuarterSize, DotSize;
int M, N, O;
int Tmp;
int XB0, YB0; \Upper-left corner of button images

begin \Initialize
	Cpureg := Getreg;
	TrapC(true); \Force user to make a clean exit, restoring video mode.

	I := Equip;
	if (I(2)&$08) = 0 then \Test for VGA display.
		[Text(0, "

	This program requires an SVGA display. Sorry.
	");   exit];

	\Initialize mouse.
	Text(0, "Looking for mouse...
	");
	if not OpenMouse then
		[Text(0, "This program requires a mouse. Sorry.
	");   exit];

	VidMode := GetVid;
	Setvid($6A);				\800x600x16, VESA-compatible.
	CallInt($10, $1201, $36); 	\Disable video display.
 	WaitVB;						\Avoid any possible screen glitch.
	AlignPalette;
	LoadLBM("SOLO.LBM");		\Load images into VGA display mem.

	\ImageSize(X0, Y0, X1, Y1, Z),			Get size of image (paragraphs).
	\DrawImage(X, Y, BufSeg, Op),			Draw image in BufSeg at X,Y.
	\SaveMask(X0, Y0, X1, Y1, Z, MaskBuf);	Save copy of mask for the image.
	\SaveImage(X0, Y0, X1, Y1, Z, BufSeg),	Copy image at X,Y into BufSeg.

	\Save mouse pointer image to memory (BIOS doesn't provide one in mode $6A).
	X := 0; Y := 0;
	PointerSize := ImageSize(X, Y, X+PointerWidth-1, Y+PointerHeight-1, $0F);
	PointerBuf := Malloc(PointerSize);
	SaveImage(X, Y, X+PointerWidth-1, Y+PointerHeight-1, $0F, PointerBuf);
	PointerMaskBuf := Malloc(PointerSize);
	SaveMask(X, Y, X+PointerWidth-1, Y+PointerHeight-1, $0F, PointerMaskBuf);

	\Allocate pointer background buffer.
	BackImageBuf := Malloc(PointerSize);
	\Initialize mouse pointer.
	MouseX0 := GetMousePosition(0);
	MouseY0 := GetMousePosition(1);
	MoveMouse(ScreenWidth/2, 200/2); \Show mouse pointer in center of screen.
	SetMouseLimits;

	\Save Token images to memory. The mouse pointer is 15 pixels wide by
	\25 pixels high. All images are separated horizontally by one pixel.
	\To the right of the pointer image are several tokens 27x27 pixels, in
	\different colors and styles (see definitions, or proc SmileyFaces).

	\CAUTION: Token buffer indexing is 1-based. I guess I wanted to count
	\the tokens from 1 to TokenN, as they appear in the lbm file.
	Y := 0;
	X := PointerWidth + 1;
	for N := 1, TokenN do
	begin
		TokenSize := ImageSize(X, Y, X+TokenWidth-1, Y+TokenHeight-1, $0F);
		TokenBuf(N) := Malloc(TokenSize);
		SaveImage(X, Y, X+TokenWidth-1, Y+TokenHeight-1, $0F, TokenBuf(N));
		X := X + TokenWidth + 1;
	end;

	\Read in the 16 hexagon-shaped images that reside in a 4x4 square directly
	\below token # 10. They are same size as tokens.
	X := X - 2*TokenWidth - 2; \Two tokens to the left and one down.
	X0 := X;
	Y := Y + TokenHeight + 1;
	O := 0;
	for M := 0, 3 do
	begin
		for N := 0, 3 do
		begin
			HexBuf(O) := Malloc(TokenSize);
			SaveImage(X, Y, X+HexWidth-1, Y+HexHeight-1, $0F, HexBuf(O));
			O := O + 1;
			X := X + HexWidth + 1;
		end;
		Y := Y + HexHeight + 1;
		X := X0;
	end;

	\Read in the 16 quarter-circle images that reside immediately to the left
	\of the hex images. They are in the form of four circles 55 pixels on a
	\side. We take 27x27 pixels for each quarter circle, leaving the center
	\lines behind, and later combine them into random circles in the corners
	\of the game cross. We use TokenWidth for these calculations.
	X := PointerWidth + 1 +	TokenN * (TokenWidth+1);
	X := X - 2*TokenWidth - 2;
	X := X - 4*QuarterWidth - 4;
	X0 := X;
	Y := TokenHeight + 1;
	O := 0;
	QuarterSize := ImageSize(X, Y, X+QuarterWidth-1, Y+QuarterHeight-1, $0F);
	for M := 0, 3 do
	begin
		for N := 0, 3 do
		begin
			QuarterBuf(O) := Malloc(QuarterSize);
			SaveImage(X, Y, X+QuarterWidth-1, Y+QuarterHeight-1, $0F, QuarterBuf(O));
			O := O + 1;
			X := X + QuarterWidth + 1;
		end;
		Y := Y + QuarterHeight + 1;
		X := X0;
	end;

	\Save BullsEye to memory.
	X := X0;
	\Re-use Quartersize.
	QuarterSize := ImageSize(X, Y, X+2*QuarterWidth+1-1, Y+2*QuarterHeight+1-1, $0F);
	BullsEyeBuf := Malloc(QuarterSize);
	SaveImage(X, Y, X+2*QuarterWidth+1-1, Y+2*QuarterHeight+1-1, $0F, BullsEyeBuf);

	\Save snowflake images to memory.
	X := X0;
	\There are some un-used dot images in solo.lbm, so we space past them.
	Y := Y + 2*QuarterHeight + 3;
	SnowSize := ImageSize(X, Y, X+SnowWidth-1, Y+SnowHeight-1, $0F);
	for M := 0, SnowN-1 do
	begin
		SnowBuf(M) := Malloc(SnowSize);
		SaveImage(X, Y, X+SnowWidth-1, Y+SnowHeight-1, $0F, SnowBuf(M));
		X := X + SnowWidth + 1;
	end;

	\Save large snoflakes images to memory.
	\(I've decided not to use these.)
	X := X0 - OctWidth*3 - 3;
	OctSize := ImageSize(X, Y, X+OctWidth-1, Y+OctHeight-1, $0F);
	for M := 0, OctN-1 do
	begin
		OctBuf(M) := Malloc(OctSize);
		SaveImage(X, Y, X+OctWidth-1, Y+OctHeight-1, $0F, OctBuf(M));
		X := X + OctWidth + 1;
	end;

	\Save Solo to memory.
	X := X0;
	Y := Y + SnowHeight + 1;
	SoloSize := ImageSize(X, Y, X+SoloWidth-1, Y+SoloHeight-1, $0F);
	SoloBuf := Malloc(SoloSize);
	SaveImage(X, Y, X+SoloWidth-1, Y+SoloHeight-1, $0F, SoloBuf);

	\Save a blank area to use as a quarter-round eraser.
	X := PointerWidth + TokenN*(TokenWidth+1);
	Y := 0;
	EraserSize := ImageSize(X, Y, X+QuarterWidth-1, Y+QuarterHeight-1, $0F);
	QEraserBuf := Malloc(EraserSize);
	SaveImage(X, Y, X+QuarterWidth-1, Y+QuarterHeight-1, $0F, QEraserBuf);

	\Save button images to memory. They reside below the pointer and Token
	\images, three pixels below the pointer image, flush left.
	ButtonSize := ImageSize(0, 0, ButtonWidth-1, ButtonHeight-1, $0F);
	XB0 := 0; YB0 := PointerHeight+3;
	I := 0;
	for Y := 0, ButtonN-1 do
		for X := 0, 1 do \Button up + button down
		begin
			ButtonBuf(I) := Malloc(ButtonSize);
			SaveImage(XB0+X*ButtonWidth, YB0+Y*ButtonHeight,
				XB0+(X+1)*ButtonWidth-1, YB0+(Y+1)*ButtonHeight-1,
						$0F, ButtonBuf(I));
			I := I + 1;
		end;

	\Save button mask.
	ButtonMaskBuf := Malloc(ButtonSize);
	SaveMask(XB0, YB0, XB0+ButtonWidth-1, YB0+ButtonHeight-1, $0F, ButtonMaskBuf);

	Clear;
	WaitVB; \Avoid any possible screen glitch.
	CallInt($10, $1200, $36); \Reenable video display.

	\2 marks no-go territory; other values to be filled in later.
	for M := 0, BoardN-1 do
		for N := 0, BoardN-1 do Board(M,N) := 2;

	Bw := Fix(Float(Tw)*2.0);
	Bh := Fix(Float(Th)*2.0);

	EraserWidth := Bw - 3;
	EraserHeight := Bh - 3;

	\Save a blank area to use as a token eraser.
	X := PointerWidth + TokenN*TokenWidth+1;
	Y := 0;
	EraserSize := ImageSize(X, Y, X+EraserWidth-1, Y+EraserHeight-1, $0F);
	EraserBuf := Malloc(EraserSize);
	SaveImage(X, Y, X+EraserWidth-1, Y+EraserHeight-1, $0F, EraserBuf);

	Tx0 := 190;
	Ty0 := 80;
	Tx1 := Tx0 + 7*Bw;
	Ty1 := Ty0 + 7*Bh;

	\Set coordinate origins for quarter-round images.
	Qx(0) := Tx0 + Bw;		\Upper left.
	Qx(1) := Tx0 + Bw*6;	\Upper right.
	Qx(2) := Qx(0);			\Lower left.
	Qx(3) := Qx(1);			\Lower right.

	Qy(0) := Ty0 + Bh;		\Upper left.
	Qy(1) := Qy(0);			\Upper right.
	Qy(2) := Ty0 + Bh*6;	\Lower left.
	Qy(3) := Qy(2);			\Lower right.

	\Set coordinates of upper-left box corners in Boardx+y arrays
	\plus offset coordinates of tokens in Trx+y arrays..
	Y := Ty0;
	for M := 0, BoardN-1 do
	begin
		X := Tx0;
		for N := 0, BoardN-1 do
		begin
			Boardx(M,N) := X;
			Boardy(M,N) := Y;
			Trx(M,N) := X + (Bw-TokenWidth)/2 + 1;
			Try(M,N) := Y + (Bh-TokenHeight)/2;
			X := X + Bw;
		end;
		Y := Y + Bh;
	end;

	\Coordinates of the game cross.
	MN := [ [0,2], [0,3], [0,4], [1,2], [1,3], [1,4],
			[2,0], [2,1], [2,2], [2,3], [2,4], [2,5], [2,6],
			[3,0], [3,1], [3,2], [3,3], [3,4], [3,5], [3,6],
			[4,0], [4,1], [4,2], [4,3], [4,4], [4,5], [4,6],
			[5,2], [5,3], [5,4], [6,2], [6,3], [6,4] ];

	MoveI := 0;
	BoardFlag := false;
	TextDevice := 0;
	GameCount := 0;
	MoveCount := 0;

end; \Initialize


\===============================================================================


begin \Main
	Initialize;
	loop PlayGame;
end; \Main
