/******************************************************************************
 SCI Template Game
 By Brian Provinciano
 ******************************************************************************
 titlescreen.sc
 Contains the title screen room.
 ******************************************************************************/
(include "sci.sh")
(include "game.sh")
/******************************************************************************/
(script 405)
/******************************************************************************/
(use "main")
(use "game")
(use "menubar")
(use "obj")
(use "cycle")
(use "user")
(use "controls")
(use "feature")
(local
ready2
clicked
)
/******************************************************************************/
(instance public TitleScreen of Rm
	(properties
		picture 405
	)
	(method (init)
        // Set up the title screen
		ProgramControl()
		= gProgramControl FALSE
		(send gGame:setSpeed(1))
		(SL:disable())
		(TheMenuBar:hide())

		(super:init())
		(self:setScript(RoomScript))

		(send gEgo:
			init()
			hide()
         )



        /**************************************************
         * Add the rest of your initialization stuff here *
         **************************************************/
     = gTimeSeconds 9
     (aScreen: init() setCycle(Fwd))
 )
)
/******************************************************************************/
(instance RoomScript of Script
	(properties)

(method (changeState newState)
 = state newState
  (switch (state)
    (case 0
   (aDoor:init())
   (send gGame:setSpeed(5))
      (aElevator: init() setCycle(End))
      (aE: init() setMotion(MoveTo 175 1 RoomScript))
      )
      (case 1
     (aDoor: setCycle(End))
     (aMan: init())
      (aE: init() setMotion(MoveTo 150 1 RoomScript))
     )
     (case 2
     (aDoor: posn(1 2))
    (aMan: setCycle(Walk) setMotion(MoveTo 104 131 RoomScript))
      )
      (case 3
       (aMan2: init() setCycle(Walk) setMotion(MoveTo 129 139 RoomScript))
      (aMan:loop(0))
      )
      (case 4
      Print("How's the Moon Base?" #title"Alien:" #at 30 60 #icon 777 0 1)
      Print("Everything is going as planned sir!" #title"Humanoid:" #at 70 140 #icon 778 0 3)
      Print("Did some research on our target, planet Earth. Pretty advanced civilization is living on that planet." #title"Alien:" #at 30 60 #icon 777 0 1)  = clicked 1
      Print("Really? Give the research to Lord Bather, so he can make a war plan." #title"Humanoid:" #at 70 140 #icon 778 0 3) = clicked 1
      Print("Is the laser operational?" #title"Alien:" #at 30 60 #icon 777 0 1) = clicked 1
      Print("Engineers are working full time." #title"Humanoid:" #at 70 140 #icon 778 0 3) = clicked 1
       Print("Good ... good!" #title"Alien:" #at 30 60 #icon 777 0 1)  = clicked 1
       Print("If you excuse me, I have to go now." #title"Humanoid:" #at 70 140 #icon 778 0 3) = clicked 1
        Print("Dismissed!" #title"Alien:" #at 30 60 #icon 777 0 1) = clicked 1
        Wait(20)
         (aMan2: setCycle(Walk) setMotion(MoveTo 0 139 RoomScript))

        )
        (case 5
        (aMan2: hide())

          DrawPic(8)
          (aMan: hide())
          (aElevator: hide())
          (aScreen: hide())
Display("But enough for now; let's get" dsCOORD 70 87 dsCOLOUR clNAVY dsBACKGROUND clTRANSPARENT dsFONT 900)
Display("this game started!" dsCOORD 95 97 dsCOLOUR clNAVY dsBACKGROUND clTRANSPARENT dsFONT 900)
Display("But enough for now; let's get" dsCOORD 71 86 dsCOLOUR clBLUE dsBACKGROUND clTRANSPARENT dsFONT 900)
Display("this game started!" dsCOORD 96 96 dsCOLOUR clBLUE dsBACKGROUND clTRANSPARENT dsFONT 900)
(aE: init() setMotion(MoveTo 0 1 RoomScript))
)
(case 6
 (send gRoom:newRoom(INITROOMS_SCRIPT))

    )
    )
    )
	(method (handleEvent pEvent)
      (var button2)
        (super:handleEvent(pEvent))
        (if( not (send pEvent:claimed) )
			(if( (== (send pEvent:type) evKEYBOARD))
        = button2 Print(
  "Are you sure you want to cancel the intro. It includes some useful clues."
  #title "Make your selection:"
  #font 999
  #button " No " 1
  #button " Yes " 0
)
(if(== button2 0)
 (send gRoom:newRoom(INITROOMS_SCRIPT))
 return
)(else
return

))))
(method(doit)
(if(== gTimeSeconds 7)
= clicked 0
)
)
)

(instance aMan of Act
(properties
view 32
x 80
y 98

))
(instance aDoor of Act
(properties
view 48
x 84
y 104
cycleSpeed 1
))
(instance aElevator of Prop
(properties
view 47
x 82
y 42
cycleSpeed 3
))
(instance aE of Act
 (properties
 view 300
 x 1
 y 1
 ))
(instance aMan2 of Act
(properties
view 127
x 319
y 139

))
(instance aScreen of Prop
(properties
view 405
x 215
y 70
))
