/******************************************************************************/
(include "sci.sh")
(include "game.sh")
/******************************************************************************/
(script 22)
/******************************************************************************/
(use "controls")
(use "cycle")
(use "door")
(use "feature")
(use "game")
(use "inv")
(use "main")
(use "obj")
/******************************************************************************/
(instance public rm022 of Rm
	(properties
		picture scriptNumber
		north 0
		east 0
		south 144
		west 0
	)
	(method (init)
		(super:init())
		(self:setScript(RoomScript))

		(switch(gPreviousRoomNumber)
			(default
				(send gEgo:
					posn(93 185)
					loop(3)
				)
			)
		)

		SetUpEgo()
		(send gEgo:init())
  = righty TRUE
  (aKey: init())
	)
)
/******************************************************************************/
(instance RoomScript of Script
	(properties)
 
  (method (handleEvent pEvent)
     (var dyingScript)
(super:handleEvent(pEvent))
(if(Said('open,read,use,(use<with)/drawer,file,cabinet,(file<drawer)') or (if(Said('take/map'))))
Print("The file cabinet is in the other end of the office. You can't reach it from this point.")
)
 (if(Said('take>'))
 (if(Said('/key'))
 Print("You can't reach the key from this distance.")
 )
 (if(Said('/'))
 Print("You have no need to take it.")
 )
 )
(if(Said('touch/beam'))
 = dyingScript ScriptID(DYING_SCRIPT)
  (send dyingScript:
    caller(3)
register("The beam cut off your hand and in horrible pain you fell on the floor. Right into another beam which cuts through your eye and into your brain.")
  )
  (send gGame:setScript(dyingScript))
)
(if(Said('deactivate,(turn<off)/beam,(security<beam)'))
Print("You can't do it from here. It's been turned off somewhere else.")

)
 (if(Said('look>'))
(if(Said('/desk'))
(if(send gEgo: has(INV_VESSEL_KEY))
Print("It's just a regular desk. Nothing special about it.")
return
)
Print("It's just a regular desk. There's a key on the desk.")
)
)
(if(Said('/drawer,file,cabinet,(file<drawer)'))
Print("Usually some important papers are held in those kind of drawers.")

)
(if(Said('/key'))
(if(send gEgo: has(INV_VESSEL_KEY))
Print("It's in your inventory. To see it press TAB.")
return
)
Print("This key is too far away to see.")
)
(if(Said('/window'))
Print("You can see a building on a flying island outside.")
)
(if(Said('/painting'))
Print("It's not very beautiful to look at.")
)
(if(Said('/island'))
Print("They are not connected to anything but they still stay up. Unknown gravity...")
)
(if(Said('/building'))
Print("It looks like a residental building.")
)
(if(Said('/carpet'))
Print("This carpet gives this room a special look... Also there are a lot of security beams across the floor.")
)
(if(Said('/wall,ceiling'))
Print("You don't see anything special about it.")
)
(if(Said('/chair'))
Print("This chair looks comfortable, but no time to sit.")
)
(if(Said('/beam'))
Print("I wonder how these beams are turned off.")
)
(if(Said('/'))
Print("You're in some office. There's a file drawer, desk, window and some paintings. Through the window you can see a building. There are a lot of security beams across the floor.")
  )
  )
 (method(doit)
  (var dyingScript)
 (if(==(send gEgo: onControl()) ctlBLUE)
 = dyingScript ScriptID(DYING_SCRIPT)
  (send dyingScript:
    caller(3)
register("The beams cut through your legs and you were in an unbearable pain until you bled to death.")
  )
  (send gGame:setScript(dyingScript))
 )
 )
 )
 (instance aKey of Prop
(properties
view 131
x 116
y 90
priority 14
))
/******************************************************************************/
