/******************************************************************************/
(include "sci.sh")
(include "game.sh")
/******************************************************************************/
(script 19)
/******************************************************************************/
(use "controls")
(use "cycle")
(use "door")
(use "feature")
(use "game")
(use "inv")
(use "main")
(use "obj")
/******************************************************************************/
(instance public rm019 of Rm
	(properties
		picture scriptNumber
		north 0
		east 0
		south 0
		west 0
	)
	(method (init)
		(super:init())
		(self:setScript(RoomScript))

		(switch(gPreviousRoomNumber)
			(default
				(send gEgo:
					posn(113 126)
					loop(3)
				)
			)
		)

		SetUpEgo()
		(send gEgo:init())
  (aScreen: init() setCycle(Fwd))
  (smallScreen: init()cel(0))
  (if(roofOpen)
  (smallScreen: cel(1))
  )
	)
)
/******************************************************************************/
(instance RoomScript of Script
(properties)
(method (handleEvent pEvent)
(super:handleEvent(pEvent))
(if(Said('take,touch,pull/cable,wires'))
(if(not(warnedWire))
Print("I'm warning you. Don't touch these wires!")
= warnedWire TRUE
return
)
Print("I told you not to touch these. You lose 1 point.")
-= GameScore 1
)
(if(Said('press,activate,start,use/button,computer,machine') or (if(Said('press,activate,start/(start<button)'))))
 (if(==(send gEgo: onControl()) ctlYELLOW)
(if(roofOpen)
Print("It's been already done.")
return
)
Print("Ok")
Wait(30)
Print("You hear a sound coming above you. It sounds like the bay door up at the roof is opening.")
= roofOpen TRUE
+= gScore 3
(smallScreen: cel(1))
return
)
Print("You're not close enough to the computer.")
return
)
(if(Said('look>'))
(if(Said('/window'))
Print("You can see to the lift-off room.")
)
(if(Said('/cable,wires'))
= warnedWire TRUE
Print("Better don't touch any of those because they are very important cables.")
)
(if(Said('/screen,monitor,display'))
Print("Some text in some unknown language is scrolling on the screen. It's like a screensaver.")
)
(if(Said('/indicator,light'))
Print("This should show if the roof is open or not.")
)
(if(Said('/floor,wall,ceiling'))
Print("It's not very interesting to look at.")
)
(if(Said('/button'))
Print("It's marked 'Start'.")
)
(if(Said('/platform'))
Print("This is the platform you have to walk on to get to the rocket.")
)
(if(Said('/rocket,spaceship,freight'))
Print("This is the one you're going aboard. Roger that Houston!")
)
(if(Said('/computer,console,keypad,machine'))
Print("There are a lot of buttons on it. One is marked as 'Start'. This should activate all the take-off operations.")
)
(if(Said('/'))
(if(roofOpen)
Print("This is the control room for the rocket. There's a big computer, lots of cables running on the floor and a screen above the window. Next to the window there's a small indicator which is green at the moment.")
return
)
Print("This is the control room for the rocket. There's a big computer, lots of cables running on the floor and a screen above the window. Next to the window there's a small indicator which is red at the moment.")

)
)
)
 (method(doit)
 (if(==(send gEgo: onControl())ctlRED)
 (send gRoom: newRoom(17))
 )
 )
)
/******************************************************************************/
(instance aScreen of Act
(properties
view 10
x 136
y 59
cycleSpeed 2
))
(instance smallScreen of Act
(properties
view 702
x 181
y 70
cycleSpeed 2
))
