/******************************************************************************/
(include "sci.sh")
(include "game.sh")
/******************************************************************************/
(script 10)
/******************************************************************************/
(use "controls")
(use "cycle")
(use "door")
(use "feature")
(use "game")
(use "inv")
(use "main")
(use "obj")
(local
dyingScript
)
/******************************************************************************/
(instance public rm010 of Rm
	(properties
		picture scriptNumber
		north 0
		east 9
		south 0
		west 12
	)
	(method (init)
		(super:init())
		(self:setScript(RoomScript))

		(switch(gPreviousRoomNumber)
			(case 9

				(send gEgo:
					posn(315 135)
					loop(1)
				)
			)
   (case 12
				(send gEgo:
					posn(5 140)
					loop(0)
				)
			)
		)

		SetUpEgo()
		(send gEgo:init())
    (aOxLevel: init() cel(oxLev))
      = objective 4
      (if(keypadOpen)
      (if(not(doorOpened))
      (aKeypad: init() cel(0))
      (if(wc)
      (aKeypad: cel(1))
      )
      (if(bc)
      (aKeypad: cel(2))
      )
      )
      )
    (if(doorOpened)
    DrawPic(11)
    = objective 5

  )
  
   = gTimeSeconds2 0
	)
)
/******************************************************************************/
(instance RoomScript of Script
	(properties)
  (method(doit)
 (if(== gTimeSeconds2 2)
 = gTimeSeconds2 0
  (aOxLevel: cel(oxLev))
  += oxLev 1
 )
   (if(== oxLev 16)
    = dyingScript ScriptID(DYING_SCRIPT)
  (send dyingScript:
    caller(3)
    register("You couldn't hold your breath any longer.")
  )
  (send gGame:setScript(dyingScript))
  )
 )
 (method (handleEvent pEvent)
        (super:handleEvent(pEvent))
   (if(Said('climb/tree'))
   Print("Nah!")
   )
        (if(Said('short,(short<circuit)/keypad,button'))
           Print("You need some power source and a something to connect it with. Like a wire.")
           )
        (if(Said('use,place,connect/wire/keypad') or (Said('use,place,connect/wire')))
                     (if(not(keypadOpen))
             Print("You first have to remove the cover of the keypad.")
             return
             )
       (if(== (send gEgo:onControl()) ctlRED)
       (if(send gEgo:has(INV_WIRES))
        (if(wc)
        Print("You already connect it.")
        return
        )
        Print("Ok")
         += gScore 2
        Print("You connect the wire to the keypad.")
        Print("But nothing happens.")
        (aKeypad: cel(1))
        = wc TRUE
         (send gEgo:put(INV_WIRES scriptNumber))
        return
        )
        Print("You don't have a wire.")
        return
        )
        Print("You're too far away from the keypad.")
        )
         (if(Said('connect,place,use/battery,electricity/wire,keypad') or (Said('use,place,connect/battery,electricity')))
             (if(not(keypadOpen))
             Print("You first have to remove the cover of the keypad.")
             return
             )
       (if(== (send gEgo:onControl()) ctlRED)
       (if(send gEgo:has(INV_BATTERIES))
        (if(bc)
        Print("You already connect it.")
        return
        )
         (if(wc)
        Print("Ok")
        Print("You connect the battery with the wire...")
        (aKeypad: cel(2))
        (aSpark: init() cycleSpeed(0) setCycle(End))
         = bc TRUE
         += gScore 3
         = doorUnlocked TRUE
         (send gEgo:put(INV_BATTERIES scriptNumber))
            Print("Now you can open the door.")

        return
        )

        Print("You need some connector to lead the electricity into the keypad. Like a wire.")
        return
        )
        Print("You don't have a source of elctricity. Like a battery or something.")
        return
        )
        Print("You're too far away from the keypad.")
        )
            (if(Said('remove/cover,(keypad,button<cover)'))
                          (if(not(== (send gEgo:onControl()) ctlRED))
              Print("You're not close enough to the keypad.")
              return
              )
             (if(keypadOpen)
             Print("You already removed the cover.")
             return
             )
             Print("Ok")
Print("You remove the cover of the keypad. Some electronics show up. Now if you connect some electricity into it, it should shorten its circuit.")
             = keypadOpen TRUE
             (aKeypad: init())
             += gScore 1
             return

            )
      (if(Said('open>'))
            (if(Said('/keypad,button,cover'))
              (if(not(== (send gEgo:onControl()) ctlRED))
              Print("You're not close enough to the keypad.")
              return
              )
             (if(keypadOpen)
             Print("You already removed the cover.")
             return
             )
             Print("Ok")
 Print("You remove the cover of the keypad. Some electronics show up. Now if you connect some electricity into it, it should shorten its circuit.")
             = keypadOpen TRUE
             += gScore 1
             (aKeypad: init())
             return
             )
            (if(Said('/door'))
        (if(doorOpened)
        Print("It's already opened.")
        return
        )
       (if(== (send gEgo:onControl()) ctlNAVY)

          (if(doorOpened)
       Print("You already opened it.")
       return
       )
        (if(doorUnlocked)
       = doorOpened TRUE
       (aKeypad: dispose())
       Print("Ok")
       DrawPic(11)
       = objective 5
       return
       )
       Print("It's locked. There's a keypad next to the door.")
       return
       )
       Print("You're too far away from the door.")
       )
       )
      (if(Said('look>'))

            (if(Said('/ground'))
            Print("It looks very strange.")
            )
            (if(Said('/keypad'))
(if(not(keypadOpen))
Print("You need to enter a code to open the door. But since you don't know the code you have to do something else. The keypad has a cover that can be removed to reveal the electronics.")
return
)
(if(wc and (if(not(bc))))
Print("There's a wire connected to the keypad.")
return
)
(if(wc and (if(bc)))
Print("There's a wire connected to the keypad. A battery is connected to the wire.")
return
)
Print("The cover of the keypad has been removed. Now if you connect some electricity into it, it should shorten its circuit.")
            )
            (if(Said('/door'))
            Print("You need to get this door open.")
            )
            (if(Said('/tree'))
            Print("Now this is more like a tree, not like the one in the previous scenery.")
            )
            (if(Said('/glass,wall'))
            Print("It seems be somekind of a wall to protect the inside world. There's a keypad next to the door on the wall.")
            )
            (if(Said('/space'))
            Print("Strange. You're in space but you can breath. That means here's some Oxygen.")
            )
            (if(Said('/sky'))
            Print("There's sky only behind the glass wall.")
                                   )
            (if(Said('/stars'))
            Print("They are too far to see them, so you can only see the light coming from them. The star itself may not exist anymore but the light coming from it is still traveling.")

            )
            (if(Said('/grass'))
            Print("I'm not really sure it's called grass around here.")
            )
            (if(Said('/'))
            Print("There's a big glass wall and a door in the center. And a keypad next to the door.")

        )
        )

)
)
(instance aSpark of Act
(properties
view 123
x 137
y 96
))
(instance aKeypad of Act
(properties
view 406
x 64
y 85
))
(instance aOxLevel of Act
(properties
view 64
x 20
y 185
))
/******************************************************************************/
