/******************************************************************************
 SCI Template Game
 By Brian Provinciano
 ******************************************************************************
 menubar.sc
 Contains the customized Menubar class. This is the script you modify if you
 want to customize the menu.
 ******************************************************************************/
(include "sci.sh")
(include "game.sh")
/******************************************************************************/
(script MENUBAR_SCRIPT)
/******************************************************************************/
(use "main")
(use "controls")
(use "sound")
(use "user")
(use "cycle")
(local
  score2[1]

)
/******************************************************************************/
(class TheMenuBar of MenuBar
	(properties
		state 0
	)
	(method (init)
		AddMenu(
			"  Fungame  "
				"About   `^a:"+
				"Help`#1"
		)
		AddMenu(
			"  File  "
				"Restart Game`#9:"+
				"Save Game`#5:"+
				"Restore Game`#7:"+
                "Autosave`#4:"+
                "--! :"+
				"Quit`^q"
		)
		AddMenu(
			"  Action  "
				"Pause Game`^p:"+
				"Inventory`^I:"+
                "Clone`#3:"+
                "Toggle Sound`#2:"+
                "Sound Volume`#8:"+
				"Change Layout`^L"


		)
		AddMenu(
			"  Speed  "
				"Increase`+:"+
                "Decrease`-:"
		)



		SetMenu(MENU_SAVE		smMENU_SAID 'save[/game]')
		SetMenu(MENU_RESTORE	smMENU_SAID 'restore[/game]')
		SetMenu(MENU_RESTART	smMENU_SAID 'restart[/game]')
		SetMenu(MENU_QUIT		smMENU_SAID 'done[/game]')
		SetMenu(MENU_PAUSE		smMENU_SAID 'delay[/game]')
		SetMenu(MENU_INVENTORY	smMENU_SAID 'all')
	)
	(method (handleEvent pEvent)
		(var menuItem, hGauge, newSpeed, newVolume, wndCol, wndBack, hPause, but, sc, vol, layout)
		= menuItem (super:handleEvent(pEvent))
		(switch(menuItem)


			(case MENU_ABOUT
				Print(
     0 42

					#title "About This Game" #font 999  #icon 147 0 0
				)
                Print(
            0 36

					#title "SCI Studio" #font 999 #icon 149 0 0
				)
       Print(0 37 #title "The Band:" #icon 148 0 2)
    Print(
     0 35
					#title "Online Stuff:" #font 999 #icon 148 0 1
				)

     Print(
        0 34
				#title "Beta Testers:" #font 999 #icon 148 0 0
    )
   Print(0 33 #title "Whada ya want?" #icon 148 0 3)


   )
			(case MENU_HELP
				Print(
                    0 32
					#title "Help! I'm stuck..." #icon 149 0 1
				)
    Print(
     0 41
					#title "KEYS:" #icon 149 0 2
				)
    //FormatPrint("You have %d points out of %d. Keep on playing!" gScore gMaxScore)
			)
			(case MENU_RESTART

				(if(Print(
                        0 31
					  #title "Press CTRL-ALT-DEL"
                       #icon 44 0 0
					  #button "Restart" 1
					  #button " Noooo! " 0
					)
				   )
					(send gGame:restart())
				)

			)
			(case MENU_RESTORE
  = savedGame3 10
				(send gGame:restore())
     = savedGame2 77


              )
   (case MENU_SNDVOL
    = voll Print("Select your sound volume:\n\n" #button "Soft" 5 #button "Normal" 9 #button "Loud" 15 #button "Other" 99)
    (if(== voll 99)
    = voll GetNumber("Enter the sound volume (0-15):")
    (if(not(>= voll 0) and (<= voll 15))
     = voll 8
     )
    )
     DoSound(sndVOLUME voll)
			)
			(case MENU_SAVE
				(send gGame:save())
			)
   		(case MENU_LOOK
    = layout Print(0 38 #button " Default " 1 #button " AGI " 2 #button " Gray " 3 #button " Pirate! " 4)
(if(== layout 1)
= buttonBg 15
= lookView1 900
= lookView2 901
)
(if(== layout 2)
= buttonBg 15
= lookView1 905
= lookView2 904
)
(if(== layout 3)
= buttonBg 15
= lookView1 913
= lookView2 915
)
(if(== layout 4)
= buttonBg 14
= lookView1 916
= lookView2 917
)
)
			(case MENU_QUIT

				(if(Print(
					  "      Do you really want to quit  \n   "+
                      "  and leave Dr.Jummybummy all \n     alone here?             "
					  #title "Be serious now!"
                      #icon 7 0 0
					  #button " Of course! " 1
                      #button " Nah! " 0
					)


   				)


						= gQuitGame TRUE
				)

			)
			(case MENU_PAUSE
				= hPause (Sound:pause())
 				Print(0 39 #title"Dr.Jummybummy:  " #icon (send gEgo: view) 2 0)
 				(Sound:pause(hPause))
			)
			(case MENU_INVENTORY
 (send gInv:showSelf(gEgo))
)
(case MENU_RETYPE
				(send pEvent:
					claimed(FALSE)
					type(evKEYBOARD)
					message( (User:echo) )
				)
			)
			(case MENU_AUTOSAVE
          (if(== gRoomNumber 133)
          = enemyLives 0
          return
          )
     = autoV GetNumber("After how many minutes do you want the game to remind you to save?\n\nType 0 for no Autosave.\n")
     (if(<> autoV 0 <= autoV 60)
     (if(<= autoV -1)
     Print("No Autosave feature")
     = autoV 0
     return
     )
     = autoSave 0
     return
     )
     Print(0 40)
     = autoV 60
     )

			(case MENU_CHANGESPEED
  	(if(gSpeed)
					(send gGame:setSpeed(--gSpeed))
				)
			)


    (case MENU_SLOWER
 (if(< gSpeed 15)
					(send gGame:setSpeed(++gSpeed))
				)
			)

(case MENU_TOGGLESOUND
ToggleSound()
   )


 )
 )
 )

/******************************************************************************/
(procedure public (ToggleSound)
	(var SOUND_OFF)
	= SOUND_OFF DoSound(sndSET_SOUND)
	= SOUND_OFF DoSound( sndSET_SOUND not(SOUND_OFF) )
	(if(SOUND_OFF)

	)(else

	)
)
/******************************************************************************/
