/******************************************************************************
 SCI Template Game
 By Brian Provinciano
 ******************************************************************************
 main.sc
 Contains the game's main instance and inventory items.
 ******************************************************************************/
(include "sci.sh")
(include "game.sh")
/******************************************************************************/
(script MAIN_SCRIPT)
/******************************************************************************/
(use "controls")
(use "sound")
(use "syswindow")
(use "cycle")
(use "game")
(use "inv")
(use "user")
(use "menubar")
(use "feature")
(use "obj")
(use "disposeload")
/******************************************************************************
 * These are the global variables. You can access them from any script as long
 * as it "use"es this script
 ******************************************************************************/
(local
	gEgo					/* points to the ego's class */
	gGame					/* points to the game instance */
	gRoom					/* points to the current room instance */
	gSpeed 					/* the game speed (delay each interpreter cycle) */
	gQuitGame = FALSE		/* if set to TRUE, the game will exit */
	
	gCast					/* points to the cast class (list of actors) */
	gRegions				/* points to the regions class (list of regions) */
	gLocales 				/* points to the locales class (list of locales) */
	gTimers					/* points to the timers class (list of timers) */
	gSounds					/* points to the sounds class (list of sounds) */
	gInv					/* points to the inventory class */
	gAddToPics				/* points to the add to pics class */
	gFeatures				/* points to the add to features class */		
	gSFeatures				/* points to the add to sfeatures class */

	gRoomNumberExit			/* room number exit */
	gPreviousRoomNumber		/* the number of the previous room */
	gRoomNumber				/* the number of the current room */ 
	gDebugOnExit = FALSE	/* enter debug mode on room exit */ 
	camWarn
	gScore = 0				/* the game score */		
	gMaxScore = 231     	/* the maximum game score */
	gOldScore				/* previous score */

	gCurrentCursor			/* the number of the current cursor */
	gNormalCursor = 999		/* the number of the normal cursor (ie. arrow) */
	gLoadingCursor = 997	/* the number of the loading cursor (ie. hand) */
	
	gDefaultFont = 1		/* the number of the default font */
	gSaveRestoreFont = 0	/* the number of the font for the save/restore dialogs*/
	gDeadFont = 0			/* the number of the font for the dialog when ego dies */
	
	gUserEvent				/* points to the user's event object */
	gPrintDlg				/* points to the current Print() window */
	gVolume					/* the sound volume */
	gVersion				/* the version string */
	gSaveDirPtr				/* points to the save directory string */
	gCheckAniWait			/* the checkAni delay */
	gSetRegions				/* a flag -- see User:doit() */
	
	gPicAngle				/* the room's pic angle */
	gOverlay = -1			/* whether to overlay the picture when drawing */
	gDefaultPicAni			/* the default pic animation */
	gDefaultPalette = 0	    /* the default palette to use for the pictures (0-3) */
	gCastMotionCue			/* if set, the cast's motionCue() is called */
	
	gTheWindow				/* points to the window class */
	gWndColor				/* the colour of the game's windows foreground (ie. text) */
	gWndBack				/* the colour of the game's windows background */

	gOldPort				/* the previous port */
	warnedWire = FALSE
	gEgoView				/* ego's current view number */
	colorN
 
	/* hh:mm:ss | gTimeHours:gTimeMinutes:gTimeSeconds */
	/* the time elapsed since the game started */
	gTimeSeconds			/* the seconds */
	gTimeMinutes			/* the minutes */
	gTimeHours				/* the hours */
	
	gCurrentTime				/* the current time in seconds */
    connected = FALSE
	gTheMusic				/* points to the music class */
	gTheSoundFX				/* points to the sound fx class */
	gProgramControl 		/* states whether the program has control or the user */
 /////////////////////////////////////////
 //DO NOT CHANGE THESE VARIABLES BELOW!///
 /////////////////////////////////////////
 //I think you got the point? Capice? You don't want to mess with the Lenk Family!
    lookView1 = 900 //900, 905, 908, 911, 913
    lookView2 = 901 //901, 904, 909, 912, 915
    mouseX
    mouseY
    spp
    beenToTheRebels = FALSE
    avatar = 18
    light = FALSE
    button = FALSE
    power = FALSE
    activated = FALSE
    musicRe = FALSE
    voll = 15
    mailbox = FALSE
    room5 = FALSE
    theft = FALSE
    locked = FALSE
    oxLev = 15
    trans = FALSE
    doorOpened = FALSE
    doorUnlocked = FALSE
    bc = FALSE
    shotsLeft
    wc = FALSE
    al = FALSE
    repaired = FALSE
    lineIs = FALSE
    talkedBum = FALSE
    ro1 = 0
    ro2 = 0
    ro3 = 0
    wire
    numm3
    money = 10
    cash = 10
    bet = 2
     wire2
     ex ey
     GameScore
     slotsMaxedOut2 = FALSE //if true, player can't play slots at the bar anymore
     woodPlaced = FALSE
     sysLocked = FALSE
    chief = FALSE
    removed = FALSE
    converse = FALSE
    powercut = FALSE
    packageTaken = FALSE
    pickedLock = FALSE
    sonny = FALSE
    flash = FALSE
    lef = FALSE
    righty = FALSE
    backy = FALSE
    deactivated = FALSE
    buttonNumber = 0
    jokeNum = 0
    hasFlashlight = FALSE
    Xposn = 0
    info = FALSE
    music77
    killed = FALSE
    tManClub = FALSE
    bayDoor = FALSE
    bayOpen = FALSE
    Xposn2
    gaveMon = FALSE
    needCode = FALSE
    autoSave = 0
    autoV = 5 //Default Autosave time
    guardD
    postman = FALSE
	gTimeSeconds2 = 0
	gTimeMinutes2 = 0
    carpetMoved = FALSE
	gTimeHours2 = 0
 	gTimeSeconds3 = 0
	gTimeMinutes3 = 0
	gTimeHours3 = 0
 invited = FALSE
 inve2 = FALSE
    grassBurned = FALSE
    bummm = FALSE
    noteShown = FALSE
    holeOpen = FALSE
    bigDoorOpen = FALSE
    score = 0
    entered = FALSE
    haveCard = FALSE
    randomCode = 0
    enteredTalk = FALSE
    randomMusic = 0
    onCyan = FALSE
    enterBase = FALSE
    readyLaunch = FALSE
    roofOpen = FALSE
    openn = FALSE
    warning = FALSE
    Yposn = 0
    numm2 = 0
    jonny = FALSE
    talkedSaler = FALSE
    hasWater = FALSE
    hasRope = FALSE
    ropeUsed = FALSE
    carIsParked = FALSE
    climbed = FALSE
    objective = 0
    expletive = 0
    meanwhile = FALSE
    guardT = FALSE
    oxygen = 140
    games = FALSE
    viewNum1
    OldGameSpeed
    viewNum2
    viewNum3
    numm = 70
    rope1 rope2 rope3
    hidd = FALSE showAir = FALSE scoree = FALSE talkedGuy2 = FALSE
    talkedWo = FALSE
    gaveWater = FALSE
    filledTank = FALSE
    talkBar = FALSE
    talkkk = FALSE
    showed = FALSE
    tt = FALSE
    deadOver = FALSE
    firstTime = FALSE
    debugOn = FALSE
    talkRebel = FALSE
    onRed = FALSE
    animStart = FALSE
    escape = FALSE
    freeStand = FALSE
    corridorDoor = FALSE shoot = FALSE lidOpen = FALSE
    localCode  xx    yy
    glassesOn   anim
    bridgeDown
    ggg
    BusIs = FALSE
    vari1
    filledBottle
    placedWater
    bartender
    fireAlarm
    hFile = 0
    rebelsCalled = FALSE
    salersNum = 0
    granz = FALSE
    ladderPlaced = 0
    ladderX = 0
    savedGame2 = FALSE
    savedGame3 = 0
    PlayerLives = 40
    enemyLives = 100
    sec2 = 0
    sec3
    keypadOpen = FALSE
    guard1Down = FALSE
    dynPlaced = FALSE
    cheatUsed = FALSE
    debugMode = FALSE // FALSE
    dialog = 0
    sshow = 4
    sshow2 = 12
    BaseText = 0
    pushed = FALSE
    gasTanked = FALSE
    windowOpen = FALSE
    onBarrel = FALSE
    side = 0
    paperTaken = FALSE
    paperGiven = FALSE
    dug = FALSE shovelTaken = FALSE holeBroke = FALSE
    buttonBg = 15
)
/******************************************************************************/
(instance public Jummy_2 of Game
	(properties)
	(method (init)
        // Set up the base window
		= gTheWindow theWindow
		= gWndColor  0
		= gWndBack 15
		(send gTheWindow:
            color(gWndColor)
		    back(gWndBack)
		)

		(super:init())
	    (SL:code(statusCode))
	    (TheMenuBar:init())
         = gVersion "1.0"

	    = gTheMusic theMusic
	    (send gTheMusic:
	    	owner(self)
	    	init()
	    )
		= gTheSoundFX theSoundFX
	    (send gTheSoundFX:
	    	owner(self)
	    	init()
	    )
	    
	    = gEgo ego
	    (User:
	    	alterEgo(gEgo)
	    	blocks(0)
	    	y(150)
	    )

		Load(rsFONT		gDeadFont)
		Load(rsFONT		gDefaultFont)
		Load(rsFONT		gSaveRestoreFont)
	
		Load(rsCURSOR	gNormalCursor)
		Load(rsCURSOR	gLoadingCursor)
			
	    (if(HaveMouse())
	    	(send gGame:setCursor(gNormalCursor SET_CURSOR_VISIBLE))
		)(else
	    	(send gGame:setCursor(gNormalCursor SET_CURSOR_VISIBLE 304 174))
		)
			(Inv:
			add(
{Nothing}{Keycard}{Flashlight}{Calculator}{Transmitter}{Letter}
{Key}{Note}{Batteries}{Wires}{Knife}{Hairpin}
{Map}{Vessel Key}{Spacesuit}{Signal Device}
{Paper}{Card}{Course Key}{Rope}{Bottle of water}{Diamond}{Radio}{Glasses}{Authorization Key}{Maze Map}
{Moon Stone}{Empty Bottle}{Money}{Tools}{Hotel Room Key}{Ladder}{Sniper}{Dynamato}{Axe}{Shovel}
{Car key}{House key (Spare)}{Wall Tile}{Gas}{Free Magazine}{Wooden Board}{Dry grass}
			))

		(if(GameIsRestarting())
	    	(self:newRoom(INITROOMS_SCRIPT))
	    )(else
	    	(self:newRoom(TITLESCREEN_SCRIPT))
		))
	(method (doit)
 (var button5, dyingScript, ox, oxx)
		(super:doit())
  (if(gProgramControl)
			(User:
				canControl(FALSE)
				canInput(FALSE)
			))
  (if(>= gScore 1)
  += GameScore gScore
  = gScore 0
  
  )
    (if(== oxygen 10)
   (if(power)
   Print(0 29)
   = power FALSE
   )
    )
  (if(== oxygen 0)
  (if(send gEgo: has(INV_SPACESUIT))
  (if(not(deadOver))
  = deadOver TRUE
  = dyingScript ScriptID(DYING_SCRIPT)
  (send dyingScript:
    caller(3)
    register("You ran out of oxygen in your air-tank. Too bad! Hope you saved early, saved often.")
  )
 (send gGame:setScript(dyingScript))
  )))
  (if(== gTimeSeconds sshow)
 = showAir FALSE
  += sshow 12
 (SL:doit())
 )
   (if(== gTimeSeconds sshow2)
 = showAir TRUE
  += sshow2 12
  -= oxygen 1
 (SL:doit())
 )

(if(<> gCurrentTime (= gCurrentTime GetTime(gtTIME_OF_DAY)))
(if(>= ++gTimeSeconds 60)
  	= gTimeSeconds 0
  ++ gTimeMinutes
  = sshow 4
  = sshow2 12

                ++ autoSave
                = showAir TRUE
                (SL:doit())
                )
      (if(>= ++gTimeSeconds2 60 or >= ++sec3 60 or >= ++sec2 60)
      ++ gTimeMinutes2
      = gTimeSeconds2 0
      = sec3 0
      = sec2 0

      )
		    	(if(>= gTimeMinutes 60)
		    		= gTimeMinutes 0
		    		++ gTimeHours
)(if(== autoSave autoV)
         (if(not(== autoV 0))
        = autoSave 0
        = button5 Print(0 30 #button "Save" 0 #button "Nah!" 1 #title "Autosave Reminder" #icon 23 0 0)
        (if(== button5 0)
        (send gGame:save())
        return
        )
        return
)))
  		(if(> gOldScore gScore)
		    	= gOldScore gScore
				(SL:doit())
		)
		(if(< gOldScore gScore)
		    = gOldScore gScore
			(SL:doit())))
	(method (replay)
  		(TheMenuBar:draw())
  		(SL:enable())

		(super:replay())
	)
	(method (newRoom roomNum picAni)

  			Load(rsFONT		gDeadFont)
  			Load(rsFONT		gDefaultFont)
  			Load(rsFONT		gSaveRestoreFont)

  			Load(rsCURSOR	gNormalCursor)
  			Load(rsCURSOR	gLoadingCursor)

			(super:newRoom(roomNum))
			(if(< paramTotal 2)
    = gDefaultPicAni Random(0 5)
			)(else
				= gDefaultPicAni picAni
			))(method (startRoom roomNum)
		DisposeLoad(
			NULL
			FILEIO_SCRIPT JUMP_SCRIPT EXTRA_SCRIPT WINDOW_SCRIPT
		        TIMER_SCRIPT FOLLOW_SCRIPT REV_SCRIPT DCICON_SCRIPT
		        DOOR_SCRIPT AUTODOOR_SCRIPT
		)
		DisposeScript(DISPOSELOAD_SCRIPT)

		(send gTheSoundFX:
			stop()
			number(1)
		)
		(super:startRoom(roomNum)))

 (method (handleEvent pEvent)
         (var dyingScript, obje, piccy, roomNum, dyingScript)
		(super:handleEvent(pEvent))
     (SL:doit())
(if((<> (send pEvent:type) evSAID) or (send pEvent:claimed))
		    return(TRUE)
      )
  (if(Said('remove,(take<off)>'))
  (if(Said('/spacesuit,helmet'))
  (if(send gEgo: has(INV_SPACESUIT))
  Print(0 0)
  return
  )
  Print(0 1)
  )
  (if(Said('/id,card'))
  (if(postman)
  Print(0 2)
  return
  )
  Print(0 3)
  )
  (if(Said('/glasses'))
  (if(glassesOn)
  Print(0 4)
  return
  )
  Print(0 5)
   ))
     (if(Said('open/flashlight,light'))
             (if(send gEgo:has(INV_FLASHLIGHT))
           (if(removed)
           Print(0 6)
           return
           )
           Print(0 7)
           Print(0 8)
               += gScore 1
               = removed TRUE
          (send gEgo:get(INV_BATTERIES))
         (send gEgo:put(INV_FLASHLIGHT scriptNumber))
          return
           )
           Print(0 9)
         )
         (if(Said('wear,(put,set<on),use,put/glasses'))
        (if(glassesOn)
        Print(0 10)
        return
        )
        (if(send gEgo: has(INV_GLASSES))
        Print("Ok")
        += gScore 1
        = glassesOn TRUE
        = gEgoView 0
        (send gEgo: view(0))
        return
        )
        Print(0 11)
        )(if(Said('open>'))
          (if(Said('/letter'))
            (if(send gEgo:has(INV_LETTER))
           (if(send gEgo:has(INV_RECEIT))
           Print(0 0 12)
           return
           )
           (if(send gEgo:has(INV_GLASSES))
           (if(not(glassesOn))
           Print(0 13)
           return
           )
           )
          (if(not(send gEgo:has(INV_GLASSES)))
          Print(0 14)
          return
          )
       Print(0 15)
       Print(0 16)

             += gScore 1
          (send gEgo:get(INV_RECEIT))
          return
           )
           Print(0 0 18)
           ))(if(Said('read,use,look>'))
         (if(Said('/letter'))
           (if(send gEgo:has(INV_LETTER))
           (if(send gEgo:has(INV_RECEIT))
          Print(0 0 17)
           return
           )
           Print(0 19)
           return
         )
         Print("You don't have a letter.")
           return
             )
            (if(Said('/map,paper'))
            (if(>= gRoomNumber 100 and (<= gRoomNumber 118))
            (if(send gEgo:has(INV_MAZE_MAP))
            (send gRoom: newRoom(120))
            return
            )
            Print(0 20)
            return
            )
            Print(0 21)
            ))
        (if(Said('tp'))
        (send gRoom: newRoom(GetNumber("Teleport to room:")))
        )
        (if(Said('use>'))
(if(Said('/flashlight'))Print(0 0 22))
(if(Said('/calculator'))Print(0 0 23))
                )
                (if(Said('take/'))
        Print(0 24)
                )
(if(Said('stab'))
           Print(0 25)
           )
       (if(Said('open/'))
        Print(0 26)
                        )
           (if(Said('move,push/'))
        Print(0 27)
                        )
           (if(Said('break/'))
        Print(0 28)
                        )
(if(Said('sing')) Print(0 85) )
(if(Said('dance')) Print(0 86) )
(if(Said('fart')) Print(0 87) )

             
return(FALSE)

  	))(class Iitem of InvI
	(properties
		said 0
		description 0
		owner 0
		view 0
		loop 0
		cel 0
		script 0
	)
	(method (showSelf)
		Print(
            0 description
			#title objectName
            #icon view loop cel
		)
  (if(== view 828)
  FormatPrint("You have %d dakos." money)
  )))(instance statusCode  of Code
	(properties)
 	(method (doit param1)
  (if(== gRoomNumber 90)
  Format(param1 " Cash: %d        Bet: %-3d         Your Number: %-5d  " money bet numm2)
  return
   )
    (if(== gRoomNumber 95  or == gRoomNumber 87 or == gRoomNumber 132)
  Format(param1 " Cash: %d        Bet: %-3d                           " money bet)
  return
  )
  (if(send gEgo: has(INV_SPACESUIT))
  (if(showAir)
  Format(param1 " Score: %d of %-3d                  Air Left: %-4d   " GameScore gMaxScore oxygen)
  return
  )
  Format(param1 " Score: %d of %-3d                 Space Adventure 2" GameScore gMaxScore)
  return
  )
  Format(param1 " Score: %d of %-3d                 Space Adventure 2" GameScore gMaxScore)
  return
  ))(instance ego of Ego
	(properties
		y 1111
		x 0
		z 0
		heading 0
		yStep 2
		view 0
		loop 0
		cel 0
		priority 0
		underBits 0
		signal $2000
		nsTop 0
		nsLeft 0
		nsBottom 0
		nsRight 0
		lsTop 0
		lsLeft 0
		lsBottom 0
		lsRight 0
		brTop 0
		brLeft 0
		brBottom 0
		brRight 0
		cycleSpeed 0
		script 0
		cycler 0
		timer 0
		illegalBits $8000
		xLast 0
		yLast 0
		xStep 3
		moveSpeed 0
		blocks 0
		baseSetter 0
		mover 0
		looper 0
		viewer 0
		avoider 0
		edgeHit 0
	))(instance theMusic  of Sound
	(properties
		state 0
		number 1
		priority 0
		loop 1
		handle 0
		signal 0
		prevSignal 0
		client 0
		owner 0
	))(instance theSoundFX  of Sound
	(properties
		state 0
		number 1
		priority 1
		loop 1
		handle 0
		signal 0
		prevSignal 0
		client 0
		owner 0
 ))(instance theWindow  of SysWindow
	(properties)
	(method (open)
		(if(< Graph(grGET_COLOURS) 9)
			(if( (< color 7) or (== color 8) )
				= color 0
				= back  15
			)(else
				= color 15
				= back  0
			))
  		(super:open())
	))(instance NormalBase of Code
	(properties)
	(method (doit)
		(var temp0)
		(if(== gRoomNumberExit 253)
		    = temp0 22
		)(else
  			= temp0 10
		)(send gEgo:
			brBottom(
				(+ (send gEgo:y) 1)
			))(send gEgo:
			brTop(
				(- (send gEgo:brBottom) (send gEgo:yStep))))(send gEgo:
			brLeft(
				(- (send gEgo:x) temp0)))(send gEgo:
			brRight(
				(+ (send gEgo:x) temp0)
			))))

   (procedure public (SetUpEgo theLoop theView)
	PlayerControl()
	(send gEgo:edgeHit(EDGE_NONE))
	(switch(paramTotal)
		(case 0
			SetUpActor(gEgo (send gEgo:loop) gEgoView)
		)
  		))
    (procedure public (SetUpActor pActor theLoop theView)
		(send pActor:view(theView))
 (send pActor:
		setLoop(-1)
		setPri(-1)
		setStep(3 2)
		setCycle(Walk)
		illegalBits($8000)
		cycleSpeed(0)
		moveSpeed(0)
		ignoreActors(0)
	)
   )
 (procedure public (ProgramControl)
	(User:
		canControl(FALSE)
		canInput(FALSE)
	)(send gEgo:setMotion(NULL)))

(procedure public (PlayerControl)
	(User:
		canControl(TRUE)
		canInput(TRUE)
	)
	(send gEgo:setMotion(NULL)))

 /******************************************************************************/
(instance Nothing  of Iitem
	(properties)
)
(instance {Keycard} of Iitem
	(properties
		said 'keycard'
		description 43
		view 800
		loop 0
		cel 0
		script 1
	))(instance {Flashlight} of Iitem
	(properties
		said 'flashlight'
		description 44
		view 801
		loop 0
		cel 0
		script 0
	))(instance {Calculator} of Iitem
	(properties
		said 'calculator'
		description 45
		view 802
		loop 0
		cel 0
		script 0
	))(instance {Transmitter} of Iitem
	(properties
		said 'transmitter'
		description 46
		view 803
		loop 0
		cel 0
		script 0
	))(instance {Letter} of Iitem
	(properties
		said 'letter'
		description
             47
		view 804
		loop 0
		cel 0
		script 0
	))(instance {Key} of Iitem
	(properties
		said 'key'
		description
             48
		view 805
		loop 0
		cel 0
		script 0
	))(instance {Note} of Iitem
	(properties
		said 'note'
		description 49
		view 806
		loop 0
		cel 0
		script 0
	))(instance {Batteries} of Iitem
	(properties
		said 'batteries'
		description
             50
		owner 0
		view 807
		loop 0
		cel 0
		script 0
	))(instance {Wires} of Iitem
	(properties
		said 'wire'
		description
             51
		owner 0
		view 808
		loop 0
		cel 0
		script 0
	))(instance {Knife} of Iitem
	(properties
		said 'knife'
		description
             52
		owner 0
		view 809
		loop 0
		cel 0
		script 0
	))(instance {Hairpin} of Iitem
	(properties
		said 'hair'
		description
             53
		owner 0
		view 810
		loop 0
		cel 0
		script 0
	))(instance {Map} of Iitem
	(properties
		said 'map'
		description
             54
		owner 0
		view 811
		loop 0
		cel 0
		script 0
	))(instance {Vessel Key} of Iitem
	(properties
		said 'key'
		description
             55
		owner 0
		view 812
		loop 0
		cel 0
		script 0
	))(instance {Spacesuit} of Iitem
	(properties
		said 'suit'
		description
             56
		owner 0
		view 819
		loop 0
		cel 0
		script 0
	))(instance {Signal Device} of Iitem
	(properties
		said 'device'
		description
             57
		owner 0
		view 814
		loop 0
		cel 0
		script 0
	))(instance {Paper} of Iitem
	(properties
		said 'paper'
		description
             58
		owner 0
		view 815
		loop 0
		cel 0
		script 0
	))(instance {Card} of Iitem
	(properties
		said 'card'
		description
             59
		owner 0
		view 816
		loop 0
		cel 0
		script 0
	))(instance {Course Key} of Iitem
	(properties
		said 'key'
		description
             60
		owner 0
		view 817
		loop 0
		cel 0
		script 0
	))(instance {Rope} of Iitem
	(properties
		said 'rope'
		description
             61
		owner 0
		view 818
		loop 0
		cel 0
		script 0
	))(instance {Bottle of water} of Iitem
	(properties
		said 'water,bottle'
		description
             62
		owner 0
		view 813
		loop 0
		cel 0
		script 0
	))(instance {Diamond} of Iitem
	(properties
		said 'diamond'
		description
             63
		owner 0
		view 820
		loop 0
		cel 0
		script 0
	))(instance {Radio} of Iitem
	(properties
		said 'radio'
		description
             64
		owner 0
		view 821
		loop 0
		cel 0
		script 0
	))(instance {Glasses} of Iitem
	(properties
		said 'glasses'
		description
             65
		owner 0
		view 822
		loop 0
		cel 0
		script 0
	))(instance {Authorization Key} of Iitem
	(properties
		said 'key'
		description
             66
		owner 0
		view 823
		loop 0
		cel 0
		script 0
	))(instance {Maze Map} of Iitem
	(properties
		said 'maze/map'
		description
             67
		owner 0
		view 824
		loop 0
		cel 0
		script 0
	))(instance {Moon Stone} of Iitem
	(properties
		said 'stone'
		description
             68
		owner 0
		view 826
		loop 0
		cel 0
		script 0
	))(instance {Empty Bottle} of Iitem
	(properties
		said '(empty<bottle)'
		description
             69
		owner 0
		view 827
		loop 0
		cel 0
		script 0
	)) (instance {Money} of Iitem
	(properties
		said 'money'
		description
             70
		owner 0
		view 828
		loop 0
		cel 0
		script 0
	))(instance {Tools} of Iitem
	(properties
		said 'tools'
		description
             71
		owner 0
		view 829
		loop 0
		cel 0
		script 0))
  (instance {Hotel Room Key} of Iitem
	(properties
		said 'hotel,room/key'
		description
             72
		owner 0
		view 830
		loop 0
		cel 0
		script 0))
    (instance {Ladder} of Iitem
	(properties
		said 'ladder'
		description
             73
		owner 0
		view 831
		loop 0
		cel 0
		script 0))
      (instance {Sniper} of Iitem
	(properties
		said 'gun,sniper'
		description
             74
		owner 0
		view 832
		loop 0
		cel 0
		script 0))
      (instance {Dynamato} of Iitem
	(properties
		said 'dynamato'
		description
             75
		owner 0
		view 833
		loop 0
		cel 0
		script 0))
     (instance {Axe} of Iitem
	(properties
		said 'axe'
		description
             76
		owner 0
		view 834
		loop 0
		cel 0
		script 0))
     (instance {Shovel} of Iitem
	(properties
		said 'shovel'
		description
             77
		owner 0
		view 835
		loop 0
		cel 0
		script 0))
       (instance {Car key} of Iitem
	(properties
		said 'car<key'
		description
             78
		owner 0
		view 836
		loop 0
		cel 0
		script 0))
         (instance {House key (Spare)} of Iitem
	(properties
		said 'house<key'
		description
             79
		owner 0
		view 837
		loop 0
		cel 0
		script 0))
           (instance {Wall Tile} of Iitem
	(properties
		said 'tile'
		description
             80
		owner 0
		view 838
		loop 0
		cel 0
		script 0))
             (instance {Gas} of Iitem
	(properties
		said 'gas'
		description
             81
		owner 0
		view 839
		loop 0
		cel 0
		script 0))
                (instance {Free Magazine} of Iitem
	(properties
		said 'newspaper'
		description
             82
		owner 0
		view 840
		loop 0
		cel 0
		script 0))
             (instance {Wooden Board} of Iitem
	(properties
		said 'board'
		description
             83
		owner 0
		view 841
		loop 0
		cel 0
		script 0))
             (instance {Dry grass} of Iitem
	(properties
		said 'grass'
		description
             84
		owner 0
		view 842
		loop 0
		cel 0
		script 0))

