/******************************************************************************
 SCI Template Game
 By Brian Provinciano
 ******************************************************************************
 dying.sc
 Contains a public script instance to handle when the ego dies.
 ******************************************************************************/
(include "sci.sh")
(include "game.sh")
/******************************************************************************/
(script DYING_SCRIPT)
/******************************************************************************/
(use "main")
(use "controls")
(use "dcicon")
(use "cycle")
(use "obj")
(local
buto7
)
/******************************************************************************/
(instance public DyingScript of Script
	(properties)

	(method (changeState newState)
		(var mbResult, message, message2)
		= state newState
		(if(== state 0)
			ProgramControl()
			(send gTheMusic:fade())
			(send gRoom:setScript(0))
			Load(rsSOUND 2)
			= seconds 2
		)(else
  			(if(== state 1)
  				(send gTheSoundFX:stop())
  				/*(send gTheMusic:
  					number(2)
  					loop(1)
  					priority(-1)
                    number(601)
  					play()
  				)  */
  					= message register

               = buto7 Print(
  					message
                    #font gDeadFont
                    #icon 13 0 0
  					#button "Continue" 0
  					#button "Hintbook" 1
  				)
      (if(== buto7 1)
  					Print(
  						"Do you think I'm some charity dude, giving hints out just like that? Think again!"
  					)
        Print("Actually just post a message at my message board. See the Readme file for link.")
  				)

  					= mbResult Print(
  						"Like Al Lowe used to say: \"Save early, save often!\"\n\nEigen Lenk adds: \"Yeah!\""
  						#title "Great wisdom..."
  						#font gDeadFont
  						#button "Restore"  1
  						#button "Restart"  2
  						#button "  Quit  " 3
  					)
  					(switch(mbResult)
  						(case 1
  							(if(<> (send gGame:restore()) -1) 
  								return
  							)
		    			)
		    			(case 2
  							(send gGame:restart())
  							return
		    			)
		    			(case 3
		    				= gQuitGame TRUE
		    				return
		    			))))))
/******************************************************************************/
(instance deadIcon of DCIcon
	(properties)
	(method (init)
		(super:init())
		(if(== gRoomNumberExit 540)
			= cycler (End:new())
			(send cycler:init(self))
		)
	)
)
/******************************************************************************/
