/******************************************************************************
 dying.sc
 Contains a public script instance to handle when the ego dies.
 ******************************************************************************/
(include "sci.sh")(include "game.sh")                      (script DYING_SCRIPT)
/******************************************************************************/
(use "main")(use "controls")(use "dcicon")(use "cycle")(use "obj")
/******************************************************************************/
(instance public DyingScript of Script
	(properties)
	(method (changeState newState)
		(var mbResult, message)
		= state newState
		(if(== state 0)
			ProgramControl()
			(send gTheMusic:fade())
			(send gRoom:setScript(0))
			Load(rsSOUND 2)
			= seconds 1
		)(else
  			(if(== state 1)
  				(send gTheSoundFX:stop())
  				(send gTheMusic:
  					number(2)
  					loop(1)
  					priority(-1)
  					play()
  				)
      
                // The following lines give a typical Sierra style
                // message box telling the player that they have died.
                // You can customize it to your liking.

  				(if(<> NULL caller)
  					Load(rsVIEW caller)
  					(deadIcon:view(caller))
  				)(else
  					Load(rsVIEW DYING_SCRIPT)
  					(deadIcon:view(DYING_SCRIPT))
  				)
  				(if(<> NULL register)
  					= message register
  				)(else
  					= message 5
  				)
  				(if(Print(1 message #font gDeadFont #icon deadIcon))
  				)

  				(while(1)
  					= mbResult Print(1 4
  						#font gDeadFont
  						#button "Restart"  1
  						#button "  Quit  " 2
  					)
  					(switch(mbResult)
		    			(case 1
  							(send gGame:restart())
  							return
		    			)
		    			(case 2
		    				 Print(1 0)
                             = gQuitGame TRUE
		    				return
		    			)
		    		)
		    	)
  			)
  		)
	)
)
/******************************************************************************/
(instance deadIcon of DCIcon
	(properties)
	(method (init)
		(super:init())
		(if(== gRoomNumberExit 540)
			= cycler (End:new())
			(send cycler:init(self))
		)
	)
)
/******************************************************************************/
