' Stripped AZ/P core
' (c) 2005 Pc72

DEFINT A-Z
DECLARE SUB ProcessRecords ()
DECLARE FUNCTION AreaFree (X, Y)
DECLARE SUB MoveActor (Num, Direction)
DECLARE SUB ResetRecords ()
CONST Actors = 10, ScreenColumns = 20, ScreenRows = 12
CONST MaxX = ScreenColumns - 1, MaxY = ScreenRows - 1
CONST FALSE = 0, TRUE = NOT FALSE
TYPE BaseType
  X AS INTEGER
  Y AS INTEGER
  MapX AS INTEGER
  MapY AS INTEGER
  Tick AS INTEGER
  Exist AS INTEGER
END TYPE
TYPE ActorType
  Inherited AS BaseType
  Direction AS INTEGER
END TYPE
DIM SHARED ActorTemp(0 TO 130 * (Actors + 1)), Guy(130), Box(130)
DIM SHARED Map(0 TO MaxX, 0 TO MaxY) AS INTEGER, Actor(0 TO Actors) AS ActorType

SCREEN 13
RANDOMIZE TIMER

FOR Y = 0 TO MaxY
  FOR X = 0 TO MaxX
    Map(X, Y) = 0
NEXT X, Y

FOR I = 1 TO 50
  Map(INT(RND * ScreenColumns), INT(RND * ScreenRows)) = 1
NEXT I
FOR I = 7 TO 0 STEP -1
  J = 20 + (7 - I)
  CIRCLE (7, 7), I, J
  PAINT (7, 7), J, J
  LINE (16 + I, I)-(31 - I, 15 - I), I + 20, B
NEXT I
GET (0, 0)-(15, 15), Guy
GET (16, 0)-(31, 15), Box

ResetRecords

CLS
FOR Y = 0 TO MaxY
  FOR X = 0 TO MaxX
    IF Map(X, Y) <> 0 THEN PUT (X * 16, Y * 16), Box, PSET
NEXT X, Y
DO
  ProcessRecords
  WHILE INKEY$ <> "": WEND
  Patang = INP(96)
  SELECT CASE Patang
    CASE 72
      MoveActor 0, 1
    CASE 80
      MoveActor 0, 2
    CASE 75
      MoveActor 0, 3
    CASE 77
      MoveActor 0, 4
    CASE 1
      EXIT DO
  END SELECT
  FOR I = 1 TO Actors
    J = INT(RND * 20)
    IF (J \ 2) = 5 THEN
      Actor(I).Direction = INT(RND * 4) + 1
    ELSEIF (J \ 4) = 4 THEN
      IF Actor(I).Inherited.Y < Actor(0).Inherited.Y THEN Actor(I).Direction = 2
      IF Actor(I).Inherited.Y > Actor(0).Inherited.Y THEN Actor(I).Direction = 1
      IF Actor(I).Inherited.X < Actor(0).Inherited.X THEN Actor(I).Direction = 4
      IF Actor(I).Inherited.X > Actor(0).Inherited.X THEN Actor(I).Direction = 3
    END IF
    MoveActor I, Actor(I).Direction
  NEXT I
LOOP

FUNCTION AreaFree (X, Y)
  AreaFree = 0
  IF (X <= MaxX) AND (Y <= MaxY) AND (X >= 0) AND (Y >= 0) THEN
    C = Map(X, Y) AND 1
    AreaFree = (C = 0)
  END IF
END FUNCTION

SUB MoveActor (Num, Direction)
  IF NOT Actor(Num).Inherited.Exist THEN EXIT SUB
  Dr = Direction
  Referred = FALSE
TopOff:
  Actor(Num).Direction = Dr
  X = Actor(Num).Inherited.X
  Y = Actor(Num).Inherited.Y
  A = X MOD 16
  B = Y MOD 16
  C = X \ 16
  D = Y \ 16
  SELECT CASE Dr
    CASE 1
      IF B <> 0 THEN D = D + 1
      Z = AreaFree(C, D - 1)
      IF A <> 0 THEN Z = Z AND AreaFree(C + 1, D - 1)
      IF Z THEN Actor(Num).Inherited.Y = Actor(Num).Inherited.Y - 1
    CASE 2
      Z = AreaFree(C, D + 1)
      IF A <> 0 THEN Z = Z AND AreaFree(C + 1, D + 1)
      IF Z THEN Actor(Num).Inherited.Y = Actor(Num).Inherited.Y + 1
    CASE 3
      IF A <> 0 THEN C = C + 1
      Z = AreaFree(C - 1, D)
      IF B <> 0 THEN Z = Z AND AreaFree(C - 1, D + 1)
      IF Z THEN Actor(Num).Inherited.X = Actor(Num).Inherited.X - 1
    CASE 4
      Z = AreaFree(C + 1, D)
      IF B <> 0 THEN Z = Z AND AreaFree(C + 1, D + 1)
      IF Z THEN Actor(Num).Inherited.X = Actor(Num).Inherited.X + 1
  END SELECT
' The SELECT structure below is the "auto correction" code.  If you remove
' it, the palyers will no longer avoid blocks automatically.
  SELECT CASE Dr
    CASE 1, 2
      IF NOT Z THEN
        IF A = 0 THEN Referred = TRUE
        IF NOT Referred THEN
          Referred = TRUE
          IF A < 8 THEN Dr = 3 ELSE Dr = 4
          GOTO TopOff
        END IF
      END IF
    CASE 3, 4
      IF NOT Z THEN
        IF B = 0 THEN Referred = TRUE
        IF NOT Referred THEN
          Referred = TRUE
          IF B < 8 THEN Dr = 1 ELSE Dr = 2
          GOTO TopOff
        END IF
      END IF
  END SELECT
  C = X \ 16
  D = Y \ 16
  IF A > 7 THEN C = C + 1
  IF B > 7 THEN D = D + 1
  Actor(Num).Inherited.MapX = C
  Actor(Num).Inherited.MapY = D
  IF Actor(Num).Inherited.Tick < 15 THEN Actor(Num).Inherited.Tick = Actor(Num).Inherited.Tick + 1 ELSE Actor(Num).Inherited.Tick = 0
END SUB

SUB ProcessRecords
  FOR I = 0 TO Actors
    GET (Actor(I).Inherited.X, Actor(I).Inherited.Y)-(Actor(I).Inherited.X + 15, Actor(I).Inherited.Y + 15), ActorTemp(I * 130)
  NEXT I
  FOR I = 0 TO Actors
    PUT (Actor(I).Inherited.X, Actor(I).Inherited.Y), Guy
  NEXT I
  WAIT &H3DA, 8
  FOR I = 0 TO Actors
    PUT (Actor(I).Inherited.X, Actor(I).Inherited.Y), ActorTemp(I * 130), PSET
  NEXT I
END SUB

SUB ResetRecords
  FOR Enum = 0 TO Actors
    Actor(Enum).Inherited.Exist = TRUE
    Actor(Enum).Inherited.X = INT(RND * ScreenColumns) * 16
    Actor(Enum).Inherited.Y = INT(RND * ScreenRows) * 16
    Actor(Enum).Inherited.Tick = 0
    Actor(Enum).Direction = 1
  NEXT Enum
END SUB

