''Unfinished QB/RelLib game.
''I'm releasing the source and demo and all the tilesets because I'm going to
''convert this in FreeBASIC using SDL+OpenGL.
''Code needs QB4.5 and Rellib ver 5.0 to compile
''Richard Eric M. Lope aka RelSoft
''Rel.Betterwebber.com

''What This Demo does:
''1. Pixel perfect collision detection
''2. Homing Missiles
''3. Enimy AI is just straight but adding other AI's is easy enough.


DECLARE SUB DoCollision (Layer%, BOM%(), Lvl AS ANY, Tile%(), TIdx%(), Obj%(), OIdx%(), Ship%(), SIdx%(), v AS ANY, Shot() AS ANY, Home() AS ANY, Object() AS ANY)
DECLARE SUB DoHoming (Home() AS ANY, Obj() AS ANY, Lsin!(), Lcos!())
DECLARE SUB DrawShip (Ship AS ANY, Shot() AS ANY, Home() AS ANY)
DECLARE SUB StartHoming (Home() AS ANY, Ship AS ANY, Obj() AS ANY)
DECLARE SUB InitShotObject (x%, y%, id%, Shot AS ANY)
DECLARE SUB DoShots (Shot() AS ANY)
DECLARE SUB DrawObjects (Layer%, Obj() AS ANY, ObjSpr%(), ObjSprIdx%(), ESpr%(), ESprIdx%())
DECLARE SUB InitObject (x%, y%, id%, Obj AS ANY)
DECLARE SUB DrawCollideLayer (Layer%, BOM%(), Lvl AS ANY, TileSpr%(), TileSprIndex%())
DECLARE SUB CheckObjectMap (Obj() AS ANY, BOM%(), Lvl AS ANY)
DECLARE SUB DoObjects (Obj() AS ANY)
DECLARE SUB DrawMap (BOM%(), PFM%(), Lvl AS ANY, FS%)
DECLARE SUB MAIN ()
DECLARE SUB InitLevel (Lvl AS ANY, BOM%(), PFM%(), Filename$)
DECLARE SUB UpdateCamera (Lvl AS ANY)
DECLARE SUB StartShots (Shot() AS ANY, Ship AS ANY, Opt() AS ANY)
DECLARE SUB InitShip (Ship AS ANY, Opt() AS ANY)
DECLARE SUB DoOptions (Opt() AS ANY, Ship AS ANY, Ls!(), Lc!())
DECLARE SUB InitLuts (Ls!(), Lc!())
DECLARE SUB MakeImageIndex (ImageArray%(), IndexArray%())
DECLARE SUB InitImageData (Filename$, ImageArray%())
DECLARE SUB LoadData ()
DECLARE SUB DoControls (Ship AS ANY, Shot() AS ANY, Opt() AS ANY, Obj() AS ANY, FinVal%)

'To be common shared
'All CONST
'LAYER

DEFINT A-Z
REM $INCLUDE: 'RelLib.Bi'
REM $DYNAMIC
'ON ERROR GOTO Mybad

TYPE ShipType
    id             AS INTEGER
    DeathID        AS INTEGER
    x              AS SINGLE
    y              AS SINGLE
    xv             AS SINGLE
    yv             AS SINGLE
    Active         AS INTEGER
    Frame          AS INTEGER
    StartFrame     AS INTEGER
    MaxFrame       AS INTEGER
    Counter        AS INTEGER
    Speedx         AS SINGLE
    Speedy         AS SINGLE
    FlipMode       AS INTEGER
    Action         AS INTEGER
    ShotSpeed      AS INTEGER
    ShotDelay      AS INTEGER
    ShotMaxDelay   AS INTEGER
    HomingDelay    AS INTEGER
    HomingMaxDelay AS INTEGER
END TYPE

TYPE OptionType
    x               AS SINGLE
    y               AS SINGLE
    xv              AS SINGLE
    yv              AS SINGLE
    Angle           AS INTEGER
    StartFrame      AS INTEGER
    Frame           AS INTEGER
    MaxFrame        AS INTEGER
    ShotSpeed       AS INTEGER
END TYPE
TYPE ShotType
    id             AS INTEGER
    DeathID        AS INTEGER
    x              AS SINGLE
    y              AS SINGLE
    xv             AS SINGLE
    yv             AS SINGLE
    Active         AS INTEGER
    Frame          AS INTEGER
    Energy         AS INTEGER
    StartFrame     AS INTEGER
    MaxFrame       AS INTEGER
    AnimFlag       AS INTEGER
END TYPE

TYPE HomingType
    id             AS INTEGER
    DeathID        AS INTEGER
    x              AS SINGLE
    y              AS SINGLE
    Tx             AS SINGLE
    Ty             AS SINGLE
    xv             AS SINGLE
    yv             AS SINGLE
    Active         AS INTEGER
    Frame          AS INTEGER
    Energy         AS INTEGER
    StartFrame     AS INTEGER
    MaxFrame       AS INTEGER
    AnimFlag       AS INTEGER
    Angle          AS INTEGER
    Speed          AS INTEGER
    NewTarget      AS INTEGER
    NumTarget      AS INTEGER
END TYPE

TYPE LevelType
    camerax             AS SINGLE
    Speed               AS SINGLE
    xoffs               AS INTEGER
    TileX               AS INTEGER
    Pxoffs              AS INTEGER      'Parallax
    PTileX              AS INTEGER
    Fxoffs              AS INTEGER      'ForeGround ie. Clouds, Translucency
    FTileX              AS INTEGER
    Fcamx               AS INTEGER      'needed as=faster and same dim as Par
    Stopped             AS INTEGER
    MinSpeed            AS SINGLE
    MaxSpeed            AS SINGLE
    Trans               AS INTEGER
END TYPE

TYPE ObjectType
    id             AS INTEGER
    DeathID        AS INTEGER
    x              AS SINGLE
    y              AS SINGLE
    xv             AS SINGLE
    yv             AS SINGLE
    Active         AS INTEGER
    AnimFlag       AS INTEGER
    Frame          AS INTEGER
    StartFrame     AS INTEGER
    MaxFrame       AS INTEGER
    Counter        AS INTEGER
    FlipMode       AS INTEGER
    Action         AS INTEGER
    ShotSpeed      AS INTEGER
    ShotDelay      AS INTEGER
    ShotMaxDelay   AS INTEGER
    ImgArray       AS INTEGER
END TYPE



'0 to 24
CONST idVIC = 0
CONST idShotSTRAIGHT = 10
CONST idShotExp = 11
CONST idHOMING = 15
CONST idHomingEXP = 16


CONST MAXSHOT = 10
CONST MAXHOMING = 10

CONST MAXOBJECT = 50

'25 to 99
CONST idENEMSTRAIGHT = 25

'100 to inf
CONST idEXPSMALL = 100


'ship Action
CONST VICNORMAL = 0
CONST VICHIT = 1

'DrawObject locator
CONST TMAIN = 0
CONST TOBJ = 1
CONST TEXP = 2


CONST MAPXMAX = 512, MAPYMAX = 10
CONST PFMAPXMAX = (MAPXMAX \ 4) + 16

RANDOMIZE TIMER

DIM SHARED Lsin!(359), Lcos!(359)

DIM SHARED Vpage%(31999)

REDIM SHARED ShipSpr(1) AS INTEGER
REDIM SHARED ShipSprIndex(1) AS INTEGER
REDIM SHARED Shot(MAXSHOT, 2) AS ShotType
REDIM SHARED Homing(MAXHOMING) AS HomingType
REDIM SHARED Options(1) AS OptionType
REDIM SHARED Object(MAXOBJECT) AS ObjectType
REDIM SHARED ObjectSpr(1) AS INTEGER
REDIM SHARED ObjectSprIndex(1) AS INTEGER
REDIM SHARED TileSpr(1) AS INTEGER
REDIM SHARED TileSprIndex(1) AS INTEGER
REDIM SHARED ExpSpr(1) AS INTEGER
REDIM SHARED ExpSprIndex(1) AS INTEGER
REDIM SHARED Font(1) AS INTEGER
REDIM SHARED FontIndex(1) AS INTEGER



REDIM SHARED BOMap%(MAPXMAX, MAPYMAX)           'Base/Object
REDIM SHARED PFMap%(PFMAPXMAX, MAPYMAX)         'Parallax/Foreground

DIM SHARED Viper AS ShipType
DIM SHARED Level AS LevelType
DIM SHARED Layer%
DIM SHARED Path$

CLS
SCREEN 13
RANDOMIZE TIMER
RelFFix

Path$ = "C:\Qbasic\Rellib\ShotTute\"
'Path$ = ""

Layer% = VARSEG(Vpage%(0))
LoadData
InitLuts Lsin!(), Lcos!()
InitShip Viper, Options()
InitLevel Level, BOMap%(), PFMap%(), ""

MAIN

SCREEN 0
WIDTH 80
END

Mybad:
CLS
SCREEN 0
PRINT ERR
END

REM $STATIC
SUB CheckObjectMap (Obj() AS ObjectType, BOM%(), Lvl AS LevelType) STATIC
    FOR y% = 0 TO 10
            Tx% = Lvl.TileX + 20
            Ty% = y%
            ObjectID% = RelGetHI(BOM%(Tx%, Ty%))
            IF ObjectID% > 0 THEN
                FOR i% = 0 TO MAXOBJECT
                    IF NOT Obj(i%).Active THEN
                        'AddObject obj(i%), ObjectID%, ty%
                        mx% = (Tx% - Lvl.TileX) * 16
                        my = Ty% * 16
                        InitObject mx%, my%, ObjectID%, Obj(i%)
                        RelAddHI VARSEG(BOM%(Tx%, Ty%)), VARPTR(BOM%(Tx%, Ty%)), 0
                        EXIT FOR
                    END IF
                NEXT i%
            END IF
    NEXT y%
END SUB

SUB DoCollision (Layer%, BOM%(), Lvl AS LevelType, Tile(), TIdx(), Obj(), OIdx(), Ship(), SIdx(), v AS ShipType, Shot() AS ShotType, Home() AS HomingType, Object() AS ObjectType)
DrawCollideLayer Layer%, BOM%(), Lvl, Tile(), TIdx()
Shipx% = v.x
Shipy% = v.y
IF RelCollide(Layer%, Shipx%, Shipy%, VARSEG(Ship(1)), VARPTR(Ship(SIdx(3)))) = 15 THEN
    v.Action = VICHIT
ELSE
    v.Action = VICNORMAL
END IF

'Shot
FOR i% = 0 TO 2
FOR j% = 0 TO MAXSHOT
    IF Shot(j%, i%).Active THEN
    IF Shot(j%, i%).id = idShotSTRAIGHT THEN
        shotx% = Shot(j%, i%).x
        shoty% = Shot(j%, i%).y
        IF RelCollide(Layer%, shotx%, shoty%, VARSEG(Ship(1)), VARPTR(Ship(SIdx(16)))) = 15 THEN
            InitShotObject shotx%, shoty% - 4, idShotExp, Shot(j%, i%)
        END IF
    END IF
    END IF
NEXT j%
NEXT i%

'Ship to Object

FOR i% = 0 TO MAXOBJECT
    IF Object(i%).Active THEN
        TF% = Object(i%).StartFrame + Object(i%).Frame
        IF RelCollideSpr(Shipx%, Shipy%, VARSEG(Ship(1)), VARPTR(Ship(SIdx(3))), Object(i%).x, Object(i%).y, VARSEG(Obj(1)), VARPTR(Obj(OIdx(TF%)))) THEN
            mx% = Object(i%).x
            my% = Object(i%).y
            ObjectID% = Object(i%).DeathID
            InitObject mx%, my%, ObjectID%, Object(i%)
        END IF
    END IF
NEXT i%

'Shot to Object
FOR i% = 0 TO 2
FOR j% = 0 TO MAXSHOT
    IF Shot(j%, i%).Active THEN
    IF Shot(j%, i%).id = idShotSTRAIGHT THEN
        FOR k% = 0 TO MAXOBJECT
            IF Object(k%).Active THEN
            TF% = Object(k%).StartFrame + Object(k%).Frame
                IF RelCollideSpr(Shot(j%, i%).x, Shot(j%, i%).y, VARSEG(Ship(1)), VARPTR(Ship(SIdx(16))), Object(k%).x, Object(k%).y, VARSEG(Obj(1)), VARPTR(Obj(OIdx(TF%)))) THEN
                    mx% = Object(k%).x
                    my% = Object(k%).y
                    ObjectID% = Object(k%).DeathID
                    InitObject mx%, my%, ObjectID%, Object(k%)
                    shotx% = Shot(j%, i%).x
                    shoty% = Shot(j%, i%).y
                    InitShotObject shotx%, shoty% - 4, idShotExp, Shot(j%, i%)
                END IF
            END IF
        NEXT k
    END IF
    END IF
NEXT j%
NEXT i%

'Homing to object
FOR i% = 0 TO MAXHOMING
    IF Home(i%).Active THEN
        FOR j% = 0 TO MAXOBJECT
            IF Object(j%).Active THEN
                hx% = Home(i%).x
                hy% = Home(i%).y
                ox% = Object(j%).x
                oy% = Object(j%).y
                TF% = Object(j%).StartFrame + Object(j%).Frame
                SF% = Home(i%).StartFrame
                F% = Home(i%).Frame + SF%
                IF RelCollideSpr(hx%, hy%, VARSEG(Ship(1)), VARPTR(Ship(SIdx(F%))), ox%, oy%, VARSEG(Obj(1)), VARPTR(Obj(OIdx(TF%)))) THEN
                    ObjectID% = Object(j%).DeathID
                    InitObject ox%, oy%, ObjectID%, Object(j%)
                    Home(i%).NewTarget = TRUE
                    GOSUB ExplodeHoming
                END IF
            END IF
        NEXT j%
    END IF
NEXT i



EXIT SUB

'***************************************************************************
ExplodeHoming:
    Home(i%).id = idHomingEXP
    Home(i%).xv = 0
    Home(i%).yv = 0
    Home(i%).Frame = 0
    Home(i%).StartFrame = 24
    Home(i%).MaxFrame = 2
    Home(i%).AnimFlag = 0
RETURN

END SUB

SUB DoControls (Ship AS ShipType, Shot() AS ShotType, Opt() AS OptionType, Obj() AS ObjectType, FinVal) STATIC


Ship.xv = 0
Ship.yv = 0
ox% = Ship.x
oy% = Ship.y

IF RelKey(KEYESC) THEN
    FinVal% = TRUE
END IF
IF RelKey(KEYSPACE) THEN
    Ship.ShotDelay = Ship.ShotDelay - 1
    IF Ship.ShotDelay < 0 THEN
       Ship.ShotDelay = Ship.ShotMaxDelay
       StartShots Shot(), Ship, Opt()
    END IF

    Ship.HomingDelay = Ship.HomingDelay - 1
    IF Ship.HomingDelay < 0 THEN
       Ship.HomingDelay = Ship.HomingMaxDelay
       StartHoming Homing(), Ship, Obj()
    END IF

END IF
IF RelKey(KEYENTER) THEN              'Toggle StatBar
END IF
IF RelKey(KEYTAB) THEN                'if Pressed Speed is increased
ELSE
END IF

IF RelKey(KEYRIGHT) THEN
    Ship.xv = Ship.Speedx
    Ship.yv = 0
    Ship.x = Ship.x + Ship.xv
    Ship.y = Ship.y + Ship.yv
END IF
IF RelKey(KEYLEFT) THEN
    Ship.xv = -Ship.Speedx
    Ship.yv = 0
    Ship.x = Ship.x + Ship.xv
    Ship.y = Ship.y + Ship.yv
END IF


IF RelKey(KEYDOWN) THEN
    Ship.xv = 0
    Ship.yv = Ship.Speedy
    Ship.x = Ship.x + Ship.xv
    Ship.y = Ship.y + Ship.yv
END IF
IF RelKey(KEYUP) THEN   'Pressed UP
    Ship.xv = 0
    Ship.yv = -Ship.Speedy
    Ship.x = Ship.x + Ship.xv
    Ship.y = Ship.y + Ship.yv
END IF



IF Ship.x < 0 OR Ship.x > 292 THEN
    Ship.x = ox%
END IF
IF Ship.y < 0 OR Ship.y > 161 THEN
    Ship.y = oy%
END IF


END SUB

SUB DoHoming (Home() AS HomingType, Obj() AS ObjectType, Lsin!(), Lcos!()) STATIC

CONST AngleStep% = 15

'Clear destroyed targets
FOR j% = 0 TO MAXOBJECT
    IF NOT Obj(j%).Active THEN
        FOR i% = 0 TO MAXHOMING
            IF j% = Home(i%).NumTarget THEN     'if target is dead
                Home(i%).NewTarget = TRUE       'select new target
            END IF
        NEXT i%
    END IF
NEXT j%

FOR i% = 0 TO MAXHOMING
    IF Home(i%).Active THEN
        IF Home(i%).NewTarget THEN
            GOSUB CheckObject2Home
        END IF
        GOSUB MoveHoming
        Home(i%).AnimFlag = (Home(i%).AnimFlag + 1) AND 3
        IF Home(i%).id <> idHOMING THEN
            IF Home(i%).AnimFlag = 0 THEN
                Home(i%).Frame = (Home(i%).Frame + 1)
            END IF
            IF Home(i%).Frame >= Home(i%).MaxFrame THEN
                 Home(i%).Active = FALSE
            END IF
        ELSE            'Homing
            IF Home(i%).AnimFlag = 0 THEN
                Home(i%).Frame = (Home(i%).Frame + 1) MOD Home(i%).MaxFrame
            END IF
        END IF

    END IF
NEXT i



EXIT SUB
'***************************************************************************
CheckObject2Home:
    HomeRot% = 32 * (((i% AND 1) = 1) OR 1)         'Rotate the up down vecs
    Home(i%).Tx = 420
    Home(i%).Ty = Home(i%).y + HomeRot%

    FOR j% = 0 TO MAXOBJECT
        IF Obj(j%).Active THEN
            Home(i%).Tx = Obj(j%).x
            Home(i%).Ty = Obj(j%).y
            Home(i%).NewTarget = FALSE
            Home(i%).NumTarget = j%
            EXIT FOR
        END IF
    NEXT j%
RETURN

'***************************************************************************
MoveHoming:
    'move the missile
    Home(i%).xv = Lcos!(Home(i%).Angle) * Home(i%).Speed
    Home(i%).yv = Lsin!(Home(i%).Angle) * Home(i%).Speed

    Home(i%).x = Home(i%).x + Home(i%).xv
    Home(i%).y = Home(i%).y + Home(i%).yv

    'Check if outside of screen
    IF Home(i%).x < -50 OR Home(i%).x > 370 OR Home(i%).y < -50 OR Home(i%).y > 250 THEN
        Home(i%).NewTarget = TRUE
        Home(i%).Active = FALSE
    END IF

    'Check if Result>0 then Dec else Inc
    'the actual angle is not important
    Dot = ((Home(i%).yv * (Home(i%).Tx - Home(i%).x)) - (Home(i%).xv * (Home(i%).Ty - Home(i%).y)))
    IF Dot > 0 THEN
            Home(i%).Angle = (Home(i%).Angle - AngleStep%)
            IF Home(i%).Angle < 0 THEN Home(i%).Angle = Home(i%).Angle + 360
    ELSE
            Home(i%).Angle = (Home(i%).Angle + AngleStep%) MOD 360
    END IF

RETURN
END SUB

SUB DoObjects (Obj() AS ObjectType) STATIC
FOR i% = 0 TO MAXOBJECT
    IF Obj(i%).Active THEN
        GOSUB CheckID
        Obj(i%).AnimFlag = (Obj(i%).AnimFlag + 1) AND 3
    END IF
NEXT i%
EXIT SUB

CheckID:
    SELECT CASE Obj(i%).id
        CASE idENEMSTRAIGHT
            Obj(i%).x = Obj(i%).x + Obj(i%).xv
            Obj(i%).y = Obj(i%).y + Obj(i%).yv
            IF Obj(i%).AnimFlag = 0 THEN
                Obj(i%).Frame = (Obj(i%).Frame + 1) MOD Obj(i%).MaxFrame
            END IF
            IF Obj(i%).x <= -30 THEN
                 Obj(i%).Active = FALSE
            END IF
        CASE idEXPSMALL
            IF Obj(i%).AnimFlag = 0 THEN
                Obj(i%).Frame = (Obj(i%).Frame + 1)
            END IF
            Obj(i%).x = Obj(i%).x + Obj(i%).xv
            Obj(i%).y = Obj(i%).y + Obj(i%).yv
            IF Obj(i%).Frame >= Obj(i%).MaxFrame THEN
                 Obj(i%).Active = FALSE
            END IF
        CASE ELSE
            Obj(i%).Active = FALSE
    END SELECT
RETURN
END SUB

SUB DoOptions (Opt() AS OptionType, Ship AS ShipType, Ls!(), Lc!()) STATIC
Animate% = (Animate + 1) AND 7
JetAnim% = (JetAnim% + 1) AND 0
FOR i% = 0 TO 1
    Opt(i%).Angle = Opt(i%).Angle + 3
    IF Opt(i%).Angle > 359 THEN
        Opt(i%).Angle = Opt(i%).Angle - 360
    END IF
    Opt(i%).xv = Lc!(Opt(i%).Angle) * 45
    Opt(i%).yv = Ls!(Opt(i%).Angle) * 25
    Opt(i%).x = 4 + Ship.x + Opt(i%).xv
    Opt(i%).y = Ship.y + Opt(i%).yv
    IF Animate% = 1 THEN
        Opt(i%).Frame = (Opt(i%).Frame + 1) MOD Opt(i%).MaxFrame
    END IF
    TFrame% = Opt(i%).StartFrame + Opt(i%).Frame
    RelSprite Layer%, Opt(i%).x - 7, Opt(i%).y + 5, VARSEG(ShipSpr(1)), VARPTR(ShipSpr(ShipSprIndex(6 + JetAnim%)))
    RelSprite Layer%, Opt(i%).x, Opt(i%).y, VARSEG(ShipSpr(1)), VARPTR(ShipSpr(ShipSprIndex(TFrame%)))
NEXT i%
END SUB

SUB DoShots (Shot() AS ShotType) STATIC
'Shot
FOR i% = 0 TO 2
FOR j% = 0 TO MAXSHOT
    IF Shot(j%, i%).Active THEN
        Shot(j%, i%).x = Shot(j%, i%).x + Shot(j%, i%).xv
        Shot(j%, i%).y = Shot(j%, i%).y + Shot(j%, i%).yv
        IF Shot(j%, i%).x >= 320 THEN
            Shot(j%, i%).Active = FALSE
        END IF
        IF Shot(j%, i%).id = idShotExp THEN
            Shot(j%, i%).AnimFlag = (Shot(j%, i%).AnimFlag + 1) AND 3
            IF Shot(j%, i%).AnimFlag = 0 THEN
                Shot(j%, i%).Frame = (Shot(j%, i%).Frame + 1)
            END IF
            IF Shot(j%, i%).Frame >= Shot(j%, i%).MaxFrame THEN
                 Shot(j%, i%).Active = FALSE
            END IF
        END IF
    END IF
NEXT j%
NEXT i%

END SUB

SUB DrawCollideLayer (Layer%, BOM%(), Lvl AS LevelType, TileSpr(), TileSprIndex())

IF Lvl.TileX > 5 THEN   'Base
    BxadderTile% = -4
END IF

'Base
FOR y% = 0 TO 10
FOR x% = BxadderTile% TO 20
        Tx% = x% + Lvl.TileX
        Ty% = y%
        Tile% = RelGetLow(BOM%(Tx%, Ty%))
        IF Tile% > 0 THEN
                screenx% = (x% * 16) - Level.xoffs
                screeny% = (y% * 16)
                RelSpriteColor Layer%, screenx%, screeny%, VARSEG(TileSpr(1)), VARPTR(TileSpr(TileSprIndex(Tile%))), 15
        END IF
NEXT x%
NEXT y%

END SUB

SUB DrawMap (BOM%(), PFM%(), Lvl AS LevelType, FS%)


'Parallax
IF NOT FS% THEN
    IF Lvl.TileX > 5 THEN   'Base
        BxadderTile% = -4
    END IF
    IF Lvl.PTileX > 5 THEN  'Par
        PxadderTile% = -4
    END IF


    FOR y% = 0 TO 10
    FOR x% = PxadderTile% TO 20
            Tx% = x% + Lvl.PTileX
            Ty% = y%
            Tile% = RelGetLow(PFM%(Tx%, Ty%))
            IF Tile% > 0 THEN
                    screenx% = (x% * 16) - Level.Pxoffs
                    screeny% = (y% * 16)
                    RelSpriteSolid Layer%, screenx%, screeny%, VARSEG(TileSpr(1)), VARPTR(TileSpr(TileSprIndex(Tile%)))
            END IF
    NEXT x%
    NEXT y%

    'Base
    FOR y% = 0 TO 10
    FOR x% = BxadderTile% TO 20
            Tx% = x% + Lvl.TileX
            Ty% = y%
            Tile% = RelGetLow(BOM%(Tx%, Ty%))
            IF Tile% > 0 THEN
                    screenx% = (x% * 16) - Level.xoffs
                    screeny% = (y% * 16)
                    RelSprite Layer%, screenx%, screeny%, VARSEG(TileSpr(1)), VARPTR(TileSpr(TileSprIndex(Tile%)))
            END IF
    NEXT x%
    NEXT y%

    '''=========TEMP========
    'Object  test
    FOR y% = 0 TO 10
    FOR x% = 0 TO 20
            Tx% = x% + Lvl.TileX
            Ty% = y%
            Tile% = RelGetHI(BOM%(Tx%, Ty%))
            IF Tile% > 0 THEN
                    screenx% = (x% * 16) - Level.xoffs
                    screeny% = (y% * 16)
                    'RelBoxF Layer%, screenx%, screeny%, screenx% + 15, screeny% + 15, Tile%
            END IF
    NEXT x%
    NEXT y%
    '''=========ENDTEMP========

ELSE           'ForeGround

    IF Lvl.FTileX > 5 THEN   'Base
        FxadderTile% = -4
    END IF

'Foreground
maxx% = UBOUND(PFM%, 1)
FOR y% = 0 TO 10
FOR x% = FxadderTile% TO 20
        Tx% = x% + Lvl.FTileX
        Ty% = y%
        IF Tx% > maxx% THEN
            Tx% = Tx% - (maxx% + 1)
        END IF
        Tile% = RelGetHI(PFM%(Tx%, Ty%))
        IF Tile% > 0 THEN
                screenx% = (x% * 16) - Level.Fxoffs
                screeny% = (y% * 16)
                RelSpriteTrans Layer%, screenx%, screeny%, VARSEG(TileSpr(1)), VARPTR(TileSpr(TileSprIndex(Tile%)))
        END IF
NEXT x%
NEXT y%

END IF
END SUB

SUB DrawObjects (Layer%, Obj() AS ObjectType, ObjSpr(), ObjSprIdx(), ESpr(), ESprIdx())
FOR i% = 0 TO MAXOBJECT
    IF Obj(i%).Active THEN
        TF% = Obj(i%).StartFrame + Obj(i%).Frame
        SELECT CASE Obj(i%).ImgArray
        CASE TMAIN
        CASE TOBJ
            RelSprite Layer%, Obj(i%).x, Obj(i%).y, VARSEG(ObjSpr(1)), VARPTR(ObjSpr(ObjSprIdx(TF%)))
        CASE TEXP
            RelSprite Layer%, Obj(i%).x, Obj(i%).y, VARSEG(ESpr(1)), VARPTR(ESpr(ESprIdx(TF%)))
        CASE ELSE
        END SELECT

    END IF
NEXT i%

END SUB

SUB DrawShip (Ship AS ShipType, Shot() AS ShotType, Home() AS HomingType) STATIC

    'Shot
    FOR i% = 0 TO 2
    FOR j% = 0 TO MAXSHOT
        IF Shot(j%, i%).Active THEN
            SF% = Shot(j%, i%).StartFrame
            F% = Shot(j%, i%).Frame + SF%
            RelSprite Layer%, Shot(j%, i%).x, Shot(j%, i%).y, VARSEG(ShipSpr(1)), VARPTR(ShipSpr(ShipSprIndex(F%)))
        END IF
    NEXT j%
    NEXT i%

    'Homing
    FOR i% = 0 TO MAXHOMING
        IF Home(i%).Active THEN
            SF% = Home(i%).StartFrame
            F% = Home(i%).Frame + SF%
            RelSprite Layer%, Home(i%).x, Home(i%).y, VARSEG(ShipSpr(1)), VARPTR(ShipSpr(ShipSprIndex(F%)))
        END IF
    NEXT i%
    ''For the nice Ship animation  ;*)
    Anim% = (Anim% AND 3) + 1
    IF Anim% = 1 THEN
        TF! = .5
        yv% = FIX(Ship.yv)
        IF SGN(yv%) < 0 THEN            'UP
            tfv! = tfv! + TF!
        ELSEIF SGN(yv%) > 0 THEN        'Down
            tfv! = tfv! - TF!
        ELSE                            'Neutral
            IF tfv! < 0 THEN
                tfv! = tfv! + TF!
            ELSEIF tfv! > 0 THEN
                tfv! = tfv! - TF!
            ELSE
            END IF
        END IF
        IF tfv! < -2 THEN
            tfv! = -2
        ELSEIF tfv! > 2 THEN
            tfv! = 2
        END IF
    END IF
    TFrame% = FIX(tfv! + 3)
    'Ship
    JetAnim% = (JetAnim% AND 3) + 1
    RelSprite Layer%, Ship.x - 1, Ship.y + 5, VARSEG(ShipSpr(1)), VARPTR(ShipSpr(ShipSprIndex(5 + JetAnim%)))
    IF Ship.Action = VICNORMAL THEN
        RelSprite Layer%, Ship.x, Ship.y, VARSEG(ShipSpr(1)), VARPTR(ShipSpr(ShipSprIndex(TFrame%)))
    ELSE
        RelSpriteColor Layer%, Ship.x, Ship.y, VARSEG(ShipSpr(1)), VARPTR(ShipSpr(ShipSprIndex(TFrame%))), 15
    END IF


END SUB

SUB InitImageData (Filename$, ImageArray())

    IF Filename$ <> "" THEN
        '***** Read image data from file *****

        'Establish size of integer array required.
        FileNo = FREEFILE
        OPEN Filename$ FOR BINARY AS #FileNo
        Ints = (LOF(FileNo) - 7) \ 2
        CLOSE #FileNo
        REDIM ImageArray(1 TO Ints)

        'Load image data directly into array memory.
        DEF SEG = VARSEG(ImageArray(1))
        BLOAD Filename$, 0
        DEF SEG
    ELSE
        '***** Read image data from DATA statements *****

        'Establish size of integer array required.
        READ IntCount
        REDIM ImageArray(1 TO IntCount)

        'READ image DATA into array.
        FOR n = 1 TO IntCount
            READ x
            ImageArray(n) = x
        NEXT n
    END IF

END SUB

SUB InitLevel (Lvl AS LevelType, BOM%(), PFM%(), Filename$)

Lvl.camerax = 0 * 16
Lvl.Speed = .5
Lvl.xoffs = 0
Lvl.TileX = 0
Lvl.Pxoffs = 0
Lvl.PTileX = 0
Lvl.Fxoffs = 0
Lvl.FTileX = 0
Lvl.Fcamx = 0 * 16
Lvl.Stopped = FALSE
Lvl.MinSpeed = .1
Lvl.MaxSpeed = 2.5
Lvl.Trans = TRUE




FOR y% = 0 TO MAPYMAX
FOR x% = 0 TO MAPXMAX
        BOM%(x%, y%) = 0
NEXT x%
NEXT y%

'Object
FOR y% = 0 TO MAPYMAX
FOR x% = 0 TO MAPXMAX
    a% = INT(RND * 55)
    c% = INT(RND * 15)
    IF c% = 1 THEN
        RelAddHI VARSEG(BOM%(x%, y%)), VARPTR(BOM%(x%, y%)), idENEMSTRAIGHT
    ELSE
        RelAddHI VARSEG(BOM%(x%, y%)), VARPTR(BOM%(x%, y%)), 0
    END IF
NEXT x%
NEXT y%

'Parallax/ForeGround
FOR y% = 0 TO MAPYMAX
FOR x% = 0 TO PFMAPXMAX
    b% = Lsin!(((TIMER / (y% + 1))) AND 127) * 1128 + Lsin!(((y% + x%)) AND 127) * 128
    b% = b% AND 255
    a% = INT(RND * 4) * ABS((b% AND 7) = 0)
    RelAddLOW VARSEG(PFM%(x%, y%)), VARPTR(PFM%(x%, y%)), a%
    IF (x% AND 7) = 0 THEN
            xty% = INT(RND * MAPYMAX)
            Added = NOT Added
            IF Added THEN RelAddHI VARSEG(PFM%(x%, y%)), VARPTR(PFM%(x%, xty%)), 22 + INT(RND * 10)
    END IF
NEXT x%
NEXT y%



x% = MAPXMAX
FOR y% = 0 TO MAPYMAX
    RelAddHI VARSEG(PFM%(PFMAPXMAX, y%)), VARPTR(PFM%(PFMAPXMAX, y%)), 15
    RelAddLOW VARSEG(BOM%(x%, y%)), VARPTR(BOM%(x%, y%)), 15
NEXT y%


'base Temp
Tile = 0
y% = MAPYMAX
FOR x% = 0 TO MAPXMAX
    'floor
    Tile = (Tile + 1) MOD 15
    RelAddLOW VARSEG(BOM%(x%, y%)), VARPTR(BOM%(x%, y%)), 5 + Tile
    'Add big block
    IF (Tile AND 63) = 0 THEN
        RelAddLOW VARSEG(BOM%(x%, y%)), VARPTR(BOM%(x%, y% - 3)), 21
        xTile% = NOT xTile%     'Top block
        IF xTile% THEN
            RelAddLOW VARSEG(BOM%(x%, y%)), VARPTR(BOM%(x%, y% - 6)), 20
        END IF
    END IF



NEXT x%


UpdateCamera Lvl


END SUB

SUB InitLuts (Ls!(), Lc!())
FOR a% = 0 TO 359
    ang! = (a% * 3.141593 / 180)
    Ls!(a%) = SIN(ang!)
    Lc!(a%) = COS(ang!)
NEXT a%
END SUB

SUB InitObject (x%, y%, id%, Obj AS ObjectType)
'Params:
'x% and y% = Starting coords
'id = its id
'Obj our udt for sprites
'
'
'
'

SELECT CASE id%
    CASE idENEMSTRAIGHT
        Obj.id = id
        Obj.DeathID = idEXPSMALL
        Obj.x = x%
        Obj.y = y%
        Obj.xv = -.5
        Obj.yv = 0
        Obj.Active = TRUE
        Obj.AnimFlag = 0
        Obj.Frame = INT(RND * 2)
        Obj.StartFrame = 91
        Obj.MaxFrame = 4
        Obj.Counter = 0
        Obj.FlipMode = FALSE
        Obj.Action = NORMAL
        Obj.ShotSpeed = 0
        Obj.ShotDelay = 0
        Obj.ShotMaxDelay = 0
        Obj.ImgArray = TOBJ

    CASE idEXPSMALL
        Obj.id = id
        Obj.DeathID = 0
        Obj.x = x%
        Obj.y = y%
        Obj.xv = -.5
        Obj.yv = -.5
        Obj.Active = TRUE
        Obj.AnimFlag = 0
        Obj.Frame = 0
        Obj.StartFrame = 11
        Obj.MaxFrame = 8
        Obj.Counter = 0
        Obj.FlipMode = FALSE
        Obj.Action = NORMAL
        Obj.ShotSpeed = 0
        Obj.ShotDelay = 0
        Obj.ShotMaxDelay = 0
        Obj.ImgArray = TEXP
    CASE ELSE
END SELECT

END SUB

SUB InitShip (Ship AS ShipType, Opt() AS OptionType)

    Ship.id = idVIC
    Ship.x = 10
    Ship.y = 85
    Ship.xv = 1
    Ship.yv = 1
    Ship.Active = TRUE
    Ship.Frame = 0
    Ship.StartFrame = 3
    Ship.MaxFrame = 3
    Ship.Counter = 0
    Ship.Speedx = 2
    Ship.Speedy = 1.8
    Ship.FlipMode = FALSE
    Ship.Action = VICNORMAL
    Ship.ShotSpeed = 8
    Ship.ShotDelay = 0
    Ship.ShotMaxDelay = 3
    Ship.HomingDelay = 0
    Ship.HomingMaxDelay = 8

'Options
FOR i% = 0 TO 1
    Opt(i%).Angle = i% * 180
    Opt(i%).StartFrame = 10
    Opt(i%).MaxFrame = 4
    Opt(i%).Frame = 0
    Opt(i%).ShotSpeed = 11
NEXT i%

END SUB

SUB InitShotObject (x%, y%, id%, Shot AS ShotType)

Shot.id = id
Shot.x = x%
Shot.y = y%
Shot.xv = 0
Shot.yv = 0
Shot.Frame = 0
Shot.StartFrame = 24
Shot.MaxFrame = 2
Shot.AnimFlag = 0

END SUB

SUB LoadData

RelLoadPalPP256 Path$ + "Si.Pal"

InitImageData Path$ + "ShootShp.Put", ShipSpr()
MakeImageIndex ShipSpr(), ShipSprIndex()

InitImageData Path$ + "ShotEnem.Put", ObjectSpr()
MakeImageIndex ObjectSpr(), ObjectSprIndex()

InitImageData Path$ + "ShotLvl.Put", TileSpr()
MakeImageIndex TileSpr(), TileSprIndex()

InitImageData Path$ + "ShootFnt.Put", Font()
MakeImageIndex Font(), FontIndex()

InitImageData Path$ + "ShootEX.Put", ExpSpr()
MakeImageIndex ExpSpr(), ExpSprIndex()


END SUB

SUB MAIN

Finished = FALSE
RelKeyBoardON
DO
   
    RelCls Layer%, 0
    UpdateCamera Level
    DoControls Viper, Shot(), Options(), Object(), Finished
    IF Level.xoffs = 0 THEN CheckObjectMap Object(), BOMap%(), Level
    DoObjects Object()
    DoShots Shot()
    DoHoming Homing(), Object(), Lsin!(), Lcos!()
    DoCollision Layer%, BOMap%(), Level, TileSpr(), TileSprIndex(), ObjectSpr(), ObjectSprIndex(), ShipSpr(), ShipSprIndex(), Viper, Shot(), Homing(), Object()
    DrawMap BOMap%(), PFMap%(), Level, FALSE
    DrawObjects Layer%, Object(), ObjectSpr(), ObjectSprIndex(), ExpSpr(), ExpSprIndex()
    DrawShip Viper, Shot(), Homing()
    DoOptions Options(), Viper, Lsin!(), Lcos!()
    DrawMap BOMap%(), PFMap%(), Level, TRUE
    Fps% = Fps% + 1
    IF StartTime& + 1 < TIMER THEN
     Fps2% = Fps%
     Fps% = 0
     StartTime& = TIMER
    END IF
    RelFont256 Layer%, 0, 176, "Fps:" + STR$(Fps2%), FALSE, Font(), FontIndex()
    RelWait
    RelPcopy VIDEO, Layer%
LOOP UNTIL Finished
RelKeyBoardOFF

END SUB

SUB MakeImageIndex (ImageArray(), IndexArray())

    'The index will initially be built in a temporary array, allowing
    'for the maximum 1000 images per file.
    DIM Temp(1 TO 1000)
    ptr& = 1: IndexNo = 1: LastInt = UBOUND(ImageArray)
    DO
        Temp(IndexNo) = ptr&
        IndexNo = IndexNo + 1

        'Evaluate descriptor of currently referenced image to
        'calculate the beginning of the next image.
        x& = (ImageArray(ptr&) \ 8) * (ImageArray(ptr& + 1)) + 4
        IF x& MOD 2 THEN x& = x& + 1
        ptr& = ptr& + (x& \ 2)
    LOOP WHILE ptr& < LastInt

    LastImage = IndexNo - 1

    'Copy the image index values into the actual index array.
    REDIM IndexArray(1 TO LastImage)
    FOR n = 1 TO LastImage
        IndexArray(n) = Temp(n)
    NEXT n
    ERASE Temp
END SUB

SUB StartHoming (Home() AS HomingType, Ship AS ShipType, Obj() AS ObjectType) STATIC

FOR i% = 0 TO MAXHOMING
    IF NOT Home(i%).Active THEN
        Home(i%).Active = TRUE
        Home(i%).x = Ship.x - 5
        Home(i%).y = Ship.y + 2
        Home(i%).StartFrame = 20
        Home(i%).Frame = 0
        Home(i%).MaxFrame = 4
        Home(i%).Speed = 5
        Home(i%).NewTarget = TRUE
        Home(i%).Angle = 180
        Home(i%).id = idHOMING
        EXIT FOR
    END IF
NEXT i

END SUB

SUB StartShots (Shot() AS ShotType, Ship AS ShipType, Opt() AS OptionType) STATIC
        'Option 1
        FOR i% = 0 TO MAXSHOT
            IF NOT Shot(i%, 1).Active THEN
                SF% = (SF% + 1) AND 1
                Shot(i%, 1).Active = TRUE
                Shot(i%, 1).x = Opt(0).x + 16
                Shot(i%, 1).y = Opt(0).y + 4
                Shot(i%, 1).xv = Opt(0).ShotSpeed
                Shot(i%, 1).yv = 0
                Shot(i%, 1).StartFrame = 16 + SF%
                Shot(i%, 1).Frame = 0
                Shot(i%, 1).id = idShotSTRAIGHT
                EXIT FOR
            END IF
        NEXT i

        'Option 2
        FOR i% = 0 TO MAXSHOT
            IF NOT Shot(i%, 2).Active THEN
                SF% = (SF% + 1) AND 1
                Shot(i%, 2).Active = TRUE
                Shot(i%, 2).x = Opt(1).x + 16
                Shot(i%, 2).y = Opt(1).y + 4
                Shot(i%, 2).xv = Opt(1).ShotSpeed
                Shot(i%, 2).yv = 0
                Shot(i%, 2).StartFrame = 16 + SF%
                Shot(i%, 2).Frame = 0
                Shot(i%, 2).id = idShotSTRAIGHT
                EXIT FOR
            END IF
        NEXT i

        'Ship
        FOR i% = 0 TO MAXSHOT
            IF NOT Shot(i%, 0).Active THEN
                SF% = (SF% + 1) AND 1
                Shot(i%, 0).Active = TRUE
                Shot(i%, 0).x = Ship.x + 15
                Shot(i%, 0).y = Ship.y + 4
                Shot(i%, 0).xv = Ship.ShotSpeed
                Shot(i%, 0).yv = 0
                Shot(i%, 0).StartFrame = 18 + SF%
                Shot(i%, 0).Frame = 0
                Shot(i%, 0).id = idShotSTRAIGHT
                EXIT FOR
            END IF
        NEXT i

END SUB

SUB UpdateCamera (Lvl AS LevelType)

'Normal
NMax% = ((MAPXMAX) * 16) - 320
Lvl.camerax = Lvl.camerax + Lvl.Speed
IF Lvl.camerax >= NMax% THEN
    Lvl.camerax = NMax%
    Lvl.Stopped = TRUE
END IF
Lvl.TileX = Lvl.camerax \ 16
Lvl.xoffs = Lvl.camerax AND 15


''Parallax
parcamx! = Lvl.camerax * .25
Lvl.PTileX = parcamx! \ 16
Lvl.Pxoffs = parcamx! AND 15

'''ForeGround
'''Faster scrolling and wraps-around if over
Fmax% = (PFMAPXMAX + 1) * 16
IF NOT Lvl.Stopped OR Lvl.Fxoffs THEN
    Lvl.Fcamx = Lvl.Fcamx + (Lvl.Speed * 2)
        IF Lvl.Fcamx > Fmax% THEN
            Lvl.Fcamx = Lvl.Fcamx - (Fmax% + 1)
        END IF
END IF
Lvl.FTileX = Lvl.Fcamx \ 16
Lvl.Fxoffs = (Lvl.Fcamx) MOD 16

END SUB

