'KEISPRIT.BAS
'KeiSprite Editor
'(c) 2000-2001 KeiProductions
'
'This is a new version and remake of Keith's Sprite Editor.
'A simple sprite editor that can edit, save and load BSAVEd files (.PIC) as
'well as being able to edit, save and load palettes. (.PAL)
'
'Thanks to the generic version of MOUSE.BAS for the mouse code.
'Thanks to Enhanced Productions' EDRAW for the BSAVE space saving routine.
'
'If you have any problems with this program, drop me a line at my e-mail
'below. Any suggestions, comments, and/or questions are welcome.
'
'E-mail: KeiSprite@keithkosh.com
'   URL: www.keithkosh.com - Click on QBasic.
'
'
'Made and optimized for QBasic 1.1

DEFINT A-Z
OPTION BASE 0

'Mouse SUBs

DECLARE SUB mousehide ()
DECLARE SUB mousedriver (ax, bx, cx, dx)
DECLARE SUB mouseshow ()
DECLARE SUB mousestatus (lb, rb, xmouse, ymouse)
DECLARE SUB mouseput (x, y)
DECLARE SUB mouserange (x1, y1, x2, y2)
DECLARE FUNCTION mouseinit% ()

'Other SUBs (and functions)

DECLARE SUB ColorSet (pal, r, g, B)
DECLARE SUB ColorGet (pal, r, g, B)
DECLARE SUB FileMenu ()
DECLARE SUB ToolsMenu ()
DECLARE SUB PaletteMenu ()
DECLARE SUB SelectMenu ()
DECLARE SUB SaveIt ()
DECLARE SUB OKBtn (row, col)
DECLARE SUB waitforclick (x1, y1, x2, y2)
DECLARE SUB center (text$, row)
DECLARE SUB MakeGradient ()
DECLARE FUNCTION OKorCancel (showtext$)
DECLARE FUNCTION GetInput$ (showtext$)
DECLARE FUNCTION CheckFFile (file$)
DECLARE FUNCTION ReplaceFile (file$)
DECLARE SUB ZoomMode (wx, wy)
DECLARE SUB EndProg ()

'Variables used

DIM SHARED directory$
DIM SHARED availkeys$, cfilename$, currenttool, ccolor, paleditopen
DIM SHARED drawagain
DIM SHARED okx1, oky1, okx2, oky2
DIM SHARED filefound
DIM SHARED scr&(16000), infocover&(880)
DIM SHARED boxcover&(7000)
DIM SHARED isfilesaved, ispalsaved, showpalagain
CONST bottom = 190, top = 0
CONST pencil = 1, linet = 2, box = 3, fbox = 4, circlet = 5, fill = 6
CONST pick = 7, zoom = 8
CONST copy = 9, hflip = 10, vflip = 11, ptiled = 12
availkeys$ = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz1234567890_"

'Program starts here

ON ERROR GOTO runfirst

OPEN "robotdir.dat" FOR INPUT AS #1
INPUT #1, directory$
CLOSE #1

ON ERROR GOTO 0

infobar = bottom
currenttool = pencil
ccolor = 15
isfilesaved = 1: ispalsaved = 1

'Check for mouse

DIM SHARED mouse$

RESTORE

mouse$ = SPACE$(57)
FOR i = 1 TO 57
 READ a$
 h$ = CHR$(VAL("&H" + a$))
 MID$(mouse$, i, 1) = h$
NEXT i

DATA 55,89,E5,8B,5E,0C,8B,07,50,8B,5E,0A,8B,07,50,8B
DATA 5E,08,8B,0F,8B,5E,06,8B,17,5B,58,1E,07,CD,33,53
DATA 8B,5E,0C,89,07,58,8B,5E,0A,89,07,8B,5E,08,89,0F
DATA 8B,5E,06,89,17,5D,CA,08,00

ms = mouseinit%
IF NOT ms THEN
 PRINT "A mouse is required for use of KeiSprite Editor. Either the computer"
 PRINT "you are on does not have one, or it is not configured correctly."
 END
END IF

SCREEN 13: CLS
DEF SEG

COLOR 9: center "KeiSprite Editor", 10
COLOR 7: center "(c) 2000 KeiProductions", 12

OKBtn 14, 20

LINE (51, 61)-(260, 120), 8, B
LINE (50, 60)-(259, 119), 15, B

mouseshow

waitforclick okx1, oky1, okx2, oky2

CALL mousehide: CLS

mainloop:

oldx = -1: oldy = -1

GET (0, infobar)-(319, infobar + 9), infocover&
mouseshow
GOSUB showbar

DO

mousestatus lb, rb, xmouse, ymouse

COLOR 15: LOCATE lc, 1: PRINT "X: ";
COLOR 7: PRINT LTRIM$(RTRIM$(STR$(xmouse))); " ";
COLOR 15: LOCATE lc, 8: PRINT "Y: ";
COLOR 7: PRINT LTRIM$(RTRIM$(STR$(ymouse))); " ";

IF isfilesaved = 1 THEN
 LOCATE lc, 16: PRINT " ";
ELSE
 COLOR 12: LOCATE lc, 16: PRINT "*";
END IF

IF justpressed = 0 THEN
 IF selected = 1 THEN
  SELECT CASE currenttool
   CASE copy
    mousehide
    PUT (0, 0), scr&, PSET
    GET (sx, sy)-(xmouse, ymouse), boxcover&
    bwidth = (xmouse - sx): bheight = (ymouse - sy)
    mouserange bwidth * 2, bheight, 319 * 2, 199
    CALL mouseshow: oldx = -1: oldy = -1
    DO
     mousestatus lb, rb, xmouse, ymouse
     IF lb = -1 THEN
      tx = xmouse - bwidth: ty = ymouse - bheight
      DO: mousestatus lb, rb, xmouse, ymouse: LOOP UNTIL lb = 0
      EXIT DO
     END IF
     IF xmouse <> oldx OR ymouse <> oldy THEN
      oldx = xmouse: oldy = ymouse
      mousehide
      PUT (0, 0), scr&, PSET
      LINE (xmouse - bwidth, ymouse - bheight)-(xmouse, ymouse), 15, B
      mouseshow
     END IF
    LOOP
    mousehide
    PUT (0, 0), scr&, PSET
    PUT (tx, ty), boxcover&, PSET
    GET (0, infobar)-(319, infobar + 9), infocover&
    GOSUB showbar
    mouserange 0, 0, 319 * 2, 299
    mouseshow
    isfilesaved = 0: selected = 0
   CASE hflip
    mousehide
    PUT (0, 0), scr&, PSET
    startx = sx: starty = sy
    finishx = xmouse: finishy = ymouse
    z = INT(((finishy - starty) + 1) / 2)
    FOR f = 1 TO z
     GET (startx, starty + f - 1)-(finishx, starty + f - 1), boxcover&
     GET (startx, finishy - f + 1)-(finishx, finishy - f + 1), infocover&
     PUT (startx, starty + f - 1), infocover&, PSET
     PUT (startx, finishy - f + 1), boxcover&, PSET
    NEXT f
    GET (0, infobar)-(319, infobar + 9), infocover&
    GOSUB showbar
    isfilesaved = 0: selected = 0
    mouserange 0, 0, 319 * 2, 199
    mouseshow
   CASE vflip
    mousehide
    PUT (0, 0), scr&, PSET
    startx = sx: starty = sy
    finishx = xmouse: finishy = ymouse
    z = INT(((finishx - startx) + 1) / 2)
    FOR f = 1 TO z
     GET (startx + f - 1, starty)-(startx + f - 1, finishy), boxcover&
     GET (finishx - f + 1, starty)-(finishx - f + 1, finishy), infocover&
     PUT (startx + f - 1, starty), infocover&, PSET
     PUT (finishx - f + 1, starty), boxcover&, PSET
    NEXT f
    GET (0, infobar)-(319, infobar + 9), infocover&
    GOSUB showbar
    isfilesaved = 0: selected = 0
    mouserange 0, 0, 319 * 2, 199
    mouseshow
   CASE ptiled
    mousehide
    PUT (0, 0), scr&, PSET
    GET (sx, sy)-(xmouse, ymouse), boxcover&
    iw = xmouse - sx + 1: ih = ymouse - sy + 1
    tright = INT(320 / iw): tdown = INT(200 / ih)
    CLS
     FOR t1 = 1 TO tdown
      FOR t2 = 1 TO tright
       PUT ((t2 * iw) - iw, (t1 * ih) - ih), boxcover&, PSET
      NEXT t2
     NEXT t1
    mouserange 0, 0, 319 * 2, 199
    mouseshow
    DO: mousestatus lb, rb, xmouse, ymouse: LOOP UNTIL lb OR rb
    DO: mousestatus lb, rb, xmouse, ymouse: LOOP UNTIL lb = 0 AND rb = 0
    mousehide
    CLS
    PUT (0, 0), scr&, PSET
    GOSUB showbar
    mouseshow
    selected = 0
  END SELECT
 ELSEIF drawingline = 1 THEN
  mousehide
  PUT (0, 0), scr&, PSET
  LINE (sx, sy)-(xmouse, ymouse), ccolor
  GET (0, infobar)-(319, infobar + 9), infocover&
  GOSUB showbar
  mouseshow
  isfilesaved = 0
  drawingline = 0
 ELSEIF drawingbox = 1 THEN
  mousehide
  PUT (0, 0), scr&, PSET
  LINE (sx, sy)-(xmouse, ymouse), ccolor, B
  GET (0, infobar)-(319, infobar + 9), infocover&
  GOSUB showbar
  mouseshow
  isfilesaved = 0
  drawingbox = 0
 ELSEIF drawingfbox = 1 THEN
  mousehide
  PUT (0, 0), scr&, PSET
  LINE (sx, sy)-(xmouse, ymouse), ccolor, BF
  GET (0, infobar)-(319, infobar + 9), infocover&
  GOSUB showbar
  mouseshow
  isfilesaved = 0
  drawingfbox = 0
 ELSEIF drawingcircle = 1 THEN
  mousehide
  PUT (0, 0), scr&, PSET
  CIRCLE (sx, sy), rad, ccolor
  GET (0, infobar)-(319, infobar + 9), infocover&
  GOSUB showbar
  mouseshow
  isfilesaved = 0
  drawingcircle = 0
 ELSEIF filling = 1 THEN
  mousehide
  PUT (0, 0), scr&, PSET
  PAINT (xmouse, ymouse), ccolor, ccolor
  GET (0, infobar)-(319, infobar + 9), infocover&
  GET (0, 0)-(319, 199), scr&
  GOSUB showbar
  mouseshow
  isfilesaved = 0
  filling = 0
 END IF
END IF

IF ymouse >= 150 THEN
 IF infobar = bottom THEN infobar = top: movebar = 1: GOSUB showbar
END IF

IF ymouse < 150 THEN
 IF infobar = top THEN infobar = bottom: movebar = 1: GOSUB showbar
END IF

IF currenttool = zoom THEN GOSUB zoombox

IF lb = -1 THEN
 SELECT CASE currenttool
  CASE pencil: isfilesaved = 0: GOSUB pencil
  CASE linet: GOSUB dline
  CASE box: GOSUB dbox
  CASE fbox: GOSUB fbox
  CASE circlet: GOSUB dcircle
  CASE fill: GOSUB fill
  CASE pick: GOSUB pick
  CASE copy: GOSUB selectb
  CASE hflip: GOSUB selectb
  CASE vflip: GOSUB selectb
  CASE ptiled: GOSUB selectb
  CASE zoom
   DO: mousestatus lb, rb, xmouse, ymouse: LOOP UNTIL lb = 0
   ZoomMode oldx, oldy
   GET (0, infobar)-(319, infobar + 9), infocover&
   GOSUB showbar
   justpressed = 0
 END SELECT
ELSE
 IF currenttool <> zoom THEN justpressed = 0
END IF

IF rb = -1 AND lb = 0 THEN
 DO: mousestatus lb, rb, xmouse, ymouse: LOOP UNTIL rb = 0
 IF currenttool = zoom THEN
  mousehide
  justpressed = 0
  PUT (0, 0), scr&, PSET: GET (0, infobar)-(319, infobar + 9), infocover&
  mouserange 0, 0, 638, 199
  GOSUB showbar
  mouseshow
 END IF
 GOTO showpalandmenu
END IF

LOOP

pencil:
IF oldx = xmouse AND oldy = ymouse THEN RETURN
IF justpressed = 1 THEN
 mousehide
 LINE (oldx, oldy)-(xmouse, ymouse), ccolor
 oldx = xmouse: oldy = ymouse
 mouseshow
ELSEIF justpressed = 0 THEN
 mousehide
 PSET (xmouse, ymouse), ccolor
 oldx = xmouse: oldy = ymouse
 justpressed = 1
 mouseshow
END IF

RETURN

dline:
IF justpressed = 0 THEN
 mousehide
 PUT (0, infobar), infocover&, PSET
 GET (0, 0)-(319, 199), scr&
 sx = xmouse: sy = ymouse
 mouseshow
 justpressed = 1
END IF
IF justpressed = 1 THEN
 IF xmouse <> oldx OR ymouse <> oldy THEN
  oldx = xmouse: oldy = ymouse
  mousehide
  PUT (0, 0), scr&, PSET
  LINE (sx, sy)-(xmouse, ymouse), ccolor
  GOSUB showbar
  mouseshow
  drawingline = 1
 END IF
END IF

RETURN

dbox:
IF justpressed = 0 THEN
 mousehide
 PUT (0, infobar), infocover&, PSET
 GET (0, 0)-(319, 199), scr&
 sx = xmouse: sy = ymouse
 mouseshow
 justpressed = 1
END IF
IF justpressed = 1 THEN
 IF xmouse <> oldx OR ymouse <> oldy THEN
  oldx = xmouse: oldy = ymouse
  mousehide
  PUT (0, 0), scr&, PSET
  LINE (sx, sy)-(xmouse, ymouse), ccolor, B
  GOSUB showbar
  drawingbox = 1
  mouseshow
 END IF
END IF

RETURN

fbox:
IF justpressed = 0 THEN
 mousehide
 PUT (0, infobar), infocover&, PSET
 GET (0, 0)-(319, 199), scr&
 sx = xmouse: sy = ymouse
 mouseshow
 justpressed = 1
END IF
IF justpressed = 1 THEN
 IF xmouse <> oldx OR ymouse <> oldy THEN
  oldx = xmouse: oldy = ymouse
  mousehide
  PUT (0, 0), scr&, PSET
  LINE (sx, sy)-(xmouse, ymouse), ccolor, BF
  GOSUB showbar
  drawingfbox = 1
  mouseshow
 END IF
END IF

RETURN

dcircle:
IF justpressed = 0 THEN
 mousehide
 PUT (0, infobar), infocover&, PSET
 GET (0, 0)-(319, 199), scr&
 sx = xmouse: sy = ymouse
 mouseshow
 justpressed = 1
END IF
IF justpressed = 1 THEN
 IF xmouse <> oldx OR ymouse <> oldy THEN
  oldx = xmouse: oldy = ymouse
  w(1) = xmouse - sx: w(2) = sx - xmouse: w(3) = sy - ymouse: w(4) = ymouse - sy
  FOR a = 3 TO 1 STEP -1
   IF w(a) < w(a + 1) THEN SWAP w(a), w(a + 1)  'Find the highest value
  NEXT a
  rad = w(1)
  mousehide
  PUT (0, 0), scr&, PSET
  CIRCLE (sx, sy), rad, ccolor
  GOSUB showbar
  drawingcircle = 1
  mouseshow
 END IF
END IF

RETURN

fill:
IF justpressed = 0 THEN justpressed = 1
filling = 1
RETURN

pick:
IF xmouse <> oldx OR ymouse <> oldy THEN
 mousehide
 ccolor = POINT(xmouse, ymouse)
 mouseshow
 oldx = xmouse: oldy = ymouse
 GOSUB showbar
END IF

RETURN

zoombox:
IF justpressed = 0 THEN
 mousehide
 mouserange 0, 0, 576, 168
 IF xmouse > 288 THEN mouseput 576, ymouse
 IF ymouse > 168 THEN mouseput xmouse * 2, 168
 PUT (0, infobar), infocover&, PSET
 GET (0, 0)-(319, 199), scr&
 oldx = -1: oldy = -1
 mouseshow
 justpressed = 1
END IF
IF xmouse <> oldx OR ymouse <> oldy THEN
 mousehide
 PUT (0, 0), scr&, PSET
 GOSUB showbar
 LINE (xmouse, ymouse)-(xmouse + 31, ymouse + 31), 15, B
 oldx = xmouse: oldy = ymouse
 mouseshow
END IF

RETURN

selectb:
IF justpressed = 0 THEN
 mousehide
 PUT (0, infobar), infocover&, PSET
 GET (0, 0)-(319, 199), scr&
 sx = xmouse: sy = ymouse
 xr = sx + 159: yr = sy + 99
 IF xr > 319 THEN xr = 319
 IF yr > 199 THEN yr = 199
 IF currenttool <> copy AND currenttool <> ptiled THEN xr = 319: yr = 199
 mouserange sx * 2, sy, xr * 2, yr
 mouseshow
 justpressed = 1
END IF
IF justpressed = 1 THEN
 IF xmouse <> oldx OR ymouse <> oldy THEN
  oldx = xmouse: oldy = ymouse
  mousehide
  PUT (0, 0), scr&, PSET
  LINE (sx, sy)-(xmouse, ymouse), 15, B
  GOSUB showbar
  selected = 1
  mouseshow
 END IF
END IF

RETURN

showpalandmenu:

mousehide

oldx = -1: oldy = -1
oldcx = -1: oldcy = -1

PUT (0, infobar), infocover&, PSET
GET (0, 0)-(319, 199), scr&

skipgetnewscr:

LINE (252, 10)-(319, 199), 0, BF

spal = 0
FOR y = 1 TO 26
FOR x = 1 TO 11
 LINE ((x * 6) + 248, (y * 6) + 7)-(((x * 6) + 4) + 248, ((y * 6) + 4) + 7), spal, BF
 LINE ((x * 6) + 247, (y * 6) + 6)-(((x * 6) + 4) + 249, ((y * 6) + 4) + 8), 8, B
 spal = spal + 1
 IF spal = 256 THEN GOTO exitcloop
NEXT x
NEXT y

exitcloop:

GOSUB ccolor

LINE (0, 10)-(319, 10), 15
LINE (0, 0)-(319, 9), 0, BF

LOCATE 1, 1: COLOR 7: PRINT "File   Tools   Palette   Select";

LINE (251, 10)-(251, 189), 15

IF paleditopen = 1 THEN GOSUB showpaledit ELSE LINE (251, 181)-(251, 199), 15

mouseshow

DO
mousestatus lb, rb, xmouse, ymouse

IF lb = -1 THEN
 GOSUB checkmenu
 IF xmouse = oldcx AND ymouse = oldcy THEN GOTO lppal
 IF paleditopen = 1 THEN
  IF ymouse > 182 AND ymouse < 190 THEN
   IF xmouse >= 8 AND xmouse <= 71 THEN GOSUB editpal
   IF xmouse >= 88 AND xmouse <= 151 THEN GOSUB editpal
   IF xmouse >= 168 AND xmouse <= 231 THEN GOSUB editpal
  END IF
 END IF
 IF xmouse < 254 OR xmouse > 318 THEN GOTO lppal
 IF ymouse < 13 OR ymouse > 155 THEN GOTO lppal
 IF ymouse > 150 AND xmouse > 271 THEN GOTO lppal  'Past 255th color
 xmouse = xmouse - 247
 ymouse = ymouse - 6
 IF xmouse MOD 6 > 0 AND ymouse MOD 6 > 0 THEN
  xmouse = xmouse + 247
  ymouse = ymouse + 6
  oldcx = xmouse: oldcy = ymouse
  CALL mousehide
  ccolor = POINT(xmouse, ymouse): GOSUB ccolor
  mouseshow
 END IF
ELSEIF rb = -1 THEN
 DO: mousestatus lb, rb, xmouse, ymouse: LOOP UNTIL rb = 0
 CALL mousehide: PUT (0, 0), scr&, PSET: GOTO mainloop
END IF

lppal:
LOOP

checkmenu:

IF ymouse < 10 THEN
 'Probably one of the menu items will be selected.
 IF xmouse > 250 THEN RETURN
 IF xmouse < 30 THEN
  FileMenu
  IF drawagain = 1 THEN
   CALL mousehide: PUT (0, 0), scr&, PSET: GOTO mainloop
  END IF
 END IF
 IF xmouse > 55 AND xmouse < 94 THEN
  ToolsMenu
  IF drawagain = 1 THEN
   CALL mousehide: PUT (0, 0), scr&, PSET: GOTO mainloop
  END IF
 END IF
 IF xmouse > 119 AND xmouse < 174 THEN
  IF paleditopen = 0 THEN flag = 1
  showpalagain = 0
  PaletteMenu
  IF showpalagain = 1 AND paleditopen = 1 THEN GOSUB showpaledit
  IF paleditopen = 1 AND flag = 1 THEN GOSUB showpaledit
  IF paleditopen = 0 AND flag = 0 THEN
   mousehide
   PUT (0, 0), scr&, PSET
   GOTO skipgetnewscr
  END IF
  flag = 0
  IF drawagain = 1 THEN
   CALL mousehide: PUT (0, 0), scr&, PSET: GOTO mainloop
  END IF
 END IF
 IF xmouse >= 200 AND xmouse <= 245 THEN
  SelectMenu
  IF drawagain = 1 THEN
   CALL mousehide: PUT (0, 0), scr&, PSET: GOTO mainloop
  END IF
 END IF
END IF

RETURN

ccolor:

z$ = LTRIM$(RTRIM$(STR$(ccolor)))

IF LEN(z$) = 1 THEN
 z$ = "  " + z$
ELSEIF LEN(z$) = 2 THEN
 z$ = " " + z$
END IF

COLOR 15: LOCATE 21, 38: PRINT z$;
LINE (253, 175)-(318, 199), ccolor, BF

IF paleditopen = 1 THEN GOSUB newedit

RETURN

showbar:

mousehide

IF movebar = 1 THEN
 IF infobar = top THEN
  PUT (0, 190), infocover&, PSET
  GET (0, 0)-(319, 9), infocover&
 ELSE
  PUT (0, 0), infocover&, PSET
  GET (0, 190)-(319, 199), infocover&
 END IF
END IF

movebar = 0

IF infobar = top THEN
 lc = 1
 LINE (0, infobar + 9)-(319, infobar + 9), 15
 LINE (0, infobar)-(319, infobar + 8), 0, BF
 LINE (304, infobar)-(319, infobar + 6), ccolor, BF
ELSE
 lc = 25
 LINE (0, infobar + 1)-(319, infobar + 9), 0, BF
 LINE (0, infobar)-(319, infobar), 15
 LINE (304, infobar + 2)-(319, infobar + 8), ccolor, BF
END IF

ccolor$ = "Color " + LTRIM$(RTRIM$(STR$(ccolor)))
COLOR 15: LOCATE lc, 39 - LEN(ccolor$): PRINT ccolor$;
LOCATE lc, 17: COLOR 15
IF cfilename$ = "" THEN PRINT "Untitled";  ELSE PRINT cfilename$;

mouseshow

RETURN

showpaledit:

mousehide

LINE (0, 181)-(251, 199), 0, BF
LINE (0, 181)-(251, 181), 15

LOCATE 25, 1: COLOR 15: PRINT " Red       Green     Blue";

LINE (8, 186)-(71, 186), 15
LINE (88, 186)-(151, 186), 15
LINE (168, 186)-(231, 186), 15

mouseshow

GOSUB newedit

RETURN

newedit:
mousehide
COLOR 15
ColorGet ccolor, r, g, B
r$ = LTRIM$(RTRIM$(STR$(r)))
g$ = LTRIM$(RTRIM$(STR$(g)))
B$ = LTRIM$(RTRIM$(STR$(B)))
IF LEN(r$) = 1 THEN r$ = " " + r$
IF LEN(g$) = 1 THEN g$ = " " + g$
IF LEN(B$) = 1 THEN B$ = " " + B$
LOCATE 25, 8: PRINT r$;
LOCATE 25, 18: PRINT g$;
LOCATE 25, 28: PRINT B$;

LINE (8 + oldr, 183)-(8 + oldr, 185), 0
LINE (8 + oldr, 187)-(8 + oldr, 189), 0

LINE (88 + oldg, 183)-(88 + oldg, 185), 0
LINE (88 + oldg, 187)-(88 + oldg, 189), 0

LINE (168 + oldb, 183)-(168 + oldb, 185), 0
LINE (168 + oldb, 187)-(168 + oldb, 189), 0

LINE (8 + r, 183)-(8 + r, 189), 15
LINE (88 + g, 183)-(88 + g, 189), 15
LINE (168 + B, 183)-(168 + B, 189), 15

oldr = r: oldg = g: oldb = B

mouseshow

RETURN

editpal:
COLOR 15
IF xmouse < 75 THEN
 newred = xmouse - 8
 ColorGet ccolor, r, g, B
 oldr = r
 mousehide
 ColorSet ccolor, newred, g, B
 r$ = LTRIM$(RTRIM$(STR$(newred)))
 IF LEN(r$) = 1 THEN r$ = " " + r$
 LOCATE 25, 8: PRINT r$;
 LINE (8 + oldr, 183)-(8 + oldr, 185), 0
 LINE (8 + oldr, 187)-(8 + oldr, 189), 0
 LINE (8 + newred, 183)-(8 + newred, 189), 15
 mouseshow
 oldr = newred
ELSEIF xmouse > 85 AND xmouse < 160 THEN
 newgreen = xmouse - 88
 ColorGet ccolor, r, g, B
 oldg = g
 mousehide
 ColorSet ccolor, r, newgreen, B
 g$ = LTRIM$(RTRIM$(STR$(newgreen)))
 IF LEN(g$) = 1 THEN g$ = " " + g$
 LOCATE 25, 18: PRINT g$;
 LINE (88 + oldg, 183)-(88 + oldg, 185), 0
 LINE (88 + oldg, 187)-(88 + oldg, 189), 0
 LINE (88 + newgreen, 183)-(88 + newgreen, 189), 15
 mouseshow
 oldg = newgreen
ELSEIF xmouse > 165 THEN
 newblue = xmouse - 168
 ColorGet ccolor, r, g, B
 oldb = B: mousehide
 ColorSet ccolor, r, g, newblue
 B$ = LTRIM$(RTRIM$(STR$(newblue)))
 IF LEN(B$) = 1 THEN B$ = " " + B$
 LOCATE 25, 28: PRINT B$;
 LINE (168 + oldb, 183)-(168 + oldb, 185), 0
 LINE (168 + oldb, 187)-(168 + oldb, 189), 0
 LINE (168 + newblue, 183)-(168 + newblue, 189), 15
 mouseshow
 oldb = newblue
END IF

oldcx = xmouse: oldcy = ymouse
ispalsaved = 0

RETURN

filenotfound:
filefound = 0
RESUME NEXT

runfirst:
CLS : PRINT "Run Robot Robbery first to set the current directory.": END

SUB center (text$, row)

LOCATE row, CINT(((40 - LEN(text$)) / 2) + .6): PRINT text$;
                                               
END SUB

FUNCTION CheckFFile (file$)

ON ERROR GOTO filenotfound

filefound = 1

OPEN directory$ + file$ FOR INPUT AS #1
CLOSE #1

IF filefound = 0 THEN
 showtext$ = file$ + " was not found."
 widthoftext = LEN(showtext$) * 8
 st = CINT(((40 - LEN(showtext$)) / 2) + .6)

 mousehide

 GET ((st * 8) - 20, 65)-((st * 8) + widthoftext + 3, 121), boxcover&
 LINE ((st * 8) - 19, 66)-((st * 8) + widthoftext + 1, 119), 0, BF
 LINE ((st * 8) - 19, 66)-((st * 8) + widthoftext + 3, 121), 8, B
 LINE ((st * 8) - 20, 65)-((st * 8) + widthoftext + 2, 120), 15, B

 COLOR 12: center "ERROR", 10
 COLOR 15: center file$ + " was not found.", 12
 OKBtn 14, 20

 mouseshow

 waitforclick okx1, oky1, okx2, oky2

 mousehide
 PUT ((st * 8) - 20, 65), boxcover&, PSET
 mouseshow
END IF

CheckFFile = filefound

END FUNCTION

SUB ColorGet (pal, r, g, B)

OUT &H3C7, pal
r = INP(&H3C9)
g = INP(&H3C9)
B = INP(&H3C9)

END SUB

SUB ColorSet (pal, r, g, B)

OUT &H3C8, pal
OUT &H3C9, r
OUT &H3C9, g
OUT &H3C9, B

END SUB

SUB EndProg

mousehide

CLS
SYSTEM

END SUB

SUB FileMenu

drawagain = 0

mousehide
LOCATE 1, 1: COLOR 9: PRINT "File";
GET (0, 11)-(60, 94), boxcover&
LINE (0, 11)-(59, 93), 0, BF
LINE (-1, 10)-(60, 94), 15, B
COLOR 15
LOCATE 3, 1: PRINT "New"
LOCATE 5, 1: PRINT "Open"
LOCATE 7, 1: PRINT "Save"
LOCATE 9, 1: PRINT "Save as"
LOCATE 11, 1: PRINT "Exit"
mouseshow

DO
mousestatus lb, rb, xmouse, ymouse

IF rb THEN
 DO: mousestatus lb, rb, xmouse, ymouse: LOOP UNTIL rb = 0
 drawagain = 1: EXIT SUB
END IF

IF lb THEN

 IF ymouse < 10 AND xmouse > 29 THEN GOSUB closefilemenu: EXIT SUB
 IF xmouse > 60 THEN GOSUB closefilemenu: EXIT SUB
 IF ymouse > 94 THEN GOSUB closefilemenu: EXIT SUB

 IF ymouse >= 16 AND ymouse <= 22 AND xmouse <= 22 THEN        'New
   DO: mousestatus lb, rb, xmouse, ymouse: LOOP UNTIL lb = 0
   IF ymouse >= 16 AND ymouse <= 22 AND xmouse <= 22 THEN
    GOSUB closefilemenu
    IF isfilesaved = 0 THEN
     c = OKorCancel("File not saved. Continue?")
     IF c = 0 THEN EXIT SUB
    END IF
    IF ispalsaved = 0 THEN
     c = OKorCancel("Palette not saved. Continue?")
     IF c = 0 THEN EXIT SUB
    END IF
    CALL mousehide: LINE (0, 0)-(319, 199), 0, BF
    PALETTE
    GET (0, 0)-(319, 199), scr&
    ccolor = 15: cfilename$ = ""
    isfilesaved = 1: ispalsaved = 1
    CALL mouseshow
    drawagain = 1
    EXIT SUB
   END IF
 END IF

 IF ymouse >= 32 AND ymouse <= 39 AND xmouse <= 29 THEN        'Open
  DO: mousestatus lb, rb, xmouse, ymouse: LOOP UNTIL lb = 0
  IF ymouse >= 32 AND ymouse <= 39 AND xmouse <= 29 THEN
   GOSUB closefilemenu
   openname$ = GetInput("Enter file to open:")
   IF openname$ = "" THEN EXIT SUB
   filename$ = UCASE$(openname$) + ".PIC"
   z = CheckFFile(filename$)
   IF z = 0 THEN EXIT SUB
   IF isfilesaved = 0 THEN
    c = OKorCancel("File not saved. Continue?")
    IF c = 0 THEN EXIT SUB
   END IF
   IF ispalsaved = 0 THEN
    c = OKorCancel("Palette not saved. Continue?")
    IF c = 0 THEN EXIT SUB
   END IF
   CALL mousehide: LINE (0, 0)-(319, 199), 0, BF
   PALETTE
   BLOAD directory$ + filename$
   ccolor = 15: cfilename$ = filename$
   GET (0, 0)-(319, 199), scr&
   CALL mouseshow
   drawagain = 1: isfilesaved = 1: ispalsaved = 1: EXIT SUB
   EXIT SUB
  END IF
 END IF

 IF ymouse >= 48 AND ymouse <= 54 AND xmouse <= 29 THEN        'Save
  DO: mousestatus lb, rb, xmouse, ymouse: LOOP UNTIL lb = 0
  IF ymouse >= 48 AND ymouse <= 54 AND xmouse <= 29 THEN
   GOSUB closefilemenu
   IF cfilename$ = "" THEN
    savename$ = GetInput("Save file as?")
    IF savename$ = "" THEN EXIT SUB
    savename$ = UCASE$(savename$) + ".PIC"
    a = ReplaceFile(savename$)
    IF a THEN
     z = OKorCancel("Replace " + savename$ + "?")
     IF z = 0 THEN EXIT SUB
     cfilename$ = savename$
    END IF
   END IF
   SaveIt
   drawagain = 1: EXIT SUB
  END IF
 END IF

 IF ymouse >= 64 AND ymouse <= 70 AND xmouse <= 53 THEN         'Save as
  DO: mousestatus lb, rb, xmouse, ymouse: LOOP UNTIL lb = 0
  IF ymouse >= 64 AND ymouse <= 70 AND xmouse <= 53 THEN
   GOSUB closefilemenu
   savename$ = GetInput("Save file as?")
   IF savename$ = "" THEN EXIT SUB
   savename$ = UCASE$(savename$) + ".PIC"
   a = ReplaceFile(savename$)
   IF a THEN
    z = OKorCancel("Replace " + savename$ + "?")
    IF z = 0 THEN EXIT SUB
   END IF
   cfilename$ = savename$: SaveIt
   drawagain = 1: EXIT SUB
   EXIT SUB
  END IF
 END IF

 IF ymouse >= 80 AND ymouse <= 86 AND xmouse <= 29 THEN
  DO: mousestatus lb, rb, xmouse, ymouse: LOOP UNTIL lb = 0
  IF ymouse >= 80 AND ymouse <= 86 AND xmouse <= 29 THEN
   GOSUB closefilemenu
   IF isfilesaved = 0 THEN
    c = OKorCancel("File not saved. Exit?")
    IF c = 0 THEN EXIT SUB
   END IF
   IF ispalsaved = 0 THEN
    c = OKorCancel("Palette not saved. Exit?")
    IF c = 0 THEN EXIT SUB
   END IF
   EndProg
  END IF
 END IF

END IF

LOOP

closefilemenu:
mousehide
PUT (0, 11), boxcover&, PSET
LOCATE 1, 1: COLOR 7: PRINT "File"
mouseshow
RETURN

END SUB

FUNCTION GetInput$ (showtext$)

widthoftext = LEN(showtext$) * 8

st = CINT(((40 - LEN(showtext$)) / 2) + .6)

mousehide

GET ((st * 8) - 20, 62)-((st * 8) + widthoftext + 3, 129), boxcover&

LINE ((st * 8) - 19, 63)-((st * 8) + widthoftext + 1, 127), 0, BF
LINE ((st * 8) - 19, 63)-((st * 8) + widthoftext + 3, 129), 8, B
LINE ((st * 8) - 20, 62)-((st * 8) + widthoftext + 2, 128), 15, B

COLOR 15: LOCATE 10, st: PRINT showtext$;

LOCATE 15, 15: PRINT "OK    Cancel"

LINE (108, 108)-(130, 122), 10, B
LINE (156, 108)-(208, 122), 12, B

LINE (116, 85)-(194, 99), 15, B

mouseshow

COLOR 7: LOCATE 12, 16: PRINT CHR$(219)
st$ = ""

DO
getmk:
 z$ = INKEY$
 mousestatus lb, rb, xmouse, ymouse
 IF lb THEN
  IF xmouse >= 108 AND xmouse <= 130 AND ymouse >= 108 AND ymouse <= 122 THEN
   DO: mousestatus lb, rb, xmouse, ymouse: LOOP UNTIL lb = 0
   IF xmouse >= 108 AND xmouse <= 130 AND ymouse >= 108 AND ymouse <= 122 THEN
    IF st$ > "" THEN EXIT DO
   END IF
  ELSEIF xmouse >= 156 AND xmouse <= 208 AND ymouse >= 108 AND ymouse <= 122 THEN
   DO: mousestatus lb, rb, xmouse, ymouse: LOOP UNTIL lb = 0
   IF xmouse >= 156 AND xmouse <= 208 AND ymouse >= 108 AND ymouse <= 122 THEN
    st$ = "": EXIT DO
   END IF
  END IF
 END IF
 IF z$ = "" THEN GOTO getmk
 IF INSTR(availkeys$, z$) THEN
  IF LEN(st$) = 8 THEN GOTO lp
  st$ = st$ + z$
  LOCATE 12, 15 + LEN(st$):
  mousehide
  COLOR 15: PRINT z$; : COLOR 7: PRINT CHR$(219);
  mouseshow
 ELSEIF z$ = CHR$(8) THEN
  IF LEN(st$) > 0 THEN
   st$ = LEFT$(st$, LEN(st$) - 1)
   LOCATE 12, 16 + LEN(st$)
   mousehide
   COLOR 7: PRINT CHR$(219); " ";
   mouseshow
  END IF
 ELSEIF z$ = CHR$(13) THEN
  IF LEN(st$) > 0 THEN EXIT DO
 END IF
lp:
LOOP

GetInput$ = st$

CALL mousehide: PUT ((st * 8) - 20, 62), boxcover&, PSET: mouseshow

END FUNCTION

SUB MakeGradient

mousehide

GET (68, 62)-(243, 128), boxcover&
LINE (68, 62)-(242, 128), 0, BF
LINE (69, 63)-(243, 128), 8, B
LINE (68, 62)-(242, 127), 15, B

COLOR 9: center "GRADIENT", 10
GOSUB newcols

LOCATE 15, 15: PRINT "OK    Cancel"

LINE (108, 108)-(130, 122), 10, B
LINE (156, 108)-(208, 122), 12, B

mouseshow

DO
 mousestatus lb, rb, xmouse, ymouse
 IF lb THEN
  IF xmouse >= 88 AND xmouse <= 158 AND ymouse >= 88 AND ymouse <= 94 THEN
   DO: mousestatus lb, rb, xmouse, ymouse: LOOP UNTIL lb = 0
   IF xmouse >= 88 AND xmouse <= 158 AND ymouse >= 88 AND ymouse <= 94 THEN
    IF cgselected <> 1 THEN
     cgselected = 1
     GOSUB newcols
    ELSE
     cgselected = 0
     GOSUB newcols
     END IF
   END IF
  END IF
  IF xmouse >= 168 AND xmouse <= 222 AND ymouse >= 88 AND ymouse <= 94 THEN
   DO: mousestatus lb, rb, xmouse, ymouse: LOOP UNTIL lb = 0
   IF xmouse >= 168 AND xmouse <= 222 AND ymouse >= 88 AND ymouse <= 94 THEN
    IF cgselected < 2 THEN
     cgselected = 2
     GOSUB newcols
    ELSE
     cgselected = 0
     GOSUB newcols
    END IF
   END IF
  END IF
  IF xmouse >= 108 AND xmouse <= 130 AND ymouse >= 108 AND ymouse <= 122 THEN
   DO: mousestatus lb, rb, xmouse, ymouse: LOOP UNTIL lb = 0
   IF xmouse >= 108 AND xmouse <= 130 AND ymouse >= 108 AND ymouse <= 122 THEN go = 1: EXIT DO
  ELSEIF xmouse >= 156 AND xmouse <= 208 AND ymouse >= 108 AND ymouse <= 122 THEN
   DO: mousestatus lb, rb, xmouse, ymouse: LOOP UNTIL lb = 0
   IF xmouse >= 156 AND xmouse <= 208 AND ymouse >= 108 AND ymouse <= 122 THEN go = 0: EXIT DO
  END IF
  IF xmouse < 254 OR xmouse > 318 THEN GOTO np
  IF ymouse < 13 OR ymouse > 155 THEN GOTO np
  IF ymouse > 150 AND xmouse > 271 THEN GOTO np  'Past 255th color
  xmouse = xmouse - 247
  ymouse = ymouse - 6
  IF xmouse MOD 6 > 0 AND ymouse MOD 6 > 0 THEN
   IF xmouse + 247 = oldcx AND ymouse + 6 = oldcy THEN GOTO np
   xmouse = xmouse + 247
   ymouse = ymouse + 6
   oldcx = xmouse: oldcy = ymouse
   CALL mousehide
   ccolor = POINT(xmouse, ymouse)
   mouseshow
   IF cgselected > 0 THEN
    IF cgselected = 1 THEN col1 = ccolor ELSE col2 = ccolor
    GOSUB newcols
   END IF
  END IF
 END IF
np:
LOOP

IF go = 0 THEN GOTO exitgrad

CALL mousehide: PUT (68, 62), boxcover&, PSET

IF col1 = col2 THEN mouseshow: EXIT SUB
IF col1 < col2 THEN gradstart = col1: gradfin = col2
IF col1 > col2 THEN gradstart = col2: gradfin = col1
IF gradfin - gradstart <= 1 THEN mouseshow: EXIT SUB

ColorGet gradstart, r, g, B
r1 = r: g1 = g: b1 = B
ColorGet gradfin, r, g, B
r2 = r: g2 = g: b2 = B
rinc! = (r2 - r1) / (gradfin - gradstart)
ginc! = (g2 - g1) / (gradfin - gradstart)
binc! = (b2 - b1) / (gradfin - gradstart)

gradfin = gradfin - 1: gradstart = gradstart + 1

FOR a = gradstart TO gradfin
 count = count + 1
 newred = CINT(r1 + (rinc! * count))
 newgreen = CINT(g1 + (ginc! * count))
 newblue = CINT(b1 + (binc! * count))
 ColorSet a, newred, newgreen, newblue
NEXT a

ispalsaved = 0
mouseshow
EXIT SUB

exitgrad:
CALL mousehide: PUT (68, 62), boxcover&, PSET: mouseshow
EXIT SUB

newcols:

mousehide
col1$ = LTRIM$(RTRIM$(STR$(col1)))
IF LEN(col1$) = 2 THEN col1$ = col1$ + " "
IF LEN(col1$) = 1 THEN col1$ = col1$ + "  "
col2$ = LTRIM$(RTRIM$(STR$(col2)))
IF LEN(col2$) = 2 THEN col2$ = col2$ + " "
IF LEN(col2$) = 1 THEN col2$ = col2$ + "  "
IF cgselected = 1 THEN COLOR 9 ELSE COLOR 15
LOCATE 12, 12: PRINT "From: " + col1$
LINE (88, 99)-(158, 96), col1, BF
IF cgselected = 2 THEN COLOR 9 ELSE COLOR 15
LOCATE 12, 22: PRINT "To: " + col2$
LINE (168, 99)-(222, 96), col2, BF
mouseshow

RETURN

END SUB

SUB mousedriver (ax, bx, cx, dx)
  DEF SEG = VARSEG(mouse$)
  mouse = SADD(mouse$)
  CALL Absolute(ax, bx, cx, dx, mouse)
END SUB

SUB mousehide
 ax = 2
 mousedriver ax, 0, 0, 0
END SUB

FUNCTION mouseinit%
  ax = 0
  mousedriver ax, 0, 0, 0
  mouseinit = ax
END FUNCTION

SUB mouseput (x, y)
  ax = 4
  cx = x
  dx = y
  mousedriver ax, 0, cx, dx
END SUB

SUB mouserange (x1, y1, x2, y2)
ax1 = 7
cx1 = x1
dx1 = x2
mousedriver ax1, 0, cx1, dx1
ax1 = 8
cx1 = y1
dx1 = y2
mousedriver ax1, 0, cx1, dx1
END SUB

SUB mouseshow
  ax = 1
  mousedriver ax, 0, 0, 0
END SUB

SUB mousestatus (lb, rb, xmouse, ymouse)
  ax = 3
  mousedriver ax, bx, cx, dx
  lb = ((bx AND 1) <> 0)
  rb = ((bx AND 2) <> 0)
  xmouse = cx
  ymouse = dx
  xmouse = xmouse / 2
END SUB

SUB OKBtn (row, col)

LOCATE row, col: COLOR 15: PRINT "OK";

swidth = 4

startx = (col * 8) - 8 - swidth
starty = (row * 8) - 8 - swidth

endx = startx + 14 + (swidth * 2)
endy = starty + 6 + (swidth * 2)

LINE (startx, starty)-(endx, endy), 10, B

okx1 = startx: oky1 = starty: okx2 = endx: oky2 = endy

END SUB

FUNCTION OKorCancel (showtext$)

widthoftext = LEN(showtext$) * 8

st = CINT(((40 - LEN(showtext$)) / 2) + .6)

mousehide

GET ((st * 8) - 20, 70)-((st * 8) + widthoftext + 3, 121), boxcover&

LINE ((st * 8) - 19, 71)-((st * 8) + widthoftext + 1, 119), 0, BF
LINE ((st * 8) - 19, 71)-((st * 8) + widthoftext + 3, 121), 8, B
LINE ((st * 8) - 20, 70)-((st * 8) + widthoftext + 2, 120), 15, B

COLOR 15: LOCATE 11, st: PRINT showtext$;

LOCATE 14, 15: PRINT "OK    Cancel"

LINE (108, 100)-(130, 114), 10, B
LINE (156, 100)-(208, 114), 12, B

mouseshow

DO
 mousestatus lb, rb, xmouse, ymouse
 IF lb THEN
  IF xmouse >= 108 AND xmouse <= 130 AND ymouse >= 100 AND ymouse <= 114 THEN
   DO: mousestatus lb, rb, xmouse, ymouse: LOOP UNTIL lb = 0
   IF xmouse >= 108 AND xmouse <= 130 AND ymouse >= 100 AND ymouse <= 114 THEN choice = 1: EXIT DO
  ELSEIF xmouse >= 156 AND xmouse <= 208 AND ymouse >= 100 AND ymouse <= 114 THEN
   DO: mousestatus lb, rb, xmouse, ymouse: LOOP UNTIL lb = 0
   IF xmouse >= 156 AND xmouse <= 208 AND ymouse >= 100 AND ymouse <= 114 THEN choice = 0: EXIT DO
  END IF
 END IF
LOOP

OKorCancel = choice

CALL mousehide: PUT ((st * 8) - 20, 70), boxcover&, PSET: mouseshow

END FUNCTION

SUB PaletteMenu
drawagain = 0

mousehide
LOCATE 1, 16: COLOR 9: PRINT "Palette";
GET (114, 10)-(188, 94), boxcover&
LINE (115, 11)-(187, 93), 0, BF
LINE (114, 10)-(188, 94), 15, B
COLOR 15
LOCATE 3, 16: PRINT "Open"
LOCATE 5, 16: PRINT "Save"
LOCATE 7, 16: PRINT "Edit"
LOCATE 9, 16: PRINT "Restore"
LOCATE 11, 16: PRINT "Gradient"

IF paleditopen THEN COLOR 9: LOCATE 7, 20: PRINT ""
mouseshow

DO
mousestatus lb, rb, xmouse, ymouse

IF rb THEN
 DO: mousestatus lb, rb, xmouse, ymouse: LOOP UNTIL rb = 0
 drawagain = 1: EXIT SUB
END IF

IF lb THEN
 IF ymouse < 10 AND (xmouse < 120 OR xmouse > 173) THEN GOSUB closepalm: EXIT SUB
 IF xmouse < 114 OR xmouse > 188 THEN GOSUB closepalm: EXIT SUB
 IF ymouse > 94 THEN GOSUB closepalm: EXIT SUB
 
 IF xmouse >= 120 AND xmouse <= 149 AND ymouse >= 16 AND ymouse <= 23 THEN
  DO: mousestatus lb, rb, xmouse, ymouse: LOOP UNTIL lb = 0
  IF xmouse >= 120 AND xmouse <= 149 AND ymouse >= 16 AND ymouse <= 23 THEN
   GOSUB closepalm
   openpal$ = GetInput("Enter palette file to open:")
   IF openpal$ = "" THEN EXIT SUB
   openpal$ = UCASE$(openpal$) + ".PAL"
   z = CheckFFile(openpal$)
   IF z = 0 THEN EXIT SUB
   IF ispalsaved = 0 THEN
    c = OKorCancel("Palette not saved. Continue?")
    IF c = 0 THEN EXIT SUB
   END IF
   OPEN directory$ + openpal$ FOR BINARY AS #1
   DIM pb AS STRING * 1
   FOR c = 0 TO 255
    GET #1, , pb: r = ASC(pb)
    GET #1, , pb: g = ASC(pb)
    GET #1, , pb: B = ASC(pb)
    ColorSet c, r, g, B
   NEXT c
   CLOSE #1
   ispalsaved = 1: showpalagain = 1
   EXIT SUB
  END IF
 END IF
 IF xmouse >= 120 AND xmouse <= 149 AND ymouse >= 32 AND ymouse <= 38 THEN
  DO: mousestatus lb, rb, xmouse, ymouse: LOOP UNTIL lb = 0
  IF xmouse >= 120 AND xmouse <= 149 AND ymouse >= 32 AND ymouse <= 38 THEN
   GOSUB closepalm
   savepal$ = GetInput("Save palette file as:")
   IF savepal$ = "" THEN EXIT SUB
   savepal$ = UCASE$(savepal$) + ".PAL"
   a = ReplaceFile(savepal$)
   IF a THEN
    z = OKorCancel("Replace " + savepal$ + "?")
    IF z = 0 THEN EXIT SUB
   END IF
   OPEN directory$ + savepal$ FOR BINARY AS #1
   FOR c = 0 TO 255
    ColorGet c, r, g, B
    r$ = CHR$(r): PUT #1, , r$
    g$ = CHR$(g): PUT #1, , g$
    B$ = CHR$(B): PUT #1, , B$
   NEXT c
   CLOSE #1
   ispalsaved = 1: EXIT SUB
  END IF
 END IF
 IF xmouse >= 120 AND xmouse <= 149 AND ymouse >= 48 AND ymouse <= 54 THEN
  DO: mousestatus lb, rb, xmouse, ymouse: LOOP UNTIL lb = 0
  IF xmouse >= 120 AND xmouse <= 149 AND ymouse >= 48 AND ymouse <= 54 THEN
   IF paleditopen = 0 THEN paleditopen = 1 ELSE paleditopen = 0
   GOSUB closepalm: EXIT SUB
  END IF
 END IF

 IF xmouse >= 120 AND xmouse <= 173 AND ymouse >= 64 AND ymouse <= 70 THEN
  DO: mousestatus lb, rb, xmouse, ymouse: LOOP UNTIL lb = 0
  IF xmouse >= 120 AND xmouse <= 173 AND ymouse >= 64 AND ymouse <= 70 THEN
   GOSUB closepalm
   c = OKorCancel("Restore palette to QBasic default?")
   IF c THEN
    IF ispalsaved = 0 THEN
     c = OKorCancel("Palette not saved. Continue?")
     IF c = 0 THEN EXIT SUB
    END IF
    PALETTE: showpalagain = 1: ispalsaved = 1: EXIT SUB
   END IF
   EXIT SUB
  END IF
 END IF
 IF xmouse >= 120 AND xmouse <= 181 AND ymouse >= 80 AND ymouse <= 86 THEN
  DO: mousestatus lb, rb, xmouse, ymouse: LOOP UNTIL lb = 0
  IF xmouse >= 120 AND xmouse <= 181 AND ymouse >= 80 AND ymouse <= 86 THEN
   GOSUB closepalm
   MakeGradient
   showpalagain = 1: EXIT SUB
  END IF
 END IF
END IF

LOOP

closepalm:
mousehide
PUT (114, 10), boxcover&, PSET
LOCATE 1, 16: COLOR 7: PRINT "Palette"
mouseshow
RETURN

END SUB

FUNCTION ReplaceFile (file$)

ON ERROR GOTO filenotfound

filefound = 1

OPEN directory$ + file$ FOR INPUT AS #1
CLOSE #1

ReplaceFile = filefound

END FUNCTION

SUB SaveIt
mousehide
CLS : PUT (0, 0), scr&

Lines! = 0
FOR i = 199 TO 0 STEP -1
 DataBlock = 0
 FOR ii = 0 TO 319
  IF POINT(ii, i) <> 0 THEN DataBlock = 1: EXIT FOR
 NEXT ii
 IF DataBlock = 1 THEN Lines! = i + 1: EXIT FOR
NEXT i

IF Lines! = 0 THEN Lines! = 1
CountSpace! = 320 * Lines!

DEF SEG = &HA000
BSAVE directory$ + cfilename$, 0, CountSpace!
DEF SEG = 0

mouseshow

isfilesaved = 1

END SUB

SUB SelectMenu
drawagain = 0

mousehide
LOCATE 1, 26: COLOR 9: PRINT "Select";
GET (194, 10)-(285, 78), boxcover&
LINE (195, 11)-(284, 77), 0, BF
LINE (194, 10)-(285, 78), 15, B
COLOR 15
IF currenttool = copy THEN COLOR 9 ELSE COLOR 15
LOCATE 3, 26: PRINT "Copy"
IF currenttool = hflip THEN COLOR 9 ELSE COLOR 15
LOCATE 5, 26: PRINT "Horiz flip"
IF currenttool = vflip THEN COLOR 9 ELSE COLOR 15
LOCATE 7, 26: PRINT "Vert flip"'
IF currenttool = ptiled THEN COLOR 9 ELSE COLOR 15
LOCATE 9, 26: PRINT "Prev tiled"
mouseshow

DO
mousestatus lb, rb, xmouse, ymouse

IF rb THEN
 DO: mousestatus lb, rb, xmouse, ymouse: LOOP UNTIL rb = 0
 drawagain = 1: EXIT SUB
END IF

IF lb THEN

 IF ymouse < 10 AND (xmouse < 200 OR xmouse > 245) THEN GOSUB closeselect: EXIT SUB
 IF xmouse < 194 OR xmouse > 285 THEN GOSUB closeselect: EXIT SUB
 IF ymouse > 78 THEN GOSUB closeselect: EXIT SUB

 IF xmouse >= 200 AND xmouse <= 229 AND ymouse >= 16 AND ymouse <= 23 THEN
  DO: mousestatus lb, rb, xmouse, ymouse: LOOP UNTIL lb = 0
  IF xmouse >= 200 AND xmouse <= 229 AND ymouse >= 16 AND ymouse <= 23 THEN
   IF currenttool <> copy THEN
    currenttool = copy
    GOSUB closeselect: EXIT SUB
   END IF
  END IF
 END IF
 IF xmouse >= 200 AND xmouse <= 278 AND ymouse >= 32 AND ymouse <= 39 THEN
  DO: mousestatus lb, rb, xmouse, ymouse: LOOP UNTIL lb = 0
  IF xmouse >= 200 AND xmouse <= 278 AND ymouse >= 32 AND ymouse <= 39 THEN
   IF currenttool <> hflip THEN
    currenttool = hflip
    GOSUB closeselect: EXIT SUB
   END IF
  END IF
 END IF
 IF xmouse >= 200 AND xmouse <= 270 AND ymouse >= 48 AND ymouse <= 55 THEN
  DO: mousestatus lb, rb, xmouse, ymouse: LOOP UNTIL lb = 0
  IF xmouse >= 200 AND xmouse <= 278 AND ymouse >= 48 AND ymouse <= 55 THEN
   IF currenttool <> vflip THEN
    currenttool = vflip
    GOSUB closeselect: EXIT SUB
   END IF
  END IF
 END IF
 IF xmouse >= 200 AND xmouse <= 278 AND ymouse >= 64 AND ymouse <= 70 THEN
  DO: mousestatus lb, rb, xmouse, ymouse: LOOP UNTIL lb = 0
  IF xmouse >= 200 AND xmouse <= 278 AND ymouse >= 64 AND ymouse <= 70 THEN
   IF currenttool <> ptiled THEN
    currenttool = ptiled
    GOSUB closeselect: EXIT SUB
   END IF
  END IF
 END IF
END IF

LOOP

closeselect:
mousehide
PUT (194, 10), boxcover&, PSET
LOCATE 1, 26: COLOR 7: PRINT "Select"
mouseshow
RETURN

END SUB

SUB ToolsMenu
drawagain = 0

mousehide
LOCATE 1, 8: COLOR 9: PRINT "Tools";
GET (50, 10)-(108, 142), boxcover&
LINE (51, 11)-(107, 141), 0, BF
LINE (50, 10)-(108, 142), 15, B
COLOR 15
IF currenttool = pencil THEN COLOR 9 ELSE COLOR 15
LOCATE 3, 8: PRINT "Pencil"
IF currenttool = linet THEN COLOR 9 ELSE COLOR 15
LOCATE 5, 8: PRINT "Line"
IF currenttool = box THEN COLOR 9 ELSE COLOR 15
LOCATE 7, 8: PRINT "Box"
IF currenttool = fbox THEN COLOR 9 ELSE COLOR 15
LOCATE 9, 8: PRINT "FBox"
IF currenttool = circlet THEN COLOR 9 ELSE COLOR 15
LOCATE 11, 8: PRINT "Circle"
IF currenttool = fill THEN COLOR 9 ELSE COLOR 15
LOCATE 13, 8: PRINT "Fill"
IF currenttool = pick THEN COLOR 9 ELSE COLOR 15
LOCATE 15, 8: PRINT "Pick"
IF currenttool = zoom THEN COLOR 9 ELSE COLOR 15
LOCATE 17, 8: PRINT "Zoom"
mouseshow

DO
mousestatus lb, rb, xmouse, ymouse

IF rb THEN
 DO: mousestatus lb, rb, xmouse, ymouse: LOOP UNTIL rb = 0
 drawagain = 1: EXIT SUB
END IF

IF lb THEN

 IF ymouse < 10 AND (xmouse < 56 OR xmouse > 93) THEN GOSUB closetools: EXIT SUB
 IF xmouse < 50 OR xmouse > 108 THEN GOSUB closetools: EXIT SUB
 IF ymouse > 142 THEN GOSUB closetools: EXIT SUB

 IF xmouse >= 56 AND xmouse <= 100 AND ymouse >= 16 AND ymouse <= 22 THEN
  DO: mousestatus lb, rb, xmouse, ymouse: LOOP UNTIL lb = 0
  IF xmouse >= 56 AND ymouse <= 100 AND ymouse >= 16 AND ymouse <= 22 THEN
   IF currenttool <> pencil THEN
    currenttool = pencil
    GOSUB closetools: EXIT SUB
   END IF
  END IF
 END IF
 IF xmouse >= 56 AND xmouse <= 85 AND ymouse >= 32 AND ymouse <= 38 THEN
  DO: mousestatus lb, rb, xmouse, ymouse: LOOP UNTIL lb = 0
  IF xmouse >= 56 AND xmouse <= 85 AND ymouse >= 32 AND ymouse <= 38 THEN
   IF currenttool <> linet THEN
    currenttool = linet
    GOSUB closetools: EXIT SUB
   END IF
  END IF
 END IF
 IF xmouse >= 56 AND xmouse <= 78 AND ymouse >= 48 AND ymouse <= 54 THEN
  DO: mousestatus lb, rb, xmouse, ymouse: LOOP UNTIL lb = 0
  IF xmouse >= 56 AND xmouse <= 78 AND ymouse >= 48 AND ymouse <= 54 THEN
   IF currenttool <> box THEN
    currenttool = box
    GOSUB closetools: EXIT SUB
   END IF
  END IF
 END IF
 IF xmouse >= 56 AND xmouse <= 101 AND ymouse >= 64 AND ymouse <= 70 THEN
  DO: mousestatus lb, rb, xmouse, ymouse: LOOP UNTIL lb = 0
  IF xmouse >= 56 AND xmouse <= 86 AND ymouse >= 64 AND ymouse <= 70 THEN
   IF currenttool <> fbox THEN
    currenttool = fbox
    GOSUB closetools: EXIT SUB
   END IF
  END IF
 END IF
 IF xmouse >= 56 AND xmouse <= 101 AND ymouse >= 80 AND ymouse <= 86 THEN
  DO: mousestatus lb, rb, xmouse, ymouse: LOOP UNTIL lb = 0
  IF xmouse >= 56 AND xmouse <= 101 AND ymouse >= 80 AND ymouse <= 86 THEN
   IF currenttool <> circlet THEN
    currenttool = circlet
    GOSUB closetools: EXIT SUB
   END IF
  END IF
 END IF
 IF xmouse >= 56 AND xmouse <= 84 AND ymouse >= 96 AND ymouse <= 102 THEN
  DO: mousestatus lb, rb, xmouse, ymouse: LOOP UNTIL lb = 0
  IF xmouse >= 56 AND xmouse <= 85 AND ymouse >= 96 AND ymouse <= 102 THEN
   IF currenttool <> fill THEN
    currenttool = fill
    GOSUB closetools: EXIT SUB
   END IF
  END IF
 END IF
 IF xmouse >= 56 AND xmouse <= 86 AND ymouse >= 112 AND ymouse <= 118 THEN
  DO: mousestatus lb, rb, xmouse, ymouse: LOOP UNTIL lb = 0
  IF xmouse >= 56 AND xmouse <= 86 AND ymouse >= 112 AND ymouse <= 118 THEN
   IF currenttool <> pick THEN
    currenttool = pick
    GOSUB closetools: EXIT SUB
   END IF
  END IF
 END IF
 IF xmouse >= 56 AND xmouse <= 86 AND ymouse >= 128 AND ymouse <= 134 THEN
  DO: mousestatus lb, rb, xmouse, ymouse: LOOP UNTIL lb = 0
  IF xmouse >= 56 AND xmouse <= 86 AND ymouse >= 128 AND ymouse <= 134 THEN
   IF currenttool <> zoom THEN
    currenttool = zoom
    GOSUB closetools: EXIT SUB
   END IF
  END IF
 END IF
END IF

LOOP

closetools:
mousehide
PUT (50, 10), boxcover&, PSET
LOCATE 1, 8: COLOR 7: PRINT "Tools"
mouseshow
RETURN

END SUB

SUB waitforclick (x1, y1, x2, y2)

DO
 mousestatus lb, rb, xmouse, ymouse
 IF lb = -1 THEN
  IF xmouse >= x1 AND xmouse <= x2 AND ymouse >= y1 AND ymouse <= y2 THEN
   DO: mousestatus lb, rb, xmouse, ymouse: LOOP UNTIL lb = 0
   IF xmouse >= x1 AND xmouse <= x2 AND ymouse >= y1 AND ymouse <= y2 THEN
    EXIT SUB
   END IF
  END IF
 END IF
LOOP
END SUB

SUB ZoomMode (wx, wy)

mousehide
mouserange 0, 0, 638, 199

PUT (0, 0), scr&, PSET
GET (wx, wy)-(wx + 31, wy + 31), infocover&
CLS
LINE (232, 0)-(232, 199), 15

spal = 0
FOR y = 1 TO 26
FOR x = 1 TO 14
 LINE ((x * 6) + 230, (y * 6) + 7)-(((x * 6) + 4) + 230, ((y * 6) + 4) + 7), spal, BF
 LINE ((x * 6) + 229, (y * 6) + 6)-(((x * 6) + 4) + 231, ((y * 6) + 4) + 8), 8, B
 spal = spal + 1
 IF spal = 256 THEN GOTO exitp
NEXT x
NEXT y

exitp:

GOSUB chcolor
COLOR 15
LOCATE 18, 32: PRINT "Preview"
PUT (259, 150), infocover&, PSET

spx = 259
spy = 150
gridx = 18
gridy = 4

FOR y = 0 TO 31
 FOR x = 0 TO 31
  pointclr = POINT(spx + x, spy + y)
   LINE (gridx + (x * 6), gridy + (y * 6))-(gridx + 5 + (x * 6), gridy + 5 + (y * 6)), pointclr, BF
 NEXT x
NEXT y

mouseshow

DO
mousestatus lb, rb, xmouse, ymouse

IF rb THEN
 DO: mousestatus lb, rb, xmouse, ymouse: LOOP UNTIL rb = 0
 EXIT DO
END IF

IF lb THEN
 IF xmouse < 236 THEN GOTO notpal
 IF ymouse < 13 THEN GOTO notpal
 IF ymouse > 125 THEN GOTO notpal
 IF ymouse > 119 AND xmouse > 258 THEN GOTO notpal
 xm = xmouse - 229
 ym = ymouse - 12
 IF xm MOD 6 > 0 AND ym MOD 6 > 0 THEN
  IF xmouse <> oldcx OR ymouse <> oldcy THEN
   mousehide
   oldcx = 0: oldcy = 0
   ccolor = POINT(xmouse, ymouse)
   GOSUB chcolor
   mouseshow
   oldcx = xmouse: oldcy = ymouse
  END IF
 END IF

notpal:

 IF xmouse >= gridx AND ymouse >= gridy AND xmouse <= 209 AND ymouse <= 195 THEN
  IF xmouse <> oldcx OR ymouse <> oldcy THEN
   isfilesaved = 0
   plotx = xmouse: ploty = ymouse
   plotx = plotx - gridx: plotx = FIX(plotx / 6)
   ploty = ploty - gridy: ploty = FIX(ploty / 6)
   mousehide
   PSET (spx + plotx, spy + ploty), ccolor
   xcor = plotx * 6 + gridx: ycor = ploty * 6 + gridy
   LINE (xcor, ycor)-(xcor + 5, ycor + 5), ccolor, BF
   oldcx = xmouse: oldcy = ymouse
   mouseshow
  END IF
 END IF

END IF

LOOP

GET (spx, spy)-(spx + 31, spy + 31), infocover&
CLS : mousehide
PUT (0, 0), scr&, PSET
PUT (wx, wy), infocover&, PSET
GET (0, 0)-(319, 199), scr&
GET (0, infobar)-(319, infobar + 9), infocover&
mouseshow
EXIT SUB

chcolor:
z$ = LTRIM$(RTRIM$(STR$(ccolor)))

IF LEN(z$) = 1 THEN
 z$ = "  " + z$
ELSEIF LEN(z$) = 2 THEN
 z$ = " " + z$
END IF

COLOR 15: LOCATE 1, 31: PRINT z$;
LINE (270, 0)-(319, 6), ccolor, BF

RETURN

END SUB

