/******************************************************************************
 SCI Template Game
 By Brian Provinciano
 ******************************************************************************
 rm001.sc
 Contains the first room of your game. 
 ******************************************************************************/
(include "sci.sh")
(include "game.sh")
/******************************************************************************/
(script 1)
/******************************************************************************/
(use "main")
(use "controls")
(use "cycle")
(use "game")
(use "feature")
(use "obj")
(use "inv")
(use "door")
(use "jump")
(use "dpath")
/******************************************************************************/
(local
    LAMP_HAS_BULB
    SPEAKER_CUT
    FIRST_TIME_ON_CHAIR
    ON_CHAIR
    FOUND_KNIFE
)
/******************************************************************************/
(instance public rm001 of Rm
	(properties
		picture scriptNumber
		// Set up the rooms to go to/come from here
		north 0
		east 0
		south 0
		west 0
	)
	(method (init)
		// same in every script, starts things up
  		(super:init())
  		(self:setScript(RoomScript))
  		
  		// Check which room ego came from and position it
  		(switch(gPreviousRoomNumber)
            /******************************************************
             * Put the cases here for the rooms ego can come from *
             ******************************************************/ /*
            (case north
  				(send gEgo:
  					posn(210 110)
  					loop(2)
  				)
  			)*/
            // Set up ego's position if it hasn't come from any room
  			(default
  				(send gEgo:
  					posn(160 160)
  					loop(2)
  				)
  			)
  		)
		
		// Set up the ego
		SetUpEgo()		
		(send gEgo:
            init()
            observeControl(ctlCYAN)
        )

        /****************************************
         * Set up the room's music to play here *
         ****************************************/ /*
		(send gTheMusic:
			prevSignal(0)
			stop()
			number(scriptNumber)
			loop(-1)
			play()
		)*/

        /**************************************************
         * Add the rest of your initialization stuff here *
         **************************************************/
        = LAMP_HAS_BULB TRUE
        = SPEAKER_CUT  FALSE
        = FIRST_TIME_ON_CHAIR TRUE
        = ON_CHAIR FALSE
        = FOUND_KNIFE FALSE
        
        (send gEgo:get(INV_WINDOWS))

        (LightBulb:
            init()
            setCycle(Fwd)
        )
        (Speaker:
            init()
            ignoreActors(FALSE)
        )
    )
)
/******************************************************************************/
(instance RoomScript of Script
	(properties)
	(method (handleEvent pEvent)
        (super:handleEvent(pEvent))

        /*****************************************
         * Handle the possible said phrases here *
         *****************************************/
        (if(Said('look>'))
            (if(Said('/boxes'))
                (if(& (send gEgo:onControl()) (ctlFUCHSIA))
                    (if(not FOUND_KNIFE)
                        Print("You dig through the box to find a knife!")
                        (send gGame:changeScore(1))
                        = FOUND_KNIFE TRUE
                    )(else
                        Print("You found a knife in the box")
                    )
                )(else
                    Print("You see many boxes, all of which are securely sealed except for one.")
                )
            )(else
                (if(Said('/table'))
                    Print("There's nothing of any importance on the table.")
                )(else
                    (if(Said('/chair'))
                        Print("This is no time for sitting down, but you might want to consider heightening your strategy.")
                    )(else
                        (if(Said('/barrel'))
                            Print("The barrel looks pretty unsteady! I wouldn't open it if I were you!")
                        )(else
                            (if(Said('/can,paint,(paint<can)'))
                                Print("It paint can has paint all over it. One bad move and the locker will get some unneeded redecorating!")
                            )(else
                                (if(Said('/speaker'))
                                        Print("A top of the line super fantasitc MEGA-BLAST speaker! So fantastic, you wonder why you left it here to collect dust.")
                                )(else
                                    (if(Said('/bag,(garbage<bag)'))
                                        Print("The garbage bags look pretty old. Shouldn't they be in a waste dump?" )
                                    )(else
                                        (if(Said('/light,bulb'))
                                            (if(LAMP_HAS_BULB)
                                                Print("There's not much of a bulb left now")
                                            )(else
                                                Print("That's a fine looking light bulb. It looks obtainable.")
                                            )
                                        )(else
                                            (if(Said('/briefcase,suitcase,case'))
                                                    Print("That's a fine looking suit case. It seems to be locked as well though.")
                                            )(else
                                                (if(Said('[ /* , !* ]'))
                                                    Print("You are stuck in the Gnome Locker and must get out! "+
                                                        "You see some boxes, a lamp, a chair, a table, a speaker, "+
                                                        "and all of your other valuables.")
                                                )
                                            )
                                        )
                                    )
                                )
                            )
                        )
                    )
                )
            )
        )
        (if(Said('(climb<on),(stand<on),(go<on),(get,on)/chair'))
                (if(& (send gEgo:onControl()) (ctlCYAN))
                    // already on the chair
                    Print("You can't climb any further.")
                )(else
                    (if(& (send gEgo:onControl()) (ctlRED))
                        // at the chair
                        (if(FIRST_TIME_ON_CHAIR)
                            Print("Good idea! Think of what you can reach now!")
                            = FIRST_TIME_ON_CHAIR FALSE
                            (send gGame:changeScore(3))
                        )
                        = ON_CHAIR TRUE
                        (send gEgo: stopUpd() posn(142 94))
                    )(else
                        PrintNotCloseEnough()
                    )
                )
        )(else
            (if(Said('(climb<down),(climb<off),jump,((get,go)<off)'))
                (if(ON_CHAIR)
                    // already on the chair
                    = ON_CHAIR FALSE
                    (send gEgo: startUpd() posn(156 118))
                )(else
                    Print("Climb down from where?")
                )
            )
        )

        (if(Said('take>'))
            (if(Said('/boxes,box'))
                Print("What do you need the box for? It's fine here.")
            )(else
                (if(Said('/knife'))
                    (if(send gEgo:has(INV_KNIFE))
                        Print("You already have it!")
                    )(else
                        (if(& (send gEgo:onControl()) (ctlFUCHSIA))
                            Print("You pick up the knife, but how will it help you get out?")
                            (send gEgo:get(INV_KNIFE))
                            (send gGame:changeScore(4))
                        )(else
                            PrintNotCloseEnough()
                        )
                    )
                )(else
                    (if(Said('/table'))
                        Print("The table is much too heavy for you to carry around.")
                    )(else
                        (if(Said('/chair'))
                            Print("The chair is much too heavy for you to carry around. Maybe you can use it for something else.")
                        )(else
                            (if(Said('/barrel'))
                                Print("That's waaaay to heavy!")
                            )(else
                                (if(Said('/can,paint,(paint<can)'))
                                    Print("The only thing a paint can would do for you is riun your pocket protector!" )
                                )(else
                                    (if(Said('/speaker'))
                                        (if(send gEgo:has(INV_SPEAKER))
                                            Print("You already have it!")
                                        )(else
                                            (if(& (send gEgo:onControl()) (ctlYELLOW))
                                                Print("You pick up the speaker, but what good will it do you you without electricity?")
                                                (send gEgo:get(INV_SPEAKER))
                                                (Speaker:hide())
                                                (send gGame:changeScore(4))
                                            )(else
                                                PrintNotCloseEnough()
                                            )
                                        )
                                    )(else
                                        (if(Said('/bag,(garbage<bag)'))
                                            Print("The garbage bags are a little too smelly for the taking." )
                                        )(else
                                            (if(Said('/light,bulb'))
                                                (if(LAMP_HAS_BULB)
                                                    (if(ON_CHAIR)
                                                        Print("you remove the bulb, oooouch! and drop it. It sure isn't any good use to you now that it's broken!")
                                                        = LAMP_HAS_BULB FALSE
                                                        (LightBulb:
                                                            setLoop(1)
                                                            posn(132 120)
                                                        )
                                                        (send gGame:changeScore(4))
                                                    )(else
                                                        Print("Your arms aren't that long! You can't reach it from there! You might want to try standing on something.")
                                                    )
                                                )(else
                                                    Print("It's broken and useless! Plus, it's sharp! You might hurt yourself!")
                                                )
                                            )(else
                                                Print("You can't take that!")
                                            )
                                        )
                                    )
                                )
                            )
                        )
                    )
                )
            )
        )
        (if(Said('open>'))
            (if(Said('/bag,(garbage<bag)'))
                Print("The garbage smells pretty bad in the bags! Being stuck in this small room, you really wouldn't want to open them!")
            )(else
                (if(Said('/box'))
                    (if(& (send gEgo:onControl()) (ctlFUCHSIA))
			             Print("It already is open! It's an open box!")
                    )(else
			             Print("The boxes are so well sealed, not even a knife could open them!")
                    )
                )(else
                    (if(Said('/door'))
                            Print("The door is locked! Haven't you been paying attention?")
                    )(else
                        (if(Said('/speaker'))
                            Print("Open the speaker!? What are you talking about?")
                        )(else
                            (if(Said('/barrel'))
                                Print("Who knows what hazardous material could be in there. It wouldn't be safe to open.")
                            )
                        )
                    )
                )
            )
        )
        (if(Said('use>'))
            (if(Said('/knife>'))
                (if(send gEgo:has(INV_KNIFE))
                    (if(Said('//speaker'))
                        (if(send gEgo:has(INV_SPEAKER))
                            (if(not SPEAKER_CUT)
                                Print("You cut the cord on the speaker to reveal it's open wires.")
                                (send gGame:changeScore(4))
                                = SPEAKER_CUT TRUE
                            )(else
                                Print("You already cut the cord on the speaker.")
                            )
                        )(else
                           Print("You don't have the speaker!")
                        )
                    )(else
                        (if(Said('[ /* , !* ]'))
                            Print("You can't use the knife with that.")
                        )
                    )
                )(else
                    Print("You don't have the knife!")
                )
            )(else
                (if(Said('/speaker>'))
                    (if(send gEgo:has(INV_SPEAKER))
                    (if(Said('//light,lamp'))
                        (if(LAMP_HAS_BULB)
                            Print("You can't use the lamp while the bulb is still in it!")
                        )(else
                            (if(not SPEAKER_CUT)
                                Print("the plug won't fit!")
                            )(else
                                DoWinGame()
                            )
                        )
                    )(else
                        Print("You don't have the speaker!")
                    )
                    )(else
                       (if(Said('[ /* , !* ]'))
                            Print("You can't use the speaker with that.")
                        )
                    )
                )(else
                    (if(Said('/windows'))
                            Print("As incredible as it is, there's nothing you can do with it now!")
                    )(else
                        (if(Said('[ /* , !* ]'))
                            Print("There isn't anything to use it with!")
                        )
                    )
                )
            )
        )
 	)
    (method (changeState newState)
        = state newState
        (switch(state)
            (case 10
                = cycles 20
            )
            (case 11
				(send gRoom:newRoom(2))
            )
        )
    )
)
/******************************************************************************/
(instance LightBulb of Prop
  (properties
    y 61
    x 137
    view 12
  )
)
/******************************************************************************/
(instance Speaker of Prop
  (properties
    y 150
    x 222
    view 11
  )
)
/******************************************************************************/
(procedure (DoWinGame)
    Print("(Don't try this at home kids!)" #font LARGE_FONT)
    Print("You connect the speaker's open wires to the lamp. After "+
            "receiving the shock, the speakers begin to blair an earth "+
            "shattering sound!")
    ShakeScreen(3 ssFULL_SHAKE)
    Print("Wow! The sound from the speakers has shaken the door's lock enough to unlock it!")
    (send gGame:changeScore(8))
    ProgramControl()

    (send gEgo:
        startUpd()
        posn(156 118)
        setMotion(MoveTo 160 172)
    )
    (RoomScript:changeState(10))
)
/******************************************************************************/
