/******************************************************************************
 SCI Template Game
 By Brian Provinciano
 ******************************************************************************
 titlescreen.sc
 Contains the title screen room.
 ******************************************************************************/
(include "sci.sh")
(include "game.sh")
/******************************************************************************/
(script TITLESCREEN_SCRIPT)
/******************************************************************************/
(use "main")
(use "game")
(use "menubar")
(use "obj")
(use "cycle")
(use "user")
(use "controls")
(use "feature")
(use "rev")
(use "dpath")
(use "door")
(local
    magiColID = 0
    magiCol[4] = ( clBROWN clYELLOW clWHITE clSILVER)
    DRAW_AUTHOR = FALSE
    CAN_CONTINUE = FALSE
)
/******************************************************************************/
(instance public TitleScreen of Rm
	(properties
		picture 800
	)
	(method (init)
        // Set up the title screen
		ProgramControl()
		= gProgramControl FALSE
		(send gGame:setSpeed(1))
		(SL:disable())
		(TheMenuBar:hide())

		(super:init())
		(self:setScript(RoomScript))

		(send gEgo:
			init()
			hide()
		)

        /****************************************
         * Set up the room's music to play here *
         ****************************************/ /*
		(send gTheMusic:
			prevSignal(0)
			stop()
			number(scriptNumber)
			loop(-1)
			play()
		)       */

        /**************************************************
         * Add the rest of your initialization stuff here *
         **************************************************/

	)
    (method (doit)
        (super:doit())

        (if(DRAW_AUTHOR and (Title:isStopped))
            = magiColID ( & (+ magiColID 1) 3)
	       Display(
			"By Brian Provinciano"
			dsCOORD 176 181
			dsCOLOUR clBLACK
			dsBACKGROUND clTRANSPARENT
		  )
		  Display(
			"By Brian Provinciano"
			dsCOORD 175 180
			dsCOLOUR magiCol[magiColID]
			dsBACKGROUND clTRANSPARENT
		  )
        )
    )
)
/******************************************************************************/
(instance RoomScript of Script
	(properties)     /*
    (method (changeState newState)
        = state newState
        /************************************
         * Add the state related stuff here *
         ************************************/
    //)
	(method (handleEvent pEvent)
        (super:handleEvent(pEvent))
        (if( not (send pEvent:claimed) )
			(if( (== (send pEvent:type) evKEYBOARD) and (== (send pEvent:message) $3C00) )
				ToggleSound()
			)(else
                /******************************************
                 * If the title screen has music, fade it *
                 ******************************************/
				//(send gTheMusic:fade())

                // End the title screen, start the game
				(if(CAN_CONTINUE)
                    (send gRoom:newRoom(INITROOMS_SCRIPT))
                )
		    )
		)
	)
    (method (changeState newState)
        = state newState
        (switch(state)
            (case 0
		        (send gGame:setSpeed(8))
                = cycles 2
            )
            (case 1
                (Logo:
                    init()
                    setCycle(Fwd)
                )
                = cycles 4
            )
            (case 2
		          Display(
			         "Developed With SCI Studio 3"
			         dsCOORD 75 170
			         dsCOLOUR clSILVER
			         dsBACKGROUND clTRANSPARENT
		          )
		          Display(
			         "http://www.bripro.com"
			         dsCOORD 95 180
			         dsCOLOUR clSILVER
			         dsBACKGROUND clTRANSPARENT
		          )
                (Logo:
                    setCycle(NULL)
                )
                = cycles 4
            )
            (case 3
		          Display(
			         "Developed With SCI Studio 3"
			         dsCOORD 75 170
			         dsCOLOUR clGREY
			         dsBACKGROUND clTRANSPARENT
		          )
		          Display(
			         "http://www.bripro.com"
			         dsCOORD 95 180
			         dsCOLOUR clGREY
			         dsBACKGROUND clTRANSPARENT
		          )
                (Logo:
                    setCycle(Rev)
                )
                = cycles 4
            )
            (case 4
		        (send gGame:setSpeed(6))
                (TitleScreen:drawPic(800))
                (Logo:
                    hide()
                )
                = cycles 1
            )
            (case 5
                (Logo:dispose())
                (TitleScreen:drawPic(2))
                (LockerDoor:
                    doorState(DOOR_OPEN)
                    init()
                    setPri(0)
                )
		          (send gEgo:
			view(0)
		          loop(2)
		          posn(202 138)
			setStep(4 4)
			setMotion(MoveTo 202 138)
			setCycle(Walk)
			init()
   show()
		)

                Print(
                    "You are LockerGnome, the great master of the Gnome Locker, the safe where you store all your valuables."+
                    "After just getting your hands on a rare copy of Microsoft Windows 1.0, you are on your way to put it in "+
                    "the locker for safe keeping..."
                )
                (send gEgo:
                    setCycle(Walk)
                    setMotion(
                        DPath
                        160 130
                        160 58
                    )
                )
                = cycles 24
            )
            (case 6
                (send gEgo:hide())
                = cycles 1
            )
            (case 7
                (LockerDoor:close())
                = cycles 8
            )
            (case 8
                ShakeScreen(4  ssFULL_SHAKE)
                = cycles 1
            )
            (case 9
                Print(
                    "When suddenly the door closes! You find yourself stuck inside the super secure Gnome Locker! How on earth are you going to get out?"
                )
                (Title:
                    init()
                    setPri(15)
                    setStep(0 8)
                    setCycle(Fwd)
                    setMotion(MoveTo 160 170)
                )
                = DRAW_AUTHOR TRUE
                = cycles 8
            )
            (case 10
                = CAN_CONTINUE TRUE
            )
        )
    )
)
/******************************************************************************/
(instance Title of Act
  (properties
    y 0
    x 160
    view 8
  )
)
/******************************************************************************/
(instance LockerDoor of Door
  (properties
    y 104
    x 166
    view 10
  )
)
/******************************************************************************/
(instance Logo of Act
  (properties
    y 141
    x 160
    view 99
  )
)
/******************************************************************************/
