'**************************************************************************
'*                              DEEP BASIC
'*
'*     WRITTEN BY THOMAS MCBURNEY    (C) 2003
'*
'*     EMAIL: tommyinoz@yahoo.com
'*     WEB: www.zeta.org.au/~tommy
'*
'**************************************************************************

OPEN "CHESS.LOG" FOR OUTPUT AS #1
PRINT #1, DATE$; " ";
PRINT #1, TIME$
PRINT #1, " "
PRINT #1, "MOVE     TIME    SCORE DEPTH LINE"
CLOSE 1

'SIDE 0 = COMPUTER PLAYS BLACK
'SIDE 1 = COMPUTER PLAYS WHITE
SIDE% = 0
LOGGAME% = 1
FLIP% = 0

CLS

DIM P$(6), PIECE%(7, 16, 8, 2), CMOVES%(6, 130), HMOVES%(6, 130)
DIM BO%(8, 9), CB%(9, 9)
DIM ENGINE%(10, 130, 5), SCORE%(12, 2)
DIM PAWN%(8, 2), BESTL%(10, 12, 4), HISTORY%(4, 10)
DIM QENGINE%(15, 30, 5), QSCORE%(15, 2), QB%(8, 9)
DIM FIRSTPLY%(218)
DIM FIND$(10), QUERY$(9), dsc$(10), RECORD$(10)
DIM TAKEBACK%(5, 200)

' GRAPHICS
DIM Gpiece(0 TO 400) AS INTEGER
DIM blot(0 TO 400) AS INTEGER
DIM GraphicImage(0 TO 4800) AS INTEGER

SCREEN 9'12

'**** LOAD IMAGES OF PIECES
GOSUB LoadPieces

P$(1) = "P": P$(2) = "N": P$(3) = "B": P$(4) = "R": P$(5) = "Q": P$(6) = "K"

C$(1) = "A": C$(2) = "B": C$(3) = "C": C$(4) = "D": C$(5) = "E": C$(6) = "F": C$(7) = "G": C$(8) = "H"
CY$(1) = "8": CY$(2) = "7": CY$(3) = "6": CY$(4) = "5": CY$(5) = "4": CY$(6) = "3": CY$(7) = "2": CY$(8) = "1"

' PIECE VALUE
V%(1) = 100: V%(2) = 300: V%(3) = 305
V%(4) = 500: V%(5) = 900: V%(6) = 19000

MAXQDEPTH% = 4
LEVEL% = 10
MOVESPERHOUR% = 360

' *** KNIGHT
PIECE%(2, 1, 1, 1) = -1: PIECE%(2, 1, 1, 2) = -2
PIECE%(2, 2, 1, 1) = 1: PIECE%(2, 2, 1, 2) = -2
PIECE%(2, 3, 1, 1) = 2: PIECE%(2, 3, 1, 2) = -1
PIECE%(2, 4, 1, 1) = 2: PIECE%(2, 4, 1, 2) = 1
PIECE%(2, 5, 1, 1) = 1: PIECE%(2, 5, 1, 2) = 2
PIECE%(2, 6, 1, 1) = -1: PIECE%(2, 6, 1, 2) = 2
PIECE%(2, 7, 1, 1) = -2: PIECE%(2, 7, 1, 2) = 1
PIECE%(2, 8, 1, 1) = -2: PIECE%(2, 8, 1, 2) = -1

'*** BISHOP

FOR I = 1 TO 8
	PIECE%(3, 1, I, 1) = I * -1: PIECE%(3, 1, I, 2) = I * -1
	PIECE%(3, 2, I, 1) = I: PIECE%(3, 2, I, 2) = I * -1
	PIECE%(3, 3, I, 1) = I: PIECE%(3, 3, I, 2) = I
	PIECE%(3, 4, I, 1) = I * -1: PIECE%(3, 4, I, 2) = I
NEXT

' **** ROOK

FOR I = 1 TO 8
	PIECE%(4, 1, I, 1) = 0: PIECE%(4, 1, I, 2) = I * -1
	PIECE%(4, 2, I, 1) = I: PIECE%(4, 2, I, 2) = 0
	PIECE%(4, 3, I, 1) = 0: PIECE%(4, 3, I, 2) = I
	PIECE%(4, 4, I, 1) = I * -1: PIECE%(4, 4, I, 2) = 0
NEXT
  
' **** QUEEN
FOR D = 1 TO 4
	FOR I = 1 TO 8
		PIECE%(5, D, I, 1) = PIECE%(3, D, I, 1): PIECE%(5, D, I, 2) = PIECE%(3, D, I, 2)
	NEXT
NEXT

FOR D = 1 TO 4
	FOR I = 1 TO 8
		PIECE%(5, D + 4, I, 1) = PIECE%(4, D, I, 1): PIECE%(5, D + 4, I, 2) = PIECE%(4, D, I, 2)
	NEXT
NEXT

' **** KING
FOR I = 1 TO 8
	PIECE%(6, I, 1, 1) = PIECE%(5, I, 1, 1): PIECE%(6, I, 1, 2) = PIECE%(5, I, 1, 2)
NEXT

' ***** SUPER PIECE

FOR D = 1 TO 8
	FOR S = 1 TO 8
		PIECE%(7, D, S, 1) = PIECE%(5, D, S, 1): PIECE%(7, D, S, 2) = PIECE%(5, D, S, 2)
	NEXT
NEXT
FOR D = 1 TO 8
	PIECE%(7, D + 8, 1, 1) = PIECE%(2, D, 1, 1): PIECE%(7, D + 8, 1, 2) = PIECE%(2, D, 1, 2)
NEXT





START:
'************************** START **************************************

COLOR 7
FOR I = 5 TO 20: LOCATE I, 52: PRINT "                        ": NEXT

GOSUB INITBOARD
MOVE% = 0
SIDE% = 0
TOTALTIME = 0
CMOVES% = 0
GOSUB COPYBOARD
GOSUB ENCODEBOARD
STARTPOS$ = BOARD$
TAKEBACK%(0, 0) = 0

MAIN:
GOSUB DRAWBOARD

DO
	SOUND 1500, 2

	GOSUB COPYBOARD
	GOSUB GAMESTATUS
	IF GAMEOVER = 1 THEN EXIT DO
  
	RANDOMIZE TIMER
 
	'######## TEST CODE ########
	'T$ = TIME$
	'C = 0
	'DO
	'   C = C + 1
	'   GOSUB CMOVELIST
	'   IF T$ <> TIME$ THEN PRINT C: C = 0: T$ = TIME$
	'LOOP

	'GOSUB CMOVELIST
	'PRINT "CMOVES----"
	'FOR I = 1 TO CMOVES%(0, 0)
	'   IF CMOVES%(5, I) > 0 THEN
	'      PRINT I; "..";
	'      A$ = "-"
	'      IF CMOVES%(5, I) <> 0 THEN A$ = "X"
	'      PRINT C$(CMOVES%(1, I)) + CY$(CMOVES%(2, I)) + A$;
	'      PRINT C$(CMOVES%(3, I)) + CY$(CMOVES%(4, I)); "("; CMOVES%(6, I); ")  CAPTURE="; CMOVES%(5, I)
	'   END IF
	'NEXT

	M% = 0: OKTHINK% = 1
	IF AUTO% = 0 THEN GOSUB USERINPUT
	IF W$ = "FEN" OR W$ = "BACK" THEN OKTHINK% = 0

	IF AUTO% = 1 THEN
		SIDE% = SIDE% + 1
		IF SIDE% = 2 THEN SIDE% = 0
	END IF
  
	IF OKTHINK% = 1 THEN
		IF SIDE% = 0 THEN GOSUB HMAKEMOVE
		IF SIDE% = 1 THEN GOSUB CMAKEMOVE
		IF M% > 0 THEN GOSUB RECORDMOVE
		MOVE% = MOVE% + 1

		IF LOGGAME% = 1 THEN
			OPEN "CHESS.LOG" FOR APPEND AS #1
				PRINT #1, " "
				PRINT #1, USING "###"; MOVE%;
				PRINT #1, ". ";
				IF SIDE% = 1 THEN PRINT #1, " ... ";
				PRINT #1, C$(X%); CY$(Y%); C$(XX%); CY$(YY%)
				PRINT #1, " "
			CLOSE 1
		END IF
	  
		GOSUB COPYCB2BO
		GOSUB DRAWBOARD
	  
		GOSUB GAMESTATUS
		IF GAMEOVER = 1 THEN EXIT DO
		
		GOSUB THINK
	END IF
LOOP

DO
	A$ = INKEY$
	IF A$ <> "" THEN EXIT DO
LOOP


'**********************************************************************
END


SELECTPROMOTION:
'********** USER SELECTS WHICH PIECE TO PROMOTE PAWN TO. *********
FOR I = 5 TO 20: LOCATE I, 52: PRINT "                        ": NEXT
LOCATE 15, 56: PRINT "Promote pawn to..."
LOCATE 16, 56: PRINT "Q,R,B or N:"
DO
	X% = 68: Y% = 16: L% = 1: GOSUB INTAKE
	IF W$ = "Q" THEN PAWNPROMOTE% = 6: EXIT DO
	IF W$ = "R" THEN PAWNPROMOTE% = 5: EXIT DO
	IF W$ = "B" THEN PAWNPROMOTE% = 4: EXIT DO
	IF W$ = "N" THEN PAWNPROMOTE% = 3: EXIT DO
	SOUND 700, 2
LOOP
FOR I = 5 TO 20: LOCATE I, 52: PRINT "                        ": NEXT

RETURN


FENIN:
'***** LOADS FEN POSITION FROM THE FEN.IN FILE **************
FEN$ = ""
OPEN "FEN.IN" FOR INPUT AS #1
DO
	IF EOF(1) = -1 THEN EXIT DO
	INPUT #1, A$
	IF LEN(A$) > LEN(FEN$) THEN FEN$ = A$
LOOP
 
L% = LEN(FEN$)
A% = 0
X% = 0
Y% = 1

DO
	A% = A% + 1
	IF A% > L% THEN EXIT DO
	
	P% = 0
	A$ = MID$(FEN$, A%, 1)

  
	IF A$ = "/" THEN X% = 0: Y% = Y% + 1
  
	IF X% > 7 THEN X% = 0: Y% = Y% + 1
	IF Y% > 8 THEN EXIT DO
  
	IF VAL(A$) > 0 AND VAL(A$) < 9 THEN
		FOR I = 1 TO VAL(A$)
			X% = X% + 1
			IF X% < 9 THEN CB%(X%, Y%) = 0
		NEXT
	END IF


	IF A$ = "p" THEN P% = -1
	IF A$ = "n" THEN P% = -2
	IF A$ = "b" THEN P% = -3
	IF A$ = "r" THEN P% = -4
	IF A$ = "q" THEN P% = -5
	IF A$ = "k" THEN P% = -6
	IF A$ = "P" THEN P% = 1
	IF A$ = "N" THEN P% = 2
	IF A$ = "B" THEN P% = 3
	IF A$ = "R" THEN P% = 4
	IF A$ = "Q" THEN P% = 5
	IF A$ = "K" THEN P% = 6

	IF P% <> 0 THEN X% = X% + 1: CB%(X%, Y%) = P%

	
LOOP
  
SIDE% = 0
DO
	A% = A% + 1
	IF A% > L% THEN EXIT DO
  
	A$ = UCASE$(MID$(FEN$, A%, 1))
	IF A$ = "B" THEN SIDE% = 1: EXIT DO
LOOP

CLOSE 1
GOSUB COPYCB2BO
GOSUB DRAWBOARD
GOSUB ENCODEBOARD
STARTPOS$ = BOARD$
TAKEBACK%(0, 0) = 0
RETURN


GAMESTATUS:
'****** CHECK TO SEE IF GAME IS IN CHECK, CHECKMATE OR STALEMATE

GOSUB FINDKINGS
GOSUB CMOVELIST
GOSUB HMOVELIST
GOSUB CKINGCHECK
GOSUB HKINGCHECK

GAMEOVER = 0
MESSAGE$ = ""
  
IF CCHECK% = 1 AND CMOVES%(0, 0) = 0 THEN MESSAGE$ = "CHECKMATE!": GAMEOVER = 1
IF CCHECK% = 0 AND CMOVES%(0, 0) = 0 THEN MESSAGE$ = "STALEMATE!": GAMEOVER = 0
IF CCHECK% = 1 AND CMOVES%(0, 0) > 0 THEN MESSAGE$ = "CHECK!"
 
IF HCHECK% = 1 AND HMOVES%(0, 0) = 0 THEN MESSAGE$ = "CHECKMATE!": GAMEOVER = 1
IF HCHECK% = 0 AND HMOVES%(0, 0) = 0 THEN MESSAGE$ = "STALEMATE!": GAMEOVER = 0
IF HCHECK% = 1 AND HMOVES%(0, 0) > 0 THEN MESSAGE$ = "CHECK!"
COLOR 10
LOCATE 7, 58: PRINT MESSAGE$
IF MESSAGE$ = "CHECK!" THEN SOUND 1000, 2: SOUND 800, 2: SOUND 1000, 2
IF MESSAGE$ = "CHECKMATE!" THEN
	FOR I = 100 TO 2000 STEP 100
		SOUND I, 1
	NEXT
END IF
RETURN

PERFMTEST:
'************** PERFORMANCE TEST *****************
FOR TY% = 1 TO 8
	FOR TX% = 1 TO 8
		BO%(TX%, TY%) = 0
	NEXT
NEXT

'################# mate in 2 moves
BO%(2, 1) = -6: BO%(7, 1) = -3
BO%(1, 2) = -1: BO%(2, 2) = -1
BO%(1, 6) = -5: BO%(7, 2) = -1
BO%(8, 2) = -1: BO%(3, 3) = -4
BO%(5, 4) = -1: BO%(4, 5) = -1
BO%(3, 6) = -1: BO%(7, 5) = 1
BO%(8, 5) = 1
BO%(2, 6) = 1: BO%(4, 6) = 1
BO%(6, 6) = 1: BO%(1, 7) = 1
BO%(3, 7) = 1: BO%(5, 7) = 2
BO%(6, 7) = 5: BO%(1, 8) = 6
BO%(2, 8) = 4

GOSUB COPYBOARD
GOSUB DRAWBOARD

NODES = 0
TESTMODE% = 1
OLDLEVEL = LEVEL%
LEVEL% = 32000
STARTTEST = TIMER
GOSUB THINK
FINISHTEST = TIMER
SOUND 1400, 2
LEVEL% = OLDLEVEL
TESTMODE% = 0

FOR I = 7 TO 20: LOCATE I, 52: PRINT "                        ": NEXT

COLOR 11
LOCATE 7, 55: PRINT " TIME = ";
PRINT USING "###.##"; (FINISHTEST - STARTTEST)
COLOR 12
NPS = INT(NODES / (FINISHTEST - STARTTEST))
LOCATE 9, 56: PRINT "NPS="; NPS
COLOR 13
LOCATE 11, 56: PRINT "BENCH MARK="; INT((NPS / 3086) * 100); "%"
COLOR 9
LOCATE 13, 56: PRINT "NODES="; NODES


COLOR 10
LOCATE 18, 56: PRINT "PRESS ANY KEY"
DO
	A$ = INKEY$
	IF A$ <> "" THEN EXIT DO
LOOP

FOR I = 7 TO 20: LOCATE I, 52: PRINT "                       ": NEXT

RETURN



BOOK:
'*******  OPENING BOOK SEARCH
FOR I = 5 TO 20: LOCATE I, 52: PRINT "                      ": NEXT
FOUND = 0

GOSUB ENCODEBOARD
IF SIDE% = 0 THEN FIND$(1) = "B" + BOARD$
IF SIDE% = 1 THEN FIND$(1) = "W" + BOARD$

GOSUB GETREC
IF RECORD = 0 THEN RETURN

COLOR 10
LOCATE 5, 57: PRINT "OPENING BOOK"
X1 = VAL(RECORD$(2))
Y1 = VAL(RECORD$(3))
X2 = VAL(RECORD$(4))
Y2 = VAL(RECORD$(5))
FOUND = FOUND + 1
COLOR 11
LOCATE 6 + FOUND, 58: PRINT FOUND; "- "; C$(X1); CY$(Y1); C$(X2); CY$(Y2)

DO
	GOSUB NEXTREC
	IF RECORD = 0 THEN EXIT DO
	FOUND = FOUND + 1
	X1 = VAL(RECORD$(2))
	Y1 = VAL(RECORD$(3))
	X2 = VAL(RECORD$(4))
	Y2 = VAL(RECORD$(5))
	LOCATE 6 + FOUND, 58: PRINT FOUND; "- "; C$(X1); CY$(Y1); C$(X2); CY$(Y2)
LOOP

RANDOMIZE TIMER
PICK = INT(RND(1) * FOUND) + 1
'PRINT PICK
FOUND = 0

GOSUB GETREC
FOUND = FOUND + 1
IF FOUND = PICK THEN
	X% = VAL(RECORD$(2))
	Y% = VAL(RECORD$(3))
	XX% = VAL(RECORD$(4))
	YY% = VAL(RECORD$(5))
	SPECIAL% = VAL(RECORD$(6))
	RETURN
END IF

DO
	GOSUB NEXTREC
	IF RECORD = 0 THEN EXIT DO
	FOUND = FOUND + 1
	IF FOUND = PICK THEN
		X% = VAL(RECORD$(2))
		Y% = VAL(RECORD$(3))
		XX% = VAL(RECORD$(4))
		YY% = VAL(RECORD$(5))
		SPECIAL% = VAL(RECORD$(6))
		RETURN
	END IF
LOOP


PRINT "I'M NOT SUPPOSED TO STOP HERE!!!"
END

ENCODEBOARD:
'***** ENCODE CURRENT BOARD INTO A STRING
BOARD$ = ""
FOR Y% = 1 TO 8
	FOR X% = 1 TO 8
		P% = CB%(X%, Y%)
		IF P% = 1 THEN P$ = "P"
		IF P% = 2 THEN P$ = "N"
		IF P% = 3 THEN P$ = "B"
		IF P% = 4 THEN P$ = "R"
		IF P% = 5 THEN P$ = "Q"
		IF P% = 6 THEN P$ = "K"
		IF P% = -1 THEN P$ = "p"
		IF P% = -2 THEN P$ = "n"
		IF P% = -3 THEN P$ = "b"
		IF P% = -4 THEN P$ = "r"
		IF P% = -5 THEN P$ = "q"
		IF P% = -6 THEN P$ = "k"
		IF P% = 0 THEN P$ = "."
		BOARD$ = BOARD$ + P$
	NEXT
NEXT
RETURN




USERINPUT:
'****** USER INTERFACE *************
COLOR 7
LOCATE 23, 55: PRINT "                    "
LOCATE 23, 55: PRINT "YOUR MOVE:"

X% = 66: Y% = 23: L% = 4: GOSUB INTAKE
M% = 0

IF W$ = "QUIT" THEN END

IF W$ = "TEST" THEN
	GOSUB PERFMTEST
	GOSUB HMOVELIST
	GOTO USERINPUT
END IF

IF W$ = "FEN" THEN
	GOSUB FENIN
	RETURN
END IF

IF W$ = "BACK" THEN
	GOSUB TAKEBACK
	RETURN
END IF

IF W$ = "SWAP" OR W$ = "GO" THEN
	IF SIDE% = 0 THEN SIDE% = 1: RETURN
	IF SIDE% = 1 THEN SIDE% = 0: RETURN
END IF

IF W$ = "NEW" THEN SIDE% = 0: GOTO START

IF W$ = "FLIP" THEN
	FLIP% = FLIP% + 1
	IF FLIP% = 2 THEN FLIP% = 0
	GOSUB DRAWBOARD
	OKTHINK% = 0
	RETURN
END IF

IF W$ = "AUTO" THEN
	AUTO% = AUTO% + 1
	IF AUTO% = 2 THEN AUTO% = 0
	RETURN
END IF

IF W$ = "TIME" THEN
	FOR I = 5 TO 20: LOCATE I, 52: PRINT "                        ": NEXT
	LOCATE 15, 56: PRINT "PLEASE ENTER AVERAGE"
	LOCATE 16, 56: PRINT "RESPONSE TIME:"
	DO
		X% = 57: Y% = 17: L% = 5: GOSUB INTAKE
		T = VAL(W$)
		IF T < 32001 AND T >= 0 THEN LEVEL% = T: EXIT DO
		SOUND 700, 2
	LOOP
	FOR I = 5 TO 20: LOCATE I, 52: PRINT "                        ": NEXT
	OKTHINK% = 0
	IF LEVEL% = 0 THEN RETURN
	MOVESPERHOUR% = 3600 / LEVEL%
	RETURN
END IF


X1 = 0: Y1 = 0
IF LEN(W$) = 4 THEN
	X1$ = MID$(W$, 1, 1)
	Y1$ = MID$(W$, 2, 1)
	X2$ = MID$(W$, 3, 1)
	Y2$ = MID$(W$, 4, 1)
	X1 = ASC(X1$) - 64
	Y1 = 9 - VAL(Y1$)
	X2 = ASC(X2$) - 64
	Y2 = 9 - VAL(Y2$)
	'PRINT X1; Y1; X2; Y2
END IF

PAWNPROMOTE% = 0
IF X1 > 0 AND X1 < 9 AND X2 > 0 AND X2 < 9 THEN
	IF Y1 > 0 AND Y1 < 9 AND Y2 > 0 AND Y2 < 9 THEN
		IF SIDE% = 0 AND Y1 = 2 AND CB%(X1, Y1) = 1 AND Y2 = 1 THEN
			GOSUB SELECTPROMOTION
		END IF
		IF SIDE% = 1 AND Y1 = 7 AND CB%(X1, Y1) = -1 AND Y2 = 8 THEN
			GOSUB SELECTPROMOTION
		END IF
	END IF
END IF

IF SIDE% = 0 THEN
	FOR I = 1 TO HMOVES%(0, 0)
		A% = 0
		IF HMOVES%(1, I) = X1 THEN A% = A% + 1
		IF HMOVES%(2, I) = Y1 THEN A% = A% + 1
		IF HMOVES%(3, I) = X2 THEN A% = A% + 1
		IF HMOVES%(4, I) = Y2 THEN A% = A% + 1
		IF PAWNPROMOTE% <> 0 THEN
			IF HMOVES%(6, I) = PAWNPROMOTE% THEN A% = A% + 1
		END IF
	  
		IF PAWNPROMOTE% <> 0 THEN
			IF A% = 5 THEN M% = I
		END IF
		IF PAWNPROMOTE% = 0 THEN
			IF A% = 4 THEN M% = I
		END IF
	NEXT
END IF

IF SIDE% = 1 THEN
	FOR I = 1 TO CMOVES%(0, 0)
		A% = 0
		IF CMOVES%(1, I) = X1 THEN A% = A% + 1
		IF CMOVES%(2, I) = Y1 THEN A% = A% + 1
		IF CMOVES%(3, I) = X2 THEN A% = A% + 1
		IF CMOVES%(4, I) = Y2 THEN A% = A% + 1
		IF PAWNPROMOTE% <> 0 THEN
			IF CMOVES%(6, I) = PAWNPROMOTE% THEN A% = A% + 1
		END IF

		IF PAWNPROMOTE% <> 0 THEN
			IF A% = 5 THEN M% = I
		END IF
		IF PAWNPROMOTE% = 0 THEN
			IF A% = 4 THEN M% = I
		END IF
	NEXT
END IF

IF M% = 0 THEN SOUND 500, 5: GOTO USERINPUT


RETURN


QCOPYQB2CB:
'********** COPY CB% TO QUIESCENCE BOARD (QB%) ********
FOR QY% = 1 TO 9
	FOR QX% = 1 TO 8
		CB%(QX%, QY%) = QB%(QX%, QY%)
	NEXT
NEXT
RETURN


QCOPYBOARD:
'********** COPY CB% TO QUIESCENCE BOARD (QB%) ********
FOR QY% = 1 TO 9
	FOR QX% = 1 TO 8
		IF QB%(QX%, QY%) <> CB%(QX%, QY%) THEN
			QB%(QX%, QY%) = CB%(QX%, QY%)
		END IF
	NEXT
NEXT
RETURN

QUIESCENCE:
'************ QUIESCENCE SEARCH ****************

GOSUB QCOPYBOARD

FOR A% = 1 TO 15
	QENGINE%(A%, 1, 0) = 0
	QSCORE%(A%, 1) = 0
	QSCORE%(A%, 2) = 0
NEXT

GOSUB EVALBOARD
STANDPAT% = EVAL%

'***** FIND THE KINGS AND STORE THEIR LOCATION
QCKX% = CKX%
QCKY% = CKY%
QHKY% = HKY%
QHKX% = HKX%

EXTRAPLY% = 0
IF DEPTH% = 1 THEN EXTRAPLY% = 10 - MAXQDEPTH%
IF DEPTH% = 2 THEN EXTRAPLY% = 8 - MAXQDEPTH%




' ***** DISPLAY MOVES MADE BEFORE QUIESCENCE WAS CALLED *********
'LOCATE 8, 60: PRINT "AFTER:"
'FOR I = 1 TO PLY%
'   LOCATE 8 + I, 60
'      PRINT C$(ENGINE%(I, ENGINE%(I, 1, 0), 1));
'      PRINT CY$(ENGINE%(I, ENGINE%(I, 1, 0), 2));
'      PRINT C$(ENGINE%(I, ENGINE%(I, 1, 0), 3));
'      PRINT CY$(ENGINE%(I, ENGINE%(I, 1, 0), 4))
'NEXT

QFORCED% = 0

QWHOSTURN% = 1
IF (PLY% + 1 + SIDE%) / 2 = INT((PLY% + 1 + SIDE%) / 2) THEN QWHOSTURN% = 2

IF QWHOSTURN% = 2 THEN
	GOSUB HKINGCHECK
	IF HCHECK% = 1 THEN QFORCED% = 1
END IF

IF QWHOSTURN% = 1 THEN
	GOSUB CKINGCHECK
	IF CCHECK% = 1 THEN QFORCED% = 1
END IF



DO

	QPLY% = 0
	IF QENGINE%(1, 1, 0) > QENGINE%(1, 0, 0) THEN EXIT DO
 
	DO
		QPLY% = QPLY% + 1
	 
		IF QPLY% = 1 THEN
			GOSUB QCOPYQB2CB
			CKY% = QCKY%
			CKX% = QCKX%
			HKX% = QHKX%
			HKY% = QHKY%
		END IF


		QWHOSTURN% = 1
		IF (PLY% + QPLY% + SIDE%) / 2 = INT((PLY% + QPLY% + SIDE%) / 2) THEN QWHOSTURN% = 2

		'****** GET MOVE LIST IF REQUIRED ******
		IF QENGINE%(QPLY%, 1, 0) = 0 THEN
			IF QWHOSTURN% = 1 THEN
				GOSUB CMOVELIST
				IF CMOVES%(0, 0) = 0 THEN
					GOSUB CKINGCHECK
					MATEC% = 2
					IF CCHECK% = 1 THEN MATEC% = 1
				END IF
				GOSUB QMOVEORDER
			END IF
			IF QWHOSTURN% = 2 THEN
				GOSUB HMOVELIST
				IF HMOVES%(0, 0) = 0 THEN
					GOSUB HKINGCHECK
					MATEH% = 2
					IF HCHECK% = 1 THEN MATEH% = 1
				END IF
				GOSUB QMOVEORDER
			END IF
		END IF

	  
		QPOINTER% = QENGINE%(QPLY%, 1, 0)
		IF QPOINTER% < QENGINE%(QPLY%, 0, 0) + 1 THEN
			X% = QENGINE%(QPLY%, QPOINTER%, 1)
			Y% = QENGINE%(QPLY%, QPOINTER%, 2)
			XX% = QENGINE%(QPLY%, QPOINTER%, 3)
			YY% = QENGINE%(QPLY%, QPOINTER%, 4)
			SPECIAL% = QENGINE%(QPLY%, QPOINTER%, 5)
			GOSUB MAKEMOVE
		END IF

		ENDOFTREE% = 0
		IF QENGINE%(QPLY%, 1, 0) = 0 OR QPLY% = MAXQDEPTH% + EXTRAPLY% THEN
			QPLY% = QPLY% - 1
			GOSUB EVALBOARD
			GOSUB QABPRUNE
			GOSUB QSCOREIT
			ENDOFTREE% = 1
		END IF

		'################### TEST CODE ############################
		'IF PLY% = DEPTH% THEN
		'   LOCATE 3, 30: PRINT "WHO'S TURN="; QWHOSTURN%
		'   LOCATE 4, 30: PRINT "CAPTURES="; QENGINE%(QPLY%, 0, 0)
		'   LOCATE 5, 30: PRINT "PLY="; QPLY%
		'   LOCATE 6, 30: PRINT "MOVE="; QENGINE%(PLY%, 1, 0); "OUT OF "; QENGINE%(PLY%, 0, 0)
		'   LOCATE 7, 30: PRINT "EVAL="; EVAL% / 100; "   "
		'   GOSUB DRAWCBBOARD
		'   LOCATE 24, 1: PRINT SPACE$(70)
		'   LOCATE 24, 1 + (QPLY% * 6): PRINT "****"
		'
		'   FOR I = 1 TO 5: LOCATE 24 + I, 10: PRINT SPACE$(70): NEXT
		'
		'
		'   FOR A% = 1 TO QPLY%
		'      LOCATE 25, 1 + (A% * 6): PRINT QSCORE%(A%, 1); ": "
		'      LOCATE 26, 1 + (A% * 6): PRINT QSCORE%(A%, 2); " "
		'      LOCATE 27, 1 + (A% * 6): PRINT QENGINE%(A%, 1, 0)
		'      LOCATE 28, 1 + (A% * 6): PRINT QENGINE%(A%, 0, 0)
		'   NEXT
		'   DO
		'      A$ = INKEY$
		'     IF A$ <> "" THEN EXIT DO
		'  LOOP
		'END IF
	  
	  
	  
		IF ENDOFTREE% = 1 THEN EXIT DO
	LOOP

	IF QPLY% < 1 THEN QPLY% = 1
	QENGINE%(QPLY%, 1, 0) = QENGINE%(QPLY%, 1, 0) + 1

	IF QPLY% > 1 THEN
		FOR A% = QPLY% TO 2 STEP -1
			IF QENGINE%(A%, 1, 0) > QENGINE%(A%, 0, 0) THEN
				QENGINE%(A% - 1, 1, 0) = QENGINE%(A% - 1, 1, 0) + 1
				QENGINE%(A%, 1, 0) = 0: QENGINE%(A%, 0, 0) = 0
				'IF A% = 2 THEN LOCATE 3, 30: PRINT ENGINE%(1, 1, 0); " OUT OF "; ENGINE%(1, 0, 0)
			END IF
		NEXT
	END IF
LOOP

GOSUB QCOPYQB2CB

QWHOSTURN% = 1
IF (PLY% + 1) / 2 = INT((PLY% + 1) / 2) THEN QWHOSTURN% = 2

IF QWHOSTURN% = 1 AND QSCORE%(1, 1) >= STANDPAT% THEN EVAL% = QSCORE%(1, 1)
IF QWHOSTURN% = 1 AND QSCORE%(1, 1) < STANDPAT% THEN EVAL% = STANDPAT%
IF QWHOSTURN% = 2 AND QSCORE%(1, 1) <= STANDPAT% THEN EVAL% = QSCORE%(1, 1)
IF QWHOSTURN% = 2 AND QSCORE%(1, 1) > STANDPAT% THEN EVAL% = STANDPAT%

IF QFORCED% = 1 THEN EVAL% = QSCORE%(1, 1)

'IF EVAL% > 17999 THEN EVAL% = 17000   ' DO NOT RETURN A MATE SCORE

'####################### TEST CODE ###################################
'LOCATE 15, 30: PRINT "RETURNED SCORE="; EVAL%
'LOCATE 16, 30: PRINT "STAND PAT="; STANDPAT%
'IF ENGINE%(1, 1, 0) > 1 THEN
'   LOCATE 14, 30: PRINT "SCORE TO BEAT="; SCORE%(1, 1)
'END IF
'SOUND 1000, 5
'DO
'   A$ = INKEY$
'  IF A$ <> "" THEN EXIT DO
'LOOP
'LOCATE 15, 30: PRINT SPACE$(30)
'LOCATE 16, 30: PRINT SPACE$(30)
'
'QSEARCH = QSEARCH + 1
'OPEN "CHESS.LOG" FOR APPEND AS #1
'PRINT #1, QSEARCH; ". ";
'FOR I = 1 TO PLY%
'   PRINT #1, C$(ENGINE%(I, ENGINE%(I, 1, 0), 1));
'   PRINT #1, CY$(ENGINE%(I, ENGINE%(I, 1, 0), 2));
'   PRINT #1, C$(ENGINE%(I, ENGINE%(I, 1, 0), 3));
'   PRINT #1, CY$(ENGINE%(I, ENGINE%(I, 1, 0), 4)); ", ";
'NEXT
'PRINT #1, " "
'PRINT #1, "QSEARCH SCORE="; QSCORE%(1, 1)
'PRINT #1, "STAND PAT SCORE="; STANDPAT%
'PRINT #1, "RETURNED SCORE="; EVAL%
'PRINT #1, "  "
'CLOSE 1




RETURN


QMOVEORDER:
' *** COPY MOVE LIST TO ENGINE THEN ORDER THEM ******

IF QWHOSTURN% = 1 THEN
	A% = 0: AA% = 0
	DO
		A% = A% + 1
		IF A% > CMOVES%(0, 0) THEN EXIT DO

		IF CMOVES%(5, A%) > 0 OR CMOVES%(0, 0) = 1 OR CMOVES%(6, A%) = 6 THEN
			QX% = CMOVES%(1, A%)
			QY% = CMOVES%(2, A%)
			QXX% = CMOVES%(3, A%)
			QYY% = CMOVES%(4, A%)
			QP% = CB%(QX%, QY%)
			TEMP1% = CKX%
			TEMP2% = CKY%
			CKX% = QXX%
			CKY% = QYY%
			GOSUB CKINGCHECK
			CKX% = TEMP1%
			CKY% = TEMP2%

			TEMP1% = HKX%
			TEMP2% = HKY%
			TEMP3% = CB%(QX%, QY%)
			CB%(QX%, QY%) = 0
			HKX% = QXX%
			HKY% = QYY%
			GOSUB HKINGCHECK
			CB%(QX%, QY%) = TEMP3%
			HKX% = TEMP1%
			HKY% = TEMP2%


			CAPTURE% = 1
			'***** IF PIECE BEING CATURED IS LOWER VALUED AND IS BEING PROTECTED THEN DO NOT CAPTURE IT.
			IF V%(ABS(QP%)) > V%(CMOVES%(5, A%)) AND CCHECK% = 1 THEN CAPTURE% = 0
		  
			'**** IF PIECE BEING CAPTURED IS BEING ATTACKED BY FRIENDLY PIECE THEN PERFORM CAPTURE ONLY FOR FIRST 2 PLYS
			IF HCHECK% = 1 AND QPLY% < 3 THEN CAPTURE% = 1

			IF AA% > 1 THEN
				QTHISCAPTURE% = V%(CMOVES%(5, A%)) - V%(ABS(QP%))
				IF QTHISCAPTURE% < QCAPTURESCORE% THEN CAPTURE% = 0
			END IF

			'**** IF THERE IS ONLY ONE POSSIBLE MOVE THEN MAKE IT.
			IF CMOVES%(0, 0) = 1 THEN CAPTURE% = 1
		  
		  
			'*** IF PAWN PROMOTION THEN PERFORM PROMOTION.
			IF CMOVES%(6, A%) = 6 THEN CAPTURE% = 1

			IF CAPTURE% = 1 THEN
				AA% = AA% + 1
				QENGINE%(QPLY%, AA%, 1) = CMOVES%(1, A%)
				QENGINE%(QPLY%, AA%, 2) = CMOVES%(2, A%)
				QENGINE%(QPLY%, AA%, 3) = CMOVES%(3, A%)
				QENGINE%(QPLY%, AA%, 4) = CMOVES%(4, A%)
				QENGINE%(QPLY%, AA%, 5) = CMOVES%(6, A%)
				QCAPTURESCORE% = V%(CMOVES%(5, A%)) - V%(ABS(QP%))
			END IF
		END IF
	LOOP
	
	QENGINE%(QPLY%, 0, 0) = AA%
	IF AA% > 0 THEN QENGINE%(QPLY%, 1, 0) = 1
END IF

IF QWHOSTURN% = 2 THEN
	A% = 0: AA% = 0
	DO
		A% = A% + 1
		IF A% > HMOVES%(0, 0) THEN EXIT DO

		IF HMOVES%(5, A%) < 0 OR HMOVES%(0, 0) = 1 OR HMOVES%(6, A%) = 6 THEN
			QX% = HMOVES%(1, A%)
			QY% = HMOVES%(2, A%)
			QXX% = HMOVES%(3, A%)
			QYY% = HMOVES%(4, A%)
			QP% = CB%(QX%, QY%)
			TEMP1% = HKX%
			TEMP2% = HKY%
			HKX% = QXX%
			HKY% = QYY%
			GOSUB HKINGCHECK
			HKX% = TEMP1%
			HKY% = TEMP2%

			TEMP1% = CKX%
			TEMP2% = CKY%
			TEMP3% = CB%(QX%, QY%)
			CKX% = QXX%
			CKY% = QYY%
			CB%(QX%, QY%) = 0
			GOSUB CKINGCHECK
			CB%(QX%, QY%) = TEMP3%
			CKX% = TEMP1%
			CKY% = TEMP2%



			CAPTURE% = 1
			IF V%(QP%) > V%(ABS(HMOVES%(5, A%))) AND HCHECK% = 1 THEN CAPTURE% = 0
		  
			IF CCHECK% = 1 AND QPLY% < 3 THEN CAPTURE% = 1
		 
			IF AA% > 1 THEN
				QTHISCAPTURE% = V%(ABS(HMOVES%(5, A%))) - V%(QP%)
				IF QTHISCAPTURE% < QCAPTURESCORE% THEN CAPTURE% = 0
			END IF
		  
			IF HMOVES%(0, 0) = 1 THEN CAPTURE% = 1
		  
			IF HMOVES%(6, A%) = 6 THEN CAPTURE% = 1

			IF CAPTURE% = 1 THEN
				AA% = AA% + 1
				QENGINE%(QPLY%, AA%, 1) = HMOVES%(1, A%)
				QENGINE%(QPLY%, AA%, 2) = HMOVES%(2, A%)
				QENGINE%(QPLY%, AA%, 3) = HMOVES%(3, A%)
				QENGINE%(QPLY%, AA%, 4) = HMOVES%(4, A%)
				QENGINE%(QPLY%, AA%, 5) = HMOVES%(6, A%)
				QTHISCAPTURE% = V%(ABS(HMOVES%(5, A%))) - V%(QP%)
			END IF
		END IF
	LOOP
	 
	QENGINE%(QPLY%, 0, 0) = AA%
	IF AA% > 0 THEN QENGINE%(QPLY%, 1, 0) = 1
END IF

'*** IF THERE ARE AT LEAST 2 TAKES THEN BUBBLE SORT THEM
IF QENGINE%(QPLY%, 0, 0) > 1 THEN
	QSTART% = QENGINE%(QPLY%, 0, 0)
  
	FOR A% = 1 TO QENGINE%(QPLY%, 0, 0) - 1
	  
		QSTART% = QSTART% - 1
	 
		FOR I% = 1 TO QSTART%
			QX% = QENGINE%(QPLY%, I%, 1)
			QY% = QENGINE%(QPLY%, I%, 2)
			QXX% = QENGINE%(QPLY%, I%, 3)
			QYY% = QENGINE%(QPLY%, I%, 4)
			P1% = ABS(CB%(QX%, QY%))
			P2% = ABS(CB%(QXX%, QYY%))
			V1% = V%(P2%) - V%(P1%)
	  
			QX% = QENGINE%(QPLY%, I% + 1, 1)
			QY% = QENGINE%(QPLY%, I% + 1, 2)
			QXX% = QENGINE%(QPLY%, I% + 1, 3)
			QYY% = QENGINE%(QPLY%, I% + 1, 4)
			P1% = ABS(CB%(QX%, QY%))
			P2% = ABS(CB%(QXX%, QYY%))
			V2% = V%(P2%) - V%(P1%)

			IF V1% < V2% THEN
				'TEMP1% = ENGINE%(QPLY%, I%, 1)
				'TEMP2% = ENGINE%(QPLY%, I%, 2)
				'TEMP3% = ENGINE%(QPLY%, I%, 3)
				'TEMP4% = ENGINE%(QPLY%, I%, 4)
				'TEMP5% = ENGINE%(QPLY%, I%, 5)
			  
				FOR II% = 1 TO 5
					SWAP QENGINE%(QPLY%, I%, II%), QENGINE%(QPLY%, I% + 1, II%)
				NEXT
			  
				'QENGINE%(QPLY%, I% + 1, 1) = TEMP1%
				'QENGINE%(QPLY%, I% + 1, 2) = TEMP2%
				'QENGINE%(QPLY%, I% + 1, 3) = TEMP3%
				'QENGINE%(QPLY%, I% + 1, 4) = TEMP4%
				'QENGINE%(QPLY%, I% + 1, 5) = TEMP5%
			  
			END IF
		NEXT
	NEXT
END IF

RETURN




QABPRUNE:
'********** ALPHA BETA PRUNE *************************************

QMINIMAX% = 1
IF (PLY% + QPLY%) / 2 = INT((PLY% + QPLY%) / 2) THEN QMINIMAX% = 2

QFIRSTPLY% = 1
IF (PLY% + 1) / 2 = INT((PLY% + 1) / 2) THEN QFIRSTPLY% = 2

IF QFIRSTPLY% = 2 THEN
	IF ENGINE%(1, 1, 0) > 1 THEN
		IF QENGINE%(1, 1, 0) > 1 THEN
			IF QSCORE%(1, 1) < SCORE%(1, 1) THEN
				QENGINE%(1, 0, 0) = QENGINE%(1, 1, 0)
			END IF
		END IF
	END IF
END IF


IF QPLY% < 2 THEN RETURN
IF QENGINE%(QPLY% - 1, 1, 0) = 1 THEN RETURN


IF QMINIMAX% = 1 THEN
	IF EVAL% > QSCORE%(QPLY% - 1, 1) THEN
		QENGINE%(QPLY%, 0, 0) = QENGINE%(QPLY%, 1, 0)
	END IF
	IF QFIRSTPLY% = 1 THEN
		IF QENGINE%(1, 1, 0) > 1 THEN
			IF QENGINE%(QPLY% - 1, 1, 0) > 1 THEN
				IF QSCORE%(QPLY% - 1, 1) < QSCORE%(1, 1) THEN
					QENGINE%(QPLY% - 1, 0, 0) = QENGINE%(QPLY% - 1, 1, 0)
					QENGINE%(QPLY%, 0, 0) = QENGINE%(QPLY%, 1, 0)
				END IF
			END IF
		END IF
	END IF
END IF

IF QMINIMAX% = 2 THEN
	IF EVAL% < QSCORE%(QPLY% - 1, 1) THEN
		QENGINE%(QPLY%, 0, 0) = QENGINE%(QPLY%, 1, 0)
	END IF

	IF QFIRSTPLY% = 1 THEN
		IF QENGINE%(1, 1, 0) > 1 THEN
			IF EVAL% < QSCORE%(1, 1) THEN
				QENGINE%(QPLY%, 0, 0) = QENGINE%(QPLY%, 1, 0)
			END IF
		END IF
	END IF
END IF


IF QFIRSTPLY% = 2 THEN
	IF ENGINE%(1, 1, 0) > 1 THEN
		IF QENGINE%(1, 1, 0) > 1 THEN
			IF QSCORE%(1, 1) < SCORE%(1, 1) THEN
				QENGINE%(1, 0, 0) = QENGINE%(1, 1, 0)
			END IF
		END IF
	END IF
END IF

RETURN


QSCOREIT:
'******************** APPLY MINI MAX RULES WITH EVAL% ***************

IF QPLY% < 1 THEN
	QSCORE%(1, 1) = EVAL%
	QSCORE%(1, 2) = 0
	RETURN
END IF

IF QENGINE%(QPLY%, 1, 0) = 1 THEN
	QSCORE%(QPLY%, 1) = EVAL%
	QSCORE%(QPLY%, 2) = 1
END IF

QMINIMAX% = 1
IF (PLY% + QPLY%) / 2 = INT((PLY% + QPLY%) / 2) THEN QMINIMAX% = 2

IF QMINIMAX% = 1 THEN
	IF EVAL% > QSCORE%(QPLY%, 1) THEN
		QSCORE%(QPLY%, 1) = EVAL%
		QSCORE%(QPLY%, 2) = QENGINE%(QPLY%, 1, 0)
	END IF
END IF

IF QMINIMAX% = 2 THEN
	IF EVAL% < QSCORE%(QPLY%, 1) THEN
		QSCORE%(QPLY%, 1) = EVAL%
		QSCORE%(QPLY%, 2) = QENGINE%(QPLY%, 1, 0)
	END IF
END IF

A% = QPLY%

QPROPAGATE% = 1

DO
	IF QPLY% = 1 THEN EXIT DO
 
	QMINIMAX% = 1
	IF (PLY% + A%) / 2 = INT((PLY% + A%) / 2) THEN QMINIMAX% = 2

	IF QENGINE%(A%, 1, 0) < QENGINE%(A%, 0, 0) THEN QPROPAGATE% = 0
 

	IF A% < QPLY% THEN
		IF QENGINE%(A%, 1, 0) = 1 THEN
			QSCORE%(A%, 1) = QSCORE%(A% + 1, 1)
			QSCORE%(A%, 2) = 1
		END IF
	END IF

	IF QPROPAGATE% = 1 THEN
		IF QENGINE%(A%, 1, 0) >= QENGINE%(A%, 0, 0) THEN
			IF QMINIMAX% = 1 THEN
				IF QSCORE%(A%, 1) < QSCORE%(A% - 1, 1) THEN
					QSCORE%(A% - 1, 1) = QSCORE%(A%, 1)
					QSCORE%(A% - 1, 2) = QENGINE%(A% - 1, 1, 0)
				END IF
			END IF
	 
			IF QMINIMAX% = 2 THEN
				IF QSCORE%(A%, 1) > QSCORE%(A% - 1, 1) THEN
					QSCORE%(A% - 1, 1) = QSCORE%(A%, 1)
					QSCORE%(A% - 1, 2) = QENGINE%(A% - 1, 1, 0)
				END IF
			END IF
		END IF
	END IF


	 A% = A% - 1
	IF A% = 0 THEN EXIT DO

LOOP

RETURN





















GAMEPHASE:
'************ DETERMINE GAME PHASE. IE. OPENNING, MIDDLE, END GAME

PC% = 0: ROW1% = 0

FOR PY% = 1 TO 8
	FOR PX% = 1 TO 8
		IF SIDE% = 0 AND CB%(PX%, PY%) < 0 THEN
			IF CB%(PX%, PY%) < -1 THEN PC% = PC% + 1
			IF PY% = 1 THEN ROW1% = ROW1% + 1
		END IF
	  
		IF SIDE% = 1 AND CB%(PX%, PY%) > 0 THEN
			IF CB%(PX%, PY%) > 1 THEN PC% = PC% + 1
			IF PY% = 8 THEN ROW1% = ROW1% + 1
		END IF
	  
	NEXT
NEXT

IF PC% > 4 THEN PHASE% = 2
IF ROW1% > 3 THEN
	IF SIDE% = 0 AND (CB%(3, 9) = 1 OR CB%(4, 9) = 1) THEN PHASE% = 1
	IF SIDE% = 1 AND (CB%(1, 9) = 1 OR CB%(2, 9) = 1) THEN PHASE% = 1
END IF
IF PC% < 5 THEN PHASE% = 3

RETURN

		


THINK:
'********** START SEARCHING  ***********

FOR A% = 5 TO 20: LOCATE A%, 52: PRINT "                       ": NEXT

T1 = TIMER

GOSUB BOOK
IF FOUND > 0 THEN
	GOSUB RECORDMOVE
	GOSUB MAKEMOVE
	CMOVES% = CMOVES% + 1
	TOTALTIME = TOTALTIME + (TIMER - T1)

	IF LOGGAME% = 1 THEN
		OPEN "CHESS.LOG" FOR APPEND AS #1
			PRINT #1, " "
			PRINT #1, USING "###"; MOVE%;
			PRINT #1, ". ";
			IF SIDE% = 0 THEN PRINT #1, " ... ";
			PRINT #1, C$(X%); CY$(Y%); C$(XX%); CY$(YY%); " (BOOK)"
			PRINT #1, " "
		CLOSE 1
	END IF
  
	GOSUB COPYCB2BO
	GOSUB DRAWBOARD
	COLOR 12
	IF FLIP% = 0 THEN LINE (XX% * 45 - 33, YY% * 38 - 8)-((XX% * 45) + 45 - 33, (YY% * 38) + 38 - 8), , B
	IF FLIP% = 1 THEN LINE ((9 - XX%) * 45 - 33, (9 - YY%) * 38 - 8)-(((9 - XX%) * 45) + 45 - 33, ((9 - YY%) * 38) + 38 - 8), , B
  
	RETURN
END IF

FOR A% = 1 TO 10
	ENGINE%(A%, 1, 0) = 0
	SCORE%(A%, 1) = 0
	SCORE%(A%, 2) = 0
NEXT

COLOR 10
LOCATE 23, 55: PRINT "   THINKING  ("; MOVE%; ")"

MAXDEPTH% = 10
DEPTH% = 1
NODES = 0
MATEH% = 0
MATEC% = 0

EXTENSTION% = 0

'***** FIND THE KINGS AND STORE THEIR LOCATION
GOSUB FINDKINGS
OCKX% = CKX%
OCKY% = CKY%
OHKY% = HKY%
OHKX% = HKX%

'****** DETERMINE GAME PHASE (OPENNING,MIDDLE,END)
GOSUB GAMEPHASE

IF PHASE% = 1 THEN PHASE$ = "OPENING"
IF PHASE% = 2 THEN PHASE$ = "MIDDLE"
IF PHASE% = 3 THEN PHASE$ = "END GAME"
'LOCATE 5, 55: PRINT PHASE$

IF CMOVES%(0, 0) = 1 AND SIDE% = 0 THEN
	MAXDEPTH% = 1
END IF
IF HMOVES%(0, 0) = 1 AND SIDE% = 1 THEN
	MAXDEPTH% = 1
END IF

IF LEVEL% > 0 THEN
	IF CMOVES% < MOVESPERHOUR% THEN LEVEL% = (3600 - TOTALTIME) / (MOVESPERHOUR% - CMOVES%)
	IF CMOVES% > MOVESPERHOUR% THEN LEVEL% = 3600 - TOTALTIME
END IF
'LOCATE 18, 60: PRINT "LEVEL="; LEVEL%


DO
	'DEPTH% = DEPTH% + 1
	IF DEPTH% > MAXDEPTH% THEN EXIT DO

	IF DEPTH% > 1 AND TIMER - T1 > LEVEL% AND LEVEL% <> 0 THEN
		SCOREWINDOW% = SCORE%(1, 1) - LASTPLYSCORE%
		IF SCOREWINDOW% > -.2 THEN EXIT DO
		IF EXTENSTION% = 0 THEN
			IF SCOREWINDOW% < -19 THEN EXTENSTION% = LEVEL% * .5
			IF SCOREWINDOW% < -50 THEN EXTENSTION% = LEVEL% * 2
			IF SCOREWINDOW% < -80 THEN EXTENSTION% = LEVEL% * 10
			'LOCATE 20, 60: PRINT "EXTENSTION="; EXTENSTION%
			'LOCATE 21, 60: PRINT "SCORE WINDOW="; SCOREWINDOW%
		END IF
		IF TIMER - T1 > LEVEL% + EXTENSTION% THEN EXIT DO
	END IF
  
	IF ENGINE%(1, 1, 0) > 1 AND SCORE%(1, 1) > 18000 THEN EXIT DO
  
	A$ = INKEY$
	IF A$ = " " THEN EXIT DO

	PLY% = 0
  
	DO
		PLY% = PLY% + 1
	  
		IF PLY% > DEPTH% THEN PLY% = 1
	
		IF PLY% = 1 THEN
			GOSUB COPYBOARD
			CKY% = OCKY%
			CKX% = OCKX%
			HKX% = OHKX%
			HKY% = OHKY%
		END IF


		WHOSTURN% = 1
		IF (PLY% + SIDE%) / 2 = INT((PLY% + SIDE%) / 2) THEN WHOSTURN% = 2

		IF ENGINE%(PLY%, 1, 0) = 0 THEN
			IF WHOSTURN% = 1 THEN
				GOSUB CMOVELIST
				IF CMOVES%(0, 0) = 0 THEN
					GOSUB CKINGCHECK
					MATEC% = 2
					IF CCHECK% = 1 THEN MATEC% = 1
				END IF
				GOSUB MOVEORDER
			END IF
			IF WHOSTURN% = 2 THEN
				GOSUB HMOVELIST
				IF HMOVES%(0, 0) = 0 THEN
					GOSUB HKINGCHECK
					MATEH% = 2
					IF HCHECK% = 1 THEN MATEH% = 1
				END IF
				GOSUB MOVEORDER
			END IF
		END IF

		IF PLY% = DEPTH% THEN ENGINE%(DEPTH%, 1, 0) = ENGINE%(DEPTH%, 1, 0) + 1
	  
		POINTER% = ENGINE%(PLY%, 1, 0)
		IF POINTER% < ENGINE%(PLY%, 0, 0) + 1 THEN
			X% = ENGINE%(PLY%, POINTER%, 1)
			Y% = ENGINE%(PLY%, POINTER%, 2)
			XX% = ENGINE%(PLY%, POINTER%, 3)
			YY% = ENGINE%(PLY%, POINTER%, 4)
			SPECIAL% = ENGINE%(PLY%, POINTER%, 5)
			GOSUB MAKEMOVE
		END IF

		IF PLY% = DEPTH% THEN
			GOSUB QUIESCENCE
		  
			IF PLY% = 1 THEN
				FIRSTPLY%(ENGINE%(1, 1, 0)) = EVAL%
			END IF
		  
			GOSUB ABPRUNE
		  
			GOSUB SCOREIT

		END IF

		'################### TEST CODE ############################
		'IF PLY% = DEPTH% AND DEPTH% = 3 AND ENGINE%(1, 1, 0) > 2 THEN
		'   CLS
		'   LOCATE 3, 60: PRINT "WHO'S TURN="; WHOSTURN%
		'   LOCATE 4, 60: PRINT "DEPTH="; DEPTH%
		'   LOCATE 5, 60: PRINT "PLY="; PLY%
		'   LOCATE 6, 60: PRINT "MOVE="; ENGINE%(PLY%, 1, 0); "OUT OF "; ENGINE%(PLY%, 0, 0)
		'   LOCATE 7, 60: PRINT "EVAL="; EVAL% / 100; "   "
		'   GOSUB DRAWCBBOARD
		'   FOR A% = 0 TO PLY%
		'      LOCATE 19, 10 + (A% * 6): PRINT SCORE%(A%, 1); ":     "
		'      LOCATE 20, 10 + (A% * 6): PRINT SCORE%(A%, 2); "    "
		'      LOCATE 21, 10 + (A% * 6): PRINT ENGINE%(A%, 1, 0)
		'      LOCATE 22, 10 + (A% * 6): PRINT ENGINE%(A%, 0, 0)
		'      LOCATE 23, 10 + (A% * 6): PRINT C$(ENGINE%(A%, ENGINE%(A%, 1, 0), 1)); CY$(ENGINE%(A%, ENGINE%(A%, 1, 0), 2)); C$(ENGINE%(A%, ENGINE%(A%, 1, 0), 3)); CY$(ENGINE%(A%, ENGINE%(A%, 1, 0), 4))
		'
		'   NEXT
		'  DO
		'      A$ = INKEY$
		'    IF A$ <> "" THEN EXIT DO
		'  LOOP
		'END IF
	  

		IF PLY% = DEPTH% THEN
			IF POINTER% >= ENGINE%(PLY%, 0, 0) THEN EXIT DO
		END IF

	LOOP

	ENGINE%(DEPTH%, 1, 0) = ENGINE%(DEPTH%, 1, 0) + 1
	IF DEPTH% > 1 THEN
		FOR A% = DEPTH% TO 2 STEP -1
			IF ENGINE%(A%, 1, 0) > ENGINE%(A%, 0, 0) THEN
				ENGINE%(A% - 1, 1, 0) = ENGINE%(A% - 1, 1, 0) + 1
				ENGINE%(A%, 1, 0) = 0: ENGINE%(A%, 0, 0) = 0
				IF A% = 2 THEN
					COLOR 10
					CUR$ = C$(ENGINE%(1, ENGINE%(1, 1, 0), 1)) + CY$(ENGINE%(1, ENGINE%(1, 1, 0), 2)) + C$(ENGINE%(1, ENGINE%(1, 1, 0), 3)) + CY$(ENGINE%(1, ENGINE%(1, 1, 0), 4))
				  
					LOCATE 7, 60: PRINT ENGINE%(1, 1, 0); "OF"; ENGINE%(1, 0, 0); "("; CUR$; ")  "
					'IF ENGINE%(1, 1, 0) > ENGINE%(1, 0, 0) THEN
					'   LOCATE 7, 60: PRINT " 1 OF "; ENGINE%(1, 0, 0); "("; CUR$; ")  "
					'END IF
				END IF
			END IF
		NEXT
	END IF

	IF ENGINE%(1, 1, 0) > ENGINE%(1, 0, 0) THEN
		ENGINE%(1, 1, 0) = 1
		DEPTH% = DEPTH% + 1

		GOSUB HISTORY
	  
		GOSUB BESTORDER
		SCORE%(1, 2) = 1
		COLOR 12
		LOCATE 7, 52: PRINT "DEPTH="; DEPTH%
		COLOR 10
		CUR$ = C$(ENGINE%(1, ENGINE%(1, 1, 0), 1)) + CY$(ENGINE%(1, ENGINE%(1, 1, 0), 2)) + C$(ENGINE%(1, ENGINE%(1, 1, 0), 3)) + CY$(ENGINE%(1, ENGINE%(1, 1, 0), 4))
		LOCATE 7, 60: PRINT " 1 OF "; ENGINE%(1, 0, 0); "("; CUR$; ")  "
		LASTPLYSCORE% = SCORE%(1, 1)

	END IF
LOOP

THINKFINISHED:

GOSUB BESTORDER

BESTM% = 1
IF DEPTH% = 2 THEN BESTM% = SCORE%(1, 2)

GOSUB COPYBOARD

X% = ENGINE%(1, BESTM%, 1)
Y% = ENGINE%(1, BESTM%, 2)
XX% = ENGINE%(1, BESTM%, 3)
YY% = ENGINE%(1, BESTM%, 4)
SPECIAL% = ENGINE%(1, BESTM%, 5)
GOSUB RECORDMOVE
GOSUB MAKEMOVE
'*** TIME MANAGEMENT
CMOVES% = CMOVES% + 1
TOTALTIME = TOTALTIME + (TIMER - T1)
IF TOTALTIME >= 3600 THEN TOTALTIME = TOTALTIME - 3600: CMOVES% = 0

GOSUB COPYCB2BO
GOSUB DRAWBOARD

COLOR 12
X% = ENGINE%(1, BESTM%, 1)
Y% = ENGINE%(1, BESTM%, 2)
XX% = ENGINE%(1, BESTM%, 3)
YY% = ENGINE%(1, BESTM%, 4)
IF FLIP% = 0 THEN LINE (XX% * 45 - 33, YY% * 38 - 8)-((XX% * 45) + 45 - 33, (YY% * 38) + 38 - 8), , B
IF FLIP% = 1 THEN LINE ((9 - XX%) * 45 - 33, (9 - YY%) * 38 - 8)-(((9 - XX%) * 45) + 45 - 33, ((9 - YY%) * 38) + 38 - 8), , B


IF LOGGAME% = 1 THEN
	OPEN "CHESS.LOG" FOR APPEND AS #1
		PRINT #1, " "
		PRINT #1, USING "###"; MOVE%;
		PRINT #1, ". ";
		IF SIDE% = 0 THEN PRINT #1, " ... ";
		PRINT #1, C$(X%); CY$(Y%); C$(XX%); CY$(YY%)
		PRINT #1, " "
	CLOSE 1
END IF


'PRINT "NODES="; NODES
'T2 = TIMER
'PRINT "TIME TAKEN="; T2 - T1
'PRINT "COMPUTER MATED="; MATEC%
'PRINT "HUMAN MATED="; MATEH%

'IF T2 - T1 <> 0 THEN PRINT "AVERAGE NODES PER SECOND="; NODES / (T2 - T1)
'END

FOR I = 1 TO 3
	LOCATE I + 4, 52: PRINT "                         "
NEXT
'LOCATE 22, 55: PRINT "TOTAL TIME="; TOTALTIME
RETURN

HISTORY:
'**** RECORDS BEST LINE AFTER EACH ITERATION FOR USE IN ORDERING MOVES
FOR I% = 1 TO DEPTH% - 1
	FOR A% = 1 TO 4
		HISTORY%(A%, I%) = BESTL%(1, I%, A%)
	NEXT
NEXT
RETURN


ORDERAFTERPLY1:
'***** BUBBLE SORT THE MOVES ON PLY 1 FROM BEST TO WORST ******
A% = ENGINE%(1, 0, 0)
FOR I% = 1 TO ENGINE%(1, 0, 0) - 1
	A% = A% - 1
	FOR II% = 1 TO A%
		IF FIRSTPLY%(II% + 1) > FIRSTPLY%(II%) THEN
			TEMP1% = FIRSTPLY%(II%)
			FIRSTPLY%(II%) = FIRSTPLY%(II% + 1)
			FIRSTPLY%(II% + 1) = TEMP1%

			TEMP1% = ENGINE%(1, II%, 1)
			TEMP2% = ENGINE%(1, II%, 2)
			TEMP3% = ENGINE%(1, II%, 3)
			TEMP4% = ENGINE%(1, II%, 4)
			TEMP5% = ENGINE%(1, II%, 5)

			FOR AA% = 1 TO 5
				ENGINE%(1, II%, AA%) = ENGINE%(1, II% + 1, AA%)
			NEXT

			ENGINE%(1, II% + 1, 1) = TEMP1%
			ENGINE%(1, II% + 1, 2) = TEMP2%
			ENGINE%(1, II% + 1, 3) = TEMP3%
			ENGINE%(1, II% + 1, 4) = TEMP4%
			ENGINE%(1, II% + 1, 5) = TEMP5%
		END IF
	NEXT
NEXT

RETURN




BESTORDER:
'***** ORDER THE BEST MOVE FOUND SO FAR FIRST AND SHUFFLE THE REST DOWN *****

IF DEPTH% = 2 THEN GOSUB ORDERAFTERPLY1: SCORE%(1, 2) = 1: RETURN

TEMP1% = ENGINE%(1, SCORE%(1, 2), 1)
TEMP2% = ENGINE%(1, SCORE%(1, 2), 2)
TEMP3% = ENGINE%(1, SCORE%(1, 2), 3)
TEMP4% = ENGINE%(1, SCORE%(1, 2), 4)
TEMP5% = ENGINE%(1, SCORE%(1, 2), 5)


FOR I% = SCORE%(1, 2) TO 2 STEP -1
	FOR A% = 1 TO 5
		ENGINE%(1, I%, A%) = ENGINE%(1, I% - 1, A%)
	NEXT
NEXT
 
ENGINE%(1, 1, 1) = TEMP1%
ENGINE%(1, 1, 2) = TEMP2%
ENGINE%(1, 1, 3) = TEMP3%
ENGINE%(1, 1, 4) = TEMP4%
ENGINE%(1, 1, 5) = TEMP5%

SCORE%(1, 2) = 1

'###################### TEST CODE ############################
'FOR I = 1 TO SCORE%(1, 2) + 2
'   FOR A = 1 TO 5
'      PRINT ENGINE%(1, I, A);
'   NEXT
'   PRINT
'NEXT
'END

RETURN



ABPRUNE:
'********** ALPHA BETA PRUNE *************************************
IF PLY% = 1 THEN RETURN

PRUNE% = 0

	'*** FIND ALPHA
	A% = 0
	DO
		A% = A% + 1
		IF A% > DEPTH% - 1 THEN EXIT DO

		IF ENGINE%(A%, 1, 0) > 1 THEN EXIT DO
	LOOP

	ALPHA% = SCORE%(A%, 1)

	AMINIMAX% = 1
	IF A% / 2 = INT(A% / 2) THEN AMINIMAX% = 2

	'***** FIND BETA AND COMPARE TO ALPHA FOR PRUNE
B% = A%
DO
	B% = B% + 1
	IF B% > DEPTH% THEN EXIT DO

	MINIMAX% = 1
	IF B% / 2 = INT(B% / 2) THEN MINIMAX% = 2

	IF MINIMAX% <> AMINIMAX% AND ENGINE%(B%, 1, 0) > 1 THEN
	  
		IF B% < DEPTH% THEN BETA% = SCORE%(B%, 1)
		IF B% = DEPTH% THEN BETA% = EVAL%
	  
		IF AMINIMAX% = 1 AND BETA% < ALPHA% THEN
			FOR I% = B% TO DEPTH%
				ENGINE%(I%, 0, 0) = ENGINE%(I%, 1, 0)
			NEXT
			PRUNE% = 1
			EXIT DO
		END IF
  
		IF AMINIMAX% = 2 AND BETA% > ALPHA% THEN
			FOR I% = B% TO DEPTH%
				ENGINE%(I%, 0, 0) = ENGINE%(I%, 1, 0)
			NEXT
			PRUNE% = 1
			EXIT DO
		END IF
	END IF
LOOP


IF PRUNE% = 1 THEN RETURN

'IF PLY% > 2 THEN
'   IF ENGINE%(2, 1, 0) > 1 AND ENGINE%(1, 1, 0) > 1 THEN
'      IF SCORE%(2, 1) < SCORE%(1, 1) THEN
'         PRINT "I ENDED AT CUT OFF"
'         END
'         FOR I% = 2 TO DEPTH%
'            ENGINE%(I%, 0, 0) = ENGINE%(I%, 1, 0)
'         NEXT
'      END IF
'   END IF
'END IF


MINIMAX% = 1
IF (PLY%) / 2 = INT((PLY%) / 2) THEN MINIMAX% = 2

IF MINIMAX% = 1 THEN
 
	IF EVAL% > SCORE%(PLY% - 1, 1) AND ENGINE%(PLY% - 1, 1, 0) > 1 THEN
		ENGINE%(PLY%, 0, 0) = ENGINE%(PLY%, 1, 0)
	END IF

	'IF PLY% > 2 AND ENGINE%(1, 1, 0) > 1 THEN
	'   IF ENGINE%(PLY% - 1, 1, 0) > 1 THEN
	'      IF SCORE%(PLY% - 1, 1) < SCORE%(1, 1) THEN
	'         ENGINE%(PLY% - 1, 0, 0) = ENGINE%(PLY% - 1, 1, 0)
	'         ENGINE%(PLY%, 0, 0) = ENGINE%(PLY%, 1, 1)
	'      END IF
	'   END IF
	'END IF
END IF

IF MINIMAX% = 2 THEN
	IF EVAL% < SCORE%(PLY% - 1, 1) AND ENGINE%(PLY% - 1, 1, 0) > 1 THEN
		ENGINE%(PLY%, 0, 0) = ENGINE%(PLY%, 1, 0)
	END IF

	IF ENGINE%(1, 1, 0) > 1 AND EVAL% < SCORE%(1, 1) AND ENGINE%(PLY%, 1, 0) > 1 THEN
	  ENGINE%(PLY%, 0, 0) = ENGINE%(PLY%, 1, 0)
	END IF
END IF

RETURN

SCOREIT:
'******************** APPLY MINI MAX RULES WITH EVAL% ***************

IF ENGINE%(PLY%, 1, 0) = 1 THEN
	SCORE%(PLY%, 1) = EVAL%
	SCORE%(PLY%, 2) = 1
	IF PLY% = 1 THEN GOSUB BESTMOVE: RETURN
	BL% = PLY%: GOSUB BESTLINE
END IF

MINIMAX% = 1
IF PLY% / 2 = INT(PLY% / 2) THEN MINIMAX% = 2

IF MINIMAX% = 1 THEN
	IF EVAL% > SCORE%(PLY%, 1) THEN
		SCORE%(PLY%, 1) = EVAL%
		SCORE%(PLY%, 2) = ENGINE%(PLY%, 1, 0)
		IF PLY% = 1 THEN GOSUB BESTMOVE
		BL% = PLY%: GOSUB BESTLINE
	END IF
END IF

IF MINIMAX% = 2 THEN
	IF EVAL% < SCORE%(PLY%, 1) THEN
		SCORE%(PLY%, 1) = EVAL%
		SCORE%(PLY%, 2) = ENGINE%(PLY%, 1, 0)
		BL% = PLY%: GOSUB BESTLINE
	END IF
END IF

A% = PLY%

PROPAGATE% = 1

DO
	IF PLY% = 1 THEN EXIT DO
  
	MINIMAX% = 1
	IF A% / 2 = INT(A% / 2) THEN MINIMAX% = 2

	IF ENGINE%(A%, 1, 0) < ENGINE%(A%, 0, 0) THEN PROPAGATE% = 0
  
	IF PROPAGATE% = 1 THEN
		IF ENGINE%(A%, 1, 0) >= ENGINE%(A%, 0, 0) THEN
			IF MINIMAX% = 1 THEN
				IF SCORE%(A%, 1) < SCORE%(A% - 1, 1) THEN
					SCORE%(A% - 1, 1) = SCORE%(A%, 1)
					SCORE%(A% - 1, 2) = ENGINE%(A% - 1, 1, 0)
					BL% = A% - 1: GOSUB BESTLINE
				END IF
			END IF
	  
			IF MINIMAX% = 2 THEN
				IF SCORE%(A%, 1) > SCORE%(A% - 1, 1) THEN
					SCORE%(A% - 1, 1) = SCORE%(A%, 1)
					SCORE%(A% - 1, 2) = ENGINE%(A% - 1, 1, 0)
					BL% = A% - 1: GOSUB BESTLINE
					IF A% - 1 = 1 THEN GOSUB BESTMOVE
				END IF
			END IF
		END IF
	END IF

	IF A% < DEPTH% THEN
		IF ENGINE%(A%, 1, 0) = 1 THEN
			SCORE%(A%, 1) = SCORE%(A% + 1, 1)
			SCORE%(A%, 2) = 1
			BL% = A%: GOSUB BESTLINE
			IF A% = 1 THEN GOSUB BESTMOVE
		END IF
	END IF

	A% = A% - 1
	IF A% = 0 THEN EXIT DO

LOOP


		
RETURN


BESTLINE:
'*************** STORE THE BEST LINE IN MEMORY ***********
IF BL% = DEPTH% THEN
	FOR I% = 1 TO DEPTH%
		FOR II% = 1 TO 4
			BESTL%(DEPTH%, I%, II%) = ENGINE%(I%, ENGINE%(I%, 1, 0), II%)
		NEXT
	NEXT
END IF

IF BL% < DEPTH% THEN
	FOR I% = 1 TO DEPTH%
		FOR II% = 1 TO 4
			BESTL%(BL%, I%, II%) = BESTL%(BL% + 1, I%, II%)
		NEXT
	NEXT
END IF

RETURN


BESTMOVE:
'********* SHOWS BEST MOVE DISCOVERED SO FAR ************

'IF ENGINE%(1, 1, 0) = 1 THEN RETURN

IF SCORE%(1, 1) = LASTSCORE% AND SCORE%(1, 2) = LASTBEST% AND DEPTH% = LASTDEPTH% THEN RETURN

'SHOWN% = SHOWN% + 1
COLOR 11

COLOR 15
LOCATE 11, 59: PRINT SPACE$(10)
LOCATE 9, 55: PRINT "BEST:";

BESTMOVE1% = SCORE%(1, 2)
MESSAGE$ = STR$(SCORE%(1, 1) / 100)
IF SCORE%(1, 1) > 18000 THEN MESSAGE$ = "MATE IN" + STR$(INT((DEPTH% / 2) + .5))
PRINT USING "####.##"; SCORE%(1, 1) / 100;
IF SCORE%(1, 1) > 18000 THEN
	LOCATE 9, 52: PRINT "                         "
	LOCATE 9, 55: PRINT MESSAGE$;
END IF
PRINT "("; INT(TIMER - T1); ") "


COLOR 9
FOR I% = 1 TO DEPTH%
	LOCATE 10 + I%, 62: PRINT C$(BESTL%(1, I%, 1)); CY$(BESTL%(1, I%, 2)); C$(BESTL%(1, I%, 3)); CY$(BESTL%(1, I%, 4))
NEXT

IF LOGGAME% = 1 AND DEPTH% > 1 THEN
	OPEN "CHESS.LOG" FOR APPEND AS #1
		PRINT #1, USING "###"; MOVE%;
		PRINT #1, ".  ";
		PRINT #1, USING "######"; INT(TIMER - T1);
		PRINT #1, "s  ";
		PRINT #1, USING "####.##"; SCORE%(1, 1) / 100;
		PRINT #1, USING " (##)"; DEPTH%;
		PRINT #1, " ";
		IF SIDE% = 0 THEN PRINT #1, " ... ";
		FOR I% = 1 TO DEPTH%
			PRINT #1, C$(BESTL%(1, I%, 1)); CY$(BESTL%(1, I%, 2)); C$(BESTL%(1, I%, 3)); CY$(BESTL%(1, I%, 4)); " ";
		NEXT
		PRINT #1, " "
	CLOSE 1
END IF


LASTBEST% = SCORE%(1, 2)
LASTSCORE% = SCORE%(1, 1)
LASTDEPTH% = DEPTH%

RETURN





MOVEORDER:
' *** COPY MOVE LIST TO ENGINE THEN ORDER THEM ******

IF WHOSTURN% = 1 THEN
	FOR A% = 1 TO CMOVES%(0, 0)
		ENGINE%(PLY%, A%, 1) = CMOVES%(1, A%)
		ENGINE%(PLY%, A%, 2) = CMOVES%(2, A%)
		ENGINE%(PLY%, A%, 3) = CMOVES%(3, A%)
		ENGINE%(PLY%, A%, 4) = CMOVES%(4, A%)
		ENGINE%(PLY%, A%, 5) = CMOVES%(6, A%)
	NEXT
	ENGINE%(PLY%, 0, 0) = CMOVES%(0, 0)
	
	'################# TEST SPECIFIC BRANCH ###############
	'IF PLY% = 1 THEN
	'   ENGINE%(1, 1, 1) = 5
	'   ENGINE%(1, 1, 2) = 5
	'   ENGINE%(1, 1, 3) = 7
	'   ENGINE%(1, 1, 4) = 4
	'   ENGINE%(1, 1, 5) = 0
	'  ENGINE%(1, 0, 0) = 1
	'END IF

END IF

IF WHOSTURN% = 2 THEN
	FOR A% = 1 TO HMOVES%(0, 0)
		ENGINE%(PLY%, A%, 1) = HMOVES%(1, A%)
		ENGINE%(PLY%, A%, 2) = HMOVES%(2, A%)
		ENGINE%(PLY%, A%, 3) = HMOVES%(3, A%)
		ENGINE%(PLY%, A%, 4) = HMOVES%(4, A%)
		ENGINE%(PLY%, A%, 5) = HMOVES%(6, A%)
	NEXT
	ENGINE%(PLY%, 0, 0) = HMOVES%(0, 0)
END IF

IF PLY% < DEPTH% THEN ENGINE%(PLY%, 1, 0) = 1

'****** BUBBLE SORT MOVES LIST WITH LOWEST VALUE PIECE TAKING HIGHEST VALUE PIECE
IF PLY% > 1 AND DEPTH% > 3 THEN

	'HUMOVE% = 0
	'IF PLY% / 2 = INT(PLY% / 2) THEN HUMOVE% = 1
	'IF DEPTH% > 4 THEN HUMOVE% = 1

	'IF HUMOVE% = 1 THEN
		IF ENGINE%(PLY%, 0, 0) > 1 THEN
			START% = ENGINE%(PLY%, 0, 0)

			FOR A% = 1 TO ENGINE%(PLY%, 0, 0) - 1
  
				START% = START% - 1
 
				FOR I% = 1 TO START%
				
					QX% = ENGINE%(PLY%, I%, 1)
					QY% = ENGINE%(PLY%, I%, 2)
					QXX% = ENGINE%(PLY%, I%, 3)
					QYY% = ENGINE%(PLY%, I%, 4)
					P1% = ABS(CB%(QX%, QY%))
					P2% = ABS(CB%(QXX%, QYY%))
					V1% = V%(P2%) - V%(P1%)
				

					QX% = ENGINE%(PLY%, I% + 1, 1)
					QY% = ENGINE%(PLY%, I% + 1, 2)
					QXX% = ENGINE%(PLY%, I% + 1, 3)
					QYY% = ENGINE%(PLY%, I% + 1, 4)
					P1% = ABS(CB%(QX%, QY%))
					P2% = ABS(CB%(QXX%, QYY%))
					V2% = V%(P2%) - V%(P1%)
				
					IF V1% < V2% THEN
						FOR II% = 1 TO 5
							SWAP ENGINE%(PLY%, I%, II%), ENGINE%(PLY%, I% + 1, II%)
						NEXT
					END IF
		  
				NEXT
			NEXT
		END IF
	'END IF
END IF



'**** PUT MOVE FROM BEST LINE TO TOP OF MOVE LIST ****
A% = 0
FOR I% = 1 TO PLY% - 1
	IF ENGINE%(I%, 1, 0) = 1 THEN A% = A% + 1
NEXT

IF A% = PLY% - 1 AND PLY% > 1 AND PLY% < DEPTH% THEN
	'PRINT "i ENDED HERE"; DEPTH%; PLY%: END
	TEMP1% = ENGINE%(PLY%, 1, 1)
	TEMP2% = ENGINE%(PLY%, 1, 2)
	TEMP3% = ENGINE%(PLY%, 1, 3)
	TEMP4% = ENGINE%(PLY%, 1, 4)
	TEMP5% = ENGINE%(PLY%, 1, 5)

	I% = 0
	DO
		I% = I% + 1
		IF I% > ENGINE%(PLY%, 0, 0) THEN I% = I% - 1: EXIT DO
	  
		F% = 0
		FOR A% = 1 TO 4
			IF ENGINE%(PLY%, I%, A%) = HISTORY%(A%, PLY%) THEN F% = F% + 1
		NEXT
	  
		IF F% = 4 THEN EXIT DO
	LOOP
	  
	'IF F% <> 4 THEN
	'   PRINT "OOPS, I ENDED HERE."
	'   PRINT "ENGINE PLY 1";
	'   FOR AA% = 1 TO 5
	'      PRINT ENGINE%(1, 1, AA%);
	'   NEXT
	'   PRINT
	'   PRINT "HISTORY PLY 1";
	'   FOR AA% = 1 TO 4
	'      PRINT HISTORY%(AA%, 1);
	'   NEXT
	'   PRINT
	'   PRINT "HISTORY PLY "; PLY%;
	'   FOR AA% = 1 TO 4
	'      PRINT HISTORY%(AA%, PLY%);
	'   NEXT
	'   END
	'END IF
  
	FOR A% = 1 TO 5
		ENGINE%(PLY%, 1, A%) = ENGINE%(PLY%, I%, A%)
	NEXT

	ENGINE%(PLY%, I%, 1) = TEMP1%
	ENGINE%(PLY%, I%, 2) = TEMP2%
	ENGINE%(PLY%, I%, 3) = TEMP3%
	ENGINE%(PLY%, I%, 4) = TEMP4%
	ENGINE%(PLY%, I%, 5) = TEMP5%

	'######### TEST CODE ###############
	'PRINT "ENGINE PLY "; PLY%; " - "
	'FOR I% = 1 TO DEPTH%
	'   FOR AA% = 1 TO 5
	'      PRINT ENGINE%(I%, 1, AA%);
	'   NEXT
	'   PRINT
	'NEXT
END IF

RETURN






EVALBOARD:
'************ GIVE THE BOARD A SCORE **************

IF TESTMODE% = 1 THEN NODES = NODES + 1

EVAL% = 0

IF MATEH% > 0 OR MATEC% > 0 THEN
	IF MATEH% = 1 THEN EVAL% = 19000
	IF MATEC% = 1 THEN EVAL% = -19000
	MATEH% = 0
	MATEC% = 0
	IF SIDE% = 1 THEN EVAL% = EVAL% * -1
	RETURN
END IF

GOSUB HEURISTIC01  ' CALCULATE MATERIAL BALANCE

IF ENGINE%(1, 1, 0) > 1 THEN

	' IF THERE IS A LARGE MATERIAL DEFFERNCE COMPARED TO BEST MOVE FOUND SO FAR
	' THEN NO POINT IN CALCULATING POSITIONAL SCORE.  THIS SHOULD
	' IMPROVE SEARCH SPEED. ABOUT 10% IMPROVEMENT IN NPS.

	IF EVAL% < SCORE%(1, 1) - 100 THEN
		IF SIDE% = 1 THEN EVAL% = EVAL% * -1
		RETURN
	END IF
END IF

GOSUB HEURISTIC02
GOSUB HEURISTIC03
GOSUB HEURISTIC06
GOSUB HEURISTIC07
GOSUB HEURISTIC08



IF SIDE% = 1 THEN EVAL% = EVAL% * -1

RETURN

HEURISTIC01:
'******** COUNT THE MATERIAL ON THE BOARD THEN RETURN THE SCORE ******

FOR HY% = 1 TO 8
	FOR HX% = 1 TO 8
		HP% = CB%(HX%, HY%)
		IF HP% > 0 THEN EVAL% = EVAL% - V%(HP%)
		IF HP% < 0 THEN EVAL% = EVAL% + V%(HP% * -1)
	NEXT
NEXT
RETURN

HEURISTIC02:
SCORE% = 0
'****** CASTLING ****************************************************
IF PHASE% = 3 THEN RETURN

'**** CHECK IF CASTLED
IF CB%(1, 9) = 2 OR CB%(2, 9) = 2 THEN
	EVAL% = EVAL% - 10
  
	'**** A BIT OF KING SAFETY
	IF HKY% > 2 THEN
		IF CB%(HKY%, HKY% - 1) = 0 THEN EVAL% = EVAL% + 10

		IF HKX% > 1 THEN
			IF CB%(HKX% - 1, HKY% - 1) = 0 THEN EVAL% = EVAL% + 10
		END IF
	  
		IF HKX% < 8 THEN
			IF CB%(HKX% + 1, HKY% - 1) = 0 THEN EVAL% = EVAL% + 10
		END IF
	END IF

END IF

IF CB%(3, 9) = 2 OR CB%(4, 9) = 2 THEN
	EVAL% = EVAL% + 10

	'**** A BIT OF KING SAFETY
	IF CKY% < 7 THEN
		IF CB%(CKX%, CKY% + 1) = 0 THEN EVAL% = EVAL% - 10
	  
		IF CKX% > 1 THEN
			IF CB%(CKX% - 1, CKY% + 1) = 0 THEN EVAL% = EVAL% - 10
		END IF
		IF CKX% < 8 THEN
			IF CB%(CKX%, CKY% + 1) = 0 THEN EVAL% = EVAL% - 10
		END IF
	END IF
END IF


' **** CHECK IF CASTLING NOT POSSIBLE
IF CB%(1, 9) = 0 AND CB%(2, 9) = 0 THEN EVAL% = EVAL% + 15
IF CB%(3, 9) = 0 AND CB%(4, 9) = 0 THEN EVAL% = EVAL% - 15


RETURN




HEURISTIC03:
'****** KNIGHT POSTION  ********
SCORE% = 0
FOR H3Y% = 1 TO 8
	FOR H3X% = 1 TO 8

		'****** DEVELOP KNIGHT IN OPENNING PHASE
		IF H3Y% = 1 AND PHASE% = 1 THEN
			IF CB%(H3X%, H3Y%) = -2 OR CB%(H3X%, H3Y%) = -3 THEN
				EVAL% = EVAL% - 4
			END IF
		END IF

		IF H3Y% = 8 AND PHASE% = 1 THEN
			IF CB%(H3X%, H3Y%) = 2 OR CB%(H3X%, H3Y%) = 3 THEN
				EVAL% = EVAL% + 4
			END IF
		END IF



		'*******BISHOP POSITION
		IF CB%(H3X%, H3Y%) = -3 THEN
			SCORE% = 0
			GOSUB HEURISTIC04
			EVAL% = EVAL% + SCORE%
		END IF
		IF CB%(H3X%, H3Y%) = 3 THEN
			SCORE% = 0
			GOSUB HEURISTIC05
			EVAL% = EVAL% - SCORE%
		END IF
	  
		'******* KNIGHT POSITION
		IF CB%(H3X%, H3Y%) = -2 THEN
			DX% = 4.5 - (ABS(4.5 - H3X%))
			DY% = 4.5 - (ABS(4.5 - H3Y%))
			SCORE% = DX% + DY%
		  
			IF PHASE% = 3 THEN
				DX% = ABS(HKX% - H3X%)
				DY% = ABS(HKY% - H3Y%)
				IF DX% < 3 AND DY% < 3 THEN SCORE% = SCORE% + 5
			END IF
		  
			IF PHASE% = 2 AND H3Y% = 1 THEN SCORE% = SCORE% - 2
			EVAL% = EVAL% + SCORE%
		END IF
		IF CB%(H3X%, H3Y%) = 2 THEN
			DX% = 4.5 - (ABS(4.5 - H3X%))
			DY% = 4.5 - (ABS(4.5 - H3Y%))
			SCORE% = DX% + DY%
		  
			IF PHASE% = 3 THEN
				DX% = ABS(CKX% - H3X%)
				DY% = ABS(CKY% - H3Y%)
				IF DX% < 3 AND DY% < 3 THEN SCORE% = SCORE% + 5
			END IF
		  
			IF PHASE% = 2 AND H3Y% = 8 THEN SCORE% = SCORE% - 2
			EVAL% = EVAL% - SCORE%
		END IF
	NEXT
NEXT

RETURN

HEURISTIC04:
'******* COMPUTER BISHOP MOBILITY ************************
H4D% = 0
DO
	H4D% = H4D% + 1
	IF H4D% = 5 THEN EXIT DO
	
	H4SQ% = 0

	DO
		H4SQ% = H4SQ% + 1
		IF H4SQ% = 9 THEN EXIT DO

		H4X% = H3X% + PIECE%(3, H4D%, H4SQ%, 1)
		H4Y% = H3Y% + PIECE%(3, H4D%, H4SQ%, 2)

		IF H4X% > 8 OR H4X% < 1 OR H4Y% > 8 OR H4Y% < 1 THEN EXIT DO

		IF CB%(H4X%, H4Y%) = 0 THEN SCORE% = SCORE% + 1

		'IF CB%(H4X%, H4Y%) > 0 THEN SCORE% = SCORE% + 1

		IF PHASE% > 1 THEN
			DISTX% = ABS(HKX% - H4X%)
			DISTY% = ABS(HKY% - H4Y%)
			IF DISTX% < 2 AND DISTY% < 2 THEN SCORE% = SCORE% + 2
		END IF

		IF CB%(H4X%, H4Y%) <> 0 THEN EXIT DO
	LOOP
LOOP

RETURN


HEURISTIC05:
'******* HUMAN BISHOP MOBILITY ************************
H5D% = 0
DO
	H5D% = H5D% + 1
	IF H5D% = 5 THEN EXIT DO
  
	H5SQ% = 0

	DO
		H5SQ% = H5SQ% + 1
		IF H5SQ% = 9 THEN EXIT DO

		H5X% = H3X% + PIECE%(3, H5D%, H5SQ%, 1)
		H5Y% = H3Y% + PIECE%(3, H5D%, H5SQ%, 2)

		IF H5X% > 8 OR H5X% < 1 OR H5Y% > 8 OR H5Y% < 1 THEN EXIT DO

		IF CB%(H5X%, H5Y%) = 0 THEN SCORE% = SCORE% + 1
	  
		'IF CB%(H5X%, H5Y%) < 0 THEN SCORE% = SCORE% + 1

		IF PHASE% > 1 THEN
			DISTX% = ABS(CKX% - H5X%)
			DISTY% = ABS(CKY% - H5Y%)
			IF DISTX% < 2 AND DISTY% < 2 THEN SCORE% = SCORE% + 2
		END IF

		IF CB%(H5X%, H5Y%) <> 0 THEN EXIT DO
	LOOP
LOOP

RETURN

HEURISTIC06:
'***** PAWN STRUCTURE *****

IF PHASE% = 3 THEN
	'******* PAWN PROGRESS FOR END GAME
	FOR TY% = 2 TO 7
	  
		FOR TX% = 1 TO 8
			IF CB%(TX%, TY%) = -1 THEN
				EVAL% = EVAL% + TY%
			END IF
		  
			IF CB%(TX%, TY%) = 1 THEN
				EVAL% = EVAL% - (9 - TY%)
			END IF
		NEXT
  
	NEXT
END IF


FOR I% = 1 TO 8
	PAWN%(I%, 1) = 0: PAWN%(I%, 2) = 0
NEXT

FOR TY% = 1 TO 8
	FOR TX% = 1 TO 8
	  
		IF CB%(TX%, TY%) = -1 THEN PAWN%(TX%, 1) = PAWN%(TX%, 1) + 1
		IF CB%(TX%, TY%) = 1 THEN PAWN%(TX%, 2) = PAWN%(TX%, 2) + 1
	 
		'**** QUEEN EVALUATION
		IF CB%(TX%, TY%) = 5 OR CB%(TX%, TY%) = -5 THEN GOSUB HEURISTIC09

		'***** PASSED PAWN
		IF PHASE% > 1 AND CB%(TX%, TY%) = -1 THEN
				IF TY% > 3 THEN
					A% = TY%
					DO
						TEMP1% = CB%(TX% - 1, A% + 1)
						TEMP2% = CB%(TX%, A%)
						TEMP3% = CB%(TX% + 1, A% + 1)
						IF TEMP1% = 1 OR TEMP2% = 1 OR TEMP3% = 1 THEN PASSED% = 0: EXIT DO
						IF A% = 7 THEN PASSED% = 1: EXIT DO
						A% = A% + 1
					LOOP

					IF PASSED% = 1 THEN EVAL% = EVAL% + (TY% * 4)
				END IF
		END IF
		IF PHASE% > 1 AND CB%(TX%, TY%) = 1 THEN
				IF TY% < 6 THEN
					A% = TY%
					DO
						TEMP1% = CB%(TX% - 1, A% - 1)
						TEMP2% = CB%(TX%, A%)
						TEMP3% = CB%(TX% + 1, A% - 1)
						IF TEMP1% = -1 OR TEMP2% = -1 OR TEMP3% = -1 THEN PASSED% = 0: EXIT DO
						IF A% = 2 THEN PASSED% = 1: EXIT DO
						A% = A% - 1
					LOOP

					IF PASSED% = 1 THEN EVAL% = EVAL% - ((9 - TY%) * 4)
				END IF
		END IF


		'******* KING SIDE PAWN
		IF PHASE% <> 3 THEN
			IF TX% > 5 THEN
				IF CB%(3, 9) = 1 THEN
					IF TY% > 3 AND CB%(TX%, TY%) = -1 THEN EVAL% = EVAL% - 6
					'IF TY% = 3 AND CB%(TX%, TY%) = -1 THEN EVAL% = EVAL% - 2
				END IF
				IF CB%(1, 9) = 1 THEN
					IF TY% < 6 AND CB%(TX%, TY%) = 1 THEN EVAL% = EVAL% + 6
					'IF TY% = 6 AND CB%(TX%, TY%) = 1 THEN EVAL% = EVAL% + 2
				END IF
			END IF
		END IF

		IF PHASE% = 1 AND TX% = 4 THEN
			'****MOVE CENTRE PAWNS OUT DURING OPENNING PHASE
			IF TY% = 2 AND CB%(4, TY%) = -1 THEN EVAL% = EVAL% - 4
			IF TY% = 2 AND CB%(5, TY%) = -1 THEN EVAL% = EVAL% - 4
			IF TY% = 7 AND CB%(4, TY%) = 1 THEN EVAL% = EVAL% + 4
			IF TY% = 7 AND CB%(5, TY%) = 1 THEN EVAL% = EVAL% + 4
		END IF

		IF PHASE% < 3 THEN
			'*** OVER AMBISHOUS PAWN
			IF CB%(TX%, TY%) = -1 AND TY% > 5 THEN
				EVAL% = EVAL% - 4
				IF TX% > 1 AND TX% < 8 THEN
					IF CB%(TX% - 1, TY% - 1) = -1 OR CB%(TX% + 1, TY% - 1) = -1 THEN EVAL% = EVAL% + 9
				END IF
			END IF
		  
			IF CB%(TX%, TY%) = 1 AND TY% < 4 THEN
				EVAL% = EVAL% + 4
				IF TX% > 1 AND TX% < 8 THEN
					IF CB%(TX% - 1, TY% + 1) = 1 OR CB%(TX% + 1, TY% + 1) = 1 THEN EVAL% = EVAL% - 9
				END IF
			END IF

		END IF
  
	NEXT
NEXT

'***** DOUBLED PAWNS
FOR I% = 1 TO 8
	IF PAWN%(I%, 1) > 1 THEN EVAL% = EVAL% - (15 + PAWN%(I%, 1))
	IF PAWN%(I%, 2) > 1 THEN EVAL% = EVAL% + (15 + PAWN%(I%, 2))

	'****** MISSING KING SIDE PAWN DURING OPENING AND MIDDLE GAME
	IF I% > 5 AND PHASE% < 3 THEN
		IF PAWN%(I%, 1) = 0 AND CB%(3, 9) = 1 THEN EVAL% = EVAL% - 6
		IF PAWN%(I%, 2) = 0 AND CB%(1, 9) = 1 THEN EVAL% = EVAL% + 6
	END IF
NEXT

IF PHASE% = 3 THEN RETURN

' ******** ISOLATED PAWNS
FOR I% = 2 TO 7
	IF PAWN%(I%, 1) > 0 THEN
		IF PAWN%(I% - 1, 1) = 0 AND PAWN%(I% + 1, 1) = 0 THEN EVAL% = EVAL% - 10
	END IF
	IF PAWN%(I%, 2) > 0 THEN
		IF PAWN%(I% - 1, 2) = 0 AND PAWN%(I% + 1, 2) = 0 THEN EVAL% = EVAL% + 10
	END IF
NEXT
IF PAWN%(1, 1) > 0 AND PAWN%(2, 1) = 0 THEN EVAL% = EVAL% - 10
IF PAWN%(8, 1) > 0 AND PAWN%(7, 1) = 0 THEN EVAL% = EVAL% - 10
IF PAWN%(1, 2) > 0 AND PAWN%(2, 2) = 0 THEN EVAL% = EVAL% + 10
IF PAWN%(8, 2) > 0 AND PAWN%(7, 2) = 0 THEN EVAL% = EVAL% + 10

RETURN


HEURISTIC07:
'******* ROOK MOBILITY ETC ************************
IF PHASE% = 1 THEN RETURN

FOR TY% = 1 TO 8
	FOR TX% = 1 TO 8
		IF CB%(TX%, TY%) = -4 THEN
			GOSUB SUBHEUR07
			
			IF TY% = 7 THEN SCORE% = SCORE% + 6
			EVAL% = EVAL% + SCORE%
		END IF

		IF CB%(TX%, TY%) = 4 THEN
			GOSUB SUBHEUR07
			
			IF TY% = 2 THEN SCORE% = SCORE% + 6
			EVAL% = EVAL% - SCORE%
		END IF
	NEXT
NEXT

RETURN

SUBHEUR07:
SCORE% = 0
H7D% = 0
DO
	H7D% = H7D% + 1
	IF H7D% = 5 THEN EXIT DO
  
	H7SQ% = 0

	DO
		H7SQ% = H7SQ% + 1
		IF H7SQ% = 9 THEN EXIT DO

		H7X% = TX% + PIECE%(4, H7D%, H7SQ%, 1)
		H7Y% = TY% + PIECE%(4, H7D%, H7SQ%, 2)

		IF H7X% > 8 OR H7X% < 1 OR H7Y% > 8 OR H7Y% < 1 THEN EXIT DO

		IF CB%(H7X%, H7Y%) = 0 THEN SCORE% = SCORE% + 1

		IF CB%(H7X%, H7Y%) <> 0 THEN
			IF CB%(TX%, TY%) < 0 AND CB%(H7X%, H7Y%) > 0 THEN SCORE% = SCORE% + 1
			IF CB%(TX%, TY%) > 0 AND CB%(H7X%, H7Y%) < 0 THEN SCORE% = SCORE% + 1
		END IF
	  
		IF CB%(TX%, TY%) < 0 THEN
			DISTX% = ABS(HKX% - H7X%)
			DISTY% = ABS(HKY% - H7Y%)
			IF DISTX% < 2 AND DISTY% < 2 THEN SCORE% = SCORE% + 2
		END IF
		
		IF CB%(TX%, TY%) > 0 THEN
			DISTX% = ABS(CKX% - H7X%)
			DISTY% = ABS(CKY% - H7Y%)
			IF DISTX% < 2 AND DISTY% < 2 THEN SCORE% = SCORE% + 2
		END IF
	  
		IF CB%(H7X%, H7Y%) = CB%(TX%, TY%) THEN SCORE% = SCORE% + 3

		IF CB%(H7X%, H7Y%) <> 0 THEN EXIT DO
	LOOP
LOOP

RETURN

HEURISTIC08:
'*** KING TOWARDS CENTRE OF BOARD DURING END GAME
IF PHASE% <> 3 THEN RETURN

DX% = 4.5 - (ABS(4.5 - CKX%))
DY% = 4.5 - (ABS(4.5 - CKY%))
EVAL% = EVAL% + ((DX% + DY%) / 2)


DX% = 4.5 - (ABS(4.5 - HKX%))
DY% = 4.5 - (ABS(4.5 - HKY%))
EVAL% = EVAL% - ((DX% + DY%) / 2)

RETURN

HEURISTIC09:
'**** ENCOURAGE THE QUEEN TO BE CLOSE TO THE ENEMY KING
IF PHASE% = 1 THEN RETURN

IF CB%(TX%, TY%) = -5 THEN
	QDX% = ABS(HKX% - TX%)
	QDY% = ABS(HKY% - TY%)
	EVAL% = EVAL% + (14 - (QDX% + QDY%))
END IF

IF CB%(TX%, TY%) = 5 THEN
	QDX% = ABS(CKX% - TX%)
	QDY% = ABS(CKY% - TY%)
	EVAL% = EVAL% - (14 - (QDX% + QDY%))
END IF

RETURN

HMAKEMOVE:
'***** COMPUTER MAKE MOVE *****
X% = HMOVES%(1, M%)
Y% = HMOVES%(2, M%)
XX% = HMOVES%(3, M%)
YY% = HMOVES%(4, M%)
SPECIAL% = HMOVES%(6, M%)

GOSUB MAKEMOVE

RETURN

CMAKEMOVE:
'***** COMPUTER MAKE MOVE *****
X% = CMOVES%(1, M%)
Y% = CMOVES%(2, M%)
XX% = CMOVES%(3, M%)
YY% = CMOVES%(4, M%)
SPECIAL% = CMOVES%(6, M%)

GOSUB MAKEMOVE

RETURN

MAKEMOVE:
'***** PHYSICALLY MAKES THE MOVE ON THE BOARD (CB%) ************

P% = CB%(X%, Y%)

'**** MOVE THE PIECE
CB%(XX%, YY%) = CB%(X%, Y%)
CB%(X%, Y%) = 0

'**** UPDATE THE KING POSITION
IF CB%(XX%, YY%) = -6 THEN CKX% = XX%: CKY% = YY%
IF CB%(XX%, YY%) = 6 THEN HKX% = XX%: HKY% = YY%


'**** RECORD THE LAST MOVE ON THE BOARD
CB%(5, 9) = X%: CB%(6, 9) = Y%
CB%(7, 9) = XX%: CB%(8, 9) = YY%


'**** IF KING MOVES THEN CANCEL ALL CASTLING
IF P% = -6 THEN CB%(3, 9) = 0: CB%(4, 9) = 0
IF P% = 6 THEN CB%(1, 9) = 0: CB%(2, 9) = 0


'***** IF QUEEN SIDE ROOK MOVES THEN CANCEL LONG CASTLE
IF P% = -4 AND X% = 1 AND Y% = 1 THEN
	CB%(4, 9) = 0
END IF
IF P% = 4 AND X% = 1 AND Y% = 8 THEN
	CB%(2, 9) = 0
END IF


'***** IF KING SIDE ROOK MOVES THEN CANCEL SHORT CASTLE
IF P% = -4 AND X% = 8 AND Y% = 1 THEN
	CB%(3, 9) = 0
END IF
IF P% = 4 AND X% = 8 AND Y% = 8 THEN
	CB%(1, 9) = 0
END IF

'***** EN PASSANT
IF SPECIAL% = 7 THEN
	IF P% < 0 THEN
		CB%(XX%, YY% - 1) = 0
	END IF
	IF P% > 0 THEN
		CB%(XX%, YY% + 1) = 0
	END IF
END IF

'***** SHORT CASTLE
IF SPECIAL% = 1 THEN
	IF P% < 0 THEN
		CB%(8, 1) = 0
		CB%(6, 1) = -4
		CB%(3, 9) = 2
	END IF
	IF P% > 0 THEN
		CB%(8, 8) = 0
		CB%(6, 8) = 4
		CB%(1, 9) = 2
	END IF
END IF

'***** LONG CASTLE
IF SPECIAL% = 2 THEN
	IF P% < 0 THEN
		CB%(1, 1) = 0
		CB%(4, 1) = -4
		CB%(4, 9) = 2
	END IF
	IF P% > 0 THEN
		CB%(1, 8) = 0
		CB%(4, 8) = 4
		CB%(2, 9) = 2
	END IF
END IF

'******* PAWN PROMOTION
IF SPECIAL% > 2 AND SPECIAL% < 7 THEN
	IF P% < 0 THEN
		IF SPECIAL% = 3 THEN CB%(XX%, YY%) = -2
		IF SPECIAL% = 4 THEN CB%(XX%, YY%) = -3
		IF SPECIAL% = 5 THEN CB%(XX%, YY%) = -4
		IF SPECIAL% = 6 THEN CB%(XX%, YY%) = -5
	END IF
	IF P% > 0 THEN
		IF SPECIAL% = 3 THEN CB%(XX%, YY%) = 2
		IF SPECIAL% = 4 THEN CB%(XX%, YY%) = 3
		IF SPECIAL% = 5 THEN CB%(XX%, YY%) = 4
		IF SPECIAL% = 6 THEN CB%(XX%, YY%) = 5
	END IF
END IF

RETURN

HMOVELIST:
' *** GENERATES LIST OF LEGAL MOVES IN HMOVES% **************

HMOVES%(0, 0) = 0
SPECIAL% = 0

FOR Y% = 1 TO 8
	FOR X% = 1 TO 8
		IF CB%(X%, Y%) > 0 THEN GOSUB HCHECKMOVE
	NEXT
NEXT

HCHECK% = 0
RETURN

HCHECKMOVE:
'**** CHECK TO MAKE MOVE ******
P% = CB%(X%, Y%)
D% = 0

'**** ONLY DO THIS BIT IF PIECE IS NOT A PAWN
IF P% > 1 THEN
	DO
		D% = D% + 1
		IF D% > 16 THEN EXIT DO
		SQ% = 0

		DO
			SQ% = SQ% + 1
			IF SQ% > 8 THEN EXIT DO
			IF PIECE%(P%, D%, SQ%, 1) = 0 AND PIECE%(P%, D%, SQ%, 2) = 0 THEN EXIT DO

			XX% = X% + PIECE%(P%, D%, SQ%, 1)
			YY% = Y% + PIECE%(P%, D%, SQ%, 2)

			IF XX% < 1 OR XX% > 8 THEN EXIT DO
			IF YY% < 1 OR YY% > 8 THEN EXIT DO
		 
			DQ% = CB%(XX%, YY%)

			IF DQ% < 1 THEN GOSUB HADDTOLIST

			IF DQ% <> 0 THEN EXIT DO
		LOOP
	LOOP
END IF

IF P% > 1 AND P% < 6 THEN RETURN

IF P% = 1 THEN
	'****** PAWN LEGAL MOVE ********
 
	' JUMP TWO SQUARES FROM STARTING ROW
	IF Y% = 7 THEN
		XX% = X%: YY% = Y% - 2
		IF CB%(XX%, YY%) = 0 AND CB%(XX%, YY% + 1) = 0 THEN GOSUB HADDTOLIST
	END IF

	' EN PASSANT
	IF CB%(CB%(7, 9), CB%(8, 9)) = -1 AND Y% = 4 AND CB%(8, 9) = 4 THEN
		IF X% - 1 = CB%(7, 9) THEN
			IF CB%(6, 9) = 2 THEN
				XX% = X% - 1: YY% = Y% - 1: SPECIAL% = 7
				GOSUB HADDTOLIST
			END IF
		END IF
		IF X% + 1 = CB%(7, 9) THEN
			IF CB%(6, 9) = 2 THEN
				XX% = X% + 1: YY% = Y% - 1: SPECIAL% = 7
				GOSUB HADDTOLIST
			END IF
		END IF
	END IF
			  
 
	' PAWN PROMOTION
	XX% = X%: YY% = Y% - 1
	IF CB%(XX%, YY%) = 0 THEN
		IF YY% = 1 THEN
			SPECIAL% = 6: GOSUB HADDTOLIST
			SPECIAL% = 5: GOSUB HADDTOLIST
			SPECIAL% = 4: GOSUB HADDTOLIST
			SPECIAL% = 3: GOSUB HADDTOLIST
		END IF
		' NORMAL MOVE ONE SQUARE FORWARD
		IF YY% > 1 THEN GOSUB HADDTOLIST
	END IF

	' PAWN TAKE ENEMY PIECE
	XX% = X% - 1: YY% = Y% - 1
	IF XX% > 0 THEN
		IF YY% = 1 AND CB%(XX%, YY%) < 0 THEN
			SPECIAL% = 6: GOSUB HADDTOLIST
			SPECIAL% = 5: GOSUB HADDTOLIST
			SPECIAL% = 4: GOSUB HADDTOLIST
			SPECIAL% = 3: GOSUB HADDTOLIST
		END IF
		IF CB%(XX%, YY%) < 0 AND YY% <> 1 THEN GOSUB HADDTOLIST
	END IF

	XX% = X% + 1: YY% = Y% - 1
	IF XX% < 9 THEN
		IF YY% = 1 AND CB%(XX%, YY%) < 0 THEN
			SPECIAL% = 6: GOSUB HADDTOLIST
			SPECIAL% = 5: GOSUB HADDTOLIST
			SPECIAL% = 4: GOSUB HADDTOLIST
			SPECIAL% = 3: GOSUB HADDTOLIST
		END IF
		IF CB%(XX%, YY%) < 0 AND YY% <> 1 THEN GOSUB HADDTOLIST
	END IF
END IF

' CASTLING
IF P% = 6 AND X% = 5 AND Y% = 8 THEN
	'SHORT CASTLE
	IF CB%(1, 9) = 1 THEN
		IF CB%(6, 8) = 0 AND CB%(7, 8) = 0 AND CB%(8, 8) = 4 THEN
		 
			HKX% = 5: HKY% = 8
			GOSUB HKINGCHECK
			CSQ1% = HCHECK%

			HKX% = 6: HKY% = 8
			GOSUB HKINGCHECK
			CSQ2% = HCHECK%

			HKX% = 7: HKY% = 8
			GOSUB HKINGCHECK
			CSQ3% = HCHECK%

			HKX% = 5: HKY% = 8

			IF CSQ1% = 0 AND CSQ2% = 0 AND CSQ3% = 0 THEN
				XX% = 7: YY% = 8: SPECIAL% = 1
				GOSUB HADDTOLIST
			END IF
		END IF
	END IF
 
	' LONG CASTLE
	IF CB%(2, 9) = 1 THEN
		IF CB%(4, 8) = 0 AND CB%(3, 8) = 0 AND CB%(2, 8) = 0 AND CB%(1, 8) = 4 THEN
		 
			HKX% = 5: HKY% = 8
			GOSUB HKINGCHECK
			CSQ1% = HCHECK%

			HKX% = 4: HKY% = 8
			GOSUB HKINGCHECK
			CSQ2% = HCHECK%

			HKX% = 3: HKY% = 8
			GOSUB HKINGCHECK
			CSQ3% = HCHECK%

			HKX% = 5: HKY% = 8
		  
			IF CSQ1% = 0 AND CSQ2% = 0 AND CSQ3% = 0 THEN
				XX% = 3: YY% = 8: SPECIAL% = 2
				GOSUB HADDTOLIST
			END IF
		END IF
	END IF
END IF

HCHECK% = 0
RETURN

HADDTOLIST:
'******* ADD MOVE TO LEGAL MOVE LIST ***********
GOSUB CHECKHPIN
IF HPIN% = 1 THEN SPECIAL% = 0: RETURN

R% = HMOVES%(0, 0)
R% = R% + 1
HMOVES%(1, R%) = X%
HMOVES%(2, R%) = Y%
HMOVES%(3, R%) = XX%
HMOVES%(4, R%) = YY%
HMOVES%(5, R%) = CB%(XX%, YY%)
HMOVES%(6, R%) = SPECIAL%
HMOVES%(0, 0) = R%

IF SPECIAL% = 7 THEN HMOVES%(5, R%) = -1

SPECIAL% = 0

RETURN


CHECKHPIN:
'** BEFORE ADDING TO LEGAL MOVE LIST, CHECK TO MAKE SURE KING IS NOT IN CHECK
HPIN% = 0

P1% = CB%(XX%, YY%)
CB%(XX%, YY%) = CB%(X%, Y%): CB%(X%, Y%) = 0
IF SPECIAL% = 7 THEN CB%(XX%, YY% + 1) = 0

IF CB%(XX%, YY%) = 6 THEN HKX% = XX%: HKY% = YY%

GOSUB HKINGCHECK

HPIN% = HCHECK%

CB%(X%, Y%) = CB%(XX%, YY%): CB%(XX%, YY%) = P1%
IF SPECIAL% = 7 THEN CB%(XX%, YY% + 1) = -1

IF CB%(X%, Y%) = 6 THEN HKX% = X%: HKY% = Y%

RETURN





CMOVELIST:
' *** GENERATES LIST OF LEGAL MOVES IN CMOVES% **************

CMOVES%(0, 0) = 0
SPECIAL% = 0

FOR Y% = 8 TO 1 STEP -1
	FOR X% = 8 TO 1 STEP -1
		IF CB%(X%, Y%) < 0 THEN GOSUB CCHECKMOVE
	NEXT
NEXT

CCHECK% = 0
RETURN

CCHECKMOVE:
'**** CHECK TO MAKE MOVE ******
D% = 0
P% = ABS(CB%(X%, Y%))

'**** ONLY DO THIS BIT IF PIECE IS NOT A PAWN
IF P% > 1 THEN
	DO
		D% = D% + 1
		IF D% > 16 THEN EXIT DO
		SQ% = 0

		DO
			SQ% = SQ% + 1
			IF SQ% > 8 THEN EXIT DO
			IF PIECE%(P%, D%, SQ%, 1) = 0 AND PIECE%(P%, D%, SQ%, 2) = 0 THEN EXIT DO

			XX% = X% + PIECE%(P%, D%, SQ%, 1)
			YY% = Y% + PIECE%(P%, D%, SQ%, 2)

			IF XX% < 1 OR XX% > 8 THEN EXIT DO
			IF YY% < 1 OR YY% > 8 THEN EXIT DO
		  
			DQ% = CB%(XX%, YY%)

			IF DQ% > -1 THEN GOSUB CADDTOLIST

			IF DQ% <> 0 THEN EXIT DO
		LOOP
	LOOP
END IF

IF P% > 1 AND P% < 6 THEN RETURN

CPAWNMOVE:
'****** PAWN LEGAL MOVE ********
  
' JUMP TWO SQUARES FROM STARTING ROW
IF P% = 1 THEN
	IF Y% = 2 THEN
		XX% = X%: YY% = Y% + 2
		IF CB%(XX%, YY%) = 0 AND CB%(XX%, YY% - 1) = 0 THEN GOSUB CADDTOLIST
	END IF

	' ENPASSANT
	IF CB%(CB%(7, 9), CB%(8, 9)) = 1 AND Y% = 5 AND CB%(8, 9) = 5 THEN
		IF X% - 1 = CB%(7, 9) THEN
			IF CB%(6, 9) = 7 THEN
				XX% = X% - 1: YY% = Y% + 1: SPECIAL% = 7
				GOSUB CADDTOLIST
			END IF
		END IF
		IF X% + 1 = CB%(7, 9) THEN
			IF CB%(6, 9) = 7 THEN
				XX% = X% + 1: YY% = Y% + 1: SPECIAL% = 7
				GOSUB CADDTOLIST
			END IF
		END IF
	END IF
					
  
		' PAWN PROMOTION
	XX% = X%: YY% = Y% + 1
	IF CB%(XX%, YY%) = 0 THEN
		IF YY% = 8 THEN
			SPECIAL% = 6: GOSUB CADDTOLIST
			SPECIAL% = 5: GOSUB CADDTOLIST
			SPECIAL% = 4: GOSUB CADDTOLIST
			SPECIAL% = 3: GOSUB CADDTOLIST
		END IF
		' NORMAL MOVE ONE SQUARE FORWARD
		IF YY% < 8 THEN GOSUB CADDTOLIST
	END IF

	' PAWN TAKE ENEMY PIECE
	XX% = X% - 1: YY% = Y% + 1
	IF XX% > 0 THEN
		IF YY% = 8 AND CB%(XX%, YY%) > 0 THEN
			SPECIAL% = 6: GOSUB CADDTOLIST
			SPECIAL% = 5: GOSUB CADDTOLIST
			SPECIAL% = 4: GOSUB CADDTOLIST
			SPECIAL% = 3: GOSUB CADDTOLIST
		END IF
		IF CB%(XX%, YY%) > 0 AND YY% <> 8 THEN GOSUB CADDTOLIST
	END IF

	XX% = X% + 1: YY% = Y% + 1
	IF XX% < 9 THEN
		IF YY% = 8 AND CB%(XX%, YY%) > 0 THEN
			SPECIAL% = 6: GOSUB CADDTOLIST
			SPECIAL% = 5: GOSUB CADDTOLIST
			SPECIAL% = 4: GOSUB CADDTOLIST
			SPECIAL% = 3: GOSUB CADDTOLIST
		END IF
		IF CB%(XX%, YY%) > 0 AND YY% <> 8 THEN GOSUB CADDTOLIST
	END IF
END IF

' CASTLING
IF X% = 5 AND Y% = 1 THEN
	'SHORT CASTLE
	IF CB%(3, 9) = 1 THEN
		IF CB%(6, 1) = 0 AND CB%(7, 1) = 0 AND CB%(8, 1) = -4 THEN
		  
			CKX% = 5: CKY% = 1
			GOSUB CKINGCHECK
			CSQ1% = CCHECK%

			CKX% = 6: CKY% = 1
			GOSUB CKINGCHECK
			CSQ2% = CCHECK%

			CKX% = 7: CKY% = 1
			GOSUB CKINGCHECK
			CSQ3% = CCHECK%

			CKX% = 5: CKY% = 1

			IF CSQ1% = 0 AND CSQ2% = 0 AND CSQ3% = 0 THEN
				XX% = 7: YY% = 1: SPECIAL% = 1
				GOSUB CADDTOLIST
			END IF
		END IF
	END IF
  
	' LONG CASTLE
	IF CB%(4, 9) = 1 THEN
		IF CB%(4, 1) = 0 AND CB%(3, 1) = 0 AND CB%(2, 1) = 0 AND CB%(1, 1) = -4 THEN
		  
			CKX% = 5: CKY% = 1
			GOSUB CKINGCHECK
			CSQ1% = CCHECK%

			CKX% = 4: CKY% = 1
			GOSUB CKINGCHECK
			CSQ2% = CCHECK%

			CKX% = 3: CKY% = 1
			GOSUB CKINGCHECK
			CSQ3% = CCHECK%

			CKX% = 5: CKY% = 1
			
			IF CSQ1% = 0 AND CSQ2% = 0 AND CSQ3% = 0 THEN
				XX% = 3: YY% = 1: SPECIAL% = 2
				GOSUB CADDTOLIST
			END IF
		END IF
	END IF
END IF

RETURN

CADDTOLIST:
'******* ADD MOVE TO LEGAL MOVE LIST ***********
GOSUB CHECKCPIN
IF CPIN% = 1 THEN SPECIAL% = 0: RETURN

R% = CMOVES%(0, 0)
R% = R% + 1
CMOVES%(1, R%) = X%
CMOVES%(2, R%) = Y%
CMOVES%(3, R%) = XX%
CMOVES%(4, R%) = YY%
CMOVES%(5, R%) = CB%(XX%, YY%)
CMOVES%(6, R%) = SPECIAL%
CMOVES%(0, 0) = R%

IF SPECIAL% = 7 THEN CMOVES%(5, R%) = 1

SPECIAL% = 0
RETURN


CHECKCPIN:
'** BEFORE ADDING TO LEGAL MOVE LIST, CHECK TO MAKE SURE KING IS NOT IN CHECK
CPIN% = 0

P1% = CB%(XX%, YY%)
CB%(XX%, YY%) = CB%(X%, Y%): CB%(X%, Y%) = 0
IF SPECIAL% = 7 THEN CB%(XX%, YY% - 1) = 0

IF CB%(XX%, YY%) = -6 THEN CKX% = XX%: CKY% = YY%

GOSUB CKINGCHECK

CPIN% = CCHECK%

CB%(X%, Y%) = CB%(XX%, YY%): CB%(XX%, YY%) = P1%
IF SPECIAL% = 7 THEN CB%(XX%, YY% - 1) = 1

IF CB%(X%, Y%) = -6 THEN CKX% = X%: CKY% = Y%

RETURN




HKINGCHECK:
'******* RETURNS 1 IF HUMAN KING IS IN CHECK **************************

HCHECK% = 0: HD% = 0

DO
	IF HCHECK% = 1 THEN EXIT DO
	HD% = HD% + 1
	IF HD% > 16 THEN EXIT DO
	HSQ% = 0

	DO
		HSQ% = HSQ% + 1
		IF HSQ% = 9 THEN EXIT DO
		
		HX% = HKX% + PIECE%(7, HD%, HSQ%, 1)
		HY% = HKY% + PIECE%(7, HD%, HSQ%, 2)
		IF HX% < 1 OR HX% > 8 OR HY% < 1 OR HY% > 8 THEN EXIT DO
		IF HD% > 8 AND HSQ% > 1 THEN EXIT DO

		EP% = CB%(HX%, HY%)
		IF EP% > 0 THEN EXIT DO

		IF HSQ% = 1 AND HD% < 9 AND EP% = -6 THEN HCHECK% = 1

		IF HD% < 5 THEN
			IF EP% = -3 OR EP% = -5 THEN HCHECK% = 1
		END IF
		IF HD% > 4 AND HD% < 9 THEN
			IF EP% = -4 OR EP% = -5 THEN HCHECK% = 1
		END IF
		IF HD% > 8 THEN
			IF EP% = -2 THEN HCHECK% = 1
		END IF

		IF HCHECK% = 1 THEN EXIT DO
		IF EP% <> 0 THEN EXIT DO

	LOOP
LOOP

HX% = HKX% - 1: HY% = HKY% - 1
IF HX% > 0 AND HY% > 1 THEN
	IF CB%(HX%, HY%) = -1 THEN HCHECK% = 1
END IF

HX% = HKX% + 1: HY% = HKY% - 1
IF HX% < 9 AND HY% > 1 THEN
	IF CB%(HX%, HY%) = -1 THEN HCHECK% = 1
END IF

RETURN




CKINGCHECK:
'******* RETURNS 1 IF COMPUTER KING IS IN CHECK **************************
CCHECK% = 0: CD% = 0

DO
	IF CCHECK% = 1 THEN EXIT DO
	CD% = CD% + 1
	IF CD% > 16 THEN EXIT DO
	CSQ% = 0

	DO
		CSQ% = CSQ% + 1
		IF CSQ% = 9 THEN EXIT DO
		CX% = CKX% + PIECE%(7, CD%, CSQ%, 1)
		CY% = CKY% + PIECE%(7, CD%, CSQ%, 2)
		IF CX% < 1 OR CX% > 8 OR CY% < 1 OR CY% > 8 THEN EXIT DO
		IF CD% > 8 AND CSQ% > 1 THEN EXIT DO

		EP% = CB%(CX%, CY%)
		IF EP% < 0 THEN EXIT DO

		IF CSQ% = 1 AND CD% < 9 AND EP% = 6 THEN CCHECK% = 1

		IF CD% < 5 THEN
			IF EP% = 3 OR EP% = 5 THEN CCHECK% = 1
		END IF
		IF CD% > 4 AND CD% < 9 THEN
			IF EP% = 4 OR EP% = 5 THEN CCHECK% = 1
		END IF
		IF CD% > 8 THEN
			IF EP% = 2 THEN CCHECK% = 1
		END IF

		IF CCHECK% = 1 THEN EXIT DO
		IF EP% <> 0 THEN EXIT DO

	LOOP
LOOP

CX% = CKX% + -1: CY% = CKY% + 1
IF CX% > 0 AND CY% < 8 THEN
	IF CB%(CX%, CY%) = 1 THEN CCHECK% = 1
END IF

CX% = CKX% + 1: CY% = CKY% + 1
IF CX% < 9 AND CY% < 8 THEN
	IF CB%(CX%, CY%) = 1 THEN CCHECK% = 1
END IF

RETURN



COPYCB2BO:
'******************** COPY THE BOARD TO DISPLAY BOARD (COPY CB% TO BO%)

FOR Y% = 1 TO 9
	FOR X% = 1 TO 8
		BO%(X%, Y%) = CB%(X%, Y%)
	NEXT
NEXT
RETURN


COPYBOARD:
'******************** COPY THE BOARD TO TEMP BOARD (COPY BOARD- CB%)

FOR Y% = 1 TO 9
	FOR X% = 1 TO 8
		IF CB%(X%, Y%) <> BO%(X%, Y%) THEN
			CB%(X%, Y%) = BO%(X%, Y%)
		END IF
	NEXT
NEXT
RETURN


FINDKINGS:
'**** FIND AND RETURN XY COORDINATES OF BOTH KINGS ***********
FOR Y% = 1 TO 8
	FOR X% = 1 TO 8
		IF CB%(X%, Y%) = -6 THEN CKX% = X%: CKY% = Y%
		IF CB%(X%, Y%) = 6 THEN HKX% = X%: HKY% = Y%
	NEXT
NEXT
RETURN


INITBOARD:
'******************************************************************
' Initialise the board
'******************************************************************
FOR Y = 1 TO 9
	FOR X = 1 TO 8
		BO%(X, Y) = 0
	NEXT
NEXT
FOR X = 1 TO 8: BO%(X, 2) = -1: BO%(X, 7) = 1: NEXT
BO%(1, 1) = -4: BO%(8, 1) = -4: BO%(2, 1) = -2: BO%(7, 1) = -2
BO%(3, 1) = -3: BO%(6, 1) = -3: BO%(4, 1) = -5: BO%(5, 1) = -6
FOR X = 1 TO 8: BO%(X, 8) = BO%(X, 1) * -1: NEXT

FOR I = 1 TO 4: BO%(I, 9) = 1: BO%(I + 4, 9) = 0: NEXT

'**** TEST POSITION - 218 LEGAL MOVES!! ******
'BO%(1, 8) = -6: BO%(6, 8) = 6
'BO%(2, 8) = 3: BO%(3, 8) = 2
'BO%(4, 8) = 2: BO%(7, 8) = 3
'BO%(1, 7) = -1: BO%(2, 7) = -1
'BO%(4, 7) = 5: BO%(1, 6) = 5
'BO%(6, 6) = 5: BO%(3, 5) = 5
'BO%(8, 5) = 5: BO%(5, 4) = 5
'BO%(2, 3) = 5: BO%(7, 3) = 5
'BO%(4, 2) = 5: BO%(1, 1) = 4
'BO%(8, 1) = 4



RETURN

'DRAWBOARD:
'FOR Y = 1 TO 8
'   FOR x = 1 TO 8
'      COLOR 8
'
'      IF (x + Y) / 2 = INT((x + Y) / 2) THEN COLOR 7
'      LINE ((x * 16) + 12, (Y * 16) + 28)-((x * 16) + 28, (Y * 16) + 44), , BF
'
'   NEXT
'NEXT

'GOSUB TMPDRAW
'RETURN
'END


'DRAWPIECES:
'FOR Y = 1 TO 8
'   FOR x = 1 TO 8
'      COLOR 7
'      IF BO%(x, Y) < 0 THEN COLOR 1
'      P$ = ""
'      P$ = P$(ABS(BO%(x, Y)))
'      LOCATE (Y * 2) + 5, (x * 2) + 3: PRINT P$
'   NEXT
'NEXT

'COLOR 4
'LOCATE 5, 4: PRINT " a b c d e f g h "
'FOR Y = 1 TO 8: LOCATE (Y * 2) + 5, 3: PRINT MID$(STR$(9 - Y), 2, 1): NEXT
'
'COLOR 9
'LOCATE 2, 15: PRINT "Deep BASIC"
'COLOR 1
'LINE (110, 20)-(192, 20)
'LINE (60, 0)-(240, 27), , B
'RETURN
'
'TMPDRAW:
'
'FOR Y = 1 TO 8
'   FOR x = 1 TO 8
'      COLOR 7
'      IF BO%(x, Y) < 0 THEN COLOR 1
'      P$ = "."
'      IF BO%(x, Y) <> 0 THEN P$ = P$(ABS(BO%(x, Y)))
'      LOCATE (Y * 2), (x * 3): PRINT P$
'   NEXT
'NEXT
'RETURN
'
'END
'

DRAWCBBOARD:

FOR Y = 1 TO 8
	FOR X = 1 TO 8
		COLOR 7
		IF CB%(X, Y) < 0 THEN COLOR 1
		P$ = "."
		IF CB%(X, Y) <> 0 THEN P$ = P$(ABS(CB%(X, Y)))
		LOCATE (Y * 2), (X * 3): PRINT P$
	NEXT
NEXT
RETURN


SCNCLR:
'*******************************************************************************
'       THIS WILL CLEAR THE SCREEN AND DRAW A BORDER AROUND IT.
'*******************************************************************************

CLS
COLOR 8
PRINT CHR$(201);
FOR I = 1 TO 38: PRINT CHR$(205); : NEXT
PRINT CHR$(187)
FOR I = 1 TO 21
  PRINT CHR$(186); TAB(40); CHR$(186)
NEXT
PRINT CHR$(200);
FOR I = 1 TO 38: PRINT CHR$(205); : NEXT
PRINT CHR$(188)
RETURN



INTAKE:
'******** ALTERNATIVE TO INPUT **********
COLOR 15
LOCATE Y%, X% - 1: PRINT "["
LOCATE Y%, X% + L% + 1: PRINT "]"
SX% = X%
COLOR 10
W$ = "": X1% = X%
LOCATE Y%, X%: PRINT SPACE$(L%)
5 LOCATE Y%, X%: PRINT "_"
10 A$ = INKEY$: IF A$ = "" THEN GOTO 10
A$ = UCASE$(A$)
IF A$ = "," THEN BEEP: GOTO 10
IF A$ = CHR$(27) THEN RUN
IF ASC(A$) > 96 AND ASC(A$) < 123 THEN A$ = CHR$(ASC(A$) - 32)
IF A$ = CHR$(13) THEN
	LOCATE Y%, X%: PRINT " "
	LOCATE Y%, SX% - 1: PRINT " "
	LOCATE Y%, SX% + L% + 1: PRINT " "
	RETURN
END IF
IF A$ = CHR$(8) THEN GOSUB DEL: GOTO 5
X% = X% + 1
IF X% > L% + X1% THEN BEEP: X% = X% - 1: GOTO 5
LOCATE Y%, X% - 1: PRINT A$
W$ = W$ + A$
GOTO 5
DEL:
LOCATE Y%, X%: PRINT " "
X% = X% - 1: IF X% < X1% THEN BEEP: X% = X% + 1: RETURN
A% = LEN(W$)
W$ = MID$(W$, 1, A% - 1)
RETURN


GETREC:
'*******************************************************************************
' FIND A RECORD USING THE FOLLOWING:
' FIND$(10),
'*******************************************************************************

FOR I = 1 TO 9: QUERY$(I) = "": NEXT

QUERY$(1) = "BOOK"
QUERY$(2) = "1"
QUERY$(5) = "="

FIL$ = "BOOK.REC"
OPEN FIL$ FOR INPUT AS #12
INPUT #12, RECS$
CLOSE 12
QUERY$(8) = RECS$


F% = 6: LENG% = 75
dsc$(1) = "65"
dsc$(2) = "2"
dsc$(3) = "2"
dsc$(4) = "2"
dsc$(5) = "2"
dsc$(6) = "2"
dsc$(7) = "0"

QUERY$(6) = STR$(LENG% + 1)
QUERY$(7) = STR$(F%)

INDEX$ = "BOOK"
QUERY$(9) = "1"


ILEN% = 0
QUERY$(3) = INDEX$
QUERY$(4) = "1"
ILEN% = 65
QUERY$(4) = "1"

PLAN:

WI% = VAL(dsc$(1))
TMP$ = MID$(FIND$(1), 1, WI%)
L% = LEN(TMP$)
FIND$(1) = TMP$ + SPACE$(WI% - L%)

NEXTREC:
'*******************************************************************************
'  RETRIEVE THE NEXT RECORD BASED ON QUERY$
'*******************************************************************************

IF QUERY$(1) = "" THEN
	RECORD = 0
	FOR I% = 1 TO 100
		RECORD$(I%) = ""
	NEXT
	RETURN
END IF

IF QUERY$(3) <> "" AND QUERY$(5) = "=" THEN GOTO BTREE


BTREE:
'****************************************************************************
' USES BINARY INDEX TO FIND RECORDS
'*****************************************************************************
INAME$ = "BOOK.IDX"
TNAME$ = "BOOK.DBA"
OPEN INAME$ FOR RANDOM AS #201 LEN = 40 + ILEN%
FIELD #201, ILEN% AS KEY$, 10 AS BIG$, 10 AS SMALL$, 10 AS REC$, 10 AS EQUAL$

IREC = VAL(QUERY$(4))

ISEARCH:
IF IREC = 0 THEN
	CLOSE 201
	FOR I% = 1 TO 8: QUERY$(I%) = "": NEXT
	FOR I% = 1 TO 10: RECORD$(I%) = "": NEXT
	RECORD = 0
	RETURN
END IF

GET #201, IREC
COMPARE$ = KEY$
CSTRING$ = FIND$(VAL(QUERY$(9)))
GOSUB COMPARE

IF COMPARE% = 0 THEN NREC = VAL(EQUAL$)
IF COMPARE% = 1 THEN NREC = VAL(BIG$)
IF COMPARE% = -1 THEN NREC = VAL(SMALL$)
RECORD = VAL(REC$)

IF COMPARE% = 0 THEN
	OPEN TNAME$ FOR RANDOM AS 202 LEN = VAL(QUERY$(6))
	FIELD #202, 1 AS STAT$, VAL(QUERY$(6)) - 1 AS RECORD$
	GET #202, RECORD
	IF STAT$ = "+" THEN
		QUERY$(4) = STR$(NREC)
		GOSUB SPLIT
		MATCH% = 0
		FOR I% = 1 TO RR% - 1
			IF RECORD$(I%) = FIND$(I%) AND FIND$(I%) <> "" THEN MATCH% = MATCH% + 1
			IF FIND$(I%) = "" THEN MATCH% = MATCH% + 1
		NEXT
		IF MATCH% = RR% - 1 THEN
			CLOSE 202
			CLOSE 201
			RETURN
		END IF
	END IF
	CLOSE 202
END IF
IREC = NREC

GOTO ISEARCH

SPLIT:
'*****************************************************************************
'        SPLIT RECORD$ INTO RECORD$(10) USING DSC$(10)
'******************************************************************************
RR% = 0: CU% = 1
DO
	RR% = RR% + 1
	WI% = VAL(dsc$(RR%))
	IF WI% = 0 THEN EXIT DO
	RECORD$(RR%) = MID$(RECORD$, CU%, WI%)
	CU% = CU% + WI%
LOOP
RETURN



COMPARE:
'******************************************************************************
' COMPARES TWO STRINGS AND RETURNS WHETHER WHICH IS THE BIGGIEST OR SMALLEST
'******************************************************************************
COMPARE% = 0
IF CSTRING$ = COMPARE$ THEN RETURN

IF CSTRING$ > COMPARE$ THEN COMPARE% = 1: RETURN
IF CSTRING$ < COMPARE$ THEN COMPARE% = -1: RETURN



DRAWBOARD:
'************************************************************************
' DRAW THE BOARD AND THE PIECES
'
'MAKE-EGA - Define, test and save EGA (640 x 350 x 16) chess graphic pieces
'Ed Parry
'Started: 05-14-1991
'Updated: 06-25-1994
'MODIFIED BY THOMAS MCBURNEY FOR DEEP BASIC 8 FEB 2003
'*************************************************************************

GOSUB DRAWTHEBOARD           'DrawBoard
GOSUB SHOWPIECES             ' DRAW THE PIECES

RETURN


DRAWTHEBOARD:       ' STATIC 'draws checkered chessboard
'Each square height and width
high = 38                             'square pixels height DEFAULT=40
WIDE = 45                             'square pixels wide DEFAULT=56
'starting board positions - adjust for video modes
hs = (640 \ 2) - ((WIDE * 6) + 38)    'board horizontal vertical position
he = hs + (8 * WIDE)                  'horz end
vs = 30                               'DEFAULT=10 - board starting vertical postion
ve = vs + (8 * high)
sbc = 15                              'square border color
lsc = 7                               'lite sqr color
dsc = 2                               'dark sqr color
'board line matrix
H = hs
FOR I = vs TO ve STEP high
	'horizontal lines
	LINE (hs, I)-(he, I), sbc
	'vertical lines
	LINE (H, vs)-(H, ve), sbc
	H = H + WIDE
NEXT I

'use line to fill each board square
FOR j = vs + 1 TO ve - 1 STEP high
	FOR I = hs + 1 TO he - 1 STEP WIDE
		'horizontal lines
		LINE (I, j)-(I + WIDE - 2, j + high - 2), lsc, BF
		SWAP lsc, dsc
	NEXT I
	SWAP lsc, dsc
NEXT j
COLOR 7
IF FLIP% = 0 THEN LOCATE 2, 4: PRINT " a     b    c     d     e    f     g    h "
IF FLIP% = 1 THEN LOCATE 2, 4: PRINT " h     g    f     e     d    c     b    a "

FOR Y = 1 TO 8
	IF Y = 1 THEN YY = 4
	IF Y = 2 THEN YY = 7
	IF Y = 3 THEN YY = 10
	IF Y = 4 THEN YY = 12
	IF Y = 5 THEN YY = 15
	IF Y = 6 THEN YY = 18
	IF Y = 7 THEN YY = 21
	IF Y = 8 THEN YY = 23
	IF FLIP% = 0 THEN LOCATE YY, 49: PRINT MID$(STR$(9 - Y), 2, 1)
	IF FLIP% = 1 THEN LOCATE YY, 49: PRINT MID$(STR$(Y), 2, 1)
NEXT

COLOR 9
LOCATE 2, 58: PRINT "Deep BASIC"
COLOR 1
LINE (455, 30)-(535, 30)
LINE (425, 10)-(565, 37), , B

RETURN




SHOWPIECES:
'White on any = Put blot OR, put piece XOR, put blot XOR
'Black on any = Put blot OR, put piece XOR

high = 38                             'square pixels height DEFAULT=40
WIDE = 45                             'square pixels wide DEFAULT=56
vof = 32                          'reset vert offset DEFAULT=14
hof = 17
PIECEOFFSET = 0
BLOTOFFSET = 2400
'put em up to test!

	
FOR YY = 1 TO 8
	FOR XX = 1 TO 8
	  

		IF BO%(XX, YY) <> 0 THEN
			  
			P% = ABS(BO%(XX, YY))
			
			FOR X = 0 TO 399
				PIECEOFFSET = (400 * P%) - 400
				BLOTOFFSET = ((400 * P%) - 400) + 2400
				Gpiece(X) = GraphicImage(PIECEOFFSET + X)
				blot(X) = GraphicImage(BLOTOFFSET + X)
			NEXT X
			 
			X1 = XX
			Y1 = YY
		  
			IF FLIP% = 1 THEN X1 = 9 - XX: Y1 = 9 - YY

			IF BO%(XX, YY) > 0 THEN
				'white piece
				PUT (hof + (WIDE * X1) - WIDE, vof + (38 * Y1) - 38), blot, OR
				PUT (hof + (WIDE * X1) - WIDE, vof + (38 * Y1) - 38), Gpiece, XOR
				PUT (hof + (WIDE * X1) - WIDE, vof + (38 * Y1) - 38), blot, XOR
			END IF
			  
			IF BO%(XX, YY) < 0 THEN
				'BLACK piece
				PUT (hof + (WIDE * X1) - WIDE, vof + (38 * Y1) - 38), blot, OR
				PUT (hof + (WIDE * X1) - WIDE, vof + (38 * Y1) - 38), Gpiece, XOR
			END IF
		END IF
	NEXT
NEXT
  
RETURN


LoadPieces:
'**** LOAD GRAPHICS OF PIECES OFF DISK
DEF SEG = VARSEG(GraphicImage(0))
BLOAD "PIECES.EGA", VARPTR(GraphicImage(0))
RETURN

TAKEBACK:
'---------------------------------------------------------------------
'                         TAKE BACK ONE MOVE
'---------------------------------------------------------------------
IF TAKEBACK%(0, 0) < 1 THEN TAKEBACK%(0, 0) = 0: BEEP: RETURN
TAKEBACK%(0, 0) = TAKEBACK%(0, 0) - 1

SIDE% = SIDE% + 1
IF SIDE% > 1 THEN SIDE% = 0

C = 0
FOR Y = 1 TO 8
	FOR X = 1 TO 8
		C = C + 1
		P$ = MID$(STARTPOS$, C, 1)
		P = 0
		IF P$ = "p" THEN P = -1
		IF P$ = "n" THEN P = -2
		IF P$ = "b" THEN P = -3
		IF P$ = "r" THEN P = -4
		IF P$ = "q" THEN P = -5
		IF P$ = "k" THEN P = -6
		IF P$ = "P" THEN P = 1
		IF P$ = "N" THEN P = 2
		IF P$ = "B" THEN P = 3
		IF P$ = "R" THEN P = 4
		IF P$ = "Q" THEN P = 5
		IF P$ = "K" THEN P = 6
		CB%(X, Y) = P
	NEXT
NEXT
FOR I = 1 TO TAKEBACK%(0, 0)
	X% = TAKEBACK%(1, I)
	Y% = TAKEBACK%(2, I)
	XX% = TAKEBACK%(3, I)
	YY% = TAKEBACK%(4, I)
	SPECIAL% = TAKEBACK%(5, I)
	GOSUB MAKEMOVE
NEXT
GOSUB COPYCB2BO
GOSUB DRAWBOARD
RETURN

RECORDMOVE:
TAKEBACK%(0, 0) = TAKEBACK%(0, 0) + 1
IF TAKEBACK%(0, 0) > 200 THEN TAKEBACK%(0, 0) = 1
R = TAKEBACK%(0, 0)
TAKEBACK%(1, R) = X%
TAKEBACK%(2, R) = Y%
TAKEBACK%(3, R) = XX%
TAKEBACK%(4, R) = YY%
TAKEBACK%(5, R) = SPECIAL%
RETURN

