DECLARE FUNCTION SelectFile$ (Patterns AS STRING)
DECLARE FUNCTION PalBestColor% (RR AS INTEGER, GG AS INTEGER, BB AS INTEGER)
DECLARE SUB GetPalette (Attr%, Red%, Green%, Blue%)
DECLARE FUNCTION ListBox% (LstStr AS STRING, Title AS STRING, DefItem AS INTEGER)
DECLARE FUNCTION RleCompStr$ (CompStr AS STRING)
DECLARE FUNCTION RleDeCompStr2$ (CompStr AS STRING, WhileC AS INTEGER)
DECLARE FUNCTION RleDeCompStr$ (CompStr AS STRING)
DECLARE FUNCTION EncodeStr$ (EncStr AS STRING, PassStr AS STRING)
DECLARE FUNCTION RotateX# (Angle AS DOUBLE, Radius AS DOUBLE, CX AS DOUBLE)
DECLARE FUNCTION RotateY# (Angle AS DOUBLE, Radius AS DOUBLE, CY AS DOUBLE)
DECLARE FUNCTION RmLDir$ (SDR AS STRING)
DECLARE SUB Sort (A$(), Low!, High!)
DECLARE SUB GetDir (EntryName$(), Extension$(), EntryType%(), DirNum%, Path$, Status%)
DECLARE FUNCTION GetKey2% ()
DEFINT A-Z
''''
DEFINT A-Z
'$INCLUDE: 'future.bi'

DECLARE SUB VecFont (PX%, PY%, SZ AS SINGLE, Fln$, CC AS LONG)
DECLARE FUNCTION GetWord$ (Strng AS STRING, Strt AS INTEGER, Ed AS INTEGER, LastPos%)
DECLARE FUNCTION GetNum% (Strng AS STRING, Strt AS INTEGER, Ed AS INTEGER, LastPos%)

DECLARE SUB Delay (Ln%)
DECLARE SUB ChangeDrive (Drive$)
DECLARE SUB Refresh (X%, Y%, Length%, C&)
'DECLARE SUB Sort (A$(), Low%, High%)
'DECLARE SUB GetDir (EntryName$(), Extension$(), EntryType%(), DirNum%, Path$, Status%)
DECLARE FUNCTION LogicalDrives% (Drive$)
'DECLARE FUNCTION GetKey2% ()
DECLARE FUNCTION CurrentPath$ ()
DECLARE FUNCTION CurrentDrive$ ()
DECLARE FUNCTION NumDrives% ()
DECLARE FUNCTION RandInt% (Lower%, Upper%)
DECLARE FUNCTION RealPath$ ()
'DECLARE SUB SelectFile (FileName$, Status%, X%, Y%)
DECLARE SUB GIFLoad (Num%, PX%, PY%)
DECLARE SUB FastProgBar (X%, Y%, Perc%, Ln%, Txt$)
DECLARE FUNCTION FindOffs& (Fln$, Mask$, FromPos AS LONG, ToPos AS LONG)
DECLARE SUB T.Print (X%, Y%, T$, C AS LONG, B AS LONG, FontNum%, Italic%, Tall%, Bold%, CharSpacing%, UnderLined%, FSize AS INTEGER)
DECLARE SUB PRNT (X%, Y%, T$, C AS LONG)
DECLARE FUNCTION BitN% (NN%, NUMB%)
DECLARE SUB SetCur (Num%)
DECLARE SUB InstAll ()
DECLARE FUNCTION InitLib% (TDLLibrary AS STRING, Offs AS LONG)

DECLARE SUB Draw3DBox (X%, Y%, x2%, y2%, Side%)
DECLARE SUB MouseWait ()
DECLARE FUNCTION InBut% (X%, Y%, X1%, Y1%, x2%, y2%)
DECLARE SUB PrepProg (X%, Y%, Perc%, Ln%)
DECLARE FUNCTION ExistFile% (FilN$)
DECLARE FUNCTION MsgBox% (X%, Y%, Title$, Message$, Butt%, Icon%)
DECLARE SUB Gradient (X1!, Y1!, x2!, y2!, C1 AS LONG, C2 AS LONG)
DECLARE SUB PutPic (Num AS INTEGER, PXX%, PYY%)
DECLARE SUB CopyDat (InF AS INTEGER, OutF AS INTEGER, Siz AS LONG)
DECLARE FUNCTION InputBox$ (Leng%, Title$, Def$, X AS INTEGER, Y AS INTEGER, Prompt AS STRING)

DECLARE SUB DirectPut ALIAS "SVGAput" (BYVAL X%, BYVAL Y%, BYVAL Offs%, BYVAL Segment%)
DECLARE SUB DirectGet ALIAS "SVGAget" (BYVAL X1%, BYVAL Y1%, BYVAL x2%, BYVAL y2%, BYVAL Offs%, BYVAL Segment%)

''''




TYPE FileFindBuf
    DOS            AS STRING * 19
    CreateTime     AS STRING * 1
    Attributes     AS INTEGER
    AccessTime     AS INTEGER
    AccessDate     AS INTEGER
    FileSize       AS LONG
    FileName       AS STRING * 13
END TYPE

TYPE Register
    AX    AS INTEGER
    BX    AS INTEGER
    CX    AS INTEGER
    DX    AS INTEGER
    Bp    AS INTEGER
    Si    AS INTEGER
    Di    AS INTEGER
    Flags AS INTEGER
    DS    AS INTEGER
    Es    AS INTEGER
END TYPE

TYPE TPFHeaderType
    ID AS STRING * 5
    FMT AS STRING * 3
    Bpp AS INTEGER
    SizeX AS LONG
    SizeY AS LONG
    Comment AS STRING * 20
END TYPE

DEFSNG A-Z
FUNCTION BitN% (NN%, NUMB%)
 BitN% = SGN(NUMB% AND 2 ^ NN%)
END FUNCTION

DEFINT A-Z
SUB Bload2 (Fln AS STRING, FOffs AS LONG, LSeg AS LONG, LOffs AS LONG, LSize AS INTEGER)
 DIM Reg AS Register, FH AS INTEGER
 Fln = Fln + CHR$(0)

 'Open:
   Reg.AX = &H3D00
   Reg.DS = VARSEG(Fln)
   Reg.DX = SADD(Fln)
   CALL Interrupt(&H21, Reg, Reg)
   Reg.BX = Reg.AX
   FH = Reg.AX
  'FilePointer Move
    Reg.AX = &H4200
    Reg.BX = FH
    Reg.CX = FOffs \ &HFFFF
    Reg.DX = FOffs MOD &HFFFF
    CALL Interrupt(&H21, Reg, Reg)
  'Read
    Reg.AX = &H3000
    Reg.BX = FH
    Reg.CX = LSize
    Reg.DS = LSeg
    Reg.DX = LOffs
    'SOUND 100 + RND * 200, 1
    CALL Interrupt(&H21, Reg, Reg)
    'SOUND 800 + RND * 200, 1
 'Close
   Reg.AX = &H3E00
   Reg.BX = FH
   Reg.DX = SADD(Fln)
   CALL Interrupt(&H21, Reg, Reg)

END SUB

DEFSNG A-Z
SUB ChangeDrive (Drive$)
    DIM InReg AS Register
    InReg.AX = &HE00
    InReg.DX = ASC(Drive$) - 65
    CALL Interrupt(&H21, InReg, InReg)
END SUB

DEFINT A-Z
'Returns current drive.
FUNCTION CurrentDrive$
    DIM InReg AS Register
    InReg.AX = &H1900
    CALL Interrupt(&H21, InReg, InReg)
    CurrentDrive$ = CHR$(65 + InReg.AX MOD 256)
END FUNCTION

'Returns current path(not a full path- the current drive must be added).
'**********************************************************************
'WARNING: for some reason, if the drive isn't ready this sub will
'HANG UP!!! (the SelectFile sub makes sure the drive is ready)
FUNCTION CurrentPath$
        DIM InReg AS Register
        DIM PathSize AS STRING * 64
        InReg.AX = &H4700
        InReg.DX = ASC(CurrentDrive$) - 64
        InReg.DS = VARSEG(PathSize)
        InReg.Si = VARPTR(PathSize)
        CALL InterruptX(&H21, InReg, InReg)
        CurrentPath$ = LEFT$(PathSize, INSTR(PathSize, CHR$(0)) - 1)
END FUNCTION

SUB Delay (Ln%)
'Ln# = Ln# / 1000
'TLN# = TIMER
'WHILE TIMER - TLN# < Ln#: WEND
ResetCounter
StartTIMER
WHILE ReadCounter < Ln%: WEND
END SUB

SUB Draw3DBox (X, Y, x2, y2, Side)

IF Side = 0 THEN
  BC1 = 30
  BC2 = 29
  BC3 = 26
  BC4 = 25
  BKC = 7 '28
 ELSE
  BC1 = 26
  BC2 = 25
  BC4 = 29
  BC3 = 30
  BKC = 7 '28
END IF

 Future.FILLBOX X, Y, x2, y2, BKC

 Future.LINE X, Y, x2, Y, BC1, -1
 Future.LINE X, Y + 1, x2, Y + 1, BC2, -1

 Future.LINE X, y2 - 1, x2, y2 - 1, BC3, -1
 Future.LINE X, y2, x2, y2, BC4, -1

 Future.LINE X, Y, X, y2, BC1, -1
 Future.LINE X + 1, Y + 1, X + 1, y2 - 1, BC2, -1

 Future.LINE x2 - 1, Y + 1, x2 - 1, y2 - 1, BC3, -1
 Future.LINE x2, Y, x2, y2, BC4, -1

END SUB

SUB Draw3DBox2 (X, Y, x2, y2, Side)
  IX = 1: IY = 1
  DO
    IF IX < x2 - X THEN IX = IX + 1
    IF IY < y2 - Y THEN IY = IY + 1
    Draw3DBox (X + (x2 - X) / 2 - IX / 2), (Y + (y2 - Y) / 2 - IY / 2), (X + (x2 - X) / 2 + IX / 2), (Y + (y2 - Y) / 2 + IY / 2), Side
    'Delay 1
  LOOP WHILE ((IX < x2 - X) OR (IY < y2 - Y))
END SUB

REM $DYNAMIC
SUB Draw3DCir (X, Y, R, Side)

IF Side = 0 THEN
  BC1 = 30
  BC2 = 28
  BC3 = 26
  BC4 = 23
  BKC = 28
 ELSE
  BC1 = 26
  BC2 = 25
  BC4 = 29
  BC3 = 30
  BKC = 28
END IF

 DIM RN AS SINGLE, Stp AS SINGLE
 Stp = 3 / (2 * Pi * R)
 'Stp = .001
 Future.FILLCIRCLE X, Y, R - 3, BKC
 FOR RN = .25 * Pi TO 1.25 * Pi STEP Stp
  Future.PSET ((COS(RN - Pi / 2) * R) + X), ((SIN(RN - Pi / 2) * R) + Y), BC2
 NEXT
 FOR RN = .25 * Pi TO 1.25 * Pi STEP Stp
  Future.PSET ((COS(RN + Pi / 2) * R) + X), ((SIN(RN + Pi / 2) * R) + Y), BC3
 NEXT
 FOR RN = .25 * Pi TO 1.25 * Pi STEP Stp
  Future.PSET ((COS(RN - Pi / 2) * (R - 1)) + X), ((SIN(RN - Pi / 2) * (R - 1)) + Y), BC1
 NEXT
 FOR RN = .25 * Pi TO 1.25 * Pi STEP Stp
  Future.PSET ((COS(RN + Pi / 2) * (R - 1)) + X), ((SIN(RN + Pi / 2) * (R - 1)) + Y), BC4
 NEXT
 
END SUB

REM $STATIC
FUNCTION EncodeStr$ (EncStr AS STRING, PassStr AS STRING)
DIM II AS INTEGER, IC AS INTEGER, TmpStr AS STRING
IF EncStr = "" OR PassStr = "" THEN EncodeStr = EncStr: EXIT FUNCTION
FOR II = 1 TO LEN(EncStr)
    IC = IC + 1: IF IC > LEN(PassStr) THEN IC = 1
    TmpStr = TmpStr + CHR$(ASC(MID$(EncStr, II, 1)) XOR ASC(MID$(PassStr, IC, 1)))
NEXT
EncodeStr = TmpStr
END FUNCTION

REM $DYNAMIC
FUNCTION ExistFile (FilN$)
 ON LOCAL ERROR RESUME NEXT
 FF% = FREEFILE
 ExistFile = 0
 IF LTRIM$(RTRIM$(FilN$)) = "" OR LEFT$(FilN$, 1) = "." THEN EXIT FUNCTION
 OPEN FilN$ FOR BINARY AS FF%
  IF ERR <> 0 THEN
    ExistFile = 0
    CLOSE FF%
    KILL FilN$
  END IF
  IF NOT (LOF(FF%) < 1) THEN
    ExistFile = -1
    CLOSE FF%
   ELSE
    ExistFile = 0
    CLOSE FF%
    KILL FilN$
  END IF
END FUNCTION

REM $STATIC
SUB GetDir (EntryName$(), Extension$(), EntryType(), DirNum, Path$, Status)

    DIM InReg AS Register, OutReg AS Register
    DIM Buffer AS FileFindBuf
     
    DirNum = 1
   
    CONST File = 0, Directory = 1
   
    InReg.AX = &H1A00
    InReg.DS = VARSEG(Buffer)
    InReg.DX = VARPTR(Buffer)
    CALL Interrupt(&H21, InReg, OutReg)
    InReg.AX = &H4E00
    InReg.CX = 16
    Npath$ = Path$ + CHR$(0)
    InReg.DX = SADD(Npath$)
    CALL InterruptX(&H21, InReg, OutReg)
    FirstFM = (OutReg.AX AND &HF)
    IF OutReg.Flags AND 1 THEN
        Status = True
        EXIT SUB
    ELSE
        Status = FALSE
    END IF
  
    IF FirstFM = 0 THEN
        GOSUB MakeFile
        DO
            InReg.AX = &H4F00
            InReg.DX = SADD(Npath$)
            CALL Interrupt(&H21, InReg, OutReg)
            NextFM = OutReg.AX AND &HF
            IF NextFM = 0 THEN
                GOSUB MakeFile
            END IF
        LOOP WHILE NextFM = 0
    END IF
    EXIT SUB

MakeFile:
    IF LEFT$(Buffer.FileName, 1) = "." THEN
        RETURN
    END IF
 
     
    Entry$ = RTRIM$(Buffer.FileName)
    IF Buffer.Attributes = 4096 THEN
        EntryName$ = RTRIM$(LEFT$(Entry$, 8))
        EntryType = Directory
    ELSE
        IF INSTR(Entry$, ".") = 0 THEN
            EntryName$ = RTRIM$(LEFT$(Entry$, 8))
            Extension$ = ""
        ELSE
            EntryName$ = LEFT$(Entry$, INSTR(Entry$, ".") - 1)
            Extension$ = RTRIM$(LEFT$(MID$(Entry$, INSTR(Entry$, ".") + 1), 3))
        END IF
        EntryType = File
    END IF
    
  
    EntryName$(DirNum) = EntryName$
    Extension$(DirNum) = Extension$
    EntryType(DirNum) = EntryType

    DirNum = DirNum + 1
    IF DirNum >= UBOUND(EntryName$) THEN EXIT SUB

    Buffer.Attributes = 0
    Buffer.AccessTime = 0
    Buffer.AccessDate = 0
    Buffer.FileSize = 0
    Buffer.FileName = STRING$(13, 32)
RETURN

END SUB

'This sub returns the ascii keycode- extended keycodes(ones that have
'a zero as the first character) return easy to handle negative
'values.
FUNCTION GetKey2
    DO
        A$ = INKEY$
    LOOP UNTIL A$ <> ""
    IF LEN(A$) = 2 THEN
        GetKey2 = -ASC(RIGHT$(A$, 1))
    ELSE
        GetKey2 = ASC(A$)
    END IF
END FUNCTION

FUNCTION GetNum (Strng AS STRING, Strt AS INTEGER, Ed AS INTEGER, LastPos)
 GV$ = ""
 SE$ = LTRIM$(RIGHT$(Strng, LEN(Strng) - Strt))
 FOR NI = 1 TO Ed - Strt
  GS$ = MID$(SE$, NI, 1)
  SELECT CASE ASC(GS$)
   CASE ASC("0") TO ASC("9"), ASC("."): GV$ = GV$ + GS$
   CASE ELSE: EXIT FOR
  END SELECT
 NEXT NI
 LastPos = NI + Strt
 GetNum = VAL(GV$)
END FUNCTION

SUB GetPalette (Attr%, Red%, Green%, Blue%)

OUT &H3C7, Attr%
Red% = INP(&H3C9)
Green% = INP(&H3C9)
Blue% = INP(&H3C9)

END SUB

DEFSNG A-Z
FUNCTION GetWord$ (Strng AS STRING, Strt AS INTEGER, Ed AS INTEGER, LastPos AS INTEGER)
 GV$ = ""
 SE$ = LTRIM$(RIGHT$(Strng, LEN(Strng) - Strt))
 FOR NI = 1 TO Ed - Strt
  GS$ = MID$(SE$, NI, 1)
  SELECT CASE ASC(GS$)
   CASE 32, 13, 10: EXIT FOR
   CASE ELSE: GV$ = GV$ + GS$
  END SELECT
 NEXT NI
 LastPos = NI + Strt
 GetWord$ = GV$
END FUNCTION

REM $DYNAMIC
SUB Gradient (X1, Y1, x2, y2, C1 AS LONG, C2 AS LONG)
SWAP X1, Y1: SWAP x2, y2
DIM I AS SINGLE, Stp AS SINGLE
IF C2 = C1 THEN Stp = 1 ELSE Stp = (y2 - Y1) / (C2 - C1)
FOR I = C1 TO C2 - 1 STEP 1
 YYYY = YYY
 YYY = Y1 + (I - C1) * Stp
 IF YYY <> YYYY THEN Future.FILLBOX YYY, X1, YYY + Stp, x2, I
NEXT
END SUB

DEFINT A-Z
FUNCTION InBut (X, Y, X1, Y1, x2, y2)
 IF ((X > X1) AND (X < x2) AND (Y > Y1) AND (Y < y2)) THEN InBut = -1 ELSE InBut = 0
END FUNCTION

REM $STATIC
FUNCTION ListBox% (LstStr AS STRING, Title AS STRING, DefItem AS INTEGER)
 DIM BC1 AS INTEGER, BC2 AS INTEGER, BC3 AS INTEGER, BC4 AS INTEGER
 DIM BKC AS INTEGER, Back3(16000) AS INTEGER, INK AS STRING
 DIM CurItem AS INTEGER, Items(1 TO 502) AS STRING * 23, ItemCol AS INTEGER, I AS INTEGER, CPS AS INTEGER
 X = 220: Y = 165: CurItem = DefItem: I = 1: ItemCol = 0
 BC1 = 29
 BC2 = 28
 BC3 = 24
 BC4 = 23
 BKC = 26

 DO
  ItemCol = ItemCol + 1: IF ItemCol > 500 THEN ItemCol = 500: EXIT DO
  CPS = INSTR(I, LstStr, "|")
  IF CPS = 0 THEN Items(ItemCol) = MID$(LstStr, I, LEN(LstStr) - I + 1): EXIT DO
  Items(ItemCol) = MID$(LstStr, I, CPS - I)
  I = CPS + 1
 LOOP

 IF (CurItem < 1) OR (CurItem > ItemCol) THEN CurItem = 1
 CPS = 1
 
 SetMaskColor 254
ReDrawListBox: Future.MouseOff
 Future.GET X, Y, X + 200, Y + 150, Back3()
 Draw3DBox X, Y, X + 200, Y + 150, 0
 Gradient X + 3, Y + 3, X + 197, Y + 19, 17, 30
 PutPic 2, X + 3, Y + 3
 'T.Print X + 25, Y + 4, Title, 14, -1, 4, 0, 0, 0, 3, 0, 1
 Future.Print X + 25, Y + 4, Title, 14, -1
 Future.BOX X + 2, Y + 2, X + 198, Y + 20, 12
 Draw3DBox X + 3, Y + 23, X + 197, Y + 147, 1
 IF CurItem > CPS + 6 THEN CPS = CurItem - 6
 IF CurItem < CPS THEN CPS = CurItem
 FOR I = CPS TO CPS + 6
  Future.Print X + 8, Y + 13 + 16 * (I + 1 - CPS), Items(I), 0, 7 - (I = CurItem) * 18
 NEXT
 DO
  INK = INKEY$
  IF INK <> "" THEN
   SELECT CASE INK
    CASE CHR$(27), CHR$(13), CHR$(9): ListBox = CurItem: EXIT DO
    CASE CHR$(0) + "H": CurItem = CurItem - 1: IF CurItem < 1 THEN CurItem = 1
    CASE CHR$(0) + "P": CurItem = CurItem + 1: IF CurItem > ItemCol THEN CurItem = ItemCol
    CASE CHR$(0) + "K": CurItem = 1
    CASE CHR$(0) + "M": CurItem = ItemCol
    CASE CHR$(0) + "I": CurItem = CurItem - 6: IF CurItem < 1 THEN CurItem = 1
    CASE CHR$(0) + "Q": CurItem = CurItem + 6: IF CurItem > ItemCol THEN CurItem = ItemCol
   END SELECT
   IF CurItem > CPS + 6 THEN CPS = CurItem - 6
   IF CurItem < CPS THEN CPS = CurItem
   FOR I = CPS TO CPS + 6
    Future.Print X + 8, Y + 13 + 16 * (I + 1 - CPS), Items(I), 0, 7 - (I = CurItem) * 18
   NEXT
  END IF
 LOOP
 Future.PUT X, Y, Back3()
END FUNCTION

SUB LoadTPF (Fln AS STRING, Offs AS LONG, PX AS INTEGER, PY AS INTEGER)
 ON LOCAL ERROR RESUME NEXT
 DIM TPF AS TPFHeaderType, F AS INTEGER, Bff AS STRING, I AS INTEGER, RleSize AS LONG, RLESizeP AS INTEGER
 DIM OutStr AS STRING, LG AS INTEGER, NN AS LONG
 DIM Fln2 AS STRING: Fln2 = Fln
 IF NOT ExistFile(Fln2) THEN
  IF INSTR(Fln2, ".") <> 0 THEN EXIT SUB
  Fln2 = Fln2 + ".TPF"
  IF NOT ExistFile(Fln2) THEN EXIT SUB
 END IF
 F = FREEFILE
 OPEN Fln2 FOR BINARY AS F
  IF Offs > 1 THEN SEEK F, Offs
  GET F, , TPF
  IF TPF.ID <> "TPSPF" THEN CLOSE F: EXIT SUB
  IF (TPF.FMT <> "FMT") AND (TPF.FMT <> "RLE") THEN CLOSE F: EXIT SUB
  IF TPF.Bpp <> 8 THEN CLOSE F: EXIT SUB
  IF TPF.FMT = "RLE" THEN GET F, , RleSize
  IF TPF.SizeX > 2000 THEN CLOSE F: EXIT SUB
  I = 0: NN = 0: OutStr = ""
  IF (TPF.SizeX * TPF.SizeY) > 20000 THEN
    IF TPF.FMT = "RLE" THEN
         DO
          LG = ASC(INPUT$(1, F))         'ASC(MID$(CompStr, NN, 1))
          IF (LG AND 128) = 0 THEN
            OutStr = OutStr + INPUT$(LG + 1, F)   'MID$(CompStr, NN + 1, LG + 1)
           ELSE
            OutStr = OutStr + STRING$(LG - 127, INPUT$(1, F))
          END IF
          NN = LEN(OutStr)
          IF NN > TPF.SizeX THEN
           Bff = MKI$(TPF.SizeX - 1) + MKI$(0) + LEFT$(OutStr, TPF.SizeX)
           DirectPut PX, PY + I, SADD(Bff), SSEG(Bff)
           NN = LEN(OutStr) - TPF.SizeX: IF NN <= 0 THEN EXIT DO
           I = I + 1: IF I + 1 >= TPF.SizeY THEN EXIT DO
           OutStr = RIGHT$(OutStr, NN)
          END IF
         LOOP
     ELSE
      FOR I = 0 TO TPF.SizeY - 2
       Bff = MKI$(TPF.SizeX - 1) + MKI$(0) + INPUT$(TPF.SizeX, F)
       DirectPut PX, PY + I, SADD(Bff), SSEG(Bff)
      NEXT
    END IF
   ELSE
    IF TPF.FMT = "RLE" THEN
      Bff = MKI$(TPF.SizeX - 1) + MKI$(TPF.SizeY - 1) + RleDeCompStr(INPUT$(RleSize, F))
     ELSE
      Bff = MKI$(TPF.SizeX - 1) + MKI$(TPF.SizeY - 1) + INPUT$(TPF.SizeX * TPF.SizeY, F)
    END IF
    DirectPut PX, PY, SADD(Bff), SSEG(Bff)
  END IF
 CLOSE F
 PX = TPF.SizeX: PY = TPF.SizeY
END SUB

REM $DYNAMIC
FUNCTION LogicalDrives (Drive$)
    DIM InReg AS Register
    InReg.AX = &H440E
    InReg.BX = ASC(Drive$) - 64
    CALL Interrupt(&H21, InReg, InReg)
    IF (InReg.Flags AND 1) = 1 THEN
        LogicalDrives = -1
    ELSE
        LogicalDrives = InReg.AX AND 255
    END IF
END FUNCTION

REM $STATIC
SUB MemCopy (fromseg%, fromoffset%, toseg%, tooffset%, bytes%)
  asm$ = ""
  asm$ = asm$ + CHR$(85)
  asm$ = asm$ + CHR$(137) + CHR$(229)
  asm$ = asm$ + CHR$(30)
  asm$ = asm$ + CHR$(139) + CHR$(70) + CHR$(10)
  asm$ = asm$ + CHR$(142) + CHR$(192)
  asm$ = asm$ + CHR$(139) + CHR$(70) + CHR$(14)
  asm$ = asm$ + CHR$(142) + CHR$(216)
  asm$ = asm$ + CHR$(139) + CHR$(118) + CHR$(8)
  asm$ = asm$ + CHR$(139) + CHR$(126) + CHR$(12)
  asm$ = asm$ + CHR$(139) + CHR$(78) + CHR$(6)
  asm$ = asm$ + CHR$(243)
  asm$ = asm$ + CHR$(164)
  asm$ = asm$ + CHR$(31)
  asm$ = asm$ + CHR$(93)
  asm$ = asm$ + CHR$(203)
  WAIT &H3DA, 8
  DEF SEG = VARSEG(asm$)
    CALL ABSOLUTE(BYVAL fromseg%, BYVAL fromoffset%, BYVAL toseg%, BYVAL tooffset%, BYVAL bytes%, SADD(asm$))
  DEF SEG
END SUB

REM $DYNAMIC
SUB MouseWait
Future.MouseOn
WHILE Future.MouseB <> 0
 Future.UpdateMouse
WEND
'Future.MouseOff
END SUB

'Returns the number of logical drives. For instance- if 4 is returned
'then the valid drive names are A: B: C: & D:
'Since I only got to check this sub out with my computer's
'drive configuration, this sub checks over it's findings
'to make sure it has the correct number of logical drives.
'(better safe than sorry!)
FUNCTION NumDrives
    DIM InReg AS Register
    InReg.AX = &HE00
    InReg.DX = ASC(CurrentDrive$) - 65
    CALL Interrupt(&H21, InReg, InReg)
    Temp = (InReg.AX MOD 256) - 1
    FOR A = 1 TO Temp
        IF LogicalDrives(CHR$(A + 64)) = -1 THEN
            NumDrives = A - 1
            EXIT FUNCTION
        END IF
    NEXT
    NumDrives = Temp
END FUNCTION

REM $STATIC
FUNCTION PalBestColor% (RR AS INTEGER, GG AS INTEGER, BB AS INTEGER)
 DIM I AS INTEGER, MinDiff AS INTEGER, MinNum AS INTEGER, Diff AS INTEGER
 DIM RRR AS INTEGER, GGG AS INTEGER, BBB AS INTEGER
 MinDiff = 32000
 FOR I = 0 TO 255
  GetPalette I, RRR, GGG, BBB
  Diff = ABS(RR - RRR) + ABS(GG - GGG) + ABS(BB - BBB)
  IF Diff < MinDiff THEN MinDiff = Diff: MinNum = I
 NEXT
 PalBestColor = MinNum
END FUNCTION

SUB PlayWav (wavefile$, watp%, FileOffset AS LONG)
'IF INSTR(wavefile$, ".") = 0 THEN wavefile$ = wavefile$ + ".wav"
repeats% = 1
tmp% = 0
blast$ = UCASE$(ENVIRON$("BLASTER"))
IF LEN(blast$) THEN
tmp% = INSTR(blast$, "A")
tmp1$ = MID$(blast$, tmp% + 1, 3)
tmp% = VAL("&H" + tmp1$)
IF tmp% = 203 THEN tmp% = -1
IF tmp% > 0 THEN
tmp2% = INSTR(blast$, "D")
dma% = VAL(MID$(blast$, tmp2% + 1))
IF dma% < 0 OR dma% > 7 THEN tmp% = -2
END IF
END IF
BlasterAddr% = tmp%
sp% = INSTR(Spec$, " ")
IF sp% THEN
wavefile$ = LEFT$(Spec$, sp% - 1)
repeats% = VAL(RIGHT$(Spec$, LEN(Spec$) - sp%))
IF repeats% = 0 THEN repeats% = 1
ELSE
IF LEN(Spec$) THEN
wavefile$ = Spec$
repeats% = 1
END IF
END IF
IF LEN(wavefile$) = 0 THEN
END IF
rID$ = SPACE$(4)
wID$ = SPACE$(4)
fID$ = SPACE$(4)
dat$ = SPACE$(4)
dummy$ = SPACE$(1)
filenum% = FREEFILE
OPEN wavefile$ FOR BINARY AS filenum%
IF watp% = -1 THEN watp% = LOF(filenum%)
GET filenum%, , rID$
GET filenum%, , rLen&
GET filenum%, , wID$
GET filenum%, , fID$
GET filenum%, , fLen&
GET filenum%, , wFormatTag%
GET filenum%, , Channels%
GET filenum%, , Sampling&
GET filenum%, , bytes&
GET filenum%, , nBlockAlign%
GET filenum%, , FormatSpecific%

FOR I% = 1 TO fLen& - 16
 GET filenum%, , dummy$
NEXT I%

GET filenum%, , dat$
IF UCASE$(dat$) = "FACT" THEN
GET filenum%, , dummy&
GET filenum%, , dummy&
GET filenum%, , dat$
END IF
GET filenum%, , WavLen&
LenHeader% = LOC(1)
CLOSE filenum%
IF UCASE$(rID$) = "RIFF" THEN
IF UCASE$(wID$) = "WAVE" THEN
IF UCASE$(dat$) = "DATA" THEN
IF UCASE$(fID$) = "FMT " THEN
IF FormatSpecific% = 8 THEN ok% = -1
END IF
END IF
END IF
END IF
DO: LOOP UNTIL (INP(BlasterAddr% + &HC) AND 128) = 0
OUT BlasterAddr% + &HC, &HD1'Speaker ON
filenum% = FREEFILE
OPEN wavefile$ FOR BINARY AS filenum%
Num% = 0
SEEK filenum%, LenHeader% + 1
Remaining& = WavLen&
Num% = Num% + 1
IF Remaining& > watp% THEN
BufferLen% = watp%
ELSE
BufferLen% = Remaining&
END IF
Remaining& = Remaining& - BufferLen%
Buffer$ = SPACE$(BufferLen%)

GET filenum%, , Buffer$

'FOR N% = 1 TO BufferLen - 1
' OUT &H61, ASC(MID$(Buffer$, N%, 1))
' FOR G% = 1 TO 1000: NEXT
'NEXT
'OUT &H61, 2
'END

BufferLen% = BufferLen% - 1
Segment& = VARSEG(Buffer$)
Offset& = SADD(Buffer$)
IF Segment& < 0 THEN Segment& = Segment& + 65536
IF Offset& < 0 THEN Offset& = Offset& + 65536
baseaddr& = Segment& * 16 + Offset&
look1% = VARPTR(baseaddr&)
look2% = VARPTR(BufferLen%)
SELECT CASE dma%
CASE 0: dmapage% = &H87: dmaaddr% = 0: dmalen% = 1
CASE 1: dmapage% = &H83: dmaaddr% = 2: dmalen% = 3
CASE 2: dmapage% = &H81: dmaaddr% = 4: dmalen% = 5
CASE 3: dmapage% = &H82: dmaaddr% = 6: dmalen% = 7
CASE 4: dmapage% = &H8F: dmaaddr% = &HC0: dmalen% = &HC2
CASE 5: dmapage% = &H8B: dmaaddr% = &HC4: dmalen% = &HC6
CASE 6: dmapage% = &H89: dmaaddr% = &HC8: dmalen% = &HCA
CASE 7: dmapage% = &H8A: dmaaddr% = &HCC: dmalen% = &HCE
END SELECT
SELECT CASE dma%
CASE 0 TO 3: dmamask% = &HA: dmamode% = &HB: dmaclear% = &HC: dmastatus% = &H8
CASE 4 TO 7: dmamask% = &HD4: dmamode% = &HD6: dmaclear% = &HD8: dmastatus% = &HD0
END SELECT
SELECT CASE dma%
CASE 0, 4: dmaterminal% = 1
CASE 1, 5: dmaterminal% = 2
CASE 2, 6: dmaterminal% = 4
CASE 3, 7: dmaterminal% = 8
END SELECT
OUT dmamask%, dma% + 4
OUT dmaclear%, &H0
OUT dmamode%, 72 + dma%
OUT dmaaddr%, PEEK(look1%)
OUT dmaaddr%, PEEK(look1% + 1)
OUT dmapage%, PEEK(look1% + 2)
OUT dmalen%, PEEK(look2%)
OUT dmalen%, PEEK(look2% + 1)
OUT dmamask%, dma%
IF Num% = 1 THEN
timeconst% = 256 - 1000000 / (Sampling& * Channels%)
DO: LOOP UNTIL (INP(BlasterAddr% + &HC) AND 128) = 0
OUT BlasterAddr% + &HC, &H40
DO: LOOP UNTIL (INP(BlasterAddr% + &HC) AND 128) = 0
OUT BlasterAddr% + &HC, timeconst%
OUT BlasterAddr% + &H4, &H0
OUT BlasterAddr% + &H4 + 1, 0
OUT BlasterAddr% + &H4, &H22
OUT BlasterAddr% + &H4 + 1, 255
IF Channels% = 2 THEN
OUT BlasterAddr% + &H4, &HE
OUT BlasterAddr% + &H4 + 1, 34
END IF
END IF
IF bytes& > 22000 THEN
DO: LOOP UNTIL (INP(BlasterAddr% + &HC) AND 128) = 0
OUT BlasterAddr% + &HC, &H48
ELSE
DO: LOOP UNTIL (INP(BlasterAddr% + &HC) AND 128) = 0
OUT BlasterAddr% + &HC, &H14
END IF
DO: LOOP UNTIL (INP(BlasterAddr% + &HC) AND 128) = 0
OUT BlasterAddr% + &HC, PEEK(look2%)
DO: LOOP UNTIL (INP(BlasterAddr% + &HC) AND 128) = 0
OUT BlasterAddr% + &HC, PEEK(look2% + 1)
IF bytes& > 22000 THEN
DO: LOOP UNTIL (INP(BlasterAddr% + &HC) AND 128) = 0
OUT BlasterAddr% + &HC, &H91
END IF
dummy% = INP(dmastatus%)
dummy% = INP(BlasterAddr% + &HE)
OUT &H20, &H20
CLOSE filenum%
END SUB

SUB PlayWavPCS (wavefile$, watp%, FileOffset AS LONG)
 Port = &H61       'PC Speaker Port

 filenum% = FREEFILE
 OPEN wavefile$ FOR BINARY AS filenum%
  SEEK filenum%, FileOffset
  GET filenum%, , rID$
  GET filenum%, , rLen&
  GET filenum%, , wID$
  GET filenum%, , fID$
  GET filenum%, , fLen&
  GET filenum%, , wFormatTag%
  GET filenum%, , Channels%
  GET filenum%, , Sampling&
  GET filenum%, , bytes&
  GET filenum%, , nBlockAlign%
  GET filenum%, , FormatSpecific%
  'FOR i% = 1 TO fLen& - 16
  ' GET FileNum%, , dummy$
  'NEXT i%
  'GET FileNum%, , dat$
  'IF UCASE$(dat$) = "FACT" THEN
  ' GET FileNum%, , dummy&
  ' GET FileNum%, , dummy&
  ' GET FileNum%, , dat$
  'END IF
  'GET FileNum%, , WavLen&
  WavLen& = fLen&
  IF WavLen& > watp% THEN WavLen& = watp%
  DIM WavBuf AS STRING
  WavBuf = INPUT$(WavLen&, filenum%)
 CLOSE filenum%

 FOR g = 1 TO WavLen&
  'Delay 1
  FOR R = 1 TO 1200: NEXT
  OUT Port, -(ASC(MID$(WavBuf, g, 1)) > 128) * 2
 NEXT

END SUB

REM $DYNAMIC
'This subroutine is for the QuickSort algoritmn only.
FUNCTION RandInt (Lower, Upper)
    RandInt = INT(RND(1) * (Upper - Lower) + .5) + Lower
END FUNCTION

'Returns the current path in a usable form.
'WARNING: if the drive isn't ready this sub will HANG UP!!!
FUNCTION RealPath$
    RealPath$ = CurrentDrive$ + ":\" + CurrentPath$
END FUNCTION

'Similar to the CHDIR command except this can also change the current
'drive.
SUB RestorePath (A$)
    ChangeDrive LEFT$(A$, 1)
    CHDIR A$
END SUB

REM $STATIC
SUB RetraceWait
 WAIT &H3DA, 8: WAIT &H3DA, 8, 8
END SUB

FUNCTION RleCompStr$ (CompStr AS STRING)

DIM Size AS LONG, NN AS LONG, SN AS LONG, Count AS LONG
DIM SA AS STRING, SB AS STRING, SC AS STRING, SE AS STRING
DIM FF1 AS INTEGER, FF2 AS INTEGER
DIM OutStr AS STRING

Size = LEN(CompStr): NN = 0: T = 1: SN = 0: OutStr = ""
                  
StartRleCompStr:

 NN = NN + 1
 SA = MID$(CompStr, NN, 1): SB = MID$(CompStr, NN + 1, 1): SC = MID$(CompStr, NN + 2, 1)
 IF NN > Size THEN RleCompStr = OutStr: EXIT FUNCTION

 IF SA = SB THEN
  T = T + 1
  IF T = 129 THEN OutStr = OutStr + CHR$(255) + SA: T = 1
  Move = 1
 END IF

 IF Move = 1 THEN Move = 0: GOTO StartRleCompStr

 IF SA <> SB THEN
   IF T = 1 THEN IF SB = SC THEN OutStr = OutStr + CHR$(0) + SA ELSE T = T + 1: SN = NN: Move = 1
   IF Move = 1 THEN Move = 0: GOTO StartRleCompStr
   IF T > 1 THEN
     IF SN > 0 THEN
       IF SB = SC THEN
         OutStr = OutStr + CHR$(T - 1) + MID$(CompStr, SN, NN - SN + 1)
         T = 1: SN = 0
        ELSE
         T = T + 1
         IF T = 129 THEN OutStr = OutStr + CHR$(127) + MID$(CompStr, SN, NN - SN + 1): T = 1: SN = 0
       END IF
      ELSE
        OutStr = OutStr + CHR$((T - 1) OR 128) + MID$(CompStr, NN, 1)
        T = 1
     END IF
   END IF
 END IF
 GOTO StartRleCompStr


END FUNCTION

FUNCTION RleDeCompStr$ (CompStr AS STRING)
 ON LOCAL ERROR GOTO RleDecompStrErr
 DIM OutStr AS STRING, LG AS INTEGER
 DIM NN AS LONG: NN = 1: OutStr = ""
 DO
  LG = ASC(MID$(CompStr, NN, 1))
  IF (LG AND 128) = 0 THEN
    OutStr = OutStr + MID$(CompStr, NN + 1, LG + 1)
    NN = NN + 2 + LG
   ELSE
    OutStr = OutStr + STRING$(LG - 127, MID$(CompStr, NN + 1, 1))
    NN = NN + 2
  END IF
  IF NN > LEN(CompStr) THEN RleDeCompStr = OutStr: EXIT FUNCTION
 LOOP
RleDecompStrErr: RleDeCompStr = OutStr: EXIT FUNCTION: RESUME NEXT
END FUNCTION

FUNCTION RleDeCompStr2$ (CompStr AS STRING, WhileC AS INTEGER)
 ON LOCAL ERROR GOTO RleDecompStr2Err
 DIM OutStr AS STRING, SA AS STRING, SB AS STRING
 DIM NN AS LONG: NN = 1: OutStr = ""
 DO
  SA = MID$(CompStr, NN, 1)
  IF ((ASC(SA)) AND 128) = 0 THEN
    LG = ASC(SA)
    OutStr = OutStr + MID$(CompStr, NN + 1, LG + 1)
    NN = NN + 2 + LG
    IF (NN > LEN(CompStr)) OR (LEN(OutStr) > WhileC) THEN RleDeCompStr2 = OutStr: WhileC = NN - 2 - LG: EXIT FUNCTION
   ELSE
    OutStr = OutStr + STRING$(ASC(MID$(CompStr, NN, 1)) - 127, MID$(CompStr, NN + 1, 1))
    NN = NN + 2
    IF (NN > LEN(CompStr)) OR (LEN(OutStr) > WhileC) THEN RleDeCompStr2 = OutStr: WhileC = NN - 2: EXIT FUNCTION
  END IF
 LOOP
RleDecompStr2Err: RleDeCompStr2 = OutStr: WhileC = NN: EXIT FUNCTION: RESUME NEXT
END FUNCTION

FUNCTION RmLDir$ (SDR AS STRING)
 FOR RMLC = LEN(SDR) TO 1 STEP -1
  IF MID$(SDR, RMLC, 1) = "\" THEN
   RmLDir$ = LEFT$(SDR, RMLC - 1)
   EXIT FUNCTION
  END IF
 NEXT
END FUNCTION

FUNCTION RotateX# (Angle AS DOUBLE, Radius AS DOUBLE, CX AS DOUBLE)
 RotateX# = CX + (COS(Angle)) * Radius
END FUNCTION

FUNCTION RotateY# (Angle AS DOUBLE, Radius AS DOUBLE, CY AS DOUBLE)
 RotateY# = CY + (SIN(Angle)) * Radius
END FUNCTION

SUB SaveBMP8 (Pic$, X1%, Y1%, x2%, y2%)

'Calculate width and height of image-
BMPWidth% = x2% - X1% + 1
BMPHeight% = y2% - Y1% + 1
'Each raster must be a multiple of 4 bytes, this next line takes
'care of 'padded' bytes at the end of rasters of odd-width images-
IF BMPWidth% / 4 <> BMPWidth% \ 4 THEN PadBytes% = 4 - (BMPWidth% MOD 4)
OPEN Pic$ FOR BINARY AS #1
'General Picture Information-
'  BMP format marker-
Buffer$ = "BM"
'  File size minus header-
L& = (BMPWidth% + PadBytes%)
L& = L& * BMPHeight% + 1078
Buffer$ = Buffer$ + MKL$(L&)
'  Reserved 1-
Buffer$ = Buffer$ + CHR$(0) + CHR$(0)
'  Reserved 2-
Buffer$ = Buffer$ + CHR$(0) + CHR$(0)
'  Number of bytes offset to picture data-
Buffer$ = Buffer$ + MKL$(1078)
'Information Header-
'  Size of information header-
Buffer$ = Buffer$ + MKL$(40)
'  Picture width in pixels-
L& = BMPWidth%
Buffer$ = Buffer$ + MKL$(L&)
'  Picture height in pixels-
L& = BMPHeight%
Buffer$ = Buffer$ + MKL$(L&)
'  Number of planes-
Buffer$ = Buffer$ + CHR$(1) + CHR$(0)
'  Bits per pixel-
Buffer$ = Buffer$ + CHR$(8) + CHR$(0)
'  Compression-
Buffer$ = Buffer$ + MKL$(0)
'  Image size in bytes-
L& = (BMPWidth% + PadBytes%)
L& = L& * BMPHeight%
Buffer$ = Buffer$ + MKL$(L&)
'  Picture width in pixels per meter-
Buffer$ = Buffer$ + MKL$(0)
'  Picture height in pixels per meter-
Buffer$ = Buffer$ + MKL$(0)
'  Colors used in picture-
Buffer$ = Buffer$ + MKL$(256)
'  Number of important colors-
Buffer$ = Buffer$ + MKL$(256)
PUT #1, 1, Buffer$
'Save palette data-
Buffer$ = ""
FOR I% = 0 TO 255
  GetPalette I%, Red%, Green%, Blue%
  'Palette is saved B, G, R with unused byte trailing-
  Buffer$ = Buffer$ + CHR$(Blue% * 4)
  Buffer$ = Buffer$ + CHR$(Green% * 4)
  Buffer$ = Buffer$ + CHR$(Red% * 4)
  Buffer$ = Buffer$ + CHR$(0)
NEXT I%
PUT #1, , Buffer$
'Save image data-
FOR I% = (BMPHeight% - 1) TO 0 STEP -1
  Buffer$ = ""
  FOR J% = 0 TO (BMPWidth% - 1)
    Buffer$ = Buffer$ + CHR$(ABS(Future.POINT(X1% + J%, Y1% + I%)))
  NEXT J%
  IF PadBytes% > 0 THEN
    FOR J% = 1 TO PadBytes%
      Buffer$ = Buffer$ + CHR$(0)
    NEXT J%
  END IF
  PUT #1, , Buffer$
NEXT I%
'Put a fork in it, it's done-
CLOSE #1

END SUB

SUB SaveTPF (X1 AS INTEGER, Y1 AS INTEGER, x2 AS INTEGER, y2 AS INTEGER, Fln AS STRING, RLE AS INTEGER)
 DIM TPF AS TPFHeaderType, F AS INTEGER, Bff AS STRING, Bff2 AS STRING, I AS INTEGER, RleSize AS LONG
 IF ExistFile(Fln) THEN KILL Fln
 TPF.SizeX = x2 - X1: TPF.SizeY = y2 - Y1: TPF.Bpp = 8: TPF.ID = "TPSPF": TPF.Comment = "Generated By TPSSoft"
 F = FREEFILE
 Bff = SPACE$(x2 - X1 + 400)
 OPEN Fln FOR BINARY AS F
  IF RLE THEN
    TPF.FMT = "RLE"
    PUT F, , TPF
    RleSize = 0
    PUT F, , RleSize
    FOR I = Y1 TO y2
     DirectGet X1, I, x2, I, SADD(Bff), SSEG(Bff)
     Bff2 = RleCompStr(MID$(Bff, 5, x2 - X1))
     RleSize = RleSize + LEN(Bff2)
     PUT F, , Bff2
    NEXT
    PUT F, 39, RleSize
   ELSE
    TPF.FMT = "FMT"
    PUT F, , TPF
    FOR I = Y1 TO y2
     DirectGet X1, I, x2, I, SADD(Bff), SSEG(Bff)
     Bff2 = MID$(Bff, 5, x2 - X1)
     PUT F, , Bff2
    NEXT
  END IF
 CLOSE F
END SUB

FUNCTION SelectFile$ (Patterns AS STRING)
 DIM PatCol AS INTEGER, Patts(1 TO 20) AS STRING
 DIM CPS AS INTEGER, I AS INTEGER
 DIM FilesLst(1 TO 1000) AS STRING, FilesCol AS INTEGER
 DIM FilesStr AS STRING, FF AS INTEGER
 I = 1: PatCol = 0
 DO
  PatCol = PatCol + 1: IF PatCol > 500 THEN PatCol = 500: EXIT DO
  CPS = INSTR(I, Patterns, "|")
  IF CPS = 0 THEN Patts(PatCol) = MID$(Patterns, I, LEN(Patterns) - I + 1): EXIT DO
  Patts(PatCol) = MID$(Patterns, I, CPS - I)
  I = CPS + 1
 LOOP
 FF = FREEFILE: FilesCol = 0
 FOR I = 1 TO PatCol
  SOUND 200 + I * 100, 2
  SHELL "dir " + Patts(I) + " /A-D /ON /B > adgjlxvn.del"
  OPEN "adgjlxvn.del" FOR INPUT AS FF
   WHILE NOT EOF(FF)
    FilesCol = FilesCol + 1: IF FilesCol > 300 THEN FilesCol = 300: CLOSE FF: KILL "adgjlxvn.del": GOTO ProcessListFiles
    LINE INPUT #FF, FilesLst(FilesCol)
   WEND
  CLOSE FF
  KILL "adgjlxvn.del"
 NEXT

ProcessListFiles:
 FilesStr = FilesLst(1)
 FOR I = 2 TO FilesCol
  FilesStr = "|" + FilesLst(I)
 NEXT
 SelectFile = FilesLst(ListBox(FilesStr, "Choose File", 1))
END FUNCTION

DEFSNG A-Z
'QuickSorts a string array. Low=first entry High=last entry
SUB Sort (A$(), Low, High)

   IF Low < High THEN
      IF High - Low = 1 THEN
         IF A$(Low) > A$(High) THEN
            SWAP A$(Low), A$(High)
         END IF
      ELSE

         'RandIndex = RandInt(Low, High)
         SWAP A$(High), A$(RandIndex)
         Partition$ = A$(High)
         DO

            I = Low: J = High
            DO WHILE (I < J) AND (A$(I) <= Partition$)
               I = I + 1
            LOOP
            DO WHILE (J > I) AND (A$(J) >= Partition$)
               J = J - 1
            LOOP

            IF I < J THEN
               SWAP A$(I), A$(J)
            END IF
         LOOP WHILE I < J

         SWAP A$(I), A$(High)

         IF (I - Low) < (High - I) THEN
            Sort A$(), Low, I - 1
            Sort A$(), I + 1, High
         ELSE
            Sort A$(), I + 1, High
            Sort A$(), Low, I - 1
         END IF
      END IF
   END IF
END SUB

DEFINT A-Z
SUB StarField (SNum AS INTEGER)
 DIM I AS INTEGER
 FOR I = 0 TO SNum
        Future.PSET RND * 639, RND * 479, RND * 7 + 24
 NEXT
END SUB

SUB StarFld (SNum AS INTEGER, XX1 AS INTEGER, YY1 AS INTEGER, XX2 AS INTEGER, YY2 AS INTEGER)
 DIM I AS INTEGER
 FOR I = 0 TO SNum
        Future.PSET ABS(RND * (XX2 - XX1)) + XX1, ABS(RND * (YY2 - YY1)) + YY1, RND * 7 + 24
 NEXT
END SUB

SUB vGradient (X1, Y1, x2, y2, C1 AS LONG, C2 AS LONG)
DIM I AS SINGLE, Stp AS SINGLE
IF C2 = C1 THEN Stp = 1 ELSE Stp = (y2 - Y1) / (C2 - C1)
FOR I = C1 TO C2 - 1 STEP 1
 YYYY = YYY
 YYY = Y1 + (I - C1) * Stp
 IF YYY <> YYYY THEN Future.FILLBOX X1, YYY, x2, YYY + Stp, I
NEXT
END SUB

