'SUPER MARIO QB v.15
'-----------------------------------------------------------------------
'email:smarioqb@yahoo.com
'-----------------------------------------------------------------------

DEFINT A-Z

DECLARE SUB RESETDSP ()
DECLARE SUB SBDETECT ()
DECLARE SUB CLEARSB ()
DECLARE SUB LEVELFINISH ()
DECLARE SUB INTRO ()
DECLARE SUB HITBLOCK ()
DECLARE SUB DRAWOBJECT ()
DECLARE SUB SPSTATS ()
DECLARE SUB JUMPFALL ()
DECLARE SUB CONTROL ()
DECLARE SUB DRAWSPRITES ()
DECLARE SUB MULTDATA ()
DECLARE SUB DRAWFONT ()
DECLARE SUB PRINTFPS ()
DECLARE SUB FRAMES ()
DECLARE SUB SPEAKERSTATE (OnOff)
DECLARE SUB DELAY ()
DECLARE SUB ENDING ()
DECLARE SUB DRAWMARIO ()
DECLARE SUB GETFONT (y)
DECLARE SUB LOADLEVEL ()
DECLARE SUB DMAPLAY (Segment&, Offset&, buflen&)
DECLARE SUB LOADGPH (n$)
DECLARE SUB CHGCOLS (r!, g!, B!)
DECLARE SUB GETGPH ()
DECLARE SUB DRAWTILES ()
DECLARE SUB CLIPTILES ()
DECLARE SUB MASK ()
DECLARE SUB CLEARKEYS ()
DECLARE SUB SETGAME ()
DECLARE SUB NEWGAME ()
DECLARE SUB LOSELIFE ()
DECLARE FUNCTION DMADONE ()
DECLARE SUB GetBLASTER (DMA, BasePort, IRQ)
DECLARE SUB WRITEDSP (ibyte)
DECLARE SUB PLAYMUSIC ()
DECLARE SUB LOADFX (file$)
DECLARE SUB PLAYFX (fxnum)
DECLARE SUB PUTFONT (fontnum$, xstart)

COMMON SHARED xst, xnd, yst, ynd, pspd AS SINGLE, bframe, ychk, bchg, ny, xmv, ymv, sboard, s1, s2
COMMON SHARED gatedir, gate, repeat, buflen&, dnum&
COMMON SHARED n, dir, move, spframe, jump, mframe, midway, nypl, sbdir, onboard
COMMON SHARED lives, score AS LONG, xmap, ymap, fpscount, smin, snum, bk, gframe, gdir
COMMON SHARED level, world, die, nextlevel, newtile, t!, addr, cframe, cdir, msmin
COMMON SHARED BasePort, LenPort, Channel, cfrdir, frcount, fps, coins, onground
COMMON SHARED xmsz, ymsz, nosound
CONST timeconst = 256 - 1000000 \ 22050

'$DYNAMIC
DIM SHARED tiles(0 TO 33, 0 TO 500), WavBuffer(0 TO 0) AS STRING * 32767
DIM SHARED sprites(0 TO 257, 0 TO 80), msprites(0 TO 257, 0 TO 80)
DIM SHARED map(-1 TO 605, -1 TO 49), spdat(-1 TO 150, 0 TO 7)

'$STATIC
DIM SHARED pal(0 TO 2, 0 TO 255), byte AS STRING * 1, backup(0 TO 3)
DIM SHARED font(0 TO 100, 0 TO 9), plst(0 TO 6) AS LONG
DIM SHARED xpl AS LONG, ypl AS LONG
DIM SHARED sel(0 TO 2), check(0 TO 6)
DIM SHARED snds(1 TO 6) AS STRING * 30, data8(0 TO 39), data320(0 TO 39)
DIM SHARED data2560(0 TO 24) AS LONG
DIM SHARED xdata(0 TO 1), sxpl(-1 TO 150), sypl(-1 TO 150)
DIM SHARED side(0 TO 2, -1 TO 4)

SCREEN 13: CLS

DEF SEG
SBDETECT
IF nosound = 0 THEN
  GetBLASTER Channel, BasePort, IRQ
  RESETDSP
END IF

LOADFX "effects.snd"
cfrdir = 1
MULTDATA
INTRO
CLEARKEYS
DO: LOOP WHILE INKEY$ <> CHR$(13)
CLOSE
LOADGPH "graphics"
GETGPH

LINE (0, 8)-(319, 199), 0, BF
NEWGAME
COLOR 6
addr = VARSEG(tiles(0, 0))

t! = TIMER
DO
  SETGAME
  'ON ERROR GOTO fixit
  DO
    CLEARKEYS
    IF die = 0 THEN
      JUMPFALL
      CONTROL
    END IF
    SPSTATS
    DRAWTILES
    CLIPTILES
    IF coins = 100 THEN
      coins = 0: lives = lives + 1
      IF nosound = 0 THEN PLAYFX 5
    END IF
    DRAWFONT
    'PRINTFPS
    FRAMES
    'LOCATE 1, 1: PRINT repeat
    IF die > 0 THEN die = die + 1
    FOR d& = 1 TO dnum& * 2500: NEXT
  LOOP UNTIL nextlevel = 1 OR repeat < -1 OR nosound = 1 AND die > 100
  IF die > 0 THEN LOSELIFE
  CLOSE #2
LOOP

fixit:
               
PRINT plst(3); plst(2)
RESUME


level1:

'DATA 144,140,136, 164,140,136, 184,140,136
DATA 999

SUB CHGCOLS (r!, g!, B!)

'this sub controls rgb brightness and color attributes

FOR attr = 0 TO 255
  OUT &H3C8, attr
  red = pal(0, attr) * r!
  IF red > 63 THEN red = 63
  OUT &H3C9, red
  green = pal(1, attr) * g!
  IF green > 63 THEN green = 63
  OUT &H3C9, green
  blue = pal(2, attr) * B!
  IF blue > 63 THEN blue = 63
  OUT &H3C9, blue
NEXT

END SUB

SUB CLEARKEYS

DEF SEG = &H40
POKE &H1C, PEEK(&H1A)

END SUB

SUB CLIPTILES

  'this sub draws the pixels of tiles that are on the edges of the screen
 
  FOR x = 0 TO 7
    IF DMADONE AND nosound = 0 THEN PLAYMUSIC
    plst(0) = x - n + 4
    plst(2) = x + 2560
    IF x < n THEN
      xmap = xpl - 1
      plst(0) = plst(0) + 8
    ELSE
      plst(2) = plst(2) + 312
      xmap = xpl + 39
    END IF
    FOR y1 = 0 TO 24
      plst(3) = plst(2) + data2560(y1) - data320(ny)
      plst(1) = plst(0) + 68 * map(xmap, y1 + ypl)
      IF y1 < 24 THEN
        FOR y2 = 0 TO 7
          DEF SEG = addr
          attr = PEEK(plst(1) + data8(y2))
          DEF SEG = &HA000
          POKE (plst(3) + data320(y2)), attr
        NEXT
      ELSE
        FOR y2 = 0 TO ny
          DEF SEG = addr
          attr = PEEK(plst(1) + data8(y2))
          DEF SEG = &HA000
          POKE (plst(3) + data320(y2)), attr
        NEXT
      END IF
   NEXT
 NEXT
 LINE (0, 0)-(7, 7), 1, BF
 LINE (319, 0)-(303, 7), 1, BF

END SUB

SUB CONTROL

  sel(0) = INP(&H60)
  SELECT CASE sel(0)
  CASE 80, 75, 77
    sel(1) = sel(0)
    move = 1
  CASE 83
    sel(2) = sel(0)
  CASE 170, 200, 203, 205, 208
    sel(0) = 0: sel(1) = 0: sel(2) = 0
    mframe = 0: move = 0: pspd = 2
  CASE 74
    IF dnum& > 0 THEN dnum& = dnum& - 1
  CASE 78
    IF dnum& < 40 THEN dnum& = dnum& + 1
  END SELECT
  xst = 13: xnd = xst + 2
  FOR sn = 0 TO 1
      IF sn = 0 OR sel(1) <> sel(0) THEN
        SELECT CASE sel(sn)
        CASE 75
            dir = 2
            move = 1
            IF xpl > pspd - 2 THEN
              IF side(0, 4) = 0 AND side(0, 2) = 0 THEN
                n = n + pspd
              END IF
            ELSEIF spdat(0, 6) > 15 THEN
              spdat(0, 6) = spdat(0, 6) - pspd
            END IF
        CASE 77
          dir = 0
          move = 1
          IF spdat(0, 6) = 112 THEN
            IF side(2, 4) = 0 AND side(2, 2) = 0 THEN
              n = n - pspd
            END IF
          ELSE
            spdat(0, 6) = spdat(0, 6) + pspd
          END IF
      CASE 79
        IF jump = 0 AND onground = 0 OR onboard = 1 AND jump = 0 THEN
          jump = 1: onground = 1
          IF onboard = 1 THEN
            sboard = 0: sbdir = 1
            IF nosound = 0 THEN PLAYFX 6
          ELSE
            IF nosound = 0 THEN PLAYFX 1
          END IF
        END IF
      CASE 80
        'down
      CASE 1
        ENDING
        SYSTEM
      END SELECT
    END IF
  NEXT
  IF onground = 2 THEN onground = 0
  'IF sel(2) = 83 AND pspd < 4 THEN
  '  pspd = pspd + .05
  'ELSEIF pspd > 2 AND sel(2) = 0 THEN
  '  pspd = pspd - .05
  'END IF

END SUB

SUB DELAY

  t! = TIMER
  DO
    IF DMADONE AND nosound = 0 THEN PLAYMUSIC
  LOOP WHILE TIMER - t! < .01

END SUB

FUNCTION DMADONE

Count = INP(LenPort)
Count2 = INP(LenPort)
Count& = CLNG(Count + 1) * CLNG(Count2 + 1)
IF (Count& - 1) >= &HFFFF& THEN junk = INP(DSPDataAvail): DMADONE = -1

END FUNCTION

SUB DMAPLAY (Segment&, Offset&, buflen&)

Page = 0
MemLoc& = Segment& * 16 + Offset&
SELECT CASE Channel
    CASE 0
       PgPort = &H87
       AddPort = &H0
       LenPort = &H1
       ModeReg = &H48
    CASE 1
       PgPort = &H83
       AddPort = &H2
       LenPort = &H3
       ModeReg = &H49
    CASE 2
       PgPort = &H81
       AddPort = &H4
       LenPort = &H5
       ModeReg = &H4A
    CASE 3
       PgPort = &H82
       AddPort = &H6
       LenPort = &H7
       ModeReg = &H4B
END SELECT
OUT &HA, &H4 + Channel
OUT &HC, &H0
OUT &HB, ModeReg
OUT AddPort, MemLoc& AND &HFF
OUT AddPort, (MemLoc& AND &HFFFF&) \ &H100
IF (MemLoc& AND 65536) THEN Page = Page + 1
IF (MemLoc& AND 131072) THEN Page = Page + 2
IF (MemLoc& AND 262144) THEN Page = Page + 4
IF (MemLoc& AND 524288) THEN Page = Page + 8
OUT PgPort, Page
OUT LenPort, buflen& AND &HFF
OUT LenPort, (buflen& AND &HFFFF&) \ &H100
OUT &HA, Channel
WRITEDSP &H40
WRITEDSP timeconst
WRITEDSP &H14
WRITEDSP (buflen& AND &HFF)
WRITEDSP ((buflen& AND &HFFFF&) \ &H100)

END SUB

SUB DRAWFONT

PUTFONT STR$(lives), 60
PUTFONT STR$(world), 118
PUTFONT STR$(level), 134
PUTFONT STR$(score), 194
PUTFONT STR$(coins), 296

END SUB

SUB DRAWMARIO

  
  'if gframe=1 then 1/2=1
  'if gframe=2 then 2/2=0
  'if gframe=3 then 3/2=1
  IF die = 0 AND jump = 0 THEN
    chg = dir + mframe + spdat(0, 4) * 40
    PUT (spdat(0, 6), spdat(0, 3)), msprites(0, chg), AND
    PUT (spdat(0, 6), spdat(0, 3)), sprites(0, chg), XOR
    PUT (spdat(0, 6), spdat(0, 3) + 16), msprites(0, chg + 20), AND
    PUT (spdat(0, 6), spdat(0, 3) + 16), sprites(0, chg + 20), XOR
  ELSEIF jump > 0 AND die = 0 THEN
    chg = dir / 2 + 4 + spdat(0, 4) * 40
    PUT (spdat(0, 6), spdat(0, 3)), msprites(0, chg), AND
    PUT (spdat(0, 6), spdat(0, 3)), sprites(0, chg), XOR
    PUT (spdat(0, 6), spdat(0, 3) + 16), msprites(0, chg + 20), AND
    PUT (spdat(0, 6), spdat(0, 3) + 16), sprites(0, chg + 20), XOR
  END IF

END SUB

SUB DRAWSPRITES

  'new
  'spdat(snum,4)
  '0=turtle/90 1=falling shell 2=shell/114 3=gomba/86 4=flipped gomba 5=falling gomba
  '6=flying koopa/130 7=falling koopa 8=koopa 9=bcoin/94 10=bmushroom/115
  '11=b1up/116 12=bboard 13=coin/94 14=mushroom/115 15=1up/116 16=sprinboard
 
 
  SELECT CASE spdat(snum, 4)
  CASE 0: yt = 1: chg = 11 + spframe + spdat(snum, 5)
  CASE 1, 2: yt = 0: chg = 34
  CASE 3: yt = 0: chg = 7 + spframe + spdat(snum, 5)
  CASE 4, 5: yt = 0: chg = 27 + spframe + spdat(snum, 5)
  CASE 6: yt = 1: chg = 51 + spframe + spdat(snum, 5)
  CASE 7: yt = 0: chg = 67 + spframe + spdat(snum, 5)
  CASE 8: yt = 0: chg = 47 + spframe + spdat(snum, 5)
  CASE 13: yt = 0: chg = 14 + cframe
  CASE 14: yt = 0: chg = 35
  CASE 15: yt = 0: chg = 36
  CASE 16: yt = 0: chg = 54 + sboard
  CASE 20: yt = 0: chg = 18
  CASE 21: yt = 0: chg = 19
  CASE 22: yt = 0: chg = 38
  END SELECT
  FOR y = 0 TO yt
    PUT (sxpl(snum), sypl(snum) + y * 16), msprites(0, chg + y * 20), AND
    PUT (sxpl(snum), sypl(snum) + y * 16), sprites(0, chg + y * 20), XOR
  NEXT

END SUB

SUB DRAWTILES

  'This sub draws the background tiles and manages the n variable
  'Note: A special system is in place that draws the sprites right
  'after drawing the background tiles to reduce flickering
 
  IF n > 7 THEN
    n = n - 8
    xpl = xpl - 1
  ELSEIF n < 0 THEN
    n = 8 + n
    xpl = xpl + 1
    SELECT CASE xst + xpl
    CASE xmsz + xst: midway = xmsz - xst: msmin = smin
    CASE xmsz * 2 - 25: LEVELFINISH
    END SELECT
  END IF
  IF ny > 7 THEN
    ny = ny - 8
    ypl = ypl + 1
  ELSEIF ny < 0 THEN
    ny = 8 + ny
    ypl = ypl - 1
  END IF
  spdat(0, 0) = 1
  'fps: 45 to 48
  FOR xmap = 0 TO 40
    IF DMADONE AND nosound = 0 THEN PLAYMUSIC
    FOR snum = smin TO smin + 20
      IF spdat(snum, 0) = 0 THEN
        IF xmap > sxpl(snum) / 8 + 2 THEN
          DRAWSPRITES
          spdat(snum, 0) = 1
        END IF
      END IF
    NEXT
    IF spdat(0, 0) = 1 THEN
      IF xmap > spdat(0, 6) / 8 + 2 THEN DRAWMARIO: spdat(0, 0) = 2
    END IF
    IF xmap < 39 THEN
      nxpl = data8(xmap) + n
      xtile = xmap + xpl
      FOR ymap = 1 TO 23
        PUT (nxpl, data8(ymap) + 8 - ny), tiles(0, map(xtile, ymap + ypl)), PSET
      NEXT
     
      DEF SEG = VARSEG(tiles(0, 0))
     
      IF ny > 0 THEN
      bpl = VARPTR(tiles(0, map(xtile, ymap + ypl))) + 2
      POKE (bpl), ny
      PUT (nxpl, 200 - ny), tiles(0, map(xtile, ymap + ypl)), PSET
      POKE (bpl), 8
      END IF
     
      npl = ny / 2 * 8
      bpl = VARPTR(tiles(npl, map(xtile, ypl)))
      FOR bu = 0 TO 3
        backup(bu) = PEEK(bpl + bu)
        SELECT CASE bu
        CASE 0: POKE (bpl + bu), 64
        CASE 1: POKE (bpl + bu), 0
        CASE 2: POKE (bpl + bu), 8 - ny
        CASE 3: POKE (bpl + bu), 0
        END SELECT
      NEXT
      PUT (nxpl, 8), tiles(npl, map(xtile, ypl)), PSET
      FOR bu = 0 TO 3
        POKE (bpl + bu), backup(bu)
      NEXT
    END IF
 
  NEXT

END SUB

SUB ENDING

CLOSE
SCREEN 12: CLS
COLOR 15
LOCATE 2, 2: PRINT "Thanks for playing Super Mario QB. Send your"
LOCATE 3, 2: PRINT "comments to smarioqb@yahoo.com and"
LOCATE 4, 2: PRINT "be sure to watch for new releases by visiting"
LOCATE 5, 2: PRINT "Roms64.cjb.net, the new home of DarkFlare Software."
DO: LOOP WHILE INKEY$ = ""
SYSTEM

END SUB

SUB FRAMES

frcount = frcount + 1
IF frcount = 5 THEN
  frcount = 0
  IF move = 1 THEN
    mframe = mframe + 1
    IF mframe = 2 THEN mframe = 0
  END IF
  IF spframe = 0 THEN
    spframe = 1
  ELSE
    spframe = 0
  END IF
  bframe = bframe + 2
  IF bframe = 8 THEN bframe = 0
  IF gframe > 0 AND gframe < 11 THEN
    gframe = gframe + 1
    IF nosound = 0 THEN PLAYFX 4
    IF spdat(0, 4) = 0 THEN
      spdat(0, 4) = 1
    ELSE
      spdat(0, 4) = 0
    END IF
  ELSE
    gframe = 0
  END IF
  cframe = cframe + cdir
  IF cframe = 0 OR cframe = 3 THEN cdir = cdir * -1
END IF
fpscount = fpscount + 1

END SUB

SUB GetBLASTER (DMA, BasePort, IRQ)

IF LEN(ENVIRON$("BLASTER")) = 0 THEN PRINT "BLASTER environment variable not set.": EXIT SUB
FOR Length = 1 TO LEN(ENVIRON$("BLASTER"))
   SELECT CASE MID$(ENVIRON$("BLASTER"), Length, 1)
      CASE "A"
        BasePort = VAL("&H" + MID$(ENVIRON$("BLASTER"), Length + 1, 3))
      CASE "I"
        IRQ = VAL(MID$(ENVIRON$("BLASTER"), Length + 1, 1))
      CASE "D"
        DMA = VAL(MID$(ENVIRON$("BLASTER"), Length + 1, 1))
   END SELECT
NEXT

END SUB

SUB GETFONT (y)

FOR x = 0 TO 9
  GET (x * 8 + 1, y)-(x * 8 + 8, y + 7), font(0, x)
NEXT

END SUB

SUB GETGPH

FOR y = 0 TO 11
  FOR x = 0 TO 39
    GET (x * 8, y * 8 + 8)-(x * 8 + 7, y * 8 + 15), tiles(0, y * 40 + x)
  NEXT
NEXT
FOR y = 0 TO 3
  FOR x = 0 TO 19
    GET (x * 16, y * 16 + 88)-(x * 16 + 15, y * 16 + 103), sprites(0, y * 20 + x)
  NEXT
NEXT
MASK

END SUB

SUB HITBLOCK
    
   IF sxpl(snum) + 10 > spdat(0, 6) AND sxpl(snum) < spdat(0, 6) + 10 THEN
     IF sypl(snum) + 15 > spdat(0, 3) AND sypl(snum) < spdat(0, 3) + 15 THEN
       IF spdat(0, 4) = 0 THEN
         ychk = 0
       ELSE
         ychk = -1
       END IF
       jp = 0
       IF side(1, ychk) < 0 THEN
         bchg = -1
         ymv = yst + ychk
         map(xmv, ymv) = 266
         map(xmv + 1, ymv) = 267
         map(xmv, ymv + 1) = 306
         map(xmv + 1, ymv + 1) = 307
         IF spdat(snum, 4) > 9 THEN
           IF spdat(snum, 4) < 12 THEN
             spdat(snum, 3) = spdat(snum, 3) - 18
           ELSE
             spdat(snum, 3) = spdat(snum, 3) - 16
           END IF
           spdat(snum, 5) = dir - 1
         ELSEIF spdat(snum, 4) = 9 THEN
           IF nosound = 0 THEN PLAYFX 3
           spdat(snum, 5) = 1
           spdat(snum, 3) = spdat(snum, 3) - 8
           spdat(snum, 2) = spdat(snum, 3) - 16
           score = score + 50
           coins = coins + 1
         END IF
         spdat(snum, 4) = spdat(snum, 4) + 4
       END IF
     END IF
   END IF

END SUB

SUB INTRO

CHGCOLS 0, 0, 0
LOADGPH "logo"
OPEN "intro.wav" FOR BINARY AS #2
GET #2, , WavBuffer(0): buflen& = 32767
IF nosound = 0 THEN PLAYMUSIC
repeat = 0
br! = 0: bdir! = .04
DO
  CLEARKEYS
  IF br! < 1 AND br! > 0 THEN CHGCOLS br!, br!, br!
  br! = br! + bdir!
  IF br! > 2 THEN bdir! = bdir! * -1
  DELAY
LOOP WHILE br! > 0
LOADGPH "title"
CHGCOLS 1, 1, 1

END SUB

SUB JUMPFALL

  jp = 0
  yst = (spdat(0, 3) - 4 + ny) / 8 + ypl - 1: ynd = yst + 3
  IF yst < 0 THEN yst = 0
  FOR y = -1 TO 4
    FOR x = 0 TO 2
      SELECT CASE map(xpl + xst + x, yst + y)
      CASE 240 TO 251, 280 TO 291, 320 TO 331, 360 TO 371'go through blocks and land
        side(x, y) = 2
      CASE 258, 260, 262, 264
        side(x, y) = -1 'hitting blocks
      CASE 259, 261, 263, 265
        side(x, y) = -2 'hitting blocks
      CASE 240 TO 333, 360 TO 373 'hard blocks
        side(x, y) = 1
      CASE ELSE
        side(x, y) = 0
      END SELECT
    NEXT
  NEXT
  IF jump = 0 THEN
      IF side(0, 4) = 0 AND side(2, 4) = 0 THEN
        jp = 1
      ELSEIF side(1, 4) = 0 THEN
        IF side(2, 4) = 0 AND n = 0 OR side(0, 4) = 0 AND n = 6 THEN jp = 1
      END IF
      IF jp = 1 THEN
        mframe = 1: onground = 1
        IF spdat(0, 3) < 162 THEN spdat(0, 3) = spdat(0, 3) + 4
      ELSE
        side(0, 4) = side(0, 3)
        side(2, 4) = side(2, 3)
        IF onground = 1 THEN onground = 0: mframe = 0
      END IF
  ELSE
    IF spdat(0, 4) = 1 THEN
      ychk = 0
    ELSE
      ychk = 1
    END IF
    IF side(0, ychk) <> 1 AND side(2, ychk) <> 1 THEN
      jp = 2
    ELSEIF side(1, ychk) <> 1 THEN
      IF side(2, ychk) <> 1 AND n = 0 OR side(0, ychk) <> 1 AND n = 6 THEN jp = 2
    END IF
    IF jp = 2 THEN
      onground = 1
      side(0, 4) = side(0, 3)
      side(2, 4) = side(2, 3)
      IF spdat(0, 3) > 12 THEN spdat(0, 3) = spdat(0, 3) - 4
    END IF
    jump = jump + 1
    IF onboard = 0 THEN
      IF jump = 15 THEN jump = 0
    ELSE
      IF jump = 30 THEN jump = 0: onboard = 0
    END IF
  END IF
  IF spdat(0, 3) < 60 AND ypl > 0 THEN
    spdat(0, 3) = spdat(0, 3) + 2: ny = ny - 2
  ELSEIF spdat(0, 3) > 120 THEN
    IF spdat(0, 3) < 166 AND ypl < ymsz * 2 - 22 THEN
      spdat(0, 3) = spdat(0, 3) - 2: ny = ny + 2
    END IF
  END IF
  IF spdat(0, 3) > 164 THEN
    die = 1: repeat = 0
    CLOSE #2
    OPEN "die.wav" FOR BINARY AS #2
    GET #2, , WavBuffer(0): buflen& = 32767
    IF nosound = 0 THEN PLAYMUSIC
  END IF
 
END SUB

SUB LEVELFINISH

CLOSE #2
OPEN "win.wav" FOR BINARY AS #2
GET #2, , WavBuffer(0): buflen& = 32767
IF nosound = 0 THEN PLAYMUSIC
cdraw = 0
repeat = 0
DO
  CLEARKEYS
  IF cdraw < 100 THEN
    FOR chg = 0 TO 2
      LINE (chg + cdraw, chg + cdraw)-(319 - cdraw - chg, 199 - cdraw - chg), 0, B
    NEXT
  END IF
  IF cdraw >= 100 THEN
    COLOR 3
    LOCATE 13, 11: PRINT "LEVEL"; level; "COMPLETED!"
  END IF
  DELAY
  cdraw = cdraw + 3
LOOP WHILE cdraw < 300
CHGCOLS 0, 0, 0
midway = 0
msmin = 0
nextlevel = 1
level = level + 1

END SUB

SUB LOADFX (file$)

OPEN file$ FOR BINARY AS #1
DIM id AS STRING * 4
GET #1, , id
GET #1, , NumSound
FOR i = 1 TO NumSound
  IF EOF(1) THEN EXIT FOR
  GET #1, , snds(i)
  temp$ = SPACE$(20)
  GET #1, , temp$
NEXT i
CLOSE #1

END SUB

SUB LOADGPH (n$)

CHGCOLS 0, 0, 0
DEF SEG = &HA000

BLOAD n$ + ".gph", 0
OPEN n$ + ".col" FOR BINARY AS #1
FOR attr = 0 TO 255
  FOR rgb = 0 TO 2
    GET #1, attr * 3 + rgb + 1, byte
    pal(rgb, attr) = ASC(byte)
  NEXT
NEXT
CLOSE #1

END SUB

SUB LOADLEVEL

SELECT CASE level
CASE 1
  OPEN "level1.dat" FOR BINARY AS #1
  xmsz = 300: ymsz = 24
  REDIM map(-1 TO 601, 0 TO 50)
CASE 2
  OPEN "level2.dat" FOR BINARY AS #1
  xmsz = 250: ymsz = 29
  REDIM map(-1 TO 501, 0 TO 60)
END SELECT

'times 2 for x, times 40 for y

FOR y = 0 TO ymsz
  FOR ychg = 0 TO 1
    FOR x = 0 TO xmsz
      GET #1, (y * (xmsz + 1) + x) * 2 + 1, tile
      FOR xchg = 0 TO 1
        newtile = INT(tile / 20) * 40 + ychg * 40 + xchg + tile * 2
        map(x * 2 + xchg, y * 2 + ychg) = newtile
      NEXT
    NEXT
  NEXT
NEXT
CLOSE #1

END SUB

SUB LOSELIFE

  lives = lives - 1
  IF lives = 0 THEN
    CLEARKEYS
    CLS
    COLOR 1: LOCATE 13, 15: PRINT "GAME OVER"
    t! = TIMER
    DO: LOOP WHILE TIMER - t! < 2
    NEWGAME
  END IF
  CLOSE #2
  OPEN "music1.wav" FOR BINARY AS #2

END SUB

SUB MASK

FOR y1& = 0 TO 3
  FOR x1& = 0 TO 19
    FOR y2& = 0 TO 15
      FOR x2& = 0 TO 15
        pl& = y1& * 5120 + (y2& + 88) * 320 + x1& * 16 + x2&
        IF PEEK(pl&) = 0 THEN
          POKE (pl&), 255
        ELSE
          POKE (pl&), 0
        END IF
      NEXT
    NEXT
    GET (x1& * 16, y1& * 16 + 88)-(x1& * 16 + 15, y1& * 16 + 103), msprites(0, y1& * 20 + x1&)
  NEXT
NEXT

END SUB

SUB MULTDATA

FOR xy = 0 TO 39
  data8(xy) = xy * 8
  data320(xy) = xy * 320
NEXT
FOR xy& = 0 TO 24
  data2560(xy&) = xy& * 2560
NEXT

END SUB

SUB NEWGAME

  lives = 3: score = 0
  curmus = 1: coins = 0
  level = 1: world = 1
  midway = 0: msmin = 0

END SUB

SUB PLAYFX (fxnum)

  IF fxnum = 0 THEN EXIT SUB
  FOR i = 1 TO 15
    OUT &H388, ASC(MID$(snds(fxnum), (i * 2) - 1, 1))
    OUT &H389, ASC(MID$(snds(fxnum), (i * 2)))
  NEXT i

END SUB

SUB PLAYMUSIC
 
  DEF SEG
  RESETDSP
  SPEAKERSTATE 1
  IF repeat >= 0 THEN DMAPLAY VARSEG(WavBuffer(0)), VARPTR(WavBuffer(0)), buflen&
  IF EOF(2) THEN
    SEEK #2, 44
    IF repeat <= 0 THEN repeat = repeat - 1
  END IF
  buflen& = LOF(2) - LOC(2)
  IF buflen& > 32767 THEN buflen& = 32767
  GET #2, , WavBuffer(0)
 
END SUB

SUB PRINTFPS

IF TIMER - t! > .99 THEN
  fps = fpscount
  fpscount = 0
  t! = TIMER
END IF
LOCATE 1, 1: PRINT fps

END SUB

SUB PUTFONT (fontnum$, xstart)

FOR x = 2 TO LEN(fontnum$)
  PUT ((x - 2) * 8 + xstart, 0), font(0, VAL(MID$(fontnum$, x, 1))), PSET
NEXT

END SUB

SUB RESETDSP
         
OUT BasePort + 6, 1
FOR Count = 1 TO 4
   junk = INP(BasePort + 6)
NEXT
OUT BasePort + 6, 0

END SUB

SUB SBDETECT

nosound = 1
FOR port = &H210 TO &H280 STEP &H10
  OUT port + &H6, 1
  FOR Count = 1 TO 100
    OUT port + &H6, 0
    Stat = INP(port + &HE)
    Stat = INP(port + &HA)
    IF Stat = &HAA THEN nosound = 0: EXIT SUB
  NEXT Count
NEXT port
IF nosound = 1 THEN
   PRINT "Sound Blaster not detected. Do you"
   PRINT "wish to disable sound? (y,n)"
   DO: sel$ = INKEY$: LOOP WHILE UCASE$(sel$) <> "Y" AND UCASE$(sel$) <> "N"
   IF UCASE$(sel$) = "N" THEN END
END IF

END SUB

SUB SETGAME
 
  DEF SEG
  SELECT CASE level
  CASE 1: OPEN P$ + "sprites1.dat" FOR BINARY AS #1
  CASE 2: OPEN P$ + "sprites2.dat" FOR BINARY AS #1
  CASE 3: ENDING
  END SELECT
    FOR snum = 1 TO 150
      FOR n = 0 TO 4
        GET #1, , spdat(snum, n)
      NEXT
      SELECT CASE spdat(snum, 4)
      CASE 0, 3, 6, 8: spdat(snum, 5) = -1
      CASE ELSE: spdat(snum, 5) = 0
      END SELECT
      spdat(snum, 3) = spdat(snum, 3) + 8
      spdat(snum, 6) = spdat(snum, 1)
    NEXT
  CLOSE #1
  LOADLEVEL
  LOADGPH "graphics"
  sel(0) = 0
  sel(1) = 0
  onboard = 0
  bframe = 0
  repeat = 1
  gatedir = 1
  gate = 0
  smin = 1
  spdat(0, 0) = 1
  spdat(0, 4) = 0
  cframe = 0
  gframe = 0
  mframe = 0
  move = 0
  pspd = 2
  sbdir = 1
  cdir = 1
  dir = 0
  move = 0
  die = 0
  n = 0
  ny = 0
  xpl = midway
  nextlevel = 0
  smin = msmin
  ypl = 22
  onground = 0
  t! = TIMER
  OPEN "music1.wav" FOR BINARY AS #2
  GETFONT 192
  spdat(0, 6) = 112
  SELECT CASE level
  CASE 1
    ypl = 22: spdat(0, 3) = 121
  CASE 2
    ypl = 35: spdat(0, 3) = 121
    IF midway > 0 THEN ypl = 10
  END SELECT
  GET #2, , WavBuffer(0): buflen& = 32767
  IF nosound = 0 THEN PLAYMUSIC
  CHGCOLS 1, 1, 1

END SUB

SUB SPEAKERSTATE (OnOff)

IF OnOff THEN WRITEDSP &HD1 ELSE WRITEDSP &HD3

END SUB

SUB SPSTATS
 
  'spdat(snum,0)
  ' 0=visible/moving 1=invisible/moving 2=visible 3=invisible 4=dead

  'new
  'spdat(snum,4)
  '0=turtle/90 1=falling shell 2=shell/114 3=gomba/86 4=flipped gomba 5=falling gomba
  '6=flying koopa/130 7=falling koopa 8=koopa 9=bcoin/94 10=bmushroom/115
  '11=b1up/116 12=bboard 13=coin/94 14=mushroom/115 15=1up/116 16=sprinboard

  check = 0
  bchg = 0
  gcheck = 0
  fsize = smin - 10
  IF fsize < 1 THEN fsize = 1
  FOR snum = fsize TO fsize + 30
      SELECT CASE spdat(snum, 4)
      CASE 0, 3, 6, 8
          spdat(snum, 6) = spdat(snum, 6) - spdat(snum, 5)
          IF spdat(snum, 6) = spdat(snum, 1) OR spdat(snum, 6) = spdat(snum, 2) THEN spdat(snum, 5) = spdat(snum, 5) * -1
      CASE 1
        IF spdat(snum, 3) < spdat(snum, 2) THEN
          spdat(snum, 3) = spdat(snum, 3) + 2
        ELSE
          spdat(snum, 4) = 2
          spdat(snum, 5) = 0
        END IF
      CASE 2, 14, 15
        IF spdat(snum, 5) <> 0 AND spdat(snum, 0) = 1 THEN
            IF spdat(snum, 5) > 0 THEN
              xchk = 2
            ELSE
              xchk = 0
            END IF
            IF map((spdat(snum, 6) - 4) / 8 + xchk, (spdat(snum, 3) - 4) / 8 + 1) < 240 THEN
              IF sypl(snum) < 180 THEN
                spdat(snum, 3) = spdat(snum, 3) + 2
              ELSE
                spdat(snum, 0) = 2
              END IF
            END IF
            FOR xchk = 0 TO 2 STEP 2
                IF map((spdat(snum, 6) - 4) / 8 + xchk, spdat(snum, 3) / 8) > 240 THEN
                  spdat(snum, 5) = spdat(snum, 5) * -1
                  IF spdat(snum, 4) = 2 AND nosound = 0 THEN PLAYFX 2
                END IF
                IF sxpl(snum) < -100 OR sxpl(snum) > 400 THEN
                  spdat(snum, 0) = 2
                END IF
              NEXT
              spdat(snum, 6) = spdat(snum, 6) - spdat(snum, 5)
              IF spdat(snum, 6) < 4 THEN spdat(snum, 0) = 2
              IF spdat(snum, 4) = 2 AND spdat(snum, 5) <> 0 THEN
                FOR hnum = smin TO smin + 20
                  IF hnum <> snum AND spdat(snum, 0) < 2 THEN
                    IF spdat(snum, 6) + 15 > spdat(hnum, 6) AND spdat(snum, 6) < spdat(hnum, 6) + 15 THEN
                      IF spdat(snum, 3) + 15 > spdat(hnum, 3) AND spdat(snum, 3) < spdat(hnum, 3) + 31 THEN
                        SELECT CASE spdat(hnum, 4)
                        CASE 0, 3, 4, 6, 8
                          IF nosound = 0 THEN PLAYFX 2
                          score = score + 100
                          SELECT CASE spdat(hnum, 4)
                          CASE 0: spdat(hnum, 4) = 1: spdat(hnum, 2) = ymsz * 16
                          CASE 3 TO 4: spdat(hnum, 4) = 5
                          CASE 8: spdat(hnum, 4) = 7
                          CASE ELSE: spdat(hnum, 0) = 2
                          END SELECT
                          EXIT FOR
                        END SELECT
                      END IF
                    END IF
                  END IF
                NEXT
              END IF
            END IF
      CASE 5, 7
        spdat(snum, 3) = spdat(snum, 3) + 4
      CASE 13
        IF spdat(snum, 5) > 0 THEN
          spdat(snum, 3) = spdat(snum, 3) - 2
          IF spdat(snum, 3) < spdat(snum, 2) THEN spdat(snum, 0) = 2
        END IF
      CASE 22
         IF gcheck = 0 THEN
           gate = gate + gatedir
           IF gate = 0 OR gate = 64 THEN gatedir = gatedir * -1
           gcheck = -1
           spdat(snum, 3) = spdat(snum, 3) + gatedir
           spdat(snum + 1, 3) = spdat(snum + 1, 3) + gatedir
         END IF
      END SELECT
      sxpl(snum) = spdat(snum, 6) - xpl * 8 + n
      sypl(snum) = spdat(snum, 3) - ypl * 8 - ny
      IF spdat(snum, 3) >= ymsz * 16 THEN spdat(snum, 0) = 2
      IF sxpl(snum) >= 0 AND sxpl(snum) <= 303 THEN
        IF check = 0 THEN smin = snum: check = -1
        IF sypl(snum) > 7 THEN
          jp = 0
          IF sypl(snum) < 167 THEN jp = 1
          IF spdat(snum, 4) <> 0 AND spdat(snum, 4) <> 6 AND sypl(snum) < 183 THEN jp = 1
          IF spdat(snum, 4) > 8 AND spdat(snum, 4) < 13 THEN jp = 1
          IF jp = 1 THEN
            SELECT CASE spdat(snum, 4)
            CASE IS < 9, IS > 12
              IF spdat(snum, 0) = 1 THEN spdat(snum, 0) = 0
            END SELECT
            edge = 1
          END IF
        END IF
      ELSEIF sxpl(snum) >= n - 16 AND sxpl(snum) <= 312 + n THEN
        edge = 2
      ELSE
        edge = 0
      END IF
      IF edge = 1 AND spdat(snum, 0) = 0 THEN
        IF sxpl(snum) + 15 > spdat(0, 6) AND sxpl(snum) < spdat(0, 6) + 15 THEN
          IF spdat(0, 3) + 31 > sypl(snum) AND spdat(0, 3) < sypl(snum) + 15 THEN
            SELECT CASE spdat(snum, 4)
            CASE 0, 2, 3, 4, 6, 8
              IF jump = 0 AND onground = 1 OR spdat(snum, 4) = 4 THEN
                score = score + 100
                IF nosound = 0 THEN PLAYFX 2
                IF spdat(snum, 4) = 0 THEN
                  spdat(snum, 2) = spdat(snum, 3) + 16
                END IF
                IF spdat(snum, 4) = 2 AND spdat(snum, 5) = 0 THEN
                  IF nosound = 0 THEN PLAYFX 2
                  spdat(snum, 5) = (dir - 1) * 3
                ELSEIF spdat(snum, 4) = 2 THEN
                  IF nosound = 0 THEN PLAYFX 2
                  spdat(snum, 5) = 0
                ELSEIF spdat(snum, 4) < 8 THEN
                  spdat(snum, 4) = spdat(snum, 4) + 1
                ELSEIF spdat(snum, 4) = 8 THEN
                  spdat(snum, 4) = 7
                ELSE
                  spdat(snum, 0) = 2
                END IF
                IF spdat(snum, 4) <> 2 OR onground = 1 THEN jump = 4
                EXIT FOR
              ELSEIF die = 0 AND gframe = 0 THEN
                IF spdat(snum, 5) <> 0 THEN
                  IF spdat(0, 4) = 1 THEN
                    gframe = 1
                    spdat(0, 4) = 0
                  ELSEIF spdat(0, 4) = 0 THEN
                    die = 1: repeat = 0
                    CLOSE #2
                    OPEN "die.wav" FOR BINARY AS #2
                    GET #2, , WavBuffer(0): buflen& = 32767
                    IF nosound = 0 THEN PLAYMUSIC
                  END IF
                ELSE
                  IF nosound = 0 THEN PLAYFX 2
                  spdat(snum, 5) = (dir - 1) * 3
                END IF
              END IF
            CASE 13
              IF spdat(snum, 5) = 0 THEN
                IF nosound = 0 THEN PLAYFX 3
                coins = coins + 1
                spdat(snum, 0) = 2
                score = score + 50
              END IF
            CASE 14
              IF spdat(0, 4) = 0 THEN spdat(0, 4) = 1: gframe = 1
              spdat(snum, 0) = 2
              score = score + 500
            CASE 15
              lives = lives + 1: spdat(snum, 0) = 2
              IF nosound = 0 THEN PLAYFX 5
            CASE 16
              IF onboard = 0 THEN jump = 0
              onboard = 1
              IF frcount = 3 AND jump = 0 THEN
                sboard = sboard + sbdir
                IF sboard = 0 OR sboard = 2 THEN sbdir = sbdir * -1
              END IF
              spdat(0, 3) = sypl(snum) - 31 + sboard * 4
            END SELECT
          END IF
        ELSEIF spdat(snum, 4) = 16 THEN
          sboard = 0: sbdir = 1
          IF jump = 0 THEN onboard = 0
        END IF
      END IF
      SELECT CASE spdat(snum, 4)
      CASE 9 TO 12
        xmv = (sxpl(snum) - n) / 8 + xpl
        ymv = (sypl(snum) + ny) / 8 + ypl
        map(xmv, ymv - 1) = 258 + bframe
        map(xmv + 1, ymv - 1) = 259 + bframe
        map(xmv, ymv) = 298 + bframe
        map(xmv + 1, ymv) = 299 + bframe
        IF bchg = 0 THEN HITBLOCK
      END SELECT
  NEXT

END SUB

SUB WRITEDSP (ibyte)

DO: LOOP WHILE INP(BasePort + 12) AND &H80
OUT BasePort + 12, ibyte

END SUB

