'$DYNAMIC
'Gameplay
DECLARE FUNCTION Skbit% ()
DECLARE SUB TypedText2 (Text$, Ypo%)
DECLARE SUB InitData ()
DECLARE SUB InitEvents ()
DECLARE SUB Youvewon ()
DECLARE SUB PositionCar ()
DECLARE SUB Outro ()
DECLARE SUB Intro ()
DECLARE SUB TypedText (Text$, Ypo%)
DECLARE SUB DrawScreen ()
DECLARE SUB ShowIntro ()
DECLARE FUNCTION Hor% (T%)
DECLARE SUB CheckCollision ()
DECLARE SUB UpdateEvents ()
DECLARE SUB Deactivate (T%)
DECLARE SUB InitEvent (T%)
DECLARE SUB PlayGame ()
DECLARE SUB DELAY (T%)
DECLARE SUB DisplayMap ()
DECLARE SUB LoadMap (FileName$)
'Graphics
DECLARE SUB SmallPrint (SrSeg%, SrOff%, X%, Y%, Temp$, Col%)
DECLARE SUB BigPrint (SrSeg%, SrOff%, X%, Y%, Temp$, Col%)
DECLARE SUB LoadFonts ()
DECLARE SUB Fadein ()
DECLARE SUB fadeout ()
DECLARE SUB SetColor (T%, R%, G%, B%)
DECLARE SUB LoadGraphics ()
DECLARE SUB LoadPalette ()
'Asm Routines
DECLARE SUB TouPset (BYVAL ScrSeg%, BYVAL ScrOff%, BYVAL X%, BYVAL Y%, BYVAL Col%)
DECLARE SUB TouPcopy (BYVAL ScrSeg%, BYVAL ScrOff%, BYVAL toSeg%, BYVAL ToOff%)
DECLARE SUB TouCls (BYVAL ScrSeg%, BYVAL ScrOff%, BYVAL Col%)
DECLARE SUB TouFastCls (BYVAL ScrSeg%, BYVAL ScrOff%)
DECLARE SUB TouTilePut (BYVAL ScrSeg%, BYVAL ScrOff%, BYVAL SprSeg%, BYVAL SprOff%, BYVAL X%, BYVAL Y%)
DECLARE SUB TouSolidPut (BYVAL ScrSeg%, BYVAL ScrOff%, BYVAL SprSeg%, BYVAL SprOff%, BYVAL X%, BYVAL Y%)
DECLARE SUB TouPut (BYVAL ScrSeg%, BYVAL ScrOff%, BYVAL SprSeg%, BYVAL SprOff%, BYVAL X%, BYVAL Y%, BYVAL Inv%)
DECLARE SUB TouIPut (BYVAL ScrSeg%, BYVAL ScrOff%, BYVAL SprSeg%, BYVAL SprOff%, BYVAL X%, BYVAL Y%, BYVAL Inv%)
DECLARE SUB TouGet (BYVAL ScrSeg%, BYVAL ScrOff%, BYVAL SprSeg%, BYVAL SprOff%, BYVAL X1%, BYVAL Y1%, BYVAL X2%, BYVAL Y2%)
DECLARE SUB TouClipPut (BYVAL ScrSeg%, BYVAL ScrOff%, BYVAL SprSeg%, BYVAL SprOff%, BYVAL X%, BYVAL Y%)
DECLARE SUB TouClipPut2 (BYVAL ScrSeg%, BYVAL ScrOff%, BYVAL SprSeg%, BYVAL SprOff%, BYVAL X%, BYVAL Y%)
DECLARE SUB TouFillBox (BYVAL ScrSeg%, BYVAL ScrOff%, BYVAL X1%, BYVAL Y1%, BYVAL X2%, BYVAL Y2%, BYVAL Col%)
DECLARE SUB TouBox (BYVAL ScrSeg%, BYVAL ScrOff%, BYVAL X1%, BYVAL Y1%, BYVAL X2%, BYVAL Y2%, BYVAL Col%)
'Keyboard routines by Alan O' Hagan
DECLARE FUNCTION CSAsc% (BYVAL ScanCode%, BYVAL Shift%)
DECLARE FUNCTION CSCheckKeys% ()
DECLARE FUNCTION CSKey% (BYVAL ScanCode%)
DECLARE FUNCTION CSReadKey% ()
DECLARE SUB CSInstallKeyBoard ()
DECLARE SUB CSLockKeys (BYVAL LKey%, BYVAL State%)
DECLARE SUB CSRemoveKeyBoard ()
DECLARE SUB CSWaitKey (BYVAL ScanCode%)

DIM SHARED GraphicsNum%: GraphicsNum% = 74
DIM SHARED buffer%(31999)
DIM SHARED PassMap%(799, 8)
DIM SHARED Map%(799, 8)
DIM SHARED Event%(799), TankTimer!, TankTimer2!
DIM SHARED Red%(255), Green%(255), Blue%(255)
DIM SHARED Tiles%(201, GraphicsNum%)
DIM SHARED Cars%(451, 58), Crash%, Lives%
DIM SHARED Xpos%, Ypos%, Xoffset%, Xp%, Yp%, PlayerCar%
DIM SHARED PlayerFrame%, Fpt!, Fs%, Speedup%
DIM SHARED SmallFont%(26, 33 TO 126)
DIM SHARED NpcX%(75), NpcY%(75), NpcActive%(75), NpcGraphic%(75)
DIM SHARED Difficulty%

RANDOMIZE TIMER

WIDTH 80
InitData
SCREEN 13
LoadPalette

Intro
Outro

OPEN "gamesys.cfg" FOR BINARY AS #1
  PUT #1, , Difficulty%
  PUT #1, , Speedup%
CLOSE #1

END

REM $STATIC
SUB BigPrint (SrSeg%, SrOff%, X%, Y%, Temp$, Col%)

FOR I% = 1 TO LEN(Temp$)
  Temp% = ASC(MID$(Temp$, I%, 1))
  Wid% = 4
  IF Temp% >= 33 AND Temp% <= 126 THEN
    Wid% = SmallFont%(0, Temp%) + 1
    FOR Yt% = 1 TO SmallFont%(1, Temp%)
      FOR Xt% = 1 TO Wid% - 1
        J% = SmallFont%(1 + ((Xt%) + ((Yt% - 1) * (Wid% - 1))), Temp%)
        IF J% <> 0 THEN
          TouPset SrSeg%, SrOff%, X% + (Xt% * 2), Y% + (Yt% * 2), Col%
          TouPset SrSeg%, SrOff%, X% + (Xt% * 2) + 1, Y% + (Yt% * 2), Col%
          TouPset SrSeg%, SrOff%, X% + (Xt% * 2), Y% + (Yt% * 2) + 1, Col%
          TouPset SrSeg%, SrOff%, X% + (Xt% * 2) + 1, Y% + (Yt% * 2) + 1, Col%
        END IF
      NEXT Xt%
    NEXT Yt%
  END IF
  X% = X% + (Wid% * 2)
NEXT I%

END SUB

SUB CheckCollision

'The most important sub, and the hardest to code...

Crash% = 0

'First, Check with Walls above and infront
Xt% = INT((Xp% + (Xpos% * 20) + Xoffset% + 30) / 20)
Yt% = (Yp% - (Yp% MOD 20)) / 20
IF PassMap%(Xt%, Yt%) = 1 THEN Crash% = 1
'Next, Check with Walls below and infront
Yt% = ((Yp% + 9) - ((Yp% + 9) MOD 20)) / 20
IF PassMap%(Xt%, Yt%) = 1 THEN Crash% = 1
'Next, Check with Walls above and behind
Xt% = INT((Xp% + (Xpos% * 20) + Xoffset%) / 20)
Yt% = (Yp% - (Yp% MOD 20)) / 20
IF PassMap%(Xt%, Yt%) = 1 THEN Crash% = 1
'Next, Check with Walls below and behind
Yt% = ((Yp% + 9) - ((Yp% + 9) MOD 20)) / 20
IF PassMap%(Xt%, Yt%) = 1 THEN Crash% = 1

'Next, Horizontal Cars
FOR I% = 0 TO 75
  IF NpcActive%(I%) > 0 THEN
    IF Hor%(NpcGraphic%(I%)) = 1 THEN
      IF ABS(Xp% - NpcX%(I%)) <= 27 THEN
        IF ABS(Yp% - NpcY%(I%)) <= 10 THEN
          Crash% = 1
        END IF
      END IF
    END IF
  END IF
NEXT I%

'Next, Verticle Cars and Bullets
FOR I% = 0 TO 75
  IF NpcActive%(I%) > 0 THEN
    IF Hor%(NpcGraphic%(I%)) = 2 THEN
      IF ABS(Xp% - NpcX%(I%)) <= 16 THEN
        IF ABS(Yp% - NpcY%(I%) - 2) <= 18 THEN
          Crash% = 1
        END IF
      END IF
    END IF
    IF Hor%(NpcGraphic%(I%)) = 4 THEN
      IF ABS(Xp% - NpcX%(I%)) <= 20 THEN
        IF ABS(Yp% - NpcY%(I%)) <= 10 THEN
          Crash% = 1
        END IF
      END IF
    END IF
  END IF
NEXT I%

'Next, Noveltys
FOR I% = 40 TO 75
  IF NpcActive%(I%) > 0 THEN
    IF NpcActive%(40) = 1 THEN
      IF Xp% <= 40 THEN
        Crash% = 1
      END IF
    END IF
    IF Hor%(NpcGraphic%(I%)) = 4 THEN
      IF ABS(Xp% - NpcX%(I%)) <= 20 THEN
        IF ABS(Yp% - NpcY%(I%)) <= 10 THEN
          Crash% = 1
        END IF
      END IF
    END IF
    IF Hor%(NpcGraphic%(I%)) = 5 THEN
      IF ABS(Xp% - NpcX%(I%)) <= 25 THEN
        IF ABS(Yp% - NpcY%(I%)) <= 15 THEN
          Crash% = 1
        END IF
      END IF
    END IF
  END IF
NEXT I%

END SUB

SUB Deactivate (T%)

NpcActive%(T%) = 0
NpcGraphic%(T%) = 0
NpcX%(T%) = 0
NpcY%(T%) = 0

END SUB

SUB DELAY (T%)

FOR I% = 0 TO (T% - 1)
  WAIT &H3DA, 8, 8
  WAIT &H3DA, 8
NEXT I%

END SUB

SUB DisplayMap

FOR Y% = 0 TO 8
  FOR X% = 0 TO 16
    T% = Map%(X% + Xpos%, Y%)
    TouClipPut VARSEG(buffer%(0)), VARPTR(buffer%(0)), VARSEG(Tiles%(0, T%)), VARPTR(Tiles%(0, T%)), (X% * 20) - Xoffset%, (Y% * 20) + 10
  NEXT X%
NEXT Y%

END SUB

SUB DrawScreen
 
DisplayMap

FOR I% = 0 TO 75
  IF NpcActive%(I%) > 0 THEN
    TouClipPut2 VARSEG(buffer%(0)), VARPTR(buffer%(0)), VARSEG(Cars%(0, NpcGraphic%(I%))), VARPTR(Cars%(0, NpcGraphic%(I%))), NpcX%(I%), NpcY%(I%)
  END IF
NEXT I%
TouPut VARSEG(buffer%(0)), VARPTR(buffer%(0)), VARSEG(Cars%(0, PlayerCar% + PlayerFrame%)), VARPTR(Cars%(0, PlayerCar% + PlayerFrame%)), Xp%, Yp%, 0

TouFillBox VARSEG(buffer%(0)), VARPTR(buffer%(0)), 0, 0, 319, 9, 0
TouFillBox VARSEG(buffer%(0)), VARPTR(buffer%(0)), 0, 190, 319, 199, 0

END SUB

SUB Fadein

FOR I2% = 0 TO 63
  FOR I% = 0 TO 255
    OUT &H3C7, I%
    R% = INP(&H3C9)
    G% = INP(&H3C9)
    B% = INP(&H3C9)
    R% = R% + 1: G% = G% + 1: B% = B% + 1
    IF R% > Red%(I%) THEN R% = Red%(I%)
    IF G% > Green%(I%) THEN G% = Green%(I%)
    IF B% > Blue%(I%) THEN B% = Blue%(I%)
    SetColor I%, R%, G%, B%
  NEXT I%
NEXT I2%

END SUB

SUB fadeout

FOR I2% = 0 TO 63
  FOR I% = 0 TO 255
    OUT &H3C7, I%
    R% = INP(&H3C9)
    G% = INP(&H3C9)
    B% = INP(&H3C9)
    R% = R% - 1: G% = G% - 1: B% = B% - 1
    IF R% < 0 THEN R% = 0
    IF G% < 0 THEN G% = 0
    IF B% < 0 THEN B% = 0
    SetColor I%, R%, G%, B%
  NEXT I%
NEXT I2%

END SUB

FUNCTION Hor% (T%)

Hor% = 0

SELECT CASE T%
  CASE 3 TO 5, 12 TO 17, 24 TO 29, 36 TO 41, 48 TO 50
    Hor% = 1
  CASE 6 TO 11, 18 TO 23, 30 TO 35, 42 TO 47
    Hor% = 2
  CASE 53
    Hor% = 4
  CASE 51, 52
    Hor% = 5
END SELECT

END FUNCTION

SUB InitData

CLS

COLOR 15, 4
PRINT " 'The Hunt' by Terry Cavanagh 2002                                 Final Version"
COLOR 7, 0
PRINT
PRINT "Loading Fonts ....."
LoadFonts
LOCATE 3, 1: PRINT "Loading Fonts DONE!"
PRINT "Loading Graphics ....."
LoadGraphics
LOCATE 4, 1: PRINT "Loading Graphics DONE!"
PRINT "Loading Road Info ....."
LoadMap "road.dat"
LOCATE 5, 1: PRINT "Loading Road Info DONE!"
PRINT "Loading Setup Information ....."
OPEN "gamesys.cfg" FOR BINARY AS #1
  GET #1, , Difficulty%
  GET #1, , Speedup%
CLOSE #1
LOCATE 6, 1: PRINT "Loading Setup Information DONE!"
PRINT
PRINT "Press any key to begin..."
SLEEP

END SUB

SUB InitEvent (T%)

T2% = 40
FOR I% = 0 TO 40
  IF NpcActive%(I%) = 0 THEN T2% = I%: EXIT FOR
NEXT I%

IF T2% = 40 THEN EXIT SUB

SELECT CASE T%
  CASE 1
    NpcActive%(40) = 1
    NpcGraphic%(40) = 54
    NpcX%(40) = -15
    NpcY%(40) = Yp% - 15
 
    NpcActive%(41) = 1
    NpcGraphic%(41) = 55
    NpcX%(41) = 15
    NpcY%(41) = Yp% - 15
  
    NpcActive%(42) = 1
    NpcGraphic%(42) = 56
    NpcX%(42) = -15
    NpcY%(42) = Yp% + 15

    NpcActive%(43) = 1
    NpcGraphic%(43) = 57
    NpcX%(43) = 15
    NpcY%(43) = Yp% + 15
    TankTimer! = TIMER + 1
    TankTimer2! = TIMER + 1
  CASE 2
    NpcActive%(T2%) = 2
    NpcGraphic%(T2%) = 53
    NpcX%(T2%) = 15
    NpcY%(T2%) = NpcY%(43) - 15
  CASE 3
    NpcActive%(T2%) = 2
    NpcGraphic%(T2%) = 53
    NpcX%(T2%) = 15
    Tr% = -3 + (INT(2 * RND) * 37)
    NpcY%(T2%) = NpcY%(41) + Tr%
  CASE 4
    NpcActive%(40) = 4
    NpcGraphic%(40) = 54
    NpcX%(40) = 335
    NpcY%(40) = 110
  
    NpcActive%(41) = 4
    NpcGraphic%(41) = 55
    NpcX%(41) = 365
    NpcY%(41) = 110
  
    NpcActive%(42) = 4
    NpcGraphic%(42) = 56
    NpcX%(42) = 335
    NpcY%(42) = 140
  
    NpcActive%(43) = 4
    NpcGraphic%(43) = 57
    NpcX%(43) = 365
    NpcY%(43) = 140

  CASE 5
    NpcActive%(40) = 5
    NpcGraphic%(40) = 54
    NpcX%(40) = -30
    NpcY%(40) = Yp% - 15

    NpcActive%(41) = 5
    NpcGraphic%(41) = 55
    NpcX%(41) = 0
    NpcY%(41) = Yp% - 15
 
    NpcActive%(42) = 5
    NpcGraphic%(42) = 56
    NpcX%(42) = -30
    NpcY%(42) = Yp% + 15

    NpcActive%(43) = 5
    NpcGraphic%(43) = 57
    NpcX%(43) = 0
    NpcY%(43) = Yp% + 15
  CASE 6
    NpcActive%(40) = 0
    NpcActive%(41) = 0
    NpcActive%(42) = 0
    NpcActive%(43) = 0
  CASE 7
    fadeout
    Youvewon
  CASE 8
    NpcActive%(I%) = 6
    NpcGraphic%(I%) = 24
    NpcX%(I%) = 320
    NpcY%(I%) = 120
  CASE 9
    NpcActive%(I%) = 6
    NpcGraphic%(I%) = 36
    NpcX%(I%) = 320
    NpcY%(I%) = 120
  CASE 10
    NpcActive%(I%) = 6
    NpcGraphic%(I%) = 48
    NpcX%(I%) = 320
    NpcY%(I%) = 120
  CASE 11
    NpcActive%(40) = 7
    NpcGraphic%(40) = 42
    NpcX%(40) = 325
    NpcY%(40) = -30
   
    NpcActive%(41) = 7
    NpcGraphic%(41) = 33
    NpcX%(41) = 325
    NpcY%(41) = -130
   
    NpcActive%(42) = 7
    NpcGraphic%(42) = 21
    NpcX%(42) = 325
    NpcY%(42) = -230
   
    NpcActive%(43) = 7
    NpcGraphic%(43) = 33
    NpcX%(43) = 325
    NpcY%(43) = -430
   
    NpcActive%(44) = 8
    NpcGraphic%(44) = 45
    NpcX%(44) = 295
    NpcY%(44) = 230
  
    NpcActive%(45) = 8
    NpcGraphic%(45) = 30
    NpcX%(45) = 295
    NpcY%(45) = 330
  
    NpcActive%(46) = 8
    NpcGraphic%(46) = 30
    NpcX%(46) = 295
    NpcY%(46) = 430
  
    NpcActive%(47) = 8
    NpcGraphic%(47) = 45
    NpcX%(47) = 295
    NpcY%(47) = 630
 
  CASE 12
    NpcActive%(48) = 7
    NpcGraphic%(48) = 42
    NpcX%(48) = 325
    NpcY%(48) = -30
  
    NpcActive%(49) = 7
    NpcGraphic%(49) = 33
    NpcX%(49) = 325
    NpcY%(49) = -430
  
    NpcActive%(50) = 8
    NpcGraphic%(50) = 30
    NpcX%(50) = 295
    NpcY%(50) = 330
 
    NpcActive%(51) = 8
    NpcGraphic%(51) = 30
    NpcX%(51) = 295
    NpcY%(51) = 430
  
  CASE 13
    NpcActive%(I%) = 9
    Tt% = INT(3 * RND)
    IF Tt% = 0 THEN Tt% = 24
    IF Tt% = 1 THEN Tt% = 48
    IF Tt% = 2 THEN Tt% = 36
    NpcGraphic%(I%) = Tt%
    NpcX%(I%) = 320
    NpcY%(I%) = 40

  CASE 14
    NpcActive%(40) = 10
    NpcActive%(41) = 10
    NpcGraphic%(40) = 51
    NpcGraphic%(41) = 52
    NpcY%(40) = 65
    NpcY%(41) = 65
    NpcX%(40) = 320
    NpcX%(41) = 350
  CASE 15
    NpcActive%(I%) = 9
    Tt% = INT(3 * RND)
    IF Tt% = 0 THEN Tt% = 24
    IF Tt% = 1 THEN Tt% = 48
    IF Tt% = 2 THEN Tt% = 36
    NpcGraphic%(I%) = Tt%
    NpcX%(I%) = 320
    NpcY%(I%) = 23
 
  CASE 16
    NpcActive%(50) = 7
    NpcGraphic%(50) = 42
    NpcX%(50) = 325
    NpcY%(50) = -30
  
    NpcActive%(51) = 7
    NpcGraphic%(51) = 33
    NpcX%(51) = 325
    NpcY%(51) = -100
  
    NpcActive%(52) = 7
    NpcGraphic%(52) = 21
    NpcX%(52) = 325
    NpcY%(52) = -200
  
    NpcActive%(53) = 7
    NpcGraphic%(53) = 33
    NpcX%(53) = 325
    NpcY%(53) = -330
  
    NpcActive%(54) = 8
    NpcGraphic%(54) = 45
    NpcX%(54) = 295
    NpcY%(54) = 230
 
    NpcActive%(55) = 8
    NpcGraphic%(55) = 30
    NpcX%(55) = 295
    NpcY%(55) = 330
 
    NpcActive%(56) = 8
    NpcGraphic%(56) = 30
    NpcX%(56) = 295
    NpcY%(56) = 430
 
    NpcActive%(57) = 8
    NpcGraphic%(57) = 45
    NpcX%(57) = 295
    NpcY%(57) = 630
 
  CASE 17
    NpcActive%(60) = 7
    NpcGraphic%(60) = 42
    NpcX%(60) = 325
    NpcY%(60) = -30
 
    NpcActive%(61) = 7
    NpcGraphic%(61) = 33
    NpcX%(61) = 325
    NpcY%(61) = -130
 
    NpcActive%(62) = 7
    NpcGraphic%(62) = 21
    NpcX%(62) = 325
    NpcY%(62) = -230
 
    NpcActive%(63) = 7
    NpcGraphic%(63) = 33
    NpcX%(63) = 325
    NpcY%(63) = -430
 
    NpcActive%(64) = 8
    NpcGraphic%(64) = 45
    NpcX%(64) = 295
    NpcY%(64) = 200

    NpcActive%(65) = 8
    NpcGraphic%(65) = 21
    NpcX%(65) = 295
    NpcY%(65) = 400

    NpcActive%(66) = 8
    NpcGraphic%(66) = 30
    NpcX%(66) = 295
    NpcY%(66) = 570

    NpcActive%(67) = 8
    NpcGraphic%(67) = 45
    NpcX%(67) = 295
    NpcY%(67) = 630
   
    NpcActive%(68) = 8
    NpcGraphic%(68) = 21
    NpcX%(68) = 295
    NpcY%(68) = 700

  CASE 18
    NpcActive%(I%) = 9
    Tt% = INT(3 * RND)
    IF Tt% = 0 THEN Tt% = 24
    IF Tt% = 1 THEN Tt% = 48
    IF Tt% = 2 THEN Tt% = 36
    NpcGraphic%(I%) = Tt%
    NpcX%(I%) = 320
    NpcY%(I%) = 145 - INT(RND * 10)
 
  CASE 19
    NpcActive%(I%) = 9
    Tt% = INT(3 * RND)
    IF Tt% = 0 THEN Tt% = 24
    IF Tt% = 1 THEN Tt% = 48
    IF Tt% = 2 THEN Tt% = 36
    NpcGraphic%(I%) = Tt%
    NpcX%(I%) = 320
    NpcY%(I%) = 110 + INT(RND * 10)
 
  CASE 20
    NpcActive%(40) = 7
    NpcGraphic%(40) = 42
    NpcX%(40) = 325
    NpcY%(40) = -30
  
    NpcActive%(41) = 7
    NpcGraphic%(41) = 33
    NpcX%(41) = 325
    NpcY%(41) = -130
   
    NpcActive%(48) = 7
    NpcGraphic%(48) = 33
    NpcX%(48) = 325
    NpcY%(48) = -180

    NpcActive%(42) = 7
    NpcGraphic%(42) = 21
    NpcX%(42) = 325
    NpcY%(42) = -230
  
    NpcActive%(49) = 7
    NpcGraphic%(49) = 33
    NpcX%(49) = 325
    NpcY%(49) = -300
   
    NpcActive%(71) = 7
    NpcGraphic%(71) = 33
    NpcX%(71) = 325
    NpcY%(71) = -370
   
    NpcActive%(43) = 7
    NpcGraphic%(43) = 33
    NpcX%(43) = 325
    NpcY%(43) = -430
  
    NpcActive%(44) = 8
    NpcGraphic%(44) = 45
    NpcX%(44) = 295
    NpcY%(44) = 230
 
    NpcActive%(45) = 8
    NpcGraphic%(45) = 30
    NpcX%(45) = 295
    NpcY%(45) = 330
 
    NpcActive%(46) = 8
    NpcGraphic%(46) = 30
    NpcX%(46) = 295
    NpcY%(46) = 430
 
    NpcActive%(72) = 8
    NpcGraphic%(72) = 30
    NpcX%(72) = 295
    NpcY%(72) = 500
   
    NpcActive%(47) = 8
    NpcGraphic%(47) = 45
    NpcX%(47) = 295
    NpcY%(47) = 570
   
    NpcActive%(73) = 8
    NpcGraphic%(73) = 45
    NpcX%(73) = 295
    NpcY%(73) = 660

  CASE 21
    Tt% = INT(3 * RND)
    IF Tt% = 0 THEN Tt% = 15
    IF Tt% = 1 THEN Tt% = 27
    IF Tt% = 2 THEN Tt% = 39
   
    NpcActive%(I%) = 10
    NpcGraphic%(I%) = Tt%
    NpcX%(I%) = 320
    NpcY%(I%) = 100
  CASE 22
    NpcActive%(I%) = 11
    NpcGraphic%(I%) = 3
    NpcX%(I%) = -30
    NpcY%(I%) = 120
  CASE 23
    NpcActive%(I%) = 13
    NpcGraphic%(I%) = 3
    NpcX%(I%) = -30
    NpcY%(I%) = 65
  CASE 24
    NpcActive%(I%) = 15
    NpcGraphic%(I%) = 3
    NpcX%(I%) = -30
    NpcY%(I%) = 120
  CASE 25
    NpcActive%(I%) = 18
    NpcGraphic%(I%) = 3
    NpcX%(I%) = -30
    NpcY%(I%) = 5
  CASE 26
    NpcActive%(I%) = 20
    NpcGraphic%(I%) = 3
    NpcX%(I%) = -30
    NpcY%(I%) = 115
  CASE 27
    NpcActive%(I%) = 22
    NpcGraphic%(I%) = 3
    NpcX%(I%) = -30
    NpcY%(I%) = 135
  CASE 28
    NpcActive%(30) = 10
    NpcGraphic%(30) = 6
    NpcX%(30) = 325
    NpcY%(30) = 25
   
    NpcActive%(31) = 10
    NpcGraphic%(31) = 6
    NpcX%(31) = 325
    NpcY%(31) = 50
   
    NpcActive%(32) = 10
    NpcGraphic%(32) = 6
    NpcX%(32) = 325
    NpcY%(32) = 75
  CASE 29
    NpcActive%(30) = 10
    NpcGraphic%(30) = 6
    NpcX%(30) = 325
    NpcY%(30) = 40
  
    NpcActive%(31) = 10
    NpcGraphic%(31) = 6
    NpcX%(31) = 325
    NpcY%(31) = 65
  
    NpcActive%(32) = 10
    NpcGraphic%(32) = 6
    NpcX%(32) = 325
    NpcY%(32) = 90
 
  CASE 30
    NpcActive%(20) = 10
    NpcGraphic%(20) = 6
    NpcX%(20) = 325
    NpcY%(20) = 135
 
    NpcActive%(21) = 10
    NpcGraphic%(21) = 6
    NpcX%(21) = 325
    NpcY%(21) = 160
  CASE 31
    IF NpcActive%(40) = 0 THEN
      NpcActive%(40) = 10
      NpcGraphic%(40) = 6
      NpcX%(40) = 325
      NpcY%(40) = 30
  
      NpcActive%(41) = 10
      NpcGraphic%(41) = 6
      NpcX%(41) = 325
      NpcY%(41) = 60
    ELSE
      NpcActive%(42) = 10
      NpcGraphic%(42) = 6
      NpcX%(42) = 325
      NpcY%(42) = 30
 
      NpcActive%(43) = 10
      NpcGraphic%(43) = 6
      NpcX%(43) = 325
      NpcY%(43) = 60
    END IF
  CASE 32
    NpcActive%(I%) = 24
    NpcX%(I%) = 320
    NpcY%(I%) = 100
    NpcGraphic%(I%) = 21
  CASE 33
    NpcActive%(30) = 10
    NpcGraphic%(30) = 6
    NpcX%(30) = 325
    NpcY%(30) = 50
  
    NpcActive%(31) = 10
    NpcGraphic%(31) = 6
    NpcX%(31) = 325
    NpcY%(31) = 75
  
    NpcActive%(32) = 10
    NpcGraphic%(32) = 6
    NpcX%(32) = 400
    NpcY%(32) = 75
   
    NpcActive%(33) = 10
    NpcGraphic%(33) = 6
    NpcX%(33) = 400
    NpcY%(33) = 100

    NpcActive%(34) = 10
    NpcGraphic%(34) = 6
    NpcX%(34) = 475
    NpcY%(34) = 50
 
    NpcActive%(35) = 10
    NpcGraphic%(35) = 6
    NpcX%(35) = 475
    NpcY%(35) = 75

END SELECT

END SUB

SUB InitEvents

'A few cars going the other direction
Event%(0) = 8
Event%(5) = 9
Event%(10) = 8
IF Difficulty% > 1 THEN Event%(14) = 10
'Related Cops
Event%(1) = 22
IF Difficulty% > 1 THEN Event%(6) = 23

'Cop chasing
IF Difficulty% > 1 THEN Event%(42) = 22
Event%(46) = 22
IF Difficulty% > 1 THEN Event%(49) = 24

'First Crossroads
Event%(54) = 11
Event%(65) = 12

'The one way street
Event%(77) = 25
Event%(78) = 13
IF Difficulty% > 1 THEN Event%(80) = 15
Event%(82) = 15
Event%(83) = 13
IF Difficulty% > 1 THEN Event%(88) = 13
Event%(90) = 15
Event%(93) = 13
Event%(95) = 14
Event%(98) = 13
Event%(103) = 13
Event%(105) = 15
Event%(108) = 13
IF Difficulty% > 1 THEN Event%(111) = 15
Event%(113) = 13

'The Chase
IF Difficulty% > 1 THEN Event%(135) = 26
Event%(139) = 27
Event%(142) = 28
Event%(167) = 22
Event%(175) = 29
IF Difficulty% > 1 THEN Event%(192) = 29
Event%(200) = 30

'The Second Crossroads
Event%(224) = 11
Event%(240) = 16
Event%(256) = 17
Event%(269) = 11

'Dual Carraige Way
Event%(300) = 18
Event%(302) = 19
IF Difficulty% > 1 THEN Event%(303) = 18
Event%(305) = 19
IF Difficulty% > 1 THEN Event%(306) = 18
Event%(309) = 19
Event%(312) = 18
IF Difficulty% > 1 THEN Event%(315) = 19
Event%(317) = 18
IF Difficulty% > 1 THEN Event%(318) = 19
Event%(320) = 18
Event%(321) = 19
IF Difficulty% > 1 THEN Event%(324) = 18
Event%(326) = 19
Event%(327) = 18
IF Difficulty% > 1 THEN Event%(330) = 19
Event%(331) = 18
Event%(333) = 19
IF Difficulty% > 1 THEN Event%(336) = 18
Event%(340) = 19
IF Difficulty% > 1 THEN Event%(345) = 18
Event%(352) = 19
Event%(353) = 18
IF Difficulty% > 1 THEN Event%(355) = 19
Event%(356) = 18
Event%(359) = 19
IF Difficulty% > 1 THEN Event%(362) = 18
Event%(365) = 19
Event%(367) = 18
IF Difficulty% > 1 THEN Event%(368) = 19
Event%(370) = 18
Event%(371) = 19
IF Difficulty% > 1 THEN Event%(374) = 18
Event%(376) = 19
Event%(377) = 18
IF Difficulty% > 1 THEN Event%(380) = 19
Event%(381) = 18
Event%(383) = 19
IF Difficulty% > 1 THEN Event%(386) = 18
Event%(390) = 19
Event%(394) = 18
IF Difficulty% > 1 THEN Event%(400) = 19
Event%(404) = 18
Event%(406) = 19
IF Difficulty% > 1 THEN Event%(407) = 18
Event%(410) = 19
Event%(411) = 18
IF Difficulty% > 1 THEN Event%(413) = 19
Event%(416) = 18
IF Difficulty% > 1 THEN Event%(420) = 19
Event%(424) = 19
IF Difficulty% > 1 THEN Event%(434) = 18
IF Difficulty% > 1 THEN Event%(436) = 19
Event%(437) = 18

'Road Blocks on Dual Carraigeway
Event%(304) = 31
IF Difficulty% > 1 THEN Event%(313) = 31
Event%(322) = 31
Event%(343) = 31
IF Difficulty% > 1 THEN Event%(354) = 31
Event%(378) = 31
Event%(389) = 31
Event%(401) = 31
Event%(422) = 31

'The Final Crossroads
Event%(456) = 21
Event%(459) = 12
Event%(466) = 11
Event%(471) = 21
Event%(474) = 16
Event%(484) = 17
Event%(489) = 21
Event%(492) = 20

'Roundabout and beyond
Event%(504) = 32
Event%(516) = 33
Event%(616) = 28

'The Bloody Tank!
Event%(647) = 4
Event%(675) = 5
Event%(757) = 6
Event%(782) = 7

'Last Desperate Chance...
IF Difficulty% > 1 THEN Event%(770) = 22
Event%(771) = 23
IF Difficulty% > 1 THEN Event%(773) = 25
Event%(774) = 26
IF Difficulty% > 1 THEN Event%(775) = 27

END SUB

SUB Intro

CLS
TypedText "TERRY CAVANAGH PRESENTS", 80: DELAY 100

TypedText "A MINIGAME PROGRAMMED ", 115
TypedText "IN QUICKBASIC 4.5", 128: DELAY 60

Restar:
FOR I% = 0 TO 75
  Deactivate I%
NEXT I%
CLS
TypedText "THE HUNT", 50: DELAY 10

Text$ = "Play Game"
SmallPrint &HA000, 0, 160 - (LEN(Text$) * 2), 95, Text$, 15
Text$ = "Speedup"
IF Speedup% = 0 THEN
  Text$ = Text$ + " is off"
ELSE
  Text$ = Text$ + " is on"
END IF
SmallPrint &HA000, 0, 160 - (LEN(Text$) * 2), 105, Text$, 15
Text$ = "Difficulty "
IF Difficulty% = 1 THEN Text$ = Text$ + "EASY"
IF Difficulty% = 2 THEN Text$ = Text$ + "NORMAL"
IF Difficulty% = 3 THEN Text$ = Text$ + "PRO"
SmallPrint &HA000, 0, 160 - (LEN(Text$) * 2), 115, Text$, 15
Text$ = "Exit Game"
SmallPrint &HA000, 0, 160 - (LEN(Text$) * 2), 125, Text$, 15

Text$ = "Instructions:"
SmallPrint &HA000, 0, 160 - (LEN(Text$) * 2), 150, Text$, 15
Text$ = "AT THE MENU: Use up and down to select an option and space to confirm."
SmallPrint &HA000, 0, 160 - (LEN(Text$) * 2), 160, Text$, 15
Text$ = "IN THE GAME: Press the direction keys to avoid... well, everything."
SmallPrint &HA000, 0, 160 - (LEN(Text$) * 2), 170, Text$, 15
Text$ = "The Hunt (c) Terry Cavanagh 2002 - Have fun!"
SmallPrint &HA000, 0, 160 - (LEN(Text$) * 2), 190, Text$, 15

DEF SEG = &H40
  POKE &H1A, PEEK(&H1C)
  POKE &H1B, PEEK(&H1D)
DEF SEG

Sel% = 1
DO
  Key$ = INKEY$
  FOR I% = 1 TO 4
    IF Sel% <> I% THEN
      LINE (120, 84 + (I% * 10))-(199, 92 + (I% * 10)), 0, B
    ELSE
      LINE (120, 84 + (Sel% * 10))-(199, 92 + (Sel% * 10)), 4, B
    END IF
  NEXT I%
  IF Key$ = CHR$(0) + "H" THEN Sel% = Sel% - 1
  IF Key$ = CHR$(0) + "P" THEN Sel% = Sel% + 1
  IF Sel% < 1 THEN Sel% = 4
  IF Sel% > 4 THEN Sel% = 1
  IF Key$ = " " THEN
    SELECT CASE Sel%
      CASE 1: GOTO StartGame
      CASE 2
        Speedup% = (Speedup% = 0)
        LINE (121, 105)-(198, 111), 0, BF
        Text$ = "Speedup"
        IF Speedup% = 0 THEN
          Text$ = Text$ + " is off"
        ELSE
          Text$ = Text$ + " is on"
        END IF
        SmallPrint &HA000, 0, 160 - (LEN(Text$) * 2), 105, Text$, 15
      CASE 3
        Difficulty% = Difficulty% + 1
        IF Difficulty% > 3 THEN Difficulty% = 1
        LINE (121, 115)-(198, 121), 0, BF
        Text$ = "Speedup"
        Text$ = "Difficulty "
        IF Difficulty% = 1 THEN Text$ = Text$ + "EASY"
        IF Difficulty% = 2 THEN Text$ = Text$ + "NORMAL"
        IF Difficulty% = 3 THEN Text$ = Text$ + "PRO"
        SmallPrint &HA000, 0, 160 - (LEN(Text$) * 2), 115, Text$, 15
      CASE 4: GOTO EndGame
    END SELECT
  END IF
  IF Key$ = CHR$(27) THEN
    IF Sel% = 4 THEN GOTO EndGame
    Sel% = 4
  END IF
LOOP

StartGame:
ShowIntro
PlayGame
fadeout
CLS
FOR I% = 0 TO 255
  SetColor I%, Red%(I%), Green%(I%), Blue%(I%)
NEXT I%
GOTO Restar

EndGame:


END SUB

SUB LoadFonts

OPEN "graphics\game.fnt" FOR BINARY AS #1
  FOR I% = 33 TO 126
    FOR X% = 0 TO 26
      GET #1, , SmallFont%(X%, I%)
    NEXT X%
  NEXT I%
CLOSE #1

END SUB

SUB LoadGraphics

FOR I% = 0 TO GraphicsNum%
  DEF SEG = VARSEG(Tiles%(0, I%))
  BLOAD "graphics/tile" + LTRIM$(STR$(I%)) + ".bsv", VARPTR(Tiles%(0, I%))
NEXT I%
DEF SEG

FOR I% = 0 TO 58
  DEF SEG = VARSEG(Cars%(0, I%))
  BLOAD "graphics/cars/car" + LTRIM$(STR$(I%)) + ".bsv", VARPTR(Cars%(0, I%))
NEXT I%
DEF SEG

END SUB

SUB LoadMap (FileName$)

OPEN FileName$ FOR BINARY AS #1
  FOR Y% = 0 TO 8
    FOR X% = 0 TO 799
      GET #1, , Map%(X%, Y%)
      GET #1, , PassMap%(X%, Y%)
    NEXT X%
  NEXT Y%
CLOSE #1

END SUB

SUB LoadPalette

OPEN "graphics/color.pal" FOR BINARY AS #1
  FOR I% = 0 TO 255
    GET #1, , Red%(I%)
    GET #1, , Green%(I%)
    GET #1, , Blue%(I%)
  NEXT I%
CLOSE #1

FOR I% = 0 TO 255
  SetColor I%, Red%(I%), Green%(I%), Blue%(I%)
NEXT I%

END SUB

SUB Outro

SCREEN 0: WIDTH 80
COLOR 7
CLS
COLOR 15, 4
PRINT " 'The Hunt' by Terry Cavanagh 2002                                       Ver1.0 "
COLOR 7, 0
PRINT
PRINT "Thank you very much for playing 'The Hunt'. All criticiques and comments are"
PRINT "welcome. Feel free to email me with suggestions for updated versions."
PRINT
PRINT "CREDITS:"
PRINT "Programming, Qbasic and ASM, Graphics, Story and Concept by Terry Cavanagh."
PRINT "ASM keyboard routines by Bobby of CosmoSoft (from the CosmoX Lib)"
PRINT
PRINT "- Terry Cavanagh (blinkthedarkness@hotmail.com)"
PRINT "                 (http://www.talesofutopia.cjb.net)"
PRINT
PRINT "Press any key to exit..."
SLEEP

END SUB

SUB PlayGame

Xpos% = 0: Xp% = 50: Yp% = 90: PlayerCar% = 0: PlayerFrame% = 0
Lives% = 5: Crash% = 0
InitEvents
CLS
DrawScreen
TouPcopy VARSEG(buffer%(0)), VARPTR(buffer%(0)), &HA000, 0
Fadein
CSInstallKeyBoard
DO
  'Render the screen
  DrawScreen
  IF Crash% = 1 THEN
    TouPut VARSEG(buffer%(0)), VARPTR(buffer%(0)), VARSEG(Cars%(0, 58)), VARPTR(Cars%(0, 58)), Xp%, Yp%, 0
  END IF
  TouPcopy VARSEG(buffer%(0)), VARPTR(buffer%(0)), &HA000, 0
  IF Crash% = 1 THEN
    Lives% = Lives% - 1
    TypedText "CRASH!", 80: DELAY 15
    TypedText LTRIM$(STR$(Lives%)) + " LIVES LEFT", 105
    DELAY 20
    IF Lives% > 0 THEN
      TypedText "PUT YOUR CAR INTO POSITION", 140
      DELAY 10
      PositionCar
      DrawScreen
      TouPcopy VARSEG(buffer%(0)), VARPTR(buffer%(0)), &HA000, 0
      TypedText "ON YOUR MARKS,", 80: DELAY 10
      TypedText "GET SET,", 105: DELAY 10
      TypedText "GO!", 130: DELAY 10
      TankTimer! = TIMER
      TankTimer2! = TIMER
    END IF
    IF Lives% <= 0 THEN
      TypedText "GAME OVER...", 140
      CSRemoveKeyBoard
      DELAY 30
      EXIT SUB
    END IF
  END IF
  IF Speedup% = 0 THEN DELAY 2
  IF Difficulty% = 1 THEN DELAY 2
  IF Difficulty% = 2 THEN DELAY 1
  IF Xpos% >= 25 AND Xpos% <= 40 THEN Xoffset% = Xoffset% + 5
  IF Xpos% >= 550 AND Xpos% <= 610 THEN Xoffset% = Xoffset% + 5
  'Recieve input
  PlayerFrame% = 0
  IF CSKey%(72) THEN 'up
    PlayerFrame% = 2
    Yp% = Yp% - 3
  END IF
  IF CSKey%(80) THEN 'Down
    PlayerFrame% = 1
    Yp% = Yp% + 3
  END IF
  IF CSKey%(75) THEN 'Left
    Xp% = Xp% - 5
  END IF
  IF CSKey%(77) THEN 'Right
    Xp% = Xp% + 5
  END IF
  'Finally, Update Data
  Xoffset% = Xoffset% + 5
  IF Xoffset% > 20 THEN Xoffset% = Xoffset% - 20: Xpos% = Xpos% + 1
  IF Xpos% > 783 THEN Xpos% = 783
  IF Xp% < 0 THEN Xp% = 0
  IF Xp% > 289 THEN Xp% = 289
  IF Yp% < 0 THEN Yp% = 0
  IF Yp% > 169 THEN Yp% = 169
  UpdateEvents
  'Play Events
  IF Event%(Xpos%) > 0 THEN
    T% = Event%(Xpos%)
    Event%(Xpos%) = 0
    InitEvent T%
  END IF
  CheckCollision
LOOP UNTIL CSKey%(1)
CSRemoveKeyBoard

END SUB

SUB PositionCar

DO
  DisplayMap
 
  FOR I% = 0 TO 75
    IF NpcActive%(I%) > 0 THEN
      TouClipPut2 VARSEG(buffer%(0)), VARPTR(buffer%(0)), VARSEG(Cars%(0, NpcGraphic%(I%))), VARPTR(Cars%(0, NpcGraphic%(I%))), NpcX%(I%), NpcY%(I%)
    END IF
  NEXT I%
  DELAY 2
  TouPut VARSEG(buffer%(0)), VARPTR(buffer%(0)), VARSEG(Cars%(0, PlayerCar% + PlayerFrame%)), VARPTR(Cars%(0, PlayerCar% + PlayerFrame%)), Xp%, Yp%, 0
 
  IF Crash% = 1 THEN
    TouPut VARSEG(buffer%(0)), VARPTR(buffer%(0)), VARSEG(Cars%(0, 58)), VARPTR(Cars%(0, 58)), Xp%, Yp%, 0
  END IF
 
  TouFillBox VARSEG(buffer%(0)), VARPTR(buffer%(0)), 0, 0, 319, 9, 0
  TouFillBox VARSEG(buffer%(0)), VARPTR(buffer%(0)), 0, 190, 319, 199, 0
  TouPcopy VARSEG(buffer%(0)), VARPTR(buffer%(0)), &HA000, 0

  PlayerFrame% = 0
  IF CSKey%(72) THEN 'up
    PlayerFrame% = 2
    Yp% = Yp% - 3
  END IF
  IF CSKey%(80) THEN 'Down
    PlayerFrame% = 1
    Yp% = Yp% + 3
  END IF
  IF CSKey%(75) THEN 'Left
    Xp% = Xp% - 5
  END IF
  IF CSKey%(77) THEN 'Right
    Xp% = Xp% + 5
  END IF
  IF CSKey%(57) THEN
    IF Crash% = 0 THEN EXIT SUB
  END IF
 
  IF Xp% < 0 THEN Xp% = 0
  IF Xp% > 289 THEN Xp% = 289
  IF Yp% < 0 THEN Yp% = 0
  IF Yp% > 169 THEN Yp% = 169

  CheckCollision
LOOP UNTIL CSKey%(1) = 1

END SUB

SUB SetColor (T%, R%, G%, B%)

OUT &H3C8, T%
OUT &H3C9, R%
OUT &H3C9, G%
OUT &H3C9, B%

END SUB

SUB ShowIntro

DEF SEG = &H40
  POKE &H1A, PEEK(&H1C)
  POKE &H1B, PEEK(&H1D)
DEF SEG

CLS

Text$ = "Press space to skip introduction"
SmallPrint &HA000, 0, 160 - (LEN(Text$) * 2), 190, Text$, 15

TypedText2 "MALCOLM RHODES: A 30 YEAR OLD EX-ARMY", 10
IF Difficulty% > 3 THEN GOTO NeBit
TypedText2 "DRIVER, DISHONOURABLY DISCHARGED FOR", 25
IF Difficulty% > 3 THEN GOTO NeBit
TypedText2 "FAILING TO COMPLY WITH AN ORDER,", 40
IF Difficulty% > 3 THEN GOTO NeBit
TypedText2 "AND MONTHS LATER FALSLY CONVICTED OF", 55
IF Difficulty% > 3 THEN GOTO NeBit
TypedText2 "THE MURDER OF HIS FORMER MAJOR.", 70: DELAY 30
IF Difficulty% > 3 THEN GOTO NeBit

TypedText2 "MALCOLM HAS BEEN FRAMED.", 100: DELAY 30
IF Difficulty% > 3 THEN GOTO NeBit

TypedText2 "HAVING JUST BEEN SENTENCED TO DEATH,", 130
IF Difficulty% > 3 THEN GOTO NeBit
TypedText2 "HE HAS STOLEN THE JUDGE'S CAR, AND", 145
IF Difficulty% > 3 THEN GOTO NeBit
TypedText2 "HEADS FOR THE BORDER.", 160: DELAY 30
IF Difficulty% > 3 THEN GOTO NeBit

Difficulty% = Difficulty% + 3
NeBit:
Difficulty% = Difficulty% - 3
CLS
Text$ = "Press space to skip introduction"
SmallPrint &HA000, 0, 160 - (LEN(Text$) * 2), 190, Text$, 15

TypedText2 "THE HUNT IS ON", 60: DELAY 60
IF Difficulty% > 3 THEN GOTO NeBit2
TypedText2 "RUN LITTLE MAN, RUN!", 100: DELAY 60
IF Difficulty% > 3 THEN GOTO NeBit2

Difficulty% = Difficulty% + 3
NeBit2:
Difficulty% = Difficulty% - 3
fadeout

END SUB

SUB SmallPrint (SrSeg%, SrOff%, X%, Y%, Temp$, Col%)

FOR I% = 1 TO LEN(Temp$)
  Temp% = ASC(MID$(Temp$, I%, 1))
  Wid% = 4
  IF Temp% >= 33 AND Temp% <= 126 THEN
    Wid% = SmallFont%(0, Temp%) + 1
    FOR Yt% = 1 TO SmallFont%(1, Temp%)
      FOR Xt% = 1 TO Wid% - 1
        J% = SmallFont%(1 + ((Xt%) + ((Yt% - 1) * (Wid% - 1))), Temp%)
        IF J% <> 0 THEN TouPset SrSeg%, SrOff%, X% + Xt%, Y% + Yt%, Col%
      NEXT Xt%
    NEXT Yt%
  END IF
  X% = X% + Wid%
NEXT I%

END SUB

SUB TypedText (Text$, Ypo%)

FOR I% = 1 TO LEN(Text$)
  BigPrint &HA000, 0, 160 - (LEN(Text$) * 4), Ypo%, LEFT$(Text$, I%), 15
  SOUND 250 - (RND * 100), .15
  DELAY 5
NEXT I%

END SUB

SUB TypedText2 (Text$, Ypo%)

FOR I% = 1 TO LEN(Text$)
  BigPrint &HA000, 0, 160 - (LEN(Text$) * 4), Ypo%, LEFT$(Text$, I%), 15
  SOUND 250 - (RND * 100), .15
  DELAY 5
  IF INKEY$ = " " THEN
    Difficulty% = Difficulty% + 3
    EXIT SUB
  END IF
NEXT I%

END SUB

SUB UpdateEvents
 
FOR I% = 0 TO 75
  IF NpcActive%(I%) > 0 THEN
    SELECT CASE NpcActive%(I%)
      CASE 1
        IF NpcY%(40) > Yp% - 15 THEN
          NpcY%(40) = Yp% - 15
          NpcY%(41) = Yp% - 15
          NpcY%(42) = Yp% + 15
          NpcY%(43) = Yp% + 15
        END IF
        IF NpcY%(40) < Yp% - 15 THEN
          NpcY%(40) = Yp% - 15
          NpcY%(41) = Yp% - 15
          NpcY%(42) = Yp% + 15
          NpcY%(43) = Yp% + 15
        END IF
        IF TIMER - TankTimer! >= 2 THEN
          InitEvent 2
          TankTimer! = TIMER
        END IF
        IF TIMER - TankTimer2! >= 1 THEN
          InitEvent 3
          TankTimer2! = TIMER
        END IF
      CASE 2
        NpcX%(I%) = NpcX%(I%) + 10
        IF NpcX%(I%) > 320 THEN NpcActive%(I%) = 0
      CASE 4
        NpcX%(I%) = NpcX%(I%) - 5
        IF NpcX%(I%) < -30 THEN NpcActive%(I%) = 0
      CASE 5
        NpcX%(40) = NpcX%(40) + 1
        NpcX%(41) = NpcX%(41) + 1
        NpcX%(42) = NpcX%(42) + 1
        NpcX%(43) = NpcX%(43) + 1
        IF NpcX%(43) = 15 THEN
          NpcActive%(40) = 1
          NpcActive%(41) = 1
          NpcActive%(42) = 1
          NpcActive%(43) = 1
        END IF
      CASE 6
        NpcX%(I%) = NpcX%(I%) - 10
        IF NpcX%(I%) < -30 THEN NpcActive%(I%) = 0
      CASE 7
        NpcY%(I%) = NpcY%(I%) + 10
        NpcX%(I%) = NpcX%(I%) - 5
        IF NpcY%(I%) > 200 THEN NpcActive%(I%) = 0
      CASE 8
        NpcY%(I%) = NpcY%(I%) - 10
        NpcX%(I%) = NpcX%(I%) - 5
        IF NpcY%(I%) < -30 THEN NpcActive%(I%) = 0
      CASE 9
        NpcX%(I%) = NpcX%(I%) - 15
        IF NpcX%(I%) < -30 THEN NpcActive%(I%) = 0
      CASE 10
        NpcX%(I%) = NpcX%(I%) - 5
        IF NpcX%(I%) < -30 THEN NpcActive%(I%) = 0
      CASE 11
        NpcX%(I%) = NpcX%(I%) + 10
        IF NpcX%(I%) > 80 THEN
          NpcGraphic%(I%) = 5
          NpcActive%(I%) = 12
        END IF
      CASE 12
        NpcX%(I%) = NpcX%(I%) + 10
        NpcY%(I%) = NpcY%(I%) - 5
        IF NpcY%(I%) < 90 THEN
          NpcActive%(I%) = 10
          NpcY%(I%) = NpcY%(I%) + 5
          NpcGraphic%(I%) = 9
        END IF
      CASE 13
        NpcX%(I%) = NpcX%(I%) + 10
        IF NpcX%(I%) > 100 THEN
          NpcGraphic%(I%) = 4
          NpcActive%(I%) = 14
        END IF
      CASE 14
        NpcX%(I%) = NpcX%(I%) + 10
        NpcY%(I%) = NpcY%(I%) + 5
        IF NpcY%(I%) > 90 THEN
          NpcActive%(I%) = 10
          NpcY%(I%) = NpcY%(I%) - 5
          NpcGraphic%(I%) = 6
        END IF
      CASE 15
        NpcX%(I%) = NpcX%(I%) + 10
        IF NpcX%(I%) > 140 THEN
          NpcGraphic%(I%) = 9
          NpcActive%(I%) = 16
        END IF
      CASE 16
        NpcX%(I%) = NpcX%(I%) + 5
        NpcY%(I%) = NpcY%(I%) - 15
        IF NpcY%(I%) < 60 THEN
          NpcActive%(I%) = 17
          NpcY%(I%) = NpcY%(I%) + 15
          NpcGraphic%(I%) = 12
        END IF
      CASE 17
        NpcX%(I%) = NpcX%(I%) - 25
        IF NpcX%(I%) < -30 THEN NpcActive%(I%) = 0
      CASE 18
        NpcX%(I%) = NpcX%(I%) + 10
        IF NpcX%(I%) >= Xp% THEN NpcActive%(I%) = 19
      CASE 19
        NpcX%(I%) = Xp%
        IF Xpos% = 122 THEN
          IF Xp% < 40 THEN
            NpcActive%(I%) = 14
            NpcGraphic%(I%) = 4
          ELSE
            NpcActive%(I%) = 10
          END IF
        END IF
      CASE 20
        NpcX%(I%) = NpcX%(I%) + 10
        IF NpcX%(I%) > 100 THEN
          NpcGraphic%(I%) = 4
          NpcActive%(I%) = 21
        END IF
      CASE 21
        NpcX%(I%) = NpcX%(I%) + 10
        NpcY%(I%) = NpcY%(I%) + 5
        IF NpcY%(I%) > 110 THEN
          NpcY%(I%) = NpcY%(I%) - 5
          NpcGraphic%(I%) = 6
          NpcActive%(I%) = 10
        END IF
      CASE 22
        NpcX%(I%) = NpcX%(I%) + 10
        IF NpcX%(I%) > 100 THEN
          NpcGraphic%(I%) = 5
          NpcActive%(I%) = 23
        END IF
      CASE 23
        NpcX%(I%) = NpcX%(I%) + 10
        NpcY%(I%) = NpcY%(I%) - 5
        IF NpcY%(I%) < 110 THEN
          NpcY%(I%) = NpcY%(I%) + 5
          NpcGraphic%(I%) = 9
          NpcActive%(I%) = 10
        END IF
      CASE 24
        IF NpcGraphic%(I%) = 21 THEN
          NpcX%(I%) = NpcX%(I%) - 5
          NpcY%(I%) = NpcY%(I%) - 5
          IF NpcY%(I%) < 75 THEN
            NpcGraphic%(I%) = 22
          END IF
        END IF
        IF NpcGraphic%(I%) = 22 THEN
          NpcX%(I%) = NpcX%(I%) - 3
          NpcY%(I%) = NpcY%(I%) - 5
          IF NpcY%(I%) < 60 THEN
            NpcGraphic%(I%) = 15
          END IF
        END IF
        IF NpcGraphic%(I%) = 15 THEN
          NpcX%(I%) = NpcX%(I%) - 1
          IF (NpcX%(I%) < 265 AND NpcX%(I%) > 160) OR (NpcX%(I%) < 160 AND NpcX%(I%) > 20) THEN
            NpcGraphic%(I%) = 16
          END IF
        END IF
        IF NpcGraphic%(I%) = 16 THEN
          NpcX%(I%) = NpcX%(I%) - 3
          NpcY%(I%) = NpcY%(I%) + 5
          IF NpcY%(I%) > 70 THEN
            NpcGraphic%(I%) = 18
          END IF
        END IF
        IF NpcGraphic%(I%) = 18 THEN
          NpcX%(I%) = NpcX%(I%) - 5
          NpcY%(I%) = NpcY%(I%) + 5
          IF NpcY%(I%) > 110 THEN
            NpcGraphic%(I%) = 24
          END IF
        END IF
        IF NpcGraphic%(I%) = 24 THEN
          NpcX%(I%) = NpcX%(I%) - 7
          IF NpcX%(I%) < 70 THEN
            NpcGraphic%(I%) = 26
          END IF
        END IF
        IF NpcGraphic%(I%) = 26 THEN
          NpcX%(I%) = NpcX%(I%) - 5
          NpcY%(I%) = NpcY%(I%) - 3
          IF NpcY%(I%) < 125 THEN
            NpcGraphic%(I%) = 21
          END IF
        END IF
        IF NpcX%(I%) < 0 THEN NpcActive%(I%) = 0
    END SELECT
  END IF
NEXT I%

END SUB

SUB Youvewon

CSRemoveKeyBoard

DEF SEG = &H40
  POKE &H1A, PEEK(&H1C)
  POKE &H1B, PEEK(&H1D)
DEF SEG

CLS
FOR I% = 0 TO 255
  SetColor I%, Red%(I%), Green%(I%), Blue%(I%)
NEXT I%

Text$ = "Press space to skip ending"
SmallPrint &HA000, 0, 160 - (LEN(Text$) * 2), 190, Text$, 15

TypedText2 "THE FURTHER ADVENTURES OF", 80
IF Difficulty% > 3 THEN GOTO NeBit3
TypedText2 "MALCOLM RHODES", 95: DELAY 100
IF Difficulty% > 3 THEN GOTO NeBit3

Difficulty% = Difficulty% + 3
NeBit3:
Difficulty% = Difficulty% - 3

CLS
Text$ = "Press space to skip ending"
SmallPrint &HA000, 0, 160 - (LEN(Text$) * 2), 190, Text$, 15

TypedText2 "MALCOLM EVADED CAPTURE FROM", 10
IF Difficulty% > 3 THEN GOTO NeBit4
TypedText2 "THE FOREIGN ATHORITIES AND FOUND", 25
IF Difficulty% > 3 THEN GOTO NeBit4
TypedText2 "REFUGE IN AN ABANDONED WAREHOUSE.", 40: DELAY 60
IF Difficulty% > 3 THEN GOTO NeBit4

TypedText2 "ONCE THE COAST WAS CLEAR, MALCOLM", 85
IF Difficulty% > 3 THEN GOTO NeBit4
TypedText2 "SET ABOUT RECREATING HIS IMAGE, AND", 100
IF Difficulty% > 3 THEN GOTO NeBit4
TypedText2 "ARMED WITH A CLEVER DISGUISE,", 115
IF Difficulty% > 3 THEN GOTO NeBit4
TypedText2 "RETURNED TO TRY AND CLEAR HIS NAME", 130: DELAY 60
IF Difficulty% > 3 THEN GOTO NeBit4

Difficulty% = Difficulty% + 3
NeBit4:
Difficulty% = Difficulty% - 3

CLS
Text$ = "Press space to skip ending"
SmallPrint &HA000, 0, 160 - (LEN(Text$) * 2), 190, Text$, 15

TypedText2 "AFTER MONTHS OF SEARCHING, HE FOUND", 30
IF Difficulty% > 3 THEN GOTO NeBit5
TypedText2 "EVIDENCE NEEDED FOR AN AQUITTAL.", 45
IF Difficulty% > 3 THEN GOTO NeBit5
TypedText2 "HE LIVED HAPPILY EVER AFTER.", 60: DELAY 60
IF Difficulty% > 3 THEN GOTO NeBit5

Difficulty% = Difficulty% + 3
NeBit5:
Difficulty% = Difficulty% - 3

CLS
TypedText "CONGRATULATIONS ON COMPLETING", 30
TypedText "'THE HUNT'", 45: DELAY 100

SELECT CASE Difficulty%
  CASE 1
    TypedText "WAIT, YOU COMPLETED IT ON EASY?", 90: DELAY 60
    TypedText "WUSS! COWARD!!!", 105: DELAY 60
  CASE 2
    TypedText "NOW BE A MAN", 90: DELAY 60
    TypedText "AND COMPLETE IT ON PRO :)", 105: DELAY 60
  CASE 3
    TypedText "YOU ARE THE ULTIMATE DRIVER!", 90: DELAY 60
    TypedText "CONGRATULATIONS!", 105: DELAY 60
END SELECT

fadeout
Outro
END

END SUB

