DECLARE FUNCTION Reveal$ (Word AS STRING, Letters AS STRING)
DECLARE SUB ResetScreen ()
DECLARE SUB AniWin (wTop AS INTEGER, wLeft AS INTEGER, wWidth AS INTEGER, wHeight AS INTEGER, wFColor AS INTEGER, wBColor AS INTEGER)
DECLARE SUB Pause (Sec!)
DECLARE SUB TextWindow (wTop AS INTEGER, wLeft AS INTEGER, wWidth AS INTEGER, wHeight AS INTEGER, wFColor AS INTEGER, wBColor AS INTEGER, Title AS STRING)
DECLARE FUNCTION PickWord$ ()
DECLARE SUB BMPLoad (Filename AS STRING)
DECLARE FUNCTION LoadWords! (Filename AS STRING)
DECLARE FUNCTION Rand! (rFrom AS INTEGER, rTo AS INTEGER)
DECLARE SUB Game ()
DECLARE SUB TitleScreen ()
DECLARE FUNCTION PlayAgain! ()
DECLARE FUNCTION RepStr$ (rString AS STRING, rReps AS INTEGER)
DECLARE SUB Init ()
DECLARE SUB WinPrint (wTop AS INTEGER, wLeft AS INTEGER, wWidth AS INTEGER, wHeight AS INTEGER, Text AS STRING, tRow AS INTEGER, tCenter AS INTEGER)
DECLARE SUB GoodbyeScreen ()
DIM SHARED WordList(0 TO 300) AS STRING
DIM SHARED Words AS INTEGER




Init
TitleScreen
DO
  Game
  IF PlayAgain = 0 THEN
    EXIT DO
  END IF
LOOP
GoodbyeScreen

SUB AniWin (wTop AS INTEGER, wLeft AS INTEGER, wWidth AS INTEGER, wHeight AS INTEGER, wFColor AS INTEGER, wBColor AS INTEGER)
  DIM W AS INTEGER
  FOR W = 2 TO wWidth STEP 2
    TextWindow wTop, wLeft + ((wWidth - W) / 2), W, wHeight, wFColor, wBColor, ""
    Pause .05
  NEXT W

END SUB

SUB BMPLoad (Filename AS STRING)
CLS
F = FREEFILE
OPEN Filename$ FOR BINARY AS #F

header$ = SPACE$(14)
sizing$ = SPACE$(4)
GET #1, 1, header$
GET #1, 15, sizing$
bmpinfosize = CVI(sizing$)

IF bmpinfosize = 12 THEN
  infoheader$ = SPACE$(12)
  GET #1, 15, infoheader$
  nbits = CVI(MID$(infoheader$, 15, 4))
  IF nbits = 1 THEN
    palet$ = SPACE$(6)
    GET #1, bmpinfosize + 15, palet$
  ELSEIF nbits = 4 THEN
    palet$ = SPACE$(48)
    GET #1, bmpinfosize + 15, palet$
  ELSEIF nbits = 8 THEN
    palet$ = SPACE$(768)
    GET #1, bmpinfosize + 15, palet$
  END IF
ELSEIF bmpinfosize = 40 THEN
  infoheader$ = SPACE$(40)
  GET #1, 15, infoheader$
  nbits = CVI(MID$(infoheader$, 15, 4))
  IF nbits = 1 THEN
    palet$ = SPACE$(8)
    GET #1, bmpinfosize + 15, palet$
  ELSEIF nbits = 4 THEN
    palet$ = SPACE$(64)
    GET #1, bmpinfosize + 15, palet$
  ELSEIF nbits = 8 THEN
    palet$ = SPACE$(1024)
    GET #1, bmpinfosize + 15, palet$
  END IF
END IF


ft$ = MID$(header$, 1, 2)
filesize = CVL(MID$(header$, 3, 4))
r1 = CVI(MID$(header$, 7, 2))
r2 = CVI(MID$(header$, 9, 2))
offset = CVL(MID$(header$, 11, 4))
headersize = CVL(MID$(infoheader$, 1, 4))
picwidth = CVL(MID$(infoheader$, 5, 4))
picheight = CVL(MID$(infoheader$, 9, 4))
nplanes = CVI(MID$(infoheader$, 13, 4))
IF headersize = 40 THEN
  comptype = CVL(MID$(infoheader$, 17, 4))
  'IF comptype = 0 THEN PRINT "None"
  'IF comptype = 1 THEN PRINT "Run Length - 8 Bits"
  'IF comptype = 2 THEN PRINT "Run Length - 4 Bits"

  imagesize = CVL(MID$(infoheader$, 21, 4))
  xsize = CVL(MID$(infoheader$, 25, 4))
  ysize = CVL(MID$(infoheader$, 29, 4))
  colorsused = CVL(MID$(infoheader$, 33, 4))
  neededcolours = CVL(MID$(infoheader$, 37, 4))
END IF

IF nbits = 1 THEN
  SCREEN 11
ELSEIF nbits = 4 THEN
  SCREEN 12
ELSEIF nbits = 8 OR nbits = 24 THEN
  SCREEN 13
END IF
IF bmpinfosize = 40 THEN ngroups = 4
IF bmpinfosize = 12 THEN ngroups = 3

IF nbits = 24 THEN
  IF ngroups = 3 THEN
    FOR C = 0 TO 63
      D = C * 4
      palet$ = palet$ + CHR$(D) + CHR$(D) + CHR$(D)
      palet$ = palet$ + CHR$(D) + CHR$(D) + CHR$(D + 1)
      palet$ = palet$ + CHR$(D) + CHR$(D + 1) + CHR$(D)
      palet$ = palet$ + CHR$(D + 1) + CHR$(D) + CHR$(D)
    NEXT C
  ELSEIF ngroups = 4 THEN
    FOR C = 0 TO 63
      D = C * 4
      palet$ = palet$ + CHR$(D) + CHR$(D) + CHR$(D) + CHR$(0)
      palet$ = palet$ + CHR$(D) + CHR$(D) + CHR$(D + 1) + CHR$(0)
      palet$ = palet$ + CHR$(D) + CHR$(D + 1) + CHR$(D) + CHR$(0)
      palet$ = palet$ + CHR$(D + 1) + CHR$(D) + CHR$(D) + CHR$(0)
    NEXT C
  END IF
END IF

FOR x = 1 TO LEN(palet$) STEP ngroups
  zb# = INT((ASC(MID$(palet$, x, 1))) / 4)
  zg# = INT((ASC(MID$(palet$, x + 1, 1))) / 4)
  zr# = INT((ASC(MID$(palet$, x + 2, 1))) / 4)
  zc# = zb# * 65536# + zg# * 256# + zr#
  cres = ASC(MID$(palet$, x + 3, 1))
  PALETTE ((x - 1) / ngroups), zc#
NEXT x

IF nbits = 24 THEN
  y = picheight - 1
  x = 0
  dat$ = "   "
  WHILE y >= 0
    WHILE x < picwidth
      GET 1, , dat$
      p1 = INT((ASC(MID$(dat$, 1, 1)) + ASC(MID$(dat$, 1, 1)) + ASC(MID$(dat$, 1, 1))) / 3)
      PSET (x, y), p1
      x = x + 1
    WEND
    y = y - 1
    x = 0
 WEND
ELSEIF nbits = 8 THEN
  y = picheight - 1
  x = 0
  dat$ = " "
  WHILE y >= 0
    WHILE x < picwidth
      GET 1, , dat$
      PSET (x, y), ASC(dat$)
      x = x + 1
    WEND
    y = y - 1
    x = 0
  WEND
ELSEIF nbits = 4 THEN
  y = picheight - 1
  x = 0
  dat$ = " "
  WHILE y >= 0
    WHILE x < picwidth
      GET 1, , dat$
      LOCATE 1, 1
      p1 = ASC(dat$) AND 15
      p2 = ASC(dat$) AND 240 / 16
      PSET (x, y), p1
      PSET (x + 1, y), p2
      x = x + 2
    WEND
    y = y - 1
    x = 0
  WEND
ELSEIF nbits = 1 THEN
  y = picheight - 1
  x = 0
  dat$ = " "
  WHILE y >= 0
    WHILE x < picwidth
      GET 1, , dat$
      p1 = ASC(dat$)
      FOR p = 0 TO 7
        PSET (x + (7 - p), y), (p1 AND 2 ^ p) / 2 ^ p
      NEXT p
      x = x + 8
    WEND
    y = y - 1
    x = 0
 WEND
END IF

CLOSE #F

END SUB

SUB Game
  Word$ = PickWord$
  
  BMPLoad "0.bmp"
  Pause 3
  ResetScreen
  AniWin 5, 10, 60, 10, 0, 11
  DO
    TextWindow 5, 10, 60, 10, 0, 11, "Croc Hunter Hangman"
    WinPrint 5, 10, 60, 10, "The word is:", 2, 0
    WinPrint 5, 10, 60, 10, "Press a key to pick a letter.", 5, -1
    R$ = Reveal$(Word$, Letters$)
    WinPrint 5, 10, 60, 10, R$, 3, -1

    IF INSTR(1, R$, "_") = 0 THEN
      Pause 1
      AniWin 10, 35, 15, 5, 0, 4
      TextWindow 10, 35, 15, 5, 0, 4, "You Win!"
      WinPrint 10, 35, 15, 5, "Press a key.", 3, -1
      Pause 0
      EXIT SUB
    END IF
    IF Wrong = 6 THEN
      Pause 1
      AniWin 10, 25, 20, 5, 0, 4
      TextWindow 10, 25, 20, 5, 0, 4, "You've been hung!"
      WinPrint 10, 25, 20, 5, "Press a key.", 3, -1
      Pause 0
      EXIT SUB
    END IF

    a$ = ""
    DO WHILE a$ = ""
      a$ = LCASE$(INKEY$)
    LOOP

    IF ASC(a$) = 27 THEN
      EXIT SUB
    END IF

    IF INSTR(1, "abcdefghijklmnopqrstuvwxyz", a$) THEN
      IF NOT INSTR(1, Letters$, a$) THEN
        Letters$ = Letters$ + a$
        nR$ = Reveal(Word$, Letters$)
        IF nR$ = R$ THEN
          Wrong = Wrong + 1
        END IF
        SELECT CASE Wrong
          CASE 0
            BMPLoad "0.bmp"
          CASE 1
            BMPLoad "1.bmp"
          CASE 2
            BMPLoad "2.bmp"
          CASE 3
            BMPLoad "3.bmp"
          CASE 4
            BMPLoad "4.bmp"
          CASE 5
            BMPLoad "5.bmp"
          CASE 6
            BMPLoad "6.bmp"
        END SELECT
        Pause 3
      END IF
    END IF
    ResetScreen
  LOOP
  Pause 0
END SUB

SUB GoodbyeScreen
  BMPLoad "Thatshow.bmp"
  Pause 0
  END
END SUB

SUB Init
  Words = LoadWords("WordList.txt")
END SUB

FUNCTION LoadWords (Filename AS STRING)
  F = FREEFILE
  OPEN Filename FOR INPUT AS #F
    DO WHILE NOT EOF(F)
      LINE INPUT #F, C$
      WordList(Index) = C$
      Index = Index + 1
    LOOP
  CLOSE #F
  LoadWords = Index  'Return the number of words in the word list
END FUNCTION

SUB Pause (Sec)
  Start = TIMER
  IF NOT Sec = 0 THEN
    DO WHILE TIMER - Start < Sec
    LOOP
    EXIT SUB
  ELSE
    DO WHILE INKEY$ = ""
    LOOP
    EXIT SUB
  END IF
  a$ = INKEY$
END SUB

FUNCTION PickWord$
  DO WHILE W$ = ""
    W$ = WordList(Rand(1, Words) - 1)
  LOOP
  PickWord$ = W$
END FUNCTION

FUNCTION PlayAgain
  Pause 1
  AniWin 5, 35, 20, 5, 0, 10
  TextWindow 5, 35, 20, 5, 0, 10, "Play again?"
  WinPrint 5, 25, 35, 5, "Y or N", 3, -1
  DO WHILE a$ <> "y" AND a$ <> "n"
    a$ = LCASE$(INKEY$)
  LOOP
  IF a$ = "y" THEN
    PlayAgain = -1
  ELSE
    PlayAgain = 0
  END IF
END FUNCTION

FUNCTION Rand (rFrom AS INTEGER, rTo AS INTEGER)
  RANDOMIZE TIMER
  Rand = INT(RND * rTo) + rFrom
END FUNCTION

FUNCTION RepStr$ (rString AS STRING, rReps AS INTEGER)
 FOR i = 1 TO rReps
   a$ = a$ + rString
 NEXT i
 RepStr$ = a$
END FUNCTION

SUB ResetScreen
  SCREEN 0
  WIDTH 80, 25
  COLOR 0, 1
  CLS
  COLOR 0, 11
END SUB

FUNCTION Reveal$ (Word AS STRING, Letters AS STRING)
  Word = UCASE$(Word)
  Letters = UCASE$(Letters)
  FOR i = 1 TO LEN(Word)
    D$ = MID$(Word, i, 1)
    IF INSTR(1, Letters, D$) THEN
      R$ = R$ + D$ + " "
    ELSE
      IF INSTR(1, UCASE$("abcdefghijklmnopqrstuvwxyz"), D$) THEN
        R$ = R$ + "_ "
      ELSE
        R$ = R$ + D$ + " "
      END IF
    END IF
  NEXT i
  Reveal$ = R$
END FUNCTION

SUB TextWindow (wTop AS INTEGER, wLeft AS INTEGER, wWidth AS INTEGER, wHeight AS INTEGER, wFColor AS INTEGER, wBColor AS INTEGER, Title AS STRING)
  X1 = wLeft
  Y1 = wTop
  X2 = X1 + wWidth
  Y2 = Y1 + wHeight
  
  TopLeft$ = CHR$(218)     '
  TopRight$ = CHR$(191)    '
  BottomRight$ = CHR$(217) '
  BottomLeft$ = CHR$(192)  '
  H$ = CHR$(196)           '
  V$ = CHR$(179)           '
  sTop$ = TopLeft$ + RepStr$(H$, wWidth - 2) + TopRight$
  sMid$ = V$ + RepStr$(" ", wWidth - 2) + V$
  sBot$ = BottomLeft$ + RepStr$(H$, wWidth - 2) + BottomRight$

  COLOR wFColor, wBColor
  LOCATE Y1, X1: PRINT sTop$
  FOR y = 1 TO wHeight - 1
    LOCATE y + Y1, X1: PRINT sMid$
  NEXT y
  LOCATE Y2, X1: PRINT sBot$
  LOCATE Y1 + 1, (X1 + (wWidth / 2)) - (LEN(Title) / 2)
  PRINT Title
END SUB

SUB TitleScreen
  ResetScreen
  AniWin 4, 20, 40, 10, 0, 11
  TextWindow 4, 20, 40, 10, 0, 11, "Croc Hunter Hangman"
  
  
  WinPrint 4, 20, 40, 10, "Crocs finally get revenge!", 2, -1
  
  

  WinPrint 4, 20, 40, 10, "Press any key to continue", 9, -1
  
  Pause 0
END SUB

SUB WinPrint (wTop AS INTEGER, wLeft AS INTEGER, wWidth AS INTEGER, wHeight AS INTEGER, Text AS STRING, tRow AS INTEGER, tCenter AS INTEGER)
  IF tCenter = -1 THEN
    LOCATE wTop + tRow + 1, (wLeft + (wWidth / 2)) - (LEN(Text) / 2)
  ELSE
    LOCATE wTop + tRow + 1, wLeft + 1
  END IF

  IF LEN(Text) > wWidth THEN
    PRINT LEFT$(Text, wWidth - 2)
  ELSE
    PRINT Text
  END IF

END SUB

