DEFINT A-Z
'$DYNAMIC
'$INCLUDE: 'cai3.bi'
'$INCLUDE: 'gslib.bi'
'$INCLUDE: 'ds4qb2.bi'

DECLARE SUB ArmRefinery ()
DECLARE SUB ShowChar (Show%, Handle%, x%, y%)
DECLARE SUB Credits (file$)
DECLARE SUB SpaceShip ()
DECLARE SUB StaticMap ()
DECLARE SUB BoatShop ()
DECLARE SUB RemoveItem (Itm$)
DECLARE FUNCTION Center% (Talk$)
DECLARE SUB ItemQuery (ItemID%, ItemData AS ItemTYPE)
DECLARE SUB Shop ()
DECLARE SUB Refinery ()
DECLARE SUB Inn (Cost%)
DECLARE SUB LoadMember (sFile$, Number%)
DECLARE FUNCTION NpcVisible% (NPC%)
DECLARE SUB LoadNPCs (file$)
DECLARE FUNCTION ProcessActions% (FileNum%, StoryFlag%)
DECLARE SUB LoadBkg (sFile$)
DECLARE FUNCTION BYTE% (sTemp$)
DECLARE SUB GiveMajorSpell ()
DECLARE SUB PartySwitch (Char1$, Slot%, Switch%)
DECLARE SUB Script (file$)
DECLARE SUB LoadMusic (file$, Channel%)
DECLARE SUB LoadEnemy (file$, Number%)
DECLARE SUB AddPlayer (Number%)
DECLARE SUB Battle (DisableRun%, BattleType%)
DECLARE SUB LoadChests (file$)
DECLARE SUB LoadTiles (FileName$)
DECLARE SUB PaletteFade (r%, g%, b%)
DECLARE SUB DrawMenuBack (Menu$, SubMenu%)
DECLARE SUB BoatMovement (Dir%)
DECLARE SUB GetTime ()
DECLARE FUNCTION Quant% (MaxQuant%)
DECLARE SUB ViewMap (Warp AS TileDataTYPE)
DECLARE FUNCTION ChoiceBox% ()
DECLARE SUB Layer1 ()
DECLARE SUB Layer2 ()
DECLARE SUB ScrollScreen ()
DECLARE SUB FadePal (Direction%)
DECLARE FUNCTION GiveItem% (Itm$)
DECLARE SUB Push (Handle%)
DECLARE SUB ShowPlayer ()
DECLARE SUB ShowDormant ()
DECLARE SUB DialogBox (Flip%, x1%, y1%, x2%, y2%, col%)
DECLARE SUB ShowNick ()
DECLARE SUB gsprint (Flip%, xpos%, ypos%, Text$, col%)
DECLARE SUB VisiblePlane (xDir, yDir)
DECLARE SUB ShowBattle (anime%)
DECLARE SUB ShowSprite (FileName$, x%, y%, Number%, Size%, PutType)

REM $STATIC
SUB ArmRefinery

	FOR i% = 1 TO 18
		IF Item(1, i%).ItemID = 19 THEN
			Have% = True
			ItemID = i%
		END IF
	NEXT i%

	IF Have THEN
			DialogBox True, 0, 135, 319, 199, 56
			gsprint 1, 5, 140, "Blacksmith: Ah you have a piece of     ", 31
			gsprint 1, 5, 150, "Runic Metal.  Would you like it        ", 31
			gsprint 1, 5, 160, "refined for 10000 cal?", 31
			gspcopy VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), &HA000, 0

			Result% = ChoiceBox%
		ELSE
			DialogBox True, 0, 135, 319, 199, 56
			gsprint 1, 5, 140, "Blacksmith: You don't have any Runic   ", 31
			gsprint 1, 5, 150, "Metal shards on you.  Please come back ", 31
			gsprint 1, 5, 160, "with if you want to use the refinery.", 31
			gspcopy VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), &HA000, 0
			WHILE INKEY$ <> CHR$(13): WEND
			EXIT SUB
	END IF

	IF Result% THEN
		IF Cal& >= 10000 THEN
				DialogBox True, 0, 135, 319, 199, 56
				gsprint 1, 5, 140, "Blacksmith: Heh thanks.  This will take", 31
				gsprint 1, 5, 150, "just a moment...", 31
				gspcopy VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), &HA000, 0
				gswait 50
				Cal& = Cal& - 10000
				FadePal 0
				gswait 230: ShowDormant
				PartDef%(7) = PartDef%(7) + 1
				FadePal 1
				SELECT CASE PartDef%(7)
					CASE 1
						Result% = GiveItem("Saint Brace")
					CASE 2
						Result% = GiveItem("Magus Brace")
					CASE 3
						Result% = GiveItem("Ruby Brace")
					CASE 4
						Result% = GiveItem("Victor Brace")
				END SELECT
				DialogBox True, 0, 135, 319, 199, 56
				gsprint 1, 5, 140, "Blacksmith: Thanks for waiting.", 31
				gsprint 1, 5, 150, "Here is your new brace.", 31
				gspcopy VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), &HA000, 0
				WHILE INKEY$ <> CHR$(13): WEND
				Item(1, ItemID%).Quantity = Item(1, ItemID%).Quantity - 1
				IF Item(1, ItemID%).Quantity = 0 THEN Item(1, ItemID%).ItemID = 0
			ELSEIF Cal& < 10000 THEN
				CALL ShowDormant
				DialogBox True, 0, 135, 319, 199, 56
				gsprint 1, 5, 140, "Blacksmith: You don't seem to have the", 31
				gsprint 1, 5, 150, "required Cal.", 31
				gspcopy VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), &HA000, 0
				WHILE INKEY$ <> CHR$(13): WEND
		END IF
	END IF

	IF NOT Result% THEN
		DialogBox True, 0, 135, 319, 199, 56
		gsprint 1, 5, 140, "Blacksmith: Come back any time.", 31
		gspcopy VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), &HA000, 0
		WHILE INKEY$ <> CHR$(13): WEND
	END IF

END SUB

REM $DYNAMIC
FUNCTION Center% (Talk$)

	x% = 159 - INT(LEN(Talk$) * 8 / 2)
	Center% = x%

END FUNCTION

FUNCTION ChoiceBox

	CursorX% = 3: CursorY% = 93
	Refresh% = True: ChoiceMade = False

	DO
		IF Refresh% THEN
			gspcopy &HA000, 0, VARSEG(Buffer&(0)), VARPTR(Buffer&(0))
			DialogBox True, 1, 89, 55, 129, 56
			gsprint 1, 20, 93, "Yes", 31
			gsprint 1, 20, 103, "No", 31
			ShowSprite "pointer.spr", CursorX%, CursorY%, 0, 20, 0
			gspcopy VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), &HA000, 0
			Refresh% = False
		END IF
		SELECT CASE INKEY$
			CASE CHR$(0) + CHR$(72)
				CursorY% = CursorY% - 10
				IF CursorY% = 83 THEN CursorY% = 93
				Refresh% = True
				DSPlaySample 1
			CASE CHR$(0) + CHR$(80)
				CursorY% = CursorY% + 10
				IF CursorY% = 113 THEN CursorY% = 103
				Refresh% = True
				DSPlaySample 1
			CASE CHR$(13)
				IF CursorY% = 93 THEN Choice = True: ChoiceMade = True
				IF CursorY% = 103 THEN Choice = False: ChoiceMade = True
		END SELECT
	LOOP UNTIL ChoiceMade
	ChoiceBox = Choice

END FUNCTION

SUB Credits (file$)

	CLS
	FadePal 1
	DIM CreditX%(2), CreditY%(2), CreditName(2) AS STRING * 30
	FileNum% = FREEFILE
	OPEN "data\" + file$ FOR INPUT AS #FileNum%
		DO
			INPUT #FileNum%, CreditType$
			IF CreditType$ = "End" THEN ExitCredits% = True
			ExitName% = False
			IF NOT ExitCredits% THEN
				SELECT CASE CreditType$
					CASE "Title"
						INPUT #FileNum%, CreditName(1), CreditX%(1), CreditY%(1)
						LastY% = -50
						IF CreditX%(1) = 0 THEN CreditX%(1) = Center(CreditName(1))
						FOR y% = 200 TO LastY% STEP -1
							gsfill VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), 0
							gsprint 1, CreditX%(1), y% + CreditY%(1), CreditName(1), 31
							gswait 1
							gspcopy VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), &HA000, 0
							IF LastY% = 95 THEN gswait 50
						NEXT y%
					CASE "Credits"
						INPUT #FileNum%, NumCredits%
						REDIM CreditX%(1 TO NumCredits%), CreditY%(1 TO NumCredits%), CreditName(1 TO NumCredits%)  AS STRING * 30
						FOR i% = 1 TO NumCredits%
							INPUT #FileNum%, CreditName$(i%), CreditX%(i%), CreditY%(i%)
						NEXT i%
						FOR i% = 1 TO NumCredits%
							IF CreditX%(i%) = 0 THEN CreditX%(i%) = Center(CreditName$(i%))
						NEXT i%
						LastY% = 0 - (CreditY%(NumCredits%) + 20)
						FOR y% = 200 TO LastY% STEP -1
							gsfill VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), 0

							FOR i% = 1 TO NumCredits%
								gsprint 1, CreditX%(i%), y% + CreditY%(i), CreditName(i), 31
							NEXT i%
							gswait 1
							gspcopy VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), &HA000, 0
						NEXT y%
					CASE "StopMiddle"
						LastY% = 95
						INPUT #FileNum%, NumCredits%
						REDIM CreditX%(1 TO NumCredits%), CreditY%(1 TO NumCredits%), CreditName(1 TO NumCredits%) AS STRING * 30
						FOR i% = 1 TO NumCredits%
							INPUT #FileNum%, CreditName(i%), CreditX%(i%), CreditY%(i%)
						NEXT i%
						FOR i% = 1 TO NumCredits%
							IF CreditX%(i%) = 0 THEN CreditX%(i%) = Center(CreditName(i%))
						NEXT i%
						FOR y% = 200 TO LastY% STEP -1
							gsfill VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), 0

							FOR i% = 1 TO NumCredits%
								gsprint 1, CreditX%(i%), y% + CreditY%(i), CreditName(i), 31
							NEXT i%
							gswait 1
							gspcopy VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), &HA000, 0
						NEXT y%
						WHILE INKEY$ <> CHR$(13): WEND
				END SELECT
			END IF
		LOOP UNTIL ExitCredits%
	CLOSE #FileNum%

END SUB

SUB DialogBox (Flip%, x1%, y1%, x2%, y2%, col%)

	IF Flip% = 2 THEN
			FOR i% = 1 TO 158
				gsboxf VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), 158 - i%, 135, 162 + i%, 199, col%
				gsbox VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), 158 - i%, 135, 162 + i%, 199, 24
				gsbox VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), 159 - i%, 136, 161 + i%, 198, 27
				gsbox VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), 160 - i%, 137, 160 + i%, 197, 26
				gspcopy VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), &HA000, 0
			NEXT i%
		ELSEIF NOT Flip% THEN
			gsboxf &HA000, 0, x1 + 2, y1, x2 - 2, y2, col%
			gsbox &HA000, 0, x1 + 2, y1, x2 - 2, y2, 24
			gsbox &HA000, 0, x1 + 1, y1 + 1, x2 - 1, y2 - 1, 27
			gsbox &HA000, 0, x1, y1 + 2, x2, y2 - 2, 26
		ELSEIF Flip% THEN
			gsboxf VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), x1 + 2, y1, x2 - 2, y2, col%
			gsbox VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), x1 + 2, y1, x2 - 2, y2, 24
			gsbox VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), x1 + 1, y1 + 1, x2 - 1, y2 - 1, 27
			gsbox VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), x1, y1 + 2, x2, y2 - 2, 26
	END IF

END SUB

SUB DrawMenuBack (Menu$, SubMenu%)

	DIM ItemD AS ItemTYPE
	StaticMap

	IF SubMenu% = 3 THEN Menu$ = "Shop"
	IF Menu$ = "Shop" THEN
		DialogBox True, 1, 1, 180, 129, 56
		DialogBox True, 185, 50, 310, 129, 56

		gsprint 1, 205, 55, "Buy", 31
		gsprint 1, 205, 65, "Sell", 31
		gsprint 1, 205, 75, "Exit", 31
		gsprint 1, 205, 95, "Cal:" + STR$(Cal&), 31

		IF SubMenu% = 1 THEN
			FOR i% = 1 TO NumItms%
				gsprint 1, 20, -5 + (i% * 10), SPACE$(13) + STR$(ItemPrice%(i%)), 31
				gsprint 1, 20, -5 + (i% * 10), SaleItem$(i%), 31
			NEXT i%
		END IF

		IF SubMenu% = 4 THEN
			y% = 1
			FOR i% = FirstItem% TO FirstItem% + 11
				ItemQuery Item(ItemPage%, i%).ItemID, ItemD
				IF Item(ItemPage%, i%).ItemID <> 0 THEN
					gsprint 1, 20, -5 + (y% * 10), SPACE$(13) + STR$(ItemD.Value), 31
					gsprint 1, 20, -5 + (y% * 10), RTRIM$(ItemD.Title), 31
				END IF
				y% = y% + 1
			NEXT i%
		END IF

		DialogBox True, 0, 135, 319, 199, 56
		IF SubMenu% <> 3 THEN
			ShowSprite "pointer.spr", CursorX%, CursorY%, 0, 20, 0
			gspcopy VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), &HA000, 0
		END IF
	END IF

	IF Menu$ = "Refinery" THEN
		DialogBox True, 0, 0, 319, 199, 56

		gsprint 1, 25, 10, Party(1).Title, 31
		gsprint 1, 25, 20, "Weapon: " + Party(1).WepName, 31
		gsprint 1, 25, 30, "Atk:" + STR$(Party(1).WepAtk) + " >" + STR$(Party(1).Lev), 31

		IF Party(2).OnTeam THEN
			gsprint 1, 25, 50, Party(2).Title, 31
			gsprint 1, 25, 60, "Weapon: " + Party(2).WepName, 31
			gsprint 1, 25, 70, "Atk:" + STR$(Party(2).WepAtk) + " >" + STR$(Party(2).Lev), 31
		END IF

		IF Party(3).OnTeam THEN
			gsprint 1, 25, 90, Party(3).Title, 31
			gsprint 1, 25, 100, "Weapon: " + Party(3).WepName, 31
			gsprint 1, 25, 110, "Atk:" + STR$(Party(3).WepAtk) + " >" + STR$(Party(3).Lev), 31
		END IF

		y% = 20
		FOR i% = 1 TO 3
			IF Party(i%).OnTeam THEN
				SELECT CASE RTRIM$(Party(i%).Title)
					CASE "Nick"
						gsprint 1, 220, y%, "Cost:" + STR$(7 * Party(i%).Lev ^ 2), 31
					CASE "Cerl"
						gsprint 1, 220, y%, "Cost:" + STR$(5 * Party(i%).Lev ^ 2), 31
					CASE "Ariel"
						gsprint 1, 220, y%, "Cost:" + STR$(6 * Party(i%).Lev ^ 2), 31
					CASE "Dane"
						gsprint 1, 220, y%, "Cost:" + STR$(8 * Party(i%).Lev ^ 2), 31
					CASE "Edwin"
						gsprint 1, 220, y%, "Cost:" + STR$(6 * Party(i%).Lev ^ 2), 31
				END SELECT
			END IF
			y% = y% + 40
		NEXT i%
		gsprint 1, 25, 180, "Exit", 31
		gsprint 1, 160, 180, "Cal:" + STR$(Cal&), 31

		ShowSprite "pointer.spr", CursorX%, CursorY%, 0, 20, 0
		gspcopy VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), &HA000, 0
	END IF

END SUB

SUB FadePal (Direction%)

	IF Direction% = 0 THEN       'FadeOut
			FOR i% = 0 TO 63
				PaletteFade -1, -1, -1
				gswait 1
				DEF SEG = 0: POKE &H41A, PEEK(&H41C): DEF SEG 'clear keyboard buffer
			NEXT i%
		ELSEIF Direction% = 1 THEN 'Fade in
			FOR i% = 0 TO 63
				PaletteFade 1, 1, 1
				gswait 1
				DEF SEG = 0: POKE &H41A, PEEK(&H41C): DEF SEG 'clear keyboard buffer
			NEXT i%
		ELSE
			FOR i% = 0 TO 63
				PaletteFade 1, 1, 1
				gswait 1
				DEF SEG = 0: POKE &H41A, PEEK(&H41C): DEF SEG 'clear keyboard buffer
			NEXT i%
			gsfill &HA000, 0, 0

			FOR i% = 0 TO 63
				PaletteFade -1, -1, -1
				gswait 1
				DEF SEG = 0: POKE &H41A, PEEK(&H41C): DEF SEG 'clear keyboard buffer
			NEXT i%
	END IF

END SUB

SUB FontLoad (file$)

	FileNum% = FREEFILE
	OPEN file$ FOR INPUT AS #FileNum%
		INPUT #FileNum%, hi$
		INPUT #FileNum%, wid$
		FOR ctr% = 0 TO 255
			INPUT #FileNum%, Fontstr$(ctr%)
		NEXT ctr%
	CLOSE #FileNum%

END SUB

SUB GetTime

	Time.TotalTime = TIMER
	IF Time.TotalTime - Time.TimeStarted < 0 THEN
		Time.TotalTime = 86400 + Time.TotalTime!
	END IF

	Time.TimeOn = Time.TimeOn + (Time.TotalTime - Time.TimeStarted)
	Time.TimeStarted = TIMER
	Minutes! = INT(Time.TimeOn / 60)
	Hours! = INT(Minutes! / 60)
	Minutes! = Minutes! MOD 60
	IF Hours! < 10 THEN h$ = "0" + RIGHT$(STR$(Hours!), 1) ELSE h$ = RIGHT$(STR$(Hours!), 2)
	IF Minutes! < 10 THEN M$ = "0" + RIGHT$(STR$(Minutes!), 1) ELSE M$ = RIGHT$(STR$(Minutes!), 2)
	Time.TimePlayed$ = h$ + ":" + M$

END SUB

FUNCTION GiveItem% (Itm$)

	DIM ItemD AS ItemTYPE

	FOR i% = 1 TO 18
		ItemQuery Item(1, i%).ItemID, ItemD
		IF RTRIM$(ItemD.Title) = Itm$ THEN
			IF Item(1, i%).Quantity > 0 AND Item(1, i%).Quantity + 1 <> 100 THEN
				Item(1, i%).Quantity = Item(1, i%).Quantity + 1
			END IF
			Temp% = True
		END IF
	NEXT i%

	IF NOT Temp% THEN
		FileNum% = FREEFILE
		OPEN "data\items.itm" FOR BINARY AS #FileNum%
			GET #FileNum%, , NumItems%
			FOR i% = 1 TO NumItems%
				GET #FileNum%, , ItemD
				IF RTRIM$(ItemD.Title) = Itm$ THEN
					FOR j% = 1 TO 18
						IF Item(1, j%).Quantity = 0 THEN
							Item(1, j%).Quantity = 1
							Item(1, j%).ItemID = i%
							Temp% = True: EXIT FOR
						END IF
					NEXT j%
				END IF
				IF Temp% THEN EXIT FOR
			NEXT i%
		CLOSE #FileNum%
	END IF

	IF NOT Temp% THEN GiveItem% = False
	IF Temp% THEN GiveItem% = True

END FUNCTION

SUB gsprint (Flip%, xpos%, ypos%, Text$, col%)

	FOR charcount = 1 TO LEN(Text$)
		Char = ASC(MID$(Text$, charcount, 1))
		count = 0
		FOR j = 1 TO 8
			FOR k = 1 TO 8
				count = count + 1
				fx = ((j + (charcount - 1) * 8) - 1)

				fy = k - 1

				IF MID$(Fontstr$(Char), count, 1) = "1" THEN
					SELECT CASE k
						CASE 1 TO 2
							col2% = col%
						CASE 3 TO 4
							col2% = col% - 2
						CASE 5 TO 6
							col2% = col% - 4
						CASE 7 TO 8
							col2% = col% - 6
					END SELECT
					SELECT CASE Flip%
						CASE 0
							gspset fx + xpos%, fy + ypos%, &HA000, 0, col2%
							gspset fx + xpos% + 1, fy + ypos% + 1, &HA000, 0, 16
						CASE 1
							gspset fx + xpos%, fy + ypos%, VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), col2%
							gspset fx + xpos% + 1, fy + ypos% + 1, VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), 16
					END SELECT
				END IF
			NEXT k
		NEXT j
	NEXT charcount

END SUB

SUB Layer1

	a% = 0: b% = 0
	FOR y% = VisibleY% TO VisibleY% + 9

		FOR x% = VisibleX% TO VisibleX% + 15

			VMap = BYTE(Map(x%, y%).byLayer1)
			gssprite a% * 20, b% * 20, VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), VARSEG(Tiles(VMap * 202)), VARPTR(Tiles(VMap * 202))

			VMap = BYTE(Map(x%, y%).byLayer2)
			IF VMap <> 0 THEN
				gssprite a% * 20, b% * 20, VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), VARSEG(Tiles(VMap * 202)), VARPTR(Tiles(VMap * 202))
			END IF

			FOR i% = 0 TO UBOUND(NPCs) - 1
				IF i% <> MovNPC% AND i% <> CameraOn% THEN
					IF NPCs(i%).x = x% AND NPCs(i%).y = y% AND NpcVisible(i%) THEN
						SELECT CASE BYTE(NPCs(i%).byFacing)
							CASE FaceUP
								ShowSprite NPCs(i%).sSet, a% * 20, b% * 20, 3, 20, 0
							CASE FaceDOWN
								ShowSprite NPCs(i%).sSet, a% * 20, b% * 20, 0, 20, 0
							CASE FaceLEFT
								ShowSprite NPCs(i%).sSet, a% * 20, b% * 20, 9, 20, 0
							CASE FaceRIGHT
								ShowSprite NPCs(i%).sSet, a% * 20, b% * 20, 6, 20, 0
						END SELECT
					END IF
				END IF
			NEXT i

			FOR i% = 1 TO NumChests%
				SELECT CASE Chest(i%).ChType
					CASE 0
						IF Chest(i%).x = x% AND Chest(i%).y = y% THEN
							IF NOT ChestStatus%(Chest(i%).Number) THEN
									ShowSprite "chest.set", a% * 20, b% * 20, 0, 20, 0
								ELSE
									ShowSprite "chest.set", a% * 20, b% * 20, 1, 20, 0
							END IF
						END IF
					CASE -1
				END SELECT
			NEXT i%

			a% = a% + 1
			IF a% = 16 THEN a% = 0

		NEXT x%
		b% = b% + 1
		IF b% = 10 THEN b% = 0

	NEXT y%

	IF NpcVisible(CameraOn%) THEN
		SELECT CASE BYTE(NPCs(CameraOn%).byFacing)
			CASE FaceUP
				ShowSprite NPCs(CameraOn%).sSet, 160, 100, 3, 20, 0
			CASE FaceDOWN
				ShowSprite NPCs(CameraOn%).sSet, 160, 100, 0, 20, 0
			CASE FaceLEFT
				ShowSprite NPCs(CameraOn%).sSet, 160, 100, 9, 20, 0
			CASE FaceRIGHT
				ShowSprite NPCs(CameraOn%).sSet, 160, 100, 6, 20, 0
		END SELECT
	END IF
	IF RunOff% THEN gswait 3

END SUB

SUB Layer2

	a% = 0: b% = 0
	FOR y% = VisibleY% TO VisibleY% + 9

		FOR x% = VisibleX% TO VisibleX% + 15

			VMap = BYTE(Map(x%, y%).byLayer3)
			IF VMap <> 0 THEN
				gssprite a% * 20, b% * 20, VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), VARSEG(Tiles(VMap * 202)), VARPTR(Tiles(VMap * 202))
			END IF

			a% = a% + 1
			IF a% = 16 THEN a% = 0

		NEXT x%
		b% = b% + 1
		IF b% = 10 THEN b% = 0

	NEXT y%

END SUB

SUB LoadChests (file$)


	FileNum% = FREEFILE
	OPEN "data\" + file$ FOR BINARY AS #FileNum%
		GET #FileNum%, , NumChests%

		REDIM Chest(1 TO NumChests%) AS ChestTYPE
		FOR i% = 1 TO NumChests%
			GET #FileNum%, , Chest(i%)
			Map(Chest(i%).x, Chest(i%).y).bWalkable = False
		NEXT i%
	CLOSE #FileNum%

END SUB

SUB LoadNPCs (file$)

	DIM Ver AS INTEGER
	DIM TempNPC AS NpcTYPE

	TempNPC = NPCs(0)

	FileNum% = FREEFILE
	OPEN "npcs\" + file$ FOR BINARY AS #FileNum%
		GET #FileNum%, , Ver
		GET #FileNum%, , NumNPCs
		NumNPCs = NumNPCs + 1
		REDIM NPCs(NumNPCs) AS NpcTYPE
		REDIM Move(NumNPCs) AS NpcMoveTYPE
		FOR i% = 1 TO NumNPCs - 1
			GET #FileNum%, , NPCs(i%)
			Move(i%).Dir = -1
			Move(i%).Frame = 1
			Move(i%).NumFrames = LEN(RTRIM$(NPCs(i%).sMovement))
			IF NpcVisible(i%) THEN Map(NPCs(i%).x, NPCs(i%).y).bWalkable = False
		NEXT i%

		NPCs(0) = TempNPC
	CLOSE #FileNum%

END SUB

SUB LoadPal

	DEF SEG = VARSEG(Pal(0)) 'Point to palette array
	BLOAD "Cai3.pal", 0       'Load palette

END SUB

SUB LoadTiles (FileName$)

	FileNum% = FREEFILE
	OPEN "tiles\" + FileName$ FOR BINARY AS #FileNum%
		FileSize% = LOF(FileNum%)
		FileSize% = FileSize% / 2 + 1
	CLOSE #FileNum%

	REDIM Tiles%(FileSize%)

	FileName$ = "tiles\" + FileName$
	DEF SEG = VARSEG(Tiles%(0))
	BLOAD FileName$, VARPTR(Tiles%(0))
	DEF SEG

END SUB

SUB NPrint (Flip%, xcol, ycol, Text$, colr)

	DIM fontstr1$(255)

	FileNum% = FREEFILE
	OPEN "cai3.fnt" FOR INPUT AS #FileNum%
		INPUT #FileNum%, hi$
		INPUT #FileNum%, wid$
		FOR ctr = 0 TO 255
			INPUT #FileNum%, fontstr1$(ctr)
		NEXT ctr

		FOR charcount = 1 TO LEN(Text$)
			Char = ASC(MID$(Text$, charcount, 1))
			count = 0
			FOR j = 1 TO VAL(wid$)
				FOR k = 1 TO VAL(hi$)
					count = count + 1
					fx = ((j + (charcount - 1) * VAL(wid$)) - 1)

					fy = k - 1

					IF MID$(fontstr1$(Char), count, 1) = "1" THEN
						SELECT CASE k
							CASE 1 TO 2
								col2% = colr%
							CASE 3 TO 4
								col2% = colr% - 2
							CASE 5 TO 6
								col2% = colr% - 4
							CASE 7 TO 8
								col2% = colr% - 6
						END SELECT
						SELECT CASE Flip%
							CASE 0
								gspset fx + xcol%, fy + ycol%, &HA000, 0, col2%
								gspset fx + xcol% + 1, fy + ycol% + 1, &HA000, 0, 16
							CASE 1
								gspset fx + xcol%, fy + ycol%, VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), col2%
								gspset fx + xcol% + 1, fy + ycol% + 1, VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), 16
						END SELECT
					END IF
				NEXT k
			NEXT j
		NEXT charcount
	CLOSE #FileNum%

END SUB

SUB PaletteFade (r, g, b)

	' Fade palette
	' ------------
	OUT &H3C8, 0                'Send values from attribute 0
	FOR i = 0 TO 255            'Update all palette attributes
		Pal(i).Red = Pal(i).Red + r   'Change red values
		Pal(i).Green = Pal(i).Green + g   'Change green values
		Pal(i).Blue = Pal(i).Blue + b    'Change blue values
		Red = Pal(i).Red            'Copy red values
		grn = Pal(i).Green            'Copy green values
		blu = Pal(i).Blue            'Copy blue values
		IF Red < 0 THEN Red = 0   'Keep red values in minimum range
		IF grn < 0 THEN grn = 0   'Keep green values in minimum range
		IF blu < 0 THEN blu = 0   'Keep blue values in minimum range
		IF Red > 63 THEN Red = 63 'Keep red values in maximum range
		IF grn > 63 THEN grn = 63 'Keep green values in maximum range
		IF blu > 63 THEN blu = 63 'Keep blue values in maximum range
		OUT &H3C9, Red            'Send red value
		OUT &H3C9, grn            'Send green value
		OUT &H3C9, blu            'Send blue value
	NEXT

END SUB

FUNCTION ProcessActions (FileNum%, StoryFlag%)

		DO
			INPUT #FileNum%, Action$
			SELECT CASE Action$
				CASE "Story"
					INPUT #FileNum%, Flag%, Story%, Check%
				CASE "StoryEnd"
					ProcessActions = 1
					EXIT FUNCTION
				CASE "StoryElse"
					INPUT #FileNum%, Flag%, Story%, Check%
					IF NOT StoryFlag% THEN
						SELECT CASE Check%
							CASE 0
								IF PartDef%(Flag%) = Story% THEN
									ProcessActions = 1
									EXIT FUNCTION
								END IF
							CASE 1
								IF PartDef%(Flag%) >= Story% THEN
									ProcessActions = 1
									EXIT FUNCTION
								END IF
						END SELECT
					END IF
				CASE "GiveItem"
					INPUT #FileNum%, ItemID$
				CASE "SetFlag"
					INPUT #FileNum%, Flag%, Story%
				CASE "FlagAdd"
					INPUT #FileNum%, Flag%, Story%
				CASE "Shop"
				CASE "BoatShop"
				CASE "Inn"
					INPUT #FileNum%, Cost%
				CASE "Refinery"
				CASE "LoadChests"
					INPUT #FileNum%, file$
				CASE "LoadNPC"
					INPUT #FileNum%, file$
				CASE "Talk"
					INPUT #FileNum%, Text1$: INPUT #FileNum%, Text2$: INPUT #FileNum%, Text3$: INPUT #FileNum%, Text4$
				CASE "Battle"
					INPUT #FileNum%, Bkgfile$, DisableRun%, BossFight%, Lose%
				CASE "AddPlayer"
					INPUT #FileNum%, Player%
				CASE "Fade"
					INPUT #FileNum%, Way%
				CASE "CameraOn"
					INPUT #FileNum%, Handle%
				CASE "LoadMap"
					INPUT #FileNum%, file$
				CASE "Visible"
					INPUT #FileNum%, Handle%, OffOn%
				CASE "ChangeXY"
					INPUT #FileNum%, Handle%, x%, y%
				CASE "Push"
					INPUT #FileNum%, Dir%, Many%
				CASE "PushNPC"
					INPUT #FileNum%, Handle%, Dir%, Many%
				CASE "Face"
					INPUT #FileNum%, Handle%, Dir%
				CASE "AlignPlayer"
					INPUT #FileNum%, Posit%, Align%
				CASE "Wait"
					INPUT #FileNum%, Delay%
				CASE "End"
					ProcessActions = 2
					EXIT FUNCTION
				CASE "LoadMusic"
					INPUT #FileNum%, file$
				CASE "ChangeTile"
					INPUT #FileNum%, x%, y%, Layer%, TileNum%
				CASE "LoadMember"
					INPUT #FileNum%, file$, Level%
				CASE "ChangeMusic"
					INPUT #FileNum%, file$
				CASE "BattleMusic"
					INPUT #FileNum%, file$
				CASE "SetRegion"
					INPUT #FileNum%, file$, Region%
				CASE "PartySwitch"
					INPUT #FileNum%, Handle$, Param1%, Param2%
				CASE "SetBoat"
					INPUT #FileNum%, x%, y%, OnOff%
				CASE "TimerEvent"
					INPUT #FileNum%, TimeLimit%, TimerOn%
				CASE "ChangeSet"
					INPUT #FileNum%, Handle%, Set$
				CASE "RemoveItem"
					INPUT #FileNum%, ItemID$
				CASE "EffectDark"
					INPUT #FileNum%, OnOff%
				CASE "ShipShop"
				CASE "MusicFade"
					INPUT #FileNum%, Fade%
				CASE "OnTeam"
					INPUT #FileNum%, Char$
				CASE "GiveMajorSpell"
				CASE "PartyOff"
					INPUT #FileNum%, Slot%, OnOff%
				CASE "Credits"
					INPUT #FileNum%, file$
				CASE "ArmRefinery"
				CASE "EndGame"
			END SELECT
		LOOP

END FUNCTION

SUB Push (Handle%)

	TempX% = NPCs(Handle%).x - VisibleX%
	TempY% = NPCs(Handle%).y - VisibleY%
	MovNPC% = Handle%
	IF BYTE(NPCs(Handle%).byFacing) = FaceUP THEN
			FOR y% = TempY% * 20 TO TempY% * 20 - 20 STEP -2
				DEF SEG = 0: POKE &H41A, PEEK(&H41C): DEF SEG 'clear keyboard buffer
				Layer1
				IF NewWalk% = 3 THEN
					IF WalkType% = 0 THEN WalkType% = 1 ELSE IF WalkType% = 1 THEN WalkType% = 2 ELSE IF WalkType% = 2 THEN WalkType% = 0
					NewWalk% = 0
				END IF
				NewWalk% = NewWalk% + 1
				ShowSprite NPCs(Handle%).sSet, TempX * 20, y%, 3 + WalkType%, 20, 0
				Layer2
				gspcopy VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), &HA000, 0
			NEXT y%
			TempY% = TempY% - 1: NPCs(Handle%).y = NPCs(Handle%).y - 1
		ELSEIF BYTE(NPCs(Handle%).byFacing) = FaceDOWN THEN
			FOR y% = TempY% * 20 TO TempY% * 20 + 20 STEP 2
				DEF SEG = 0: POKE &H41A, PEEK(&H41C): DEF SEG 'clear keyboard buffer
				Layer1
				IF NewWalk% = 3 THEN
					IF WalkType% = 0 THEN WalkType% = 1 ELSE IF WalkType% = 1 THEN WalkType% = 2 ELSE IF WalkType% = 2 THEN WalkType% = 0
					NewWalk% = 0
				END IF
				NewWalk% = NewWalk% + 1
				ShowSprite NPCs(Handle%).sSet, TempX * 20, y%, 0 + WalkType%, 20, 0
				Layer2
				gspcopy VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), &HA000, 0
			NEXT y%
			TempY% = TempY% + 1: NPCs(Handle%).y = NPCs(Handle%).y + 1
		ELSEIF BYTE(NPCs(Handle%).byFacing) = FaceLEFT THEN
			FOR x% = TempX% * 20 TO TempX% * 20 - 20 STEP -2
				DEF SEG = 0: POKE &H41A, PEEK(&H41C): DEF SEG 'clear keyboard buffer
				Layer1
				IF NewWalk% = 3 THEN
					IF WalkType% = 0 THEN WalkType% = 1 ELSE IF WalkType% = 1 THEN WalkType% = 2 ELSE IF WalkType% = 2 THEN WalkType% = 0
					NewWalk% = 0
				END IF
				NewWalk% = NewWalk% + 1
				ShowSprite NPCs(Handle%).sSet, x%, TempY% * 20, 9 + WalkType%, 20, 0
				Layer2
				gspcopy VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), &HA000, 0
			NEXT x%
			TempX% = TempX% - 1: NPCs(Handle%).x = NPCs(Handle%).x - 1
		ELSEIF BYTE(NPCs(Handle%).byFacing) = FaceRIGHT THEN
			FOR x% = TempX% * 20 TO TempX% * 20 + 20 STEP 2
				DEF SEG = 0: POKE &H41A, PEEK(&H41C): DEF SEG 'clear keyboard buffer
				Layer1
				IF NewWalk% = 3 THEN
					IF WalkType% = 0 THEN WalkType% = 1 ELSE IF WalkType% = 1 THEN WalkType% = 2 ELSE IF WalkType% = 2 THEN WalkType% = 0
					NewWalk% = 0
				END IF
				NewWalk% = NewWalk% + 1
				ShowSprite NPCs(Handle%).sSet, x%, TempY% * 20, 6 + WalkType%, 20, 0
				Layer2
				gspcopy VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), &HA000, 0
			NEXT x%
			TempX% = TempX% + 1: NPCs(Handle%).x = NPCs(Handle%).x + 1
	END IF
	MovNPC% = -1
	ShowDormant

END SUB

FUNCTION Quant% (MaxQuant%)

	Qnt% = 1
	Refresh% = True
	DO
		IF Refresh% THEN
			gspcopy &HA000, 0, VARSEG(Buffer&(0)), VARPTR(Buffer&(0))
			gsboxf VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), 140, 109, 180, 129, 56
			gsbox VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), 140, 109, 180, 129, 24
			gsbox VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), 141, 108, 179, 128, 27
			gsbox VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), 142, 107, 178, 127, 26
			gsprint 1, 145, 112, "x" + STR$(Qnt%), 31
			gspcopy VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), &HA000, 0
			Refresh% = False
		END IF
		SELECT CASE INKEY$
			CASE CHR$(0) + CHR$(77)               ' Code for right arrow key.
				Qnt% = Qnt% + 1
				IF Qnt% = MaxQuant% + 1 THEN Qnt% = MaxQuant%
				Refresh% = True
				DSPlaySample 1
			CASE CHR$(0) + CHR$(75)               ' Code for left arrow key.
				Qnt% = Qnt% - 1
				IF Qnt% = 0 THEN Qnt% = 1
				Refresh% = True
				DSPlaySample 1
			CASE CHR$(13)
				Quant% = Qnt%: Done% = True
		END SELECT
	LOOP UNTIL Done%

END FUNCTION

SUB Refinery

	CursorX% = 7: CursorY% = 20
	DrawMenuBack "Refinery", 0

	FOR i% = 1 TO 3
		IF Party(i%).OnTeam THEN Temp% = Temp% + 1
	NEXT i%
	EndY% = -20 + (Temp% * 40)
	DO
		SELECT CASE INKEY$
			CASE CHR$(0) + CHR$(72)
				CursorY% = CursorY% - 40
				IF CursorY% > EndY% THEN CursorY% = EndY%
				IF CursorY% = -20 THEN CursorY% = 20
				DrawMenuBack "Refinery", 0
			CASE CHR$(0) + CHR$(80)
				IF CursorY% = EndY% THEN CursorY% = 180
				CursorY% = CursorY% + 40
				IF CursorY% = 220 THEN CursorY% = 180
				DrawMenuBack "Refinery", 0
			CASE CHR$(13)
				IF CursorY% = 20 THEN
						Char% = 1
					ELSEIF CursorY% = 60 THEN
						Char% = 2
					ELSEIF CursorY% = 100 THEN
						Char% = 3
					ELSEIF CursorY% = 180 THEN
						Done% = True
						Char% = 0
				END IF
				SELECT CASE Char%
					CASE 0
						'Do nothing
					CASE ELSE
						SELECT CASE RTRIM$(Party(Char%).Title)
							CASE "Nick"
								IF Cal& >= 7 * Party(Char%).Lev ^ 2 AND Party(Char).WepAtk <> Party(Char%).Lev THEN
									Cal& = Cal& - (7 * Party(Char%).Lev ^ 2)
									FOR i% = Party(Char%).WepAtk TO Party(Char%).Lev
										IF i% = 10 THEN
												Party(Char%).WepName = "Long Sword"
											ELSEIF i% = 25 THEN
												Party(Char%).WepName = "Mythril Saber"
											ELSEIF i% = 40 THEN
												Party(Char%).WepName = "Firebrand"
											ELSEIF i% = 50 THEN
												Party(Char%).WepName = "Holy Slasher"
											ELSEIF i% = 65 THEN
												Party(Char%).WepName = "Death Bringer"
											ELSEIF i% = 75 THEN
												Party(Char%).WepName = "Phoenix Saber": Party(Char%).HP = Party(Char%).HP + 50
											ELSEIF i% = 90 THEN
												Party(Char%).WepName = "S. Runic Sword"
										END IF
									NEXT i%
									Party(Char%).WepAtk = Party(Char%).Lev
									DrawMenuBack "Refinery", 0
								END IF
							CASE "Cerl"
								IF Cal& >= 5 * Party(Char%).Lev ^ 2 AND Party(Char).WepAtk <> Party(Char%).Lev THEN
									Cal& = Cal& - (5 * Party(Char%).Lev ^ 2)
									FOR i% = Party(Char%).WepAtk TO Party(Char%).Lev
										IF i% = 10 THEN
												Party(Char%).WepName = "Septer"
											ELSEIF i% = 20 THEN
												Party(Char%).WepName = "Iron Cudgel"
											ELSEIF i% = 30 THEN
												Party(Char%).WepName = "Ornate Rod"
											ELSEIF i% = 45 THEN
												Party(Char%).WepName = "Magic Staff": Party(Char%).MS = Party(Char%).MS + 1
											ELSEIF i% = 60 THEN
												Party(Char%).WepName = "Destiny Septer"
											ELSEIF i% = 70 THEN
												Party(Char%).WepName = "Staff of Fate"
											ELSEIF i% = 90 THEN
												Party(Char%).WepName = "Serenity Rod"
										END IF
									NEXT i%
									Party(Char%).WepAtk = Party(Char%).Lev
									DrawMenuBack "Refinery", 0
								END IF
							CASE "Ariel"
								IF Cal& >= 6 * Party(Char%).Lev ^ 2 AND Party(Char).WepAtk <> Party(Char%).Lev THEN
									Cal& = Cal& - (6 * Party(Char%).Lev ^ 2)
									FOR i% = Party(Char%).WepAtk TO Party(Char%).Lev
										IF i% = 10 THEN
												Party(Char%).WepName = "Windy Claw"
											ELSEIF i% = 20 THEN
												Party(Char%).WepName = "Hyper Claw"
											ELSEIF i% = 40 THEN
												Party(Char%).WepName = "Wolverine Bane"
											ELSEIF i% = 55 THEN
												Party(Char%).WepName = "Akdin's Claw": Party(Char%).Dex = Party(Char%).Dex + 1
											ELSEIF i% = 70 THEN
												Party(Char%).WepName = "Yendi's Fury"
											ELSEIF i% = 90 THEN
												Party(Char%).WepName = "Seraph's Hand"
										END IF
									NEXT i%
									Party(Char%).WepAtk = Party(Char%).Lev
									DrawMenuBack "Refinery", 0
								END IF
							CASE "Dane"
								IF Cal& >= 8 * Party(Char%).Lev ^ 2 AND Party(Char).WepAtk <> Party(Char%).Lev THEN
									Cal& = Cal& - (8 * Party(Char%).Lev ^ 2)
									FOR i% = Party(Char%).WepAtk TO Party(Char%).Lev
										IF i% = 10 THEN
												Party(Char%).WepName = "Pole Arm"
											ELSEIF i% = 20 THEN
												Party(Char%).WepName = "Halberd"
											ELSEIF i% = 40 THEN
												Party(Char%).WepName = "Skythe"
											ELSEIF i% = 55 THEN
												Party(Char%).WepName = "Holy Halberd"
											ELSEIF i% = 70 THEN
												Party(Char%).WepName = "Dream Skythe": Party(Char%).Vit = Party(Char%).Vit + 1
											ELSEIF i% = 90 THEN
												Party(Char%).WepName = "Psy Destroyer"
										END IF
									NEXT i%
									Party(Char%).WepAtk = Party(Char%).Lev
									DrawMenuBack "Refinery", 0
								END IF
							CASE "Edwin"
								IF Cal& >= 6 * Party(Char%).Lev ^ 2 AND Party(Char).WepAtk <> Party(Char%).Lev THEN
									Cal& = Cal& - (6 * Party(Char%).Lev ^ 2)
									FOR i% = Party(Char%).WepAtk TO Party(Char%).Lev
										IF i% = 10 THEN
												Party(Char%).WepName = "Pole"
											ELSEIF i% = 20 THEN
												Party(Char%).WepName = "Steel Pole"
											ELSEIF i% = 40 THEN
												Party(Char%).WepName = "Extend Pole"
											ELSEIF i% = 55 THEN
												Party(Char%).WepName = "Diamond Pole": Party(Char%).MDF = Party(Char%).MDF + 1
											ELSEIF i% = 70 THEN
												Party(Char%).WepName = "Duel Edge Pole"
											ELSEIF i% = 90 THEN
												Party(Char%).WepName = "Xenocide Edge"
										END IF
									NEXT i%
									Party(Char%).WepAtk = Party(Char%).Lev
									DrawMenuBack "Refinery", 0
								END IF
						END SELECT
				END SELECT
		END SELECT
	LOOP UNTIL Done%

END SUB

REM $STATIC
SUB RemoveItem (Itm$)

	DIM ItemD AS ItemTYPE

	FOR i% = 1 TO 18
		ItemQuery Item(1, i%).ItemID, ItemD
		IF RTRIM$(ItemD.Title) = Itm$ THEN
			Item(1, i%).Quantity = Item(1, i%).Quantity - 1
			IF Item(1, i%).Quantity <= 0 THEN Item(1, i%).ItemID = 0
		END IF
	NEXT i%

END SUB

REM $DYNAMIC
SUB SaveLoad (file$, SL%)

	DIM Header AS STRING * 7
	DIM ItemD AS ItemTYPE

	FileNum% = FREEFILE
	IF SL% = 1 THEN
		OPEN "saved\" + file$ FOR BINARY AS #FileNum%
			Header = "Data"
			PUT #FileNum, , Header$

			PUT #FileNum%, , Time
			PUT #FileNum%, , MapInfo.sMapName
			PUT #FileNum%, , MapFile$
			PUT #FileNum%, , Cal&

			FOR i% = 1 TO 5
				PUT #FileNum%, , Party(i%)
			NEXT i%

			PUT #FileNum%, , NPCs(CameraOn%)

			FOR i% = 1 TO 18
				PUT #FileNum%, , Item(1, i%)
			NEXT i%

			FOR i% = 1 TO 5
				FOR j% = 1 TO 20
					PUT #FileNum%, , Magic$(i%, j%)
					PUT #FileNum%, , SPNeed%(i%, j%)
				NEXT j%
			NEXT i%

			FOR i% = 0 TO 5
				PUT #FileNum%, , PartDef%(i%)
			NEXT i%

			PUT #FileNum%, , VisibleX%
			PUT #FileNum%, , VisibleY%
			PUT #FileNum%, , Boat

			FOR i% = 1 TO 70
				PUT #FileNum%, , ChestStatus%(i%)
			NEXT i%
		CLOSE #FileNum%
	END IF

	IF SL% = 2 THEN
		OPEN "saved\" + file$ FOR BINARY AS #FileNum%
			GET #FileNum, , Header

			GET #FileNum%, , Time
			GET #FileNum%, , MapInfo.sMapName
			GET #FileNum%, , MapFile$
			GET #FileNum%, , Cal&

			FOR i% = 1 TO 5
				GET #FileNum%, , Party(i%)
				'Party(1).Bonus = "nicklev.dat"
				'Party(2).Bonus = "ariellev.dat"
				'Party(3).Bonus = "danelev.dat"
				'Party(1).SpellData = "nickmag.dat"
				'Party(2).SpellData = "arielmag.dat"
				'Party(3).SpellData = "danemag.dat"
			NEXT i%

			REDIM NPCs(1) AS NpcTYPE
			GET #FileNum%, , NPCs(CameraOn%)

			FOR i% = 1 TO 18
				GET #FileNum%, , Item(1, i%)
			NEXT i%

			FOR i% = 1 TO 5
				FOR j% = 1 TO 20
					GET #FileNum%, , Magic$(i%, j%)
					GET #FileNum%, , SPNeed%(i%, j%)
				NEXT j%
			NEXT i%

			FOR i% = 0 TO 5
				GET #FileNum%, , PartDef%(i%)
			NEXT i%

			GET #FileNum%, , VisibleX%
			GET #FileNum%, , VisibleY%
			GET #FileNum%, , Boat

			FOR i% = 1 TO 70
				GET #FileNum%, , ChestStatus%(i%)
			NEXT i%
		CLOSE #FileNum%

		DIM Temp AS TileDataTYPE
		Temp.sFileName = MapFile$
		Temp.x = NPCs(CameraOn%).x
		Temp.y = NPCs(CameraOn%).y
		ViewMap Temp
		VisibleX% = NPCs(CameraOn%).x - 8
		VisibleY% = NPCs(CameraOn%).y - 5

		ShowDormant
		FadePal 1
	END IF

END SUB

SUB Script (file$)

	DIM TempWarp AS TileDataTYPE
	DIM TempTile AS TileTYPE
	Moved% = False
	JustEntered% = False
	FileNum% = FREEFILE
	OPEN file$ FOR INPUT AS #FileNum%
		DO
			INPUT #FileNum%, Action$
			SELECT CASE Action$
				CASE "Story"
					INPUT #FileNum%, Flag%, Story%, Check%
					IF StoryFlag = True THEN StoryFlag = False
					SELECT CASE Check%
						CASE 0
							IF PartDef%(Flag%) = Story% THEN StoryFlag = True
						CASE 1
							IF PartDef%(Flag%) >= Story% THEN StoryFlag = True
					END SELECT
					IF NOT StoryFlag THEN
						StoryFlag% = ProcessActions(FileNum%, StoryFlag)
						IF StoryFlag% = 2 THEN DoneScript% = True
					END IF
				CASE "StoryElse"
					INPUT #FileNum%, Flag%, Story%, Check%
					IF StoryFlag THEN
							StoryFlag% = ProcessActions(FileNum%, StoryFlag)
							IF StoryFlag% = 2 THEN DoneScript% = True
						ELSE
							SELECT CASE Check%
								CASE 0
									IF PartDef%(Flag%) = Story% THEN StoryFlag = True
								CASE 1
									IF PartDef%(Flag%) >= Story% THEN StoryFlag = True
							END SELECT
							IF NOT StoryFlag THEN
								StoryFlag% = ProcessActions(FileNum%, StoryFlag)
								IF StoryFlag% = 2 THEN DoneScript% = True
							END IF
					END IF
				CASE "SetFlag"
					INPUT #FileNum%, Flag%, Story%
					PartDef%(Flag%) = Story%
					NPCs(CameraOn%).iWhenEnabled = PartDef%(BYTE(NPCs(CameraOn%).byFlag))
				CASE "FlagAdd"
					INPUT #FileNum%, Flag%, Story%
					PartDef%(Flag%) = PartDef%(Flag%) + Story%
					NPCs(CameraOn%).iWhenEnabled = PartDef%(BYTE(NPCs(CameraOn%).byFlag))
				CASE "Shop"
					Shop
				CASE "BoatShop"
					BoatShop
				CASE "ShipShop"
					SpaceShip
				CASE "Inn"
					INPUT #FileNum%, Cost%
					Inn Cost%
				CASE "Refinery"
					Refinery
				CASE "LoadChests"
					INPUT #FileNum%, file$
					LoadChests file$
				CASE "LoadNPC"
					INPUT #FileNum%, file$
					LoadNPCs file$
				CASE "GiveItem"
					INPUT #FileNum%, ItemID$
					Result% = GiveItem(ItemID$)
				CASE "Talk"
					INPUT #FileNum%, Text1$: INPUT #FileNum%, Text2$: INPUT #FileNum%, Text3$: INPUT #FileNum%, Text4$
					DialogBox True, 0, 135, 319, 199, 56
					gsprint 1, 5, 140, Text1$, 31
					gsprint 1, 5, 150, Text2$, 31
					gsprint 1, 5, 160, Text3$, 31
					gsprint 1, 5, 170, Text4$, 31
					gspcopy VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), &HA000, 0
					WHILE INKEY$ <> CHR$(13): WEND
				CASE "Battle"
					INPUT #FileNum%, Bkgfile$, DisableRun%, BossFight%, Lose%
					LoadBkg Bkgfile$
					Battle DisableRun%, Lose%
					SELECT CASE Lose%
						CASE False
							IF NOT Lost% THEN
									IF BossFight% THEN
										FOR i% = 1 TO 5
											Party(i%).SPMAX = Party(i%).SPMAX + 5
										NEXT i%
									END IF
									BossFight% = False
									IF PartDef%(0) = 36 THEN FadePal 2 ELSE ShowDormant
								ELSE
									EXIT DO
							END IF
						CASE True
							'Continue script
							Lost% = False
							FOR i% = 1 TO 5
								IF Party(i%).OnTeam THEN
									Party(i%).HP = 1
									Party(i%).Alive = True
								END IF
							NEXT i%
							ShowDormant
					END SELECT
				CASE "AddPlayer"
					INPUT #FileNum%, Player%
					LoadMember "", Player%
				CASE "Fade"
					INPUT #FileNum%, Way%
					FadePal Way%
				CASE "CameraOn"
					INPUT #FileNum%, Handle%
					CameraOn% = Handle%
					VisibleX% = NPCs(Handle%).x - 8
					VisibleY% = NPCs(Handle%).y - 5
				CASE "LoadMap"
					INPUT #FileNum%, file$, x%, y%, Fade%
					MapFile$ = file$
					TempWarp.x = x%
					TempWarp.y = y%
					TempWarp.sFileName = file$
					ViewMap TempWarp
					IF Fade% THEN FadePal 1
				CASE "Visible"
					INPUT #FileNum%, Handle%, OffOn%
					IF OffOn% THEN
							NPCs(Handle%).iWhenEnabled = PartDef%(BYTE(NPCs(Handle%).byFlag))
						ELSE
							NPCs(Handle%).iWhenEnabled = -2
					END IF
					SELECT CASE PartDef%(0)
						CASE 9, 21 TO 25
							'Don't refresh screen
						CASE ELSE
							ShowDormant
					END SELECT
				CASE "ChangeXY"
					INPUT #FileNum%, Handle%, x%, y%
					NPCs(Handle%).x = x%
					NPCs(Handle%).y = y%
					IF Handle% = CameraOn% THEN
						VisibleX% = NPCs(CameraOn%).x - 8
						VisibleY% = NPCs(CameraOn%).y - 5
					END IF
					ShowDormant
				CASE "Push"
					ShowDormant
					INPUT #FileNum%, Dir%, Many%
					FOR i% = 1 TO Many%
						IF Dir% = FaceRIGHT THEN
								NPCs(CameraOn%).byFacing = CHR$(FaceRIGHT)
								IF Map(NPCs(CameraOn%).x + 1, NPCs(CameraOn%).y).bWalkable AND NOT Boat.BoatOn THEN
									VisibleX% = VisibleX% + 1
									Map(NPCs(CameraOn%).x, NPCs(CameraOn%).y).bWalkable = True
									NPCs(CameraOn%).x = NPCs(CameraOn%).x + 1
									Map(NPCs(CameraOn%).x, NPCs(CameraOn%).y).bWalkable = False
									VisiblePlane 19, 0
									IF NPCs(CameraOn%).x = Boat.x AND NPCs(CameraOn%).y = Boat.y THEN
										Map(Boat.x, Boat.y).bWalkable = False
										Boat.BoatOn = True
										NPCs(CameraOn%).sSet = "boat.set"
										LoadMusic "boat.it", 1
										ShowDormant
									END IF
								ELSEIF Boat.BoatOn THEN
									BoatMovement FaceRIGHT
								END IF
							ELSEIF Dir% = FaceLEFT THEN
								NPCs(CameraOn%).byFacing = CHR$(FaceLEFT)
								IF Map(NPCs(CameraOn%).x - 1, NPCs(CameraOn%).y).bWalkable AND NOT Boat.BoatOn THEN
									VisibleX% = VisibleX% - 1
									Map(NPCs(CameraOn%).x, NPCs(CameraOn%).y).bWalkable = True
									NPCs(CameraOn%).x = NPCs(CameraOn%).x - 1
									Map(NPCs(CameraOn%).x, NPCs(CameraOn%).y).bWalkable = False
									VisiblePlane -19, 0
									IF NPCs(CameraOn%).x = Boat.x AND NPCs(CameraOn%).y = Boat.y THEN
										Map(Boat.x, Boat.y).bWalkable = False
										Boat.BoatOn = True
										NPCs(CameraOn%).sSet = "boat.set"
										LoadMusic "boat.it", 1
										ShowDormant
									END IF
								ELSEIF Boat.BoatOn THEN
									BoatMovement FaceLEFT
								END IF
							ELSEIF Dir% = FaceDOWN THEN
								NPCs(CameraOn%).byFacing = CHR$(FaceDOWN)
								IF Map(NPCs(CameraOn%).x, NPCs(CameraOn%).y + 1).bWalkable AND NOT Boat.BoatOn THEN
									VisibleY% = VisibleY% + 1
									Map(NPCs(CameraOn%).x, NPCs(CameraOn%).y).bWalkable = True
									NPCs(CameraOn%).y = NPCs(CameraOn%).y + 1
									Map(NPCs(CameraOn%).x, NPCs(CameraOn%).y).bWalkable = False
									VisiblePlane 0, 19
									IF NPCs(CameraOn%).x = Boat.x AND NPCs(CameraOn%).y = Boat.y THEN
										Map(Boat.x, Boat.y).bWalkable = False
										Boat.BoatOn = True
										NPCs(CameraOn%).sSet = "boat.set"
										LoadMusic "boat.it", 1
										ShowDormant
									END IF
								ELSEIF Boat.BoatOn THEN
									BoatMovement FaceDOWN
								END IF
							ELSEIF Dir% = FaceUP THEN
								NPCs(CameraOn%).byFacing = CHR$(FaceUP)
								IF Map(NPCs(CameraOn%).x, NPCs(CameraOn%).y - 1).bWalkable AND NOT Boat.BoatOn THEN
									VisibleY% = VisibleY% - 1
									Map(NPCs(CameraOn%).x, NPCs(CameraOn%).y).bWalkable = True
									NPCs(CameraOn%).y = NPCs(CameraOn%).y - 1
									Map(NPCs(CameraOn%).x, NPCs(CameraOn%).y).bWalkable = False
									VisiblePlane 0, -19
									IF NPCs(CameraOn%).x = Boat.x AND NPCs(CameraOn%).y = Boat.y THEN
										Map(Boat.x, Boat.y).bWalkable = False
										Boat.BoatOn = True
										NPCs(CameraOn%).sSet = "boat.set"
										LoadMusic "boat.it", 1
										ShowDormant
									END IF
								ELSEIF Boat.BoatOn THEN
									BoatMovement FaceUP
								END IF
						END IF
					NEXT i%
					ShowDormant
				CASE "PushNPC"
					INPUT #FileNum%, Handle%, Dir%, Many%
					NPCs(Handle%).byFacing = CHR$(Dir%)
					FOR i% = 1 TO Many%
						Push Handle%
					NEXT i%
				CASE "Face"
					INPUT #FileNum%, Handle%, Dir%
					NPCs(Handle%).byFacing = CHR$(Dir%)
					ShowDormant
				CASE "AlignPlayer"
					INPUT #FileNum%, Posit%, Align%
					'Posit tells the cordinate of where i want to align
					'Align tells how i want to align(going e/w 0 or n/s 1 )
					Map(NPCs(CameraOn%).x, NPCs(CameraOn%).y).bWalkable = True
					IF Align% = 0 THEN
							IF NPCs(CameraOn%).x < Posit% THEN
									DO UNTIL NPCs(CameraOn%).x = Posit%
										NPCs(CameraOn%).byFacing = CHR$(FaceRIGHT)
										VisibleX% = VisibleX% + 1
										NPCs(CameraOn%).x = NPCs(CameraOn%).x + 1
										VisiblePlane 19, 0
									LOOP
								ELSEIF NPCs(CameraOn%).x > Posit% THEN
									DO UNTIL NPCs(CameraOn%).x = Posit%
										NPCs(CameraOn%).byFacing = CHR$(FaceLEFT)
										VisibleX% = VisibleX% - 1
										NPCs(CameraOn%).x = NPCs(CameraOn%).x - 1
										VisiblePlane -19, 0
									LOOP
							END IF
						ELSEIF Align% = 1 THEN
							IF NPCs(CameraOn%).y < Posit% THEN
									DO UNTIL NPCs(CameraOn%).y = Posit%
										NPCs(CameraOn%).byFacing = CHR$(FaceDOWN)
										VisibleY% = VisibleY% + 1
										NPCs(CameraOn%).y = NPCs(CameraOn%).y + 1
										VisiblePlane 0, 19
									LOOP
								ELSEIF NPCs(CameraOn%).y > Posit% THEN
									DO UNTIL NPCs(CameraOn%).y = Posit%
										NPCs(CameraOn%).byFacing = CHR$(FaceUP)
										VisibleY% = VisibleY% - 1
										NPCs(CameraOn%).y = NPCs(CameraOn%).y - 1
										VisiblePlane 0, -19
									LOOP
							END IF
					END IF
					Map(NPCs(CameraOn%).x, NPCs(CameraOn%).y).bWalkable = False
				CASE "Wait"
					INPUT #FileNum%, Delay%
					gswait Delay%
				CASE "End"
					DoneScript% = True
				CASE "LoadMusic"
					INPUT #FileNum%, file$
					LoadMusic file$, 1
				CASE "ChangeTile"
					INPUT #FileNum%, x%, y%, byLayer1%, byLayer2%, byLayer3%, Walkable%, ScriptID%, WarpID%, RegionID%
					TempTile.byLayer1 = CHR$(byLayer1%)
					TempTile.byLayer2 = CHR$(byLayer2%)
					TempTile.byLayer3 = CHR$(byLayer3%)
					TempTile.bWalkable = Walkable%
					TempTile.byScriptID = CHR$(ScriptID%)
					TempTile.byWarpID = CHR$(WarpID%)
					TempTile.byRegionID = CHR$(RegionID%)
					Map(x%, y%) = TempTile
				CASE "LoadMember"
					INPUT #FileNum%, file$, Level%
					LoadMember file$, Level%
				CASE "ChangeMusic"
					INPUT #FileNum%, file$
					MapInfo.sMapMusic = file$
				CASE "BattleMusic"
					INPUT #FileNum%, file$
					Background.sMusic = file$
				CASE "SetRegion"
					INPUT #FileNum%, file$, Region%
					Regions(Region%).sFileName = file$
				CASE "PartySwitch"
					INPUT #FileNum%, Handle$, Param1%, Param2%
					PartySwitch Handle$, Param1%, Param2%
				CASE "SetBoat"
					INPUT #FileNum%, x%, y%, OnOff%
					Boat.x = x%
					Boat.y = y%
					Boat.BoatOn = OnOff%
				CASE "TimerEvent"
					INPUT #FileNum%, TimeLimit%, TimerOn%
					Timed.TimeStarted = TIMER
					Timed.TimeOn = TimeLimit%
					Timed.TimerOn = TimerOn%
				CASE "ChangeSet"
					INPUT #FileNum%, Handle%, Set$
					NPCs(Handle%).sSet = Set$
				CASE "RemoveItem"
					INPUT #FileNum%, ItemID$
					RemoveItem ItemID$
				CASE "EffectDark"
					INPUT #FileNum%, OnOff%
					EffectDark% = OnOff%
				CASE "MusicFade"
					INPUT #FileNum%, Fade%
					IF Fade = 1 THEN CFade 1, 100, 0, -20
					IF Fade = 2 THEN CFade 1, 0, 100, 20
				CASE "Credits"
					INPUT #FileNum%, file$
					Credits file$
				CASE "OnTeam"
					INPUT #FileNum%, Char$, Char2$
					IF StoryFlag = True THEN StoryFlag = False
					FOR i% = 1 TO 5
						IF RTRIM$(Party(i%).Title) = Char$ AND Party(i%).OnTeam THEN
							FOR j% = 1 TO 5
								IF RTRIM$(Party(j%).Title) = Char2$ OR Char2$ = "" AND Party(j%).OnTeam THEN
									StoryFlag = True
								END IF
							NEXT j%
						END IF
					NEXT i%
					IF NOT StoryFlag THEN
						StoryFlag% = ProcessActions(FileNum%, StoryFlag)
						IF StoryFlag% = 2 THEN DoneScript% = True
					END IF
				CASE "GiveMajorSpell"
					GiveMajorSpell
				CASE "PartyOff"
					INPUT #FileNum%, Slot%, OnOff%
					IF OnOff% THEN
							Party(Slot%).HP = Party(Slot%).HPMax
							Party(Slot%).Alive = True
							Party(Slot%).OnTeam = True
						ELSE
							Party(Slot%).HP = Party(Slot%).HPMax
							Party(Slot%).Alive = False
							Party(Slot%).OnTeam = False
					END IF
				CASE "ArmRefinery"
					ArmRefinery
				CASE "EndGame"
					FadePal 0
					ShutDownDS4QB
					END
			END SELECT
		LOOP UNTIL DoneScript%
	CLOSE #FileNum%

END SUB

SUB Shop

	DIM ItemD AS ItemTYPE
	FileNum% = FREEFILE

	SELECT CASE RTRIM$(MapInfo.sMapName)
		CASE "Cai Clan Base F1"
			IF PartDef%(0) < 10 THEN NumItms% = 2
			IF PartDef%(0) > 10 THEN NumItms% = 4
			SaleItem$(1) = "Potion": ItemPrice%(1) = 70
			SaleItem$(2) = "Revive": ItemPrice%(2) = 300
			SaleItem$(3) = "Hi Potion": ItemPrice%(3) = 250
			SaleItem$(4) = "Magic Brace": ItemPrice%(4) = 2500
		CASE "Damsi Town"
			NumItms% = 5
			SaleItem$(1) = "Potion": ItemPrice%(1) = 65
			SaleItem$(2) = "Antidote": ItemPrice%(2) = 100
			SaleItem$(3) = "Revive": ItemPrice%(3) = 300
			SaleItem$(4) = "Hi Potion": ItemPrice%(4) = 350
			SaleItem$(5) = "L. Brace": ItemPrice%(5) = 400
		CASE "Tentath City"
			NumItms% = 5
			SaleItem$(1) = "Potion": ItemPrice%(1) = 40
			SaleItem$(2) = "Hi Potion": ItemPrice%(2) = 350
			SaleItem$(3) = "Revive": ItemPrice%(3) = 250
			SaleItem$(4) = "SP Potion": ItemPrice%(4) = 500
			SaleItem$(5) = "Excel Brace": ItemPrice%(5) = 1000
		CASE "Kila"
			NumItms% = 6
			SaleItem$(1) = "Potion": ItemPrice%(1) = 30
			SaleItem$(2) = "Hi Potion": ItemPrice%(2) = 150
			SaleItem$(3) = "SP Potion": ItemPrice%(3) = 250
			SaleItem$(4) = "Antidote": ItemPrice%(4) = 60
			SaleItem$(5) = "Revive": ItemPrice%(5) = 350
			SaleItem$(6) = "Chain Brace": ItemPrice%(6) = 1000
		CASE "Sahja Town"
			NumItms% = 6
			SaleItem$(1) = "Potion": ItemPrice%(1) = 100
			SaleItem$(2) = "Hi Potion": ItemPrice%(2) = 450
			SaleItem$(3) = "Revive": ItemPrice%(3) = 550
			SaleItem$(4) = "SP Potion": ItemPrice%(4) = 750
			SaleItem$(5) = "Chain Brace": ItemPrice%(5) = 1300
			SaleItem$(6) = "Excel Brace": ItemPrice%(6) = 1300
		CASE "Scarlet"
			NumItms% = 7
			SaleItem$(1) = "Potion": ItemPrice%(1) = 40
			SaleItem$(2) = "Antidote": ItemPrice%(2) = 90
			SaleItem$(3) = "Revive": ItemPrice%(3) = 350
			SaleItem$(4) = "Hi Potion": ItemPrice%(4) = 300
			SaleItem$(5) = "SP Potion": ItemPrice%(5) = 350
			SaleItem$(6) = "SP2 Potion": ItemPrice%(6) = 2000
			SaleItem$(7) = "Hide Brace": ItemPrice%(7) = 1500
		CASE "Selfane"
			NumItms% = 5
			SaleItem$(1) = "Antidote": ItemPrice%(1) = 90
			SaleItem$(2) = "Revive": ItemPrice%(2) = 350
			SaleItem$(3) = "Hi Potion": ItemPrice%(3) = 300
			SaleItem$(4) = "SP2 Potion": ItemPrice%(4) = 1500
			SaleItem$(5) = "Mega Brace": ItemPrice%(5) = 5000
		CASE "Inventa"
			NumItms% = 8
			SaleItem$(1) = "Potion": ItemPrice%(1) = 200
			SaleItem$(2) = "Antidote": ItemPrice%(2) = 200
			SaleItem$(3) = "Revive": ItemPrice%(3) = 1000
			SaleItem$(4) = "Hi Potion": ItemPrice%(4) = 950
			SaleItem$(5) = "SP Potion": ItemPrice%(5) = 1000
			SaleItem$(6) = "SP2 Potion": ItemPrice%(6) = 4000
			SaleItem$(7) = "Mega Brace": ItemPrice%(7) = 10000
			SaleItem$(8) = "Pricey Brace": ItemPrice%(8) = 20000
	END SELECT

	CursorX% = 190: CursorY% = 55
	DrawMenuBack "Shop", 0
	EndY% = -5 + (NumItms% * 10)
	DO
		SELECT CASE INKEY$
			CASE CHR$(0) + CHR$(72)
				CursorY% = CursorY% - 10
				IF CursorY% = 45 THEN CursorY% = 55
				DrawMenuBack "Shop", 0
			CASE CHR$(0) + CHR$(80)
				CursorY% = CursorY% + 10
				IF CursorY% = 85 THEN CursorY% = 75
				DrawMenuBack "Shop", 0
			CASE CHR$(13)
				IF CursorY% = 55 THEN
					CursorX% = 5: CursorY% = 5
					DrawMenuBack "Shop", 1
					ItemNum% = 1
					DO
						SELECT CASE INKEY$
							CASE CHR$(0) + CHR$(72)
								CursorY% = CursorY% - 10: ItemNum% = ItemNum% - 1
								IF CursorY% = -5 THEN CursorY% = 5
								IF ItemNum% = 0 THEN ItemNum% = 1
								DrawMenuBack "Shop", 1
							CASE CHR$(0) + CHR$(80)
								CursorY% = CursorY% + 10: ItemNum% = ItemNum% + 1
								IF CursorY% = EndY% + 10 THEN CursorY% = EndY%
								IF ItemNum% > NumItms% THEN ItemNum% = NumItms%
								DrawMenuBack "Shop", 1
							CASE CHR$(13)
								x% = CursorX%: y% = CursorY%
								DrawMenuBack "Shop", 1
								FOR i% = 1 TO 18
									ItemQuery Item(ItemPage%, i%).ItemID, ItemD
									IF RTRIM$(ItemD.Title) = SaleItem$(ItemNum%) THEN
											MaxQnt% = 99 - Item(ItemPage%, i%).Quantity
											EXIT FOR
										ELSE
											MaxQnt% = 99
									END IF
								NEXT i%
								ExPrice& = Quant(MaxQnt%)
								Price& = ItemPrice%(ItemNum%)
								gsprint 0, 5, 140, "The " + SaleItem$(ItemNum%) + "(s)" + " costs" + STR$(Price& * ExPrice&) + ".", 31
								gsprint 0, 5, 150, "Do you want this item?", 31
								Result% = ChoiceBox%
								IF Result% THEN
										CursorX% = x%: CursorY% = y%
										IF Cal& >= (Price& * ExPrice&) THEN
												FOR i% = 1 TO ExPrice&
													Result% = GiveItem(SaleItem$(ItemNum%))
												NEXT i%
												IF Result% THEN
														Cal& = Cal& - (Price& * ExPrice&)
														DrawMenuBack "Shop", 1
														gsprint 0, 5, 140, "Thank you.  Anything else?", 31
													ELSEIF NOT Result% THEN
														DrawMenuBack "Shop", 1
														gsprint 0, 5, 140, "You have too many items!", 31
												END IF
											ELSE
												DrawMenuBack "Shop", 1
												gsprint 0, 5, 140, "You don't have enoght Cal.", 31
										END IF
									ELSEIF NOT Result% THEN
										CursorX% = x%: CursorY% = y%
										DrawMenuBack "Shop", 1
								END IF
							CASE CHR$(0) + CHR$(83)
								CursorX% = 190: CursorY% = 55
								Done% = True: DrawMenuBack "Shop", 0
						END SELECT
					LOOP UNTIL Done%
					Done% = False
				END IF

				IF CursorY% = 65 THEN
					CursorX% = 5: CursorY% = 5
					FirstItem% = 1: ItemNum% = 1
					DrawMenuBack "Shop", 4
					DO
						SELECT CASE INKEY$
							CASE CHR$(0) + CHR$(72)
								CursorY% = CursorY% - 10: ItemNum% = ItemNum% - 1
								IF CursorY% = -5 THEN FirstItem% = FirstItem% - 1
								IF CursorY% = -5 THEN CursorY% = 5
								IF FirstItem% = 0 THEN FirstItem% = 1
								IF ItemNum% = 0 THEN ItemNum% = 1
								DrawMenuBack "Shop", 4
							CASE CHR$(0) + CHR$(80)
								CursorY% = CursorY% + 10: ItemNum% = ItemNum% + 1
								IF CursorY% = 125 THEN FirstItem% = FirstItem% + 1
								IF CursorY% = 125 THEN CursorY% = 115
								IF FirstItem% = 8 THEN FirstItem% = 7
								IF ItemNum% = 19 THEN ItemNum% = 18
								DrawMenuBack "Shop", 4
							CASE CHR$(13)
								IF Item(ItemPage%, ItemNum%).Quantity <> 0 THEN
									x% = CursorX%: y% = CursorY%
									ExPrice& = Quant(Item(ItemPage%, ItemNum%).Quantity)
									ItemQuery Item(ItemPage%, ItemNum%).ItemID, ItemD
									gsprint 0, 5, 140, "The " + RTRIM$(ItemD.Title) + "(s) sells for" + STR$(ItemD.Value * ExPrice&) + ".", 31
									gsprint 0, 5, 150, "Do you want to sell this item?", 31
									Result% = ChoiceBox%
									IF Result% THEN
											CursorX% = x%: CursorY% = y%
											Cal& = Cal& + (ItemD.Value * ExPrice&)
											IF Cal& > 999999 THEN Cal& = 999999
											FOR i% = 1 TO ExPrice&
												Item(ItemPage%, ItemNum%).Quantity = Item(ItemPage%, ItemNum%).Quantity - 1
												IF Item(ItemPage%, ItemNum%).Quantity = 0 THEN Item(ItemPage%, ItemNum%).ItemID = 0
											NEXT i%
											DrawMenuBack "Shop", 4
											gsprint 0, 5, 140, "Thank you.  Anything else?", 31
										ELSEIF NOT Result% THEN
											CursorX% = x%: CursorY% = y%
											DrawMenuBack "Shop", 4
									END IF
								END IF
							CASE CHR$(0) + CHR$(83)
								CursorX% = 190: CursorY% = 55
								Done% = True: DrawMenuBack "Shop", 0
						END SELECT
					LOOP UNTIL Done%
					Done% = False
				END IF
				IF CursorY% = 75 THEN ShopDone% = True
		END SELECT
	LOOP UNTIL ShopDone%

	ShowDormant

END SUB

SUB ShowBigMenu (Action%)

	DIM ItemD AS ItemTYPE

	ShowBattle 0
	DialogBox True, 0, 135, 151, 199, 56

	IF Action% = 1 THEN
		FOR i% = FirstItem% TO FirstItem% + 4
			ItemQuery Item(ItemPage%, i%).ItemID, ItemD
			IF Item(ItemPage%, i%).Quantity <> 0 THEN
				gsprint 1, 120, 140 + y%, STR$(Item(ItemPage%, i%).Quantity), 31
				gsprint 1, 20, 140 + y%, RTRIM$(ItemD.Title), 31
			END IF
			'gsprint 1, 20, 140 + y%, Item(ItemPage%, i%).Title, 31
			y% = y% + 10
		NEXT i%
	END IF

	IF Action% = 2 THEN
		FOR i% = FirstItem% TO FirstItem% + 4
			gsprint 1, 20, 140 + y%, Magic$(CharTurn%, i%), 31
			IF SPNeed%(CharTurn%, i%) <> 0 THEN gsprint 1, 120, 140 + y%, STR$(SPNeed%(CharTurn%, i%)), 31
			y% = y% + 10
		NEXT i%
	END IF

	IF Action% = 3 THEN
		gsprint 1, 20, 140, "Heal/Damage  5", 31
		FOR i% = 1 TO 3
			IF Party(i%).OnTeam = True THEN
				SELECT CASE RTRIM$(Party(i%).Title)
					CASE "Cerl"
						IF Party(i%).Lev > 9 THEN gsprint 1, 20, 150, "Magic Sword  10", 31
						IF RTRIM$(Enemy(1).Title) = "Cosmosis" THEN
							IF NOT StarsofFate% THEN
									gsprint 1, 20, 180, "Stars of Fate 0", 31
								ELSE
									gsprint 1, 20, 180, "Stars of Fate 0", 25
							END IF
						END IF
					CASE "Ariel"
						IF Party(i%).Lev > 24 THEN gsprint 1, 20, 160, "Fast Break 10", 31
					CASE "Dane"
						IF Party(i%).Lev > 39 THEN gsprint 1, 20, 170, "Holy Cross 10", 31
				END SELECT
			END IF
		NEXT i%
	END IF

	ShowSprite "pointer.spr", CursorX%, CursorY%, 0, 20, 0
	gspcopy VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), &HA000, 0

END SUB

SUB ShowSprite (FileName$, x%, y%, Number%, Size%, PutType)

	FileNum% = FREEFILE
	OPEN "tiles\" + FileName$ FOR BINARY AS #FileNum%
		Ints = (LOF(FileNum%) - 7) \ 2
	CLOSE #FileNum%
	IF Ints <= 0 THEN EXIT SUB

	DIM Sprite%(1 TO Ints)

	DEF SEG = VARSEG(Sprite(1))
	BLOAD "tiles\" + FileName$, VARPTR(Sprite%(1))
	DEF SEG

	DIM Temp(1 TO 1000)
	Ptr& = 1: IndexNo = 1: LastInt = UBOUND(Sprite%)
	DO
		Temp(IndexNo) = Ptr&
		IndexNo = IndexNo + 1

		x& = (Sprite%(Ptr&) \ 8) * (Sprite%(Ptr& + 1)) + 4
		IF x& MOD 2 THEN x& = x& + 1
		Ptr& = Ptr& + (x& \ 2)
	LOOP WHILE Ptr& < LastInt

	LastImage = IndexNo - 1

	'Copy the image index values into the actual index array.
	DIM IndexArray(0 TO LastImage - 1)
	FOR n = 0 TO LastImage - 1
		IndexArray(n) = Temp(n + 1)
	NEXT n

	IF PutType% = 0 THEN
			gssprite x%, y%, VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), VARSEG(Sprite%(IndexArray(Number%))), VARPTR(Sprite%(IndexArray(Number%)))
		ELSEIF PutType = 1 THEN
			gsputt1 x%, y%, VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), VARSEG(Sprite%(IndexArray(Number%))), VARPTR(Sprite%(IndexArray(Number%)))
		ELSEIF PutType = 2 THEN
			gsputt2 x%, y%, VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), VARSEG(Sprite%(IndexArray(Number%))), VARPTR(Sprite%(IndexArray(Number%)))
	END IF

END SUB

SUB Spritelayer (ExtraX%, ExtraY%)

	FOR i% = 0 TO NumNPCs - 1
		IF i% <> MovNPC% AND i% <> CameraOn% AND NpcVisible(i%) THEN
			IF NPCs(i%).x >= VisibleX% - 1 AND NPCs(i%).x <= VisibleX% + 16 AND NPCs(i%).y >= VisibleY% - 1 AND NPCs(i%).y <= VisibleY% + 10 THEN
				IF Move(i%).Dir = -1 THEN
						Move(i%).MoveX = 0: Move(i%).MoveY = 0
						Movement$ = MID$(RTRIM$(NPCs(i%).sMovement), Move(i%).Frame, 1)
						IF Move(i%).Reverse THEN
							SELECT CASE Movement$
								CASE "N"
									Movement$ = "S"
								CASE "S"
									Movement$ = "N"
								CASE "W"
									Movement$ = "E"
								CASE "E"
									Movement$ = "W"
							END SELECT
						END IF

						SELECT CASE Movement$
							CASE "R"
								Temp% = INT(RND * 4)
								SELECT CASE Temp%
									CASE FaceUP
										IF Map(NPCs(i%).x, NPCs(i%).y - 1).bWalkable THEN
											Map(NPCs(i%).x, NPCs(i%).y - 1).bWalkable = False
											Move(i%).Dir = Temp%
											NPCs(i%).byFacing = CHR$(Temp%)
										END IF
									CASE FaceDOWN
										IF Map(NPCs(i%).x, NPCs(i%).y + 1).bWalkable THEN
											Map(NPCs(i%).x, NPCs(i%).y + 1).bWalkable = False
											Move(i%).Dir = Temp%
											NPCs(i%).byFacing = CHR$(Temp%)
										END IF
									CASE FaceLEFT
										IF Map(NPCs(i%).x - 1, NPCs(i%).y).bWalkable THEN
											Map(NPCs(i%).x - 1, NPCs(i%).y).bWalkable = False
											Move(i%).Dir = Temp%
											NPCs(i%).byFacing = CHR$(Temp%)
										END IF
									CASE FaceRIGHT
										IF Map(NPCs(i%).x + 1, NPCs(i%).y).bWalkable THEN
											Map(NPCs(i%).x + 1, NPCs(i%).y).bWalkable = False
											Move(i%).Dir = Temp%
											NPCs(i%).byFacing = CHR$(Temp%)
										END IF
								END SELECT
							CASE "N"
								IF Map(NPCs(i%).x, NPCs(i%).y - 1).bWalkable THEN
									Map(NPCs(i%).x, NPCs(i%).y - 1).bWalkable = False
									Move(i%).Dir = FaceUP
									NPCs(i%).byFacing = CHR$(FaceUP)
								END IF
							CASE "S"
								IF Map(NPCs(i%).x, NPCs(i%).y + 1).bWalkable THEN
									Map(NPCs(i%).x, NPCs(i%).y + 1).bWalkable = False
									Move(i%).Dir = FaceDOWN
									NPCs(i%).byFacing = CHR$(FaceDOWN)
								END IF
							CASE "W"
								IF Map(NPCs(i%).x - 1, NPCs(i%).y).bWalkable THEN
									Map(NPCs(i%).x - 1, NPCs(i%).y).bWalkable = False
									Move(i%).Dir = FaceLEFT
									NPCs(i%).byFacing = CHR$(FaceLEFT)
								END IF
							CASE "E"
								IF Map(NPCs(i%).x + 1, NPCs(i%).y).bWalkable THEN
									Map(NPCs(i%).x + 1, NPCs(i%).y).bWalkable = False
									Move(i%).Dir = FaceRIGHT
									NPCs(i%).byFacing = CHR$(FaceRIGHT)
								END IF
							CASE "P"
								'Take a break
								Move(i%).Dir = 5
						END SELECT
					ELSE
						SELECT CASE Move(i%).Dir
							CASE FaceUP
								Move(i%).MoveY = Move(i%).MoveY - 1
								IF Move(i%).MoveY = -20 THEN
									Move(i%).Dir = -1
									Map(NPCs(i%).x, NPCs(i%).y).bWalkable = True
									NPCs(i%).y = NPCs(i%).y - 1
									Move(i%).MoveY = 0
								END IF
							CASE FaceDOWN
								Move(i%).MoveY = Move(i%).MoveY + 1
								IF Move(i%).MoveY = 20 THEN
									Move(i%).Dir = -1
									Map(NPCs(i%).x, NPCs(i%).y).bWalkable = True
									NPCs(i%).y = NPCs(i%).y + 1
									Move(i%).MoveY = 0
								END IF
							CASE FaceLEFT
								Move(i%).MoveX = Move(i%).MoveX - 1
								IF Move(i%).MoveX = -20 THEN
									Move(i%).Dir = -1
									Map(NPCs(i%).x, NPCs(i%).y).bWalkable = True
									NPCs(i%).x = NPCs(i%).x - 1
									Move(i%).MoveX = 0
								END IF
							CASE FaceRIGHT
								Move(i%).MoveX = Move(i%).MoveX + 1
								IF Move(i%).MoveX = 20 THEN
									Move(i%).Dir = -1
									Map(NPCs(i%).x, NPCs(i%).y).bWalkable = True
									NPCs(i%).x = NPCs(i%).x + 1
									Move(i%).MoveX = 0
								END IF
							CASE 5
								Move(i%).Anim = Move(i%).Anim + 1
								IF Move(i%).Anim = 20 THEN
									Move(i%).Anim = 0
									Move(i%).Dir = -1
								END IF
						END SELECT
						IF Move(i%).Dir = -1 THEN
							IF NOT Move(i%).Reverse THEN
									Move(i%).Frame = Move(i%).Frame + 1
									IF Move(i%).Frame > Move(i%).NumFrames THEN
										Move(i%).Frame = Move(i%).NumFrames
										Move(i%).Reverse = True
									END IF
								ELSE
									Move(i%).Frame = Move(i%).Frame - 1
									IF Move(i%).Frame < 1 THEN
										Move(i%).Frame = 1
										Move(i%).Reverse = False
									END IF
							END IF
						END IF
				END IF
				a% = NPCs(i%).x - VisibleX%
				b% = NPCs(i%).y - VisibleY%
				IF Move(i%).Dir <> -1 AND Move(i%).Dir <> 5 THEN
						ShowChar True, i%, a% * 20 + ExtraX% + Move(i%).MoveX, b% * 20 + ExtraY% + Move(i%).MoveY
					ELSE
						ShowChar False, i%, a% * 20 + ExtraX% + Move(i%).MoveX, b% * 20 + ExtraY% + Move(i%).MoveY
				END IF
			END IF
		END IF
	NEXT i%

	FOR i% = 1 TO NumChests%
		a% = Chest(i%).x - VisibleX%
		b% = Chest(i%).y - VisibleY%

		SELECT CASE Chest(i%).ChType
			CASE 0
				IF Chest(i%).x >= VisibleX% - 1 AND Chest(i%).x <= VisibleX% + 16 AND Chest(i%).y >= VisibleY% - 1 AND Chest(i%).y <= VisibleY% + 10 THEN
					IF NOT ChestStatus%(Chest(i%).Number) THEN
							ShowSprite "chest.set", a% * 20 + ExtraX%, b% * 20 + ExtraY%, 0, 20, 0
						ELSE
							ShowSprite "chest.set", a% * 20 + ExtraX%, b% * 20 + ExtraY%, 1, 20, 0
					END IF
				END IF
			CASE -1
				IF Chest(i%).x = x% AND Chest(i%).y = y% THEN
					IF NOT ChestStatus%(Chest(i%).Number) THEN
							ShowSprite "spspring.til", a% * 20 + ExtraX%, b% * 20 + ExtraY%, 0, 20, 0
						ELSE
							'Show nothing
					END IF
				END IF
		END SELECT
	NEXT i%

END SUB

SUB TimerEvent

	IF Timed.TimerOn THEN
		Timed.TotalTime = TIMER
		IF Timed.TotalTime - Timed.TimeStarted < 0 THEN
			Timed.TotalTime = 86400 + Time.TotalTime!
		END IF

		Timed.TimeOn = Timed.TimeOn - (Timed.TotalTime - Timed.TimeStarted)
		IF Timed.TimeOn < 1 THEN Timed.TimeOn = 0: Lost% = True
		Timed.TimeStarted = TIMER
		Minutes! = INT(Timed.TimeOn / 60)
		Minutes! = Minutes! MOD 60
		Seconds! = INT(Timed.TimeOn) MOD 60
		IF Seconds! < 10 THEN S$ = "0" + RIGHT$(STR$(Seconds!), 1) ELSE S$ = RIGHT$(STR$(Seconds!), 2)
		IF Minutes! < 10 THEN M$ = "0" + RIGHT$(STR$(Minutes!), 1) ELSE M$ = RIGHT$(STR$(Minutes!), 2)
		gsprint 1, 25, 25, M$ + ":" + S$, 31
	END IF

END SUB

SUB ViewMap (Warp AS TileDataTYPE)

	DIM Ver AS INTEGER

	FadePal 0
	IF EffectDark% THEN
		FOR i% = 1 TO 10
			PaletteFade 1, 1, 1
		NEXT i%
		EffectDark% = False
	END IF

	Music$ = MapInfo.sMapMusic
	FileNum% = FREEFILE
	OPEN "maps\" + Warp.sFileName FOR BINARY AS #FileNum%
		GET #FileNum%, , Ver
		GET #FileNum%, , MapInfo

		REDIM Map(-1 TO MapInfo.xMaxX + 1, -1 TO MapInfo.yMaxY + 1) AS TileTYPE
		FOR y% = 0 TO MapInfo.yMaxY - 1
			FOR x% = 0 TO MapInfo.xMaxX - 1
				GET #FileNum%, , Map(x%, y%)
			NEXT x%
		NEXT y%

		IF BYTE(MapInfo.byNumScripts) THEN
			REDIM Scripts(1 TO BYTE(MapInfo.byNumScripts)) AS TileDataTYPE
			FOR i% = 1 TO BYTE(MapInfo.byNumScripts)
				GET #FileNum%, , Scripts(i%)
			NEXT i%
		END IF

		IF BYTE(MapInfo.byNumWarps) THEN
			REDIM Warps(1 TO BYTE(MapInfo.byNumWarps)) AS TileDataTYPE
			FOR i% = 1 TO BYTE(MapInfo.byNumWarps)
				GET #FileNum%, , Warps(i%)
			NEXT i%
		END IF

		IF BYTE(MapInfo.byNumRegions) THEN
			REDIM Regions(1 TO BYTE(MapInfo.byNumRegions)) AS TileDataTYPE
			FOR i% = 1 TO BYTE(MapInfo.byNumRegions)
				GET #FileNum%, , Regions(i%)
			NEXT i%
		END IF

		REDIM Move(1) AS NpcMoveTYPE
		REDIM NPCs(1) AS NpcTYPE
		NumNPCs = 1
		NumChests% = 0
	CLOSE #FileNum%

	NPCs(0).sSet = "nick.set"
	NPCs(0).sMovement = "P"

	IF INSTR(MapInfo.sMScript, ".scr") THEN
		Script "maps\" + MapInfo.sMScript
	END IF

	NPCs(CameraOn%).x = Warp.x
	NPCs(CameraOn%).y = Warp.y
	VisibleX% = NPCs(CameraOn%).x - 8
	VisibleY% = NPCs(CameraOn%).y - 5
	Map(NPCs(CameraOn%).x, NPCs(CameraOn%).y).bWalkable = False

	NPCs(CameraOn%).iWhenEnabled = PartDef%(BYTE(NPCs(CameraOn%).byFlag))

	Script "data\global.scr"

	IF EffectDark% THEN
		FOR i% = 1 TO 10
			PaletteFade -1, -1, -1
		NEXT i%
	END IF

	FOR i% = -1 TO MapInfo.yMaxY + 1
		Map(-1, i%) = Map(0, 0)
		Map(MapInfo.xMaxX + 1, i%) = Map(0, 0)
	NEXT i%

	FOR i% = 0 TO MapInfo.xMaxX - 1
		Map(i%, 4).bWalkable = False
		Map(i%, MapInfo.yMaxY - 4).bWalkable = False
	NEXT i%

	FOR i% = 0 TO MapInfo.yMaxY - 1
		Map(7, i%).bWalkable = False
		Map(MapInfo.xMaxX - 7, i%).bWalkable = False
	NEXT i%

	IF NOT Boat.BoatOn AND RTRIM$(MapInfo.sMapName) = "Paravia" THEN
		Map(Boat.x, Boat.y).bWalkable = True
	END IF

	IF Boat.BoatOn THEN
			LoadMusic "boat.it", 1
			NPCs(0).sSet = "boat.set"
		ELSEIF RTRIM$(MapInfo.sMapMusic) <> RTRIM$(Music$) THEN
			Mus$ = MapInfo.sMapMusic
			LoadMusic Mus$, 1
	END IF

	LoadTiles MapInfo.sTileSet
	ShowDormant

END SUB

