DEFINT A-Z
'$DYNAMIC
'$INCLUDE: 'cai3.bi'
'$INCLUDE: 'gslib.bi'
'$INCLUDE: 'ds4qb2.bi'

DECLARE FUNCTION Center% (Talk$)
DECLARE FUNCTION DamageCalc% (AtkPow%, DefPow%, AtkEx%, DefEx%, Varience%)
DECLARE SUB ItemQuery (ItemID%, ItemData AS ANY)
DECLARE SUB Script (file$)
DECLARE FUNCTION BYTE% (sTemp$)
DECLARE SUB LoadMusic (file$, Channel%)
DECLARE SUB VisiblePlane (xDir, yDir)
DECLARE SUB MessageBar (Phrase$)
DECLARE FUNCTION SelectPlayer% ()
DECLARE FUNCTION GiveItem% (Itm$)
DECLARE FUNCTION SelectAction% (Act%)
DECLARE SUB ShowBigMenu (Action%)
DECLARE SUB FadePal (Direction%)
DECLARE SUB PlayerAttack (CharGo%)
DECLARE FUNCTION SelectEnemy% ()
DECLARE SUB EnemyAttack (EnemyDo%)
DECLARE SUB LoadEnemy (file$, Number%)
DECLARE SUB NPrint (Flip%, xcol%, ycol%, text$, colr%)
DECLARE SUB BattleMenu (Char%)
DECLARE SUB ShowSprite (FileName$, x%, y%, Number%, Size%, PutType%)
DECLARE SUB ShowBattleMenu ()
DECLARE SUB ShowBattle (Anime%)
DECLARE SUB gsprint (Flip%, xpos%, ypos%, text$, col%)
DECLARE SUB DialogBox (Flip%, x1%, y1%, x2%, y2%, col%)
DECLARE SUB WipeScreen ()

SUB Battle (DisableRun%, BattleType%)

	DIM SpellD AS SpDatTYPE

	RANDOMIZE TIMER
	WipeScreen
	ShowBattle 0
	gspcopy VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), &HA000, 0

	DO
		DEF SEG = 0: POKE &H41A, PEEK(&H41C): DEF SEG 'clear keyboard

		IF Party(1).Alive THEN Act%(1) = Act%(1) + (((Party(1).Dex + Haste%(1)) * .5) + 1)
		IF Party(2).Alive THEN Act%(2) = Act%(2) + (((Party(2).Dex + Haste%(2)) * .4) + 1)
		IF Party(3).Alive THEN Act%(3) = Act%(3) + (((Party(3).Dex + Haste%(3)) * .3) + 1)

		FOR i% = 1 TO 3
			IF Enemy(i%).Alive THEN Act%(i% + 3) = Act%(i% + 3) + ((Enemy(i%).Dex * .6) + 1)
		NEXT

		ShowBattle 0
		IF BattleAnime = 0 THEN BattleAnime = 1 ELSE BattleAnime = 0
		gspcopy VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), &HA000, 0
		gswait 10
		IF Party(1).Alive AND NOT Attacked% AND Act%(1) > 99 THEN BattleMenu 1: Act%(1) = 0: Attacked% = True
		IF Party(2).Alive AND NOT Attacked% AND Act%(2) > 99 THEN BattleMenu 2: Act%(2) = 0: Attacked% = True
		IF Party(3).Alive AND NOT Attacked% AND Act%(3) > 99 THEN BattleMenu 3: Act%(3) = 0: Attacked% = True

		IF NOT Attacked% AND Act%(4) > 99 THEN EnemyAttack 1: Act%(4) = 0: Attacked% = True
		IF NOT Attacked% AND Act%(5) > 99 THEN EnemyAttack 2: Act%(5) = 0: Attacked% = True
		IF NOT Attacked% AND Act%(6) > 99 THEN EnemyAttack 3: Act%(6) = 0: Attacked% = True

		IF NOT Party(1).Alive AND NOT Party(2).Alive AND NOT Party(3).Alive THEN
				DSRemoveMusic 2
				IF BattleType% <> -1 THEN
					LoadMusic "fate.it", 1
				END IF
				ShowBattle 0
				MessageBar "The Party has been devastated..."
				gswait 100
				Lost% = True
			ELSEIF NOT Enemy(1).Alive AND NOT Enemy(2).Alive AND NOT Enemy(3).Alive THEN
				Won% = True
			ELSEIF Ran% THEN
				IF DisableRun% THEN
						Ran% = False
						ShowBattle 0
						MessageBar "You cannot run!"
						gswait 100
					ELSE
						RunChance% = INT(RND * 3) + 1
						IF RunChance% = 3 THEN
							Ran% = False
							ShowBattle 0
							MessageBar "You couldn't escape!"
							gswait 100
						END IF
				END IF
			ELSE
				FOR i% = 1 TO 3
					SELECT CASE Party(i%).Status
						CASE 2
							IF Party(i%).Alive AND Attacked% THEN
								ShowBattle 0
								MessageBar RTRIM$(Party(i%).Title) + " is poisoned..."
								gswait 60
								Damage% = INT(Party(i%).HP * .1)
								IF Damage% < 1 THEN Damage% = 1
								Party(i%).HP = Party(i%).HP - Damage%
								IF Party(i%).HP < 1 THEN Party(i%).HP = 0: Party(i%).Alive = False
							END IF
						CASE 3, 4
							IF Turn% > 20 THEN Haste(i%) = 0: Turn% = 0: Party(i%).Status = 1
					END SELECT
				NEXT i%
		END IF
		Attacked% = False: Turn% = Turn% + 1
		gswait 10
	LOOP UNTIL Ran% OR Lost% OR Won%

	IF Ran% THEN
		ShowBattle 0
		MessageBar "The Party ran away..."
	END IF

	FOR j% = 1 TO 3
		Party(j).Attacking = True
	NEXT j%

	IF Won% THEN
		LoadMusic "victory.it", 2
		FOR i% = 0 TO 1
			ShowBattle 0
			FOR j% = 1 TO 3
				IF Party(j%).OnTeam AND Party(j%).Alive THEN
						ShowSprite Party(j%).BattleSet, Party(j%).x, Party(j%).y, 12 + i%, 32, 0
					ELSEIF Party(j%).OnTeam AND NOT Party(j%).Alive THEN
						ShowSprite Party(j%).BattleSet, Party(j%).x, Party(j%).y, 11, 32, 0
				END IF
			NEXT j%
			gspcopy VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), &HA000, 0
			gswait 20
		NEXT i%

		BattleAnime% = 13
		FOR j% = 1 TO 3
			Party(j).Attacking = False
		NEXT j%

		ShowBattle 0
		MessageBar "You were victorious!"
		WHILE INKEY$ <> CHR$(13): WEND

		ShowBattle 0
		MessageBar "The Party gained" + STR$(Enemy(1).Ex + Enemy(2).Ex + Enemy(3).Ex) + " Ex."
		WHILE INKEY$ <> CHR$(13): WEND

		FOR i% = 1 TO 3
			IF Party(i%).Status = 3 THEN
				Haste%(i%) = 0: Party(i%).Status = 1
			END IF

			IF Party(i%).OnTeam AND Party(i%).Alive THEN
				Party(i%).Ex = Party(i%).Ex + Enemy(1).Ex + Enemy(2).Ex + Enemy(3).Ex
				IF Party(i%).Ex > 999999 THEN Party(i%).Ex = 999999
				IF Party(i%).Ex >= Party(i%).NextLv AND Party(i%).Lev < 99 AND Party(i%).OnTeam THEN
					ShowBattle 0
					MessageBar RTRIM$(Party(i%).Title) + " gained a level!"
					WHILE INKEY$ <> CHR$(13): WEND
					FileNum% = FREEFILE
					OPEN "data\" + Party(i%).Bonus FOR INPUT AS #FileNum%
						INPUT #FileNum%, BaseEx%, ST%, DF%, Dex%, MS%, MDF%, Vit%
					CLOSE #FileNum%
					Party(i%).Lev = Party(i%).Lev + 1
					Party(i%).NextLv = BaseEx% * Party(i%).Lev ^ 2
					Party(i%).ST = Party(i%).ST + INT(RND * ST%)
					Party(i%).DF = Party(i%).DF + INT(RND * DF%)
					Party(i%).HPMax = Party(i%).HPMax + Party(i%).Vit
					Party(i%).HP = Party(i%).HP + Party(i%).Vit
					Party(i%).Dex = Party(i%).Dex + INT(RND * Dex%)
					Party(i%).MS = Party(i%).MS + INT(RND * MS%)
					Party(i%).MDF = Party(i%).MDF + INT(RND * MDF%)
					Party(i%).Vit = Party(i%).Vit + INT(RND * Vit%)
					FileNum% = FREEFILE
					OPEN "data\" + Party(i%).SpellData FOR BINARY AS #FileNum%
						GET #FileNum%, , NumSpells%
						FOR j% = 1 TO NumSpells
							GET #FileNum%, , SpellD
							IF Party(i%).Lev >= SpellD.Level AND RTRIM$(Party(i%).RunicEq) = RTRIM$(SpellD.Runic) OR RTRIM$(SpellD.Runic) = "None" THEN
								IF RTRIM$(Magic$(i%, SpellD.Subscript)) <> RTRIM$(SpellD.Title) THEN
									Magic$(i%, SpellD.Subscript) = RTRIM$(SpellD.Title)
									SPNeed%(i%, SpellD.Subscript) = SpellD.SP
									ShowBattle 0
									MessageBar RTRIM$(Party(i%).Title) + " learned " + RTRIM$(SpellD.Title)
									WHILE INKEY$ <> CHR$(13): WEND
								END IF
							END IF
						NEXT j%
					CLOSE #FileNum%
				END IF
			END IF
		NEXT i%

		ShowBattle 0
		MessageBar "Received" + STR$(Enemy(1).Cal + Enemy(2).Cal + Enemy(3).Cal) + " Cal."
		WHILE INKEY$ <> CHR$(13): WEND
		Cal& = Cal& + Enemy(1).Cal + Enemy(2).Cal + Enemy(3).Cal
		IF Cal& > 999999 THEN Cal& = 999999

		IF RTRIM$(Enemy(1).Item) <> "" THEN
			temp$ = RTRIM$(Enemy(1).Item)
			ItmGet% = INT(RND * 4) + 1
			IF ItmGet% = 1 THEN
				Result% = GiveItem(temp$)
				ShowBattle 0
				MessageBar "Received a " + RTRIM$(Enemy(1).Item)
				WHILE INKEY$ <> CHR$(13): WEND
			END IF
		END IF
	END IF

	Ran% = False: Won% = False

	IF NOT Lost% THEN
		DSRemoveMusic 2
		DSResumeMusic 1
	END IF

END SUB

SUB BattleMenu (Char%)

	CursorX% = 5: CursorY% = 140
	CharTurn% = Char%: ShowBattleMenu
	WHILE INKEY$ <> "": WEND
	DO
		SELECT CASE INKEY$
			CASE "s"
				Party(1).SP = Party(1).SPMAX
				Party(2).SP = Party(2).SPMAX
				Party(3).SP = Party(3).SPMAX
			CASE CHR$(0) + CHR$(72)
				DEF SEG = 0: POKE &H41A, PEEK(&H41C): DEF SEG 'clear keyboard buffer
				CursorY% = CursorY% - 10
				IF CursorY% = 130 THEN CursorY% = 140
				ShowBattleMenu
				DSPlaySample 1
			CASE CHR$(0) + CHR$(80)
				DEF SEG = 0: POKE &H41A, PEEK(&H41C): DEF SEG 'clear keyboard buffer
				CursorY% = CursorY% + 10
				IF CursorY% = 190 THEN CursorY% = 180
				ShowBattleMenu
				DSPlaySample 1
			CASE CHR$(13)
				IF CursorY% = 140 THEN
						Result% = SelectEnemy%
						IF NOT Result% THEN ShowBattleMenu
						IF Result% THEN
							CharDo$ = "Attack": PlayerAttack CharTurn%
							chosen% = True
						END IF
					ELSEIF CursorY% = 150 THEN
						SELECT CASE RTRIM$(Party(CharTurn%).Title)
							CASE "Nick"
								CursorX% = 5: CursorY% = 140
								ShowBigMenu 3
								Result% = SelectAction(3)
								IF NOT Result% THEN ShowBattleMenu
								IF Result% THEN CharDo$ = "Combo": PlayerAttack CharTurn%: chosen% = True
							CASE "Cerl"
								CharDo$ = "Void": PlayerAttack CharTurn%
								chosen% = True
							CASE "Dane"
								IF Party(CharTurn%).SP >= 30 THEN
									Result% = SelectEnemy%
									IF NOT Result% THEN ShowBattleMenu
									IF Result% THEN
										CharDo$ = "Psych": PlayerAttack CharTurn%
										chosen% = True
									END IF
								END IF
							CASE "Ariel"
								IF Party(CharTurn%).SP >= 50 THEN
									CharDo$ = "Speed": PlayerAttack CharTurn%
									chosen% = True
								END IF
						END SELECT
					ELSEIF CursorY% = 160 THEN
						CursorX% = 5: CursorY% = 140
						FirstItem% = 1: ShowBigMenu 2
						Result% = SelectAction(2)
						IF NOT Result% THEN ShowBattleMenu
						IF Result% THEN CharDo$ = "Magic": PlayerAttack CharTurn%: chosen% = True
					ELSEIF CursorY% = 170 THEN
						CursorX% = 5: CursorY% = 140
						FirstItem% = 1: ShowBigMenu 1
						Result% = SelectAction(1)
						IF NOT Result% THEN ShowBattleMenu
						IF Result% THEN CharDo$ = "Item": PlayerAttack CharTurn%: chosen% = True
					ELSEIF CursorY% = 180 THEN
						Ran% = True: chosen% = True
				END IF
		END SELECT
	LOOP UNTIL chosen%
	ShowBattle 0
	gspcopy VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), &HA000, 0
	CharTurn% = -1

END SUB

REM $STATIC
FUNCTION DamageCalc (AtkPow%, DefPow%, AtkEx%, DefEx%, Varience%)

	Damage% = AtkPow% / 2 + INT(RND * Varience%) - DefPow%
	IF Damage% <= 0 THEN Damage% = 1
	IF Damage% > 9999 THEN Damage% = 9999
	IF AtkEx% < DefEx% THEN
		Hit% = INT(RND * 10)
		IF Hit% = 1 THEN Damage% = 0
	END IF

	DamageCalc = Damage%

END FUNCTION

REM $DYNAMIC
SUB EnemyAttack (EnemyDo%)

	RANDOMIZE TIMER
	DIM SpellD AS SpellTYPE

	IF NumAtks%(EnemyDo%) = 0 OR Enemy(EnemyDo%).SP < 1 THEN Ec% = 1 ELSE Ec% = 3
	EnemyChoice% = INT(RND * Ec%) + 1
	AttackChar% = INT(RND * 3) + 1
	IF NOT Party(AttackChar%).Alive THEN
		IF Party(1).Alive THEN
				AttackChar% = 1
			ELSEIF Party(2).Alive THEN
				AttackChar% = 2
			ELSEIF Party(3).Alive THEN
				AttackChar% = 3
		END IF
	END IF

	SELECT CASE EnemyChoice%
		CASE 1
			Enemy(EnemyDo%).Attacking = True
			Damage% = DamageCalc(Enemy(EnemyDo%).ST, Party(AttackChar%).DF * Party(AttackChar%).ArmDF, Enemy(EnemyDo%).Dex, Party(AttackChar%).Dex, Enemy(EnemyDo%).ST / 2)
			'IF Damage% <= 0 THEN Damage% = 1
			'IF Damage% > 9999 THEN Damage% = 9999
			ShowBattle 0
			ShowSprite Enemy(EnemyDo%).Set, Enemy(EnemyDo%).x, Enemy(EnemyDo%).y, 2, 32, 0
			gspcopy VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), &HA000, 0
			gswait 50
			ShowBattle 0
			'Battle hit anime. for characters here
			ShowSprite Enemy(EnemyDo%).Set, Party(AttackChar%).x - 32, Party(AttackChar%).y, 3, 32, 0
			DSPlaySample 4
			IF Damage = 0 THEN
					gsprint 1, Party(AttackChar%).x, Party(AttackChar%).y, "Miss", 31
				ELSE
					gsprint 1, Party(AttackChar%).x, Party(AttackChar%).y, STR$(Damage%), 31
			END IF
			Party(AttackChar%).HP = Party(AttackChar%).HP - Damage%
			IF Party(AttackChar%).HP < 1 THEN Party(AttackChar%).HP = 0: Party(AttackChar%).Alive = False: Act%(AttackChar%) = 0
			gspcopy VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), &HA000, 0
			gswait 50

			Enemy(EnemyDo%).Attacking = False
		CASE 2, 3
			SpAtk% = INT(RND * NumAtks%(EnemyDo%)) + 1
			ShowBattle 0
			MessageBar RTRIM$(EneAtk$(EnemyDo%, SpAtk%)): gswait 60
			Enemy(EnemyDo%).Attacking = True
			FileNum% = FREEFILE
			OPEN "data\spells.mag" FOR BINARY AS #FileNum%
				GET #FileNum%, , NumSpells%
				FOR i% = 1 TO NumSpells%
					GET #FileNum%, , SpellD
					IF RTRIM$(SpellD.Title) = RTRIM$(EneAtk$(EnemyDo%, SpAtk%)) THEN EXIT FOR
				NEXT i%
			CLOSE #FileNum%

			FileNum% = FREEFILE
			OPEN "tiles\" + SpellD.Set FOR BINARY AS #FileNum%
				i% = (LOF(FileNum%)) / 2
				IF SpellD.Effect = 0 THEN NumTiles% = i% / 514
				IF SpellD.Effect = -1 THEN NumTiles% = i% / 2594
			CLOSE #FileNum%
			IF SpellD.Effect THEN TileSize% = 72
			IF NOT SpellD.Effect THEN TileSize% = 32

			SELECT CASE RTRIM$(SpellD.AtkType)
				CASE "Attack"
					FOR i% = 0 TO NumTiles% - 1
						ShowBattle 0
						ShowSprite Enemy(EnemyDo%).Set, Enemy(EnemyDo%).x, Enemy(EnemyDo%).y, 4, 32, 0
						IF NOT SpellD.Effect THEN
								ShowSprite SpellD.Set, Party(AttackChar%).x, Party(AttackChar%).y, i%, TileSize%, 0
							ELSE
								ShowSprite SpellD.Set, 160, 70, i%, TileSize%, 0
						END IF
						gspcopy VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), &HA000, 0
						gswait 30
					NEXT i%

					Damage% = Enemy(EnemyDo%).MS * SpellD.Power + INT(RND * Enemy(EnemyDo%).MS) - Party(1).MDF
					Damage2% = Enemy(EnemyDo%).MS * SpellD.Power + INT(RND * Enemy(EnemyDo%).MS) - Party(2).MDF
					Damage3% = Enemy(EnemyDo%).MS * SpellD.Power + INT(RND * Enemy(EnemyDo%).MS) - Party(3).MDF
					IF Damage% > 9999 THEN Damage% = 9999
					IF Damage% <= 0 THEN Damage% = 1
					IF Damage2% > 9999 THEN Damage2% = 9999
					IF Damage2% <= 0 THEN Damage2% = 1
					IF Damage3% > 9999 THEN Damage3% = 9999
					IF Damage3% <= 0 THEN Damage3% = 1
					ShowSprite Enemy(EnemyDo%).Set, Enemy(EnemyDo%).x, Enemy(EnemyDo%).y, 4, 32, 0
					IF NOT SpellD.Effect THEN
							gsprint 1, Party(AttackChar%).x, Party(AttackChar%).y, STR$(Damage%), 31
							gspcopy VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), &HA000, 0
							gswait 50
							Party(AttackChar%).HP = Party(AttackChar%).HP - Damage%
							Enemy(EnemyDo%).SP = Enemy(EnemyDo%).SP - SpellD.SP: ShowBattle 0
							IF Party(AttackChar%).HP < 1 THEN Party(AttackChar%).HP = 0: Party(AttackChar%).Alive = False
						ELSE
							IF Party(1).OnTeam AND Party(1).Alive THEN gsprint 1, Party(1).x, Party(1).y, STR$(Damage%), 31
							IF Party(2).OnTeam AND Party(2).Alive THEN gsprint 1, Party(2).x, Party(2).y, STR$(Damage2%), 31
							IF Party(3).OnTeam AND Party(3).Alive THEN gsprint 1, Party(3).x, Party(3).y, STR$(Damage3%), 31
							gspcopy VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), &HA000, 0
							gswait 50
							IF Party(1).OnTeam AND Party(1).Alive THEN Party(1).HP = Party(1).HP - Damage%
							IF Party(2).OnTeam AND Party(2).Alive THEN Party(2).HP = Party(2).HP - Damage2%
							IF Party(3).OnTeam AND Party(3).Alive THEN Party(3).HP = Party(3).HP - Damage3%
							Enemy(EnemyDo%).SP = Enemy(EnemyDo%).SP - SpellD.SP: ShowBattle 0
					END IF
					IF Party(1).HP < 1 THEN Party(1).HP = 0: Party(1).Alive = False
					IF Party(2).HP < 1 THEN Party(2).HP = 0: Party(2).Alive = False
					IF Party(3).HP < 1 THEN Party(3).HP = 0: Party(3).Alive = False
				CASE "Heal"
					UseOn% = INT(RND * NumEnemies%) + 1
					IF NOT Enemy(UseOn%).Alive THEN
						IF Enemy(1).Alive THEN
								UseOn% = 1
							ELSEIF Enemy(2).Alive THEN
								UseOn% = 2
							ELSEIF Enemy(3).Alive THEN
								UseOn% = 3
						END IF
					END IF
					FOR i% = 0 TO NumTiles% - 1
						ShowBattle 0
						ShowSprite Enemy(EnemyDo%).Set, Enemy(EnemyDo%).x, Enemy(EnemyDo%).y, 4, 32, 0
						IF NOT SpellD.Effect THEN
								ShowSprite SpellD.Set, Enemy(UseOn%).x, Enemy(UseOn%).y, i%, TileSize%, 0
							ELSE
								ShowSprite SpellD.Set, 70, 60, i%, TileSize%, 0
						END IF
						gspcopy VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), &HA000, 0
						gswait 30
					NEXT i%
					Enemy(EnemyDo%).SP = Enemy(EnemyDo%).SP - SpellD.SP
					Damage% = (Enemy(EnemyDo%).MS * SpellD.Power + (INT(RND * Enemy(EnemyDo%).MS))) / 2
					IF Damage% > 9999 THEN Damage% = 9999
					Enemy(UseOn%).HP = Enemy(UseOn%).HP + Damage%
					IF Enemy(UseOn%).HP > Enemy(UseOn%).HPMax THEN Enemy(UseOn%).HP = Enemy(UseOn%).HPMax
					ShowBattle 0
					ShowSprite Enemy(EnemyDo%).Set, Enemy(EnemyDo%).x, Enemy(EnemyDo%).y, 4, 32, 0
					gsprint 1, Enemy(UseOn%).x, Enemy(UseOn%).y, STR$(Damage%), 79
					gspcopy VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), &HA000, 0
					gswait 50
				CASE "Heal/Attack"
					FOR i% = 0 TO NumTiles% - 1
						ShowBattle 0
						ShowSprite Enemy(EnemyDo%).Set, Enemy(EnemyDo%).x, Enemy(EnemyDo%).y, 4, 32, 0
						IF NOT SpellD.Effect THEN
								ShowSprite SpellD.Set, Party(AttackChar%).x, Party(AttackChar%).y, i%, TileSize%, 0
							ELSE
								ShowSprite SpellD.Set, Party(2).x, Party(2).y, i%, TileSize%, 0
						END IF
						gspcopy VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), &HA000, 0
						gswait 30
					NEXT i%
					Damage% = Enemy(EnemyDo%).MS * SpellD.Power + INT(RND * Enemy(EnemyDo%).MS) - Party(1).MDF
					IF Damage% <= 0 THEN Damage% = 1
					IF Damage% > 9999 THEN Damage% = 9999
					ShowSprite Enemy(EnemyDo%).Set, Enemy(EnemyDo%).x, Enemy(EnemyDo%).y, 0, 32, 0
					gsprint 1, Party(AttackChar%).x, Party(AttackChar%).y, STR$(Damage%), 31
					gspcopy VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), &HA000, 0
					gswait 50
					Party(AttackChar%).HP = Party(AttackChar%).HP - Damage%
					Enemy(EnemyDo%).SP = Enemy(EnemyDo%).SP - SpellD.SP
					IF Party(AttackChar%).HP < 1 THEN Party(AttackChar%).HP = 0: Party(AttackChar%).Alive = False

					ShowBattle 0
					ShowSprite Enemy(EnemyDo%).Set, Enemy(EnemyDo%).x, Enemy(EnemyDo%).y, 0, 32, 0
					gsprint 1, Enemy(EnemyDo%).x, Enemy(EnemyDo%).y, STR$(INT(Damage% / 2)), 79
					gspcopy VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), &HA000, 0
					gswait 50
					Enemy(EnemyDo%).HP = Enemy(EnemyDo%).HP + (Damage% / 2)
					IF Enemy(EnemyDo%).HP > Enemy(EnemyDo%).HPMax THEN Enemy(EnemyDo%).HP = Enemy(EnemyDo%).HPMax
				CASE "Status"
					FOR i% = 0 TO NumTiles% - 1
						ShowBattle 0
						ShowSprite Enemy(EnemyDo%).Set, Enemy(EnemyDo%).x, Enemy(EnemyDo%).y, 4, 32, 0
						IF NOT SpellD.Effect THEN
								ShowSprite SpellD.Set, Party(AttackChar%).x, Party(AttackChar%).y, i%, TileSize%, 0
							ELSE
								ShowSprite SpellD.Set, Party(2).x, Party(2).y, i%, TileSize%, 0
						END IF
						gspcopy VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), &HA000, 0
						gswait 30
					NEXT i%
					Enemy(EnemyDo%).SP = Enemy(EnemyDo%).SP - SpellD.SP
					StatusChance% = INT(RND * 3) + 1
					IF StatusChance% = 1 THEN
						SELECT CASE RTRIM$(SpellD.Title)
							CASE "Poison"
								MessageBar RTRIM$(Party(AttackChar%).Title) + " is poisoned..."
								Party(AttackChar%).Status = 2
							CASE "Slow"
								Haste(AttackChar%) = -2
								MessageBar RTRIM$(Party(AttackChar%).Title) + " has gotten slower!"
								Party(AttackChar%).Status = 4
						END SELECT
					END IF
			END SELECT
			Enemy(EnemyDo%).Attacking = False
	END SELECT

END SUB

SUB LoadBkg (sFile$)

	RANDOMIZE TIMER

	DIM Ver AS INTEGER

	FileNum% = FREEFILE
	OPEN "bkgs\" + sFile$ FOR BINARY AS #FileNum%
		GET #FileNum%, , Ver
		GET #FileNum%, , Background

		GET #FileNum%, , BkgEnemies%

		REDIM Enemies(1 TO BkgEnemies%) AS STRING * 12
		FOR i% = 1 TO BkgEnemies%
				GET #FileNum%, , Enemies(i%)
		NEXT i%
	CLOSE #FileNum%

	IF INSTR(Background.sScript, ".scr") THEN
		Script "bkgs\" + Background.sScript
	END IF

	IF Party(1).Lev < 2 THEN NumEne% = 1 ELSE IF Party(1).Lev < 4 THEN NumEne% = 2 ELSE NumEne% = 3
	NumEnemies% = INT(RND * NumEne%) + 1
	IF BossFight% THEN NumEnemies% = BkgEnemies%
	FOR i% = 1 TO 3
		Enemy(i%).OnTeam = False: Enemy(i%).Cal = 0: Enemy(i%).Alive = False
		Enemy(i%).Ex = 0: Enemy(i%).Item = ""
	NEXT i%

	IF BossFight% THEN
			FOR i% = 1 TO BkgEnemies%
				LoadEnemy Enemies(i%), i%
			NEXT i%
		ELSE
			FOR i% = 1 TO NumEnemies%
				EnemyTYPE% = INT(RND * BkgEnemies%) + 1
				LoadEnemy Enemies(EnemyTYPE%), i%
			NEXT i%
	END IF

	FOR i% = 4 TO 6
		Act%(i%) = 0
	NEXT

	FOR i% = 1 TO 3
		Party(i%).Attacking = False
	NEXT i%
	Party(1).x = 180: Party(1).y = 120
	Party(2).x = 200: Party(2).y = 85
	Party(3).x = 210: Party(3).y = 50

	Enemy(1).x = 70: Enemy(1).y = 40
	Enemy(2).x = 90: Enemy(2).y = 70
	Enemy(3).x = 60: Enemy(3).y = 100

	BattleAnime% = 0

	IF RTRIM$(Enemy(1).Title) = "Cosmosis" THEN EnemyOffset% = 50 ELSE EnemyOffset% = 32

END SUB

SUB LoadEnemy (file$, Number%)

	FileNum% = FREEFILE
	OPEN "data\" + file$ FOR BINARY AS #FileNum%
		GET #FileNum%, , Enemy(Number%)
		GET #FileNum%, , NumAtks%(Number%)
		FOR i% = 1 TO NumAtks%(Number%)
			GET #FileNum%, , EneAtk$(Number%, i%)
		NEXT i%
	CLOSE #FileNum%
	Enemy(Number%).OnTeam = True
	Enemy(Number%).Alive = True

END SUB

SUB MessageBar (Phrase$)

	DialogBox True, 0, y, 319, y + 18, 56
	gsprint 1, Center(Phrase$), 4, Phrase$, 31
	gspcopy VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), &HA000, 0

END SUB

REM $STATIC
SUB PlayerAttack (CharGo%)

	RANDOMIZE TIMER
	DIM ItemD AS ItemTYPE
	DIM SpellD AS SpellTYPE
	DIM Change AS Vector
	DIM temp AS Vector

	SELECT CASE CharDo$
		CASE "Attack"
			TempAnime% = 2
			temp.x = Party(CharGo%).x
			temp.y = Party(CharGo%).y
			Change.x = (Enemy(ChoiceMade%).x - Party(CharGo%).x + EnemyOffset%) / 15
			Change.y = (Enemy(ChoiceMade%).y - Party(CharGo%).y) / 15

			Party(CharGo%).Attacking = True
			Damage% = DamageCalc((Party(CharGo%).ST * Party(CharGo%).WepAtk), Enemy(ChoiceMade%).DF, Party(CharGo%).Dex, Enemy(ChoiceMade%).Dex, Party(CharGo%).ST)
			'Damage% = ((Party(CharGo%).ST * Party(CharGo%).WepAtk) / 2) + (INT(RND * Party(CharGo%).ST)) - Enemy(ChoiceMade%).DF
			'IF Damage% <= 0 THEN Damage% = 1
			'IF Damage% > 9999 THEN Damage% = 9999

			FOR i% = 1 TO 15
				temp.x = temp.x + Change.x
				temp.y = temp.y + Change.y
				ShowBattle 0
				ShowSprite Party(CharGo%).BattleSet, temp.x, temp.y, TempAnime%, 32, 0
				gspcopy VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), &HA000, 0
				gswait 3
				IF TempAnime% = 2 THEN TempAnime% = 3 ELSE TempAnime% = 2
			NEXT i%

			FOR i% = 0 TO 1
				ShowBattle 0
				ShowSprite Party(CharGo%).BattleSet, Enemy(ChoiceMade%).x + EnemyOffset%, Enemy(ChoiceMade%).y, 4 + i%, 32, 0
				gspcopy VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), &HA000, 0
				gswait 9
			NEXT i%

			DSPlaySample 3
			ShowSprite Party(CharGo%).BattleSet, Enemy(ChoiceMade%).x + EnemyOffset%, Enemy(ChoiceMade%).y, 5, 32, 0
			IF Damage% = 0 THEN
					gsprint 1, Enemy(ChoiceMade%).x, Enemy(ChoiceMade%).y, "Miss", 31
				ELSE
					gsprint 1, Enemy(ChoiceMade%).x, Enemy(ChoiceMade%).y, STR$(Damage%), 31
			END IF
			Enemy(ChoiceMade%).HP = Enemy(ChoiceMade%).HP - Damage%
			IF Enemy(ChoiceMade%).HP < 1 THEN Enemy(ChoiceMade%).Alive = False: Act%(ChoiceMade% + 3) = 0
			gspcopy VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), &HA000, 0
			gswait 50
		CASE "Combo"
			IF CharItem$ = "Heal/Damage" AND Party(CharGo%).SP > 4 THEN
					TempAnime% = 14
					temp.x = Party(CharGo%).x
					temp.y = Party(CharGo%).y
					Change.x = (Enemy(ChoiceMade%).x - Party(CharGo%).x + EnemyOffset%) / 15
					Change.y = (Enemy(ChoiceMade%).y - Party(CharGo%).y) / 15

					ShowBattle 0
					MessageBar CharItem$: gswait 60
					Party(CharGo%).Attacking = True
					FOR i% = 0 TO 1
						ShowBattle 0
						ShowSprite Party(CharGo%).BattleSet, Party(CharGo%).x, Party(CharGo%).y, 8 + i%, 32, 0
						gspcopy VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), &HA000, 0
						gswait 20
					NEXT i%

					Damage% = 20 * (Party(CharGo%).Lev / 2)

					FOR i% = 1 TO 15
						temp.x = temp.x + Change.x
						temp.y = temp.y + Change.y
						ShowBattle 0
						ShowSprite Party(CharGo%).BattleSet, temp.x, temp.y, TempAnime%, 32, 0
						gspcopy VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), &HA000, 0
						gswait 3
						IF TempAnime% = 14 THEN TempAnime% = 15 ELSE TempAnime% = 14
					NEXT i%

					FOR i% = 0 TO 1
						ShowBattle 0
						ShowSprite Party(CharGo%).BattleSet, Enemy(ChoiceMade%).x + EnemyOffset%, Enemy(ChoiceMade%).y, 4 + i%, 32, 0
						gspcopy VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), &HA000, 0
						gswait 9
					NEXT i%

					ShowBattle 0
					ShowSprite Party(CharGo%).BattleSet, Enemy(ChoiceMade%).x + EnemyOffset%, Enemy(ChoiceMade%).y, 5, 32, 0
					Enemy(ChoiceMade%).HP = Enemy(ChoiceMade%).HP - Damage%
					IF Enemy(ChoiceMade%).HP < 1 THEN Enemy(ChoiceMade%).Alive = False: Act%(ChoiceMade% + 3) = 0
					gsprint 1, Enemy(ChoiceMade%).x, Enemy(ChoiceMade%).y, STR$(Damage%), 31
					gspcopy VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), &HA000, 0
					gswait 50: Party(CharGo%).Attacking = False
					ShowBattle 0
					gsprint 1, Party(CharGo%).x, Party(CharGo%).y, STR$(INT(Damage% / 2)), 79
					Party(CharGo%).HP = Party(CharGo%).HP + INT(Damage% / 2)
					IF Party(CharGo%).HP > Party(CharGo%).HPMax THEN Party(CharGo%).HP = Party(CharGo%).HPMax
					Party(CharGo%).SP = Party(CharGo%).SP - 5
					IF Party(CharGo%).SP < 1 THEN Party(CharGo%).SP = 0
					gspcopy VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), &HA000, 0
					gswait 50
				ELSEIF CharItem$ = "Magic Sword" AND Party(CharGo%).SP > 9 THEN
					FOR i% = 1 TO 3
						IF RTRIM$(Party(i%).Title) = "Cerl" THEN OtherChar% = i%
					NEXT i%
					TempAnime% = 14
					temp.x = Party(CharGo%).x
					temp.y = Party(CharGo%).y
					Change.x = (Enemy(ChoiceMade%).x - Party(CharGo%).x + EnemyOffset%) / 15
					Change.y = (Enemy(ChoiceMade%).y - Party(CharGo%).y) / 15

					ShowBattle 0
					MessageBar CharItem$: gswait 60
					Party(CharGo%).Attacking = True
					Party(OtherChar%).Attacking = True
					Damage% = Party(CharGo%).Lev * Party(OtherChar%).Lev - Enemy(ChoiceMade%).DF
					IF Damage% < 0 THEN Damage% = 1
					IF Damage% > 9999 THEN Damage% = 9999
					FOR i% = 0 TO 1
						ShowBattle 0
						ShowSprite Party(CharGo%).BattleSet, Party(CharGo%).x, Party(CharGo%).y, 8 + i%, 32, 0
						ShowSprite Party(OtherChar%).BattleSet, Party(OtherChar%).x, Party(OtherChar%).y, 14, 32, 0
						gspcopy VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), &HA000, 0
						gswait 25
					NEXT i%

					FOR i% = 1 TO 15
						temp.x = temp.x + Change.x
						temp.y = temp.y + Change.y
						ShowBattle 0
						ShowSprite Party(OtherChar%).BattleSet, Party(OtherChar%).x, Party(OtherChar%).y, 14, 32, 0
						ShowSprite Party(CharGo%).BattleSet, temp.x, temp.y, TempAnime%, 32, 0
						gspcopy VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), &HA000, 0
						gswait 3
						IF TempAnime% = 14 THEN TempAnime% = 15 ELSE TempAnime% = 14
					NEXT i%

					FOR i% = 0 TO 1
						ShowBattle 0
						ShowSprite Party(OtherChar%).BattleSet, Party(OtherChar%).x, Party(OtherChar%).y, 8 + i%, 32, 0
						ShowSprite Party(CharGo%).BattleSet, Enemy(ChoiceMade%).x + EnemyOffset%, Enemy(ChoiceMade%).y, 4 + i%, 32, 0
						ShowSprite "fire.set", Enemy(ChoiceMade%).x, Enemy(ChoiceMade%).y, i%, 32, 0
						Enemy(ChoiceMade%).HP = Enemy(ChoiceMade%).HP - Damage%
						gsprint 1, Enemy(ChoiceMade%).x, Enemy(ChoiceMade%).y, STR$(Damage%), 31
						gspcopy VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), &HA000, 0
						IF Enemy(ChoiceMade%).HP < 1 THEN Enemy(ChoiceMade%).Alive = False: Act%(ChoiceMade% + 3) = 0: EXIT FOR
						Damage% = Damage% + Party(2).MS
						IF Damage% > 9999 THEN Damage% = 9999
						gswait 50
					NEXT i%
					Party(CharGo%).SP = Party(CharGo%).SP - 10
					IF Party(CharGo%).SP < 1 THEN Party(CharGo%).SP = 0
					Party(CharGo%).Attacking = False
					Party(OtherChar%).Attacking = False
				ELSEIF CharItem$ = "Fast Break" AND Party(CharGo%).SP > 9 THEN
					Damage% = (Enemy(ChoiceMade%).HP * .3) + (Party(CharGo%).ST * INT(RND * 10) + 1)
					IF Damage% < 0 THEN Damage% = 1
					IF Damage% > 9999 THEN Damage% = 9999
					Enemy(ChoiceMade%).HP = Enemy(ChoiceMade%).HP - Damage%
					ShowBattle 0
					gsprint 1, Enemy(ChoiceMade%).x, Enemy(ChoiceMade%).y, STR$(Damage%), 31
					gspcopy VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), &HA000, 0
					gswait 50
					IF Enemy(ChoiceMade%).HP < 1 THEN Enemy(ChoiceMade%).Alive = False: Act%(ChoiceMade% + 3) = 0
					Party(CharGo%).SP = Party(CharGo%).SP - 10
					IF Party(CharGo%).SP < 1 THEN Party(CharGo%).SP = 0
				ELSEIF CharItem$ = "Holy Cross" AND Party(CharGo%).SP > 9 THEN
					FOR i% = 1 TO 3
						IF RTRIM$(Party(i%).Title) = "Dane" THEN OtherChar% = i%
					NEXT i%
					Damage% = ((Party(CharGo%).ST * Party(OtherChar%).ST / 2) + INT(RND * Party(CharGo%).ST)) - Enemy(ChoiceMade%).DF
					IF Damage% < 0 THEN Damage% = 1
					IF Damage% > 9999 THEN Damage% = 9999
					Enemy(ChoiceMade%).HP = Enemy(ChoiceMade%).HP - Damage%
					ShowBattle 0
					gsprint 1, Enemy(ChoiceMade%).x, Enemy(ChoiceMade%).y, STR$(Damage%), 31
					gspcopy VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), &HA000, 0
					gswait 50
					IF Enemy(ChoiceMade%).HP < 1 THEN Enemy(ChoiceMade%).Alive = False: Act%(ChoiceMade% + 3) = 0
					Party(CharGo%).SP = Party(CharGo%).SP - 10
					IF Party(CharGo%).SP < 1 THEN Party(CharGo%).SP = 0
				ELSEIF CharItem$ = "Stars of Fate" THEN
					StarsofFate% = True
					TempAnime% = 17
					NumTiles% = 6
					FOR i% = 1 TO 3
						IF RTRIM$(Party(i%).Title) = "Cerl" THEN OtherChar% = i%
					NEXT i%
					Party(CharGo%).Attacking = True
					Party(OtherChar%).Attacking = True
					FOR i% = 1 TO 3
						Party(i%).SP = 0
						Party(i%).HP = Party(i%).HPMax
					NEXT i%

					FadePal 1
						ShowBattle 0
						ShowSprite Party(CharGo%).BattleSet, Party(CharGo%).x, Party(CharGo%).y, 16, 32, 0
						ShowSprite Party(CharGo%).BattleSet, Party(OtherChar%).x, Party(OtherChar%).y, 16, 32, 0
						ShowSprite "Starfate.set", 70, 60, i%, 72, 0
						gspcopy VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), &HA000, 0
					FadePal 0
					gswait 50
					Damage% = 9999

					FOR i% = 0 TO NumTiles% - 1
						ShowBattle 0
						ShowSprite Party(CharGo%).BattleSet, Party(CharGo%).x, Party(CharGo%).y, TempAnime%, 32, 0
						ShowSprite Party(CharGo%).BattleSet, Party(OtherChar%).x, Party(OtherChar%).y, TempAnime%, 32, 0
						ShowSprite "Starfate.set", 70, 60, i%, 72, 0
						gsprint 1, Enemy(ChoiceMade%).x, Enemy(ChoiceMade%).y, STR$(Damage%), 31
						Enemy(ChoiceMade%).HP = Enemy(ChoiceMade%).HP - Damage%
						gspcopy VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), &HA000, 0
						gswait 30
						IF TempAnime% = 17 THEN TempAnime% = 18 ELSE TempAnime% = 17
					NEXT i%

					IF Enemy(ChoiceMade%).HP < 1 THEN Enemy(ChoiceMade%).Alive = False: Act%(ChoiceMade% + 3) = 0
					Party(CharGo%).Attacking = False
					Party(OtherChar%).Attacking = False
			END IF
		CASE "Void"
			FOR i% = 1 TO 3
				IF RTRIM$(Party(i%).Title) = "Cerl" THEN j% = i%
			NEXT i%

			FOR i% = 1 TO 3
				IF i% <> j% AND Party(i%).OnTeam THEN num% = num% + 1
			NEXT i%
			Damage% = INT(Party(CharGo%).SP / num%)
			Party(CharGo%).SP = 0
			FOR i% = 1 TO 3
				IF i% <> j% AND Party(i%).OnTeam THEN
					ShowBattle 0
					Party(i%).SP = Party(i%).SP + Damage%
					IF Party(i%).SP > Party(i%).SPMAX THEN Party(i%).SP = Party(i%).SPMAX
					gsprint 1, Party(i%).x, Party(i%).y, STR$(Damage%), 79
					gspcopy VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), &HA000, 0
					gswait 50
				END IF
			NEXT i%
		CASE "Psych"
			MessageBar CharDo$: gswait 60
			Party(CharGo%).Attacking = True
			Damage% = INT(RND * Party(CharGo%).HP) + 1
			FOR i% = 0 TO 2
				ShowBattle 0
				ShowSprite Party(CharGo%).BattleSet, Party(CharGo%).x, Party(CharGo%).y, 6, 32, 1
				ShowSprite "Psych.set", Enemy(ChoiceMade%).x, Enemy(ChoiceMade%).y, i%, 32, 0
				gspcopy VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), &HA000, 0
				gswait 30
			NEXT i%
			ShowBattle 0
			ShowSprite Party(CharGo%).BattleSet, Party(CharGo%).x, Party(CharGo%).y, 6, 32, 0
			gsprint 1, Enemy(ChoiceMade%).x, Enemy(ChoiceMade%).y, STR$(Damage%), 31
			gspcopy VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), &HA000, 0
			gswait 50
			Enemy(ChoiceMade%).HP = Enemy(ChoiceMade%).HP - Damage%
			Party(CharGo%).SP = Party(CharGo%).SP - 30: ShowBattle 0
			IF Enemy(ChoiceMade%).HP < 1 THEN Enemy(ChoiceMade%).Alive = False: Act%(ChoiceMade% + 3) = 0
		CASE "Speed"
			MessageBar CharDo$: gswait 60
			FOR i% = 0 TO 3
				ShowBattle 0
				FOR j% = 1 TO 3
					IF Party(j%).OnTeam AND Party(j%).Alive THEN
						ShowSprite "haste.set", Party(j%).x, Party(j%).y, i%, 32, 0
					END IF
				NEXT j%
				gspcopy VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), &HA000, 0
				gswait 30
			NEXT i%
			FOR i% = 1 TO 3
				Party(i%).Status = 3
				Haste(i%) = 10
			NEXT i%
			Party(CharGo%).SP = Party(CharGo%).SP - 30
			MessageBar "The Party has gotten way faster!"
			gswait 60

		CASE "Magic"
			TempAnime% = 8
			ShowBattle 0
			MessageBar CharMagic$: gswait 60
			Party(CharGo%).Attacking = True
			FileNum% = FREEFILE
			OPEN "data\spells.mag" FOR BINARY AS #FileNum%
				GET #FileNum%, , NumSpells%
				FOR i% = 1 TO NumSpells
					GET #FileNum%, , SpellD
					IF RTRIM$(SpellD.Title) = CharMagic$ THEN EXIT FOR
				NEXT i%
			CLOSE #FileNum%

			FileNum% = FREEFILE
			OPEN "tiles\" + SpellD.Set FOR BINARY AS #FileNum%
				i% = (LOF(FileNum%)) / 2
				IF SpellD.Effect = 0 THEN NumTiles% = i% / 514
				IF SpellD.Effect = -1 THEN NumTiles% = i% / 2594
			CLOSE #FileNum%
			IF SpellD.Effect THEN TileSize% = 72
			IF NOT SpellD.Effect THEN TileSize% = 32

			SELECT CASE RTRIM$(SpellD.AtkType)
				CASE "Attack"
					FOR i% = 0 TO NumTiles% - 1
						ShowBattle 0
						ShowSprite Party(CharGo%).BattleSet, Party(CharGo%).x, Party(CharGo%).y, TempAnime%, 32, 0
						IF NOT SpellD.Effect THEN
								ShowSprite SpellD.Set, Enemy(ChoiceMade%).x, Enemy(ChoiceMade%).y, i%, TileSize%, 0
							ELSE
								ShowSprite SpellD.Set, 70, 60, i%, TileSize%, 0
						END IF
						gspcopy VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), &HA000, 0
						gswait 30
						IF TempAnime% = 8 THEN TempAnime% = 9 ELSE TempAnime% = 8
					NEXT i%
					Damage% = Party(CharGo%).MS * SpellD.Power + INT(RND * Party(CharGo%).MS) - Enemy(ChoiceMade%).MDF
					Damage2% = Damage%: Damage3% = Damage%
					IF NOT SpellD.Effect THEN
							IF RTRIM$(Enemy(ChoiceMade%).Weak) = RTRIM$(SpellD.Element) THEN Damage% = INT(Damage% * 1.5)
							IF RTRIM$(Enemy(ChoiceMade%).Strong) = RTRIM$(SpellD.Element) THEN Damage% = INT(Damage% / 1.5)
							IF Damage% <= 0 THEN Damage% = 1
							IF Damage% > 9999 THEN Damage% = 9999
							ShowSprite Party(CharGo%).BattleSet, Party(CharGo%).x, Party(CharGo%).y, 8, 32, 0
							gsprint 1, Enemy(ChoiceMade%).x, Enemy(ChoiceMade%).y, STR$(Damage%), 31
							gspcopy VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), &HA000, 0
							gswait 50
							Enemy(ChoiceMade%).HP = Enemy(ChoiceMade%).HP - Damage%
							Party(CharGo%).SP = Party(CharGo%).SP - SpellD.SP: ShowBattle 0
						ELSE
							IF RTRIM$(Enemy(1).Weak) = RTRIM$(SpellD.Element) THEN Damage% = INT(Damage% * 1.5)
							IF RTRIM$(Enemy(1).Strong) = RTRIM$(SpellD.Element) THEN Damage% = INT(Damage% / 1.5)
							IF RTRIM$(Enemy(2).Weak) = RTRIM$(SpellD.Element) THEN Damage2% = INT(Damage2% * 1.5)
							IF RTRIM$(Enemy(2).Strong) = RTRIM$(SpellD.Element) THEN Damage2% = INT(Damage2% / 1.5)
							IF RTRIM$(Enemy(3).Weak) = RTRIM$(SpellD.Element) THEN Damage3% = INT(Damage3% * 1.5)
							IF RTRIM$(Enemy(3).Strong) = RTRIM$(SpellD.Element) THEN Damage3% = INT(Damage3% / 1.5)
							IF Damage% <= 0 THEN Damage% = 1
							IF Damage% > 9999 THEN Damage% = 9999
							IF Damage2% <= 0 THEN Damage2% = 1
							IF Damage% > 9999 THEN Damage% = 9999
							IF Damage3% <= 0 THEN Damage3% = 1
							IF Damage3% > 9999 THEN Damage3% = 9999
							ShowSprite Party(CharGo%).BattleSet, Party(CharGo%).x, Party(CharGo%).y, 8, 32, 0
							IF Enemy(1).Alive THEN gsprint 1, Enemy(1).x, Enemy(1).y, STR$(Damage%), 31
							IF Enemy(2).Alive THEN gsprint 1, Enemy(2).x, Enemy(2).y, STR$(Damage2%), 31
							IF Enemy(3).Alive THEN gsprint 1, Enemy(3).x, Enemy(3).y, STR$(Damage3%), 31
							gspcopy VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), &HA000, 0
							gswait 50
							IF Enemy(1).Alive THEN Enemy(1).HP = Enemy(1).HP - Damage%
							IF Enemy(2).Alive THEN Enemy(2).HP = Enemy(2).HP - Damage2%
							IF Enemy(3).Alive THEN Enemy(3).HP = Enemy(3).HP - Damage3%
							Party(CharGo%).SP = Party(CharGo%).SP - SpellD.SP: ShowBattle 0
					END IF
					IF Enemy(1).HP < 1 THEN Enemy(1).Alive = False: Act%(4) = 0
					IF Enemy(2).HP < 1 THEN Enemy(2).Alive = False: Act%(5) = 0
					IF Enemy(3).HP < 1 THEN Enemy(3).Alive = False: Act%(6) = 0
				CASE "Heal"
					FOR i% = 0 TO NumTiles% - 1
						ShowBattle 0
						ShowSprite Party(CharGo%).BattleSet, Party(CharGo%).x, Party(CharGo%).y, TempAnime%, 32, 0
						IF NOT SpellD.Effect THEN
								ShowSprite SpellD.Set, Party(UseOn%).x, Party(UseOn%).y, i%, TileSize%, 0
							ELSE
								ShowSprite SpellD.Set, 70, 60, i%, TileSize%, 0
						END IF
						gspcopy VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), &HA000, 0
						gswait 30
						IF TempAnime% = 8 THEN TempAnime% = 9 ELSE TempAnime% = 8
					NEXT i%
					Damage% = Party(CharGo%).MS * SpellD.Power + INT(RND * Party(CharGo%).MS)
					IF NOT SpellD.Effect THEN
							ShowBattle 0
							ShowSprite Party(CharGo%).BattleSet, Party(CharGo%).x, Party(CharGo%).y, 8, 32, 0
							gsprint 1, Party(UseOn%).x, Party(UseOn%).y, STR$(Damage%), 79
							gspcopy VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), &HA000, 0
							gswait 50
							Party(UseOn%).HP = Party(UseOn%).HP + Damage%
							IF Party(UseOn%).HP > Party(UseOn%).HPMax THEN Party(UseOn%).HP = Party(UseOn%).HPMax
							Party(CharGo%).SP = Party(CharGo%).SP - SpellD.SP: ShowBattle 0
						ELSE
							ShowBattle 0
							ShowSprite Party(CharGo%).BattleSet, Party(CharGo%).x, Party(CharGo%).y, 8, 32, 0
							IF Party(1).Alive THEN gsprint 1, Party(1).x, Party(1).y, STR$(Damage%), 79
							IF Party(2).Alive THEN gsprint 1, Party(2).x, Party(2).y, STR$(Damage%), 79
							IF Party(3).Alive THEN gsprint 1, Party(3).x, Party(3).y, STR$(Damage%), 79
							gspcopy VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), &HA000, 0
							gswait 50
							IF Party(1).Alive THEN Party(1).HP = Party(1).HP + Damage%
							IF Party(2).Alive THEN Party(2).HP = Party(2).HP + Damage%
							IF Party(3).Alive THEN Party(3).HP = Party(3).HP + Damage%
							Party(CharGo%).SP = Party(CharGo%).SP - SpellD.SP: ShowBattle 0
					END IF
					IF Party(1).HP > Party(1).HPMax THEN Party(1).HP = Party(1).HPMax
					IF Party(2).HP > Party(2).HPMax THEN Party(2).HP = Party(2).HPMax
					IF Party(3).HP > Party(3).HPMax THEN Party(3).HP = Party(3).HPMax
				CASE "Status"
					FOR i% = 0 TO NumTiles% - 1
						ShowBattle 0
						ShowSprite Party(CharGo%).BattleSet, Party(CharGo%).x, Party(CharGo%).y, TempAnime%, 32, 0
						ShowSprite SpellD.Set, Party(UseOn%).x, Party(UseOn%).y, i%, TileSize%, 0
						gspcopy VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), &HA000, 0
						gswait 30
						IF TempAnime% = 8 THEN TempAnime% = 9 ELSE TempAnime% = 8
					NEXT i%
					Party(CharGo%).SP = Party(CharGo%).SP - SpellD.SP
					StatusChance% = INT(RND * 3) + 1
					IF StatusChance% = 1 THEN
						SELECT CASE RTRIM$(SpellD.Title)
							CASE "Haste"
								Party(UseOn%).Status = 3
								Haste(UseOn%) = 5
								MessageBar RTRIM$(Party(UseOn%).Title) + " has gotten faster!"
								gswait 60
						END SELECT
					END IF
				CASE "Heal/Attack"
					FOR i% = 0 TO NumTiles% - 1
						ShowBattle 0
						ShowSprite Party(CharGo%).BattleSet, Party(CharGo%).x, Party(CharGo%).y, TempAnime%, 32, 0
						ShowSprite SpellD.Set, Enemy(ChoiceMade%).x, Enemy(ChoiceMade%).y, i%, TileSize%, 0
						gspcopy VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), &HA000, 0
						gswait 30
						IF TempAnime% = 8 THEN TempAnime% = 9 ELSE TempAnime% = 8
					NEXT i%
					Damage% = Party(CharGo%).MS * SpellD.Power + INT(RND * Party(CharGo%).MS) - Enemy(ChoiceMade%).MDF
					IF RTRIM$(Enemy(ChoiceMade%).Weak) = RTRIM$(SpellD.Element) THEN Damage% = INT(Damage% * 1.5)
					IF RTRIM$(Enemy(ChoiceMade%).Strong) = RTRIM$(SpellD.Element) THEN Damage% = INT(Damage% / 1.5)
					IF Damage% <= 0 THEN Damage% = 1
					IF Damage% > 9999 THEN Damage% = 9999
					ShowSprite Party(CharGo%).BattleSet, Party(CharGo%).x, Party(CharGo%).y, 8, 32, 0
					gsprint 1, Enemy(ChoiceMade%).x, Enemy(ChoiceMade%).y, STR$(Damage%), 31
					gspcopy VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), &HA000, 0
					gswait 50
					IF CharMagic$ = "Drain" THEN Enemy(ChoiceMade%).HP = Enemy(ChoiceMade%).HP - Damage%
					IF CharMagic$ = "Sap" THEN Enemy(ChoiceMade%).SP = Enemy(ChoiceMade%).SP - Damage%
					Party(CharGo%).SP = Party(CharGo%).SP - SpellD.SP: ShowBattle 0
					IF Enemy(1).HP < 1 THEN Enemy(1).Alive = False: Act%(4) = 0

					ShowBattle 0
					ShowSprite Party(CharGo%).BattleSet, Party(CharGo%).x, Party(CharGo%).y, 0, 32, 0
					gsprint 1, Party(CharGo%).x, Party(CharGo%).y, STR$(INT(Damage% / 2)), 79
					gspcopy VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), &HA000, 0
					gswait 50
					IF CharMagic$ = "Drain" THEN
							Party(CharGo%).HP = Party(CharGo%).HP + (Damage% / 2)
							IF Party(CharGo%).HP > Party(CharGo%).HPMax THEN Party(CharGo%).HP = Party(CharGo%).HPMax
						ELSEIF CharMagic$ = "Sap" THEN
							Party(CharGo%).SP = Party(CharGo%).SP + (Damage% / 2)
							IF Party(CharGo%).SP > Party(CharGo%).SPMAX THEN Party(CharGo%).SP = Party(CharGo%).SPMAX
					END IF
			END SELECT
		CASE "Item"
			ShowBattle 0
			MessageBar CharItem$: gswait 60
			Party(CharGo%).Attacking = True

			FOR i% = 0 TO 1
				ShowBattle 0
				ShowSprite Party(CharGo%).BattleSet, Party(CharGo%).x, Party(CharGo%).y, 6 + i%, 32, 0
				gspcopy VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), &HA000, 0
				gswait 20
			NEXT i%

			ItemQuery Item(ItemPage%, FirstItem%).ItemID, ItemD
			SELECT CASE RTRIM$(ItemD.ItemTYPE)
				CASE "Heal"
					Party(UseOn%).HP = Party(UseOn%).HP + ItemD.ItemPower
				CASE "SP Heal"
					Party(UseOn%).SP = Party(UseOn%).SP + ItemD.ItemPower
				CASE "Heal/SP"
					Party(UseOn%).HP = Party(UseOn%).HP + ItemD.ItemPower
					Party(UseOn%).SP = Party(UseOn%).SP + ItemD.ItemPower
				CASE "Status"
					SELECT CASE RTRIM$(ItemD.Title)
						CASE "Antidote"
							IF Party(UseOn%).Status = 2 THEN Party(UseOn%).Status = 1
					END SELECT
			END SELECT
			IF Party(UseOn%).HP > Party(UseOn%).HPMax THEN Party(UseOn%).HP = Party(UseOn%).HPMax
			IF Party(UseOn%).SP > Party(UseOn%).SPMAX THEN Party(UseOn%).SP = Party(UseOn%).SPMAX
			ShowBattle 0
			ShowSprite Party(CharGo%).BattleSet, Party(CharGo%).x, Party(CharGo%).y, 7, 32, 0
			SELECT CASE RTRIM$(ItemD.ItemTYPE)
				CASE "Heal/SP", "SP Heal", "Heal"
					gsprint 1, Party(UseOn%).x, Party(UseOn%).y, STR$(ItemD.ItemPower), 79
					gspcopy VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), &HA000, 0
					gswait 50
				CASE "Status"
					MessageBar RTRIM$(Party(UseOn%).Title) + " is cured!"
					gswait 100
			END SELECT
			Item(ItemPage%, FirstItem%).Quantity = Item(ItemPage%, FirstItem%).Quantity - 1
			IF Item(ItemPage%, FirstItem%).Quantity = 0 THEN Item(ItemPage%, FirstItem%).ItemID = 0
	END SELECT
	Party(CharGo%).Attacking = False

END SUB

FUNCTION SelectAction (Action%)

	DIM SpellD AS SpellTYPE
	DIM ItemD AS ItemTYPE
	IF Action% = 1 THEN
		ItemOn% = 1
		DO
			ItmChosen% = False
			SELECT CASE INKEY$
				CASE CHR$(0) + CHR$(72)
					DEF SEG = 0: POKE &H41A, PEEK(&H41C): DEF SEG 'clear keyboard buffer
					CursorY% = CursorY% - 10
					IF CursorY% = 130 THEN
						CursorY% = 140
						IF FirstItem% - 1 <> 0 THEN FirstItem% = FirstItem% - 1
					END IF
					IF ItemOn% - 1 <> 0 THEN ItemOn% = ItemOn% - 1
					ShowBigMenu 1
					DSPlaySample 1
				CASE CHR$(0) + CHR$(80)
					DEF SEG = 0: POKE &H41A, PEEK(&H41C): DEF SEG 'clear keyboard buffer
					CursorY% = CursorY% + 10
					IF CursorY% = 190 THEN
						CursorY% = 180
						IF FirstItem% + 1 <> 14 THEN FirstItem% = FirstItem% + 1
					END IF
					IF ItemOn% + 1 <> 18 THEN ItemOn% = ItemOn% + 1
					ShowBigMenu 1
					DSPlaySample 1
				CASE CHR$(13)
					CharItem$ = ""
					ItemQuery Item(ItemPage%, ItemOn%).ItemID, ItemD
					IF Item(ItemPage%, ItemOn%).Quantity <> 0 THEN CharItem$ = RTRIM$(ItemD.Title)
					IF CharItem$ <> "" THEN
						SELECT CASE RTRIM$(ItemD.ItemTYPE)
							CASE "Runic", "Armor", "Key", "Stat"
								'Do nothing
							CASE ELSE
								Result% = SelectPlayer%
								IF NOT Result% THEN FirstItem% = 1: ItemOn% = 1: ShowBigMenu 1
								IF Result% THEN
									ItmChosen% = True: SelectAction% = True
									FirstItem% = ItemOn%
								END IF
						END SELECT
					END IF
				CASE CHR$(0) + CHR$(83)
					SelectAction% = False: ItmChosen% = True
					CursorX% = 5: CursorY% = 140: ShowBattleMenu
			END SELECT
		LOOP UNTIL ItmChosen%
	END IF

	IF Action% = 2 THEN
		SpellOn% = 1
		DO
			SpChosen% = False
			SELECT CASE INKEY$
				CASE CHR$(0) + CHR$(72)
					DEF SEG = 0: POKE &H41A, PEEK(&H41C): DEF SEG 'clear keyboard buffer
					CursorY% = CursorY% - 10
					IF CursorY% = 130 THEN
						CursorY% = 140
						IF FirstItem% - 1 <> 0 THEN FirstItem% = FirstItem% - 1
					END IF
					IF SpellOn% - 1 <> 0 THEN SpellOn% = SpellOn% - 1
					ShowBigMenu 2
					DSPlaySample 1
				CASE CHR$(0) + CHR$(80)
					DEF SEG = 0: POKE &H41A, PEEK(&H41C): DEF SEG 'clear keyboard buffer
					CursorY% = CursorY% + 10
					IF CursorY% = 190 THEN
						CursorY% = 180
						IF FirstItem% + 1 <> 15 THEN FirstItem% = FirstItem% + 1
					END IF
					IF SpellOn% + 1 <> 19 THEN SpellOn% = SpellOn% + 1
					ShowBigMenu 2
					DSPlaySample 1
				CASE CHR$(13)
					CharMagic$ = ""
					IF SPNeed%(CharTurn%, SpellOn%) <> 0 THEN CharMagic$ = RTRIM$(Magic$(CharTurn, SpellOn%))
					IF CharMagic$ <> "" AND Party(CharTurn%).SP >= SPNeed%(CharTurn%, SpellOn%) THEN
						FileNum% = FREEFILE
						OPEN "data\spells.mag" FOR BINARY AS #FileNum%
							GET #FileNum%, , NumSpells%
							FOR i% = 1 TO NumSpells%
								GET #FileNum%, , SpellD
								IF RTRIM$(SpellD.Title) = CharMagic$ THEN EXIT FOR
							NEXT i%
						CLOSE #FileNum%
						SELECT CASE RTRIM$(SpellD.AtkType)
							CASE "Heal", "Status"
								Result% = SelectPlayer%
							CASE "Attack", "Heal/Attack"
								Result% = SelectEnemy%
						END SELECT
						IF NOT Result% THEN FirstItem% = 1: SpellOn% = 1: ShowBigMenu 2
						IF Result% THEN
							SpChosen% = True: SelectAction% = True
							FirstItem% = SpellOn%
						END IF
					END IF
					IF Party(CharTurn%).SP < SPNeed%(CharTurn%, SpellOn%) THEN
						ShowBattle 0
						MessageBar "Your lacking the spirit needed..."
						gswait 30
						ShowBigMenu 2
					END IF
				CASE CHR$(0) + CHR$(83)
					SelectAction% = False: SpChosen% = True
					CursorX% = 5: CursorY% = 140: ShowBattleMenu
			END SELECT
		LOOP UNTIL SpChosen%
	END IF

	IF Action% = 3 THEN
		DO
			CboChosen% = False
			SELECT CASE INKEY$
				CASE CHR$(0) + CHR$(72)
					DEF SEG = 0: POKE &H41A, PEEK(&H41C): DEF SEG 'clear keyboard buffer
					CursorY% = CursorY% - 10
					IF CursorY% = 130 THEN CursorY% = 140
					ShowBigMenu 3
					DSPlaySample 1
				CASE CHR$(0) + CHR$(80)
					DEF SEG = 0: POKE &H41A, PEEK(&H41C): DEF SEG 'clear keyboard buffer
					CursorY% = CursorY% + 10
					IF CursorY% = 190 THEN CursorY% = 180
					ShowBigMenu 3
					DSPlaySample 1
				CASE CHR$(13)
					CharItem$ = ""
					IF CursorY% = 140 THEN
							CharItem$ = "Heal/Damage"
						ELSEIF CursorY% = 150 THEN
							FOR i% = 1 TO 3
								IF RTRIM$(Party(i%).Title) = "Cerl" THEN Char% = i%: EXIT FOR ELSE Char% = 0
							NEXT i%
							IF Char% <> 0 AND Party(CharTurn%).Alive THEN
								IF Party(Char%).Lev > 9 AND Party(Char%).Alive THEN
									CharItem$ = "Magic Sword"
								END IF
							END IF
						ELSEIF CursorY% = 160 THEN
							FOR i% = 1 TO 3
								IF RTRIM$(Party(i%).Title) = "Ariel" THEN Char% = i%: EXIT FOR ELSE Char% = 0
							NEXT i%
							IF Char% <> 0 AND Party(CharTurn%).Alive THEN
								IF Party(Char).Lev > 24 AND Party(Char%).Alive THEN
									CharItem$ = "Fast Break"
								END IF
							END IF
						ELSEIF CursorY% = 170 THEN
							FOR i% = 1 TO 3
								IF RTRIM$(Party(i%).Title) = "Dane" THEN Char% = i%: EXIT FOR ELSE Char% = 0
							NEXT i%
							IF Char% <> 0 AND Party(CharTurn%).Alive THEN
								IF Party(Char).Lev > 39 AND Party(Char%).Alive THEN
									CharItem$ = "Holy Cross"
								END IF
							END IF
						ELSEIF CursorY% = 180 THEN
							IF RTRIM$(Enemy(1).Title) = "Cosmosis" AND NOT StarsofFate% THEN
								FOR i% = 1 TO 3
									IF RTRIM$(Party(i%).Title) = "Cerl" THEN Char% = i%: EXIT FOR ELSE Char% = 0
								NEXT i%
								IF Char% <> 0 AND Party(CharTurn%).Alive THEN
									IF Party(Char%).Alive THEN
										CharItem$ = "Stars of Fate"
									END IF
								END IF
							END IF
					END IF
					IF CharItem$ <> "" THEN
						Result% = SelectEnemy%
						IF NOT Result% THEN ShowBigMenu 3
						IF Result% THEN CboChosen% = True: SelectAction% = True
					END IF
				CASE CHR$(0) + CHR$(83)
					SelectAction% = False: CboChosen% = True
					CursorX% = 5: CursorY% = 140: ShowBattleMenu
			END SELECT
		LOOP UNTIL CboChosen%
	END IF

END FUNCTION

FUNCTION SelectEnemy

	IF Enemy(1).Alive THEN
			CursorX% = 70: CursorY% = 40
			Ec% = 1
		ELSEIF Enemy(2).Alive THEN
			CursorX% = 90: CursorY% = 70
			Ec% = 2
		ELSEIF Enemy(3).Alive THEN
			CursorX% = 60: CursorY% = 100
			Ec% = 3
	END IF
	Refresh% = True
	DO
		IF Refresh% THEN
			ShowBattle 0
			Ex% = CursorX% + 32
			Ey% = CursorY%
			DialogBox True, Ex%, Ey%, Ex% + 90, Ey% + 14, 56
			Ey% = Ey% + 4
			IF Enemy(Ec%).HP / Enemy(Ec%).HPMax < .25 THEN Colour% = 45 ELSE Colour% = 31
			NPrint 1, Ex% + 5, Ey%, Enemy(Ec%).Title, Colour%
			Ex% = Ex% + 60
			FOR j% = Ex% TO Ex% + 20
				gspset j%, Ey%, VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), 125
				gspset j%, Ey% + 1, VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), 125
				gspset j%, Ey% + 2, VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), 125
			NEXT j%

			NumBar% = Enemy(Ec%).HP / Enemy(Ec%).HPMax * 20
			IF NumBar% > 20 THEN NumBar% = 20
			FOR j% = Ex% TO NumBar% + Ex%
				gspset j%, Ey%, VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), Colour%
				gspset j%, Ey% + 1, VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), Colour%
				gspset j%, Ey% + 2, VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), Colour%
			NEXT j%

			ShowSprite "pointer.spr", CursorX%, CursorY%, 0, 20, 0
			gspcopy VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), &HA000, 0
			Refresh% = False
		END IF

		SELECT CASE INKEY$
			CASE CHR$(0) + CHR$(72), CHR$(0) + CHR$(80)
				DSPlaySample 1
				IF CursorX% = 70 AND CursorY% = 40 THEN
						IF Enemy(2).Alive THEN
								CursorX% = 90: CursorY% = 70
								Ec% = 2
							ELSEIF Enemy(3).Alive THEN
								CursorX% = 60: CursorY% = 100
								Ec% = 3
						END IF
					ELSEIF CursorX% = 90 AND CursorY% = 70 THEN
						IF Enemy(3).Alive THEN
								CursorX% = 60: CursorY% = 100
								Ec% = 3
							ELSEIF Enemy(1).Alive THEN
								CursorX% = 70: CursorY% = 40
								Ec% = 1
						END IF
					ELSEIF CursorX% = 60 AND CursorY% = 100 THEN
						IF Enemy(1).Alive THEN
								CursorX% = 70: CursorY% = 40
								Ec% = 1
							ELSEIF Enemy(2).Alive THEN
								CursorX% = 90: CursorY% = 70
								Ec% = 2
						END IF
				END IF
				Refresh% = True
			CASE CHR$(13)
				IF CursorX% = 70 AND CursorY% = 40 THEN ChoiceMade% = 1
				IF CursorX% = 90 AND CursorY% = 70 THEN ChoiceMade% = 2
				IF CursorX% = 60 AND CursorY% = 100 THEN ChoiceMade% = 3
				chosen% = True: SelectEnemy% = True
				ShowBattle 0
				gspcopy VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), &HA000, 0
			CASE CHR$(0) + CHR$(83)
				chosen% = True: SelectEnemy% = False
		END SELECT
	LOOP UNTIL chosen%
	CursorX% = 5: CursorY% = 140

END FUNCTION

FUNCTION SelectPlayer%

	CursorX% = 180: CursorY% = 120: ShowBattle 1
	DO
		SELECT CASE INKEY$
			CASE CHR$(0) + CHR$(72), CHR$(0) + CHR$(80)
				IF CursorY% = 120 AND Party(2).OnTeam THEN
						CursorX% = 200: CursorY% = 85
					ELSEIF CursorY = 85 AND Party(3).OnTeam THEN
						CursorX% = 210: CursorY% = 50
					ELSE
						CursorX% = 180: CursorY% = 120
				END IF
				DSPlaySample 1
				ShowBattle 1
			CASE CHR$(13)
				IF CursorY% = 120 THEN Char% = 1 ELSE IF CursorY% = 85 THEN Char% = 2 ELSE IF CursorY% = 50 THEN Char% = 3
				IF Party(Char%).Alive THEN
						IF NOT INSTR(CharItem$, "Revive") OR NOT INSTR(CharMagic$, "Revive") THEN
							UseOn% = Char%: CharChosen% = True
							SelectPlayer% = True
						END IF
					ELSEIF NOT Party(Char%).Alive THEN
						IF INSTR(CharItem$, "Revive") OR INSTR(CharMagic$, "Revive") THEN
							Party(Char%).Alive = True
							UseOn% = Char%: CharChosen% = True
							SelectPlayer% = True
						END IF
				END IF
			CASE CHR$(0) + CHR$(83)
				CharChosen% = True: SelectPlayer% = False
				CursorX% = 5: CursorY% = 140
		END SELECT
	LOOP UNTIL CharChosen%

END FUNCTION

REM $DYNAMIC
SUB ShowBattle (Anime%)

	IF RTRIM$(Enemy(1).Title) = "Cosmosis" THEN
			gsfill VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), 0
		ELSE
			DEF SEG = VARSEG(Buffer&(0)): BLOAD "bkgs\" + Background.sBkg, VARPTR(Buffer&(0)): DEF SEG
	END IF

	DialogBox True, 175, 163, 315, 199, 56

	FOR i% = 1 TO 3
		IF Party(i%).OnTeam THEN
			IF Party(i%).Alive AND NOT Party(i%).Attacking THEN
					ShowSprite Party(i%).BattleSet, Party(i%).x, Party(i%).y, BattleAnime%, 32, 0
				ELSEIF NOT Party(i%).Alive THEN
					ShowSprite Party(i%).BattleSet, Party(i%).x, Party(i%).y, 11, 32, 0
			END IF
		END IF
	NEXT i%

	IF Enemy(1).Alive AND NOT Enemy(1).Attacking THEN
		ShowSprite Enemy(1).Set, 70, 40, BattleAnime%, 32, 0
	END IF

	IF Enemy(2).Alive AND NOT Enemy(2).Attacking THEN
		ShowSprite Enemy(2).Set, 90, 70, BattleAnime%, 32, 0
	END IF

	IF Enemy(3).Alive AND NOT Enemy(3).Attacking THEN
		ShowSprite Enemy(3).Set, 60, 100, BattleAnime%, 32, 0
	END IF

	y% = 168
	FOR i% = 1 TO 3
		IF Party(i%).OnTeam THEN
			IF i% = CharTurn% THEN Colour% = 125 ELSE Colour% = 31
			NPrint 1, 180, y%, Party(i%).Title, Colour%
			y% = y% + 8
		END IF
	NEXT i%

	x% = 205: y% = 168
	FOR i% = 1 TO 3
		IF Party(i%).OnTeam THEN
			IF Party(i%).HP / Party(i%).HPMax < .25 THEN Colour% = 45 ELSE Colour% = 31
			NPrint 1, 205, y%, "HP:" + STR$(Party(i%).HP) + " SP:" + STR$(Party(i%).SP), Colour%
			y% = y% + 8
		END IF
	NEXT i%

	y% = 0
	FOR i% = 1 TO 3
		IF Party(i%).Alive AND Party(i%).OnTeam THEN
			FOR j% = 290 TO 310
				gspset j%, 168 + y%, VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), 125
				gspset j%, 169 + y%, VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), 125
				gspset j%, 170 + y%, VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), 125
			NEXT j%
			SELECT CASE Party(i%).Status
				CASE 1
					col% = 31
				CASE 2
					col% = 74
				CASE 3
					col% = 142
				CASE 4
					col% = 174
			END SELECT
			NumBar% = Act%(i%) / 100 * 20
			IF NumBar% > 20 THEN NumBar% = 20
			FOR j% = 290 TO NumBar% + 290
				gspset j%, 168 + y%, VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), col%
				gspset j%, 169 + y%, VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), col%
				gspset j%, 170 + y%, VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), col%
			NEXT j%
		END IF
		y% = y% + 8
	NEXT i%

	IF Anime% = 1 THEN
		ShowSprite "pointer.spr", CursorX%, CursorY%, 0, 20, 0
		gspcopy VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), &HA000, 0
	END IF

END SUB

SUB ShowBattleMenu

	ShowBattle 0
	DialogBox True, 0, 135, 80, 199, 56

	ShowSprite "pointer.spr", CursorX%, CursorY%, 0, 20, 0
	gsprint 1, 20, 140, "Attack", 31
	gsprint 1, 20, 180, "Run", 31

	SELECT CASE RTRIM$(Party(CharTurn%).Title)
		CASE "Nick"
			gsprint 1, 20, 150, "Combo", 31
			gsprint 1, 20, 160, "Magic", 31
			gsprint 1, 20, 170, "Item", 31
		CASE "Cerl"
			gsprint 1, 20, 150, "Void", 31
			gsprint 1, 20, 160, "Magic", 31
			gsprint 1, 20, 170, "Item", 31
		CASE "Ariel"
			gsprint 1, 20, 150, "Speed", 31
			gsprint 1, 20, 160, "Magic", 31
			gsprint 1, 20, 170, "Item", 31
		CASE "Dane"
			gsprint 1, 20, 150, "Psych", 31
			gsprint 1, 20, 160, "Magic", 31
			gsprint 1, 20, 170, "Item", 31
		CASE "Edwin"
			gsprint 1, 20, 150, "", 31
			gsprint 1, 20, 160, "Magic", 31
			gsprint 1, 20, 170, "Item", 31
	END SELECT

	gspcopy VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), &HA000, 0

END SUB

REM $STATIC
SUB WipeScreen

	RANDOMIZE TIMER
	Wipe% = INT(RND * 2)
	IF Wipe% = 0 THEN
			FOR x = 0 TO 159
				FOR y = 0 TO 199
					gspset x, y, &HA000, 0, POINT(319 - x, 199 - y)
					gspset 319 - x, y, &HA000, 0, POINT(x, y)
				NEXT y
				IF count% = 2 THEN gswait 1: count% = 0
				count% = count% + 1
				DEF SEG = 0: POKE &H41A, PEEK(&H41C): DEF SEG 'clear keyboard buffer
			NEXT x
		ELSEIF Wipe% = 1 THEN
			FOR y = 0 TO 99
				FOR x = 0 TO 319
					gspset x, y, &HA000, 0, POINT(319 - x, 199 - y)
					gspset x, 199 - y, &HA000, 0, POINT(x, y)
				NEXT x
				IF count% = 2 THEN gswait 1: count% = 0
				count% = count% + 1
				DEF SEG = 0: POKE &H41A, PEEK(&H41C): DEF SEG 'clear keyboard buffer
			NEXT y
		ELSEIF Wipe% = 2 THEN
	END IF
	IF INSTR(Background.sMusic, ".it") THEN
			DSPauseMusic 1
			LoadMusic Background.sMusic, 2
	END IF

END SUB

