'       ͸
'                                LEVEL.BAS                          
'                 Main Module 2 for "Ants : The Exodus"             
'       ͵
'        By Michael Hughes                            February 2002 
'       ͵
'        This is the 2nd main module for Ants:The Exodus v1.0.      
'        This code is for MS QuickBASIC v4.5.                       
'                                                                   
'            **WARNING: Load MIDI driver (SBMIDI) first!**          
'                                                                   
'        This module is designed to be called using the CHAIN                       
'        command from INTRO. To run as a stand-alone program see    
'        the instructions near the bottom of the module level code. 
'                                                                   
'        The documentation for this source can be found in          
'        SRCDOC.TXT which should accompany this file.               
'                                                                   
'        This source is public domain. You may use small parts of   
'        it within your own programs provided credit is given.      
'                                                                   
'        The following components were written by others:           
'         -GIF utilities : Mallard (www.qbasic.com)                 
'         -Mouse code    : Unknown                                  
'         -MIDI player   : Jesse Dorland                            
'         -Fading        : Manny Najera (www.flashgames.com)        
'        Original comments have been left in these sub-routines.    
'                                                                   
'        Use this product at your own risk.                         
'                                                                   
'                                                                   
'       Michael Hughes Software                        
'       February-May 2002                                     
'       mhsoft_online@yahoo.com                        
'       Visit the MHSoft Website:                                 
'       www.geocities.com/mhsoft_online                  M H S    
'       "Welcome to the World..."                      
'       ;

'**************SUB AND FUNCTION DECLARATIONS************************
REM $DYNAMIC
DECLARE SUB DrawPopupBox ()
DECLARE SUB DoFront ()
DECLARE SUB LoadImage (x!, y!, file$)
DECLARE SUB Delay (Repetitions%)
DECLARE SUB midicleanup ()
DECLARE SUB MIDIloop ()
DECLARE SUB MIDIStop ()
DECLARE SUB SetMIDI (LeftChannel%, RightChannel%)
DECLARE FUNCTION DoInMenu! ()
DECLARE SUB DoPlay (startlv!, init!)
DECLARE SUB DoInstruct ()
DECLARE SUB DrawInstruct (page!)
DECLARE SUB DoMission ()
DECLARE FUNCTION WordWrap$ (text$, w!, event!)
DECLARE SUB DoSave ()
DECLARE SUB DoSaveGame (file$)
DECLARE FUNCTION DoLoad$ ()
DECLARE FUNCTION DoLevel! (file$, ps!)
DECLARE SUB DoLoadGame (file$)
DECLARE SUB DoMainMenu ()
DECLARE SUB Centre (text$, y!)
DECLARE FUNCTION LTS$ (text!)
DECLARE FUNCTION DoGame! ()
DECLARE SUB DoTick ()
DECLARE SUB DoWin ()
DECLARE SUB DoLose (r!)
DECLARE SUB DoItem ()
DECLARE SUB DoExodus ()
DECLARE SUB InitMain ()
DECLARE SUB InitObjects ()
DECLARE SUB DrawWorld ()
DECLARE SUB DrawSide ()
DECLARE SUB DrawSprite (c!, w!)
DECLARE SUB DrawPlace (x!, y!)
DECLARE SUB Palette.Set (nColor%, pInfo AS ANY)
DECLARE SUB Palette.Get (nColor%, pInfo AS ANY)
DECLARE SUB Palette.FadeOut ()
DECLARE SUB Palette.FadeIn ()
DECLARE SUB InitSprites ()
DECLARE SUB DrawObject (o!, x!, y!)
DECLARE SUB DoCheck (s!)
DECLARE FUNCTION DoFree! (x!, y!, s!)
DECLARE SUB DrawHideSprite ()
DECLARE SUB InitWorld (file$)
DECLARE SUB DoSprite (s!)
DECLARE SUB DoSide ()
DECLARE SUB DetectSettings (BasePort%, IRQ%, LoDMA%, HiDMA%, CardType%, MPU401%)
DECLARE SUB DriversLoaded (SBMIDI%, SBSIM%)
DECLARE FUNCTION GetSynth% ()
DECLARE FUNCTION MIDIload% (Filename$)
DECLARE FUNCTION MIDIError$ ()
DECLARE FUNCTION MixerChip$ ()
DECLARE FUNCTION MusicDone% ()
DECLARE SUB MIDIplay (Handle%)
DECLARE SUB SetCard (CardType%)
DECLARE FUNCTION SoundCard$ (CardType%)
DECLARE FUNCTION MIDITime! ()
DECLARE FUNCTION InternalBitRead% (Variable%, BitNum%)
DECLARE SUB InternalBitSet (Variable%, BitNum%, OnOff%)
DECLARE SUB InternalBitToggle (Variable%, BitNum%)
DECLARE SUB InternalGetIntVector (IntNum%, segment&, offset&)
DECLARE SUB InternalGetVol (LeftChannel%, RightChannel%, Index%)
DECLARE SUB InternalSetVol (LeftChannel%, RightChannel%, Index%)
DECLARE SUB InternalWriteMixer (Index%, value%)
DECLARE FUNCTION InternalReadMixer% (Index%)
DECLARE SUB IntX (IntNum AS INTEGER, Regs AS ANY)
DECLARE SUB MIDIUnload (Handle%)
DECLARE FUNCTION MemUsed& (Handle%)
DECLARE SUB DoCreditants (y!)
DECLARE SUB DoCredits (E!)
DECLARE SUB DrawCredit (file$, x!, y!)


'****DECLARE TYPE AND DIMENSION ARRAYS***********
REM $DYNAMIC
COMMON SHARED retvalue
COMMON SHARED retvalue2
COMMON SHARED snd
COMMON SHARED musicon
COMMON SHARED SB.BASEPORT AS INTEGER
COMMON SHARED SB.IRQ AS INTEGER
COMMON SHARED SB.LODMA AS INTEGER
COMMON SHARED SB.HIDMA AS INTEGER
COMMON SHARED SB.CARDTYPE AS INTEGER
COMMON SHARED SB.MPU401 AS INTEGER
COMMON SHARED levelfile$
COMMON SHARED level
COMMON SHARED lives
COMMON SHARED delfac

TYPE PaletteType
  red AS INTEGER
  green AS INTEGER
  blue AS INTEGER
END TYPE

DIM SHARED Pal AS PaletteType
DIM SHARED pData(0 TO 255, 1 TO 3)


TYPE Registers
	 AX    AS INTEGER
	 BX    AS INTEGER
	 CX    AS INTEGER
	 dx    AS INTEGER
	 BP    AS INTEGER
	 SI    AS INTEGER
	 DI    AS INTEGER
	 FLAGS AS INTEGER
	 DS    AS INTEGER
	 ES    AS INTEGER
END TYPE
IntXCodeData:
DATA  &H55, &H8B, &HEC, &H83, &HEC, &H08, &H56, &H57, &H1E, &H55, &H8B, &H5E
DATA  &H06, &H8B, &H47, &H10, &H3D, &HFF, &HFF, &H75, &H04, &H1E, &H8F, &H47
DATA  &H10, &H8B, &H47, &H12, &H3D, &HFF, &HFF, &H75, &H04, &H1E, &H8F, &H47
DATA  &H12, &H8B, &H47, &H08, &H89, &H46, &HF8, &H8B, &H07, &H8B, &H4F, &H04
DATA  &H8B, &H57, &H06, &H8B, &H77, &H0A, &H8B, &H7F, &H0C, &HFF, &H77, &H12
DATA  &H07, &HFF, &H77, &H02, &H1E, &H8F, &H46, &HFA, &HFF, &H77, &H10, &H1F
DATA  &H8B, &H6E, &HF8, &H5B, &HCD, &H21, &H55, &H8B, &HEC, &H8B, &H6E, &H02
DATA  &H89, &H5E, &HFC, &H8B, &H5E, &H06, &H1E, &H8F, &H46, &HFE, &HFF, &H76
DATA  &HFA, &H1F, &H89, &H07, &H8B, &H46, &HFC, &H89, &H47, &H02, &H89, &H4F
DATA  &H04, &H89, &H57, &H06, &H58, &H89, &H47, &H08, &H89, &H77, &H0A, &H89
DATA  &H7F, &H0C, &H9C, &H8F, &H47, &H0E, &H06, &H8F, &H47, &H12, &H8B, &H46
DATA  &HFE, &H89, &H47, &H10, &H5A, &H1F, &H5F, &H5E, &H8B, &HE5, &H5D, &HCA
DATA  &H02, &H00
DIM SHARED QMIDIRegs AS Registers, MEM.SEGMENT(0 TO 255) AS INTEGER
DIM SHARED MIDI.PLAYTIME AS SINGLE, MIDI.ERROR AS INTEGER, PAUSED AS SINGLE
DIM SHARED MEM.ALLOCATED(0 TO 255)  AS LONG
DIM SHARED SBMIDI.INTERRUPT AS INTEGER
DIM SHARED SBSIM.INTERRUPT AS INTEGER, MIXER.CHIP AS INTEGER
DIM SHARED BIT.STORAGE(0 TO 7) AS INTEGER
DIM SHARED SENSITIVE AS INTEGER, REVERSE.STEREO AS INTEGER
DIM SHARED SOUND.DISABLED AS INTEGER, CURRENTHANDLE AS INTEGER
'DIM SHARED SB.BASEPORT AS INTEGER, SB.IRQ AS INTEGER
'DIM SHARED SB.LODMA AS INTEGER, SB.HIDMA AS INTEGER, SB.CARDTYPE AS INTEGER
'DIM SHARED SB.MPU401 AS INTEGER

IF SBMIDI.INTERRUPT = 0 THEN SBMIDI.INTERRUPT = &H80
IF SBSIM.INTERRUPT = 0 THEN SBSIM.INTERRUPT = &H81
IF SB.BASEPORT = 0 THEN SB.BASEPORT = &H220
IF SB.IRQ = 0 THEN SB.IRQ = 5
IF SB.LODMA = 0 THEN SB.LODMA = 1
IF SB.HIDMA = 0 AND SB.CARDTYPE = 6 THEN SB.HIDMA = 5

CONST black = 0
CONST blue = 1
CONST green = 2
CONST red = 4
CONST grey = 7
CONST dgrey = 8
CONST Brown = 6
CONST yellow = 14
CONST white = 15
CONST bg = 0                      '**Background for main game

'**Blocks
DIM SHARED block1!(65)
DIM SHARED block2!(65)
DIM SHARED block3!(65)
DIM SHARED block4!(65)
DIM SHARED block5!(65)
DIM SHARED block6!(65)
DIM SHARED block7!(65)
DIM SHARED block8!(65)
DIM SHARED block9!(65)
DIM SHARED block10!(65)
DIM SHARED block11!(65)
DIM SHARED block12!(65)
DIM SHARED block13!(65)
DIM SHARED block14!(65)
DIM SHARED block15!(65)
DIM SHARED block16!(65)
DIM SHARED block17!(65)
DIM SHARED block18!(65)
DIM SHARED block19!(65)
DIM SHARED block20!(65)
DIM SHARED block21!(65)
DIM SHARED block22!(65)

'**Sprite images
DIM SHARED antr!(65)
DIM SHARED antl!(65)
DIM SHARED antu!(65)
DIM SHARED antd!(65)
DIM SHARED antrn!(65)
DIM SHARED antln!(65)
DIM SHARED antun!(65)
DIM SHARED antdn!(65)
DIM SHARED antr2!(65)
DIM SHARED antl2!(65)
DIM SHARED antu2!(65)
DIM SHARED antd2!(65)
DIM SHARED antrn2!(65)
DIM SHARED antln2!(65)
DIM SHARED antun2!(65)
DIM SHARED antdn2!(65)

DIM SHARED spir!(65)
DIM SHARED spil!(65)
DIM SHARED spiu!(65)
DIM SHARED spid!(65)
DIM SHARED spirn!(65)
DIM SHARED spiln!(65)
DIM SHARED spiun!(65)
DIM SHARED spidn!(65)
DIM SHARED spir2!(65)
DIM SHARED spil2!(65)
DIM SHARED spiu2!(65)
DIM SHARED spid2!(65)
DIM SHARED spirn2!(65)
DIM SHARED spiln2!(65)
DIM SHARED spiun2!(65)
DIM SHARED spidn2!(65)

DIM SHARED waspr!(65)
DIM SHARED waspl!(65)
DIM SHARED waspu!(65)
DIM SHARED waspd!(65)
DIM SHARED wasprn!(65)
DIM SHARED waspln!(65)
DIM SHARED waspun!(65)
DIM SHARED waspdn!(65)
DIM SHARED waspr2!(65)
DIM SHARED waspl2!(65)
DIM SHARED waspu2!(65)
DIM SHARED waspd2!(65)
DIM SHARED wasprn2!(65)
DIM SHARED waspln2!(65)
DIM SHARED waspun2!(65)
DIM SHARED waspdn2!(65)
		  

DIM SHARED FLIERr!(65)
DIM SHARED FLIERl!(65)
DIM SHARED flieru!(65)
DIM SHARED FLIERd!(65)
DIM SHARED FLIERrn!(65)
DIM SHARED FLIERln!(65)
DIM SHARED flierun!(65)
DIM SHARED FLIERdn!(65)
DIM SHARED FLIERr2!(65)
DIM SHARED FLIERl2!(65)
DIM SHARED FLIERu2!(65)
DIM SHARED FLIERd2!(65)
DIM SHARED FLIERrn2!(65)
DIM SHARED FLIERln2!(65)
DIM SHARED FLIERun2!(65)
DIM SHARED FLIERdn2!(65)
DIM SHARED flier2!(65)
DIM SHARED flier2n!(65)


DIM SHARED redr!(65)
DIM SHARED redl!(65)
DIM SHARED redu!(65)
DIM SHARED redd!(65)
DIM SHARED redrn!(65)
DIM SHARED redln!(65)
DIM SHARED redun!(65)
DIM SHARED reddn!(65)
DIM SHARED redr2!(65)
DIM SHARED redl2!(65)
DIM SHARED redu2!(65)
DIM SHARED redd2!(65)
DIM SHARED redrn2!(65)
DIM SHARED redln2!(65)
DIM SHARED redun2!(65)
DIM SHARED reddn2!(65)

'**Sprite details
DIM SHARED numsprites!           '*Number of sprites on level
DIM SHARED sprt!(10)             '*Type
DIM SHARED sprx!(10)             '*X pos(pixel)
DIM SHARED spry!(10)             '*Y pos(pixel)
DIM SHARED sprd!(10)             '*Direction (real = * 90 degrees c.wise)
DIM SHARED sprmh!(10)            '*Horizontal pixels per tick
DIM SHARED sprmv!(10)            '*Vertical pixels per tick
DIM SHARED sprr!(10)             '*Rotation upon hitting obsticle (Direction = modulo [Direction + rotation])
DIM SHARED sprm!(10)             '*Dead or alive

'**Lives
DIM SHARED Ants(200)             '*Life indicators
DIM SHARED antsn(200)

'**Misc
DIM SHARED place!(-1 TO 27, -1 TO 22)     '*Place data
DIM SHARED dplace!(-1 TO 27, -1 TO 22)    '*Whether place needs redrawing
DIM SHARED itemn!(100)

'**Suply dump details
DIM SHARED numsp
DIM SHARED supx(10)
DIM SHARED supy(10)
DIM SHARED supi(10, 10)

'**Level data
DIM SHARED top$
DIM SHARED version$
DIM SHARED author$
DIM SHARED title$
DIM SHARED datew$
DIM SHARED numclines
DIM SHARED comment$(10)

'**Gamplay
DIM SHARED fullgame
DIM SHARED exodus
DIM SHARED tick                           '*Game loop no.
DIM SHARED time1                          '*Limit for pre-release
DIM SHARED time2                          '*Limit for post-release
DIM SHARED timel                          '*Time left
DIM SHARED isel                           '*Item selected
DIM SHARED oldisel                        '*Previous item selected
DIM SHARED safe                           '*Number princesses at finish
DIM SHARED lname$(10)                     '*Internal for DoSave
DIM SHARED sx
DIM SHARED sy
DIM SHARED fx
DIM SHARED fy

'**Additional sound**
DIM SHARED midiplaying
DIM SHARED midivolume%


'****BEGINNING OF RUN-CODE****
'*To run this as a stand-alone module unremark the following 4 lines. Then
'*remark the two lines which begin with CHAIN. Type the name of the level
'*next to levelfile$. To run a saved game set retvalue = 2 and enter the
'*name next to levelfile$ (saved files are SAVE\*.SAV where * = 1 to 10
'*Regardless of what you set the 'lives' variable to, the program will end
'*after one life.

'level = 1
'retvalue = 1
'levelfile$ = "maps\1.map"
'lives = 1

IF retvalue = 0 THEN
  PRINT
  PRINT "To play Ants:The Exodus, run ANTS.BAT or NOSOUND.BAT."
  END
END IF

SCREEN 9

CALL InitMain
CALL InitSprites
CALL InitObjects

IF retvalue2 = 1 THEN fullgame = 0 ELSE fullgame = 1

IF retvalue = 1 THEN
  retvalue = DoLevel(levelfile$, 1)
  IF snd = 1 THEN MIDIUnload (0)
  CHAIN "INTRO"
ELSEIF retvalue = 2 THEN
  CALL DoLoadGame(levelfile$)
  retvalue = DoLevel(levelfile$, 0)
  IF fullgame = 1 THEN retvalue2 = 0 ELSE retvalue2 = 1
  IF snd = 1 THEN MIDIUnload (0)
  CHAIN "INTRO"
END IF


'**Key presses**
F10:
IF exodus = 0 THEN CALL DoExodus
RETURN

REM $STATIC
SUB Delay (Repetitions%)
'***************************************************************************
'*Machine independant delay (From QMIDI by Jesse Dorland)                  *
'***************************************************************************

FOR I% = 1 TO Repetitions%
	WAIT &H3DA, 8, 8
	WAIT &H3DA, 8
NEXT I%

END SUB

SUB DoCheck (s)
'***************************************************************************
'*Checks to see if sprite is on special square and acts accordingly.       *
'***************************************************************************

x = INT(sprx(s) / 20)
y = INT(spry(s) / 15)
DI = sprd(s)
t = sprt(s)

IF t <> 2 THEN                                  '**If not a wasp**

'********CHECK HOLE/GAP**************

IF place(x, y) = -1 OR place(x, y) = 0 OR place(x, y) = 8 THEN     '**Space or hole**
  IF t = 0 THEN                                 '**If ant**
    IF isel = 1 AND itemn(isel) > 0 THEN        '**If have grating and selected**
      IF place(x, y) = 8 THEN                   '**If hole**
	itemn(isel) = itemn(isel) - 1           '**Reduce brige section by one**
	place(x, y) = 9                         '**Lay grating**
	FOR a = 0 TO 7
	  LOCATE a + 11, 74
	  t$ = "["
	  IF itemn(a + 1) < 10 THEN t$ = t$ + "0"
	  t$ = t$ + LTRIM$(RTRIM$(STR$(itemn(a + 1)))) + "]"
	  PRINT t$
	NEXT a
	FOR a = 0 TO 7
	  LINE (583, a * 14 + 139)-STEP(34, 14), white, B
	NEXT a
	GOTO bokay
      END IF
    END IF
    IF isel = 2 AND itemn(isel) > 0 THEN                 '**If have bridge section**
      IF place(x, y) = 0 OR place(x, y) = 8 THEN
	itemn(isel) = itemn(isel) - 1
	place(x, y) = 1                                  '**Lay grating**
	FOR a = 0 TO 7
	  LOCATE a + 11, 74
	  t$ = "["
	  IF itemn(a + 1) < 10 THEN t$ = t$ + "0"
	  t$ = t$ + LTRIM$(RTRIM$(STR$(itemn(a + 1)))) + "]"
	  PRINT t$
	NEXT a
	FOR a = 0 TO 7
	  LINE (583, a * 14 + 139)-STEP(34, 14), white, B
	NEXT a
       
	GOTO bokay
      END IF
    END IF
  END IF
						'**IF FALL OFF EDGE**
  CALL DrawHideSprite                           '**Clear sprites**
  PCOPY 1, 0                                    '**Switch to front mode**
  SCREEN , , 0, 0
  FOR g = 1 TO 4                                '**Draw red circles indicating fall**
    FOR D = 1 TO 4000: NEXT D
    CIRCLE (x * 20 + 10, y * 15 + 7), g, red
  NEXT g
  FOR g = 4 TO 1 STEP -1
    FOR D = 1 TO 4000: NEXT D
    CIRCLE (x * 20 + 10, y * 15 + 7), g, bg
  NEXT g
 
  sprm(s) = -1                                  '**Set sprite as dead**
  
 
  SCREEN , , 1, 0
  
END IF

bokay:


'*******CHECK BRICK***********

IF place(x, y) = 3 AND t = 0 THEN
  place(x, y) = 1
  IF DI = 1 THEN place(x, y + 1) = 3
  IF DI = 2 THEN place(x - 1, y) = 3
  IF DI = 3 THEN place(x, y - 1) = 3
  IF DI = 4 THEN place(x + 1, y) = 3
  FOR g = 1 TO 5
    CALL DoSprite(0)
  NEXT g
  FOR a = -1 TO 1
    FOR B = -1 TO 1
      CALL DrawPlace(x + a, y + B)
    NEXT B
  NEXT a
  CALL DrawSprite(0, 0)
END IF

'*****CHECK ARROWS*************

IF place(x, y) = 4 THEN
  sprd(s) = 3
  sprx(s) = x * 20 + 10
  spry(s) = y * 15 + 9
  FOR g = 1 TO 3
    CALL DrawSprite(s, 1)
    FOR F = 1 TO 4
      CALL DoSprite(s)
    NEXT F
  NEXT g
END IF

IF place(x, y) = 5 THEN
  sprd(s) = 2
  sprx(s) = x * 20 + 10
  spry(s) = y * 15 + 8
 
  FOR g = 1 TO 3
    CALL DrawSprite(s, 1)
    FOR F = 1 TO 6
      CALL DoSprite(s)
    NEXT F
  NEXT g
END IF

IF place(x, y) = 6 THEN
  sprd(s) = 1
  sprx(s) = x * 20 + 10
  spry(s) = y * 15 + 6
  FOR g = 1 TO 3
    CALL DrawSprite(s, 1)
    FOR F = 1 TO 4
      CALL DoSprite(s)
    NEXT F
  NEXT g
END IF

IF place(x, y) = 7 THEN
  sprd(s) = 4
  sprx(s) = x * 20 + 10
  spry(s) = y * 15 + 8
  FOR g = 1 TO 3
    CALL DrawSprite(s, 1)
    FOR F = 1 TO 6
      CALL DoSprite(s)
    NEXT F
  NEXT g
END IF

'****CHECK Keys*****

IF sprt(s) = 0 THEN
  IF place(x, y) = 16 THEN itemn(9) = itemn(9) + 1: place(x, y) = 1: CALL DrawSide
  IF place(x, y) = 17 THEN itemn(10) = itemn(10) + 1: place(x, y) = 1: CALL DrawSide
  IF place(x, y) = 18 THEN itemn(11) = itemn(11) + 1: place(x, y) = 1: CALL DrawSide
  IF place(x, y) = 19 THEN itemn(12) = itemn(12) + 1: place(x, y) = 1: CALL DrawSide
END IF

'****CHECK MINED********
IF place(x, y) = 20 THEN
  LINE (x * 20, y * 15)-STEP(19, 14), red, BF
  dplace(x, y) = 1                             '**Place needs redrawing**
  PCOPY 1, 0
  sprm(s) = -1
  place(x, y) = 1
END IF

'***CHECK WEB*************

IF place(x, y) = 21 AND t <> 1 THEN
  sprmh(s) = 0                        '**Set motion to zero**
  sprmv(s) = 0
END IF


END IF
'********FINISH SQUARE********

IF t = 4 THEN
  IF place(x, y) = 15 THEN
    safe = safe + 1
    sprt(s) = -2
  END IF
END IF

'*****SUPPLY POST**********

IF t = 0 AND place(x, y) = 22 THEN
  FOR a = 1 TO 10
    IF supx(a) = x AND supy(a) = y THEN
      FOR B = 1 TO 10
	it = supi(a, B)
	IF itemn(it) < 99 THEN itemn(it) = itemn(it) + 1
      NEXT B
    END IF
    place(x, y) = 1
  NEXT a
  CALL DrawSide
  oldisel = -100
  CALL DoSide
END IF



IF DI = 1 THEN
  pt = py - 7
  pb = py + 7
  pl = px - 6
  pr = px + 6
END IF

IF DI = 2 THEN
  pt = py - 6
  pb = py + 6
  pl = px - 9
  pr = px + 8
END IF

IF DI = 3 THEN
  pt = py - 7
  pb = py + 6
  pl = px - 6
  pr = px + 6
END IF

IF DI = 4 THEN
  pt = py - 6
  pb = py + 6
  pl = px - 9
  pr = px + 9
END IF

'**Check for getting killed by other sprite**

IF t = 1 THEN
  FOR a = 0 TO numsprites
    IF sprt(a) = 0 OR sprt(a) = 3 OR sprt(a) = 4 THEN
      IF sprx(a) + 10 > sprx(s) AND sprx(a) < sprx(s) + 10 THEN
	IF spry(a) + 8 > spry(s) AND spry(a) < spry(s) + 8 THEN
	  sprm(a) = -1
	END IF
      END IF
    END IF
  NEXT a
END IF
  
IF t = 2 THEN
  FOR a = 0 TO numsprites
    IF sprt(a) <> 2 THEN
      IF sprx(a) + 10 > sprx(s) AND sprx(a) < sprx(s) + 10 THEN
	IF spry(a) + 8 > spry(s) AND spry(a) < spry(s) + 8 THEN
	  sprm(a) = -1
	END IF
      END IF
    END IF
  NEXT a
END IF

IF t = 3 THEN
  FOR a = 0 TO numsprites
    IF sprt(a) = 0 OR sprt(a) = 4 THEN
      IF sprx(a) + 10 > sprx(s) AND sprx(a) < sprx(s) + 10 THEN
	IF spry(a) + 8 > spry(s) AND spry(a) < spry(s) + 8 THEN
	  sprm(a) = -1
	END IF
      END IF
    END IF
  NEXT a
END IF




END SUB

SUB DoExodus
'****************************************************************************
'*Releases a princess. If this is the first release then the release time is*
'*also set.                                                                 *
'****************************************************************************

  IF exodus = 0 THEN tick = 0
 
  exodus = exodus + 1
  numsprites = numsprites + 1
  '****Set Princess constants*********
  sprx(numsprites) = (sx * 20) + 10
  spry(numsprites) = (sy * 15) + 7
  sprd(numsprites) = INT(RND * 4) + 1
  sprt(numsprites) = 4
  sprm(numsprites) = 1
  sprmh(numsprites) = 6
  sprmv(numsprites) = 4

  IF exodus = 1 THEN CALL DrawSide  '**If First Exodus**


END SUB

FUNCTION DoFree (x, y, s)
'****************************************************************************
'*Checks if square x,y is available for sprite 's' to walk onto. If it is a *
'*lock and key is held, lock is removed                                     *
'****************************************************************************

p = place(x, y)
t = sprt(s)

IF t = 2 THEN
  IF p = -1 THEN
    DoFree = 0
  ELSE
    DoFree = 1
  END IF
  EXIT FUNCTION
END IF

IF p = -1 OR p = 0 THEN
  IF t = 0 OR t = 4 THEN DoFree = 1 ELSE DoFree = 0
END IF
IF p = 1 THEN DoFree = 1                              '**Yellow square**
IF p = 2 THEN DoFree = 0                              '**Stone wall**
IF p = 3 THEN                                         '**Brick
  IF t = 0 THEN
    DoFree = 1
  ELSE
    DoFree = 0
  END IF
END IF

IF p >= 4 AND p <= 9 THEN DoFree = 1                  '**Arrows, holes**

IF p >= 10 AND p <= 13 THEN                           '**Locks**
  IF t = 0 THEN
    n = p - 1
    IF itemn(n) > 0 THEN
      itemn(n) = itemn(n) - 1
      place(x, y) = 1
      dplace(x, y) = 1
      CALL DrawSide
    END IF
  ELSE
    DoFree = 0
  END IF
END IF

IF p >= 14 THEN DoFree = 1                            '**Web, supply post, mines, keys


END FUNCTION

FUNCTION DoGame
'***************************************************************************
'*This is the main game loop.                                              *
'***************************************************************************

IF snd = 1 THEN
  musicon = musicon + 1
  IF musicon = 8 THEN musicon = 1
  midiplaying = musicon + 2
  file$ = "MIDI\" + LTS$(musicon) + ".MID"
  CALL MIDIStop
  CALL MIDIUnload(0)
  Handle% = MIDIload(file$)
  CALL MIDIplay(Handle%)
END IF

SCREEN , , 1, 0

KEY(10) ON                                          '**Activate F10 key**
ON KEY(10) GOSUB F10                                '**Enable checking for F10**"
lastmove = TIMER

top:
pressed$ = ""

DO WHILE pressed$ = ""                              '**Loop while no keyboard input**
  pressed$ = INKEY$
  IF pressed$ <> "" THEN EXIT DO
 
  tick = tick + 1
  CALL DoTick                                       '**Move sprites, update screen**
 
  '***DO RELEASE**************************          '**If princesses have been released**
  IF exodus > 0 AND exodus < 4 THEN                 '**then continue to release others**
    IF tick - timed > 4 THEN                       '**at preset intervals**
      timed = tick
      CALL DoExodus
    END IF
  END IF
 
  '***UPDATE SIDEBAR*******************
  CALL DoSide
 
  '***CHECK TIME*********************
  IF timel <= 0 THEN                                '**If time-up**
    CALL DrawSide                                   '**Do final update**
    IF exodus = 0 THEN                              '**If princesses have not been released then relese them**
      CALL DoExodus
    ELSE                                            '**If princesses have been released then game is lost**
      CALL LoadImage(205, 115, "images\time.spr")
      PCOPY 1, 0
      CALL Delay(100)
      DoGame = -1
      EXIT FUNCTION
    END IF
  END IF

  '***CHECK FOR GAME LOST*************
  FOR s = 0 TO numsprites
    IF sprt(s) = 0 OR sprt(s) = 4 THEN              '**Check for dead ant/princess**
      IF sprm(s) = -1 THEN
	DoGame = -1
	CALL LoadImage(205, 115, "images\lose.spr")
	PCOPY 1, 0
	CALL Delay(100)
	EXIT FUNCTION
     END IF
    END IF
  NEXT s

  IF safe = 4 THEN                                  '**Check for win**
    DoGame = 1
    CALL LoadImage(205, 115, "images\done.spr")
    PCOPY 1, 0
    CALL Delay(100)
    EXIT FUNCTION
  END IF

 
  IF snd = 1 THEN CALL MIDIloop

  DO WHILE TIMER - lastmove < .2                    '**Stops game running too fast
  LOOP
  lastmove = TIMER

LOOP

CALL DrawSprite(0, 0)

IF pressed$ = CHR$(27) THEN                         '**Check for Esc. key**
  res = DoInMenu
  IF res = 1 THEN
    lives = 0
    DoGame = -1
    EXIT FUNCTION
  END IF
  IF res = 2 THEN
    DoGame = -1
    EXIT FUNCTION
  END IF
END IF


IF pressed$ = CHR$(0) + "H" THEN                    '**Check for UP key**
  IF sprd(0) = 3 AND sprm(0) = 1 THEN
    sprm(0) = 0
  ELSE
    sprm(0) = 1
    sprd(0) = 1
  END IF
END IF

IF pressed$ = CHR$(0) + "P" THEN                    '**Check for DOWN key**
  IF sprd(0) = 1 AND sprm(0) = 1 THEN
    sprm(0) = 0
  ELSE
    sprm(0) = 1
    sprd(0) = 3
  END IF
END IF

IF pressed$ = CHR$(0) + "K" THEN                    '**Check for LEFT key**
  IF sprd(0) = 2 AND sprm(0) = 1 THEN
    sprm(0) = 0
  ELSE
    sprm(0) = 1
    sprd(0) = 4
  END IF
END IF

IF pressed$ = CHR$(0) + "M" THEN                    '**Check for RIGHT key**
  IF sprd(0) = 4 AND sprm(0) = 1 THEN
    sprm(0) = 0
  ELSE
    sprm(0) = 1
    sprd(0) = 2
  END IF
END IF

IF pressed$ = CHR$(9) THEN                          '**Check for TAB key**
  isel = isel + 1                                   '**Select next item**
  IF isel > 8 THEN isel = 1
END IF

IF pressed$ = CHR$(13) THEN                         '**Check for ENTER key**
  isel = 3                                          '**Select dynamite**
  CALL DoItem
END IF


IF pressed$ = " " THEN CALL DoItem                  '**Check for SPACE key**
cheat = 0
IF cheat = 1 THEN
  IF UCASE$(pressed$) = "W" THEN
    DoGame = 1
    EXIT FUNCTION
  END IF
END IF

GOTO top                                            '**Begin again**


END FUNCTION

FUNCTION DoInMenu
'***************************************************************************
'*Diplays the in-game menu and repond to selection                         *
'***************************************************************************

SCREEN , , 0, 0
CALL DrawPopupBox

LOCATE 8, 33: PRINT "In-Game Menu"
sel = 1                                         '**Highlight first option**
thetop3:
IF sel = 1 THEN COLOR 2 ELSE COLOR 15
LOCATE 10, 28: PRINT "Save Game"
IF sel = 2 THEN COLOR 2 ELSE COLOR 15
LOCATE 11, 28: PRINT "Exit Game"
IF sel = 3 THEN COLOR 2 ELSE COLOR 15
LOCATE 12, 28: PRINT "Suicide"
IF sel = 4 THEN COLOR 2 ELSE COLOR 15
LOCATE 13, 28: PRINT "Done"


a$ = ""
DO WHILE a$ = ""
  IF snd = 1 THEN CALL MIDIloop
  a$ = INKEY$
LOOP

IF a$ = CHR$(0) + "H" THEN sel = sel - 1          '**Up key**
IF sel < 1 THEN sel = 4
IF a$ = CHR$(0) + "P" THEN sel = sel + 1          '**Down key**
IF sel > 4 THEN sel = 1

IF a$ = CHR$(13) THEN                             '**Enter key**
  IF sel = 1 THEN                                 '**Save game**
    CALL DoSave
   
    '**Redraw menu**
    CALL DrawPopupBox
    LOCATE 8, 33: PRINT "In-Game Menu"
  END IF
 
  IF sel = 2 THEN                                '**Exit game**
    lives = 0
    DoInMenu = 1
    EXIT FUNCTION
  END IF

  IF sel = 3 THEN                                '**Restart Level**
    DoInMenu = 2
    EXIT FUNCTION
  END IF
 
  IF sel = 4 THEN                                '**Done**
    PCOPY 1, 0
    SCREEN , , 1, 0
    EXIT FUNCTION
  END IF

END IF

GOTO thetop3






END FUNCTION

SUB DoItem
'****************************************************************************
'*Deploys space-bar activated items.                                        *
'****************************************************************************

x = INT(sprx(0) / 20)
y = INT(spry(0) / 15)
p = place(x, y)


IF itemn(isel) = 0 THEN EXIT SUB       '**If none left**

'*********DYNAMITE*********

IF isel = 3 THEN
  itemn(isel) = itemn(isel) - 1
  FOR a = -1 TO 1
    FOR B = -1 TO 1
      LINE ((x + a) * 20 + 1, (B + y) * 15 + 1)-STEP(19, 14), red, BF
      dplace(x + a, y + B) = 1
    NEXT B
  NEXT a
  PCOPY 1, 0
  sprmh(0) = 6
  sprmv(0) = 4
  FOR a = -1 TO 1
    FOR B = -1 TO 1
      IF place(x + a, B + y) > 0 AND place(x + a, B + y) <> 8 AND place(x + a, y + B) <> 14 AND place(x + a, y + B) <> 15 THEN
	place(x + a, y + B) = 1
	CALL DrawPlace(x + a, y + B)
	FOR s = 1 TO numsprites
	  IF INT(sprx(s) / 20) = x + a AND INT(spry(s) / 15) = y + B THEN sprt(s) = -1
	NEXT s
      END IF
    NEXT B
  NEXT a
END IF

'********MINE***************

IF isel = 4 THEN
  IF p = 1 THEN
    place(x, y) = 20
    itemn(isel) = itemn(isel) - 1
    sprx(s) = x * 20 + 10
    spry(s) = y * 15 + 9
    FOR z = 1 TO 10
      CALL DoSprite(0)
      CALL DrawSprite(0, 0)
    NEXT z
  END IF
END IF


'*********UP ARROW********
IF isel = 5 THEN
  IF p = 1 THEN
    place(x, y) = 6
    itemn(isel) = itemn(isel) - 1
  END IF
END IF

'********DOWN ARROW**********
IF isel = 6 THEN
  IF p = 1 THEN
    place(x, y) = 5
    itemn(isel) = itemn(isel) - 1
  END IF
END IF

'**********LEFT ARROW******
IF isel = 7 THEN
  IF p = 1 THEN
    place(x, y) = 4
    itemn(isel) = itemn(isel) - 1
  END IF
END IF

'***********RIGHT ARROW********
IF isel = 8 THEN
  IF p = 1 THEN
    place(x, y) = 7
    itemn(isel) = itemn(isel) - 1
  END IF
END IF


'*********RETYPE NUMBER OF EACH ITEM ON SIDEBAR********
'FOR y = 0 TO 7
'  LOCATE y + 11, 74
'  t$ = "["
'  IF itemn(y + 1) < 10 THEN t$ = t$ + "0"
'  t$ = t$ + LTRIM$(RTRIM$(STR$(itemn(y + 1)))) + "]"
'  PRINT t$
'NEXT y

'FOR y = 0 TO 7
'  LINE (583, y * 14 + 139)-STEP(34, 14), white, B
'NEXT y

'LOCATE 21, 69: PRINT itemn(9)
'LOCATE 21, 72: PRINT itemn(10)
'LOCATE 21, 75: PRINT itemn(11)
'LOCATE 21, 78: PRINT itemn(12)
'LINE (544, 280)-STEP(94, 13), white, B
'FOR x = 1 TO 3
'  LINE (544 + x * 24, 280)-STEP(0, 13), white
'NEXT x
CALL DrawSide
 
END SUB

FUNCTION DoLevel (file$, ps)
'****************************************************************************
'*Prepares to run a level and calls DoGame                                  *
'****************************************************************************
 
  IF ps = 1 THEN CALL InitWorld(file$)   '**If starting afresh (not loadgame)
 
  SCREEN 9, , 1, 0
  LINE (0, 0)-STEP(640, 350), black, BF
  LINE (0, 0)-STEP(640, 350), bg, BF
  CALL DrawWorld
  CALL DrawSide
 
  CALL Palette.FadeOut
  PCOPY 1, 0
 
  SCREEN , , 0, 0
  CALL DrawPopupBox
  LOCATE 8, 27: PRINT title$
  COLOR 2
  LOCATE 10, 27: PRINT "Author:" + author$
  COLOR 13
  LOCATE 12, 27: PRINT "Stage 1 Limit:" + STR$(time1)
  LOCATE 14, 27: PRINT "Stage 2 Limit:" + STR$(time2)
  COLOR 14
  LOCATE 16, 27: PRINT " < Time Begins when you"
  LOCATE 17, 27: PRINT "     press any key. >"
  CALL Palette.FadeIn
  DO WHILE INKEY$ = "": LOOP
 
  result = DoGame
  DoLevel = result
  IF snd = 1 THEN CALL MIDIStop
  
  CALL Palette.FadeOut
  SCREEN , , 0, 0
  CLS
  CALL Palette.FadeIn


END FUNCTION

SUB DoLoadGame (file$)
'****************************************************************************
'*Loads a saved game from file$                                             *
'****************************************************************************
OPEN file$ FOR INPUT AS #1
INPUT #1, a
INPUT #1, title$
INPUT #1, dated$
INPUT #1, levelfile$
INPUT #1, author$
INPUT #1, datew$
INPUT #1, numclines
FOR x = 1 TO numclines
  LINE INPUT #1, comment$(x)
NEXT x
INPUT #1, lives
INPUT #1, fullgame
IF fullgame = 1 THEN
  INPUT #1, level
END IF


FOR y = 1 TO 20
  LINE INPUT #1, lin$
  FOR x = 1 TO 50 STEP 2
    place((x + 1) / 2, y) = VAL(MID$(lin$, x, 2))
    IF place((x + 1) / 2, y) = 14 THEN
      sprx(0) = (x + 1) / 2 * 20 + 10
      spry(0) = y * 15 + 8
    END IF
  NEXT x
NEXT y

INPUT #1, numsprites
FOR x = 0 TO numsprites
  INPUT #1, sprt(x)
  INPUT #1, sprx(x)
  INPUT #1, spry(x)
  INPUT #1, sprd(x)
  INPUT #1, sprr(x)
  INPUT #1, sprm(x)
  INPUT #1, sprmh(x)
  INPUT #1, sprmv(x)
NEXT x
INPUT #1, numsp
FOR x = 1 TO numsp
  INPUT #1, supx(x)
  INPUT #1, supy(x)
  FOR y = 1 TO 10
    INPUT #1, supi(x, y)
  NEXT y
NEXT x

INPUT #1, time1
INPUT #1, time2
INPUT #1, tick
INPUT #1, exodus
INPUT #1, sx
INPUT #1, sy
INPUT #1, fx
INPUT #1, fy
FOR x = 1 TO 12
  INPUT #1, itemn(x)
NEXT x
INPUT #1, isel
CLOSE


END SUB

SUB DoSave
'****************************************************************************
'*Asks the user which slot to save the game in and the calls DoSaveGame     *
'****************************************************************************

CALL DrawPopupBox

FOR x = 1 TO 10
  file$ = "SAVE\" + LTS$(x) + ".SAV"
  OPEN file$ FOR INPUT AS #1
  INPUT #1, full
  IF full = 0 THEN
    lname$(x) = "Blank"
  ELSE
    INPUT #1, level$
    INPUT #1, dated$
    lname$(x) = level$ + " " + dated$
  END IF
  CLOSE #1
NEXT x

sel = 1
thetop4:

FOR x = 1 TO 10
  IF sel = x THEN COLOR 2 ELSE COLOR 15
  LOCATE x + 7, 28: PRINT lname$(x)
NEXT x

IF sel = 11 THEN COLOR 2 ELSE COLOR 15
LOCATE 18, 28: PRINT "Cancel"


a$ = ""
DO WHILE a$ = ""
  IF snd = 1 THEN CALL MIDIloop
  a$ = INKEY$
LOOP

IF a$ = CHR$(0) + "H" THEN sel = sel - 1
IF sel < 1 THEN sel = 11
IF a$ = CHR$(0) + "P" THEN sel = sel + 1
IF sel > 11 THEN sel = 1
IF a$ = CHR$(13) THEN
  IF sel = 11 THEN EXIT SUB
  file$ = "SAVE\" + LTS$(sel) + ".SAV"
  CALL DoSaveGame(file$)
  EXIT SUB
END IF

GOTO thetop4

END SUB

SUB DoSaveGame (file$)
'****************************************************************************
'*Saves a game to file$                                                     *
'****************************************************************************


OPEN file$ FOR OUTPUT AS #1
PRINT #1, 1
PRINT #1, title$
PRINT #1, DATE$
PRINT #1, levelfile$
PRINT #1, author$
PRINT #1, datew$
PRINT #1, numclines
FOR x = 1 TO numclines
  PRINT #1, comment$(x)
NEXT x
PRINT #1, lives
PRINT #1, fullgame
IF fullgame = 1 THEN PRINT #1, level
FOR y = 1 TO 20
  FOR x = 1 TO 25
    v = place(x, y)
    v$ = LTRIM$(RTRIM$(STR$(v)))
    IF LEN(v$) = 1 THEN v$ = "0" + v$
    PRINT #1, v$;
  NEXT x
  PRINT #1, ""
NEXT y
PRINT #1, numsprites
FOR x = 0 TO numsprites
  PRINT #1, sprt(x)
  PRINT #1, sprx(x)
  PRINT #1, spry(x)
  PRINT #1, sprd(x)
  PRINT #1, sprr(x)
  PRINT #1, sprm(x)
  PRINT #1, sprmh(x)
  PRINT #1, sprmv(x)
NEXT x

PRINT #1, numsp
FOR x = 1 TO numsp
  PRINT #1, supx(x)
  PRINT #1, supy(x)
  FOR y = 1 TO 10
    PRINT #1, supi(x, y)
  NEXT y
NEXT x

PRINT #1, time1
PRINT #1, time2
PRINT #1, tick
PRINT #1, exodus
PRINT #1, sx
PRINT #1, sy
PRINT #1, fx
PRINT #1, fy

FOR x = 1 TO 12
  PRINT #1, itemn(x)
NEXT x
PRINT #1, isel
CLOSE



END SUB

SUB DoSide
'****************************************************************************
'*Updates the sidebar                                                       *
'****************************************************************************

'**Time Limit**
IF exodus = 0 THEN ti = time1 ELSE ti = time2
timel = ti - tick
LINE (610, 331)-STEP(-60, 8), green, BF
LINE (610, 331)-STEP(-(60 / ti * tick), 8), red, BF


IF isel <> oldisel THEN
  oldisel = isel
  LINE (542, 140)-STEP(15, 115), grey, BF
  LINE (543, (isel - 1) * 14 + 140)-STEP(0, 12), black
  LINE -STEP(6, -6), black
  LINE -STEP(-6, -6), black
  PAINT (544, (isel - 1) * 14 + 144), blue, black
END IF


END SUB

SUB DoSprite (s)
'****************************************************************************
'*Moves all of the sprites                                                  *
'****************************************************************************

    IF sprt(s) = 0 AND sprm(0) = 0 THEN EXIT SUB

    DI = sprd(s)
    py = spry(s)
    px = sprx(s)
 
    IF sprt(s) = 4 OR spry(s) = 2 THEN
      sprr(s) = INT(RND * 4) - 1
    END IF
 
    IF sprt(s) = 2 THEN
      IF exodus > 0 THEN
	closest = 1000
	FOR a = (numsprites - exodus) TO numsprites
	  IF sprm(a) <> -1 THEN
	    IF SQR((sprx(a) ^ 2) + (spry(a) ^ 2)) < closest THEN
	      closestx = sprx(a)
	      closesty = spry(a)
	      closest = SQR((sprx(a) ^ 2) + (spry(a) ^ 2))
	    END IF
	  END IF
	NEXT a
	diffx = closestx - px
	diffy = closesty - py
	IF ABS(diffx) > ABS(diffy) THEN
	  IF ABS(diffx) = diffx THEN DI = 2 ELSE DI = 4
	ELSE
	  IF ABS(diffy) = diffy THEN DI = 3 ELSE DI = 1
	END IF
      ELSE
	a = INT(RND * 100) + 1
	IF a < 5 THEN
	  sprd(s) = a
	  DI = a
	END IF
      END IF
    END IF

    IF DI = 1 THEN
      pt = py - 6
      pb = py + 6
      pl = px - 4
      pr = px + 5
    END IF
  
    IF DI = 2 THEN
      pt = py - 4
      pb = py + 5
      pl = px - 8
      pr = px + 6
    END IF
  
    IF DI = 3 THEN
      pt = py - 6
      pb = py + 5
      pl = px - 4
      pr = px + 5
    END IF
  
    IF DI = 4 THEN
      pt = py - 4
      pb = py + 5
      pl = px - 9
      pr = px + 6
    END IF

    pxi = INT(px / 20)
    pyi = INT((py) / 15)
  
    lx = 0
    ly = 0
    IF pt < (pyi * 15) THEN ly = -1
    IF pb > (pyi * 15) + 15 THEN ly = 1
    IF pl < (pxi * 20) THEN lx = -1
    IF pr > (pxi * 20) + 20 THEN lx = 1
  
  
    IF DI = 1 THEN
      IF DoFree(pxi, INT((pt - 1) / 15), s) = 1 AND DoFree(pxi + lx, INT((pt - 1) / 15), s) = 1 THEN
	py = py - 1
      ELSE
	DI = DI + sprr(s)
      END IF
    END IF
    IF DI = 2 THEN
      IF DoFree(INT((pr + 1) / 20), pyi, s) = 1 AND DoFree(INT((pr + 1) / 20), pyi + ly, s) = 1 THEN
	px = px + 1
      ELSE
	DI = DI + sprr(s)
      END IF
    END IF
    IF DI = 3 THEN
      IF DoFree(pxi, INT((pb + 1) / 15), s) = 1 AND DoFree(pxi + lx, INT((pb + 1) / 15), s) = 1 THEN
	py = py + 1
      ELSE
	DI = DI + sprr(s)
      END IF
    END IF
    IF DI = 4 THEN
      IF DoFree(INT((pl - 1) / 20), pyi, s) = 1 AND DoFree(INT((pr - 1) / 20), pyi + ly, s) = 1 THEN
	px = px - 1
      ELSE
	DI = DI + sprr(s)
      END IF
    END IF

    IF DI > 4 THEN DI = DI - 4
    IF DI < 1 THEN DI = 4 + DI


    sprd(s) = DI
    spry(s) = py
    sprx(s) = px

END SUB

SUB DoTick
'****************************************************************************
'*Hides, moves and redraws all sprites                                     *
'****************************************************************************

IF place(sx, sy) <> 3 THEN place(sx, sy) = 14     '**Stops start/finish squares being destroyed by block
IF place(fx, fy) <> 3 THEN place(fx, fy) = 15

FOR l = 0 TO 1
  CALL DrawHideSprite
  FOR s = 0 TO numsprites
    IF sprm(s) >= 0 THEN
      IF sprd(s) = 1 OR sprd(s) = 3 THEN lim = sprmv(s) ELSE lim = sprmh(s)
      FOR x = 1 TO lim
	IF sprm(s) <> -1 THEN
	  CALL DoSprite(s)
	  CALL DoCheck(s)
	ELSE
	  EXIT SUB
	END IF
      NEXT x
      way = l
      IF sprm(s) <> -1 THEN CALL DrawSprite(s, way)
    END IF
  NEXT s
  PCOPY 1, 0
NEXT l

END SUB

SUB DrawHideSprite
'***************************************************************************
'*Hides all sprites. This is achieved by redrawing all squares which have  *
'*been flagged for redrawing by setting dplace(x,y) = 1 for that square.   *
'***************************************************************************

				     

FOR x = -1 TO 26
  FOR y = -1 TO 21
    IF dplace(x, y) = 1 THEN
      dplace(x, y) = 0
      CALL DrawPlace(x, y)
    END IF
  NEXT y
NEXT x


END SUB

SUB DrawObject (o, x, y)
'***************************************************************************
'*Draws object no. o at x,y (pixels)                                       *
'***************************************************************************
    IF o = -1 THEN LINE (x + 1, y + 1)-STEP(19, 14), bg, BF
    IF o = 0 THEN LINE (x + 1, y + 1)-STEP(19, 14), bg, BF
    IF o = 1 THEN PUT (x, y), block1, PSET
    IF o = 2 THEN PUT (x, y), block2, PSET
    IF o = 3 THEN PUT (x, y), block3, PSET
    IF o = 4 THEN PUT (x, y), block4, PSET
    IF o = 5 THEN PUT (x, y), block5, PSET
    IF o = 6 THEN PUT (x, y), block6, PSET
    IF o = 7 THEN PUT (x, y), block7, PSET
    IF o = 8 THEN PUT (x, y), block8, PSET
    IF o = 9 THEN PUT (x, y), block9, PSET
    IF o = 10 THEN PUT (x, y), block10, PSET
    IF o = 11 THEN PUT (x, y), block11, PSET
    IF o = 12 THEN PUT (x, y), block12, PSET
    IF o = 13 THEN PUT (x, y), block13, PSET
    IF o = 14 THEN PUT (x, y), block14, PSET
    IF o = 15 THEN PUT (x, y), block15, PSET
    IF o = 16 THEN PUT (x, y), block16, PSET
    IF o = 17 THEN PUT (x, y), block17, PSET
    IF o = 18 THEN PUT (x, y), block18, PSET
    IF o = 19 THEN PUT (x, y), block19, PSET
    IF o = 20 THEN PUT (x, y), block20, PSET
    IF o = 21 THEN PUT (x, y), block21, PSET
    IF o = 22 THEN PUT (x, y), block22, PSET
 
 
  



END SUB

SUB DrawPlace (x, y)
'***************************************************************************
'*Redraws the object at place(x,y)                                         *
'***************************************************************************


IF x = 26 THEN                               '**This stops the furthest right squares drawing over the sidebar
  LINE (x * 20, y * 15)-STEP(15, 15), bg, BF
  EXIT SUB
END IF

CALL DrawObject(place(x, y), x * 20, y * 15)

  


END SUB

SUB DrawPopupBox
'******************************************************************************
'*Draws the popup box used for the Ii-game menu and at the start of each level.*
'******************************************************************************

LINE (200, 95)-STEP(220, 163), grey, BF
LINE (200, 95)-STEP(220, 163), black, B
LINE (200, 95)-STEP(220, 0), white
LINE (200, 95)-STEP(0, 163), white

LINE (205, 98)-STEP(210, 157), black, BF
LINE (205, 98)-STEP(210, 157), white, B
LINE (205, 98)-STEP(210, 0), black
LINE (205, 98)-STEP(0, 157), black

END SUB

SUB DrawSide
'***************************************************************************
'*Draws the sidebar                                                        *
'***************************************************************************

LINE (536, 0)-STEP(104, 350), grey, BF
LINE (536, 0)-STEP(104, 350), white, B

CALL LoadImage(538, 0, "images\logo2.spr")

LOCATE 23, 69: PRINT "Time:"
LINE (68 * 8 - 1, 22 * 14 - 1)-STEP(5 * 8 + 1, 15), white, B
LINE (550, 330)-STEP(60, 10), green, BF
LINE (549, 330)-STEP(62, 10), black, B


LOCATE 9, 69: PRINT "ITEMS"
LINE (68 * 8 - 1, 8 * 14 - 1)-STEP(5 * 8 + 1, 15), white, B
CALL DrawObject(9, 560, 139)
CALL DrawObject(1, 619, 153)
CALL DrawObject(20, 619, 181)
CALL DrawObject(6, 560, 195)
CALL DrawObject(5, 619, 209)
CALL DrawObject(4, 560, 223)
CALL DrawObject(7, 619, 237)

FOR y = 0 TO 7
  LOCATE y + 11, 74
  t$ = "["
  IF itemn(y + 1) < 10 THEN t$ = t$ + "0"
  t$ = t$ + LTRIM$(RTRIM$(STR$(itemn(y + 1)))) + "]"
  PRINT t$
NEXT y


FOR y = 0 TO 7
  LINE (583, y * 14 + 139)-STEP(34, 14), white, B
NEXT y

LINE (560, 167)-STEP(20, 15), yellow, BF
LINE (560, 167)-STEP(20, 15), black, B
CIRCLE (572, 177), 6, black
PAINT (572, 177), black
DRAW "ta0 bm 568,173 u l u2 l3"
PSET STEP(0, 0), 4


CALL DrawObject(16, 545, 260)
CALL DrawObject(17, 569, 260)
CALL DrawObject(18, 593, 260)
CALL DrawObject(19, 617, 260)
LOCATE 21, 69: PRINT itemn(9)
LOCATE 21, 72: PRINT itemn(10)
LOCATE 21, 75: PRINT itemn(11)
LOCATE 21, 78: PRINT itemn(12)
LINE (544, 280)-STEP(94, 13), white, B
FOR x = 1 TO 3
  LINE (544 + x * 24, 280)-STEP(0, 13), white
NEXT x


FOR z = 0 TO lives - 1
  PUT (550 + z * 26, 64), antsn, AND
  PUT (550 + z * 26, 64), Ants, OR
NEXT z


LINE (0, 331)-STEP(540, 20), grey, BF
LINE (0, 331)-STEP(536, 0), white

LOCATE 25, 3: PRINT title$;
LOCATE 25, 25: PRINT "Esc = Menu";
LOCATE 25, 40
IF exodus = 0 THEN
  PRINT "F10 = Release Princesses";
ELSE
  PRINT "Princesses are released.";
END IF

LINE (2 * 8 - 2, 336)-STEP(LEN(title$) * 8 + 3, 13), white, B
LINE (24 * 8 - 2, 336)-STEP(10 * 8 + 3, 13), white, B
LINE (39 * 8 - 2, 336)-STEP(24 * 8 + 3, 13), white, B
 
oldisel = -1        '**Causes arrow to be redrawn
CALL DoSide



END SUB

SUB DrawSprite (c, w)
'***************************************************************************
'*Draws sprite no. c.  w  can be set to 1 or 0 and refers to the position  *
'*of the feet/wings. By flipping between 1 and 0 a walking/flying affect is*
'*achieved                                                                 *
'***************************************************************************

t = sprt(c)
x = sprx(c)
y = spry(c)
D = sprd(c)

dx = x - 10
dy = y - 7
dx = x - 10
dy = y - 7

IF w = 1 AND sprm(c) = 0 THEN w = 0

IF t = 0 THEN
  IF w = 0 THEN
    IF D = 1 THEN
      PUT (dx, dy), antun, AND
      PUT (dx, dy), antu, OR
    END IF
    IF D = 2 THEN
      PUT (dx, dy), antrn, AND
      PUT (dx, dy), antr, OR
    END IF
    IF D = 3 THEN
      PUT (dx, dy), antdn, AND
      PUT (dx, dy), antd, OR
    END IF
    IF D = 4 THEN
      PUT (dx, dy), antln, AND
      PUT (dx, dy), antl, OR
    END IF
  ELSE
    IF D = 1 THEN
      PUT (dx, dy), antun2, AND
      PUT (dx, dy), antu2, OR
    END IF
    IF D = 2 THEN
      PUT (dx, dy), antrn2, AND
      PUT (dx, dy), antr2, OR
    END IF
    IF D = 3 THEN
      PUT (dx, dy), antdn2, AND
      PUT (dx, dy), antd2, OR
    END IF
    IF D = 4 THEN
      PUT (dx, dy), antln2, AND
      PUT (dx, dy), antl2, OR
    END IF
  END IF
END IF

IF t = 1 THEN
  IF w = 0 THEN
    IF D = 1 THEN
      PUT (dx, dy), spiun, AND
      PUT (dx, dy), spiu, OR
    END IF
    IF D = 2 THEN
      PUT (dx, dy), spirn, AND
      PUT (dx, dy), spir, OR
    END IF
    IF D = 3 THEN
      PUT (dx, dy), spidn, AND
      PUT (dx, dy), spid, OR
    END IF
    IF D = 4 THEN
      PUT (dx, dy), spiln, AND
      PUT (dx, dy), spil, OR
    END IF
  ELSE
    IF D = 1 THEN
      PUT (dx, dy), spiun2, AND
      PUT (dx, dy), spiu2, OR
    END IF
    IF D = 2 THEN
      PUT (dx, dy), spirn2, AND
      PUT (dx, dy), spir2, OR
    END IF
    IF D = 3 THEN
      PUT (dx, dy), spidn2, AND
      PUT (dx, dy), spid2, OR
    END IF
    IF D = 4 THEN
      PUT (dx, dy), spiln2, AND
      PUT (dx, dy), spil2, OR
    END IF
  END IF
END IF

IF t = 2 THEN
  IF w = 0 THEN
    IF D = 1 THEN
      PUT (dx, dy), waspun, AND
      PUT (dx, dy), waspu, OR
    END IF
    IF D = 2 THEN
      PUT (dx, dy), wasprn, AND
      PUT (dx, dy), waspr, OR
    END IF
    IF D = 3 THEN
      PUT (dx, dy), waspdn, AND
      PUT (dx, dy), waspd, OR
    END IF
    IF D = 4 THEN
      PUT (dx, dy), waspln, AND
      PUT (dx, dy), waspl, OR
    END IF
  ELSE
    IF D = 1 THEN
      PUT (dx, dy), waspun2, AND
      PUT (dx, dy), waspu2, OR
    END IF
    IF D = 2 THEN
      PUT (dx, dy), wasprn2, AND
      PUT (dx, dy), waspr2, OR
    END IF
    IF D = 3 THEN
      PUT (dx, dy), waspdn2, AND
      PUT (dx, dy), waspd2, OR
    END IF
    IF D = 4 THEN
      PUT (dx, dy), waspln2, AND
      PUT (dx, dy), waspl2, OR
    END IF
  END IF
END IF

IF t = 3 THEN
  IF w = 0 THEN
    IF D = 1 THEN
      PUT (dx, dy), antun, AND
      PUT (dx, dy), redu, OR
    END IF
    IF D = 2 THEN
      PUT (dx, dy), antrn, AND
      PUT (dx, dy), redr, OR
    END IF
    IF D = 3 THEN
      PUT (dx, dy), antdn, AND
      PUT (dx, dy), redd, OR
    END IF
    IF D = 4 THEN
      PUT (dx, dy), antln, AND
      PUT (dx, dy), redl, OR
    END IF
  ELSE
    IF D = 1 THEN
      PUT (dx, dy), antun2, AND
      PUT (dx, dy), redu2, OR
    END IF
    IF D = 2 THEN
      PUT (dx, dy), antrn2, AND
      PUT (dx, dy), redr2, OR
    END IF
    IF D = 3 THEN
      PUT (dx, dy), antdn2, AND
      PUT (dx, dy), redd2, OR
    END IF
    IF D = 4 THEN
      PUT (dx, dy), antln2, AND
      PUT (dx, dy), redl2, OR
    END IF
  END IF
END IF

IF t = 4 THEN
  IF w = 0 THEN
    IF D = 1 THEN
      PUT (dx, dy), flierun, AND
      PUT (dx, dy), flieru, OR
    END IF
    IF D = 2 THEN
      PUT (dx, dy), FLIERrn, AND
      PUT (dx, dy), FLIERr, OR
    END IF
    IF D = 3 THEN
      PUT (dx, dy), FLIERdn, AND
      PUT (dx, dy), FLIERd, OR
    END IF
    IF D = 4 THEN
      PUT (dx, dy), FLIERln, AND
      PUT (dx, dy), FLIERl, OR
    END IF
  ELSE
    IF D = 1 THEN
      PUT (dx, dy), FLIERun2, AND
      PUT (dx, dy), FLIERu2, OR
    END IF
    IF D = 2 THEN
      PUT (dx, dy), FLIERrn2, AND
      PUT (dx, dy), FLIERr2, OR
    END IF
    IF D = 3 THEN
      PUT (dx, dy), FLIERdn2, AND
      PUT (dx, dy), FLIERd2, OR
    END IF
    IF D = 4 THEN
      PUT (dx, dy), FLIERln2, AND
      PUT (dx, dy), FLIERl2, OR
    END IF
  END IF
END IF

xi = INT(x / 20)
yi = INT(y / 15)
x2 = 20 * xi + 10
y2 = 15 * yi + 8
dplace(xi, yi) = 1
IF y < y2 THEN dplace(xi, yi - 1) = 1
IF y > y2 THEN dplace(xi, yi + 1) = 1
IF x < x2 THEN dplace(xi - 1, yi) = 1
IF x > x2 THEN dplace(xi + 1, yi) = 1
IF y < y2 AND x < x2 THEN dplace(xi - 1, yi - 1) = 1
IF y > y2 AND x < x2 THEN dplace(xi - 1, yi + 1) = 1
IF y < y2 AND x > x2 THEN dplace(xi + 1, yi - 1) = 1
IF y > y2 AND x > x2 THEN dplace(xi + 1, yi + 1) = 1


END SUB

SUB DrawWorld
'***************************************************************************
'*Draws the map currently loaded in memory                                 *
'***************************************************************************


'w = 25
'h = 20
FOR x = 1 TO 25 STEP 1
  FOR y = 1 TO 20 STEP 1
    CALL DrawPlace(x, y)
  NEXT y
NEXT x





END SUB

SUB InitMain
'***************************************************************************
'*General init.*
'***************************************************************************

FOR x = 0 TO 26
  FOR y = 0 TO 21
    place(x, y) = -1
  NEXT y
NEXT x
RANDOMIZE TIMER
END SUB

SUB InitObjects
'***************************************************************************
'*Captures all objects                                                     *
'***************************************************************************


SCREEN , , 1, 0

LINE (0, 0)-STEP(20, 15), yellow, BF
LINE (0, 0)-STEP(20, 15), black, B
GET (0, 0)-STEP(20, 15), block1        '**BLANK

LINE (0, 0)-STEP(20, 15), grey, BF
LINE (0, 0)-STEP(20, 15), black, B
LINE (1, 1)-STEP(18, 13), dgrey, B
LINE (1, 1)-STEP(18, 0), white
LINE (1, 1)-STEP(0, 13), white
GET (0, 0)-STEP(20, 15), block2        '**STONE

LINE (0, 0)-STEP(20, 15), Brown, BF
LINE (0, 0)-STEP(20, 15), black, B
LINE (1, 1)-STEP(18, 13), dgrey, B
LINE (1, 1)-STEP(18, 0), white
LINE (1, 1)-STEP(0, 13), white
GET (0, 0)-STEP(20, 15), block3        '**Brick

LINE (0, 0)-STEP(20, 15), yellow, BF
LINE (0, 0)-STEP(20, 15), black, B
DRAW "BM7,3 D5 L3 F5 E5 L3 U5 L3"
PAINT (8, 4), red, black
GET (0, 0)-STEP(20, 15), block4        '**DOWN ARROW

LINE (0, 0)-STEP(20, 15), yellow, BF
LINE (0, 0)-STEP(20, 15), black, B
DRAW "TA90 BM3,9 D5 L3 F5 E5 L3 U5 L3"
PAINT (4, 7), red, black
GET (0, 0)-STEP(20, 15), block5        '**RIGHT ARROW**

LINE (0, 0)-STEP(20, 15), yellow, BF
LINE (0, 0)-STEP(20, 15), black, B
DRAW "TA180 BM12,12 D5 L3 F5 E5 L3 U5 L3"
PAINT (10, 8), red, black
GET (0, 0)-STEP(20, 15), block6        '**UP ARROW**

LINE (0, 0)-STEP(20, 15), yellow, BF
LINE (0, 0)-STEP(20, 15), black, B
DRAW "TA270 BM16,6 D5 L3 F5 E5 L3 U5 L3"
PAINT (10, 8), red, black
GET (0, 0)-STEP(20, 15), block7        '**LEFT ARROW

LINE (0, 0)-STEP(20, 15), yellow, BF
LINE (0, 0)-STEP(20, 15), black, B
CIRCLE (10, 7), 7, black
PAINT (10, 7), bg, black
GET (0, 0)-STEP(20, 15), block8        '**HOLE

LINE (1, 1)-STEP(18, 13), yellow, BF
CIRCLE (10, 7), 7, black
PAINT (10, 7), bg, black
FOR x = 1 TO 19 STEP 2
  LINE (x, 1)-STEP(0, 13), grey
NEXT x
FOR y = 1 TO 14 STEP 2
  LINE (1, y)-STEP(18, 0), grey
NEXT y

GET (0, 0)-STEP(20, 15), block9        '**GRATED HOLE

LINE (0, 0)-STEP(20, 15), red, BF
LINE (0, 0)-STEP(20, 15), black, B
LINE (1, 1)-STEP(18, 13), dgrey, B
LINE (1, 1)-STEP(17, 0), white
LINE (1, 1)-STEP(0, 12), white
CIRCLE (10, 8), 4, black
PAINT (10, 8), yellow, black
GET (0, 0)-STEP(20, 15), block10        '**Yellow Lock**


LINE (0, 0)-STEP(20, 15), red, BF
LINE (0, 0)-STEP(20, 15), black, B
LINE (1, 1)-STEP(18, 13), dgrey, B
LINE (1, 1)-STEP(17, 0), white
LINE (1, 1)-STEP(0, 12), white
CIRCLE (10, 8), 4, black
PAINT (10, 8), blue, black
GET (0, 0)-STEP(20, 15), block11        '**Blue Lock**

LINE (0, 0)-STEP(20, 15), red, BF
LINE (0, 0)-STEP(20, 15), black, B
LINE (1, 1)-STEP(18, 13), dgrey, B
LINE (1, 1)-STEP(17, 0), white
LINE (1, 1)-STEP(0, 12), white
CIRCLE (10, 8), 4, black
PAINT (10, 8), green, black
GET (0, 0)-STEP(20, 15), block12        '**Green Lock**

LINE (0, 0)-STEP(20, 15), red, BF
LINE (0, 0)-STEP(20, 15), black, B
LINE (1, 1)-STEP(18, 13), dgrey, B
LINE (1, 1)-STEP(17, 0), white
LINE (1, 1)-STEP(0, 12), white
CIRCLE (10, 8), 4, black
PAINT (10, 8), white, black
GET (0, 0)-STEP(20, 15), block13        '**White Lock**

LINE (0, 0)-STEP(100, 100), 0, BF

COLOR green
LOCATE 2, 2: PRINT "S"
LINE (2, 14)-STEP(18, 13), green, B
PAINT (3, 15), yellow, green
LINE (2, 14)-STEP(18, 13), yellow, B
GET (1, 13)-STEP(20, 15), block14      '**Start square**

LINE (0, 0)-STEP(100, 100), 0, BF

COLOR red
LOCATE 2, 2: PRINT "F"
LINE (2, 14)-STEP(18, 13), red, B
PAINT (3, 15), yellow, red
LINE (2, 14)-STEP(18, 13), yellow, B
GET (1, 13)-STEP(20, 15), block15      '**End square**


LINE (0, 0)-STEP(20, 15), yellow, BF
LINE (0, 0)-STEP(20, 15), black, B
LINE (14, 4)-STEP(3, 6), yellow, BF
LINE (14, 4)-STEP(3, 6), black, B
LINE (4, 6)-STEP(10, 2), yellow, BF
LINE (4, 6)-STEP(10, 2), black, B
DRAW "ta0 bm 4,8 d2 r2 u r2 d1 r2 u r2 u"
GET (0, 0)-STEP(20, 15), block16        '**Yellow key

LINE (0, 0)-STEP(20, 15), yellow, BF
LINE (0, 0)-STEP(20, 15), black, B
LINE (14, 4)-STEP(3, 6), blue, BF
LINE (14, 4)-STEP(3, 6), black, B
LINE (4, 6)-STEP(10, 2), blue, BF
LINE (4, 6)-STEP(10, 2), black, B
DRAW "ta0 bm 4,8 d2 r2 u r2 d1 r2 u r2 u"
GET (0, 0)-STEP(20, 15), block17        '**Blue key

LINE (0, 0)-STEP(20, 15), yellow, BF
LINE (0, 0)-STEP(20, 15), black, B
LINE (14, 4)-STEP(3, 6), green, BF
LINE (14, 4)-STEP(3, 6), black, B
LINE (4, 6)-STEP(10, 2), green, BF
LINE (4, 6)-STEP(10, 2), black, B
DRAW "ta0 bm 4,8 d2 r2 u r2 d1 r2 u r2 u"
GET (0, 0)-STEP(20, 15), block18        '**Green key

LINE (0, 0)-STEP(20, 15), yellow, BF
LINE (0, 0)-STEP(20, 15), black, B
LINE (14, 4)-STEP(3, 6), white, BF
LINE (14, 4)-STEP(3, 6), black, B
LINE (4, 6)-STEP(10, 2), white, BF
LINE (4, 6)-STEP(10, 2), black, B
DRAW "ta0 bm 4,8 d2 r2 u r2 d1 r2 u r2 u"
GET (0, 0)-STEP(20, 15), block19        '**White key

LINE (0, 0)-STEP(20, 15), yellow, BF
LINE (0, 0)-STEP(20, 15), black, B
CIRCLE (10, 7), 4, black
PAINT (10, 7), black
GET (0, 0)-STEP(20, 15), block20        '**Mined

LINE (0, 0)-STEP(20, 15), yellow, BF
LINE (0, 0)-STEP(20, 15), black, B
LINE (10, 7)-STEP(9, 3), grey
LINE (10, 7)-STEP(-9, 1), grey
LINE (10, 7)-STEP(-2, -6), grey
LINE (10, 7)-STEP(-1, 7), grey
CIRCLE (10, 7), 2, grey
CIRCLE (10, 7), 5, grey
CIRCLE (10, 7), 8, grey
CIRCLE (10, 7), 11, grey
LINE (0, 0)-STEP(20, 15), black, B
GET (0, 0)-STEP(20, 15), block21        '**Web

LINE (0, 0)-STEP(20, 15), yellow, BF
LINE (0, 0)-STEP(20, 15), black, B
LINE (6, 4)-STEP(4, 2), black, BF
LINE (10, 7)-STEP(4, 4), black, BF
CIRCLE (6, 10), 4, black
PAINT (6, 10), Brown, black

GET (0, 0)-STEP(20, 15), block22        '**Supply dump






'16- 19 = keys
'20 = mined
SCREEN , , 0, 0



END SUB

SUB InitSprites
'***************************************************************************
'*Captures all sprites                                                     *
'***************************************************************************


SCREEN , , 1, 0
'**Load Ant***
CALL LoadImage(0, 0, "images\ant.spr")

GET (0, 0)-STEP(19, 13), antr
GET (20, 0)-STEP(19, 13), antl
GET (40, 0)-STEP(19, 13), antu
GET (60, 0)-STEP(19, 13), antd
GET (0, 14)-STEP(19, 13), antr2
GET (20, 14)-STEP(19, 13), antl2
GET (40, 14)-STEP(19, 13), antu2
GET (60, 14)-STEP(19, 13), antd2

FOR x = 0 TO 79
  FOR y = 0 TO 27
    IF POINT(x, y) = 2 THEN PSET (x, y), 4
  NEXT y
NEXT x
GET (0, 0)-STEP(19, 13), redr
GET (20, 0)-STEP(19, 13), redl
GET (40, 0)-STEP(19, 13), redu
GET (60, 0)-STEP(19, 13), redd
GET (0, 14)-STEP(19, 13), redr2
GET (20, 14)-STEP(19, 13), redl2
GET (40, 14)-STEP(19, 13), redu2
GET (60, 14)-STEP(19, 13), redd2


FOR x = 0 TO 79
  FOR y = 0 TO 27
    IF POINT(x, y) = 0 THEN
      PSET (x, y), 15
    ELSE
      PSET (x, y), 0
    END IF
  NEXT y
NEXT x
GET (0, 0)-STEP(19, 13), antrn
GET (20, 0)-STEP(19, 13), antln
GET (40, 0)-STEP(19, 13), antun
GET (60, 0)-STEP(19, 13), antdn
GET (0, 14)-STEP(19, 13), antrn2
GET (20, 14)-STEP(19, 13), antln2
GET (40, 14)-STEP(19, 13), antun2
GET (60, 14)-STEP(19, 13), antdn2

GET (0, 0)-STEP(19, 13), redrn
GET (20, 0)-STEP(19, 13), redln
GET (40, 0)-STEP(19, 13), redun
GET (60, 0)-STEP(19, 13), reddn
GET (0, 14)-STEP(19, 13), redrn2
GET (20, 14)-STEP(19, 13), redln2
GET (40, 14)-STEP(19, 13), redun2
GET (60, 14)-STEP(19, 13), reddn2


'**Load Spider**
CALL LoadImage(0, 0, "images\spider.spr")
GET (0, 0)-STEP(19, 13), spir
GET (20, 0)-STEP(19, 13), spil
GET (40, 0)-STEP(19, 13), spid
GET (60, 0)-STEP(19, 13), spiu
GET (0, 14)-STEP(19, 13), spir2
GET (20, 14)-STEP(19, 13), spil2
GET (40, 14)-STEP(19, 13), spid2
GET (60, 14)-STEP(19, 13), spiu2
FOR x = 0 TO 79
  FOR y = 0 TO 27
    IF POINT(x, y) = 0 THEN
      PSET (x, y), 15
    ELSE
      PSET (x, y), 0
    END IF
  NEXT y
NEXT x
GET (0, 0)-STEP(19, 13), spirn
GET (20, 0)-STEP(19, 13), spiln
GET (40, 0)-STEP(19, 13), spidn
GET (60, 0)-STEP(19, 13), spiun
GET (0, 14)-STEP(19, 13), spirn2
GET (20, 14)-STEP(19, 13), spiln2
GET (40, 14)-STEP(19, 13), spidn2
GET (60, 14)-STEP(19, 13), spiun2


'**Load FLIER**
CALL LoadImage(0, 0, "images\flier.spr")
GET (0, 0)-STEP(19, 13), FLIERr
GET (20, 0)-STEP(19, 13), FLIERl
GET (40, 0)-STEP(19, 13), FLIERd
GET (60, 0)-STEP(19, 13), flieru
GET (0, 14)-STEP(19, 13), FLIERr2
GET (20, 14)-STEP(19, 13), FLIERl2
GET (40, 14)-STEP(19, 13), FLIERd2
GET (60, 14)-STEP(19, 13), FLIERu2
FOR x = 0 TO 79
  FOR y = 0 TO 27
    IF POINT(x, y) = 0 THEN
      PSET (x, y), 15
    ELSE
      PSET (x, y), 0
    END IF
  NEXT y
NEXT x
GET (0, 0)-STEP(19, 13), FLIERrn
GET (20, 0)-STEP(19, 13), FLIERln
GET (40, 0)-STEP(19, 13), FLIERdn
GET (60, 0)-STEP(19, 13), flierun
GET (0, 14)-STEP(19, 13), FLIERrn2
GET (20, 14)-STEP(19, 13), FLIERln2
GET (40, 14)-STEP(19, 13), FLIERdn2
GET (60, 14)-STEP(19, 13), FLIERun2



'**Load Wasp**
CALL LoadImage(0, 0, "images\wasp.spr")
GET (0, 0)-STEP(19, 13), waspr
GET (20, 0)-STEP(19, 13), waspl
GET (40, 0)-STEP(19, 13), waspd
GET (60, 0)-STEP(19, 13), waspu
GET (0, 14)-STEP(19, 13), waspr2
GET (20, 14)-STEP(19, 13), waspl2
GET (40, 14)-STEP(19, 13), waspd2
GET (60, 14)-STEP(19, 13), waspu2
FOR x = 0 TO 79
  FOR y = 0 TO 27
    IF POINT(x, y) = 0 THEN
      PSET (x, y), 15
    ELSE
      PSET (x, y), 0
    END IF
  NEXT y
NEXT x
GET (0, 0)-STEP(19, 13), wasprn
GET (20, 0)-STEP(19, 13), waspln
GET (40, 0)-STEP(19, 13), waspdn
GET (60, 0)-STEP(19, 13), waspun
GET (0, 14)-STEP(19, 13), wasprn2
GET (20, 14)-STEP(19, 13), waspln2
GET (40, 14)-STEP(19, 13), waspdn2
GET (60, 14)-STEP(19, 13), waspun2


'**Load Life ant*****
CALL LoadImage(0, 0, "images\ants.spr")
GET (0, 0)-STEP(19, 35), Ants

FOR x = 0 TO 31
  FOR y = 0 TO 35
    IF POINT(x, y) = 0 THEN
      PSET (x, y), 15
    ELSE
      PSET (x, y), 0
    END IF
  NEXT y
NEXT x
GET (0, 0)-STEP(19, 35), antsn

'******Load Flying ant for credits***
CALL LoadImage(0, 0, "images\flier2.spr")
GET (0, 0)-STEP(19, 13), flier2
FOR x = 0 TO 31
  FOR y = 0 TO 35
    IF POINT(x, y) = 0 THEN
      PSET (x, y), 15
    ELSE
      PSET (x, y), 0
    END IF
  NEXT y
NEXT x
GET (0, 0)-STEP(19, 13), flier2n


SCREEN , , 0, 0


END SUB

SUB InitWorld (file$)
'***************************************************************************
'*Loads map data from file$ and sets init variables                        *
'***************************************************************************
 
numsprites = 0
numsp = 0
isel = 1
exodus = 0
sprmh(0) = 6
sprmv(0) = 4
sprm(0) = 0
sprt(0) = 0
sprd(0) = 3
safe = 0
tick = 0

FOR x = 1 TO 15
  itemn(x) = 0
NEXT x

OPEN file$ FOR INPUT AS #1
LINE INPUT #1, top$
LINE INPUT #1, version$
LINE INPUT #1, title$
LINE INPUT #1, author$
LINE INPUT #1, datew$

FOR y = 1 TO 20
  LINE INPUT #1, lin$
  FOR x = 1 TO 50 STEP 2
    place((x + 1) / 2, y) = VAL(MID$(lin$, x, 2))
    IF place((x + 1) / 2, y) = 14 THEN
      sprx(0) = (x + 1) / 2 * 20 + 10
      spry(0) = y * 15 + 8
    END IF
  NEXT x
NEXT y

INPUT #1, numsprites
FOR x = 1 TO numsprites
  INPUT #1, sprt(x)
  INPUT #1, x2
  sprx(x) = x2 * 20 + 10
  INPUT #1, y2
  spry(x) = y2 * 15 + 8
  INPUT #1, sprd(x)
  INPUT #1, sprr(x)
  IF sprt(x) = 1 THEN
    sprmh(x) = 3
    sprmv(x) = 2
  END IF
  IF sprt(x) = 2 THEN
    sprmh(x) = 10
    sprmv(x) = 7
  END IF
  IF sprt(x) = 3 THEN
    sprmh(x) = 3
    sprmv(x) = 2
  END IF
  sprm(x) = 1
NEXT x
INPUT #1, numsp
FOR x = 1 TO numsp
  INPUT #1, supx(x)
  INPUT #1, supy(x)
  FOR y = 1 TO 10
    INPUT #1, supi(x, y)
  NEXT y
NEXT x

INPUT #1, time1
INPUT #1, time2

CLOSE #1
FOR x = 1 TO 25
  FOR y = 1 TO 20
    IF place(x, y) = 14 THEN
      sx = x
      sy = y
    END IF
    IF place(x, y) = 15 THEN
      fx = x
      fy = y
    END IF
  NEXT y
NEXT x

IF title$ = "" THEN title$ = "Untitled"


END SUB

REM $DYNAMIC
FUNCTION InternalBitRead% (Variable%, BitNum%)
'***************************************************************************
'*From QMIDI by Jesse Dorland                                              *
'***************************************************************************

VarSegment% = VARSEG(Variable%)
offset% = VARPTR(Variable%)
DEF SEG = VarSegment%
InternalBitRead% = -((PEEK(offset% + BitNum% \ 8) AND 2 ^ (BitNum% MOD 8)) > 0)
DEF SEG

END FUNCTION

SUB InternalBitSet (Variable%, BitNum%, OnOff%)
'***************************************************************************
'*From QMIDI by Jesse Dorland                                              *
'***************************************************************************

VarSegment% = VARSEG(Variable%)
offset% = VARPTR(Variable%)
DEF SEG = VarSegment%
IF OnOff% THEN
	POKE offset% + BitNum% \ 8, PEEK(offset% + BitNum% \ 8) OR 2 ^ (BitNum% MOD 8)
ELSE
	POKE offset% + BitNum% \ 8, PEEK(offset% + BitNum% \ 8) AND 255 - 2 ^ (BitNum% MOD 8)
END IF
DEF SEG
END SUB

SUB InternalBitToggle (Variable%, BitNum%)
'***************************************************************************
'*From QMIDI by Jesse Dorland                                              *
'***************************************************************************

VarSegment% = VARSEG(Variable%)
offset% = VARPTR(Variable%)
DEF SEG = VarSegment%
POKE offset% + BitNum% \ 8, PEEK(offset% + BitNum% \ 8) XOR 2 ^ (BitNum% MOD 8)
DEF SEG
END SUB

SUB InternalGetIntVector (IntNum%, segment&, offset&)
'***************************************************************************
'*From QMIDI by Jesse Dorland                                              *
'***************************************************************************

QMIDIRegs.AX = IntNum% + 13568
CALL IntX(&H21, QMIDIRegs)
segment& = QMIDIRegs.ES
offset& = QMIDIRegs.BX
END SUB

REM $STATIC
SUB IntX (IntNum AS INTEGER, Regs AS Registers) STATIC
'***************************************************************************
'*From QMIDI by Jesse Dorland                                              *
'***************************************************************************

STATIC filenum AS INTEGER, IntOffset AS INTEGER, Loaded AS INTEGER
		   
	' use fixed-length string to fix its position in memory
	' and so we don't mess up string pool before routine
	' gets its pointers from caller

DIM IntCode AS STRING * 200
IF NOT Loaded THEN                     ' loaded will be 0 first time
	RESTORE IntXCodeData:
   
	FOR k% = 1 TO 145
		READ h%
		MID$(IntCode, k%, 1) = CHR$(h%)
	NEXT

	'  determine address of interrupt no. offset in IntCode
  
	IntOffset% = INSTR(IntCode$, CHR$(&HCD) + CHR$(&H21)) + 1
	Loaded% = -1
END IF

SELECT CASE IntNum
  
	CASE &H25, &H26, IS > 255               ' ignore these interrupts
  
	CASE ELSE
		DEF SEG = VARSEG(IntCode)             ' poke interrupt number into
		POKE VARPTR(IntCode) * 1& + IntOffset - 1, IntNum     ' code block
		CALL ABSOLUTE(Regs, VARPTR(IntCode$))               ' call routine
END SELECT

END SUB

SUB LoadImage (x, y, file$)

DIM getscreen(5000)
segment = VARSEG(getscreen(0))
offset = VARPTR(getscreen(0))
DEF SEG = segment
BLOAD file$, offset
PUT (x, y), getscreen, PSET


END SUB

FUNCTION LTS$ (text)
'*Returns timmed string from numeric data

LTS$ = LTRIM$(RTRIM$(STR$(text)))


END FUNCTION

REM $DYNAMIC
'***************************************************************************
'*From QMIDI by Jesse Dorland                                              *
'***************************************************************************
'MIDIload - loads a MIDI file into memory
FUNCTION MIDIload% (Filename$)
MIDIload% = -1
'See if an extension was supplied, and if not, add one.
IF INSTR(Filename$, ".") = 0 THEN Filename$ = Filename$ + ".MID"
'Open the file
FF% = FREEFILE
OPEN Filename$ FOR BINARY AS #FF%
FileLen& = LOF(FF%)
CLOSE #FF%
'If the file is empty, delete it and exit now.
IF FileLen& = 0 THEN KILL Filename$: MIDI.ERROR = 1: EXIT FUNCTION
'Make the filename an ASCIIZ string.
Filename$ = Filename$ + CHR$(0)

'Find an empty MIDI handle
NewHandle% = -1
'FOR I% = 0 TO 255
'        IF MEM.SEGMENT(I%) = 0 THEN NewHandle% = I%: EXIT FOR
'NEXT I%
NewHandle% = 0
'If there are no empty handles, return an error.
IF NewHandle% = -1 THEN MIDI.ERROR = 12: EXIT FUNCTION
'Attempt to allocate a block of conventional memory.
QMIDIRegs.AX = &H4800
QMIDIRegs.BX = (FileLen& \ 16) + 1
CALL IntX(&H21, QMIDIRegs)
'If the block couldn't be allocated, it means there's not enough free
'memory.  To fix this, we need to ask BASIC to release some of the memory
'it's using:
IF QMIDIRegs.AX = 7 OR QMIDIRegs.AX = 8 THEN
	'Find out how much memory is available, in kilobytes.
	LargestBlock& = QMIDIRegs.BX
	LargestBlock& = LargestBlock& * 16
	'Calculate the amount of memory that BASIC needs to release for us.
	MEM.ALLOCATED(NewHandle%) = (FileLen& + 2048) - LargestBlock&
	'Attempt to release the memory.
	a& = SETMEM(-MEM.ALLOCATED(NewHandle%))
	'Try again to allocate a block of memory
	QMIDIRegs.AX = &H4800
	QMIDIRegs.BX = (FileLen& \ 16) + 1
	CALL IntX(&H21, QMIDIRegs)
	'If the second attempt was unsuccessful, then there just isn't
	'enough memory, and an error needs to be returned.
	IF QMIDIRegs.AX = 7 OR QMIDIRegs.AX = 8 THEN
		'Give any memory we took back to BASIC.
		a& = SETMEM(650000)
		'Return an error.
		MIDI.ERROR = 2
		MEM.SEGMENT(NewHandle%) = 0
		'Abort.
		EXIT FUNCTION
	END IF
END IF
'If the memory was allocated successfully, store the segment
'of the memory block.
MEM.SEGMENT(NewHandle%) = QMIDIRegs.AX
MIDISegment& = QMIDIRegs.AX

'Open the MIDI file using a DOS interrupt.
QMIDIRegs.AX = &H3D00
QMIDIRegs.dx = SADD(Filename$)
QMIDIRegs.DS = VARSEG(Filename$)
CALL IntX(&H21, QMIDIRegs)
'Store the file handle.
Handle% = QMIDIRegs.AX
'Read the data from the file in 16 kilobyte increments.
FOR I& = 1 TO FileLen& STEP 16384
	QMIDIRegs.AX = &H3F00
	QMIDIRegs.CX = 16384
	QMIDIRegs.dx = 0
	QMIDIRegs.DS = VAL("&H" + HEX$(MIDISegment&))
	QMIDIRegs.BX = Handle%
	CALL IntX(&H21, QMIDIRegs)
	MIDISegment& = MIDISegment& + 1024
NEXT I&

'Close the file
QMIDIRegs.AX = &H3E00
QMIDIRegs.BX = Handle%
CALL IntX(&H21, QMIDIRegs)

MIDI.ERROR = 0
MIDIload% = NewHandle%
END FUNCTION

REM $STATIC
SUB MIDIloop
'***************************************************************************
'*From QMIDI by Jesse Dorland                                              *
'***************************************************************************

IF SBMIDI.INTERRUPT < &H80 AND SENSITIVE <> 0 THEN MIDI.ERROR = 4: EXIT SUB
QMIDIRegs.BX = 11
CALL IntX(SBMIDI.INTERRUPT, QMIDIRegs)
IF QMIDIRegs.AX = 0 THEN MIDIplay CURRENTHANDLE
END SUB

REM $DYNAMIC
'***************************************************************************
'*From QMIDI by Jesse Dorland                                              *
'***************************************************************************
'MIDIplay - Begins playing a MIDI file in the background.
SUB MIDIplay (Handle%)
IF Handle% < 0 OR Handle% > 255 THEN MIDI.ERROR = 13: EXIT SUB
IF SBMIDI.INTERRUPT < &H80 AND SENSITIVE <> 0 THEN MIDI.ERROR = 4: EXIT SUB
'If sound is not disabled....
IF SOUND.DISABLED = 0 THEN
	'Call the SBMIDI driver to begin playing the MIDI file.
	QMIDIRegs.BX = 4
	QMIDIRegs.dx = MEM.SEGMENT(Handle%)
	QMIDIRegs.AX = 0
	CALL IntX(SBMIDI.INTERRUPT, QMIDIRegs)
	QMIDIRegs.BX = 5
	CALL IntX(SBMIDI.INTERRUPT, QMIDIRegs)
	'If the music could not be started, return an error.
	IF QMIDIRegs.AX <> 0 THEN MIDI.ERROR = 11: EXIT SUB
	'Start the MIDI timer.
	MIDI.PLAYTIME = TIMER
	'Set the current handle.
	CURRENTHANDLE = Handle%
END IF
MIDI.ERROR = 0
END SUB

'***************************************************************************
'*From QMIDI by Jesse Dorland                                              *
'***************************************************************************
'MIDIstop - Stops playing MIDI file
SUB MIDIStop

midiplaying = 0            '**Added by Michael Hughes

IF SBMIDI.INTERRUPT < &H80 AND SENSITIVE <> 0 THEN MIDI.ERROR = 4: EXIT SUB
'Call the SBMIDI driver to stop the music.
IF MIDI.PLAYTIME THEN
	QMIDIRegs.BX = 4
	QMIDIRegs.dx = MEM.SEGMENT(CURRENTHANDLE)
	QMIDIRegs.AX = 0
	CALL IntX(SBMIDI.INTERRUPT, QMIDIRegs)
	MIDI.ERROR = 0
ELSE
	MIDI.ERROR = 3
END IF
MIDI.PLAYTIME = 0
END SUB

REM $STATIC
SUB MIDIUnload (Handle%)
'***************************************************************************
'*From QMIDI by Jesse Dorland                                              *
'***************************************************************************

IF Handle% < 0 OR Handle% > 255 THEN MIDI.ERROR = 13: EXIT SUB
'If a block of memory was allocated to hold the MIDI file....
IF MEM.SEGMENT(Handle%) THEN
	'Release the block of memory.
	QMIDIRegs.ES = MEM.SEGMENT(Handle%)
	QMIDIRegs.AX = &H4900
	CALL IntX(&H21, QMIDIRegs)
	'Give back all the memory we took from BASIC.
	a& = SETMEM(650000)
END IF
MEM.SEGMENT(Handle%) = 0
MEM.ALLOCATED(Handle%) = 0
MIDI.ERROR = 0

END SUB

DEFINT I, O
SUB Palette.FadeIn
'***************************************************************************
'*From FADE.BAS by Manny Najera                                            *
'***************************************************************************

DIM tT(1 TO 3)
FOR I = 1 TO 64
WAIT &H3DA, 8, 8
  FOR o = 0 TO 255
    Palette.Get o, Pal
    tT(1) = Pal.red
    tT(2) = Pal.green
    tT(3) = Pal.blue
    IF tT(1) < pData(o, 1) THEN tT(1) = tT(1) + 1
    IF tT(2) < pData(o, 2) THEN tT(2) = tT(2) + 1
    IF tT(3) < pData(o, 3) THEN tT(3) = tT(3) + 1
    Pal.red = tT(1)
    Pal.green = tT(2)
    Pal.blue = tT(3)
    Palette.Set o, Pal
  NEXT o
NEXT I

END SUB

SUB Palette.FadeOut
'***************************************************************************
'*From FADE.BAS by Manny Najera                                            *
'***************************************************************************
DIM tT(1 TO 3)
FOR I = 0 TO 255
  Palette.Get I, Pal
  pData(I, 1) = Pal.red
  pData(I, 2) = Pal.green
  pData(I, 3) = Pal.blue
NEXT I
FOR I = 1 TO 64
WAIT &H3DA, 8, 8
  FOR o = 0 TO 255
    Palette.Get o, Pal
    tT(1) = Pal.red
    tT(2) = Pal.green
    tT(3) = Pal.blue
    IF tT(1) > 0 THEN tT(1) = tT(1) - 1
    IF tT(2) > 0 THEN tT(2) = tT(2) - 1
    IF tT(3) > 0 THEN tT(3) = tT(3) - 1
    Pal.red = tT(1)
    Pal.green = tT(2)
    Pal.blue = tT(3)
    Palette.Set o, Pal
  NEXT o
NEXT I
END SUB

DEFSNG I, O
SUB Palette.Get (nColor%, pInfo AS PaletteType)
'***************************************************************************
'*From FADE.BAS by Manny Najera                                            *
'***************************************************************************

OUT &H3C6, &HFF
OUT &H3C7, nColor%
pInfo.red = INP(&H3C9)
pInfo.green = INP(&H3C9)
pInfo.blue = INP(&H3C9)
END SUB

SUB Palette.Set (nColor%, pInfo AS PaletteType)
'***************************************************************************
'*From FADE.BAS by Manny Najera                                            *
'***************************************************************************

OUT &H3C6, &HFF
OUT &H3C8, nColor%
OUT &H3C9, pInfo.red
OUT &H3C9, pInfo.green
OUT &H3C9, pInfo.blue
END SUB

