'       ͸
'                                INTRO.BAS                          
'                Main Module 1 for "Ants : The Exodus"              
'       ͵
'        By Michael Hughes                            February 2002 
'       ͵
'        This is the main module 1 for Ants:The Exodus v1.0.        
'        It provides the menu and prep for the game.                
'        This code is for MS QuickBASIC v4.5.                       
'                                                                   
'            **WARNING: Load MIDI driver (SBMIDI) first!**          
'                                                                   
'        The documentation for this source can be found in          
'        SRCDOC.TXT which should accompany this file.               
'                                                                   
'        This module is designed to be called from ANTS.BAT. To     
'        run from QB4.5, set COMMAND$ to /SY or /SN . To run        
'        from QBasic 1.0 see instructions below.                    
'        This source is public domain. You may use small parts of   
'        it within your own programs provided credit is given.      
'                                                                   
'        The following components were written by others:           
'         -GIF utilities : Mallard (www.qbasic.com)                 
'         -Mouse code    : Unknown                                  
'         -MIDI player   : Jesse Dorland                            
'         -Fading        : Manny Najera (www.flashgames.com)        
'        Original comments have been left in these sub-routines.    
'                                                                   
'        Use this product at your own risk.                         
'                                                                   
'                                                                   
'       Michael Hughes Software                        
'       February-May 2002                                     
'       mhsoft_online@yahoo.com                        
'       Visit the MHSoft Website:                                 
'       www.geocities.com/mhsoft_online                  M H S    
'       "Welcome to the World..."                      
'       ;
'
'**************SUB AND FUNCTION DECLARATIONS************************
DECLARE SUB KillPress ()
DECLARE FUNCTION DoAddon$ ()
DECLARE SUB DoFront ()
DECLARE SUB LoadImage (x!, y!, file$)
DECLARE SUB Delay (Repetitions%)
DECLARE SUB MIDICleanup ()
DECLARE SUB MIDILoop ()
DECLARE SUB MIDIStop ()
DECLARE SUB DoPlay (startlv!, init!)
DECLARE SUB DoInstruct ()
DECLARE SUB DrawInstruct (page!)
DECLARE SUB DoMission ()
DECLARE FUNCTION WordWrap$ (text$, w!, event!)
DECLARE FUNCTION DoLoad$ ()
DECLARE SUB DoMainMenu ()
DECLARE SUB Centre (text$, y!)
DECLARE FUNCTION Lts$ (text!)
DECLARE SUB InitMain ()
DECLARE SUB InitObjects ()
DECLARE SUB Palette.Set (nColor%, pInfo AS ANY)
DECLARE SUB Palette.Get (nColor%, pInfo AS ANY)
DECLARE SUB Palette.Fadeout ()
DECLARE SUB palette.fadein ()
DECLARE SUB InitSprites ()
DECLARE SUB DrawObject (o!, x!, y!)
DECLARE SUB DetectSettings (BasePort%, IRQ%, LoDMA%, HiDMA%, CardType%, MPU401%)
DECLARE SUB DriversLoaded (SBMIDI%, SBSIM%)
DECLARE FUNCTION MIDILoad% (Filename$)
DECLARE FUNCTION MIDIError$ ()
DECLARE FUNCTION MixerChip$ ()
DECLARE SUB MIDIPlay (Handle%)
DECLARE SUB SetCard (CardType%)
DECLARE FUNCTION SoundCard$ (CardType%)
DECLARE FUNCTION InternalBitRead% (Variable%, BitNum%)
DECLARE SUB InternalGetIntVector (IntNum%, segment&, offset&)
DECLARE FUNCTION InternalReadMixer% (Index%)
DECLARE SUB IntX (IntNum AS INTEGER, Regs AS ANY)
DECLARE SUB MIDIUnload (Handle%)
DECLARE SUB DoCreditAnts (y!)
DECLARE SUB DoCredits (e!)
DECLARE SUB DrawCredit (file$, x!, y!)
DECLARE SUB DoWin ()
REM $DYNAMIC
'****DECLARE TYPE AND DIMENSION ARRAYS***********
COMMON SHARED retvalue
COMMON SHARED retvalue2
COMMON SHARED snd
COMMON SHARED Musicon
COMMON SHARED sb.baseport AS INTEGER
COMMON SHARED sb.irq AS INTEGER
COMMON SHARED sb.lodma AS INTEGER
COMMON SHARED SB.HiDma AS INTEGER
COMMON SHARED sb.cardtype AS INTEGER
COMMON SHARED SB.Mpu401 AS INTEGER
COMMON SHARED levelfile$
COMMON SHARED level
COMMON SHARED lives
COMMON SHARED delfac

TYPE Registers
	 AX    AS INTEGER
	 BX    AS INTEGER
	 CX    AS INTEGER
	 dx    AS INTEGER
	 BP    AS INTEGER
	 SI    AS INTEGER
	 DI    AS INTEGER
	 FLAGS AS INTEGER
	 DS    AS INTEGER
	 ES    AS INTEGER
END TYPE
IntXCodeData:
DATA  &H55, &H8B, &HEC, &H83, &HEC, &H08, &H56, &H57, &H1E, &H55, &H8B, &H5E
DATA  &H06, &H8B, &H47, &H10, &H3D, &HFF, &HFF, &H75, &H04, &H1E, &H8F, &H47
DATA  &H10, &H8B, &H47, &H12, &H3D, &HFF, &HFF, &H75, &H04, &H1E, &H8F, &H47
DATA  &H12, &H8B, &H47, &H08, &H89, &H46, &HF8, &H8B, &H07, &H8B, &H4F, &H04
DATA  &H8B, &H57, &H06, &H8B, &H77, &H0A, &H8B, &H7F, &H0C, &HFF, &H77, &H12
DATA  &H07, &HFF, &H77, &H02, &H1E, &H8F, &H46, &HFA, &HFF, &H77, &H10, &H1F
DATA  &H8B, &H6E, &HF8, &H5B, &HCD, &H21, &H55, &H8B, &HEC, &H8B, &H6E, &H02
DATA  &H89, &H5E, &HFC, &H8B, &H5E, &H06, &H1E, &H8F, &H46, &HFE, &HFF, &H76
DATA  &HFA, &H1F, &H89, &H07, &H8B, &H46, &HFC, &H89, &H47, &H02, &H89, &H4F
DATA  &H04, &H89, &H57, &H06, &H58, &H89, &H47, &H08, &H89, &H77, &H0A, &H89
DATA  &H7F, &H0C, &H9C, &H8F, &H47, &H0E, &H06, &H8F, &H47, &H12, &H8B, &H46
DATA  &HFE, &H89, &H47, &H10, &H5A, &H1F, &H5F, &H5E, &H8B, &HE5, &H5D, &HCA
DATA  &H02, &H00
DIM SHARED QMIDIRegs AS Registers, MEM.SEGMENT(0 TO 255) AS INTEGER
DIM SHARED MIDI.PLAYTIME AS SINGLE, MIDI.ERROR AS INTEGER, PAUSED AS SINGLE
DIM SHARED SBMIDI.INTERRUPT AS INTEGER, MEM.ALLOCATED(0 TO 255) AS LONG
DIM SHARED SBSIM.INTERRUPT AS INTEGER, MIXER.CHIP AS INTEGER
DIM SHARED BIT.STORAGE(0 TO 7) AS INTEGER
DIM SHARED SENSITIVE AS INTEGER, REVERSE.STEREO AS INTEGER
DIM SHARED SOUND.DISABLED AS INTEGER, CURRENTHANDLE AS INTEGER

DriversLoaded SBMIDI.INTERRUPT, SBSIM.INTERRUPT
IF SBMIDI.INTERRUPT = 0 THEN SBMIDI.INTERRUPT = &H80
IF SBSIM.INTERRUPT = 0 THEN SBSIM.INTERRUPT = &H81
DetectSettings sb.baseport, sb.irq, sb.lodma, SB.HiDma, sb.cardtype, SB.Mpu401
IF sb.cardtype = 0 THEN SetCard 2
IF sb.baseport = 0 THEN sb.baseport = &H220
IF sb.irq = 0 THEN sb.irq = 5
IF sb.lodma = 0 THEN sb.lodma = 1
IF SB.HiDma = 0 AND sb.cardtype = 6 THEN SB.HiDma = 5

TYPE PaletteType
  red AS INTEGER
  green AS INTEGER
  blue AS INTEGER
END TYPE

DIM SHARED Pal AS PaletteType
DIM SHARED pData(0 TO 255, 1 TO 3)


CONST black = 0
CONST blue = 1
CONST green = 2
CONST red = 4
CONST grey = 7
CONST dgrey = 8
CONST Brown = 6
CONST yellow = 14
CONST white = 15
CONST bg = 0                      '*Background for main game

'**Blocks
DIM SHARED block1!(65)
DIM SHARED block2!(65)
DIM SHARED block3!(65)
DIM SHARED block4!(65)
DIM SHARED block5!(65)
DIM SHARED block6!(65)
DIM SHARED block7!(65)
DIM SHARED block8!(65)
DIM SHARED block9!(65)
DIM SHARED block10!(65)
DIM SHARED block11!(65)
DIM SHARED block12!(65)
DIM SHARED block13!(65)
DIM SHARED block14!(65)
DIM SHARED block15!(65)
DIM SHARED block16!(65)
DIM SHARED block17!(65)
DIM SHARED block18!(65)
DIM SHARED block19!(65)
DIM SHARED block20!(65)
DIM SHARED block21!(65)
DIM SHARED block22!(65)

'**Sprite images
DIM SHARED antr!(65)
DIM SHARED antrn!(65)
DIM SHARED spir!(65)
DIM SHARED spirn!(65)
DIM SHARED waspr!(65)
DIM SHARED wasprn!(65)
DIM SHARED flieru!(65)
DIM SHARED flierun!(65)
DIM SHARED flier2!(65)
DIM SHARED flier2n!(65)
DIM SHARED redr!(65)
DIM SHARED redrn!(65)


'**Additional sound**
DIM SHARED midiplaying
DIM SHARED midivolume%

DIM SHARED lname$(200)


'****BEGINNING OF RUN-CODE****

ON ERROR GOTO nosndfile
OPEN "SOUND.DAT" FOR INPUT AS #1
INPUT #1, x
IF x <> -1 THEN
  sb.cardtype = x
  INPUT #1, sb.irq
  INPUT #1, sb.lodma
  INPUT #1, ab.hidma
  INPUT #1, sb.baseport
END IF
CLOSE
ON ERROR GOTO generror

RANDOMIZE TIMER

SCREEN 9

CALL InitSprites
CALL InitObjects
'**************************************************************************
'*To run as a stand-alone program without modifying command$, delete the
'*next block of code and replace it with the following to remarked lines
'**************************************************************************
'CALL DoFront
'CALL DoMainMenu

CALL KillPress
IF snd = 1 THEN MIDICleanup
IF retvalue = 0 THEN
  c$ = UCASE$(LTRIM$(RTRIM$(COMMAND$)))
  IF c$ = "/SY" THEN
    snd = 1
  ELSEIF c$ = "/SN" THEN
    snd = 0
  ELSE
    PRINT "To play Ants:The Exodus run ANTS.BAT or NOSOUND.BAT"
    END
  END IF
  CALL DoFront
  CALL DoMainMenu
  END
END IF

IF retvalue = -1 THEN
  lives = lives - 1
  IF lives <= 0 THEN CALL DoMainMenu
  IF retvalue2 = 0 THEN levelfile$ = "MAPS\LEVEL" + Lts$(level) + ".MAP"
  retvalue = 1
  IF snd = 1 THEN MIDICleanup
  CHAIN "LEVEL"
END IF
IF retvalue = 1 THEN
  IF retvalue2 = 1 THEN
    CALL DoMainMenu
  END IF
  level = level + 1
  IF level = 26 THEN
    CALL DoWin
    CALL Palette.Fadeout
    LINE (0, 0)-STEP(650, 350), black, BF
    CALL palette.fadein
    CALL DoCredits(1)
    CALL DoMainMenu
  END IF
  levelfile$ = "MAPS\LEVEL" + Lts$(level) + ".MAP"
  retvalue = 1
  IF snd = 1 THEN MIDICleanup
  CHAIN "LEVEL"
END IF

END

'*********Handlers******************

nosndfile:
retvalue = 1
CHAIN "SETSOUND"
RETURN

generror:
CLS
SCREEN 0
PRINT "Unexpected error:"; ERR
PRINT "Ants is terminating."
IF snd = 1 THEN MIDICleanup
END

REM $STATIC
SUB Centre (text$, y)
'***************************************************************************
'*Prints centred text in Screen 7                                          *
'***************************************************************************

P = INT(20 - (LEN(text$) / 2))
LOCATE y, P: PRINT text$;



END SUB

SUB Delay (Repetitions%)
'***************************************************************************
'*Machine independant delay (From QMIDI by Jesse Dorland)                  *
'***************************************************************************

FOR I% = 1 TO Repetitions%
	WAIT &H3DA, 8, 8
	WAIT &H3DA, 8
NEXT I%

END SUB

REM $DYNAMIC
'***************************************************************************
'*From QMIDI by Jesse Dorland                                              *
'***************************************************************************
'DetectSettings - Attempt to detect Sound Blaster settings
SUB DetectSettings (BasePort%, IRQ%, LoDMA%, HiDMA%, CardType%, MPU401%)

'Reset all of the variables
BasePort% = 0
IRQ% = 0
LoDMA% = 0
HiDMA% = 0
CardType% = 0
MPU401% = 0

'Read the BLASTER environment variable
Settings$ = ENVIRON$("BLASTER")

'Attempt to extract the base port, High DMA, Low DMA, IRQ, and card type
'from the BLASTER enironment variable.
FOR I% = 1 TO LEN(Settings$) - 1
	'If the type of sound card was found, get it and exit the loop.
	SELECT CASE UCASE$(MID$(Settings$, I%, 1))
		'If the card type was found...
		CASE "T"
			CardType% = VAL(MID$(Settings$, I% + 1, 1))
			'If the base port address was found...
		CASE "A"
			BasePort% = VAL("&H" + LTRIM$(STR$(VAL(MID$(Settings$, I% + 1, 3)))))
		'If the IRQ was found...
		CASE "I"
			IRQ% = VAL(MID$(Settings$, I% + 1, 2))
		'If the low DMA channel was found...
		CASE "D"
			LoDMA% = VAL(MID$(Settings$, I% + 1, 1))
		'If the high DMA channel was found...
		CASE "H"
			HiDMA% = VAL(MID$(Settings$, I% + 1, 1))
		'If the MPU401 port was found...
		CASE "P"
			MPU401% = VAL("&H" + LTRIM$(STR$(VAL(MID$(Settings$, I% + 1, 3)))))
	END SELECT
NEXT I%

'If the card type wasn't found in the BLASTER variable, try to figure
'out the type using another method.

IF CardType% = 0 THEN
	'Examine the card's DMA channel.
	SELECT CASE LoDMA%
		'If the DMA is 210h or 230h, the card is an SB1.0/1.5.
		CASE &H210, &H230
			CardType% = 1
		'If the DMA is 250h or 260h, the card is either an SB2CD or a
		'Sound Blaster 16.  It could also be a Sound Blaster 1.0/1.5,
		'but it probably isn't.  Actually, it's also unlikely that the card
		'is an SB16, but I check for it anyway, because there's an easy way
		'to tell if it is - the High DMA channel will be greater than
		'0.
		'
		'On the other hand, there's no way that I know of to
		'distinguish an SB 1.0 from an SB 2.0, except by looking at the
		'BLASTER environment variable.  And since this code is executing
		'that method obviously failed.
		CASE &H250, &H260
			'Examining the High DMA channel will narrow it down.
			'If the High DMA is greater than 0, the card is an SB16.
			IF HiDMA% THEN
				CardType% = 6
			'Otherwise, define the card as a Sound Blaster 2.0.
			ELSE
				CardType% = 3
			END IF
		'If the DMA channel is any other value....
		CASE ELSE
			'Check the High DMA channel.  If it's a non-zero value,
			'we've got an SB16.
			IF HiDMA% THEN
				CardType% = 6
			'Otherwise....
			ELSE
				'If sensitive error checking is on, define the card as
				'a Sound Blaster 1.0/1.5.
				IF SENSITIVE THEN
					CardType% = 1
				'Otherwise, assume it's a Sound Blaster Pro.
				ELSE
					CardType% = 4
				END IF
			END IF
	END SELECT
END IF

'Determine the sound card's mixer chip
SELECT CASE CardType%
	'If the card could not be detected....
	CASE 0
		MIDI.ERROR = 7
		'If sensitive error checking is on, disable mixer operations
		IF SENSITIVE THEN
			MIXER.CHIP = 0
		'Otherwise, assume the default mixer chip.
		ELSE
			MIXER.CHIP = 2
		END IF
	'If the card is a Sound Blaster 1.0/1.5 or equivalent....
	CASE 1
		'Return an error.
		MIDI.ERROR = 6
		'If sensitive error checking is on, disable mixer operations and
		'exit.
		IF SENSITIVE THEN
			MIXER.CHIP = 0
			EXIT SUB
		'Otherwise, set the earliest mixer chip and continue.
		ELSE
			MIXER.CHIP = 1
		END IF
	'If the card is a Sound Blaster 2.0/2.5 or equivalent....
	CASE 3
		'There are two different kinds of SB 2.0 cards: the regular SB2,
		'and the SB2CD.  The SB2CD has a mixer chip (the CT1335), whereas
		'the SB 2.0 does not.  The way to tell them apart is that the
		'Sound Blaster 2.0 uses Base Ports 220h and 240h, and the SB2CD
		'uses ports 250h and 260h.
		'
		'Assume the sound card is an SB2CD for now...
		MIXER.CHIP = 1
		'If the card is defined as an SB 2.0, not an SB 2.0 CD, and
		'sensitive error checking is on, disable mixer operations.
		IF (BasePort% = &H220 OR BasePort% = &H240) AND SENSITIVE <> 0 THEN
			MIXER.CHIP = 0
		END IF
		MIDI.ERROR = 0
	'If the card is a Sound Blaster Pro, assume chip CT1345
	CASE 2, 4, 5
		MIXER.CHIP = 2
		MIDI.ERROR = 0
	'If the card is a Sound Blaster 16 or later, assume chip CT1745
	CASE IS >= 6
		MIXER.CHIP = 3
		MIDI.ERROR = 0
END SELECT
END SUB

REM $STATIC
FUNCTION DoAddon$
'***************************************************************************
'*Runs the Load Addon menu and returns the file to run.                    *
'***************************************************************************
CALL Palette.Fadeout
SCREEN 7
LINE (0, 0)-STEP(320, 200), 0, BF
	      
CALL LoadImage(70, 0, "images\logo1.spr")
CALL palette.fadein
SHELL "CD ADDONS"
SHELL "DIR /-P /ON /B > ..\LIST.TMP"
SHELL "CD.."
OPEN "LIST.TMP" FOR INPUT AS #1
DO WHILE EOF(1) = 0
  x = x + 1
  IF x = 201 THEN EXIT DO
  LINE INPUT #1, lname$(x)
  lname$(x) = UCASE$(LTRIM$(RTRIM$(lname$(x))))
  file$ = "ADDONS\" + lname$(x)
  OPEN file$ FOR INPUT AS #2
  LINE INPUT #2, f$
  IF LTRIM$(RTRIM$(f$)) = "Ants Sprite" THEN
    INPUT #2, nothing$
    INPUT #2, title$
  ELSE
    title$ = "Invalid Map"
  END IF
  CLOSE #2
  lname$(x) = lname$(x) + SPACE$(12 - LEN(lname$(x)))
  lname$(x) = lname$(x) + LEFT$(title$, 12)
DOAddon1:
LOOP
CLOSE #1
KILL "LIST.TMP"
maxnum = x


sel = 1
offset = 0

thetop3:

FOR x = 1 TO 10
  IF sel = x + offset THEN COLOR 2 ELSE COLOR 15
  LOCATE x + 11, 10: PRINT SPACE$(25)
  LOCATE x + 11, 10: PRINT lname$(x + offset)
NEXT x


COLOR 15
LOCATE 23, 6: PRINT "Press Esc. to cancel";

A$ = ""
DO WHILE A$ = ""
  A$ = INKEY$
LOOP

IF A$ = CHR$(0) + "P" THEN sel = sel + 1
IF sel > maxnum THEN
  sel = maxnum
ELSE
  IF sel - offset > 10 THEN
    offset = offset + 1
  END IF
END IF

IF A$ = CHR$(0) + "H" THEN sel = sel - 1
IF sel < 1 THEN
  sel = 1
ELSE
  IF sel - offset < 1 THEN
    offset = offset - 1
  END IF
END IF


IF A$ = CHR$(13) THEN
  DoAddon$ = "ADDONS\" + LEFT$(lname$(sel), 12)
  EXIT FUNCTION
END IF

IF A$ = CHR$(27) THEN
  DoAddon$ = ""
  EXIT FUNCTION
END IF

GOTO thetop3

END FUNCTION

SUB DoCreditAnts (y)
'***************************************************************************
'*Puts 4 flying ants at height y                                                 *
'***************************************************************************

LINE (450, y)-STEP(20, 15), 11, BF
PUT (450, y), flierun, AND
PUT (450, y), flieru, OR

LINE (480, y + 5)-STEP(20, 15), 11, BF
PUT (480, y + 5), flierun, AND
PUT (480, y + 5), flieru, OR

LINE (510, y - 5)-STEP(20, 15), 11, BF
PUT (510, y - 5), flierun, AND
PUT (510, y - 5), flieru, OR

LINE (540, y)-STEP(20, 15), 11, BF
PUT (540, y), flierun, AND
PUT (540, y), flieru, OR


PCOPY 1, 0

LINE (450, y)-STEP(20, 15), 11, BF
PUT (450, y), flier2n, AND
PUT (450, y), flier2, OR
LINE (450, y + 13)-STEP(20, 0), 11


LINE (480, y + 5)-STEP(20, 15), 11, BF
PUT (480, y + 5), flier2n, AND
PUT (480, y + 5), flier2, OR
LINE (480, y + 18)-STEP(20, 0), 11

LINE (510, y - 5)-STEP(20, 15), 11, BF
PUT (510, y - 5), flier2n, AND
PUT (510, y - 5), flier2, OR
LINE (510, y + 8)-STEP(20, 0), 11

LINE (540, y)-STEP(20, 15), 11, BF
PUT (540, y), flier2n, AND
PUT (540, y), flier2, OR
LINE (540, y + 13)-STEP(20, 0), 11

PCOPY 1, 0



END SUB

SUB DoCredits (e)
'***************************************************************************
'*Runs the credits.                                                        *
'***************************************************************************

IF snd = 1 THEN
  IF midiplaying <> 1 THEN
    CALL MIDIStop
    Handle% = MIDILoad("MIDI/INTRO.MID")
    CALL MIDIPlay(Handle%)
    midiplaying = 1
  END IF
END IF

SCREEN 9, , 1, 0
z = 300
'**PROGRAMMING/GRAPHICS
LINE (0, 0)-STEP(640, 350), 11, BF
CALL DrawCredit("images\pg.spr", 100, 100)
CALL DrawCredit("images\mh.spr", 160, 140)
FOR x = 1 TO 25
  z = z - 1
  CALL DoCreditAnts(z)
NEXT x


'**BETA TESTING**
LINE (0, 0)-STEP(640, 350), 11, BF
CALL DrawCredit("images\bt.spr", 100, 100)
CALL DrawCredit("images\mh.spr", 160, 140)
CALL DrawCredit("images\ch.spr", 160, 160)
FOR x = 1 TO 25
  z = z - 1
  CALL DoCreditAnts(z)
NEXT x

'**THANKS TO**
LINE (0, 0)-STEP(640, 350), 11, BF
CALL DrawCredit("images\tt.spr", 100, 100)
CALL DrawCredit("images\m.spr", 160, 140)
CALL DrawCredit("images\jd.spr", 160, 160)
CALL DrawCredit("images\mj.spr", 160, 180)
FOR x = 1 TO 25
  z = z - 1
  CALL DoCreditAnts(z)
NEXT x

'**MHSOFT PRODUCTION**
LINE (0, 0)-STEP(640, 350), 11, BF
CALL DrawCredit("images\logo3.spr", 150, 100)
FOR x = 1 TO 25
  z = z - 1
  CALL DoCreditAnts(z)
NEXT x

'****THE END**********
IF e = 1 THEN
  LINE (0, 0)-STEP(640, 350), 11, BF
  CALL DrawCredit("images\te.spr", 210, 130)
  FOR x = 1 TO 30
    z = z - 1
    CALL DoCreditAnts(z)
  NEXT x
END IF

IF snd = 1 THEN
  CALL MIDIStop
  CALL MIDICleanup
END IF
CALL Palette.Fadeout
CALL KillPress
END SUB

SUB DoFront
'****************************************************************************
'*Loads two front pages and displays for a while                            *
'****************************************************************************

SCREEN 7, , 1, 0

IF snd = 1 THEN
  Handle% = MIDILoad("MIDI/INTRO.MID")
  MIDIPlay (Handle%)
  midiplaying = 1
END IF

'****MHSoft LOGO*************
CALL LoadImage(0, 20, "images\front.spr")
CALL Palette.Fadeout
PCOPY 1, 0
CALL palette.fadein
FOR x% = 1 TO 20
  CALL Delay(x%)
  IF INKEY$ <> "" THEN EXIT FOR
NEXT x%

CALL Palette.Fadeout

'************ANTS LOGO************
CALL LoadImage(1, 20, "images\front2.spr")
PCOPY 1, 0
CALL palette.fadein
FOR x% = 1 TO 20
  CALL Delay(x%)
  IF INKEY$ <> "" THEN EXIT FOR
NEXT x%

END SUB

SUB DoInstruct
'****************************************************************************
'*Uses DrawInstruct to display correct instruction page and managed nav.    *
'****************************************************************************

SCREEN 9, , 1, 0

page = 1

DO
 
  IF page <> oldpage THEN          '*If different**
    oldpage = page
    CALL DrawInstruct(page)
    PCOPY 1, 0
  END IF
 
  A$ = ""
  DO WHILE A$ = ""
    IF snd = 1 THEN CALL MIDILoop
    A$ = INKEY$
  LOOP
  IF A$ = CHR$(0) + "P" OR A$ = CHR$(0) + "M" THEN      '**Up or left keys**
    page = page + 1
    IF page = 9 THEN page = 8
  END IF
  IF A$ = CHR$(0) + "H" OR A$ = CHR$(0) + "K" THEN      '**Down or right keys**
    page = page - 1
    IF page = 0 THEN page = 1
  END IF
  IF A$ = CHR$(27) THEN                                 '**Escape key**
    PCOPY 1, 0
    EXIT SUB
  END IF
LOOP





END SUB

FUNCTION DoLoad$
'***************************************************************************
'*Runs the Load Addon menu and returns the file to run.                    *
'***************************************************************************

CALL Palette.Fadeout
SCREEN 7
LINE (0, 0)-STEP(320, 200), 0, BF

CALL LoadImage(70, 0, "images\logo1.spr")

up = 1
sel = 1

FOR x = 1 TO 10
  file$ = "SAVE\" + Lts$(x) + ".SAV"
  OPEN file$ FOR INPUT AS #1
  INPUT #1, full
  IF full = 0 THEN
    lname$(x) = "Blank"
  ELSE
    INPUT #1, level$
    INPUT #1, dated$
    lname$(x) = level$ + " " + dated$
  END IF
  CLOSE #1
NEXT x


thetop2:

FOR x = 1 TO 10
  IF sel = x THEN COLOR 2 ELSE COLOR 15
  CALL Centre(lname$(x), x + 11)
NEXT x
IF sel = 11 THEN COLOR 2 ELSE COLOR 15
CALL Centre("Cancel", 23)


IF up = 1 THEN
  up = 0
  CALL palette.fadein
END IF
A$ = ""
DO WHILE A$ = ""
  IF snd = 1 THEN CALL MIDILoop
  A$ = INKEY$
LOOP

IF A$ = CHR$(0) + "H" THEN sel = sel - 1
IF sel < 1 THEN sel = 11
IF A$ = CHR$(0) + "P" THEN sel = sel + 1
IF sel > 11 THEN sel = 1

IF A$ = CHR$(13) THEN
  IF sel < 11 AND lname$(sel) <> "Blank" THEN
    DoLoad$ = "SAVE\" + Lts$(sel) + ".SAV"
  ELSE
    DoLoad$ = ""
  END IF
  EXIT FUNCTION
END IF

GOTO thetop2


END FUNCTION

SUB DoMainMenu
'****************************************************************************
'*Displays main menu, allows selection to be made and responds              *
'****************************************************************************

verytop:

IF snd = 1 THEN
  IF midiplaying <> 1 THEN
    CALL MIDIStop
    Handle% = MIDILoad("MIDI\INTRO.MID")
    CALL MIDIPlay(Handle%)
    midiplaying = 1
  END IF
END IF


SCREEN 7, , 0, 0
CALL Palette.Fadeout
LINE (0, 0)-STEP(320, 200), 0, BF
CALL LoadImage(70, 0, "images\logo1.spr")


up = 1

sel = 1
thetop:
IF sel = 1 THEN COLOR 2 ELSE COLOR 15
CALL Centre("New Game", 13)
IF sel = 2 THEN COLOR 2 ELSE COLOR 15
CALL Centre("Load Game", 15)
IF sel = 3 THEN COLOR 2 ELSE COLOR 15
CALL Centre("Instructions", 17)
IF sel = 4 THEN COLOR 2 ELSE COLOR 15
CALL Centre("Add-On level", 19)
IF sel = 5 THEN COLOR 2 ELSE COLOR 15
CALL Centre("Credits", 21)
IF sel = 6 THEN COLOR 2 ELSE COLOR 15
CALL Centre("Exit", 23)
IF up = 1 THEN
  up = 0
  CALL palette.fadein
END IF
CALL KillPress
A$ = ""
DO WHILE A$ = ""
  IF snd = 1 THEN CALL MIDILoop
  A$ = INKEY$
LOOP

IF A$ = CHR$(0) + "H" THEN sel = sel - 1
IF sel < 1 THEN sel = 6
IF A$ = CHR$(0) + "P" THEN sel = sel + 1
IF sel > 6 THEN sel = 1

IF A$ = CHR$(13) THEN
  IF sel = 1 THEN
    IF snd = 1 THEN MIDIStop
    CALL Palette.Fadeout
    LINE (0, 0)-STEP(640, 350), 0, BF
    CALL palette.fadein
    SCREEN 9
    lives = 3
    level = 1
    CALL DoMission
    Musicon = 0
    levelfile$ = "MAPS\LEVEL" + Lts$(level) + ".MAP"
    retvalue = 1
    retvalue2 = 0
    CHAIN "LEVEL"
  END IF
  IF sel = 2 THEN
    file$ = DoLoad$
    IF file$ <> "" THEN
      IF snd = 1 THEN CALL MIDIStop
      retvalue = 2
      retvalue2 = 0
      levelfile$ = file$
      CHAIN "LEVEL"
    END IF
    GOTO verytop
  END IF
  IF sel = 3 THEN
    CALL Palette.Fadeout
    LINE (0, 0)-STEP(320, 200), 0, BF
    CALL palette.fadein
    CALL DoInstruct
    SCREEN 7
    GOTO verytop
  END IF
  IF sel = 4 THEN
    lives = 3
    IF snd = 1 THEN CALL MIDIStop
    file$ = DoAddon$
    IF file$ <> "" THEN
      levelfile$ = file$
      retvalue = 1
      retvalue2 = 1
      CHAIN "LEVEL"
    END IF
    GOTO verytop
  END IF
  IF sel = 5 THEN
    IF snd = 1 THEN CALL MIDIStop
    CALL Palette.Fadeout
    LINE (0, 0)-STEP(640, 350), 11, BF
    CALL DoCredits(0)
    GOTO verytop
  END IF
  IF sel = 6 THEN
    IF snd = 1 THEN MIDIStop
    CALL Palette.Fadeout
    LINE (0, 0)-STEP(300, 200), 0, BF
    CALL palette.fadein
    IF snd = 1 THEN CALL MIDICleanup
    END
  END IF
END IF

GOTO thetop


END SUB

SUB DoMission
'***************************************************************************
'*Displays and runs the mission briefing                                   *
'***************************************************************************
CALL Palette.Fadeout

SCREEN 9, , 0, 0

IF snd = 1 THEN
  IF midiplaying <> 2 THEN
    CALL MIDIStop
    Handle% = MIDILoad("MIDI/MISSION.MID")
    CALL MIDIPlay(Handle%)
    midiplaying = 2
  END IF
END IF

COLOR 15
CALL palette.fadein
OPEN "data\mission.txt" FOR INPUT AS #1
LOCATE 4, 4

LINE (21, 0)-STEP(600, 40), 6, BF
CALL LoadImage(185, 1, "images\tclogo.spr")
LINE (21, 40)-STEP(600, 0), white

DO WHILE EOF(1) = 0 AND INKEY$ = ""
  IF snd = 1 THEN CALL MIDILoop
  LINE INPUT #1, txt$
  numlines = VAL(WordWrap$(txt$, 70, 0))
  FOR l = 1 TO numlines
    t$ = WordWrap$(txt$, 70, l)
    LOCATE , 4
    LINE (0, 0)-STEP(19, 350), green, BF
    LINE (-1, -1)-STEP(21, 350), white, B
    LINE (640, 0)-STEP(-20, 350), green, BF
    LINE (641, -1)-STEP(-21, 350), white, B
    FOR c = 1 TO LEN(t$)
      PRINT MID$(t$, c, 1);
      CALL Delay(5)
      IF INKEY$ <> "" THEN GOTO done
    NEXT c
    PRINT
    LINE (0, 0)-STEP(19, 350), green, BF
    LINE (-1, -1)-STEP(21, 350), white, B
    LINE (640, 0)-STEP(-20, 350), green, BF
    LINE (641, -1)-STEP(-21, 350), white, B
  NEXT l
LOOP

DO WHILE INKEY$ = ""
IF snd = 1 THEN CALL MIDILoop
LOOP
done:
IF snd = 1 THEN CALL MIDIStop

SCREEN , , 0, 0


CLOSE #1


END SUB

SUB DoWin
'***************************************************************************
'*Displays the victory message.                                            *
'***************************************************************************
CALL Palette.Fadeout

SCREEN 9, , 0, 0

IF snd = 1 THEN
  IF midiplaying <> 2 THEN
    CALL MIDIStop
    Handle% = MIDILoad("MIDI/WIN.MID")
    CALL MIDIPlay(Handle%)
    midiplaying = 2
  END IF
END IF

COLOR 15
CALL palette.fadein
OPEN "data\win.txt" FOR INPUT AS #1
LOCATE 4, 4

LINE (21, 0)-STEP(600, 40), 6, BF
CALL LoadImage(185, 1, "images\tclogo.spr")
LINE (21, 40)-STEP(600, 0), white

DO WHILE EOF(1) = 0 AND INKEY$ = ""
  IF snd = 1 THEN CALL MIDILoop
  LINE INPUT #1, txt$
  numlines = VAL(WordWrap$(txt$, 70, 0))
  FOR l = 1 TO numlines
    t$ = WordWrap$(txt$, 70, l)
    LOCATE , 4
    LINE (0, 0)-STEP(19, 350), green, BF
    LINE (-1, -1)-STEP(21, 350), white, B
    LINE (640, 0)-STEP(-20, 350), green, BF
    LINE (641, -1)-STEP(-21, 350), white, B
    FOR c = 1 TO LEN(t$)
      PRINT MID$(t$, c, 1);
      CALL Delay(5)
      IF INKEY$ <> "" THEN GOTO done2
    NEXT c
    PRINT
    LINE (0, 0)-STEP(19, 350), green, BF
    LINE (-1, -1)-STEP(21, 350), white, B
    LINE (640, 0)-STEP(-20, 350), green, BF
    LINE (641, -1)-STEP(-21, 350), white, B
  NEXT l
LOOP

DO WHILE INKEY$ = ""
IF snd = 1 THEN CALL MIDILoop
LOOP
done2:
IF snd = 1 THEN CALL MIDIStop

SCREEN , , 0, 0


CLOSE #1

END SUB

SUB DrawCredit (file$, x, y)
'***************************************************************************
'*Draws the credit images                                                  *
'***************************************************************************

CALL LoadImage(x, y, file$)
LINE (x, y)-STEP(300, 0), 11
LINE (x, y)-STEP(0, 200), 11


END SUB

SUB DrawInstruct (page)
'***************************************************************************
'*Draws the releavnt instructions page.                                    *
'***************************************************************************


COLOR 15, black
LINE (0, 0)-STEP(640, 350), grey, BF
LINE (3 * 8 - 2, 2 * 14 - 2)-STEP(74 * 8 + 4, 18 * 14 + 4), black, BF
LINE (3 * 8 - 2, 2 * 14 - 2)-STEP(74 * 8 + 4, 18 * 14 + 4), white, B

LINE (11 * 8 - 2, 21 * 14 - 2)-STEP(36 * 8 + 4, 1 * 14 + 4), black, BF
LINE (11 * 8 - 2, 21 * 14 - 2)-STEP(36 * 8 + 4, 1 * 14 + 4), white, B
LOCATE 22, 12: PRINT " = Previous   = Next  Esc. =  Done"


LINE (59 * 8 - 2, 21 * 14 - 2)-STEP(13 * 8 + 4, 1 * 14 + 4), black, BF
LINE (59 * 8 - 2, 21 * 14 - 2)-STEP(13 * 8 + 4, 1 * 14 + 4), white, B
LOCATE 22, 60: PRINT "Page"; page; "of 8"

OPEN "data\ins.txt" FOR INPUT AS #1
DO
  LINE INPUT #1, txt$
  IF txt$ = Lts$(page) THEN EXIT DO
LOOP
LINE INPUT #1, top$

LOCATE 3, 4

DO
  LINE INPUT #1, txt$
  IF LTRIM$(RTRIM$(UCASE$(txt$))) = "END" THEN EXIT DO
  numlines = VAL(WordWrap(txt$, 74, 0))
  FOR x = 1 TO numlines
    LOCATE , 4: PRINT WordWrap$(txt$, 74, x)
  NEXT x
LOOP
CLOSE #1
    

P = INT(40 - (LEN(top$) / 2))
LOCATE 2, P: PRINT top$;
LINE ((P - 1) * 8 - 1, 14)-STEP(LEN(top$) * 8 + 2, 14), white, B



IF page = 4 THEN
  CALL DrawObject(1, 40, 52)
  CALL DrawObject(2, 40, 80)
  CALL DrawObject(3, 40, 108)
  CALL DrawObject(11, 40, 150)
  CALL DrawObject(4, 40, 192)
  CALL DrawObject(21, 40, 220)
END IF

IF page = 5 THEN
  CALL DrawObject(14, 40, 38)
  CALL DrawObject(15, 40, 66)
  CALL DrawObject(8, 40, 94)
  CALL DrawObject(20, 40, 122)
  CALL DrawObject(22, 40, 150)
END IF

IF page = 6 THEN
  CALL DrawObject(17, 40, 38)
  CALL DrawObject(1, 40, 108)
  CALL DrawObject(9, 40, 150)
  CALL DrawObject(20, 40, 220)
  CALL DrawObject(5, 40, 266)
  x = 40
  y = 178
  LINE (x, y)-STEP(20, 15), yellow, BF
  LINE (x, y)-STEP(20, 15), black, B
  CIRCLE (x + 12, y + 10), 6, black
  PAINT (x + 12, y + 10), black
  DRAW "ta0 bm" + STR$(x + 9) + "," + STR$(y + 6) + "u l u2 l3"
  PSET STEP(0, 0), 4
END IF

IF page = 7 THEN
  CALL DrawObject(1, 40, 36)
  PUT (41, 37), redrn, AND
  PUT (41, 37), redr, OR

  CALL DrawObject(1, 40, 92)
  PUT (41, 93), spirn, AND
  PUT (41, 93), spir, OR

  CALL DrawObject(1, 40, 148)
  PUT (41, 149), wasprn, AND
  PUT (41, 149), waspr, OR

END IF









END SUB

SUB DrawObject (o, x, y)
'***************************************************************************
'*Draws block o at x,y                                                     *
'***************************************************************************

    IF o = -1 THEN LINE (x + 1, y + 1)-STEP(19, 14), bg, BF
    IF o = 0 THEN LINE (x + 1, y + 1)-STEP(19, 14), bg, BF
    IF o = 1 THEN PUT (x, y), block1, PSET
    IF o = 2 THEN PUT (x, y), block2, PSET
    IF o = 3 THEN PUT (x, y), block3, PSET
    IF o = 4 THEN PUT (x, y), block4, PSET
    IF o = 5 THEN PUT (x, y), block5, PSET
    IF o = 6 THEN PUT (x, y), block6, PSET
    IF o = 7 THEN PUT (x, y), block7, PSET
    IF o = 8 THEN PUT (x, y), block8, PSET
    IF o = 9 THEN PUT (x, y), block9, PSET
    IF o = 10 THEN PUT (x, y), block10, PSET
    IF o = 11 THEN PUT (x, y), block11, PSET
    IF o = 12 THEN PUT (x, y), block12, PSET
    IF o = 13 THEN PUT (x, y), block13, PSET
    IF o = 14 THEN PUT (x, y), block14, PSET
    IF o = 15 THEN PUT (x, y), block15, PSET
    IF o = 16 THEN PUT (x, y), block16, PSET
    IF o = 17 THEN PUT (x, y), block17, PSET
    IF o = 18 THEN PUT (x, y), block18, PSET
    IF o = 19 THEN PUT (x, y), block19, PSET
    IF o = 20 THEN PUT (x, y), block20, PSET
    IF o = 21 THEN PUT (x, y), block21, PSET
    IF o = 22 THEN PUT (x, y), block22, PSET
 
 
  



END SUB

REM $DYNAMIC
'***************************************************************************
'*From QMIDI by Jesse Dorland                                              *
'***************************************************************************
'DriversLoaded - Attempt to detect if sound drivers are loaded
SUB DriversLoaded (SBMIDI%, SBSIM%)
'Open the data file.
FF% = FREEFILE
OPEN "DRIVERS.DAT" FOR BINARY AS #FF%
FileSize& = LOF(FF%)
NoExist% = 0
'If the file is empty, return an error.
IF FileSize& = 0 THEN
	CLOSE FF%
	KILL "DRIVERS.DAT"
	MIDI.ERROR = 1
	NoExist% = 1
'If the file is not exactly 1,024 bytes in size, return an error.
ELSEIF FileSize& <> 1024 THEN
	CLOSE FF%
	MIDI.ERROR = 9
	NoExist% = 1
END IF

'If DRIVERS.DAT exists, and is 1 kilobyte in size, read the driver
'data from it.
IF NoExist% = 0 THEN
REDIM DRIVERDATA$(1 TO 5)
FOR I% = 1 TO 4
	DRIVERDATA$(I%) = INPUT$(256, #FF%)
NEXT I%
END IF

'Close the data file.
CLOSE #FF%

'Check the interrupt handlers for int 80h-FFh, to see if they are occupied
'by either SBMIDI or SBSIM.
SBMIDI% = 0
SBSIM% = 0
FOR I% = &H80 TO &HFF
	'Get the address of the interrupt handler.
	InternalGetIntVector I%, segment&, offset&
	'If the segment returned is 0, that means that the current interrupt
	'is not in use.
	IF segment& = 0 THEN GOTO Skip:

	'The following code checks for the drivers by looking for the text
	'"SBMIDI" and "SBSIM" at certain locations in the driver code.
	'If it doesn't work, a different method is used.
	IF SBMIDI% = 0 THEN
	  DEF SEG = segment& - 17
	  TEMP$ = ""
	  FOR J% = 1 TO 6
		TEMP$ = TEMP$ + CHR$(PEEK(271 + J%))
	  NEXT
	  IF TEMP$ = "SBMIDI" THEN SBMIDI% = I%
	END IF
	IF SBSIM% = 0 AND segment& <> 0 THEN
		DEF SEG = segment& - 1
		TEMP$ = ""
		FOR J% = 1 TO 5
			TEMP$ = TEMP$ + CHR$(PEEK(274 + J%))
		NEXT
		IF TEMP$ = "SBSIM" THEN SBSIM% = I%
	END IF
 
	'This is the second detection method.  It's more complex than the first
	'method, but not really any more accurate.
	IF NoExist% = 0 THEN
	'Point to the segment of the interrupt handler.
	DEF SEG = segment&
	'Read 256 bytes of code from the interrupt handler.
	DRIVERDATA$(5) = ""
	FOR J% = 0 TO 255
		Byte% = PEEK(offset& + J%)
		DRIVERDATA$(5) = DRIVERDATA$(5) + CHR$(Byte%)
	NEXT J%
	'Check to see if the code matches any of the data from DRIVERS.DAT.
	FOR J% = 1 TO 4
		MATCH% = 1
		FOR k% = 0 TO 255
			IF MID$(DRIVERDATA$(J%), k% + 1, 1) <> MID$(DRIVERDATA$(5), k% + 1, 1) THEN
				SELECT CASE k%
					CASE IS = 14, 15, 113, 114, 235, 236
					CASE ELSE
						MATCH% = 0
						EXIT FOR
				END SELECT
			END IF
		NEXT k%
		'If there was a match, find out which driver is using the interrupt.
		IF MATCH% THEN
			IF J% = 1 THEN SBSIM% = I%
			IF J% <> 1 THEN SBMIDI% = I%
		END IF
		'If both SBMIDI and SBSIM have been found, exit the loop.
		IF SBSIM% <> 0 AND SBMIDI% <> 0 THEN EXIT FOR
	NEXT J%
   
	'If both SBMIDI and SBSIM have been found, exit the loop.
	IF SBSIM% <> 0 AND SBMIDI% <> 0 THEN EXIT FOR
	END IF
Skip:
NEXT I%
IF NoExist% = 0 THEN MIDI.ERROR = 0
END SUB

REM $STATIC
SUB InitObjects
SCREEN , , 1, 0
CLS
LINE (0, 0)-STEP(20, 15), yellow, BF
LINE (0, 0)-STEP(20, 15), black, B
GET (0, 0)-STEP(20, 15), block1        '**BLANK

LINE (0, 0)-STEP(20, 15), grey, BF
LINE (0, 0)-STEP(20, 15), black, B
LINE (1, 1)-STEP(18, 13), dgrey, B
LINE (1, 1)-STEP(18, 0), white
LINE (1, 1)-STEP(0, 13), white
GET (0, 0)-STEP(20, 15), block2        '**STONE

LINE (0, 0)-STEP(20, 15), Brown, BF
LINE (0, 0)-STEP(20, 15), black, B
LINE (1, 1)-STEP(18, 13), dgrey, B
LINE (1, 1)-STEP(18, 0), white
LINE (1, 1)-STEP(0, 13), white
GET (0, 0)-STEP(20, 15), block3        '**Brick

LINE (0, 0)-STEP(20, 15), yellow, BF
LINE (0, 0)-STEP(20, 15), black, B
DRAW "BM7,3 D5 L3 F5 E5 L3 U5 L3"
PAINT (8, 4), red, black
GET (0, 0)-STEP(20, 15), block4        '**DOWN ARROW

LINE (0, 0)-STEP(20, 15), yellow, BF
LINE (0, 0)-STEP(20, 15), black, B
DRAW "TA90 BM3,9 D5 L3 F5 E5 L3 U5 L3"
PAINT (4, 7), red, black
GET (0, 0)-STEP(20, 15), block5        '**RIGHT ARROW**

LINE (0, 0)-STEP(20, 15), yellow, BF
LINE (0, 0)-STEP(20, 15), black, B
DRAW "TA180 BM12,12 D5 L3 F5 E5 L3 U5 L3"
PAINT (10, 8), red, black
GET (0, 0)-STEP(20, 15), block6        '**UP ARROW**

LINE (0, 0)-STEP(20, 15), yellow, BF
LINE (0, 0)-STEP(20, 15), black, B
DRAW "TA270 BM16,6 D5 L3 F5 E5 L3 U5 L3"
PAINT (10, 8), red, black
GET (0, 0)-STEP(20, 15), block7        '**LEFT ARROW

LINE (0, 0)-STEP(20, 15), yellow, BF
LINE (0, 0)-STEP(20, 15), black, B
CIRCLE (10, 7), 7, black
PAINT (10, 7), bg, black
GET (0, 0)-STEP(20, 15), block8        '**HOLE

LINE (0, 0)-STEP(20, 15), yellow, BF
LINE (0, 0)-STEP(20, 15), black, B
CIRCLE (10, 7), 7, black
PAINT (10, 7), bg, black
FOR x = 1 TO 19 STEP 2
  LINE (x, 1)-STEP(0, 13), grey
NEXT x
FOR y = 1 TO 14 STEP 2
  LINE (1, y)-STEP(18, 0), grey
NEXT y

GET (0, 0)-STEP(20, 15), block9        '**GRATED HOLE

LINE (0, 0)-STEP(20, 15), red, BF
LINE (0, 0)-STEP(20, 15), black, B
LINE (1, 1)-STEP(18, 13), dgrey, B
LINE (1, 1)-STEP(17, 0), white
LINE (1, 1)-STEP(0, 12), white
CIRCLE (10, 8), 4, black
PAINT (10, 8), yellow, black
GET (0, 0)-STEP(20, 15), block10        '**Yellow Lock**


LINE (0, 0)-STEP(20, 15), red, BF
LINE (0, 0)-STEP(20, 15), black, B
LINE (1, 1)-STEP(18, 13), dgrey, B
LINE (1, 1)-STEP(17, 0), white
LINE (1, 1)-STEP(0, 12), white
CIRCLE (10, 8), 4, black
PAINT (10, 8), blue, black
GET (0, 0)-STEP(20, 15), block11        '**Blue Lock**

LINE (0, 0)-STEP(20, 15), red, BF
LINE (0, 0)-STEP(20, 15), black, B
LINE (1, 1)-STEP(18, 13), dgrey, B
LINE (1, 1)-STEP(17, 0), white
LINE (1, 1)-STEP(0, 12), white
CIRCLE (10, 8), 4, black
PAINT (10, 8), green, black
GET (0, 0)-STEP(20, 15), block12        '**Green Lock**

LINE (0, 0)-STEP(20, 15), red, BF
LINE (0, 0)-STEP(20, 15), black, B
LINE (1, 1)-STEP(18, 13), dgrey, B
LINE (1, 1)-STEP(17, 0), white
LINE (1, 1)-STEP(0, 12), white
CIRCLE (10, 8), 4, black
PAINT (10, 8), white, black
GET (0, 0)-STEP(20, 15), block13        '**White Lock**

LINE (0, 0)-STEP(100, 100), 0, BF

COLOR green
LOCATE 2, 2: PRINT "S"
LINE (2, 14)-STEP(18, 13), green, B
PAINT (3, 15), yellow, green
LINE (2, 14)-STEP(18, 13), yellow, B
GET (1, 13)-STEP(20, 15), block14      '**Start square**

LINE (0, 0)-STEP(100, 100), 0, BF

COLOR red
LOCATE 2, 2: PRINT "F"
LINE (2, 14)-STEP(18, 13), red, B
PAINT (3, 15), yellow, red
LINE (2, 14)-STEP(18, 13), yellow, B
GET (1, 13)-STEP(20, 15), block15      '**End square**


LINE (0, 0)-STEP(20, 15), yellow, BF
LINE (0, 0)-STEP(20, 15), black, B
LINE (14, 4)-STEP(3, 6), yellow, BF
LINE (14, 4)-STEP(3, 6), black, B
LINE (4, 6)-STEP(10, 2), yellow, BF
LINE (4, 6)-STEP(10, 2), black, B
DRAW "ta0 bm 4,8 d2 r2 u r2 d1 r2 u r2 u"
GET (0, 0)-STEP(20, 15), block16        '**Yellow key

LINE (0, 0)-STEP(20, 15), yellow, BF
LINE (0, 0)-STEP(20, 15), black, B
LINE (14, 4)-STEP(3, 6), blue, BF
LINE (14, 4)-STEP(3, 6), black, B
LINE (4, 6)-STEP(10, 2), blue, BF
LINE (4, 6)-STEP(10, 2), black, B
DRAW "ta0 bm 4,8 d2 r2 u r2 d1 r2 u r2 u"
GET (0, 0)-STEP(20, 15), block17        '**Blue key

LINE (0, 0)-STEP(20, 15), yellow, BF
LINE (0, 0)-STEP(20, 15), black, B
LINE (14, 4)-STEP(3, 6), green, BF
LINE (14, 4)-STEP(3, 6), black, B
LINE (4, 6)-STEP(10, 2), green, BF
LINE (4, 6)-STEP(10, 2), black, B
DRAW "ta0 bm 4,8 d2 r2 u r2 d1 r2 u r2 u"
GET (0, 0)-STEP(20, 15), block18        '**Green key

LINE (0, 0)-STEP(20, 15), yellow, BF
LINE (0, 0)-STEP(20, 15), black, B
LINE (14, 4)-STEP(3, 6), white, BF
LINE (14, 4)-STEP(3, 6), black, B
LINE (4, 6)-STEP(10, 2), white, BF
LINE (4, 6)-STEP(10, 2), black, B
DRAW "ta0 bm 4,8 d2 r2 u r2 d1 r2 u r2 u"
GET (0, 0)-STEP(20, 15), block19        '**White key

LINE (0, 0)-STEP(20, 15), yellow, BF
LINE (0, 0)-STEP(20, 15), black, B
CIRCLE (10, 7), 4, black
PAINT (10, 7), black
GET (0, 0)-STEP(20, 15), block20        '**Mined

LINE (0, 0)-STEP(20, 15), yellow, BF
LINE (0, 0)-STEP(20, 15), black, B
LINE (10, 7)-STEP(9, 3), grey
LINE (10, 7)-STEP(-9, 1), grey
LINE (10, 7)-STEP(-2, -6), grey
LINE (10, 7)-STEP(-1, 7), grey
CIRCLE (10, 7), 2, grey
CIRCLE (10, 7), 5, grey
CIRCLE (10, 7), 8, grey
CIRCLE (10, 7), 11, grey
LINE (0, 0)-STEP(20, 15), black, B
GET (0, 0)-STEP(20, 15), block21        '**Web

LINE (0, 0)-STEP(20, 15), yellow, BF
LINE (0, 0)-STEP(20, 15), black, B
LINE (6, 4)-STEP(4, 2), black, BF
LINE (10, 7)-STEP(4, 4), black, BF
CIRCLE (6, 10), 4, black
PAINT (6, 10), Brown, black

GET (0, 0)-STEP(20, 15), block22        '**Supply dump






'16- 19 = keys
'20 = mined
SCREEN , , 0, 0



END SUB

SUB InitSprites
'***************************************************************************
'*Loads the sprites and saves in array variables.                          *
'***************************************************************************



SCREEN , , 1, 0
'**Load Ant***
CALL LoadImage(0, 0, "images\ant.spr")

GET (0, 0)-STEP(19, 13), antr

FOR x = 0 TO 79
  FOR y = 0 TO 27
    IF POINT(x, y) = 2 THEN PSET (x, y), 4
  NEXT y
NEXT x
GET (0, 0)-STEP(19, 13), redr


FOR x = 0 TO 79
  FOR y = 0 TO 27
    IF POINT(x, y) = 0 THEN
      PSET (x, y), 15
    ELSE
      PSET (x, y), 0
    END IF
  NEXT y
NEXT x
GET (0, 0)-STEP(19, 13), antrn

GET (0, 0)-STEP(19, 13), redrn

'**Load Spider**
CALL LoadImage(0, 0, "images\spider.spr")
GET (0, 0)-STEP(19, 13), spir
FOR x = 0 TO 79
  FOR y = 0 TO 27
    IF POINT(x, y) = 0 THEN
      PSET (x, y), 15
    ELSE
      PSET (x, y), 0
    END IF
  NEXT y
NEXT x
GET (0, 0)-STEP(19, 13), spirn


'**Load FLIER**
CALL LoadImage(0, 0, "images\flier.spr")
GET (60, 0)-STEP(19, 13), flieru
FOR x = 0 TO 79
  FOR y = 0 TO 27
    IF POINT(x, y) = 0 THEN
      PSET (x, y), 15
    ELSE
      PSET (x, y), 0
    END IF
  NEXT y
NEXT x
GET (60, 0)-STEP(19, 13), flierun


'**Load Wasp**
CALL LoadImage(0, 0, "images\wasp.spr")
GET (0, 0)-STEP(19, 13), waspr
FOR x = 0 TO 79
  FOR y = 0 TO 27
    IF POINT(x, y) = 0 THEN
      PSET (x, y), 15
    ELSE
      PSET (x, y), 0
    END IF
  NEXT y
NEXT x
GET (0, 0)-STEP(19, 13), wasprn



'******Load Flying ant for credits***
CALL LoadImage(0, 0, "images\flier2.spr")
GET (0, 0)-STEP(19, 13), flier2
FOR x = 0 TO 31
  FOR y = 0 TO 35
    IF POINT(x, y) = 0 THEN
      PSET (x, y), 15
    ELSE
      PSET (x, y), 0
    END IF
  NEXT y
NEXT x
GET (0, 0)-STEP(19, 13), flier2n


SCREEN , , 0, 0


END SUB

REM $DYNAMIC
FUNCTION InternalBitRead% (Variable%, BitNum%)
'***************************************************************************
'*From QMIDI by Jesse Dorland                                              *
'***************************************************************************

VarSegment% = VARSEG(Variable%)
offset% = VARPTR(Variable%)
DEF SEG = VarSegment%
InternalBitRead% = -((PEEK(offset% + BitNum% \ 8) AND 2 ^ (BitNum% MOD 8)) > 0)
DEF SEG
END FUNCTION

SUB InternalBitSet (Variable%, BitNum%, OnOff%)
'***************************************************************************
'*From QMIDI by Jesse Dorland                                              *
'***************************************************************************

VarSegment% = VARSEG(Variable%)
offset% = VARPTR(Variable%)
DEF SEG = VarSegment%
IF OnOff% THEN
	POKE offset% + BitNum% \ 8, PEEK(offset% + BitNum% \ 8) OR 2 ^ (BitNum% MOD 8)
ELSE
	POKE offset% + BitNum% \ 8, PEEK(offset% + BitNum% \ 8) AND 255 - 2 ^ (BitNum% MOD 8)
END IF
DEF SEG
END SUB

SUB InternalBitToggle (Variable%, BitNum%)
'***************************************************************************
'*From QMIDI by Jesse Dorland                                              *
'***************************************************************************

VarSegment% = VARSEG(Variable%)
offset% = VARPTR(Variable%)
DEF SEG = VarSegment%
POKE offset% + BitNum% \ 8, PEEK(offset% + BitNum% \ 8) XOR 2 ^ (BitNum% MOD 8)
DEF SEG
END SUB

SUB InternalGetIntVector (IntNum%, segment&, offset&)
'***************************************************************************
'*From QMIDI by Jesse Dorland                                              *
'***************************************************************************

QMIDIRegs.AX = IntNum% + 13568
CALL IntX(&H21, QMIDIRegs)
segment& = QMIDIRegs.ES
offset& = QMIDIRegs.BX
END SUB

FUNCTION InternalReadMixer% (Index%)
'***************************************************************************
'*From QMIDI by Jesse Dorland                                              *
'***************************************************************************

OUT sb.baseport + 4, Index%
InternalReadMixer% = INP(sb.baseport + 5)
END FUNCTION

SUB InternalWriteMixer (Index%, value%)
'***************************************************************************
'*From QMIDI by Jesse Dorland                                              *
'***************************************************************************

OUT sb.baseport + 4, Index%
OUT sb.baseport + 5, value%
END SUB

REM $STATIC
SUB IntX (IntNum AS INTEGER, Regs AS Registers) STATIC
'***************************************************************************
'*From QMIDI by Jesse Dorland                                              *
'***************************************************************************

STATIC filenum AS INTEGER, IntOffset AS INTEGER, Loaded AS INTEGER
		   
	' use fixed-length string to fix its position in memory
	' and so we don't mess up string pool before routine
	' gets its pointers from caller

DIM IntCode AS STRING * 200
IF NOT Loaded THEN                     ' loaded will be 0 first time
	RESTORE IntXCodeData:
   
	FOR k% = 1 TO 145
		READ h%
		MID$(IntCode, k%, 1) = CHR$(h%)
	NEXT

	'  determine address of interrupt no. offset in IntCode
  
	IntOffset% = INSTR(IntCode$, CHR$(&HCD) + CHR$(&H21)) + 1
	Loaded% = -1
END IF

SELECT CASE IntNum
  
	CASE &H25, &H26, IS > 255               ' ignore these interrupts
  
	CASE ELSE
		DEF SEG = VARSEG(IntCode)             ' poke interrupt number into
		POKE VARPTR(IntCode) * 1& + IntOffset - 1, IntNum     ' code block
		CALL ABSOLUTE(Regs, VARPTR(IntCode$))               ' call routine
END SELECT

END SUB

SUB KillPress
'*****************************************************************************
'*Reads a few INKEYs to stop them carrying through                           *
'*****************************************************************************
FOR looper = 1 TO 20
  nothing$ = INKEY$
NEXT
END SUB

SUB LoadImage (x, y, file$)
'***************************************************************************
'*Loads a memory-map image and places it at x,y.                           *
'***************************************************************************

DIM getscreen(20000)
segment = VARSEG(getscreen(0))
offset = VARPTR(getscreen(0))
DEF SEG = segment
BLOAD file$, offset
PUT (x, y), getscreen, PSET

END SUB

FUNCTION Lts$ (text)
'**Returns trimmed string

Lts$ = LTRIM$(RTRIM$(STR$(text)))


END FUNCTION

SUB MIDICleanup
'***************************************************************************
'*From QMIDI by Jesse Dorland                                              *
'***************************************************************************

FOR I% = 0 TO 255
	IF MEM.SEGMENT(I%) THEN MIDIUnload I%
NEXT I%
MIDI.ERROR = 0
END SUB

REM $DYNAMIC
'***************************************************************************
'*From QMIDI by Jesse Dorland                                              *
'***************************************************************************
'MIDIError - Translates a QMIDI error code into text
FUNCTION MIDIError$
SELECT CASE MIDI.ERROR
		CASE 0: MIDIError$ = "NO ERROR"
		CASE 1: MIDIError$ = "FILE DOES NOT EXIST"
		CASE 2: MIDIError$ = "OUT OF MEMORY"
		CASE 3: MIDIError$ = "NO MIDI FILE PLAYING"
		CASE 4: MIDIError$ = "INVALID SBMIDI INTERRUPT"
		CASE 5: MIDIError$ = "INVALID SBSIM INTERRUPT"
		CASE 6: MIDIError$ = "NO MIXER CHIP"
		CASE 7: MIDIError$ = "COULD NOT DETECT SOUND CARD"
		CASE 8: MIDIError$ = "FEATURE UNAVAILABLE"
		CASE 9: MIDIError$ = "FILE IS CORRUPT"
		CASE 10: MIDIError$ = "INVALID SOUND CARD TYPE"
		CASE 11: MIDIError$ = "COULD NOT PLAY MUSIC"
		CASE 12: MIDIError$ = "ALL HANDLES IN USE"
		CASE 13: MIDIError$ = "INVALID HANDLE NUMBER"
		CASE ELSE: MIDIError$ = "UNKNOWN ERROR"
END SELECT
END FUNCTION

'***************************************************************************
'*From QMIDI by Jesse Dorland                                              *
'***************************************************************************
'MIDILoad - loads a MIDI file into memory
FUNCTION MIDILoad% (Filename$)
MIDILoad% = -1
'See if an extension was supplied, and if not, add one.
IF INSTR(Filename$, ".") = 0 THEN Filename$ = Filename$ + ".MID"
'Open the file
FF% = FREEFILE
OPEN Filename$ FOR BINARY AS #FF%
FileLen& = LOF(FF%)
CLOSE #FF%
'If the file is empty, delete it and exit now.
IF FileLen& = 0 THEN KILL Filename$: MIDI.ERROR = 1: EXIT FUNCTION
'Make the filename an ASCIIZ string.
Filename$ = Filename$ + CHR$(0)

'Find an empty MIDI handle
NewHandle% = -1
FOR I% = 0 TO 255
	IF MEM.SEGMENT(I%) = 0 THEN NewHandle% = I%: EXIT FOR
NEXT I%
'If there are no empty handles, return an error.
IF NewHandle% = -1 THEN MIDI.ERROR = 12: EXIT FUNCTION
'Attempt to allocate a block of conventional memory.
QMIDIRegs.AX = &H4800
QMIDIRegs.BX = (FileLen& \ 16) + 1
CALL IntX(&H21, QMIDIRegs)
'If the block couldn't be allocated, it means there's not enough free
'memory.  To fix this, we need to ask BASIC to release some of the memory
'it's using:
IF QMIDIRegs.AX = 7 OR QMIDIRegs.AX = 8 THEN
	'Find out how much memory is available, in kilobytes.
	LargestBlock& = QMIDIRegs.BX
	LargestBlock& = LargestBlock& * 16
	'Calculate the amount of memory that BASIC needs to release for us.
	MEM.ALLOCATED(NewHandle%) = (FileLen& + 2048) - LargestBlock&
	'Attempt to release the memory.
	A& = SETMEM(-MEM.ALLOCATED(NewHandle%))
	'Try again to allocate a block of memory
	QMIDIRegs.AX = &H4800
	QMIDIRegs.BX = (FileLen& \ 16) + 1
	CALL IntX(&H21, QMIDIRegs)
	'If the second attempt was unsuccessful, then there just isn't
	'enough memory, and an error needs to be returned.
	IF QMIDIRegs.AX = 7 OR QMIDIRegs.AX = 8 THEN
		'Give any memory we took back to BASIC.
		A& = SETMEM(650000)
		'Return an error.
		MIDI.ERROR = 2
		MEM.SEGMENT(NewHandle%) = 0
		'Abort.
		EXIT FUNCTION
	END IF
END IF
'If the memory was allocated successfully, store the segment
'of the memory block.
MEM.SEGMENT(NewHandle%) = QMIDIRegs.AX
MIDISegment& = QMIDIRegs.AX

'Open the MIDI file using a DOS interrupt.
QMIDIRegs.AX = &H3D00
QMIDIRegs.dx = SADD(Filename$)
QMIDIRegs.DS = VARSEG(Filename$)
CALL IntX(&H21, QMIDIRegs)
'Store the file handle.
Handle% = QMIDIRegs.AX
'Read the data from the file in 16 kilobyte increments.
FOR I& = 1 TO FileLen& STEP 16384
	QMIDIRegs.AX = &H3F00
	QMIDIRegs.CX = 16384
	QMIDIRegs.dx = 0
	QMIDIRegs.DS = VAL("&H" + HEX$(MIDISegment&))
	QMIDIRegs.BX = Handle%
	CALL IntX(&H21, QMIDIRegs)
	MIDISegment& = MIDISegment& + 1024
NEXT I&

'Close the file
QMIDIRegs.AX = &H3E00
QMIDIRegs.BX = Handle%
CALL IntX(&H21, QMIDIRegs)

MIDI.ERROR = 0
MIDILoad% = NewHandle%
END FUNCTION

REM $STATIC
SUB MIDILoop
'***************************************************************************
'*From QMIDI by Jesse Dorland                                              *
'***************************************************************************

IF SBMIDI.INTERRUPT < &H80 AND SENSITIVE <> 0 THEN MIDI.ERROR = 4: EXIT SUB
QMIDIRegs.BX = 11
CALL IntX(SBMIDI.INTERRUPT, QMIDIRegs)
IF QMIDIRegs.AX = 0 THEN MIDIPlay CURRENTHANDLE
END SUB

REM $DYNAMIC
'***************************************************************************
'*From QMIDI by Jesse Dorland                                              *
'***************************************************************************
'MIDIplay - Begins playing a MIDI file in the background.
SUB MIDIPlay (Handle%)
IF Handle% < 0 OR Handle% > 255 THEN MIDI.ERROR = 13: EXIT SUB
IF SBMIDI.INTERRUPT < &H80 AND SENSITIVE <> 0 THEN MIDI.ERROR = 4: EXIT SUB
'If sound is not disabled....
IF SOUND.DISABLED = 0 THEN
	'Call the SBMIDI driver to begin playing the MIDI file.
	QMIDIRegs.BX = 4
	QMIDIRegs.dx = MEM.SEGMENT(Handle%)
	QMIDIRegs.AX = 0
	CALL IntX(SBMIDI.INTERRUPT, QMIDIRegs)
	QMIDIRegs.BX = 5
	CALL IntX(SBMIDI.INTERRUPT, QMIDIRegs)
	'If the music could not be started, return an error.
	IF QMIDIRegs.AX <> 0 THEN MIDI.ERROR = 11: EXIT SUB
	'Start the MIDI timer.
	MIDI.PLAYTIME = TIMER
	'Set the current handle.
	CURRENTHANDLE = Handle%
END IF
MIDI.ERROR = 0
END SUB

'***************************************************************************
'*From QMIDI by Jesse Dorland                                              *
'***************************************************************************
'MIDIstop - Stops playing MIDI file
SUB MIDIStop

midiplaying = 0            '**Added by Michael Hughes

IF SBMIDI.INTERRUPT < &H80 AND SENSITIVE <> 0 THEN MIDI.ERROR = 4: EXIT SUB
'Call the SBMIDI driver to stop the music.
IF MIDI.PLAYTIME THEN
	QMIDIRegs.BX = 4
	QMIDIRegs.dx = MEM.SEGMENT(CURRENTHANDLE)
	QMIDIRegs.AX = 0
	CALL IntX(SBMIDI.INTERRUPT, QMIDIRegs)
	MIDI.ERROR = 0
ELSE
	MIDI.ERROR = 3
END IF
MIDI.PLAYTIME = 0
END SUB

REM $STATIC
SUB MIDIUnload (Handle%)
'***************************************************************************
'*From QMIDI by Jesse Dorland                                              *
'***************************************************************************

IF Handle% < 0 OR Handle% > 255 THEN MIDI.ERROR = 13: EXIT SUB
'If a block of memory was allocated to hold the MIDI file....
IF MEM.SEGMENT(Handle%) THEN
	'Release the block of memory.
	QMIDIRegs.ES = MEM.SEGMENT(Handle%)
	QMIDIRegs.AX = &H4900
	CALL IntX(&H21, QMIDIRegs)
	'Give back all the memory we took from BASIC.
	A& = SETMEM(650000)
END IF
MEM.SEGMENT(Handle%) = 0
MEM.ALLOCATED(Handle%) = 0
MIDI.ERROR = 0
END SUB

REM $DYNAMIC
'***************************************************************************
'*From QMIDI by Jesse Dorland                                              *
'***************************************************************************
'MixerChip - Returns name of mixer chip used by sound card
FUNCTION MixerChip$
SELECT CASE MIXER.CHIP
	CASE 0: MixerChip$ = "No Mixer Chip Detected"
	CASE 1: MixerChip$ = "CT1335"
	CASE 2: MixerChip$ = "CT1345"
	CASE 3: MixerChip$ = "CT1745"
	CASE ELSE: MixerChip$ = "Unknown"
END SELECT
END FUNCTION

REM $STATIC
DEFINT I, O
SUB palette.fadein
'***************************************************************************
'*From FADE.BAS by Manny Najera                                            *
'***************************************************************************

DIM tT(1 TO 3)
FOR I = 1 TO 64
WAIT &H3DA, 8, 8
  FOR o = 0 TO 255
    Palette.Get o, Pal
    tT(1) = Pal.red
    tT(2) = Pal.green
    tT(3) = Pal.blue
    IF tT(1) < pData(o, 1) THEN tT(1) = tT(1) + 1
    IF tT(2) < pData(o, 2) THEN tT(2) = tT(2) + 1
    IF tT(3) < pData(o, 3) THEN tT(3) = tT(3) + 1
    Pal.red = tT(1)
    Pal.green = tT(2)
    Pal.blue = tT(3)
    Palette.Set o, Pal
  NEXT o
NEXT I

END SUB

SUB Palette.Fadeout
'***************************************************************************
'*From FADE.BAS by Manny Najera                                            *
'***************************************************************************

DIM tT(1 TO 3)
FOR I = 0 TO 255
  Palette.Get I, Pal
  pData(I, 1) = Pal.red
  pData(I, 2) = Pal.green
  pData(I, 3) = Pal.blue
NEXT I
FOR I = 1 TO 64
WAIT &H3DA, 8, 8
  FOR o = 0 TO 255
    Palette.Get o, Pal
    tT(1) = Pal.red
    tT(2) = Pal.green
    tT(3) = Pal.blue
    IF tT(1) > 0 THEN tT(1) = tT(1) - 1
    IF tT(2) > 0 THEN tT(2) = tT(2) - 1
    IF tT(3) > 0 THEN tT(3) = tT(3) - 1
    Pal.red = tT(1)
    Pal.green = tT(2)
    Pal.blue = tT(3)
    Palette.Set o, Pal
  NEXT o
NEXT I
END SUB

DEFSNG I, O
SUB Palette.Get (nColor%, pInfo AS PaletteType)
'***************************************************************************
'*From FADE.BAS by Manny Najera                                            *
'***************************************************************************

OUT &H3C6, &HFF
OUT &H3C7, nColor%
pInfo.red = INP(&H3C9)
pInfo.green = INP(&H3C9)
pInfo.blue = INP(&H3C9)
END SUB

SUB Palette.Set (nColor%, pInfo AS PaletteType)
'***************************************************************************
'*From FADE.BAS by Manny Najera                                            *
'***************************************************************************

OUT &H3C6, &HFF
OUT &H3C8, nColor%
OUT &H3C9, pInfo.red
OUT &H3C9, pInfo.green
OUT &H3C9, pInfo.blue
END SUB

'SetCard - Properly Sets the Sound Card Type
SUB SetCard (CardType%)
'***************************************************************************
'*From QMIDI by Jesse Dorland                                              *
'***************************************************************************

'If the card type is invalid, return an error
IF CardType% < 1 OR CardType% > 8 THEN
	MIDI.ERROR = 10
	EXIT SUB
END IF
'Otherwise, set the new card type.
sb.cardtype = CardType%
'Then, set the mixer chip accordingly.
SELECT CASE CardType%
	'If the card is a Sound Blaster 1.0/1.5 or equivalent....
	CASE 1
		'Return an error.
		MIDI.ERROR = 6
		'If sensitive error checking is on, disable mixer operations and
		'exit.
		IF SENSITIVE THEN
			MIXER.CHIP = 0
			EXIT SUB
		'Otherwise, set the earliest mixer chip and continue.
		ELSE
			MIXER.CHIP = 1
		END IF
	'If the card is a Sound Blaster 2.0/2.5 or equivalent....
	CASE 3
		'There are two different kinds of SB 2.0 cards: the regular SB2,
		'and the SB2CD.  The SB2CD has a mixer chip (the CT1335), whereas
		'the SB 2.0 does not.  The way to tell them apart is that the
		'Sound Blaster 2.0 uses Base Ports 220h and 240h, and the SB2CD
		'uses ports 250h and 260h.
		'
		'Assume the sound card is an SB2CD for now...
		MIXER.CHIP = 1
		'If the card is defined as an SB 2.0, not an SB 2.0 CD, and
		'sensitive error checking is on, disable mixer operations.
		IF (BasePort% = &H220 OR BasePort% = &H240) AND SENSITIVE <> 0 THEN
			MIXER.CHIP = 0
		END IF
		MIDI.ERROR = 0
	'If the card is a Sound Blaster Pro, assume chip CT1345
	CASE 2, 4, 5
		MIXER.CHIP = 2
		MIDI.ERROR = 0
	'If the card is a Sound Blaster 16 or later, assume chip CT1745
	CASE ELSE
		MIXER.CHIP = 3
		MIDI.ERROR = 0
END SELECT
END SUB

REM $DYNAMIC
'***************************************************************************
'*From QMIDI by Jesse Dorland                                              *
'***************************************************************************
'SoundCard - Translates card type into text
FUNCTION SoundCard$ (CardType%)
SELECT CASE CardType%
	CASE 1: SoundCard$ = "Sound Blaster 1.0/1.5"
	CASE 2: SoundCard$ = "Sound Blaster Pro"
	CASE 3: SoundCard$ = "Sound Blaster 2.0"
	CASE 4, 5: SoundCard$ = "Sound Blaster Pro 2"
	CASE 6: SoundCard$ = "Sound Blaster 16/32/AWE32/AWE64"
	CASE ELSE: SoundCard$ = "Unknown"
END SELECT
END FUNCTION

REM $STATIC
FUNCTION WordWrap$ (text$, w, event)
'***************************************************************************
'*WORDWRAP v2.0 By Michael Hughes (www.geocities.com/mhsoft_online)        *
'*-----------------------------------------------------------------        *
'*Wordwrap allows effortless wrapping of text.                             *
'*  Text$ = The text you want wordwrapped                                  *
'*  w     = The line width to wrap to                                      *
'*  event = What you want returned:                                        *
'*          -0 returns the number of lines                                 *
'*          -Any other number return the text to go on that line           *
'*          -A negative number gives the start position of that line       *
'***************************************************************************

lprint$ = text$ + " "
wid = w
lineon = 0
doposret = 0

IF event < 0 THEN
  event = ABS(event)
  doposret = 1
END IF
poson = 1
DO
  lineon = lineon + 1
  IF LEN(lprint$) < wid THEN
    IF event = lineon THEN
      IF doposret = 0 THEN
	WordWrap$ = lprint$
	EXIT FUNCTION
      ELSE
	poson = LEN(lprint$)
	WordWrap$ = STR$(poson)
      END IF
    END IF
    EXIT DO
  END IF

  FOR x = wid TO 1 STEP -1
    IF MID$(lprint$, x, 1) = " " THEN
      IF event = lineon THEN
	IF doposret = 0 THEN
	  WordWrap$ = MID$(lprint$, 1, x)
	  EXIT FUNCTION
	ELSE
	  poson = x
	  WordWrap$ = STR$(poson)
	END IF
      END IF
      lprint$ = MID$(lprint$, x + 1)
      GOTO utils.wordwrap.gotit
    END IF
  NEXT x
  IF event = lineon THEN
    IF doposret = 0 THEN
      WordWrap$ = MID$(lprint$, 1, wid)
      EXIT FUNCTION
    ELSE
      poson = wid
      WordWrap$ = STR$(poson)
    END IF
  END IF
  lprint$ = MID$(lprint$, wid + 1)
utils.wordwrap.gotit:
LOOP

IF event = 0 THEN WordWrap$ = STR$(lineon)

END FUNCTION

