/******************************************************************************/
(include "sci.sh")
(include "game.sh")
/******************************************************************************/
(script 5)
/******************************************************************************/
(use "main")
(use "controls")
(use "cycle")
(use "game")
(use "feature")
(use "obj")
(use "inv")
(use "door")
(use "jump")
(use "menubar")
/******************************************************************************/
(instance public rm005 of Rm
 (properties
  picture scriptNumber
  // Set up the rooms to go to/come from here
		north 0
		east 0
		south 3
		west 0
 )
 (method (init)
		// same in every script, starts things up
  (super:init())
  (self:setScript(RoomScript))

  		// Check which room ego came from and position it
  (switch(gPreviousRoomNumber)
            /******************************************************
             * Put the cases here for the rooms ego can come from *
             ******************************************************/
   (default
    (send gEgo:
  	 posn(166 180)
  	 loop(3)
    )
   )
  )

		// Set up the ego
  SetUpEgo()
  (send gEgo:init())
        (clerk:init())
       (if(== Coins 2)
        (aBoy2:
         init()
         setCycle(Fwd)
        )
        (tv:
         init()
         setCycle(Fwd)
        )
       )(else
        (aBoy1:init())
       )
       (self:setRegions(700))

        /****************************************
         * Set up the room's music to play here *
         ****************************************/ /*
		(send gTheMusic:
			prevSignal(0)
			stop()
			number(scriptNumber)
			loop(-1)
			play()
		)*/

        /**************************************************
         * Add the rest of your initialization stuff here *
         **************************************************/

 )
)

/******************************************************************************/
(instance RoomScript of Script
 (properties)
 (method (handleEvent pEvent)
  (var dyingScript)
  (super:handleEvent(pEvent))

        /*****************************************
         * Handle the possible said phrases here *
         *****************************************/
  (if(Said('insert>'))
   (if(Said('/coin'))
    (if(== Coins 1)
     Print("Vous etes trop vieux pour jouer aux arcades.")
    )(else
     Print("Vous n'avez pas de jetons pour jouer aux arcades.")
    )
   )
   (if(Said('/credit'))
    Print("Vous ne pouvez pas inserer votre carte de credit pour jouer aux arcades.")
   )
  )
  (if(Said('take/arcade'))
    Print("Vous ne pouvez pas porter cet arcade sur vous. L'arcade est bien trop lourd. Bel essai.")
   (if(== Arcade 0)
    = Arcade(+ Arcade 1)
    = gScore(+ gScore 1)
   )
  )
  (if(Said('look>'))
   (if(Said('/child,boy'))
    (if(== Coins 2)
     Print("Le garcon joue a l'arcade. Ne le deranger pas.")
    )(else
     Print("Le garcon est pres de l'arcade. Il a l'air triste.")
    )
    )(else
    (if(Said('/clerk,man'))
     Print("Le caissier attend votre commande.")
     )(else
      (if(Said('/menu'))
       Print("Vous pouvez seulement acheter du hamburger et du cola.")
      )(else
       (if(Said('/arcade'))
        Print("Une arcade est utilisee pour garder les jeunes occupes.")
       )(else
        (if(Said('[ /* , !* ]'))
         Print(
         "Vous etes au restaurant McJoe. "+
         "Un caissier est derriere le comptoir. "+
         "Un enfant est pres de l'arcade. "+
         "Le menu est affiche sur un mur."
        )
       )
      )
     )
    )
   )
  )
  (if(Said('talk,say>'))
   (if(Said('/clerk,man'))
    (if(< (send gEgo:distanceTo(clerk)) 20)
     Print("\"Bienvenue chez McJoe. Puis-je vous aider?\""  #title "Le caissier:")
    )(else
     Print("Approchez vous du caissier si vous avez affaire a lui.")
    )
   )
   (if(Said('/kid,boy'))
    (if(< (send gEgo:distanceTo(aBoy1)) 20)
     (if(< Coins 2)
      Print("\"Zut! Jai plus de jetons.\""  #title "Un garcon:")
     )(else
      Print("Il est trop occupe en ce moment.")
     )
    )(else
     Print("Approchez vous du garcon si vous voulez parler avec lui.")
    )
   )
  )
  (if(Said('give>'))
   (if(Said('/coin'))
    (if(<> Coins 1)
     Print("Vous n'avez pas de jetons.")
    )(else
     (if(< (send gEgo:distanceTo(clerk)) 20)
      Print("Le caissier n'a pas besoin de jetons.")
     )(
      (if(< (send gEgo:distanceTo(aBoy1)) 20)
       (if (== Coins 1)
        Print("Vous donnez le jeton au garcon.")
        Print("\"Merci monsieur.\""  #title "Un garcon:")
        = Coins 2
        = gScore (+ gScore 2)
        (send gEgo:put(INV_COIN scriptNumber))
        (aBoy1:hide())
        (aBoy2:
         init()
         setCycle(Fwd)
        )
        (tv:
         init()
         setCycle(Fwd)
        )
       )
      )
     )
    )
   )
  )
  (if(Said('buy>'))
   (if(Said('/cola'))
    (if(< (send gEgo:distanceTo(clerk)) 20)
     (if(> Cola 0)
      Print("Vous n'avez pas besoin d'autres colas.")
     )(else
      Print("Utilisant votre carte de credit, vous payez le cola au caissier.")
      (send gEgo:get(INV_COLA))
      (= Cola(+ Cola 1))
      (= gScore(+ gScore 2))
     )
    )(else
     Print("Approcher du caissier si vous voulez acheter quelque chose.")
    )
   )
   (if(Said('/hamburger'))
    (if(< (send gEgo:distanceTo(clerk)) 20)
     (if(> Hamburger 0)
      Print("Un seul hamburger est suffisant.")
     )(else
      Print("Vous payez un hamburger avec votre carte de credit.")
      (send gEgo:get(INV_HAMBURGER))
      (= Hamburger(+ Hamburger 1))
      (= gScore(+ gScore 2))
     )
    )(else
     Print("Approcher du caissier si vous voulez acheter quelque chose.")
    )
   )
  )
 )
)
(instance clerk of Act
  (properties
    y 130
    x 125
    view 9
  )
)
(instance aBoy1 of Act
  (properties
    y 116
    x 201
    view 16
    loop 0
  )
)
(instance aBoy2 of Act
  (properties
    y 116
    x 201
    view 16
    loop 1
  )
)
(instance tv of Act
  (properties
    y 89
    x 199
    view 18
  )
)
/******************************************************************************/
