/******************************************************************************
 SCI Template Game
 By Brian Provinciano
 ******************************************************************************
 rm002.sc
 Contains the first room of your game.
 ******************************************************************************/
(include "sci.sh")
(include "game.sh")
/******************************************************************************/
(script 2)
/******************************************************************************/
(use "main")
(use "controls")
(use "cycle")
(use "game")
(use "feature")
(use "obj")
(use "inv")
(use "door")
(use "jump")
(use "menubar")
/******************************************************************************/
(instance public rm002 of Rm
 (properties
  picture scriptNumber
		// Set up the rooms to go to/come from here
		north 0
		east 3
		south 0
		west 1
 )
 (method (init)
		// same in every script, starts things up
  (super:init())
  (self:setScript(RoomScript))

  		// Check which room ego came from and position it
  (switch(gPreviousRoomNumber)
            /******************************************************
             * Put the cases here for the rooms ego can come from *
             ******************************************************/
  (case west
   (send gEgo:
  	posn(5 160)
  	loop(0)
   )
  )
  (case east
   (send gEgo:
  	posn(310 160)
  	loop(1)
   )
  )

            // Set up ego's position if it hasn't come from any room
  (default
   (send gEgo:
  					posn(150 170)
  					loop(1)
   )
  )
 )
		// Set up the ego
		SetUpEgo()
		(send gEgo:init())
        /****************************************
         * Set up the room's music to play here *
         ****************************************/ /*
		(send gTheMusic:
			prevSignal(0)
			stop()
			number(scriptNumber)
			loop(-1)
			play()
		)*/

        /**************************************************
         * Add the rest of your initialization stuff here *
         **************************************************/
  (if(== gPreviousRoomNumber 976)
   Print("\"Si je ne retrouve pas mon ordi dans quatre minutes, mon Commodore 64 sera fichu.\""   #title "DG:")
   (send gEgo:get(INV_CREDIT_CARD))
   (TheMenuBar:draw())
   (SL:enable())
  )
  (self:setRegions(700))
 )
)
/******************************************************************************/
(instance RoomScript of Script
 (properties)
 (method (handleEvent pEvent)
  (var dyingScript)
  (super:handleEvent(pEvent))
        /*****************************************
         * Handle the possible said phrases here *
         *****************************************/
  (if(Said('look>'))
   (if(Said('/fence'))
    Print("La cloture est brun!")
   )(else
    (if(Said('/hamburger'))
     FormatPrint("Hamburger %d " Hamburger)
    )(else
     (if(Said('/street'))
      Print("La rue est calme en ce moment.")
     )(else
      (if(Said('[ /* , !* ]'))
       Print("Vous etes dans la rue.")
      )
     )
    )
   )
  )
  (if(Said('climb/fence'))
   Print("Vous avez aucun raison de grimper a la cloture.")
  )
 )
)
/******************************************************************************/
