/******************************************************************************
 SCI Template Game
 By Brian Provinciano
 ******************************************************************************
 rm001.sc
 Contains the first room of your game.
 ******************************************************************************/
(include "sci.sh")
(include "game.sh")
/******************************************************************************/
(script 1)
/******************************************************************************/
(use "main")
(use "controls")
(use "cycle")
(use "game")
(use "feature")
(use "obj")
(use "inv")
(use "door")
(use "jump")
(use "menubar")
/******************************************************************************/
(instance public rm001 of Rm
 (properties
  picture scriptNumber
  // Set up the rooms to go to/come from here
		north 0
		east 2
		south 0
		west 4
 )
 (method (init)
		// same in every script, starts things up
  (super:init())
  (self:setScript(RoomScript))

  		// Check which room ego came from and position it
  (switch(gPreviousRoomNumber)
            /******************************************************
             * Put the cases here for the rooms ego can come from *
             ******************************************************/
   (case east
    (send gEgo:
     posn(310 160)
   	 loop(1)
    )
   )
   (case west
    (send gEgo:
  	 posn(10 160)
  	 loop(0)
    )
   )
   (default
    (send gEgo:
  	 posn(210 110)
  	 loop(2)
    )
   )
  )

		// Set up the ego
  SetUpEgo()
  (send gEgo:init())

        /****************************************
         * Set up the room's music to play here *
         ****************************************/ /*
		(send gTheMusic:
			prevSignal(0)
			stop()
			number(scriptNumber)
			loop(-1)
			play()
		)*/

        /**************************************************
         * Add the rest of your initialization stuff here *
         **************************************************/
  (if(== Coins 0)
   (thecoin:
    init()
    ignoreActors(TRUE)
    setPri(4)
    setCycle(Fwd)
   )
  )
  (self:setRegions(700))
 )
)

/******************************************************************************/
(instance RoomScript of Script
 (properties)
 (method (handleEvent pEvent)
  (var dyingScript)
  (super:handleEvent(pEvent))
        /*****************************************
         * Handle the possible said phrases here *
         *****************************************/
  (if(Said('open/door'))
   (if(send gEgo:inRect(99 83 167 89))
    Print("Ce n'est vraiment pas le moment de rendre visite a votre frere jumeau GD a l'hopital.\n\n"+
          "VOUS AVEZ UN ORDINATEUR A SAUVER OU VOUS NE POURREZ JAMAIS FINIR LE JEU. D'accord?!")
    Print("Pour connaitre ce qui est arrive a GD, vous devriez jouer aux jeux precedents de DG.")
   )(else
    Print("Vous ne pouvez pas ouvrir la porte a distance.")
   )
  )
  (if(Said('look>'))
   (if(Said('/street'))
     Print("La rue est calme.")
   )(else
    (if(Said('/building,hospital'))
     Print("He oui. C'est un hopital.")
    )(else
     (if(Said('/coin'))
      (if(== Coins 0)
       Print("Vous voyez un jeton par terre.")
      )(else
       Print("Il n'y a pas de jeton ici.")
      )
     )(else
      (if(Said('[ /* , !* ]'))
       Print("Vous etes a l'exterieur. Un hopital est tout pres.")
       (if(== Coins 0)
        Print("Vous voyez un jeton sur le sol.")
       )
      )
     )
    )
   )
  )
  (if(Said('take/coin'))
   (if(> Coins 0)
    Print("Vous avez deja pris le jeton!")
   )(else
    (if(send gEgo:inRect(140 150 180 170))
     Print("Vous prenez le jeton.")
     (= gScore(+ gScore 2))
     (= Coins(+ Coins 1))
     (send gEgo:get(INV_COIN))
     (thecoin:hide())
    )(else
     Print("Vous n'etes pas assez proche!")
    )
   )
  )
 )
)

(instance thecoin of Prop
 (properties
    y 160
    x 160
    view 5
 )
)
/******************************************************************************/
