/******************************************************************************
 SCI Template Game
 By Brian Provinciano
 ******************************************************************************
 menubar.sc
 Contains the customized Menubar class. This is the script you modify if you 
 want to customize the menu.
 ******************************************************************************/
(include "sci.sh")
(include "game.sh")
/******************************************************************************/
(script MENUBAR_SCRIPT)
/******************************************************************************/
(use "main")
(use "controls")
(use "gauge")
(use "sound")
(use "user")
/******************************************************************************/
(class TheMenuBar of MenuBar
	(properties
		state 0
	)
	(method (init)
		AddMenu(
			"  "
				"Au sujet de`^a:"+
				"Conseils`#1"
		)
		AddMenu(
			" File "
				"Recommencer`#9:"+
				"Sauvegarder`#5:"+
				"Restaurer  `#7:"+
				"--! :"+
				"Quitter`^q"
		)
		AddMenu(
			" Action "
				"Pause `^p:"+
				"Inventaire`^I:"+
				"Reecrire`#3:"+
				"--! :"+
				"Couleurs`^c"
		)
		AddMenu(
			" Vitesse "
				"Changer...`^s:"+
				"--!:"+
				"Rapide`+:"+
				"Normal`=:"+
				"Lent`-"
		)
		(if(DoSound(sndSET_SOUND))
			AddMenu(
				" Son "
					"Volume...`^v:"+
					"Turn Off`#2=1"
			)
		)(else
			AddMenu(
				" Son "
					"Volume...`^v:"+
					"Turn On`#2=1"
			)
		)
		(if(< Graph(grGET_COLOURS) 9)
			SetMenu(MENU_COLOURS 32 0)
		)(else
			SetMenu(MENU_COLOURS smMENU_SAID '/color')
		)
		SetMenu(MENU_SAVE		smMENU_SAID 'save[/game]')
		SetMenu(MENU_RESTORE	smMENU_SAID 'restore[/game]')
		SetMenu(MENU_RESTART	smMENU_SAID 'restart[/game]')
		SetMenu(MENU_QUIT		smMENU_SAID 'done[/game]')
		SetMenu(MENU_PAUSE		smMENU_SAID 'delay[/game]')
		SetMenu(MENU_INVENTORY	smMENU_SAID 'all')
	)
	(method (handleEvent pEvent)
		(var menuItem, hGauge, newSpeed, newVolume, wndCol, wndBack, hPause)
		= menuItem (super:handleEvent(pEvent))
		(switch(menuItem)
			(case MENU_ABOUT
				Print(
					"DG: I want my C64 back\n\n"+
					"par Robin Gravel avec l'aide "+
					"de Brian Provinciano."
					#title "Au sujet de:"
				)
			)
			(case MENU_HELP
				Print(
                    "    <F1> ecrire ce message\n"+
                    "    <F2> turn the sound on or off\n"+
                    "    <F5> sauvegarder une partie\n"+
                    "    <F7> restaurer une partie\n"+
                    "    <F9> recommencer depuis le debut\n"+
                    "   <Tab> consulter l'inventaire\n"+
                    "<CTRL+Q> Quitter le jeu"
					#title "Les touches du clavier"
				)
			)
			(case MENU_RESTART
				(if(Print(
					  "Etes vous serieux? Vous voulez recommencer depuis le debut?"
					  #title "Recommencer"
					  #font gDefaultFont
					  #button "Oui je suis serieux." 1
					  #button "Ayoye! Ou on ai-je la tete?" 0
					)
				   )
					(send gGame:restart())						
				)
			)
			(case MENU_RESTORE   
				(send gGame:restore())
			)
			(case MENU_SAVE		  		    
				(send gGame:save())
			)
			(case MENU_QUIT		  	
				(if(Print(
					  "Voulez vous vraiment quitter?"
					  #title "Quitter"
					  #font gDefaultFont
					  #button " Oui. Et tout de suite." 1
					  #button " J'avais appuye sur une mauvaise touche." 0
					)
				   )
						= gQuitGame TRUE					
				)
			)
			(case MENU_PAUSE
				= hPause (Sound:pause())
 				Print("Pause")
 				(Sound:pause(hPause))
			)
			(case MENU_INVENTORY
				(if(PrintCantDoThat($400))
					(send gInv:showSelf(gEgo))
		    	)
			)
			(case MENU_RETYPE
				(send pEvent:
					claimed(FALSE)
					type(evKEYBOARD)
					message( (User:echo) )
				)
			)
			(case MENU_COLOURS
				= wndCol 16
				(while(>u wndCol 15 and <> wndCol -1)
					= wndCol GetNumber("Couleur texte: (0-15)")
				)
				(if(<> wndCol -1)
					= wndBack 16
					(while(<> wndBack -1 and >u wndBack 15 or == wndCol wndBack)
						= wndBack GetNumber("Couleur d'arriere plan: (0-15)")
					)
					(if(<> wndBack -1)
						= gWndColor wndCol
						= gWndBack wndBack
						(send gTheWindow:
							color(gWndColor)
							back(gWndBack)
						)
					)
				)
			)
			(case MENU_CHANGESPEED
				= hGauge (Gauge:new())
				= newSpeed
					(send hGauge:
						text("Vitesse")
						description("Utiliser les fleches pour ajuster la vitesse du jeu.")
						higher("Rapide")
						lower("Lent")
						normal(NORMAL_SPEED)
						doit(- 15 gSpeed)
					)
				(send gGame:setSpeed(- 15 newSpeed))
				DisposeScript(GAUGE_SCRIPT)
			)
			(case MENU_FASTERSPEED
				(if(gSpeed)
					(send gGame:setSpeed(--gSpeed))
				)
			)
			(case MENU_NORMALSPEED
				(if(gSpeed)
					(send gGame:setSpeed(12))
				)
			)
			(case MENU_SLOWERSPEED
				(if(< gSpeed 15)
					(send gGame:setSpeed(++gSpeed))
				)
			)
			(case MENU_VOLUME
				= hGauge (Gauge:new())
				= newVolume
					(send hGauge:
						text("Volume du son")
						description("Utiliser les fleches gauche et droite pour ajuster le volume du son.")
						higher("Plus fort")
						lower("Moins fort")
						normal(15)
						doit(DoSound(sndVOLUME newVolume))
					)
				DoSound(sndVOLUME newVolume)
				DisposeScript(GAUGE_SCRIPT)
			)
			(case MENU_TOGGLESOUND
				ToggleSound()
			)
		)
	)
)
/******************************************************************************/
(procedure public (ToggleSound)
	(var SOUND_OFF)
	= SOUND_OFF DoSound(sndSET_SOUND)
	= SOUND_OFF DoSound( sndSET_SOUND not(SOUND_OFF) )
	(if(SOUND_OFF)
		SetMenu(MENU_TOGGLESOUND smMENU_TEXT "Turn On")
	)(else
		SetMenu(MENU_TOGGLESOUND smMENU_TEXT "Turn Off")
	)
)
/******************************************************************************/
