/******************************************************************************/
(include "sci.sh")
(include "game.sh")
/******************************************************************************/
(script 4)
/******************************************************************************/
(use "controls")
(use "cycle")
(use "feature")
(use "game")
(use "inv")
(use "main")
(use "obj")
/******************************************************************************/
(instance public rm004 of Rm
	(properties
		picture scriptNumber
		north 0
		east 1
		south 0
		west 0
	)
	(method (init)
		(super:init())
		(self:setScript(RoomScript))

		(switch(gPreviousRoomNumber)
            /******************************************************
             * Put the cases here for the rooms ego can come from *
             ******************************************************/
            (case east
  				(send gEgo:
  					posn(310 160)
  					loop(1)
  				)
  			)
		)

		SetUpEgo()
		(send gEgo:init())
        (aMan:init())
     (self:setRegions(700))

	)
)
/******************************************************************************/
(instance RoomScript of Script
 (properties)
 (method (handleEvent pEvent)
  (var dyingScript)
  (super:handleEvent(pEvent))

        /*****************************************
         * Handle the possible said phrases here *
         *****************************************/
  (if(Said('give>'))
   (if(Said('/hamburger'))
    (if(== Hamburger 0)
     Print("You don't have it.")
    )(else
     (if(== Guard 0)
      Print("\"I'm not hungry at the moment. Thanks anyway.\"" #title "The guard:")
     )(else
      Print("You give hamburger to the guard.")
      (= Hamburger(+ Hamburger 1))
      (if(== Cola 2)
       Print("\"Now you can enter inside the building.\"" #title "The guard:")
       (= Guard(+ Guard 1))
      )(else
       Print("\"I'm thirsty. I need some drinks.\"" #title "The guard:")
      )
      (= gScore(+ gScore 3))
      (send gEgo:put(INV_HAMBURGER scriptNumber))
     )
    )
   )
   (if(Said('/cola'))
    (if(== Cola 0)
     Print("You don't have it.")
    )(else
     (if(== Guard 0)
      Print("\"I'm not need a cola now. Thanks anyway.\"" #title "The guard:")
     )(else
      Print("You give the cola to the guard.")
      (= Cola(+ Cola 1))
      (if(== Hamburger 2)
       Print("\"Now you can enter inside the building.\"" #title "The guard:")
       (= Guard(+ Guard 1))
      )(else
       Print("\"I'm hungry. I need something to eat.\"" #title "The guard:")
      )
      (= gScore(+ gScore 2))
      (send gEgo:put(INV_COLA scriptNumber))
     )
    )
   )

  )
  (if(Said('look>'))
   (if(Said('/guard, man'))
    Print("The guard prevents anyone entering inside the building without permission.")
   )(else
    (if(Said('[ /* , !* ]'))
     Print("You are at the front of the recycling center. You see a guard.")
    )
   )
  )
  (if(Said('talk/man, guard'))
   (if(< (send gEgo:distanceTo(aMan)) 40)
    (if(== Guard 2)
     Print("\"Now you can go in.\"" #title "The guard:")
    )(
     (if(== Guard 1)
      Print("\"Get out of here! Or I call the police.\"" #title "The guard:")
     )(else
      (if(== Guard 0)
       Print("\"My wife will cook a good meal this night.\"" #title "The guard:")
       Print("\"Hey you! What do you want?\"" #title "The guard:")
       Print("\"I want to go inside this building to take back my C64.\"" #title "DG:")
       Print("\"I'm sorry. Only autorized personnals can enter to the recyling center.\"" #title "The guard:")
       = Guard (+ Guard 1)
     )
    )
    )
   )(else
    Print("You don't want to yell. Get closer.")
   )
  )
  (if(Said('open/door'))
   (if(send gEgo:inRect(24 88 74 94))
    (if(not(== Guard 2))
     Print("\"I must have to deal with this guard before I'm entering inside the building.\"" #title"DG:")
    )(else
     (send gRoom:newRoom(6))
    )
   )(else
    Print("Get closer to a door.")
   )
  )
 )
)
(instance aMan of Act
  (properties
    y 90
    x 76
    view 4
  )
)
/******************************************************************************/
