/************************************************************************/
/************************************************************************/
/*																		*/
/*	Name :		DREWAN.H												*/
/*	Project :	Tomb of Drewan in 'C'									*/
/*	Author :	Paul Robson												*/
/*	Created :	23rd April 2001											*/
/*	Function :	Include file											*/
/*	Changes :															*/
/*																		*/
/************************************************************************/
/************************************************************************/

#define	 VERSION		(100)				/* Version Number */

#include <stdio.h> 							/* Lotsa prototyping */
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <stdarg.h>
#include <math.h>
#include "structs.h"						/* Game structures */

void IOInitialise(int);						/* Prototyping for PORTIO.C */
void IOTerminate(void);
long IOTimer(void);
void IODraw(int,int,int,int);
int	 IOGet(void);
int	 IOGetCaps(void);
void IOFrame(int);
int  IOIsClassic(void);
void IOShowURL(int,char *);

int  IOXMapTileDraw(int,int,int,int);
int	 IOXAlphaDraw(int,int,int,int);
int	 IOXDraw(int,int,int,int);
int  IOXPanel(void);
int  IOXPanelRefresh(PLAYER *);
int  IOXMessage(int,char *);
int  IOXRemMessage(PLAYER *,ROOM *);

void ROOMDraw(PLAYER *,ROOM *,int);			/* Prototyping for ROOM.C */
char *ROOMObject(int);
int ROOMStyle(int n);

void DRAWClear(void);						/* Prototyping for DRAW.C */
void DRAWChar(int,int,int,int);
int	 DRAWGet(int,int);
void DRAWPrint(int,int,int,char *);
void DRAWAnimate(POINT *,POINT *,int,int,int);
void DRAWDelay(int);
void DRAWMessage(int,char *);
void DRAWRemMessage(PLAYER *,ROOM *);
int  DRAWToward(int,int);
void DRAWRefresh(int,int);

#define MAP(x,y) (DRAWGet(x,y) & 0x7F)

void TITLEPage1(void);						/* Prototyping for TITLE.C */
int  TITLEPage2(void);
void TITLEInfo(int);
void TITLECPrint(int y,int Col,char *Text);

void MONSTGetInfo(MONSTER *);				/* Prototyping for MONST.C */
void MONSTAction(PLAYER *p,ROOM *r);
void MONSTVampire(PLAYER *p,ROOM *r);
int  MONSTDamage(PLAYER *,ROOM *,int,int,int);

int MAINMissile(PLAYER *,ROOM *,POINT *,	/* Prototyping for MAIN.C */
								int,POINT *,int);

void PLAYERInit(PLAYER *p,int Seed);		/* Prototyping for PLAYER.C */
int  PLAYERResurrect(PLAYER *,ROOM *);
void PLAYERReport(PLAYER *,ROOM *);
int	 PLAYERHasWon(PLAYER *);

void PANELDraw(PLAYER *);					/* Prototyping for PANEL.C */
void PANELRefresh(PLAYER *);

int	 PARAMGet(int,int);						/* Prototyping for PARAM.C */
void PARAMInit(void);
void PARAMWrite(void);
#define		PARAM(n,c)		PARAMGet(n,c)

#define		MPT_ROOM		(0)				/* Map styles */
#define		MPT_GARDEN		(1)
#define		MPT_DUNGEON		(2)

#define  	KEY_LEFT        (':')			/* Movement keys */
#define		KEY_RIGHT		(';')			/* This odd choice comes from */
#define		KEY_UP			('@')			/* The VIC20 original. We map */
#define		KEY_DOWN		('/')			/* Cursor, Delete, End onto */
#define		KEY_LOOKLEFT	('L')			/* these */
#define		KEY_LOOKRIGHT	('=')

#define		COL_BLACK		(0)				/* Standard colours */
#define		COL_WHITE		(1)				/* for a VIC-20 */
#define 	COL_RED			(2)
#define		COL_CYAN		(3)
#define		COL_MAGENTA		(4)
#define		COL_GREEN		(5)
#define		COL_BLUE		(6)
#define		COL_YELLOW		(7)
#define		COL_REVTEXT		(0x10)			/* Reverse text for GPrintf() */

#define		DC_PIXEL		(0x0001)		/* Draw Chars to pixel accuracy */
#define		DC_COLOUR		(0x0002)		/* Supports colour display */
#define		DC_BACKGROUND	(0x0004)		/* Background colour changeable */

#define		GR_DOOR			(32)			/* Door */
#define 	GR_SPACE		(32)
#define		GRX_NOOBJECT	(32|0x100)		/* Doesn't have panel object */
#define		GRX_HASOBJECT	(42|0x100)		/* Has object on panel [*] */
#define		GRX_REFLECTMONSTER (42|0x200)
#define 	GRX_WATERSTONE	(87|0x100)
#define 	GRX_AMULET		(65|0x200)
#define 	GRX_AIRSTONE	(65|0x100)
#define 	GRX_EARTHSTONE	(69|0x100)
#define 	GRX_FIRESTONE	(70|0x100)
#define		GR_PLAYER		(97)
#define		GR_BRICK		(98)			/* Brick Graphic */
#define		GRX_OUTSIDEWALL	(98|0x100)		/* Outside wall graphic */
#define		GRX_TREE		(98|0x200)
#define		GRX_STONE		(98|0x300)
#define		GR_TREASURE		(99)			/* Treasure */
#define		GR_LOOKLEFT		(100)
#define		GR_LOOKRIGHT	(101)
#define		GR_MONSTER		(102)
#define		GR_MAGICMONSTER	(103)
#define		GR_SWORDLEFT	(104)
#define		GR_ALTSWORD		(105)
#define		GR_SWORDRIGHT	(106)
#define 	GR_BOLT			(107)
#define		GR_LARROW		(108)
#define		GR_RARROW		(109)
#define		GR_SPLAT		(110)
#define		GR_VAMPIRE		(111)
#define		GR_MIRROR		(112)
#define		GR_LFIRE		(113)
#define		GR_RFIRE		(114)
#define		GR_ONFIRE		(115)
#define		GR_LCHAOS		(116)
#define		GR_RCHAOS		(117)
#define		GR_WATER		(118)
#define		GR_CHAOSMIST	(118)
#define		GR_PETRIFY		(119)
#define		GR_TOMBLORD		(127)

#define		GRAN_UPDOWN		(0x4000)		/* Top bits can be used for */
#define		GRAN_LEFT		(0x8000)		/* Animation if reqd */
#define		GRAN_RIGHT		(0xC000)

#define		MS_DEAD			(0)				/* Monster states */
#define		MS_FROZEN		(1)
#define		MS_ACTIVE		(2)
#define		MS_INACTIVE		(3)

#define		MT_DKLORD		(1)				/* Monster types */
#define		MT_SPELLMAKER	(2)
#define		MT_SORCEROR		(3)
#define		MT_DEATHMASTER	(4)
#define		MT_SOULSTEALER	(5)
#define		MT_GUARD		(6)

#define		MB_DRAWONLY		(0x0000)		/* Message box constants */
#define		MB_DELAY		(0x0001)

#define	HF_JUMP			(0)					/* Object constants */
#define	HF_REMOVE		(1)
#define	HF_FOUNDARROW   (2)
#define	HF_CHAOS		(3)					
#define	HF_ELIXIR		(4)
#define	HF_WATER		(5)
#define	HF_FIRE			(6)
#define	HF_FOUNDGOLD	(7)
#define	HF_PETRIFY		(8)
#define	HF_VAMPIRE		(9)
#define	HF_MIRROR		(10)
#define HF_WATERSTONE	(11)				/* Codes for big treasures */
#define HF_AIRSTONE		(12)
#define HF_FIRESTONE	(13)
#define HF_EARTHSTONE	(14)
#define HF_AMULET    	(15)

#define PR_USECLASSICMODE	(0)  			/* if non zero, make it classic */
#define PR_SPELLTIME		(1)				/* spell speed, in ms per square */
#define PR_ARROWTIME		(2)				/* arrow speed, in ms per square */
#define PR_RANGE			(3)				/* max player range */
#define PR_GOLDDROPAMOUNT	(4)				/* amount dropped when D command */
#define PR_STRENGTHREGAIN	(5)				/* strength regained on weight */
#define PR_STRENGTHLOSSSCALER (6)			/* divisor for gold, strength loss */
#define PR_MOVESPEED		(7)				/* move speed, ms/square */
#define PR_JUMPSPEED		(8)				/* jump speed, ms/square */
#define PR_NOALTROOM		(9)				/* no different room types if 1 */
#define PR_MSGDELAY			(10)			/* message delay time ms */
#define PR_DEFMONSTERSPEED	(11)			/* monster speed */
#define PR_DARKLORDSTR		(12)			/* strengths of the monsters */
#define PR_SPELLMAKERSTR	(13)
#define PR_SORCERORSTR		(14)
#define PR_DEATHMASTERSTR	(15)
#define PR_SOULSTEALERSTR	(16)
#define PR_TOMBGUARDSTR		(17)
#define PR_BASHSTRENGTHLOSS	(18)			/* strength loss when hit */
#define PR_MINCHECKTIME		(19)			/* min/max times check for */
#define PR_MAXCHECKTIME		(20)			/* monster activate */
#define PR_MULTIMONST		(21)			/* multiple monsters allowed ? */
#define PR_ACTDISTANCE		(22)			/* how close to get to start them */
#define PR_AMULETVIEWTIME	(23)			/* ms disp for each monst w/amulet */
#define PR_VAMPIRERATE		(24)			/* Vampire rate :) */
#define PR_VAMPIRESPEED		(25)			/* Speed (ms/square) */
#define PR_VAMPIREHIT		(26)