/************************************************************************/
/************************************************************************/
/*																		*/
/*	Name :		DREWAN.H												*/
/*	Project :	Tomb of Drewan in 'C'									*/
/*	Author :	Paul Robson												*/
/*	Created :	23rd April 2001											*/
/*	Function :	Include file											*/
/*	Changes :															*/
/*																		*/
/************************************************************************/
/************************************************************************/

#define	MAPSIZE		(20)					/* Map Size */
#define MAXMAPSIZE	(20)					/* Maximum Map Size */

#define	MCOUNT		(4)						/* No. of monsters */
#define TCOUNT		(4)						/* Number of treasures */

typedef struct _Point						/* 2D Point structure */
{
	int x,y;
} POINT;

typedef unsigned char SHORT;

typedef struct _RData						/* Room info structure */
{
	SHORT LayoutType;						/* Open Brick Layout type 1-8 */
	SHORT TreasureLayoutType;				/* Treasure Layout type 1-5 */
	SHORT TreasureTaken[TCOUNT];			/* Treasure taken flags */
	SHORT MonsterLayoutType;				/* Monster Layout type 1-7 */
	SHORT MonsterDead[MCOUNT];				/* Monster dead flags */
	SHORT TreasureType;						/* Treasure type 1-15 */
	SHORT MonsterType;						/* Monster type 1-15 */
} RDATA;

#define	HF_FLAGS		(16)				/* Number of "has obj" flags */
											/* Also used for treasure IDs */

typedef struct _Player						/* Player structure */
{
	int	 Quit;								/* Set to 1 to exit */
	int  RoomID;							/* Current Room Number */
	POINT Pos;								/* Where we are in the room */
	int	 Kills;								/* Number of kills */
	int	 Strength;							/* Strength, 0-100 */
	int	 Wounds;							/* Wounds,0-100% */
	int  Gold;								/* Gold, 0-999 */
	int	 Arrows;							/* Arrows, 0+ */
	int	 Char;								/* Drawing Character */
	int	 Colour;							/* Colour */
	int  LookDir;							/* Looking Direction */
	long StartTimer;						/* Timer value when we started */
	int	 Has[HF_FLAGS];						/* Player flags */
	int	 MajorTreasure[5];					/* Rooms for major treasures */
	RDATA Room[MAXMAPSIZE*MAXMAPSIZE];		/* Room Information */
} PLAYER;

typedef struct _Treasure
{
	int	  Enabled;							/* Treasure on screen ? */
	int	  TreasureID;						/* Identifier */
	POINT Pos;								/* Where the treasure is */
	char  Name[16];							/* Treasure Name */
	int	  Gold;								/* Gold value */
} TREASURE;

typedef struct _Monster
{
	int	  State;							/* Monster state */
	int	  Type;								/* Monster type */
	int	  Graphic;							/* Character Graphic */
	int	  Colour;							/* Colour to draw */
	int	  Strength;							/* Strength */
	int	  Speed;							/* Speed (ms per move) */
	long  NextMove;							/* Time for next move */
	char  Name[16];							/* Monster Name */
	POINT Pos;								/* Where the monster is */
} MONSTER;

typedef struct _Room						/* Room descriptor structure */
{
	RDATA *Desc;							/* Pointer to current descriptor */
	TREASURE Treasure[TCOUNT];				/* Treasures herein */
	MONSTER  Monster[MCOUNT];				/* Monsters herein */
} ROOM;

