/************************************************************************/
/************************************************************************/
/*																		*/
/*	Name :		PARAM.C													*/
/*	Project :	Tomb of Drewan in 'C'									*/
/*	Author :	Paul Robson												*/
/*	Created :	26th April 2001											*/
/*	Function :	Very simple parameter file system						*/
/*	Changes :															*/
/*																		*/
/************************************************************************/
/************************************************************************/

#include "drewan.h"

#define NO_VALUE	(-9999)					/* Not defined value */
#define MAXPARAMS	(64)					/* What we allow */
#define PARAMFILE	"DREWAN.INI"			/* Where they go */

static int Table[MAXPARAMS];				/* The parameters */

/************************************************************************/
/*																		*/
/*					Initialise the params, read the file				*/
/*																		*/
/************************************************************************/

void PARAMInit(void)
{
	int i,p,v;
	FILE *f;
	for (i = 0;i < MAXPARAMS;i++)			/* Erase table */
						Table[i] = NO_VALUE;
	f = fopen(PARAMFILE,"r");				/* Open file */
	if (f == NULL) return;					/* If none, that's it */
	while (fscanf(f,"%d,%d",&p,&v) == 2)	/* Keep reading pairs */
							  Table[p] = v;	/* and copying them */
	fclose(f);								/* finished */
}

/************************************************************************/
/*																		*/
/*						   Get a parameter value						*/
/*																		*/
/************************************************************************/

int	PARAMGet(int ID,int Default)
{
	if (Table[ID] == NO_VALUE)				/* if not defd before */
					Table[ID] = Default;	/* set the default now */
	return Table[ID];						/* return the value */
}

/************************************************************************/
/*																		*/
/*					Write the parameter file out						*/
/*																		*/
/************************************************************************/

void PARAMWrite(void)
{
	FILE *f;
	int i;
	f = fopen(PARAMFILE,"w");				/* Open it */
	for (i = 0;i <  MAXPARAMS;i++)			/* Write all defined values */
		if (Table[i] != NO_VALUE)
				fprintf(f,"%d,%d\n",i,Table[i]);
	fclose(f);
}