'R O B O T   R O B B E R Y   v0.7
'
'By: KeiProductions
'robotrob@keithkosh.com
'http://robotrobbery.keithkosh.com
'
'Please read ROBOTROB.TXT for game information, last minute release news,
'and related bits of text. Enjoy.
'
'

DEFINT A-Z

DECLARE SUB fadein ()
DECLARE SUB Intro ()
DECLARE SUB fadeOut ()
DECLARE SUB changecolor (pal, r, g, b)
DECLARE SUB getColValues ()
DECLARE SUB getcolor (pal, r, g, b)
DECLARE SUB setColsBlack ()
DECLARE SUB drawtile (scrx, scry, x, y)
DECLARE SUB drawtile2 (scrx, scry, x, y)
DECLARE SUB GetPixCords (x, y)
DECLARE SUB LoadLevel ()
DECLARE SUB MoveEnemies ()
DECLARE SUB ShowEnemies ()
DECLARE SUB putcharacter ()
DECLARE SUB putenemy (n, x, y, t)
DECLARE SUB EndProgram ()
DECLARE SUB scrollback (What$)
DECLARE SUB MainMenu ()
DECLARE SUB GameOver ()
DECLARE SUB Init ()
DECLARE SUB GameLoop ()
DECLARE SUB setCPalette ()
DECLARE SUB ScreenWipe ()
DECLARE SUB secondpause (second!)
DECLARE SUB CharMoveHoriz ()
DECLARE SUB CheckForKeyPress ()
DECLARE SUB updatescore ()
DECLARE SUB CharMoveVert ()
DECLARE SUB GetCharStats ()
DECLARE SUB DrawLevel ()
DECLARE SUB CFScreenScroll ()
DECLARE SUB GetItem (x, y)
DECLARE SUB GetTileSet (filename$)
DECLARE SUB DirectorySetup ()

DECLARE SUB GetFonts ()
DECLARE SUB kfont (text$, txpos, typos, clr)
DECLARE SUB kCenter (text$, typos, clr)
DECLARE SUB TypeIt (text$, txpos, typos, clr, prvcolor)

TYPE paldata
 red AS SINGLE
 green AS SINGLE
 blue AS SINGLE
END TYPE

TYPE enemy
 pixelx AS INTEGER
 pixely AS INTEGER
 direction AS INTEGER
 walkstate AS INTEGER
 onscreen AS INTEGER
 alive AS INTEGER
 squished AS INTEGER
END TYPE

RANDOMIZE TIMER

DIM SHARED font$(0 TO 83) 'Holds font data (hence the name)

DIM SHARED dir$, rightdirectory
DIM SHARED menuchoice$(6)
DIM SHARED losealife

DIM SHARED level

CONST leftk = 1, rightk = 2, Upk = 3, leftupk = 4, rightupk = 5, esck = 6

DIM SHARED enemy(1 TO 11) AS enemy
DIM SHARED enemy2(1 TO 11) AS enemy

DIM SHARED enemiesinlevel, enemiesinlevel2
DIM SHARED ecoverup&(11 * 65), dontdrawchar, putchar
DIM SHARED ecoverup2&(11 * 65)
DIM SHARED changevalue(1 TO 254) AS paldata
DIM SHARED fadestep, stepx, stepy, originalface
DIM SHARED startx, starty, startscrx, startscry, doesitscrollup, facing
DIM SHARED xpos, ypos, walking, objectx, objecty, wtputx, wtputy, lives
DIM SHARED falling, jumping, bounce, soundison, levelheight, CDs
DIM SHARED levelpixelx, levelpixely, originalx, originaly, gamedelay
DIM SHARED xtilepos!, ytilepos!, charredraw, oldcx, oldcy, scorechanged, score

DIM SHARED scr$(1 TO 50)
DIM SHARED layer2$(1 TO 50)

DIM SHARED cdsmall&(14), cdsmallm&(14)
DIM SHARED charsmall&(16), charsmallm&(16)
DIM SHARED cd&(66), cdm&(66), backg&(66), exitsign&(66), backgs&(40)
DIM SHARED scorback&(660)

DIM SHARED mArrow&(2 * 39), mArrowm&(2 * 39)
DIM SHARED mArrowback&(39)

DIM SHARED bg&(40 * 66), fgwalkon&(10 * 66), fgcgthru&(20 * 66)
DIM SHARED losealife&(5 * 66), objnm&(10 * 66), objwm&(10 * 66)

DIM SHARED enemyp1&(2 * 68), enemyp2&(2 * 68)
DIM SHARED enemyp1m&(2 * 68), enemyp2m&(2 * 68)
DIM SHARED enemyflat&(2 * 68), enemyflatm&(2 * 68)
DIM SHARED spikeb&(2 * 68), spikebm&(2 * 68)

DIM SHARED difr!(12), difg!(12), difb!(12)
DIM SHARED origr(12), origg(12), origb(12)

DIM SHARED charstanding&(2 * 190), charstandmask&(2 * 190), coverup&(190)
DIM SHARED charwalking&(2 * 190), charwalkmask&(2 * 190)
DIM SHARED charjump&(2 * 190), charjumpmask&(2 * 190)

DIM SHARED walkon$, cantgothru$, losealife$, bonusitems$, offsetx, offsety
DIM SHARED keypress, jp, jcount, dir, passlevel

CONST right = 1, left = 2
CONST charheight = 32
walkon$ = "0123456789"  '-----------> These are the tiles you can walk on (go
                                     'on top of)
cantgothru$ = "ABCDEFGHIJKLMNOPQRST" 'These are the tiles you can walk on
                                     'AND can't go thru
bonusitems$ = "C"    '--------------> Items such as lives, CDs, etc...
losealife$ = "UVWXY"   '------------> These are the tiles that if you walk
                                     'on, you lose a life

fadestep = 20
soundison = 1
gamedelay = 0   'The game *should* be the same speed on all computers but
                'if it's not, you can add to this...

offsetx = 15 'How far the top of the screen is from where the tiles show
offsety = 5 'How far the left of the screen is from where the tiles show

DirectorySetup

SCREEN 13

GetFonts
Init
setCPalette

FOR a = 130 TO 142
 getcolor a, r, g, b
 origr(a - 130) = r
 origg(a - 130) = g
 origb(a - 130) = b
NEXT a

CLS

getColValues

Intro

DO

 MainMenu
 GameLoop

LOOP

filenotfound:

rightdirectory = 0
RESUME NEXT

SUB CFScreenScroll

IF wtputx >= 212 THEN
 IF xpos < LEN(scr$(1)) - 18 THEN
  xpos = xpos + 1
  scr = 1
 END IF
END IF

IF wtputx <= 90 THEN
 IF xpos > 0 THEN
  xpos = xpos - 1
  scr = 1
 END IF
END IF

IF wtputy <= 37 AND doesitscrollup = 1 THEN
 IF levelheight - 11 > ypos THEN
  ypos = ypos + 1
  scr = 1
 END IF
END IF

IF wtputy >= 117 AND doesitscrollup = 1 THEN
 IF ypos > 0 THEN
 ypos = ypos - 1
 scr = 1
 END IF
END IF

IF scr = 1 THEN
 DrawLevel
 GetCharStats
 GET (wtputx, wtputy)-(wtputx + 15, wtputy + 31), coverup&
 charredraw = 0
END IF

END SUB

SUB changecolor (pal, r, g, b)

OUT &H3C8, pal
OUT &H3C9, r
OUT &H3C9, g
OUT &H3C9, b

END SUB

SUB CharMoveHoriz

IF keypress = rightk OR keypress = rightupk THEN dest = 1: MoveOK = 1
IF keypress = leftk OR keypress = leftupk THEN dest = 0: MoveOK = 1

GetCharStats
yt = INT(ytilepos!)
xt = INT(xtilepos!)

ntcheck = 0
IF levelpixelx MOD 16 = 12 AND dest = 0 THEN ntcheck = 1
IF levelpixelx MOD 16 = 4 AND dest = 1 THEN ntcheck = 1

IF levelpixely = 48 THEN
 bounce = 0: jumping = 0: falling = 1
END IF

IF levelpixely MOD 16 = 0 THEN
 IF levelpixely / 16 = levelheight + 1 THEN
  losealife = 1
  EXIT SUB
 END IF
END IF

IF levelpixelx <= 0 AND dest = 0 THEN
 IF walking > 0 THEN oldcx = wtputx: oldcy = wtputy: charredraw = 1
 walking = 0: ntcheck = 0: MoveOK = 0
END IF

IF dest = 1 AND levelpixelx MOD 16 = 0 AND levelpixelx / 16 = LEN(scr$(1)) - 1 THEN
 IF walking > 0 THEN oldcx = wtputx: oldcy = wtputy: charredraw = 1
 walking = 0: ntcheck = 0: MoveOK = 0
END IF

IF ntcheck = 1 THEN
IF INSTR(cantgothru$, (MID$(scr$(yt - 1), xt + dest, 1))) THEN
 MoveOK = 0
 IF walking > 0 THEN oldcx = wtputx: oldcy = wtputy: charredraw = 1
 walking = 0
ELSEIF INSTR(cantgothru$, (MID$(scr$(yt - 2), xt + dest, 1))) THEN
 MoveOK = 0
 IF walking > 0 THEN oldcx = wtputx: oldcy = wtputy: charredraw = 1
 walking = 0
END IF

IF levelpixely MOD 16 > 0 THEN
  IF INSTR(cantgothru$, (MID$(scr$(yt), xt + dest, 1))) THEN MoveOK = 0
END IF
END IF

IF MoveOK = 1 THEN
 oldcx = wtputx: oldcy = wtputy
 IF dest = 0 THEN dest = -1
 levelpixelx = levelpixelx + dest
 charredraw = 1
ELSE
 oldcx = wtputx: oldcy = wtputy
END IF

FOR a = 1 TO enemiesinlevel2
 IF enemy2(a).onscreen = 1 THEN
  IF levelpixelx >= enemy2(a).pixelx - 11 AND levelpixelx <= enemy2(a).pixelx + 11 THEN
   IF (levelpixely + 16) >= enemy2(a).pixely THEN
    IF (levelpixely - charheight) <= enemy2(a).pixely THEN
     wx = enemy2(a).pixelx - (xpos * 16) + offsetx
     wy = enemy2(a).pixely - ((levelheight - 10 - ypos) * 16) - 16 + offsety
     PUT (wx, wy), ecoverup2&(a * 65), PSET
     putenemy a, wx, wy, 2
     losealife = 1
     EXIT SUB
    END IF
   END IF
  END IF
 END IF
NEXT a

FOR a = 1 TO enemiesinlevel
 IF enemy(a).onscreen = 1 AND enemy(a).alive = 1 THEN
  IF (levelpixely + 16) >= enemy(a).pixely AND levelpixely <= enemy(a).pixely THEN
   IF enemy(a).pixelx >= (levelpixelx - 13) AND enemy(a).pixelx <= (levelpixelx + 13) THEN
    'see if you jumped on him or not
    IF (levelpixely + 16) = enemy(a).pixely THEN
     IF falling = 1 OR (jumping = 1 AND dir = 0) THEN
      enemy(a).alive = 0: enemy(a).squished = 1
      wx = enemy(a).pixelx - (xpos * 16) + offsetx
      wy = enemy(a).pixely - ((levelheight - 10 - ypos) * 16) - 16 + offsety
      PUT (wx, wy), ecoverup&(a * 65), PSET
      jumping = 0: falling = 0
      bounce = 1: jcount = 0: jp = levelpixely: goneenemy = a
      IF soundison = 1 THEN SOUND 200, .8: SOUND 150, .8: SOUND 100, .8
      score = score + 50: scorechanged = 1
      END IF
    ELSE
     wx = enemy(a).pixelx - (xpos * 16) + offsetx
     wy = enemy(a).pixely - ((levelheight - 10 - ypos) * 16) - 16 + offsety
     PUT (wx, wy), ecoverup&(a * 65), PSET
     putenemy a, wx, wy, 1
     losealife = 1
     EXIT SUB
    END IF
   END IF
  END IF
 END IF
NEXT a

END SUB

SUB CharMoveVert

GetCharStats
yt = INT(ytilepos!)
xt = INT(xtilepos!)

IF xtilepos! > xt THEN
 check1tile = 0
 IF levelpixelx MOD 16 >= 12 AND levelpixelx MOD 16 <= 15 THEN
  check1tile = 1: xt = xt + 1
 END IF
IF levelpixelx MOD 16 <= 4 AND levelpixelx MOD 16 >= 1 THEN check1tile = 1
ELSE
 check1tile = 1
END IF

'Check for collision detection with items (such as coins)
IF ytilepos! <> yt THEN check3ytiles = 1
IF check1tile = 0 THEN check2xtiles = 1

FOR a = 0 TO check2xtiles
 cr$ = MID$(layer2$(yt - 1), xt + a, 1)
 IF cr$ = "" THEN cr$ = " "
 IF INSTR(bonusitems$, cr$) THEN GetItem xt + a, yt - 1
 cr$ = MID$(layer2$(yt - 2), xt + a, 1)
 IF cr$ = "" THEN cr$ = " "
 IF INSTR(bonusitems$, cr$) THEN GetItem xt + a, yt - 2
 cr$ = MID$(layer2$(yt), xt + a, 1)
 IF cr$ = "" THEN cr$ = " "
 IF check3ytiles = 1 THEN IF INSTR(bonusitems$, cr$) THEN GetItem xt + a, yt
NEXT a

'Check if the level has been passed (jump pressed when by a door)

IF check2xtiles = 0 AND levelpixely MOD 16 = 0 THEN
 IF MID$(scr$(yt - 1), xt, 1) = "#" AND MID$(scr$(yt - 2), xt, 1) = "#" THEN
  IF keypress = Upk OR keypress = leftupk OR keypress = rightupk THEN
   jumping = 0: passlevel = 1
   levelpixelx = (xt - 1) * 16: charredraw = 1
  END IF
 END IF
END IF

'Other collision detection when falling/jumping/bouncing/etc

MoveOK = 1

IF levelpixely MOD 16 = 0 THEN

IF (jumping = 1 AND dir = 1) OR bounce = 1 THEN
 IF check1tile = 0 AND INSTR(cantgothru$, (MID$(scr$(yt - 3), xt + 1, 1))) THEN
  IF jumping = 1 THEN
   dir = 0: jp = levelpixely - 1
   MoveOK = 0
  ELSE
   bounce = 0: jumping = 1: dir = 0: jp = levelpixely - 1
   MoveOK = 0
  END IF
 END IF
 IF INSTR(cantgothru$, (MID$(scr$(yt - 3), xt, 1))) THEN
  IF jumping = 1 THEN
   dir = 0: jp = levelpixely - 1
   MoveOK = 0
  ELSE
   bounce = 0: jumping = 1: dir = 0: jp = levelpixely - 1
   MoveOK = 0
  END IF
 END IF
ELSEIF falling = 1 OR (jumping = 1 AND dir = 0) THEN
 IF check1tile = 0 AND (INSTR(walkon$, (MID$(scr$(yt), xt + 1, 1))) OR INSTR(cantgothru$, (MID$(scr$(yt), xt + 1, 1)))) THEN
  IF jumping = 1 THEN jumping = 0
  falling = 0: charredraw = 1: MoveOK = 0
 END IF
 IF INSTR(walkon$, (MID$(scr$(yt), xt, 1))) OR INSTR(cantgothru$, (MID$(scr$(yt), xt, 1))) THEN
  IF jumping = 1 THEN jumping = 0
  falling = 0: charredraw = 1: MoveOK = 0
 END IF
ELSEIF falling = 0 AND jumping = 0 AND bounce = 0 THEN
 IF check1tile = 0 THEN
 IF INSTR(walkon$, (MID$(scr$(yt), xt + 1, 1))) = 0 AND INSTR(cantgothru$, (MID$(scr$(yt), xt + 1, 1))) = 0 THEN
  falling = 1: charredraw = 1: MoveOK = 0
 END IF
 END IF
 IF INSTR(walkon$, (MID$(scr$(yt), xt, 1))) = 0 AND INSTR(cantgothru$, (MID$(scr$(yt), xt, 1))) = 0 THEN
  falling = 1: charredraw = 1: MoveOK = 0
 END IF
END IF

 IF check1tile = 0 THEN
 IF INSTR(losealife$, (MID$(scr$(yt), xt + 1, 1))) = 1 THEN
  losealife = 1
 END IF
 END IF
 IF INSTR(losealife$, (MID$(scr$(yt), xt, 1))) = 1 THEN
  losealife = 1
 END IF

END IF

IF MoveOK = 1 THEN
oldcy = wtputy

IF falling = 1 THEN
 walking = 0
 levelpixely = levelpixely + 1: charredraw = 1
END IF

IF bounce = 1 THEN
 jcount = jcount + 1: levelpixely = levelpixely - 1: charredraw = 1
END IF

IF jumping = 1 THEN
 jcount = jcount + 1: charredraw = 1
 SELECT CASE dir
 CASE 1: levelpixely = levelpixely - 1
 CASE 0: levelpixely = levelpixely + 1
 END SELECT
END IF

IF bounce = 1 THEN
 IF levelpixely <= jp - 15 THEN
  IF jcount MOD 2 > 0 THEN levelpixely = levelpixely + 1: EXIT SUB
 END IF
 IF levelpixely <= jp - 21 THEN
  IF jcount MOD 3 > 0 THEN levelpixely = levelpixely + 1: EXIT SUB
 END IF
 IF levelpixely = jp - 23 THEN
  bounce = 0: jumping = 1
  dir = 0: levelpixely = levelpixely + 1: jp = levelpixely - 1: EXIT SUB
 END IF
END IF

IF jumping = 1 THEN
 SELECT CASE dir
 CASE 1
  IF levelpixely <= jp - 15 THEN
   IF jcount MOD 2 > 0 THEN levelpixely = levelpixely + 1: EXIT SUB
  END IF
  IF levelpixely <= jp - 21 THEN
   IF jcount MOD 3 > 0 THEN levelpixely = levelpixely + 1: EXIT SUB
  END IF
  IF levelpixely = jp - 23 THEN
   dir = 0: levelpixely = levelpixely + 1: jp = levelpixely - 1: EXIT SUB
  END IF
 CASE 0
  IF levelpixely <= jp + 1 THEN
   IF jcount MOD 3 > 0 THEN levelpixely = levelpixely - 1: EXIT SUB
  END IF
  IF levelpixely <= jp + 6 THEN
   IF jcount MOD 2 > 0 THEN levelpixely = levelpixely - 1: EXIT SUB
  END IF
 END SELECT
END IF

END IF

END SUB

SUB CheckForKeyPress

STATIC oktojump

z$ = INKEY$
keypress = 0

SELECT CASE z$
CASE CHR$(27)
 keypress = esck
 EXIT SUB
END SELECT

SELECT CASE PEEK(1048)
CASE 2 'right
 IF facing = left THEN walking = 1
 facing = right
 IF falling = 0 AND jumping = 0 AND bounce = 0 THEN
  walking = walking + 1
  IF walking = 21 THEN walking = 1
  wflag = 1
 END IF
 keypress = rightk
 'STOP
CASE 1 'left
 IF facing = right THEN walking = 1
 facing = left
 IF falling = 0 AND jumping = 0 AND bounce = 0 THEN
  walking = walking + 1
  IF walking = 21 THEN walking = 1
  wflag = 1
 END IF
 keypress = leftk
END SELECT

IF wflag = 0 AND walking > 0 THEN
 walking = 0: charredraw = 1: oldcx = wtputx: oldcy = wtputy
END IF

pkey = PEEK(1047)
SELECT CASE pkey MOD 16
CASE 1, 5, 9, 13
 IF falling = 0 AND jumping = 0 AND bounce = 0 AND oktojump = 1 THEN
  jumping = 1
  dir = 1: jcount = 0
  jp = levelpixely
  oktojump = 0
  IF pkey MOD 16 = 1 THEN keypress = Upk
  IF pkey MOD 16 = 5 THEN keypress = leftupk
  IF pkey MOD 16 = 9 THEN keypress = rightupk
 END IF
CASE ELSE
 oktojump = 1
 IF jumping = 1 AND dir = 1 THEN
  dir = 0: jp = levelpixely - 1: jcount = 0
 END IF
END SELECT

END SUB

SUB DirectorySetup

rightdirectory = 1

ON ERROR GOTO filenotfound

OPEN "robotdir.dat" FOR INPUT AS #1
 IF rightdirectory = 0 THEN CLOSE #1: GOTO newdirectory
 INPUT #1, dir$
CLOSE #1

OPEN dir$ + "robotrob.pic" FOR INPUT AS #1
CLOSE #1

IF rightdirectory = 0 THEN GOTO newdirectory

EXIT SUB

newdirectory:

CLS
COLOR 15, 1: PRINT STRING$(80, 255): LOCATE 1, 1
COLOR 14, 1: PRINT "Directory setup"
COLOR 15, 1: tx$ = "Robot Robbery v0.7": LOCATE 1, (81 - LEN(tx$)): PRINT tx$;

VIEW PRINT 2 TO 25

LOCATE 3, 1: COLOR 15, 0
PRINT "Robot Robbery needs to know the directory that it is in so that it can access"
PRINT "access its data files."
PRINT

IF dir$ <> "" THEN
 PRINT "The current directory, " + dir$ + ", is invalid."
ELSE
 PRINT "The current directory has not been defined yet."
END IF

getnewdir:

rightdirectory = 1

PRINT
PRINT "Please enter the full directory path: (i.e. C:\QBASIC\ROBOTROB\)"
PRINT

COLOR 14: INPUT "", dir$
PRINT

dir$ = UCASE$(dir$)

IF RIGHT$(dir$, 1) <> "\" THEN
 dir$ = dir$ + "\"
END IF

OPEN dir$ + "robotrob.pic" FOR INPUT AS #1   'test the new directory
CLOSE #1

COLOR 15

IF rightdirectory = 0 THEN
 PRINT "This directory is invalid - data files were not found."
 GOTO getnewdir
END IF

OPEN "robotdir.dat" FOR OUTPUT AS #1
WRITE #1, dir$
CLOSE #1

PRINT "Data files have been found. Robot Robbery will now continue loading."
PRINT
COLOR 9: PRINT "Press [Enter] to continue."

WHILE INKEY$ <> CHR$(13): WEND

CLS

END SUB

SUB DrawLevel

FOR a = 1 TO 11
FOR b = 1 TO 18
 x = (b * 16) - 16 + offsetx
 y = (a * 16) - 16 + offsety
 startx = b + xpos
 starty = (levelheight - 11 + a) - ypos
 drawtile startx, starty, x, y
 drawtile2 startx, starty, x, y
NEXT b
NEXT a


END SUB

SUB drawtile (levx, levy, x, y)
SELECT CASE MID$(scr$(levy), levx, 1)
 CASE "", " ": LINE (x, y)-(x + 15, y + 15), 0, BF
 CASE "#": LINE (x, y)-(x + 15, y + 15), 223, BF
 CASE "@": PUT (x, y), exitsign&, PSET
 CASE ".": LINE (x, y)-(x + 15, y + 15), 78, BF
 CASE ELSE
  char = ASC(MID$(scr$(levy), levx, 1))
  'STOP
  IF char >= 48 AND char <= 57 THEN
   char = char - 48
   'STOP
   PUT (x, y), fgwalkon&(char * 66), PSET
  ELSEIF char >= 65 AND char <= 84 THEN
   char = char - 65
   PUT (x, y), fgcgthru&(char * 66), PSET
  ELSEIF char >= 85 AND char <= 89 THEN
   char = char - 85
   PUT (x, y), losealife&(char * 66), PSET
  ELSEIF char >= 90 AND char <= 129 THEN
   char = char - 90
   PUT (x, y), bg&(char * 66), PSET
  END IF
 END SELECT
END SUB

SUB drawtile2 (levx, levy, x, y)
SELECT CASE LCASE$(MID$(layer2$(levy), levx, 1))
CASE "c": PUT (x, y), cdm&, AND: PUT (x, y), cd&, OR
CASE " ", "": EXIT SUB
CASE ELSE
  char = ASC(MID$(layer2$(levy), levx, 1))
  IF char >= 48 AND char <= 57 THEN
   char = char - 48
   PUT (x, y), objwm&(char * 66), AND
   PUT (x, y), objnm&(char * 66), OR
  END IF
END SELECT
END SUB

SUB EndProgram

fadeOut
SYSTEM

END SUB

SUB fadein
     
FOR a = 1 TO (fadestep + 1)
 FOR c = 1 TO 254
  cred! = changevalue(c).red * (a - 1)
  cgreen! = changevalue(c).green * (a - 1)
  cblue! = changevalue(c).blue * (a - 1)
  changecolor c, CINT(cred!), CINT(cgreen!), CINT(cblue!)
 NEXT c
NEXT a


END SUB

SUB fadeOut

getColValues

FOR a = 1 TO fadestep
 FOR c = 1 TO 254
  cred! = (changevalue(c).red * (fadestep - a))
  cgreen! = (changevalue(c).green * (fadestep - a))
  cblue! = (changevalue(c).blue * (fadestep - a))
  changecolor c, CINT(cred!), CINT(cgreen!), CINT(cblue!)
 NEXT c
NEXT a

CLS : PALETTE
setCPalette

END SUB

SUB GameLoop
CLS

enemiesinlevel2 = 0
enemiesinlevel = 0
walking = 0: jumping = 0: falling = 0: bounce = 0
lives = 5: CDs = 0: score = 0
losealife = 0

getColValues
setColsBlack

level$ = LTRIM$(RTRIM$(STR$(level)))
world$ = "1"

LoadLevel

originalx = startx - 1
originaly = starty
originalface = facing

levelpixelx = startx - 1: levelpixely = starty
levelpixelx = (levelpixelx * 16)
levelpixely = (levelpixely * 16)
xpos = startscrx: ypos = startscry
specialmode = 0
charredraw = 0

CLS

FOR x = 0 TO 19
 FOR y = 0 TO 12
  IF y < 12 THEN
   PUT (x * 16, y * 16), backg&, PSET
  ELSE
   PUT (x * 16, y * 16), backgs&, PSET
  END IF
 NEXT y
NEXT x

LINE (15, 5)-(302, 180), 0, BF

LINE (14, 4)-(303, 4), 1
LINE (303, 4)-(303, 181), 150
LINE (303, 181)-(14, 181), 150
LINE (14, 180)-(14, 4), 1

kCenter "R O B O T   R O B B E R Y   v 0 . 7", 184, 0
kCenter "R O B O T   R O B B E R Y   v 0 . 7", 183, 12

PUT (2, 191), charsmallm&, AND
PUT (2, 191), charsmall&, OR

PUT (273, 192), cdsmallm&, AND
PUT (273, 192), cdsmall&, OR

kfont "x", 16, 192, 12
kfont "x", 288, 192, 12

GET (0, 192)-(319, 199), scorback&

GetCharStats
updatescore

fadein

kCenter "LEVEL " + level$ + "-" + world$, 86, 15

IF soundison = 1 THEN PLAY "mb l8 o2l16 c p4 c p16 c p6 o1 g p6 c"

start! = TIMER
DO: LOOP WHILE TIMER < start! + 3

FOR a = 1 TO 11  '11
FOR b = 1 TO 9 '18
 a2 = 12 - a
 b2 = 19 - b
 x = (b * 16) - 16 + offsetx
 x2 = (b2 * 16) - 16 + offsetx
 y = (a * 16) - 16 + offsety
 y2 = (a2 * 16) + offsety - 16
 startx = b + xpos
 starty = (levelheight - 11 + a) - ypos
 drawtile startx, starty, x, y
 drawtile2 startx, starty, x, y
 startx = b2 + xpos
 starty = (levelheight - 11 + a2) - ypos
 drawtile startx, starty, x2, y2
 drawtile2 startx, starty, x2, y2
 FOR l = 1 TO 10: WAIT &H3DA, 8: NEXT l
NEXT b
NEXT a

GET (wtputx, wtputy)-(wtputx + 15, wtputy + 31), coverup&

putcharacter
ShowEnemies

DO
 FOR delay = 1 TO gamedelay: NEXT delay
 WAIT &H3DA, 8
 putcharacter
 IF passlevel = 1 THEN GOTO passlevel
 MoveEnemies
 CheckForKeyPress
 IF keypress = esck THEN GOTO startover
 CharMoveHoriz
 IF losealife = 1 THEN scorechanged = 1: GOSUB losealife
 IF scorechanged = 1 THEN updatescore
 scorechanged = 0
 CharMoveVert
 CFScreenScroll
LOOP

startover:
ScreenWipe
EXIT SUB

losealife:

putcharacter

IF soundison = 1 THEN SOUND 300, 1: SOUND 250, 1: SOUND 200, 1

FOR a = 1 TO 3
 FOR d = 1 TO 2
  FOR c = 130 TO 142
   IF d = 1 THEN
    r = 63: g = 63: b = 63
   ELSE
    r = origr(c - 130)
    b = origb(c - 130)
    g = origg(c - 130)
   END IF
   changecolor c, r, g, b
  NEXT c
  secondpause .25
 NEXT d
secondpause .25
NEXT a

losealife = 0
IF lives = 0 THEN GameOver: EXIT SUB

scrollback "init"
DO
 scrollback "scroll": DrawLevel
LOOP UNTIL ypos = startscry AND xpos = startscrx

levelpixelx = originalx * 16: levelpixely = originaly * 16
facing = originalface: walking = 0: jumping = 0: falling = 0: bounce = 0

lives = lives - 1

GetCharStats

GET (wtputx, wtputy)-(wtputx + 15, wtputy + 31), coverup&

RETURN

passlevel:

passlevel = 0

getcolor 223, r, g, b
doorr = r
doorg = g
doorb = b

FOR a = 130 TO 142
 getcolor a, r, g, b
 difr!(a - 130) = (doorr - r) / 50
 difg!(a - 130) = (doorg - g) / 50
 difb!(a - 130) = (doorb - b) / 50
NEXT a

FOR z = 1 TO 50
 FOR a = 130 TO 142
  getcolor a, r, g, b
  newr = CINT(origr(a - 130) + ((z) * (difr!(a - 130))))
  newg = CINT(origg(a - 130) + ((z) * (difg!(a - 130))))
  newb = CINT(origb(a - 130) + ((z) * (difb!(a - 130))))
  changecolor a, newr, newg, newb
 NEXT a
 WAIT &H3DA, 8, 8: WAIT &H3DA, 8
NEXT z

LINE (wtputx, wtputy)-(wtputx + 15, wtputy + 31), 223, BF

secondpause .5

IF soundison = 1 THEN PLAY "mb l16 o2 c p6 c p6 c p16 o1 g o2 p16 e p16 g p16 o3 c"

fadeOut

kCenter "Level completed.", 30, 12

kCenter "There are no more levels to play", 50, 29
kCenter "in this demo version. The latest", 60, 29
kCenter "version is always availible at", 70, 29
kCenter "Robot Robbery Online,", 80, 29
kCenter "robotrobbery.keithkosh.com|029.", 90, 9

kCenter "Thank you for trying Robot Robbery .7", 110, 29
kCenter "and don't forget to e-mail me at", 120, 29
kCenter "robotrob@keithkosh.com|029 with any", 130, 9
kCenter "comments or suggestions.", 140, 29

kCenter "Press a key to return to the main menu.", 160, 14

DO: LOOP WHILE INKEY$ = ""

fadeOut

END SUB

SUB GameOver

IF soundison = 1 THEN PLAY "mb o1 c c c p4 e- g o2 c p4 o1 c"
ScreenWipe

kCenter "Game over.", 85, 12
kCenter "Press a key to return to the main menu.", 105, 14

DO
 z$ = INKEY$: IF z$ <> "" THEN EXIT DO
LOOP

END SUB

SUB GetCharStats

xtilepos! = (levelpixelx / 16) + 1
ytilepos! = levelpixely / 16
wtputx = levelpixelx - (xpos * 16) + offsetx
wtputy = levelpixely - ((levelheight - 10 - ypos) * 16) - charheight + offsety

END SUB

SUB getcolor (pal, r, g, b)

OUT &H3C7, pal
r = INP(&H3C9)
g = INP(&H3C9)
b = INP(&H3C9)

END SUB

SUB getColValues

FOR a = 1 TO 254
 getcolor a, r, g, b
 changevalue(a).red = r / fadestep
 changevalue(a).green = g / fadestep
 changevalue(a).blue = b / fadestep
NEXT a

END SUB

SUB GetFonts

' -- Upper case letters --
font$(0) = "bd1 d5u5e1r4f1d5u3l6"
font$(1) = "d6u6r5f1d1g1l5r5f1d1g1l5"
font$(2) = "br6 l5g1d4f1r5"
font$(3) = "d6u6r5f1d4g1l5"
font$(4) = "r6l6d3r6l6d3r6"
font$(5) = "r6l6d3r6l6d3"
font$(6) = "br6 l5g1d4f1r4e1u2l3"
font$(7) = "d6u3r6d3u6"
font$(8) = "br3 d6"
font$(9) = "br6 d5g1l5"
font$(10) = "br1 d6u3r1e3g3f3"
font$(11) = "d6r6"
font$(12) = "bd1 d5u5e1r1f1d1u1e1r1f1d5"
font$(13) = "d6u6f6u6"
font$(14) = "bd1 d4f1r4e1u4h1l4g1"
font$(15) = "d6u6r5f1d1g1l4"
font$(16) = "bd1 d4f1r3e1h1f2h1e1u3h1l4g1"
font$(17) = "d6u6r5f1d1g1l5r2f3"
font$(18) = "br6 l5g1d1f1r4f1d1g1l5"
font$(19) = "r6l3d6"
font$(20) = "d5f1r4e1u5"
font$(21) = "d3f3e3u3"
font$(22) = "d5f1r1e1u2d2f1r1e1u5"
font$(23) = "f6 bl6 e6"
font$(24) = "f3e3g3d3"
font$(25) = "r6g6r6"
' -- Lower case letters --
font$(26) = "bd2 br1 g1d2f1r3e2d2u3h1l4"
font$(27) = "d6r5e1u2h1l4"
font$(28) = "bd2 br1 r5l5g1d2f1r5"
font$(29) = "br6 d6l5h1u2e1r4"
font$(30) = "bd2 br1 r4f1g1l5u1d2f1r5"
font$(31) = "br3 r2l2g1d5u4r2l3"
font$(32) = "bd2 br5 l4g1f1r5u1d2g1l5"
font$(33) = "d6u4r5f1d3"
font$(34) = "br3 d0 bd2 d4"
font$(35) = "br4 d0 bd2 d3 g1 l2"
font$(36) = "br1 d6u2r1e2g2f2"
font$(37) = "br3 d6"
font$(38) = "bd3 d3u3e1r1f1d3u3e1r1f1d3"
font$(39) = "bd3 d3u3e1r4f1d3"
font$(40) = "bd3 d2f1r4e1u2h1l4"
font$(41) = "bd2 d4u4r5f1g1l4"
font$(42) = "bd3 f1r5u2l5r5d4"
font$(43) = "bd2 br1 d4u2e2r2"
font$(44) = "bd3 e1r5l5g1f1r4f1g1l5"
font$(45) = "br3 d6u4l2r4"
font$(46) = "bd2 d3f1r4e1u3"
font$(47) = "bd2 d1f3e3u1"
font$(48) = "bd2 d3f1r1e1u3d3f1r1e1u3"
font$(49) = "bd2 br1 f4h2e2g4"
font$(50) = "bd2 d1f1r5u2d3g1l5"
font$(51) = "bd2 br1 r4g4r4"
' -- Numbers --
font$(52) = "bd2 d2f2r2e2u2h2l2g2"
font$(53) = "br2 r1d6l2r4"
font$(54) = "bd1 br1 e1r2f1d1g4r4"
font$(55) = "r4f1d1g1l4r4f1d1g1l4"
font$(56) = "br1 d3r4u3d6"
font$(57) = "br5 l5d3r4f1d1g1l4"
font$(58) = "br5 l4g1d4f1r3e1u1h1l3"
font$(59) = "r4d2g1d3"
font$(60) = "br4 l3g1d1f1g1d1f1r3e1u1h1l3r3e1u1"
font$(61) = "br4 l3g1d1f1r4u3d6"
' -- Special characters #1 --
font$(62) = "br3 d4 bd2 d0"
font$(63) = "br2 d2 br2 u2"
font$(64) = "br1 d6u5l1r6l1u1d6u1r1l6"
font$(65) = "br6 bd1 l5g1f1r4f1g1l5 br2 bd1 u6 br2 d6"
font$(66) = "br6 g6 bu6 r1d1l1u1 bf6 u1l1d1r1"
font$(67) = "br6 bd6 l1h4u1e1r1f1g3d1f1r1e2u1r1"
font$(68) = "br3 d2"
font$(69) = "br4 l1g2d2f2r1"
font$(70) = "br2 r1f2d2g2l1"
font$(71) = "br1 bd1 f4h2e2g4e2u2d4u2r2l4"
font$(72) = "br1 bd3 r4l2u2d4"
font$(73) = "br3 bd5 d1l1u1r1d1g1l1"
font$(74) = "bd3 r6"
font$(75) = "br3 bd5 d1l1u1r1"
font$(76) = "br6 g6"
' -- Special characters #2 --
font$(77) = "br3 bd2 d1r1u1 bd3 d1l1u1"
font$(78) = "br3 bd2 d1r1u1 bd3 d1l1u1d2l1"
font$(79) = "br4 g3f3"
font$(80) = "br1 bd2 r4 bd2 l4"
font$(81) = "br2 f3g3"
font$(82) = "r5f1d1g1l2d1 bd2 d0"
font$(83) = "bd6 br1 h1u4e1r4f1d4g1l2h1u2e1r1f1d2"

END SUB

SUB GetItem (x, y)

SELECT CASE MID$(layer2$(y), x, 1)
CASE "C"
 CDs = CDs + 1
 score = score + 10
 IF soundison = 1 THEN
  SOUND 400, .7
  SOUND 600, .7
 END IF
END SELECT

scorechanged = 1

MID$(layer2$(y), x, 1) = " "
GetPixCords x, y
PUT (oldcx, oldcy), coverup&, PSET
drawtile x, y, objectx, objecty
GET (oldcx, oldcy)-(oldcx + 15, oldcy + 31), coverup&
svalue = charredraw: charredraw = 0: putcharacter
charredraw = svalue

END SUB

SUB GetPixCords (x, y)

xt = ((x - 1) * 16)
yt = ((y + 1) * 16)
objectx = xt - (xpos * 16) + offsetx
objecty = yt - ((levelheight - 10 - ypos) * 16) - 16 + offsety

END SUB

SUB GetTileSet (filename$)

BLOAD dir$ + filename$

FOR a = 1 TO 20
 x = (a - 1) * 16
 GET (x, 0)-(x + 15, 15), bg&((a - 1) * 66)
NEXT a

FOR a = 1 TO 20
 x = (a - 1) * 16
 GET (x, 16)-(x + 15, 31), bg&((a + 19) * 66)
NEXT a

FOR a = 1 TO 10
 x = (a - 1) * 16
 GET (x, 32)-(x + 15, 47), fgwalkon&((a - 1) * 66)
NEXT a

FOR a = 1 TO 20
 x = (a - 1) * 16
 GET (x, 48)-(x + 15, 63), fgcgthru&((a - 1) * 66)
NEXT a

FOR a = 1 TO 5
 x = (a - 1) * 16
 GET (x, 64)-(x + 15, 79), losealife&((a - 1) * 66)
NEXT a

FOR a = 1 TO 10
 x = (a - 1) * 16
 GET (x, 80)-(x + 15, 95), objnm&((a - 1) * 66)
NEXT a

x = 0: xw = 159
y = 80: yw = 15

FOR a = x TO (x + xw)
 FOR b = y TO (y + yw)
  IF POINT(a, b) <> 0 THEN PSET (a, b), 0 ELSE PSET (a, b), 255
 NEXT b
NEXT a

FOR a = 1 TO 10
 x = (a - 1) * 16
 GET (x, 80)-(x + 15, 95), objwm&((a - 1) * 66)
NEXT a

CLS

END SUB

SUB Init

FOR a = 1 TO 254
 changecolor a, 0, 0, 0
NEXT a

BLOAD dir$ + "robotrob.pic"  'General game graphics

GET (0, 0)-(15, 15), backg&
GET (16, 0)-(31, 15), exitsign&
GET (32, 0)-(38, 6), cdsmall&
GET (32, 7)-(38, 15), charsmall&
GET (39, 0)-(54, 15), cd&
GET (55, 0)-(70, 7), backgs&
GET (55, 8)-(71, 15), mArrow&(0 * 39)
GET (72, 8)-(88, 15), mArrow&(1 * 39)

x = 32: y = 0: xw = 56: yw = 15
GOSUB dmask
GET (32, 0)-(38, 6), cdsmallm&
GET (32, 7)-(38, 15), charsmallm&
GET (39, 0)-(54, 15), cdm&
GET (55, 8)-(71, 15), mArrowm&(0 * 39)
GET (72, 8)-(88, 15), mArrowm&(1 * 39)

BLOAD dir$ + "chsprite.pic" 'Character graphics

GET (0, 0)-(15, 31), charstanding&((right - 1) * 190)
GET (16, 0)-(31, 31), charstanding&((left - 1) * 190)
GET (32, 0)-(47, 31), charwalking&((right - 1) * 190)
GET (48, 0)-(63, 31), charwalking&((left - 1) * 190)
GET (64, 0)-(79, 31), charjump&((right - 1) * 190)
GET (80, 0)-(95, 31), charjump&((left - 1) * 190)

x = 0: y = 0: xw = 95: yw = 31
GOSUB dmask

GET (0, 0)-(15, 31), charstandmask&((right - 1) * 190)
GET (16, 0)-(31, 31), charstandmask&((left - 1) * 190)
GET (32, 0)-(47, 31), charwalkmask&((right - 1) * 190)
GET (48, 0)-(63, 31), charwalkmask&((left - 1) * 190)
GET (64, 0)-(79, 31), charjumpmask&((right - 1) * 190)
GET (80, 0)-(95, 31), charjumpmask&((left - 1) * 190)

BLOAD dir$ + "ensprite.pic"  'Enemy sprites

GET (0, 0)-(15, 15), enemyflat&(0 * 68)
GET (16, 0)-(31, 15), enemyflat&(1 * 68)
GET (32, 0)-(47, 15), enemyp1&(1 * 68)
GET (48, 0)-(63, 15), enemyp2&(1 * 68)
GET (64, 0)-(79, 15), enemyp1&(0 * 68)
GET (80, 0)-(95, 15), enemyp2&(0 * 68)

GET (96, 0)-(111, 15), spikeb&(0 * 68)
GET (112, 0)-(127, 15), spikeb&(1 * 68)

x = 0: y = 0: xw = 127: yw = 60
GOSUB dmask

GET (0, 0)-(15, 15), enemyflatm&(0 * 68)
GET (16, 0)-(31, 15), enemyflatm&(1 * 68)
GET (32, 0)-(47, 15), enemyp1m&(1 * 68)
GET (48, 0)-(63, 15), enemyp2m&(1 * 68)
GET (64, 0)-(79, 15), enemyp1m&(0 * 68)
GET (80, 0)-(95, 15), enemyp2m&(0 * 68)

GET (96, 0)-(111, 15), spikebm&(0 * 68)
GET (112, 0)-(127, 15), spikebm&(1 * 68)

CLS : PALETTE

DEF SEG = 0

EXIT SUB

dmask:
FOR a = x TO (x + xw)
 FOR b = y TO (y + yw)
  IF POINT(a, b) <> 0 THEN PSET (a, b), 0 ELSE PSET (a, b), 255
 NEXT b
NEXT a

RETURN

END SUB

SUB Intro

FOR a = 0 TO 10
 changecolor 40 + a, 11 - a, 11 - a, 63
 changecolor 80 + a, 0, 0, 56 - a
NEXT a

FOR a = 0 TO 25
 changecolor 50 + a, 0, 0, 63 - a
 changecolor 90 + a, 0, 0, 45 - a
NEXT a

logocenterx = 160
logocentery = 80

FOR a = 0 TO 25
 LINE (logocenterx - a, logocentery - a)-(logocenterx - a, logocentery + a), 50 + a
 LINE (logocenterx - a, logocentery + a)-(logocenterx + a, logocentery + a), 50 + a
 LINE (logocenterx + 1 + (a / 1.5), logocentery + (a / 1.5))-(logocenterx + 1 + (a / 1.5), logocentery - (a / 1.5)), 90 + a
 WAIT &H3DA, 8
NEXT a

TypeIt "KeiProductions presents...", 56, 112, 29, 22

start! = TIMER: DO: LOOP WHILE TIMER < start! + .3

changecolor 19, 63, 63, 63

FOR a = 57 TO 305
 FOR b = 55 TO 118
  IF POINT(a, b) > 0 THEN
   PSET (a, b), POINT(a, b) - 10
  END IF
  IF POINT(a - 30, b) > 0 THEN
   PSET (a - 30, b), POINT(a - 30, b) + 10
  END IF
 NEXT b
 IF a MOD 4 > 0 THEN WAIT &H3DA, 8
NEXT a

start! = TIMER: DO: LOOP WHILE TIMER < start! + .8

fadeOut

setColsBlack

setCPalette

END SUB

SUB kCenter (text$, typos, clr)

n = LEN(text$)

FOR a = 1 TO n
 IF MID$(text$, a, 1) = "|" THEN n = n - 4
NEXT a

txpos = CINT((319 - (n * 8)) / 2)

kfont text$, txpos, typos, clr

END SUB

SUB kfont (text$, txpos, typos, clr)

startx = txpos
starty = typos

startx$ = LTRIM$(RTRIM$(STR$(startx)))
starty$ = LTRIM$(RTRIM$(STR$(starty)))

DRAW "bm" + startx$ + "," + starty$
DRAW "c" + STR$(clr)

n = LEN(text$)

FOR a = 1 TO n
 char$ = MID$(text$, a, 1)
 IF char$ = "|" THEN
  color$ = MID$(text$, a + 1, 3)
  clr = VAL(color$)
  DRAW "c" + STR$(clr)
  a = a + 3
  d = d + 4
  GOTO nxta
 END IF
 x = startx + ((a - 1 - d) * 8)
 ascc = ASC(char$)
 IF ascc >= 97 AND ascc <= 122 THEN  'Lowercase letter
  ascc = ASC(char$) - 71
 ELSEIF ascc >= 65 AND ascc <= 90 THEN 'Uppercase letter
  ascc = ASC(char$) - 65
 ELSEIF ascc >= 48 AND ascc <= 57 THEN  ' Number
  ascc = ASC(char$) + 4
 ELSEIF ascc >= 33 AND ascc <= 47 THEN ' Special chars #1
  ascc = ASC(char$) + 29
 ELSEIF ascc >= 58 AND ascc <= 64 THEN ' Special chars #2
  ascc = ASC(char$) + 19
 ELSE
  char$ = " "
 END IF
 move$ = "bm" + LTRIM$(RTRIM$(STR$((x)))) + "," + starty$
 SELECT CASE char$
  CASE " ": whichletter$ = ""
  CASE ELSE: whichletter$ = font$(ascc)
 END SELECT
 DRAW move$ + whichletter$
nxta:
NEXT a

END SUB

SUB LoadLevel

filename$ = "robotlev.dat"

OPEN dir$ + filename$ FOR INPUT AS #1

DO
 LINE INPUT #1, comments$
 IF LEFT$(comments$, 1) <> "'" THEN EXIT DO
 comments = comments + 1
LOOP

DO
 LINE INPUT #1, line$
 IF LEFT$(line$, 1) = "'" THEN EXIT DO
 IF EOF(1) THEN EXIT DO
 heightoflevel = heightoflevel + 1
LOOP

CLOSE #1

OPEN dir$ + filename$ FOR INPUT AS #1
FOR a = 1 TO comments: LINE INPUT #1, ignore$: NEXT a

INPUT #1, startx
INPUT #1, starty
INPUT #1, startscrx
INPUT #1, startscry
INPUT #1, doesitscrollup
INPUT #1, facing
INPUT #1, gtilename$

ERASE scr$

FOR a = 1 TO heightoflevel
 LINE INPUT #1, scr$(a)
NEXT a

LINE INPUT #1, skip$

RANDOMIZE TIMER

FOR a = 1 TO heightoflevel
 LINE INPUT #1, layer2$(a)
 FOR b = 1 TO LEN(layer2$(a))
  snip$ = MID$(layer2$(a), b, 1)
  IF snip$ = "o" THEN
   enemiesinlevel2 = enemiesinlevel2 + 1
   enemy2(enemiesinlevel2).walkstate = INT(RND * 10) + 1
   enemy2(enemiesinlevel2).pixelx = ((b - 1) * 16)
   enemy2(enemiesinlevel2).pixely = ((a + 1) * 16)
   enemy2(enemiesinlevel2).direction = INT(RND * 2) + 1
  ELSEIF snip$ = "<" OR snip$ = ">" THEN
   'Add up the enemies in the level
   enemiesinlevel = enemiesinlevel + 1
   enemy(enemiesinlevel).pixelx = ((b - 1) * 16)
   enemy(enemiesinlevel).pixely = ((a + 1) * 16)
   IF snip$ = "<" THEN enemy(enemiesinlevel).direction = left ELSE enemy(enemiesinlevel).direction = right
   enemy(enemiesinlevel).walkstate = INT(RND * 10) + 1
   enemy(enemiesinlevel).alive = 1
   enemy(enemiesinlevel).squished = 0
  END IF
 NEXT b
NEXT a

CLOSE #1

levelheight = heightoflevel

GetTileSet gtilename$

END SUB

SUB MainMenu
CLS

setCPalette

changecolor 245, 63, 63, 0    'Press Enter to continue text
changecolor 247, 63, 63, 63   'White
changecolor 248, 63, 63, 0    'Yellow
changecolor 249, 30, 30, 63   'Blue
changecolor 250, 10, 63, 10   'Green
changecolor 251, 63, 63, 63   'Selected item
changecolor 252, 31, 31, 31   'Not selected

FOR a = 195 TO 231
cl = a - 200
IF a >= 200 THEN r = 0 + cl ELSE r = 0
changecolor a, r, 16 + cl, 32 + cl
NEXT a

level = 1

getColValues
setColsBlack

BLOAD dir$ + "robtlscr.pic"

kfont "Enter to continue", 184, 192, 245

fadein

DO: LOOP WHILE INKEY$ <> CHR$(13)

mselect = 1
oldselect = 2

'fade out partially
FOR a = 1 TO (fadestep - 5)
 FOR c = 1 TO 245
  IF c = 245 THEN a = a * 1.35
  cred! = (changevalue(c).red * (fadestep - a))
  cgreen! = (changevalue(c).green * (fadestep - a))
  cblue! = (changevalue(c).blue * (fadestep - a))
  changecolor c, CINT(cred!), CINT(cgreen!), CINT(cblue!)
  IF c = 245 THEN a = a / 1.35
 NEXT c
NEXT a

stage = 1
arrowstage = 1
arrowmoving = 0

arrowx = 82
arrowmoveto = 8 * (7 + (mselect * 2)) - 1
arrowy = 0

btmainmenu:
menuchoice$(1) = "Start new game"
menuchoice$(2) = "Options"
menuchoice$(3) = "Help"
menuchoice$(4) = "Quit the game"
choices = 4
optionmenuon = 0

genmenu:

FOR a = 1 TO choices
kfont menuchoice$(a), 104, 8 * (7 + (a * 2)), 252
NEXT a


GET (arrowx, arrowy)-(arrowx + 16, arrowy + 7), mArrowback&

PUT (arrowx, arrowy), mArrowm&(arrowstage * 39), AND
PUT (arrowx, arrowy), mArrow&(arrowstage * 39), OR

DO
waitforselect:
 counter = counter + 1
 IF counter > 100 THEN counter = 1
 WAIT &H3DA, 8, 8: WAIT &H3DA, 8
 getcolor 251, r, g, b
  SELECT CASE stage
   CASE 1
    r = r - 1: g = g - 1: b = b - 1
    IF r = 31 THEN stage = 2
   CASE 2
    r = r + 1: g = g + 1: b = b + 1
    IF r = 63 THEN stage = 1
  END SELECT
 changecolor 251, r, g, b
 IF counter MOD 20 = 0 THEN
  arrowstage = arrowstage + 1: IF arrowstage = 2 THEN arrowstage = 0
 END IF
 PUT (arrowx, arrowy), mArrowback&, PSET
 IF arrowmoveto <> arrowy THEN
  IF arrowmoveto > arrowy THEN
   IF arrowy + 15 < arrowmoveto THEN
    arrowy = arrowy + 2
   ELSEIF arrowy + 10 < arrowmoveto THEN
    arrowy = arrowy + 1
   ELSE
    IF counter MOD 2 = 0 THEN arrowy = arrowy + 1
   END IF
  ELSEIF arrowmoveto < arrowy THEN
   IF arrowy - 15 > arrowmoveto THEN
    arrowy = arrowy - 2
   ELSEIF arrowy - 10 > arrowmoveto THEN
    arrowy = arrowy - 1
   ELSE
    IF counter MOD 2 = 0 THEN arrowy = arrowy - 1
   END IF
  END IF
  GET (arrowx, arrowy)-(arrowx + 16, arrowy + 7), mArrowback&
 END IF
 PUT (arrowx, arrowy), mArrowm&(arrowstage * 39), AND
 PUT (arrowx, arrowy), mArrow&(arrowstage * 39), OR
 kfont menuchoice$(mselect), 104, 8 * (7 + (mselect * 2)), 251
 kfont menuchoice$(oldselect), 104, 8 * (7 + (oldselect * 2)), 252
 z$ = INKEY$
 IF z$ = "" GOTO waitforselect
 IF z$ = CHR$(13) THEN EXIT DO
 IF z$ = CHR$(0) + CHR$(72) THEN
  IF mselect > 1 THEN
   oldselect = mselect: mselect = mselect - 1
   changecolor 251, 30, 30, 30: stage = 2
   arrowmoveto = 8 * (7 + (mselect * 2)) - 1
  END IF
 ELSEIF z$ = CHR$(0) + CHR$(80) THEN
  IF mselect < choices THEN
   oldselect = mselect: mselect = mselect + 1
   changecolor 251, 30, 30, 30: stage = 2
   arrowmoveto = 8 * (7 + (mselect * 2)) - 1
  END IF
 END IF
LOOP

SELECT CASE mselect
 CASE 1
  IF optionmenuon = 1 THEN
   BLOAD dir$ + "robtlscr.pic"
   changecolor 251, 30, 30, 30: stage = 2
   IF soundison = 1 THEN soundison = 0 ELSE soundison = 1
   IF soundison = 1 THEN sound$ = "on" ELSE sound$ = "off"
   menuchoice$(1) = "Sound: " + sound$
   GOTO genmenu
  END IF
  ScreenWipe
  setCPalette
  EXIT SUB
 CASE 2
  IF optionmenuon = 1 THEN
   BLOAD dir$ + "robtlscr.pic"
   changecolor 251, 30, 30, 30: stage = 2
   gamedelay = gamedelay + 1000
   IF gamedelay = 21000 THEN gamedelay = 0
   gamedelay$ = LTRIM$(RTRIM$(STR$(gamedelay)))
   menuchoice$(2) = "In game delay: " + gamedelay$
   GOTO genmenu
  END IF
  BLOAD dir$ + "robtlscr.pic"
  changecolor 251, 30, 30, 30: stage = 2
  choices = 3: mselect = 1: oldselect = 2: COLOR 7
  optionmenuon = 1
  IF soundison = 1 THEN sound$ = "on" ELSE sound$ = "off"
  gamedelay$ = LTRIM$(RTRIM$(STR$(gamedelay)))
  menuchoice$(1) = "Sound: " + sound$
  menuchoice$(2) = "In game delay: " + gamedelay$
  menuchoice$(3) = "Return to main menu"
  arrowmoveto = 8 * (7 + (mselect * 2)) - 1
  GOTO genmenu
 CASE 3
  IF optionmenuon = 1 THEN
   changecolor 251, 30, 30, 30: stage = 2
   BLOAD dir$ + "robtlscr.pic"
   mselect = 2: oldselect = 1
   arrowmoveto = 8 * (7 + (mselect * 2)) - 1
   GOTO btmainmenu
  END IF
  BLOAD dir$ + "robtlscr.pic"
  kCenter "Help - How to play", 30, 248
  kCenter "Move the character and find the exit!", 40, 247
  kCenter "Keys during game:", 58, 248
  kfont "Left Control|247 - move left", 56, 68, 250
  kfont "Left Alt|247     - move right", 56, 78, 250
  kfont "Right Shift|247  - jump/enter exit", 56, 88, 250
  kfont "Esc|247          - return to menu", 56, 98, 250
  kCenter "If you have any questions or comments,", 120, 247
  kCenter "mail me at |249Robotrob@keithkosh.com|247.", 130, 247
  kCenter "Press Enter to return to the menu...", 160, 248
  DO: LOOP UNTIL INKEY$ = CHR$(13)
  BLOAD dir$ + "robtlscr.pic"
  changecolor 251, 30, 30, 30: stage = 2
  mselect = 3: oldselect = 2
  GOTO btmainmenu
 CASE 4
  EndProgram
END SELECT


END SUB

SUB MoveEnemies

STATIC whentomove
whentomove = whentomove + 1
IF whentomove = 2 THEN whentomove = 0
IF whentomove = 0 THEN EXIT SUB

 FOR a = 1 TO enemiesinlevel
  wx = enemy(a).pixelx - (xpos * 16) + offsetx
  wy = enemy(a).pixely - ((levelheight - 10 - ypos) * 16) - 16 + offsety
  IF enemy(a).alive = 0 THEN
   IF enemy(a).squished < 40 THEN enemy(a).squished = enemy(a).squished + 1
   IF enemy(a).squished < 40 THEN
    IF wx > -1 + offsetx AND wy > -1 + offsety AND wy <= 160 + offsety AND wx <= 272 + offsetx THEN
     PUT (wx, wy), enemyflatm&((enemy(a).direction - 1) * 68), AND
     PUT (wx, wy), enemyflat&((enemy(a).direction - 1) * 68), OR
    END IF
   END IF
   IF enemy(a).squished = 40 THEN
    IF wx > -1 + offsetx AND wy > -1 + offsety AND wy <= 160 + offsety AND wx <= 272 + offsetx THEN
     PUT (wx, wy), ecoverup&(a * 65), PSET
     enemy(a).squished = enemy(a).squished + 1
    END IF
   END IF
   GOTO nexta
  END IF
  enemy(a).walkstate = enemy(a).walkstate + 1
  IF enemy(a).walkstate = 11 THEN enemy(a).walkstate = 1
   'check for other enemies
   IF enemy(a).direction = right THEN Add = 16 ELSE Add = -16
   FOR b = 1 TO enemiesinlevel
    IF b = a THEN GOTO skipthisone
    IF enemy(b).alive = 0 THEN GOTO skipthisone
    IF enemy(a).pixely = enemy(b).pixely THEN
     IF enemy(b).pixelx >= (enemy(a).pixelx + Add) AND enemy(b).pixelx <= (enemy(a).pixelx + Add + 1) THEN
      IF enemy(b).direction <> enemy(a).direction THEN
       IF enemy(b).direction = right THEN enemy(b).direction = left ELSE enemy(b).direction = right
       IF enemy(a).direction = right THEN enemy(a).direction = left ELSE enemy(a).direction = right
      END IF
     END IF
    END IF
skipthisone:
   NEXT b
  IF (wx - offsetx) MOD 16 = 0 THEN
   tilex = (enemy(a).pixelx / 16) + 1
   tiley = (enemy(a).pixely / 16) - 1
   IF wx > -1 + offsetx AND wy > -1 + offsety AND wy <= 160 + offsety AND wx <= 272 + offsetx THEN
    drawtile tilex, tiley, wx, wy
    drawtile2 tilex, tiley, wx, wy
    GET (wx, wy)-(wx + 15, wy + 15), ecoverup&(a * 65)
   END IF
   IF enemy(a).direction = right THEN move = 1 ELSE move = -1
   IF tilex + move <= 0 THEN
    enemy(a).direction = right
   ELSEIF INSTR(cantgothru$, MID$(scr$(tiley), tilex + move, 1)) THEN
    IF move = 1 THEN enemy(a).direction = left ELSE enemy(a).direction = right
   ELSEIF INSTR(cantgothru$, MID$(scr$(tiley + 1), tilex + move, 1)) = 0 THEN
    IF INSTR(walkon$, MID$(scr$(tiley + 1), tilex + move, 1)) = 0 THEN
    IF move = 1 THEN enemy(a).direction = left ELSE enemy(a).direction = right
    END IF
   END IF
  END IF
  IF wx > -1 + offsetx AND wy > -1 + offsety AND wy <= 160 + offsety AND wx <= 272 + offsetx THEN
    IF enemy(a).onscreen = 1 THEN PUT (wx, wy), ecoverup&(a * 65), PSET
   enemy(a).onscreen = 1
  ELSE
   enemy(a).onscreen = 0
  END IF
  IF enemy(a).direction = right THEN
   enemy(a).pixelx = enemy(a).pixelx + 1: wx = wx + 1
  ELSE
   enemy(a).pixelx = enemy(a).pixelx - 1: wx = wx - 1
  END IF
  IF wx > -1 + offsetx AND wy > -1 + offsety AND wy <= 160 + offsety AND wx <= 272 + offsetx AND enemy(a).onscreen = 1 THEN
   GET (wx, wy)-(wx + 15, wy + 15), ecoverup&(a * 65)
   putenemy a, wx, wy, 1
  ELSE
   enemy(a).onscreen = 0
  END IF
nexta:
 NEXT a

FOR a = 1 TO enemiesinlevel2
  enemy2(a).walkstate = enemy2(a).walkstate + 1
  IF enemy2(a).walkstate = 11 THEN enemy2(a).walkstate = 1
  wx = enemy2(a).pixelx - (xpos * 16) + offsetx
  wy = enemy2(a).pixely - ((levelheight - 10 - ypos) * 16) - 16 + offsety
  move = enemy2(a).direction
  IF (wy - offsety) MOD 16 = 0 THEN
   tilex = (enemy2(a).pixelx / 16) + 1
   tiley = (enemy2(a).pixely / 16) - 1
   IF wx > -1 + offsetx AND wy > -1 + offsety AND wy <= 160 + offsety AND wx <= 272 + offsetx THEN
    drawtile tilex, tiley, wx, wy
    drawtile2 tilex, tiley, wx, wy
    GET (wx, wy)-(wx + 15, wy + 15), ecoverup2&(a * 65)
   END IF
   IF tiley = 1 AND move = -1 THEN enemy2(a).direction = 1: move = 1
   IF tiley = levelheight THEN enemy2(a).direction = -1: move = -1
   IF INSTR(cantgothru$, MID$(scr$(tiley + move), tilex, 1)) THEN
    IF move = 1 THEN enemy2(a).direction = -1: move = -1 ELSE enemy2(a).direction = 1: move = 1
   END IF
  END IF
  IF wx > -1 + offsetx AND wy > -1 + offsety AND wy <= 160 + offsety AND wx <= 272 + offsetx THEN
    IF enemy2(a).onscreen = 1 THEN PUT (wx, wy), ecoverup2&(a * 65), PSET
   enemy2(a).onscreen = 1
  ELSE
   enemy2(a).onscreen = 0
  END IF
  enemy2(a).pixely = enemy2(a).pixely + move: wy = wy + move
  IF wx > -1 + offsetx AND wy > -1 + offsety AND wy <= 160 + offsety AND wx <= 272 + offsetx AND enemy2(a).onscreen = 1 THEN
   GET (wx, wy)-(wx + 15, wy + 15), ecoverup2&(a * 65)
   putenemy a, wx, wy, 2
  ELSE
   enemy2(a).onscreen = 0
  END IF
NEXT a

END SUB

SUB putcharacter
STATIC blink, go

IF blink = 0 THEN
 a = INT(RND * 150) + 1
 go = 100 + a
END IF

blink = blink + 1

IF blink = go + 20 THEN
 blink = 0
END IF

GetCharStats

IF charredraw = 1 THEN
 PUT (oldcx, oldcy), coverup&, PSET
 GET (wtputx, wtputy)-(wtputx + 15, wtputy + 31), coverup&
END IF

charredraw = 0

IF walking >= 10 THEN
 PUT (wtputx, wtputy), charwalkmask&((facing - 1) * 190), AND
 PUT (wtputx, wtputy), charwalking&((facing - 1) * 190), OR
ELSEIF jumping = 1 OR bounce = 1 THEN
 PUT (wtputx, wtputy), charjumpmask&((facing - 1) * 190), AND
 PUT (wtputx, wtputy), charjump&((facing - 1) * 190), OR
ELSE
 PUT (wtputx, wtputy), charstandmask&((facing - 1) * 190), AND
 PUT (wtputx, wtputy), charstanding&((facing - 1) * 190), OR
END IF

ex = wtputx + 4: ey = wtputy + 3
IF facing = right THEN ex = ex + 6

IF blink >= go AND blink <= go + 10 THEN
 LINE (ex, ey)-(ex + 1, ey + 1), 135, BF   'Blink blink
END IF

END SUB

SUB putenemy (n, x, y, t)

SELECT CASE t
CASE 1

SELECT CASE enemy(n).walkstate
CASE 1 TO 5
 PUT (x, y), enemyp1m&((enemy(n).direction - 1) * 68), AND
 PUT (x, y), enemyp1&((enemy(n).direction - 1) * 68), OR
CASE 6 TO 10
 PUT (x, y), enemyp2m&((enemy(n).direction - 1) * 68), AND
 PUT (x, y), enemyp2&((enemy(n).direction - 1) * 68), OR
END SELECT

CASE 2

SELECT CASE enemy2(n).walkstate
CASE 1 TO 5
 PUT (x, y), spikebm&(0 * 68), AND
 PUT (x, y), spikeb&(0 * 68), OR
CASE 6 TO 10
 PUT (x, y), spikebm&(1 * 68), AND
 PUT (x, y), spikeb&(1 * 68), OR
END SELECT

END SELECT

END SUB

SUB ScreenWipe

c = 520
d = 199

FOR a = 0 TO 520
 FOR b = 0 TO 198 STEP 2
  PSET ((a - 1) - b, b), 0
  PSET ((c - 1) - d, d), 0
  d = d - 2
 NEXT b
 c = c - 1: d = 199

NEXT a

END SUB

SUB scrollback (What$)

IF What$ = "init" THEN
 IF xpos < startscrx THEN stepx = 1
 IF xpos > startscrx THEN stepx = -1
 IF xpos = startscrx THEN stepx = 0
 IF ypos = startscry THEN stepy = 0
 IF ypos > startscry THEN stepy = -1
 IF ypos < startscry THEN stepy = 1
ELSEIF What$ = "scroll" THEN
 IF xpos <> startscrx THEN xpos = xpos + stepx
 IF ypos <> startscry THEN ypos = ypos + stepy
END IF

END SUB

SUB secondpause (second!)

start! = TIMER
DO: LOOP WHILE TIMER < start! + second!

END SUB

SUB setColsBlack

FOR a = 1 TO 254
 changecolor a, 0, 0, 0
NEXT a

END SUB

SUB setCPalette

OPEN dir$ + "robotrob.pal" FOR BINARY AS #1

DIM pb AS STRING * 1

FOR c = 0 TO 255
 GET #1, , pb: r = ASC(pb)
 GET #1, , pb: g = ASC(pb)
 GET #1, , pb: b = ASC(pb)
 changecolor c, r, g, b
NEXT c

CLOSE #1


END SUB

SUB ShowEnemies
FOR a = 1 TO enemiesinlevel
 wx = enemy(a).pixelx - (xpos * 16) + offsetx
 wy = enemy(a).pixely - ((levelheight - 10 - ypos) * 16) - 16 + offsety
 IF wx > -1 + offsetx AND wy > -1 + offsety AND wy <= 160 + offsety AND wx <= 272 + offsetx THEN
  GET (wx, wy)-(wx + 15, wy + 15), ecoverup&(a * 65)
  putenemy a, wx, wy, 1
  enemy(a).onscreen = 1
 ELSE
  enemy(a).onscreen = 0
 END IF
NEXT a
FOR a = 1 TO enemiesinlevel2
 wx = enemy2(a).pixelx - (xpos * 16) + offsetx
 wy = enemy2(a).pixely - ((levelheight - 10 - ypos) * 16) - 16 + offsety
 IF wx > -1 + offsetx AND wy > -1 + offsety AND wy <= 160 + offsety AND wx <= 272 + offsetx THEN
  GET (wx, wy)-(wx + 15, wy + 15), ecoverup2&(a * 65)
  putenemy a, wx, wy, 2
  enemy2(a).onscreen = 1
 ELSE
  enemy2(a).onscreen = 0
 END IF
NEXT a

END SUB

SUB TypeIt (text$, txpos, typos, clr, prvcolor)

stx = txpos
sty = typos

FOR a = 1 TO (LEN(text$) + 1)
 IF a = 1 THEN
  kfont MID$(text$, a, 1), stx, sty, prvcolor
 ELSEIF a = (LEN(text$) + 1) THEN
  kfont MID$(text$, a - 1, 1), stx + ((a - 2) * 8), sty, clr
 ELSE
  kfont MID$(text$, a - 1, 1), stx + ((a - 2) * 8), sty, clr
  kfont MID$(text$, a, 1), stx + ((a - 1) * 8), sty, prvcolor
 END IF
 FOR n = 1 TO 20: WAIT &H3DA, 8: NEXT n
NEXT a

END SUB

SUB updatescore

PUT (0, 192), scorback&, PSET

kfont "x", 16, 192, 12
kfont "x", 288, 192, 12

kfont STR$(lives), 23, 192, 10
kCenter LTRIM$(RTRIM$(STR$(score))), 192, 9
kfont "x", 288, 192, 12
kfont LTRIM$(RTRIM$(STR$(CDs))), 304, 192, 14
END SUB

