DEFINT A-Z
'$DYNAMIC
''$INCLUDE: 'C:\QB45\TANKWARS\DS4QB2.BI'
OPTION BASE 1

TYPE RegisterType
  AX AS INTEGER
  BX AS INTEGER
  CX AS INTEGER
  DX AS INTEGER
  BP AS INTEGER
  SI AS INTEGER
  DI AS INTEGER
  FLAGS AS INTEGER
  DS AS INTEGER
  ES AS INTEGER
END TYPE

DECLARE SUB ShootGun ()
DECLARE SUB FastPSET (X%, Y%, Col%)
DECLARE SUB MakeLandScape ()
DECLARE SUB Init ()
DECLARE SUB StartGame ()
DECLARE SUB ShowTanks ()
DECLARE SUB LoadStuff ()
DECLARE SUB InitRandomGame ()
DECLARE SUB LoadFont ()
DECLARE SUB ShowBar ()
DECLARE SUB PrintFont (Txt$, X%, Y%, Col%)
DECLARE SUB ShowTurret ()
DECLARE SUB TimeOpts ()
DECLARE SUB RemTurret (A)
DECLARE SUB RemPower ()
DECLARE SUB ShowPower ()
DECLARE SUB SetSpeed ()
DECLARE SUB ExplodeShot ()
DECLARE SUB RemHTurret ()
DECLARE SUB FallStuff (ESize#, X1%, Y1%)
DECLARE SUB DiePlayer (A%)
DECLARE SUB DoCollision ()
DECLARE SUB WinGame ()
DECLARE SUB ShowTitle ()
DECLARE SUB LoadTaunts ()
DECLARE SUB CenterFont (Txt$, Y%, Col%)
DECLARE SUB MakeBar (X1%, Y1%, X2%, Y2%)
DECLARE SUB ShowMenu ()
DECLARE SUB NewTMenu ()
DECLARE SUB EndProg ()
DECLARE SUB EnterThings ()
DECLARE SUB FallTanks ()
DECLARE SUB LoadSounds ()
DECLARE SUB LoadNames ()
DECLARE SUB UInput (Length%, Col%, Xx%, Yy%, Var$, Back%)
DECLARE SUB ShowScores ()
DECLARE SUB Center (Ln%, Txt$)
DECLARE SUB WinScreen ()
DECLARE SUB LoadWeapons ()
DECLARE SUB ShowShoppe ()
DECLARE SUB ExplodeDirt (DirtSize#)
DECLARE SUB ShootDirt (StartX%, StartY%)
DECLARE SUB ShootCannon (StartX%, StartY%)
DECLARE SUB RemoveShield (A%)
DECLARE SUB ShowShield (A%)
DECLARE SUB DoSpecialCollision (Size#)
DECLARE SUB FadeCols (ColsFade%)
DECLARE SUB ExplodeNuclear (NuclearSize#)
DECLARE SUB ShootNuclear (StartX%, StartY%)
DECLARE SUB LoadDieTaunts ()
DECLARE SUB ShootAirStrike ()
DECLARE SUB ShootSuicide (Xx%, Yy%)
DECLARE SUB HideMouse ()
DECLARE SUB ShowMouse ()
DECLARE SUB InitMouse ()
DECLARE SUB SetRange (X1%, Y1%, X2%, Y2%)
DECLARE SUB InitDS4QB ()
DECLARE SUB LoadMusic (MusicName AS STRING, MusicType AS INTEGER, MusicChannel AS INTEGER, Repeat AS INTEGER, Enable3D AS INTEGER)
DECLARE SUB LoadSample ()
DECLARE SUB PlaySample (SFXT%)
DECLARE SUB SetVolume (MODVol%, SAMVol%, MP3Vol%)
DECLARE SUB ShutdownDS4QB ()
DECLARE SUB WaitforDMA0 ()
DECLARE SUB RandomTeleport (PlayerTurn)
DECLARE SUB ExplodeStrikeShot ()
DECLARE SUB SelectedTeleport (A)
DECLARE SUB CalcEnd ()
DECLARE SUB ActiveHomer ()
DECLARE SUB FireUp ()
DECLARE SUB RemTank (A%)
DECLARE SUB GetStx (StartX%, StartY%)
DECLARE SUB RemEnd ()
DECLARE SUB OptionsMenu ()
DECLARE SUB LoadDefs ()
DECLARE SUB SaveDefs ()
DECLARE SUB SpookyUFO ()
DECLARE SUB ReadingStuff ()
DECLARE SUB LoadGif (A$)
DECLARE SUB RespawnPlayer ()
DECLARE SUB ExplodeTimeB ()
DECLARE SUB TimeBomb ()
DECLARE SUB ShootLaser ()
DECLARE SUB EatDigger (Xx, Yy, Gt%)
DECLARE SUB ShootDigger (Gt)
DECLARE SUB CheckKeys ()
DECLARE FUNCTION LongBreak% (LongVar AS LONG, IntNum AS INTEGER)
DECLARE FUNCTION LongMake& (IntVar1 AS INTEGER, IntVar2 AS INTEGER)
DECLARE FUNCTION RightButton% ()
DECLARE FUNCTION MiddleButton% ()
DECLARE FUNCTION LeftButton% ()
DECLARE FUNCTION MouseY% ()
DECLARE FUNCTION MouseX% ()
DECLARE FUNCTION MouseInstalled% ()
DECLARE FUNCTION FastPoint% (X%, Y%)
DECLARE FUNCTION Collision% (XX1%, YY1%, S1%, XX2%, YY2%, S2%)

CLEAR , , 16400

CONST True = 1, False = 0, Pi = 3.141592654#

DIM SHARED Players, CompSpeed&, PlayerTurn, Wind, PlysLeft, Taunts, Names
DIM SHARED StartXvel#, StartYvel#, StartX, StartY, Gravity!, Xed, Yed, T#
DIM SHARED StartCash&, NumOfGames, ExpSize, DieTaunts, DirtFalls
DIM SHARED VersionId$, NowGame, SkyCol&, QuitIt, ChangeWind, Weapons
DIM SHARED SelWeapon, RealFall, ShieldRadius#, AmmoSpeed#, StrikeWidth
DIM SHARED InRegs AS RegisterType, OutRegs AS RegisterType, InStrike
DIM SHARED Winner$, HomingThing, Hasent, UnderSP, MaxWind, Steepness
DIM SHARED Bumpyness, MusVol, SoundVol, PlayingMod, Mods, LpX, LpY
DIM SHARED LaserL

Players = 2: CompSpeed& = 15000: PlayerTurn = 1: Wind = -3: Gravity! = 9.8
PlysLeft = Players: Taunts = 0: DirtFalls = True: StartCash& = 2500: LpY = 0
NumOfGames = 10: ExpSize = 15: Names = 0: VersionId$ = "Version 1.1"
NowGame = 1: SkyCol& = 256 ^ 2 * 20: QuitIt = False: ChangeWind = False
Weapons = 0: SelWeapon = 0: RealFall = False: ShieldRadius# = 9: LpX = 0
AmmoSpeed# = 6: DieTaunts = 0: StrikeWidth = 75: InStrike = 8: MaxWind = 10
Winner$ = "Error": HomingThing = False: Hasent = False: UnderSP = 255
Steepness = 5: Bumpyness = 10: MusVol = 50: SoundVol = 75: Mods = 3
LaserL = 8

DIM SHARED Tanks(52, 6, 2), PlayerX(8), PlayerY(8), PlayerTank(8)
DIM SHARED Font1(5, 5, 128), PlayerName$(8), UnderTurr(394), PlayerAngle(16)
DIM SHARED PlayerPower(16), Taunt$(512), Far(80), Bar(3362), Names$(512)
DIM SHARED ScoreList$(8), PlayerScore&(8), HighScore&(8), HighName$(8)
DIM SHARED PlayerWeapons(8, 32), WeaponName$(32), WeaponCost&(32)
DIM SHARED PlayerShield(8), PlayerShieldType(8), PlayerWasWep(8)
DIM SHARED DieTaunt$(512), MissileXVel#(32), MissileYVel#(32), MissileXS(32)
DIM SHARED MissileYS(32), MissileFar#(32), Keys(0 TO 127)

Init
ShowTitle
ShowMenu
EndProg

REM $STATIC
SUB ActiveHomer
Hasent = True
HomingThing = True
END SUB

SUB CalcEnd
IF PlayerPower(PlayerTurn) <= 0 THEN EXIT SUB

PrintFont "PLAYER" + STR$(PlayerTurn), 0, 0, 255
PrintFont PlayerName$(PlayerTurn), 0, 10, 255

GetStx StrtX, StrtY

PA# = PlayerAngle(PlayerTurn) / 180 * Pi

StartXvel# = COS(PA#) * PlayerPower(PlayerTurn)
StartYvel# = SIN(PA#) * PlayerPower(PlayerTurn)

Wind = Wind * 5
T# = 0

DO

Xed = StrtX + (StartXvel# * T#) + (.1 * (Wind / 5) * T# ^ 2)
Yed = StrtY + ((-1 * (StartYvel# * T#)) + (.1 * Gravity! * T# ^ 2)) * (200 / 350)

IF PlayerShield(PlayerTurn) > 0 THEN
IF Xed > ((PlayerX(PlayerTurn) + 4.5) - ShieldRadius#) - 1 AND Xed < ((PlayerX(PlayerTurn) + 4.5) + ShieldRadius#) + 1 THEN
IF Yed > ((PlayerY(PlayerTurn) + 4.5) - ShieldRadius#) - 1 AND Yed < ((PlayerY(PlayerTurn) + 4.5) + ShieldRadius#) + 1 THEN
FOR Angle = 0 TO 359 STEP 6
Theta# = Angle * (Pi / 180)
X = (PlayerX(PlayerTurn) + 4.5) + ShieldRadius# * (COS(Theta#))
Y = (PlayerY(PlayerTurn) + 4.5) - ShieldRadius# * (SIN(Theta#))
IF Xed = X AND Yed = Y THEN FastPSET Xed, Yed, 15 + (PlayerShield(PlayerTurn) * 2): Remst = True: GOTO NoCheckHom1
NEXT Angle
END IF
END IF
END IF

IF Yed > 178 THEN GOSUB EndShot: EXIT DO
IF Xed > 318 THEN GOSUB EndShot: EXIT DO
IF Xed < 1 THEN GOSUB EndShot: EXIT DO
IF NOT POINT(Xed, Yed) = 255 THEN GOSUB EndShot: EXIT DO
NoCheckHom1:

T# = T# + .05

LOOP

Wind = Wind / 5

PrintFont "PLAYER" + STR$(PlayerTurn), 0, 0, 15
PrintFont PlayerName$(PlayerTurn), 0, 10, 15
EXIT SUB

EndShot:
UnderSP = POINT(Xed, Yed)
LpX = Xed
LpY = Yed
FastPSET Xed, Yed, 4
RETURN
END SUB

SUB Center (Ln, Txt$)
LOCATE (Ln), (41 - LEN(Txt$) / 2): PRINT Txt$
END SUB

SUB CenterFont (Txt$, Y, Col)
Calced = 159 - LEN(Txt$) * 6 / 2
PrintFont Txt$, Calced, Y, Col
END SUB

SUB CFade (MusicChannel AS INTEGER, FadeStart AS INTEGER, FadeEnd AS INTEGER, FadeSpeed AS INTEGER)
WaitforDMA0
OPEN "DS4QB2.DAT" FOR OUTPUT AS #1
PRINT #1, MusicChannel
PRINT #1, FadeStart
PRINT #1, FadeEnd
PRINT #1, FadeSpeed
CLOSE #1
OUT &H0, 10
OUT &H0, 10
WaitforDMA0
END SUB

SUB CheckKeys
DEF SEG = 0

POKE 1050, PEEK(1052)
POKE 1047, PEEK(1047) AND 223

KeyP = INP(&H60)

SELECT CASE KeyP
CASE 0 TO 127
Keys(KeyP) = True
CASE 128 TO 255
Keys(KeyP XOR 128) = False
END SELECT

DEF SEG = &HA000
END SUB

FUNCTION Collision% (XX1, YY1, S1, XX2, YY2, S2)
Collision% = False
IF XX1 > XX2 AND XX1 < (XX2 + S2) AND YY1 > YY2 AND YY1 < (YY2 + S2) THEN Collision% = True
IF XX1 + S1 > XX2 AND XX1 + S1 < (XX2 + S2) AND YY1 > YY2 AND YY1 < (YY2 + S2) THEN Collision% = True
IF XX1 > XX2 AND XX1 < (XX2 + S2) AND YY1 + S1 > YY2 AND YY1 + S1 < (YY2 + S2) THEN Collision% = True
IF XX1 + S1 > XX2 AND XX1 + S1 < (XX2 + S2) AND YY1 + S1 > YY2 AND YY1 + S1 < (YY2 + S2) THEN Collision% = True
END FUNCTION

SUB CPan (MusicChannel AS INTEGER, PanStart AS INTEGER, PanEnd AS INTEGER, PanSpeed AS INTEGER)
WaitforDMA0
OPEN "DS4QB2.DAT" FOR OUTPUT AS #1
PRINT #1, MusicChannel
PRINT #1, PanStart
PRINT #1, PanEnd
PRINT #1, PanSpeed
CLOSE #1
OUT &H0, 9
OUT &H0, 9
WaitforDMA0
END SUB

SUB DiePlayer (A)
IF PlayerTank(A) = -1 THEN EXIT SUB

RemTank A

RemoveShield A
PlayerTank(A) = -1
ScoreList$(PlysLeft) = PlayerName$(A)
PlysLeft = PlysLeft - 1
IF PlysLeft = 1 THEN
FOR B = 1 TO Players
IF NOT PlayerTank(B) = -1 THEN Winner$ = PlayerName$(B)
NEXT B
END IF

LINE (0, 179)-(319, 199), 26, B
LINE (0, 179)-(318, 198), 31, B
LINE (1, 180)-(319, 199), 22, B
LINE (1, 180)-(318, 198), 27, BF

TauntType = INT(RND * 2) + 1
IF PlayerTurn = A THEN TauntType = 2

IF TauntType = 1 THEN
Text$ = PlayerName$(PlayerTurn) + ": " + Taunt$(INT(RND * Taunts) + 1)
CenterFont Text$, 186, 15
END IF
IF TauntType = 2 THEN
Text$ = PlayerName$(A) + ": " + DieTaunt$(INT(RND * DieTaunts) + 1)
CenterFont Text$, 186, 15
END IF

WHILE INKEY$ = "": WEND
END SUB

SUB DoCollision
FOR A = 1 TO Players
IF NOT PlayerTank(A) = -1 THEN

IF Xed >= PlayerX(A) - 1 AND Xed <= PlayerX(A) + 10 THEN
IF Yed >= PlayerY(A) - 1 AND Yed <= PlayerY(A) + 10 THEN
DiePlayer A
END IF
END IF

IF PlayerShieldType(A) > 0 THEN
FOR Angle = 0 TO 359 STEP 6
Theta# = Angle * (Pi / 180)
X = (PlayerX(A) + 4.5) + ShieldRadius# * (COS(Theta#))
Y = (PlayerY(A) + 4.5) - ShieldRadius# * (SIN(Theta#))
IF X = Xed AND Y = Yed THEN
RemoveShield A
PlayerShield(A) = PlayerShield(A) - 1
IF PlayerShield(A) < 0 THEN PlayerShield(A) = 0: PlayerShieldType(A) = 0: GOTO BPTanken
ShowShield A
BPTanken:
END IF
NEXT Angle
END IF

END IF
NEXT A
END SUB

SUB DoSpecialCollision (Size#)
FOR A = 1 TO Players

IF NOT PlayerTank(A) = -1 THEN

IF NOT PlayerShieldType(A) = 0 AND SelWeapon = 8 THEN
RemoveShield A
PlayerShield(A) = PlayerShield(A) - 1
IF PlayerShield(A) < 0 THEN PlayerShield(A) = 0: PlayerShieldType(A) = 0: GOTO EssoTanken
ShowShield A
EssoTanken:
END IF
END IF

IF Xed > PlayerX(A) - 2 AND Xed < PlayerX(A) + 11 THEN
IF Yed > PlayerY(A) - 2 AND Yed < PlayerY(A) + 11 THEN
DiePlayer A
GOTO Nextored
END IF
END IF

XX1 = PlayerX(A)
YY1 = PlayerY(A)
S1 = 9
XX2 = Xed - INT(Size#) + 1
YY2 = Yed - INT(Size#) + 1
S2 = (INT(Size#) + 1) * 2
IF Collision%(XX1, YY1, S1, XX2, YY2, S2) = True THEN DiePlayer A: GOTO Nextored

'---> ALTERNATE BUT LESS ACCURATE COLLISION METHOD <---
'IF (PlayerX(A) + 4.5) > (Xed - Size#) AND (PlayerX(A) + 4.5) < (Xed + Size#) THEN
'IF (PlayerY(A) + 4.5) > (Yed - Size#) AND (PlayerY(A) + 4.5) < (Yed + Size#) THEN
'DiePlayer A: GOTO Nextored
'END IF
'END IF

Nextored:
NEXT A
END SUB

SUB EatDigger (Xx, Yy, Gt)
FastPSET Xx, Yy, 255

FOR A = 1 TO Gt * 10
FOR Angl = 1 TO 360
Theta# = Angl * (Pi / 180)
X = Xx + A * (COS(Theta#))
Y = Yy - A * (SIN(Theta#))
FastPSET X, Y, 255
FOR B& = 1 TO CompSpeed& / 64: NEXT B&
NEXT Angl
NEXT A

ShowTanks
FallStuff Gt * 10, Xx, Yy
ShowTanks
FallTanks
ShowTanks
END SUB

SUB EndProg
ShutdownDS4QB

SCREEN 0
WIDTH 80, 25
COLOR 7, 0
CLS

Center 6, "Q T A N K S"
Center 8, VersionId$
Center 10, "By Dennis Meuwissen (dennis.meuwissen@wanadoo.nl)"
Center 12, "Visit: http://go.to/qweb"
Center 14, "Thanks for playing!"
Center 16, "Press any key..."

WHILE INKEY$ = "": WEND

END
END SUB

SUB EnterThings
CLS

FOR EnterPlayer = 1 TO Players
ReDo7:
MakeBar 50, 20, 270, 180

CenterFont "Q T A N K S", 25, 4
CenterFont UCASE$(VersionId$), 35, 15
CenterFont "BY DENNIS MEUWISSEN", 45, 15

CenterFont "PLAYER" + STR$(EnterPlayer) + " ENTER YOUR NAME:", 65, 15
CenterFont "(NONE IS RANDOM)", 75, 15
UInput 16, 15, 113, 85, PlayerName$(EnterPlayer), 27

FOR A = 1 TO EnterPlayer - 1
IF PlayerName$(EnterPlayer) = PlayerName$(A) THEN
CenterFont "NAME ALREADY EXISTS!", 105, 15
WHILE INKEY$ = "": WEND
GOTO ReDo7
END IF
NEXT A

IF PlayerName$(EnterPlayer) = "" THEN
PlayerName$(EnterPlayer) = Names$(INT(RND * Names) + 1)
ReDo8:
PlayerName$(EnterPlayer) = Names$(INT(RND * Names) + 1)
FOR A = 1 TO EnterPlayer - 1
IF PlayerName$(EnterPlayer) = PlayerName$(A) THEN GOTO ReDo8
NEXT A
END IF

NEXT EnterPlayer

FOR A = 1 TO Players
PlayerScore&(A) = StartCash&
FOR B = 1 TO Weapons
PlayerWeapons(A, B) = 0
NEXT B
NEXT A
ShowShoppe
PlayingMod = 1

FOR NowGame = 1 TO NumOfGames
CLS
PlayingMod = PlayingMod + 1
IF PlayingMod > Mods THEN PlayingMod = 1
'RemoveMusic 1
'LoadMusic "DATA\MUSIC\MUS" + LTRIM$(RTRIM$(STR$(PlayingMod))) + ".MOD", 1, 1, 1, 0
InitRandomGame
MakeLandScape
StartGame
IF QuitIt = True THEN QuitIt = False: EXIT SUB
IF NowGame < NumOfGames THEN ShowShoppe
NEXT NowGame

WinScreen
END SUB

SUB ExplodeDirt (DirtSize#)
GET (0, 179)-(319, 199), Bar(1)

FastPSET Xed, Yed, 255

PlaySample INT(RND * 4) + 1

FOR A = 1 TO ExpSize * DirtSize#

CIRCLE (Xed, Yed), A, 2
CIRCLE (Xed + 1, Yed), A, 2

FOR B& = 1 TO CompSpeed& * 1: NEXT B&
PUT (0, 179), Bar(1), PSET
NEXT A

ShowTanks
FallStuff ((((ExpSize * DirtSize#) / 10) * 10) + 2), Xed, Yed
FallTanks
ShowTanks
END SUB

SUB ExplodeNuclear (NuclearSize#)
GET (0, 179)-(319, 199), Bar(1)
FastPSET Xed, Yed, 255
PlaySample 4

FOR A = 1 TO ExpSize * NuclearSize#
FadeCols 4
CIRCLE (Xed, Yed), A, 15
CIRCLE (Xed + 1, Yed), A, 15
FOR B& = 1 TO CompSpeed& * 3: NEXT B&
PUT (0, 179), Bar(1), PSET
NEXT A

FOR A = 1 TO ExpSize * NuclearSize#
CIRCLE (Xed, Yed), A, 255
CIRCLE (Xed + 1, Yed), A, 255
PUT (0, 179), Bar(1), PSET
FOR B& = 1 TO CompSpeed& * .5: NEXT B&
NEXT A

PALETTE
PALETTE 255, SkyCol&

ShowTanks
DoSpecialCollision (ExpSize * NuclearSize#)
FallStuff ((((ExpSize * NuclearSize#) / 10) * 10) + 2), Xed, Yed
FallTanks
ShowTanks
END SUB

SUB ExplodeShot
GET (0, 179)-(319, 199), Bar(1)

FastPSET Xed, Yed, 255

PlaySample INT(RND * 4) + 1

FOR A = 1 TO ExpSize
CIRCLE (Xed, Yed), A, 4
CIRCLE (Xed + 1, Yed), A, 4
FOR B& = 1 TO CompSpeed& * 2: NEXT B&
NEXT A

FOR A = 1 TO ExpSize
CIRCLE (Xed, Yed), A, 255
CIRCLE (Xed + 1, Yed), A, 255
NEXT A

PUT (0, 179), Bar(1), PSET
ShowTanks
DoCollision
FallStuff ((ExpSize / 10) * 10), Xed, Yed
FallTanks
ShowTanks
END SUB

SUB ExplodeStrikeShot
GET (0, 179)-(319, 199), Bar(1)

FastPSET Xed, Yed, 255

PlaySample INT(RND * 4) + 1

FOR A = 1 TO (ExpSize / 2)
CIRCLE (Xed, Yed), A, 4
CIRCLE (Xed + 1, Yed), A, 4
FOR B& = 1 TO CompSpeed& / 2: NEXT B&
NEXT A

FOR A = 1 TO (ExpSize / 2)
CIRCLE (Xed, Yed), A, 255
CIRCLE (Xed + 1, Yed), A, 255
NEXT A

PUT (0, 179), Bar(1), PSET
ShowTanks
DoCollision
FallStuff (((ExpSize / 2) / 10) * 10), Xed, Yed
FallTanks
ShowTanks

END SUB

SUB ExplodeTimeB
GET (0, 179)-(319, 199), Bar(1)

PlaySample INT(RND * 4) + 1

FOR A = 1 TO ExpSize
CIRCLE (Xed, Yed), A, 4
CIRCLE (Xed + 1, Yed), A, 4
FOR B& = 1 TO CompSpeed&: NEXT B&
PUT (0, 179), Bar(1), PSET
NEXT A

FOR A = 1 TO ExpSize
CIRCLE (Xed, Yed), A, 255
CIRCLE (Xed + 1, Yed), A, 255
PUT (0, 179), Bar(1), PSET
NEXT A

ShowTanks
DoSpecialCollision ExpSize * 1
FallStuff ExpSize * 1, Xed, Yed
FallTanks
ShowTanks
END SUB

SUB FadeCols (ColsFade)
FOR A = 0 TO 255
OUT &H3C6, &HFF
OUT &H3C7, A
Red = INP(&H3C9)
Green = INP(&H3C9)
Blue = INP(&H3C9)
Red = Red + ColsFade
Green = Green + ColsFade
Blue = Blue + ColsFade
IF Red > 63 THEN Red = 63
IF Green > 63 THEN Green = 63
IF Blue > 63 THEN Blue = 63
IF Red < 0 THEN Red = 0
IF Green < 0 THEN Green = 0
IF Blue < 0 THEN Blue = 0
OUT &H3C6, &HFF
OUT &H3C8, A
OUT &H3C9, Red
OUT &H3C9, Green
OUT &H3C9, Blue
NEXT A
END SUB

SUB FallStuff (ESize#, X1, Y1)
IF DirtFalls = False THEN EXIT SUB

FOR X = X1 - (ESize# + 1) TO X1 + (ESize# + 1)
FOR Y = 0 TO Y1 + (ESize# + 1) STEP -1
IF POINT(X, Y) = 2 THEN Highest = Y: GOTO Ready
NEXT Y
NEXT X
Ready:

Mins = (ESize# + 1)
Maxs = (ESize# + 1)
MaxedY = (ESize# + 1)

DO
Fall = False
FOR Xx = X1 - Mins TO X1 + Maxs
FOR Yy = Y1 + MaxedY TO Highest STEP -1

IF POINT(Xx, Yy) = 255 AND POINT(Xx, Yy - 1) = 2 THEN FastPSET Xx, Yy, 2: FastPSET Xx, Yy - 1, 255: Fall = True: IF Yy > MaxedY THEN MaxedY = MaxedY + 1

IF RealFall = True THEN
IF POINT(Xx - 1, Yy) = 255 AND POINT(Xx, Yy - 1) = 2 THEN FastPSET Xx - 1, Yy, 2: FastPSET Xx, Yy - 1, 255: Fall = True: IF Xx < Xed - Mins THEN Mins = Mins - 1
IF POINT(Xx + 1, Yy) = 255 AND POINT(Xx, Yy - 1) = 2 THEN FastPSET Xx + 1, Yy, 2: FastPSET Xx, Yy - 1, 255: Fall = True: IF Xx > Xed + Maxs THEN Maxs = Maxs + 1
END IF

NEXT Yy
NEXT Xx
LOOP UNTIL Fall = False
END SUB

SUB FallTanks
RemHTurret

FOR A = 1 TO Players
IF NOT PlayerTank(A) = -1 THEN
ReDo1:
Gotten = 0
FOR B = 0 TO 9
IF POINT(PlayerX(A) + B, PlayerY(A) + 10) = 255 THEN Gotten = Gotten + 1
NEXT B
IF Gotten = 10 THEN

PUT (PlayerX(A), PlayerY(A)), Tanks(1, PlayerTank(A), 1), XOR

RemoveShield A

PlayerY(A) = PlayerY(A) + 1
FallenFar = FallenFar + 1

PUT (PlayerX(A), PlayerY(A)), Tanks(1, PlayerTank(A), 2), AND
PUT (PlayerX(A), PlayerY(A)), Tanks(1, PlayerTank(A), 1), XOR

ShowShield A

FOR TT = 0 TO 9
FOR KK = 0 TO 9
IF POINT(PlayerX(A) + TT, PlayerY(A) + KK) = 0 THEN FastPSET PlayerX(A) + TT, PlayerY(A) + KK, 255
NEXT KK
NEXT TT

Xx = PlayerX(A)
Yy = PlayerY(A)
GET (Xx - 2, Yy - 2)-(Xx + 11, Yy + 11), UnderTurr(1)
FOR D& = 1 TO (CompSpeed& / 2): NEXT D&
GOTO ReDo1
END IF
END IF

FallStuff 10, PlayerX(A) + 4, PlayerY(A) + INT(FallenFar / 2)
NEXT A
END SUB

FUNCTION FastPoint% (X, Y)
Offs& = Y * 320& + X

FastPoint% = PEEK(Offs&)
END FUNCTION

SUB FastPSET (X, Y, Col)
IF X > 319 THEN X = 319
IF Y > 199 THEN Y = 199
IF X < 0 THEN X = 0
IF Y < 0 THEN Y = 0

Offs& = Y * 320& + X

POKE Offs&, Col
END SUB

SUB FireUp
PlayerWasWep(PlayerTurn) = SelWeapon
ShootGun
IF Hasent = True THEN EXIT SUB
RemHTurret
END SUB

SUB GetFBMOD (MusicChannel AS INTEGER, TotalLength AS LONG, CurrentOrder AS INTEGER, CurrentRow AS INTEGER)
WaitforDMA0
OPEN "DS4QB2.DAT" FOR OUTPUT AS #1
PRINT #1, MusicChannel
CLOSE #1
OUT &H0, 11
OUT &H0, 11
WaitforDMA0
OPEN "DS4QB2.DAT" FOR BINARY AS #1
GET #1, 1, TotalLength
GET #1, 5, CurrentOrder
GET #1, 7, CurrentRow
CLOSE #1
END SUB

SUB GetFBMP3 (MusicChannel AS INTEGER, TotalLength AS LONG, CurrentPos AS LONG)
WaitforDMA0
OPEN "DS4QB2.DAT" FOR OUTPUT AS #1
PRINT #1, MusicChannel
CLOSE #1
OUT &H0, 12
OUT &H0, 12
WaitforDMA0
OPEN "DS4QB2.DAT" FOR BINARY AS #1
GET #1, 1, TotalLength
GET #1, 5, CurrentPos
CLOSE #1
END SUB

SUB GetStx (StrtX, StrtY)
SELECT CASE PlayerTank(PlayerTurn)
CASE 1, 3
Xx = PlayerX(PlayerTurn) + 5
Yy = PlayerY(PlayerTurn) + 3
CASE 2, 4
Xx = PlayerX(PlayerTurn) + 6
Yy = PlayerY(PlayerTurn) + 3
END SELECT

Theta# = PlayerAngle(PlayerTurn) * (Pi / 180)

StrtX = Xx + 7 * (COS(Theta#))
StrtY = Yy - 7 * (SIN(Theta#))
END SUB

SUB HideMouse
InRegs.AX = 2
InRegs.BX = 0
InRegs.CX = 0
InRegs.DX = 0

CALL INTERRUPT(&H33, InRegs, OutRegs)
END SUB

SUB Init
SCREEN 0
WIDTH 80, 25
COLOR 7, 0
CLS

COLOR 14, 1
PRINT "                                  QTanks                                      "

COLOR 7, 0
PRINT "Check_Version: "; VersionId$
PRINT "Check_Mem:";
PRINT FRE(-1); "bytes free."
PRINT "Init_Mouse: ";
InitMouse
PRINT "Set_Segment: ";
DEF SEG = &HA000
PRINT "At &HA000."
PRINT "Init_Speed:";
SetSpeed
PRINT CompSpeed&; "ticks."
PRINT "Init_DS4QB: ";
'InitDS4QB
PRINT "Done."
PRINT "Load_Defaults: ";
LoadDefs
PRINT "File QTANKS.CFG loaded."
PRINT "Load_Graphics: ";
LoadStuff
PRINT "File GRA.DAT loaded."
PRINT "Load_Font: ";
LoadFont
PRINT "File QTANKS.FNT loaded."
PRINT "Load_Taunts: ";
LoadTaunts
LoadDieTaunts
PRINT "Files loaded."
PRINT "Load_Names: ";
LoadNames
PRINT "File NAMES.TXT loaded."
PRINT "Load_WeaponInfo: ";
LoadWeapons
PRINT "File WEAPONS.TXT loaded."
PRINT "Load_Sounds: ";
'LoadSounds
PRINT "Files loaded."
PRINT "Set_Volume: ";
'SetVolume MusVol, SoundVol, MusVol
PRINT "At"; MusVol; SoundVol; MusVol
PRINT "Press any key to start..."
WHILE INKEY$ = "": WEND
SCREEN 13
END SUB

SUB InitDS4QB
OUT &H0, 0: OUT &H0, 0
SHELL "start /m ds4qb2.exe"
END SUB

SUB InitMouse
IF MouseInstalled% = -1 THEN
PRINT "Mouse detected."
ELSE
PRINT "No mouse detected."
PRINT "This program requires a mouse."
END
END IF
END SUB

SUB InitRandomGame
RANDOMIZE TIMER

Wind = INT(RND * (MaxWind * 2)) - MaxWind
PlysLeft = 8

FOR A = 1 TO 8
PlayerTank(A) = INT(RND * 4) + 1
PlayerPower(A) = 10
PlayerAngle(A) = 0
PlayerWasWep(A) = 0
PlayerShield(A) = 0
PlayerShieldType(A) = 0
NEXT A
END SUB

FUNCTION LeftButton
InRegs.AX = 3
InRegs.BX = 0
InRegs.CX = 0
InRegs.DX = 0

CALL INTERRUPT(&H33, InRegs, OutRegs)

LeftButton = (OutRegs.BX AND 1)
END FUNCTION

SUB LoadDefs
OPEN "DATA\CONFIG\QTANKS.CFG" FOR BINARY AS #1
GET #1, , Gravity!
GET #1, , ChangeWind
GET #1, , MusVol
GET #1, , Steepness
GET #1, , Bumpyness
GET #1, , ExpSize
GET #1, , AmmoSpeed#
GET #1, , AIType
GET #1, , SoundVol
GET #1, , Players
GET #1, , DirtFalls
GET #1, , StartCash&
GET #1, , NumOfGames
CLOSE #1
END SUB

SUB LoadDieTaunts
OPEN "DATA\TXT\DTAUNTS.TXT" FOR INPUT AS #1
WHILE NOT EOF(1)
DieTaunts = DieTaunts + 1
IF DieTaunts = 1024 THEN CLOSE #1: GOTO Done3
LINE INPUT #1, DieTaunt$(DieTaunts)
WEND
CLOSE #1
Done3:
END SUB

SUB LoadFont
Char$ = " "
OPEN "DATA\MISC\QTANKS.FNT" FOR BINARY AS #1
IF LOF(1) = 0 THEN CLOSE #1: EXIT SUB
WHILE NOT EOF(1)
GET #1, , Char$
CharNum = ASC(Char$)
IF CharNum = 0 THEN GOTO Ender
FOR X = 1 TO 5
FOR Y = 1 TO 5
GET #1, , Font1(X, Y, CharNum)
NEXT Y
NEXT X
WEND
Ender:
CLOSE #1
END SUB

SUB LoadGif (A$)
DEFINT A-Z
DIM Prefix(0 TO 4095), Suffix(0 TO 4095), OutStack(0 TO 4095), shiftout%(0 TO 8)
DIM Ybase AS LONG, powersof2(0 TO 11) AS LONG, WorkCode AS LONG

FOR A% = 0 TO 7: shiftout%(8 - A%) = 2 ^ A%: NEXT A%
FOR A% = 0 TO 11: powersof2(A%) = 2 ^ A%: NEXT A%
IF A$ = "" THEN INPUT "GIF file"; A$: IF A$ = "" THEN END
IF INSTR(A$, ".") = 0 THEN A$ = A$ + ".gif"
OPEN A$ FOR BINARY AS #1
A$ = "      ": GET #1, , A$
IF A$ <> "GIF89a" THEN PRINT "Not a GIF89a file.": END
GET #1, , TotalX: GET #1, , TotalY: GOSUB GetByte
NumColors = 2 ^ ((A% AND 7) + 1): NoPalette = (A% AND 128) = 0
GOSUB GetByte: Background = A%
GOSUB GetByte: IF A% <> 0 THEN PRINT "Bad screen descriptor.": END
IF NoPalette = 0 THEN P$ = SPACE$(NumColors * 3): GET #1, , P$
DO
    GOSUB GetByte
    IF A% = 44 THEN
        EXIT DO
    ELSEIF A% <> 33 THEN
        PRINT "Unknown extension type.": END
    END IF
    GOSUB GetByte
    DO: GOSUB GetByte: A$ = SPACE$(A%): GET #1, , A$: LOOP UNTIL A% = 0
LOOP
GET #1, , XStart: GET #1, , YStart: GET #1, , XLength: GET #1, , YLength
XEnd = XStart + XLength: YEnd = YStart + YLength: GOSUB GetByte
IF A% AND 128 THEN PRINT "Can't handle local colormaps.": END
Interlaced = A% AND 64: PassNumber = 0: PassStep = 8
GOSUB GetByte
ClearCode = 2 ^ A%
EOSCode = ClearCode + 1
FirstCode = ClearCode + 2: NextCode = FirstCode
StartCodeSize = A% + 1: CodeSize = StartCodeSize
StartMaxCode = 2 ^ (A% + 1) - 1: MaxCode = StartMaxCode

BitsIn = 0: BlockSize = 0: BlockPointer = 1
X% = XStart: Y% = YStart: Ybase = Y% * 320&

SCREEN 13: DEF SEG = &HA000
IF NoPalette = 0 THEN
    OUT &H3C7, 0: OUT &H3C8, 0
    FOR A% = 1 TO NumColors * 3: OUT &H3C9, ASC(MID$(P$, A%, 1)) \ 4: NEXT A%
END IF
LINE (0, 0)-(319, 199), Background, BF
DO
    GOSUB GetCode
    IF Code <> EOSCode THEN
        IF Code = ClearCode THEN
            NextCode = FirstCode
            CodeSize = StartCodeSize
            MaxCode = StartMaxCode
            GOSUB GetCode
            CurCode = Code: LastCode = Code: LastPixel = Code
            IF X% < 320 THEN POKE X% + Ybase, LastPixel
            X% = X% + 1: IF X% = XEnd THEN GOSUB NextScanLine
        ELSE
            CurCode = Code: StackPointer = 0
            IF Code > NextCode THEN EXIT DO
            IF Code = NextCode THEN
                CurCode = LastCode
                OutStack(StackPointer) = LastPixel
                StackPointer = StackPointer + 1
            END IF

            DO WHILE CurCode >= FirstCode
                OutStack(StackPointer) = Suffix(CurCode)
                StackPointer = StackPointer + 1
                CurCode = Prefix(CurCode)
            LOOP

            LastPixel = CurCode
            IF X% < 320 THEN POKE X% + Ybase, LastPixel
            X% = X% + 1: IF X% = XEnd THEN GOSUB NextScanLine

            FOR A% = StackPointer - 1 TO 0 STEP -1
                IF X% < 320 THEN POKE X% + Ybase, OutStack(A%)
                X% = X% + 1: IF X% = XEnd THEN GOSUB NextScanLine
            NEXT A%

            IF NextCode < 4096 THEN
                Prefix(NextCode) = LastCode
                Suffix(NextCode) = LastPixel
                NextCode = NextCode + 1
                IF NextCode > MaxCode AND CodeSize < 12 THEN
                    CodeSize = CodeSize + 1
                    MaxCode = MaxCode * 2 + 1
                END IF
            END IF
            LastCode = Code
        END IF
    END IF
LOOP UNTIL DoneFlag OR Code = EOSCode
CLOSE #1
EXIT SUB

GetByte: A$ = " ": GET #1, , A$: A% = ASC(A$): RETURN

NextScanLine:
    IF Interlaced THEN
        Y% = Y% + PassStep
        IF Y% >= YEnd THEN
            PassNumber = PassNumber + 1
            SELECT CASE PassNumber
            CASE 1: Y% = 4: PassStep = 8
            CASE 2: Y% = 2: PassStep = 4
            CASE 3: Y% = 1: PassStep = 2
            END SELECT
        END IF
    ELSE
        Y% = Y% + 1
    END IF
    X% = XStart: Ybase = Y% * 320&: DoneFlag = Y% > 199
RETURN
GetCode:
    IF BitsIn = 0 THEN GOSUB ReadBufferedByte: LastChar = A%: BitsIn = 8
    WorkCode = LastChar \ shiftout%(BitsIn)
    DO WHILE CodeSize > BitsIn
        GOSUB ReadBufferedByte: LastChar = A%
        WorkCode = WorkCode OR LastChar * powersof2(BitsIn)
        BitsIn = BitsIn + 8
    LOOP
    BitsIn = BitsIn - CodeSize
    Code = WorkCode AND MaxCode
RETURN
ReadBufferedByte:
    IF BlockPointer > BlockSize THEN
        GOSUB GetByte: BlockSize = A%
        A$ = SPACE$(BlockSize): GET #1, , A$
        BlockPointer = 1
    END IF
    A% = ASC(MID$(A$, BlockPointer, 1)): BlockPointer = BlockPointer + 1
RETURN

END SUB

SUB LoadMusic (MusicName AS STRING, MusicType AS INTEGER, MusicChannel AS INTEGER, Repeat AS INTEGER, Enable3D AS INTEGER)
WaitforDMA0
OPEN "DS4QB2.DAT" FOR OUTPUT AS #1
PRINT #1, MusicName
PRINT #1, MusicType
PRINT #1, MusicChannel
PRINT #1, Repeat
PRINT #1, Enable3D
CLOSE #1
OUT &H0, 1
OUT &H0, 1
WaitforDMA0
END SUB

SUB LoadNames
OPEN "DATA\TXT\NAMES.TXT" FOR INPUT AS #1
WHILE NOT EOF(1)
Names = Names + 1
LINE INPUT #1, Names$(Names)
WEND
CLOSE #1
END SUB

SUB LoadSample
WaitforDMA0
OUT &H0, 3
OUT &H0, 3
WaitforDMA0
END SUB

SUB LoadSounds
OPEN "DS4QB2.DAT" FOR OUTPUT AS #1
PRINT #1, "DATA\SOUNDS\BOOM.WAV"
PRINT #1, "DATA\SOUNDS\BOOM2.WAV"
PRINT #1, "DATA\SOUNDS\BOOM3.WAV"
PRINT #1, "DATA\SOUNDS\BOOM4.WAV"
PRINT #1, "DATA\SOUNDS\ASHIELD.WAV"
PRINT #1, "DATA\SOUNDS\TELEPORT.WAV"
PRINT #1, "DATA\SOUNDS\TICK.WAV"
PRINT #1, "DATA\SOUNDS\FAILB.WAV"
CLOSE #1
LoadSample
END SUB

SUB LoadStuff
OPEN "DATA\MISC\GRA.DAT" FOR BINARY AS #1
FOR A = 1 TO 4

FOR B = 1 TO 52
GET #1, , Tanks(B, A, 1)
NEXT B
FOR B = 1 TO 52
GET #1, , Tanks(B, A, 2)
NEXT B

NEXT A

CLOSE #1
END SUB

SUB LoadTaunts
OPEN "DATA\TXT\TAUNTS.TXT" FOR INPUT AS #1
WHILE NOT EOF(1)
Taunts = Taunts + 1
IF Taunts = 1024 THEN CLOSE #1: GOTO Done2
LINE INPUT #1, Taunt$(Taunts)
WEND
CLOSE #1
Done2:
END SUB

SUB LoadWeapons
OPEN "DATA\TXT\WEAPONS.TXT" FOR INPUT AS #1
WHILE NOT EOF(1)
Weapons = Weapons + 1
INPUT #1, WeaponName$(Weapons)
INPUT #1, WeaponCost&(Weapons)
WEND
CLOSE #1
END SUB

FUNCTION LongBreak% (LongVar AS LONG, IntNum AS INTEGER)
DIM Offset AS INTEGER, Result AS INTEGER
DIM Byte1 AS INTEGER, Byte2 AS INTEGER

DEF SEG = VARSEG(LongVar)
Offset = VARPTR(LongVar)
Byte1 = PEEK(Offset + IntNum * 2)
Byte2 = PEEK(Offset + IntNum * 2 + 1)
DEF SEG = VARSEG(Result)
Offset = VARPTR(Result)
POKE Offset, Byte1
POKE Offset + 1, Byte2
DEF SEG

LongBreak% = Result
END FUNCTION

FUNCTION LongMake& (IntVar1 AS INTEGER, IntVar2 AS INTEGER)
DIM Offset AS INTEGER, Result AS LONG
DIM Byte1 AS INTEGER, Byte2 AS INTEGER, Byte3 AS INTEGER, Byte4 AS INTEGER

DEF SEG = VARSEG(IntVar1)
Offset = VARPTR(IntVar1)
Byte1 = PEEK(Offset)
Byte2 = PEEK(Offset + 1)
DEF SEG = VARSEG(IntVar2)
Offset = VARPTR(IntVar2)
Byte3 = PEEK(Offset)
Byte4 = PEEK(Offset + 1)
DEF SEG = VARSEG(Result)
Offset = VARPTR(Result)
POKE Offset, Byte1
POKE Offset + 1, Byte2
POKE Offset + 2, Byte3
POKE Offset + 3, Byte4
DEF SEG

LongMake& = Result
END FUNCTION

SUB MakeBar (X1, Y1, X2, Y2)
LINE (X1, Y1)-(X2, Y2), 26, B
LINE (X1, Y1)-(X2 - 1, Y2 - 1), 31, B
LINE (X1 + 1, Y1 + 1)-(X2, Y2), 22, B
LINE (X1 + 1, Y1 + 1)-(X2 - 1, Y2 - 1), 27, BF
END SUB

SUB MakeLandScape
PALETTE 255, SkyCol&
LINE (0, 0)-(319, 199), 255, BF

Count = 0
Pls = 0
Ply = 0
LandScape = 0
Duration = 0
Evation = 0
OverSteps = INT(240 / Players)
NowP = 0
InPly = False
RANDOMIZE TIMER
Heigth = INT(RND * 110) + 50

FOR A = 0 TO 319

IF Count = 0 THEN
LandScape = INT(RND * 3) + 1
Duration = INT(RND * Bumpiness) + 10
Evation = INT(RND * Steepness) + 1
END IF

IF InPly = False THEN
Ply = Ply + 1
IF Ply = OverSteps THEN
InPly = True
Count = 0
Ply = 0
LandScape = 3
Duration = 10
Evation = 0
NowP = NowP + 1
PlayerX(NowP) = A
PlayerY(NowP) = Heigth - 10
END IF
END IF

IF LandScape = 1 THEN
Heigth = Heigth + Evation
IF Heigth >= 160 THEN Count = -1
Count = Count + 1
IF Count = Duration THEN Count = 0
END IF

IF LandScape = 2 THEN
Heigth = Heigth - Evation
IF Heigth < 40 THEN Count = -1: LandScape = 1: Evation = INT(RND * 3) + 1
Count = Count + 1
IF Count = Duration THEN Count = 0
END IF

IF LandScape = 3 THEN
Count = Count + 1
IF Count >= Duration THEN Count = 0: InPly = False
END IF

LINE (A, Heigth)-(A, 179), 2
NEXT A

LINE (0, 179)-(319, 199), 255, BF

PlysLeft = Players
END SUB

FUNCTION MiddleButton
InRegs.AX = 3
InRegs.BX = 0
InRegs.CX = 0
InRegs.DX = 0

CALL INTERRUPT(&H33, InRegs, OutRegs)

MiddleButton = (OutRegs.BX AND 4) / 4
END FUNCTION

FUNCTION MouseInstalled%
InRegs.AX = 0
InRegs.BX = 0
InRegs.CX = 0
InRegs.DX = 0

CALL INTERRUPT(&H33, InRegs, OutRegs)
MouseInstalled% = OutRegs.AX
END FUNCTION

FUNCTION MouseX
InRegs.AX = 3
InRegs.BX = 0
InRegs.CX = 0
InRegs.DX = 0

CALL INTERRUPT(&H33, InRegs, OutRegs)

MouseX = OutRegs.CX
END FUNCTION

FUNCTION MouseY
InRegs.AX = 3
InRegs.BX = 0
InRegs.CX = 0
InRegs.DX = 0

CALL INTERRUPT(&H33, InRegs, OutRegs)

MouseY = OutRegs.DX
END FUNCTION

SUB NewTMenu
Choice = 1
ReDo5:
MakeBar 50, 20, 270, 180

IF DirtFalls = True THEN DirtFall$ = "YES" ELSE DirtFall$ = "NO"
CenterFont "Q T A N K S", 25, 4
CenterFont UCASE$(VersionId$), 35, 15
CenterFont "BY DENNIS MEUWISSEN", 45, 15
CenterFont "PLAYERS:" + STR$(Players), 65, 15
CenterFont "DIRT FALLS: " + DirtFall$, 75, 15
CenterFont "INITIAL CASH:" + STR$(StartCash&), 85, 15
CenterFont "GAMES:" + STR$(NumOfGames), 95, 15
CenterFont "BACK TO MAIN MENU", 105, 15
CenterFont "START GAME", 115, 15

GOSUB ShowChoice2

ReDo4:
DO
A$ = UCASE$(INKEY$)
IF A$ = CHR$(0) + "H" AND Choice > 1 THEN GOSUB RemChoice2: Choice = Choice - 1: GOSUB ShowChoice2
IF A$ = CHR$(0) + "P" AND Choice < 6 THEN GOSUB RemChoice2: Choice = Choice + 1: GOSUB ShowChoice2
IF A$ = CHR$(0) + "K" THEN GOSUB MinusThing
IF A$ = CHR$(0) + "M" THEN GOSUB MaxusThing
IF A$ = " " OR A$ = CHR$(13) THEN GOTO DoChoice2
LOOP

ShowChoice2:
IF DirtFalls = True THEN DirtFall$ = "YES" ELSE DirtFall$ = "NO"
IF Choice = 1 THEN CenterFont "PLAYERS:" + STR$(Players), 65, 1
IF Choice = 2 THEN CenterFont "DIRT FALLS: " + DirtFall$, 75, 1
IF Choice = 3 THEN CenterFont "INITIAL CASH:" + STR$(StartCash&), 85, 1
IF Choice = 4 THEN CenterFont "GAMES:" + STR$(NumOfGames), 95, 1
IF Choice = 5 THEN CenterFont "BACK TO MAIN MENU", 105, 1
IF Choice = 6 THEN CenterFont "START GAME", 115, 1
RETURN

RemChoice2:
IF DirtFalls = True THEN DirtFall$ = "YES" ELSE DirtFall$ = "NO"
IF Choice = 1 THEN CenterFont "PLAYERS:" + STR$(Players), 65, 15
IF Choice = 2 THEN CenterFont "DIRT FALLS: " + DirtFall$, 75, 15
IF Choice = 3 THEN CenterFont "INITIAL CASH:" + STR$(StartCash&), 85, 15
IF Choice = 4 THEN CenterFont "GAMES:" + STR$(NumOfGames), 95, 15
IF Choice = 5 THEN CenterFont "BACK TO MAIN MENU", 105, 15
IF Choice = 6 THEN CenterFont "START GAME", 115, 15
RETURN

DoChoice2:
IF Choice = 3 THEN GOSUB EnterCash
IF Choice = 5 THEN SaveDefs: EXIT SUB
IF Choice = 6 THEN EnterThings
GOTO ReDo5

MaxusThing:
IF Choice = 1 AND Players < 8 THEN Players = Players + 1: GOTO ReDo5
IF Choice = 2 AND DirtFalls = False THEN DirtFalls = True: GOTO ReDo5
IF Choice = 3 AND StartCash& < 20000 THEN StartCash& = StartCash& + 250: GOTO ReDo5
IF Choice = 4 AND NumOfGames < 150 THEN NumOfGames = NumOfGames + 1: GOTO ReDo5
GOTO ReDo5

MinusThing:
IF Choice = 1 AND Players > 2 THEN Players = Players - 1: GOTO ReDo5
IF Choice = 2 AND DirtFalls = True THEN DirtFalls = False: GOTO ReDo5
IF Choice = 3 AND StartCash& > 0 THEN StartCash& = StartCash& - 250: GOTO ReDo5
IF Choice = 4 AND NumOfGames > 1 THEN NumOfGames = NumOfGames - 1: GOTO ReDo5
GOTO ReDo5

EnterCash:
LINE (186, 86)-(249, 92), 27, BF
Var$ = ""
UInput 5, 15, 189, 85, Var$, 27
IF VAL(Var$) > 20000 THEN RETURN
StartCash& = VAL(Var$)
RETURN
END SUB

SUB OptionsMenu
MakeBar 0, 0, 319, 199

GOSUB GetStuff

CenterFont "OPTIONS", 10, 4
CenterFont "GRAVITY:" + STR$(CSNG(Gravity!)), 30, 15
CenterFont "LAND STEEPNESS:" + STR$(Steepness), 40, 15
CenterFont "LAND BUMPINESS:" + STR$(Bumpyness), 50, 15
CenterFont "EXPLOSION SIZE:" + STR$(ExpSize), 60, 15
CenterFont "SHOOT SPEED:" + STR$(AmmoSpeed#), 70, 15
CenterFont "WIND CHANGES: " + ChangeWind$, 80, 15
CenterFont "MUSIC VOLUME:" + STR$(MusVol), 90, 15
CenterFont "SOUND VOLUME:" + STR$(SoundVol), 100, 15
CenterFont "COMPUTER AI: " + AIType$, 110, 25
CenterFont "BACK TO MAIN MENU", 120, 15

Choice = 1
GOSUB ShowChoiced

ReDod:
DO
A$ = UCASE$(INKEY$)
IF A$ = CHR$(0) + "H" AND Choice > 1 THEN GOSUB RemChoiced: Choice = Choice - 1: GOSUB ShowChoiced
IF A$ = CHR$(0) + "P" AND Choice < 10 THEN GOSUB RemChoiced: Choice = Choice + 1: GOSUB ShowChoiced
IF A$ = CHR$(0) + "K" THEN GOSUB MinusThingd
IF A$ = CHR$(0) + "M" THEN GOSUB MaxusThingd
IF A$ = " " OR A$ = CHR$(13) THEN GOTO DoChoiced
LOOP

ShowChoiced:
GOSUB GetStuff
IF Choice = 1 THEN CenterFont "GRAVITY:" + STR$(CSNG(Gravity!)), 30, 1
IF Choice = 2 THEN CenterFont "LAND STEEPNESS:" + STR$(Steepness), 40, 1
IF Choice = 3 THEN CenterFont "LAND BUMPINESS:" + STR$(Bumpyness), 50, 1
IF Choice = 4 THEN CenterFont "EXPLOSION SIZE:" + STR$(ExpSize), 60, 1
IF Choice = 5 THEN CenterFont "SHOOT SPEED:" + STR$(AmmoSpeed#), 70, 1
IF Choice = 6 THEN CenterFont "WIND CHANGES: " + ChangeWind$, 80, 1
IF Choice = 7 THEN CenterFont "MUSIC VOLUME:" + STR$(MusVol), 90, 1
IF Choice = 8 THEN CenterFont "SOUND VOLUME:" + STR$(SoundVol), 100, 1
IF Choice = 9 THEN CenterFont "COMPUTER AI: " + AIType$, 110, 25
IF Choice = 10 THEN CenterFont "BACK TO MAIN MENU", 120, 1
RETURN

RemChoiced:
GOSUB GetStuff
IF Choice = 1 THEN CenterFont "GRAVITY:" + STR$(CSNG(Gravity!)), 30, 15
IF Choice = 2 THEN CenterFont "LAND STEEPNESS:" + STR$(Steepness), 40, 15
IF Choice = 3 THEN CenterFont "LAND BUMPINESS:" + STR$(Bumpyness), 50, 15
IF Choice = 4 THEN CenterFont "EXPLOSION SIZE:" + STR$(ExpSize), 60, 15
IF Choice = 5 THEN CenterFont "SHOOT SPEED:" + STR$(AmmoSpeed#), 70, 15
IF Choice = 6 THEN CenterFont "WIND CHANGES: " + ChangeWind$, 80, 15
IF Choice = 7 THEN CenterFont "MUSIC VOLUME:" + STR$(MusVol), 90, 15
IF Choice = 8 THEN CenterFont "SOUND VOLUME:" + STR$(SoundVol), 100, 15
IF Choice = 9 THEN CenterFont "COMPUTER AI: " + AIType$, 110, 26
IF Choice = 10 THEN CenterFont "BACK TO MAIN MENU", 120, 15
RETURN

KillChoiced:
IF Choice = 1 THEN CenterFont "GRAVITY:" + STR$(CSNG(Gravity!)), 30, 27
IF Choice = 2 THEN CenterFont "LAND STEEPNESS:" + STR$(Steepness), 40, 27
IF Choice = 3 THEN CenterFont "LAND BUMPINESS:" + STR$(Bumpyness), 50, 27
IF Choice = 4 THEN CenterFont "EXPLOSION SIZE:" + STR$(ExpSize), 60, 27
IF Choice = 5 THEN CenterFont "SHOOT SPEED:" + STR$(AmmoSpeed#), 70, 27
IF Choice = 6 THEN CenterFont "WIND CHANGES: " + ChangeWind$, 80, 27
IF Choice = 7 THEN CenterFont "MUSIC VOLUME:" + STR$(MusVol), 90, 27
IF Choice = 8 THEN CenterFont "SOUND VOLUME:" + STR$(SoundVol), 100, 27
IF Choice = 9 THEN CenterFont "COMPUTER AI: " + AIType$, 110, 27
IF Choice = 10 THEN CenterFont "BACK TO MAIN MENU", 120, 27
RETURN

DoChoiced:
IF Choice = 10 THEN SaveDefs: SetVolume MusVol, SoundVol, MusVol: EXIT SUB
GOTO ReDod

MaxusThingd:
GOSUB KillChoiced
IF Choice = 1 AND Gravity! < 50 THEN Gravity! = Gravity! + .5: GOTO ReDodo
IF Choice = 2 AND Steepness < 10 THEN Steepness = Steepness + 1: GOTO ReDodo
IF Choice = 3 AND Bumpyness < 100 THEN Bumpyness = Bumpyness + 1: GOTO ReDodo
IF Choice = 4 AND ExpSize < 40 THEN ExpSize = ExpSize + 1: GOTO ReDodo
IF Choice = 5 AND AmmoSpeed# < 15 THEN AmmoSpeed# = AmmoSpeed# + .5: GOTO ReDodo
IF Choice = 6 AND ChangeWind = 1 THEN ChangeWind = 0: GOTO ReDodo
IF Choice = 7 AND MusVol < 100 THEN MusVol = MusVol + 5: GOTO ReDodo
IF Choice = 8 AND SoundVol < 100 THEN SoundVol = SoundVol + 5: GOTO ReDodo
IF Choice = 9 AND AIType < 5 THEN AIType = AIType + 1: GOTO ReDodo
ReDodo:
Gravity! = CSNG(Gravity!)
GOSUB ShowChoiced
GOTO ReDod

MinusThingd:
GOSUB KillChoiced
IF Choice = 1 AND Gravity! > -50 THEN Gravity! = Gravity! - .5: GOTO ReDodo2
IF Choice = 2 AND Steepness > 1 THEN Steepness = Steepness - 1: GOTO ReDodo2
IF Choice = 3 AND Bumpyness > 5 THEN Bumpyness = Bumpyness - 1: GOTO ReDodo2
IF Choice = 4 AND ExpSize > 5 THEN ExpSize = ExpSize - 1: GOTO ReDodo2
IF Choice = 5 AND AmmoSpeed# > 1 THEN AmmoSpeed# = AmmoSpeed# - .5: GOTO ReDodo2
IF Choice = 6 AND ChangeWind = 0 THEN ChangeWind = 1: GOTO ReDodo
IF Choice = 7 AND MusVol > 0 THEN MusVol = MusVol - 5: GOTO ReDodo2
IF Choice = 8 AND SoundVol > 0 THEN SoundVol = SoundVol - 5: GOTO ReDodo2
IF Choice = 9 AND AIType > 0 THEN AIType = AIType - 1: GOTO ReDodo2
ReDodo2:
Gravity! = CSNG(Gravity!)
GOSUB ShowChoiced
GOTO ReDod

GetStuff:
IF ChangeWind = True THEN ChangeWind$ = "YES" ELSE ChangeWind$ = "NO"

AIType$ = "UNAVAILABLE"
'IF AIType = 0 THEN AIType$ = "UNAVAILABLE"
'IF AIType = 1 THEN AIType$ = "FRIGGIN EASY"
'IF AIType = 2 THEN AIType$ = "EASY"
'IF AIType = 3 THEN AIType$ = "MEDIUM"
'IF AIType = 4 THEN AIType$ = "HARD"
'IF AIType = 5 THEN AIType$ = "FRIGGIN HARD"
RETURN
END SUB

SUB PauseMusic (MusicChannel AS INTEGER)
WaitforDMA0
OPEN "DS4QB2.DAT" FOR OUTPUT AS #1
PRINT #1, MusicChannel
CLOSE #1
OUT &H0, 14
OUT &H0, 14
WaitforDMA0
END SUB

SUB PlaySample (SFXT)
OUT &H0, SFXT + 55
OUT &H0, SFXT + 55
END SUB

SUB PrintFont (Txt$, X, Y, Col)
Xx = X
Yy = Y

FOR A = 1 TO LEN(Txt$)

Char$ = MID$(Txt$, A, 1)
CharNum = ASC(Char$)

FOR XX2 = 1 TO 5
FOR YY2 = 1 TO 5
IF Font1(XX2, YY2, CharNum) = 1 THEN FastPSET Xx + XX2, Yy + YY2, Col
NEXT YY2
NEXT XX2

Xx = Xx + 6
NEXT A
END SUB

SUB RandomTeleport (A)
RemTurret A

RemoveShield A

PlaySample 6

FOR B = 1 TO 300
Xx = INT(RND * 10) + PlayerX(A)
Yy = INT(RND * 10) + PlayerY(A)
IF NOT POINT(Xx, Yy) = 255 AND NOT POINT(Xx, Yy) = 2 THEN
FastPSET Xx, Yy, INT(RND * 255) + 1
FOR C& = 1 TO CompSpeed& / 4: NEXT C&
FastPSET Xx, Yy, 0
END IF
NEXT B

LINE (PlayerX(A), PlayerY(A))-(PlayerX(A) + 9, PlayerY(A) + 9), 255, BF

ReRandom:

NewX = INT(RND * 320)
NewY = INT(RND * 179)

IF NewX < 15 THEN GOTO ReRandom
IF NewX > 305 THEN GOTO ReRandom
IF NewY < 15 THEN GOTO ReRandom
IF NewY > 155 THEN GOTO ReRandom

FOR Xx = NewX TO NewX + 9
FOR Yy = NewY TO NewY + 9
IF NOT POINT(Xx, Yy) = 255 THEN GOTO ReRandom
NEXT Yy
NEXT Xx

PlayerX(A) = NewX
PlayerY(A) = NewY

PlaySample 6

PUT (PlayerX(A), PlayerY(A)), Tanks(1, PlayerTank(A), 2), AND
PUT (PlayerX(A), PlayerY(A)), Tanks(1, PlayerTank(A), 1), XOR

FOR B = 1 TO 300
Xx = INT(RND * 10) + PlayerX(A)
Yy = INT(RND * 10) + PlayerY(A)
IF NOT POINT(Xx, Yy) = 255 AND NOT POINT(Xx, Yy) = 2 THEN
FastPSET Xx, Yy, INT(RND * 255) + 1
FOR C& = 1 TO CompSpeed& / 4: NEXT C&
FastPSET Xx, Yy, 0
END IF
NEXT B

PUT (PlayerX(A), PlayerY(A)), Tanks(1, PlayerTank(A), 2), AND
PUT (PlayerX(A), PlayerY(A)), Tanks(1, PlayerTank(A), 1), XOR

FallTanks
END SUB

SUB ReadingStuff
MakeBar 0, 0, 319, 199

CenterFont "Q T A N K S", 10, 4
CenterFont UCASE$(VersionId$), 20, 15
CenterFont "BY DENNIS MEUWISSEN", 30, 15

CenterFont "CREDIT GOES TO THE FOLLOWING PEOPLE:", 60, 15
CenterFont "NETHERGOTH FOR HIS EXCELLENT DS4QB", 80, 15
CenterFont "MICROSOFT FOR THAT CALCULATING ROUTINE IN GORRILAS", 90, 15
CenterFont "THE PEOPLE WHO WROTE THE MODS", 100, 15
CenterFont "SOMEBODY I DONT KNOW ABOUT FOR HIS GIF LOADER", 110, 15
CenterFont "DOOM AND UNREAL TOURNAMENT FOR THOSE SOUNDS", 120, 15

CenterFont "FOUND ANY BUGS? MAIL THEM TO:", 140, 15
CenterFont "DENNIS.MEUWISSEN@WANADOO.NL", 150, 15

CenterFont "I GUESS THAT'S ABOUT IT", 170, 15
CenterFont "SEE YA!", 180, 15

WHILE INKEY$ = "": WEND
END SUB

SUB RemEnd
IF PlayerPower(PlayerTurn) <= 0 THEN EXIT SUB

PrintFont "PLAYER" + STR$(PlayerTurn), 0, 0, 255
PrintFont PlayerName$(PlayerTurn), 0, 10, 255

GetStx StrtX, StrtY

PA# = PlayerAngle(PlayerTurn) / 180 * Pi

StartXvel# = COS(PA#) * PlayerPower(PlayerTurn)
StartYvel# = SIN(PA#) * PlayerPower(PlayerTurn)

Wind = Wind * 5
T# = 0

DO

Xed = StrtX + (StartXvel# * T#) + (.1 * (Wind / 5) * T# ^ 2)
Yed = StrtY + ((-1 * (StartYvel# * T#)) + (.1 * Gravity! * T# ^ 2)) * (200 / 350)

IF PlayerShield(PlayerTurn) > 0 THEN
IF Xed > ((PlayerX(PlayerTurn) + 4.5) - ShieldRadius#) - 1 AND Xed < ((PlayerX(PlayerTurn) + 4.5) + ShieldRadius#) + 1 THEN
IF Yed > ((PlayerY(PlayerTurn) + 4.5) - ShieldRadius#) - 1 AND Yed < ((PlayerY(PlayerTurn) + 4.5) + ShieldRadius#) + 1 THEN
FOR Angle = 0 TO 359 STEP 6
Theta# = Angle * (Pi / 180)
X = (PlayerX(PlayerTurn) + 4.5) + ShieldRadius# * (COS(Theta#))
Y = (PlayerY(PlayerTurn) + 4.5) - ShieldRadius# * (SIN(Theta#))
IF Xed = X AND Yed = Y THEN FastPSET Xed, Yed, 15 + (PlayerShield(PlayerTurn) * 2): Remst = True: GOTO NoCheckHom2
NEXT Angle
END IF
END IF
END IF

IF Yed > 178 THEN GOSUB EndShot2: EXIT DO
IF Xed > 318 THEN GOSUB EndShot2: EXIT DO
IF Xed < 1 THEN GOSUB EndShot2: EXIT DO
IF NOT POINT(Xed, Yed) = 255 THEN GOSUB EndShot2: EXIT DO
NoCheckHom2:

T# = T# + .05

LOOP

Wind = Wind / 5

PrintFont "PLAYER" + STR$(PlayerTurn), 0, 0, 15
PrintFont PlayerName$(PlayerTurn), 0, 10, 15
EXIT SUB

EndShot2:
FastPSET LpX, LpY, UnderSP
RETURN
END SUB

SUB RemHTurret
Theta# = PlayerAngle(PlayerTurn) * (Pi / 180)

IF PlayerTank(PlayerTurn) = 1 THEN
Xx = PlayerX(PlayerTurn) + 5
Yy = PlayerY(PlayerTurn) + 3
END IF
IF PlayerTank(PlayerTurn) = 2 THEN
Xx = PlayerX(PlayerTurn) + 6
Yy = PlayerY(PlayerTurn) + 3
END IF
IF PlayerTank(PlayerTurn) = 3 THEN
Xx = PlayerX(PlayerTurn) + 5
Yy = PlayerY(PlayerTurn) + 3
END IF
IF PlayerTank(PlayerTurn) = 4 THEN
Xx = PlayerX(PlayerTurn) + 6
Yy = PlayerY(PlayerTurn) + 3
END IF

X = Xx + 5 * (COS(Theta#))
Y = Yy - 5 * (SIN(Theta#))
LINE (Xx, Yy)-(X, Y), 255

IF PlayerTank(PlayerTurn) > 0 THEN
PUT (PlayerX(PlayerTurn), PlayerY(PlayerTurn)), Tanks(1, PlayerTank(PlayerTurn), 2), AND
PUT (PlayerX(PlayerTurn), PlayerY(PlayerTurn)), Tanks(1, PlayerTank(PlayerTurn), 1), XOR
END IF
END SUB

SUB RemoveMusic (MusicChannel AS INTEGER)
WaitforDMA0
OPEN "DS4QB2.DAT" FOR OUTPUT AS #1
PRINT #1, MusicChannel
CLOSE #1
OUT &H0, 2
OUT &H0, 2
WaitforDMA0
END SUB

SUB RemoveShield (A)
IF PlayerShield(A) = 0 THEN EXIT SUB

FOR Angle = 0 TO 359 STEP 6
Theta# = Angle * (Pi / 180)
X = (PlayerX(A) + 4.5) + ShieldRadius# * (COS(Theta#))
Y = (PlayerY(A) + 4.5) - ShieldRadius# * (SIN(Theta#))
IF POINT(X, Y) = 15 + (PlayerShield(A) * 2) THEN FastPSET X, Y, 255
NEXT Angle
END SUB

SUB RemPower
LINE (50, 189)-(74, 198), 27, BF
IF HomingThing = True THEN RemEnd
END SUB

SUB RemTank (A)
FOR Xx = 0 TO 9
FOR Yy = 0 TO 9
XP = Xx + PlayerX(A)
YP = Yy + PlayerY(A)
IF NOT POINT(XP, YP) = 255 OR NOT POINT(XP, YP) = 2 THEN FastPSET XP, YP, 255
NEXT Yy
NEXT Xx
END SUB

SUB RemTurret (A)
Xx = PlayerX(A)
Yy = PlayerY(A)
PUT (Xx - 2, Yy - 2), UnderTurr(1), PSET

LINE (4, 189)-(28, 195), 27, BF

IF HomingThing = True THEN RemEnd
END SUB

SUB RespawnPlayer
LINE (0, 179)-(319, 199), 26, B
LINE (0, 179)-(318, 198), 31, B
LINE (1, 180)-(319, 199), 22, B
LINE (1, 180)-(318, 198), 27, BF
CenterFont "SELECT YOUR TARGET", 186, 15

Deimos:

ShowMouse
SetRange 0, 0, 639, 178

DO
Xpos = (MouseX% / 2)
YPos = MouseY%
LOOP UNTIL LeftButton% = True

HideMouse

FOR A = 1 TO Players
IF NOT PlayerTank(A) = -1 AND NOT A = PlayerTurn THEN

IF Xpos >= PlayerX(A) - 1 AND Xpos <= PlayerX(A) + 10 THEN
IF YPos >= PlayerY(A) - 1 AND YPos <= PlayerY(A) + 10 THEN
Target = A
GOTO Phobos
END IF
END IF

END IF
NEXT A

GOTO Deimos

Phobos:
RemTank Target

RemoveShield Target

PlaySample 6

FOR B = 1 TO 300
Xx = INT(RND * 10) + PlayerX(Target)
Yy = INT(RND * 10) + PlayerY(Target)
IF NOT POINT(Xx, Yy) = 255 AND NOT POINT(Xx, Yy) = 2 THEN
FastPSET Xx, Yy, INT(RND * 255) + 1
FOR C& = 1 TO CompSpeed& / 4: NEXT C&
FastPSET Xx, Yy, 0
END IF
NEXT B

LINE (PlayerX(Target), PlayerY(Target))-(PlayerX(Target) + 9, PlayerY(Target) + 9), 255, BF

ReRandomed:

NewX = INT(RND * 320)
NewY = INT(RND * 179)

IF NewX < 15 THEN GOTO ReRandomed
IF NewX > 305 THEN GOTO ReRandomed
IF NewY < 15 THEN GOTO ReRandomed
IF NewY > 155 THEN GOTO ReRandomed

FOR Xx = NewX TO NewX + 9
FOR Yy = NewY TO NewY + 9
IF NOT POINT(Xx, Yy) = 255 THEN GOTO ReRandomed
NEXT Yy
NEXT Xx

PlayerX(Target) = NewX
PlayerY(Target) = NewY

PlaySample 6

PUT (PlayerX(Target), PlayerY(Target)), Tanks(1, PlayerTank(Target), 2), AND
PUT (PlayerX(Target), PlayerY(Target)), Tanks(1, PlayerTank(Target), 1), XOR

FOR B = 1 TO 300
Xx = INT(RND * 10) + PlayerX(Target)
Yy = INT(RND * 10) + PlayerY(Target)
IF NOT POINT(Xx, Yy) = 255 AND NOT POINT(Xx, Yy) = 2 THEN
FastPSET Xx, Yy, INT(RND * 255) + 1
FOR C& = 1 TO CompSpeed& / 4: NEXT C&
FastPSET Xx, Yy, 0
END IF
NEXT B

PUT (PlayerX(Target), PlayerY(Target)), Tanks(1, PlayerTank(Target), 2), AND
PUT (PlayerX(Target), PlayerY(Target)), Tanks(1, PlayerTank(Target), 1), XOR

FallTanks
END SUB

SUB ResumeMusic (MusicChannel AS INTEGER)
WaitforDMA0
OPEN "DS4QB2.DAT" FOR OUTPUT AS #1
PRINT #1, MusicChannel
CLOSE #1
OUT &H0, 15
OUT &H0, 15
WaitforDMA0
END SUB

FUNCTION RightButton
InRegs.AX = 3
InRegs.BX = 0
InRegs.CX = 0
InRegs.DX = 0

CALL INTERRUPT(&H33, InRegs, OutRegs)

RightButton = (OutRegs.BX AND 2) / 2
END FUNCTION

SUB SaveDefs
OPEN "DATA\CONFIG\QTANKS.CFG" FOR BINARY AS #1
PUT #1, , Gravity!
PUT #1, , ChangeWind
PUT #1, , MusVol
PUT #1, , Steepness
PUT #1, , Bumpyness
PUT #1, , ExpSize
PUT #1, , AmmoSpeed#
PUT #1, , AIType
PUT #1, , SoundVol
PUT #1, , Players
PUT #1, , DirtFalls
PUT #1, , StartCash&
PUT #1, , NumOfGames
CLOSE #1
END SUB

SUB SelectedTeleport (A)
RemTurret A

LINE (0, 179)-(319, 199), 26, B
LINE (0, 179)-(318, 198), 31, B
LINE (1, 180)-(319, 199), 22, B
LINE (1, 180)-(318, 198), 27, BF
CenterFont "SELECT YOUR TARGET", 186, 15

SetRange 10, 10, 600, 158

ReDial:
ShowMouse

DO
Xpos = (MouseX% / 2)
YPos = MouseY%
LOOP UNTIL LeftButton% = True

HideMouse

FOR Xx = 0 TO 9
FOR Yy = 0 TO 9
XP = Xx + Xpos
YP = Yy + YPos
IF NOT POINT(XP, YP) = 255 THEN GOTO ReDial
NEXT Yy
NEXT Xx

RemoveShield A

PlaySample 6

FOR B = 1 TO 300
Xx = INT(RND * 10) + PlayerX(A)
Yy = INT(RND * 10) + PlayerY(A)
IF NOT POINT(Xx, Yy) = 255 AND NOT POINT(Xx, Yy) = 2 THEN
FastPSET Xx, Yy, INT(RND * 255) + 1
FOR C& = 1 TO CompSpeed& / 4: NEXT C&
FastPSET Xx, Yy, 0
END IF
NEXT B

RemTank A

PlayerX(A) = Xpos
PlayerY(A) = YPos

PlaySample 6

PUT (PlayerX(A), PlayerY(A)), Tanks(1, PlayerTank(A), 2), AND
PUT (PlayerX(A), PlayerY(A)), Tanks(1, PlayerTank(A), 1), XOR

FOR B = 1 TO 300
Xx = INT(RND * 10) + PlayerX(A)
Yy = INT(RND * 10) + PlayerY(A)
IF NOT POINT(Xx, Yy) = 255 AND NOT POINT(Xx, Yy) = 2 THEN
FastPSET Xx, Yy, INT(RND * 255) + 1
FOR C& = 1 TO CompSpeed& / 4: NEXT C&
FastPSET Xx, Yy, 0
END IF
NEXT B

ShowTanks

FallTanks
END SUB

SUB Set3D (MusicChannel AS INTEGER, PX AS SINGLE, PY AS SINGLE, PZ AS SINGLE, VX AS SINGLE, VY AS SINGLE, VZ AS SINGLE)
WaitforDMA0
OPEN "DS4QB2.DAT" FOR OUTPUT AS #1
PRINT #1, MusicChannel
PRINT #1, PX
PRINT #1, PY
PRINT #1, PZ
PRINT #1, VX
PRINT #1, VY
PRINT #1, VZ
CLOSE #1
OUT &H0, 7
OUT &H0, 7
WaitforDMA0
END SUB

SUB SetChannel (MusicChannel AS INTEGER, Frequency AS LONG, Volume AS INTEGER, Panning AS INTEGER)
WaitforDMA0
OPEN "DS4QB2.DAT" FOR OUTPUT AS #1
PRINT #1, MusicChannel
PRINT #1, Frequency
PRINT #1, Volume
PRINT #1, Panning
CLOSE #1
OUT &H0, 8
OUT &H0, 8
WaitforDMA0
END SUB

SUB SetEAX (EaxCode AS INTEGER)
WaitforDMA0
OPEN "DS4QB2.DAT" FOR OUTPUT AS #1
PRINT #1, EaxCode
CLOSE #1
OUT &H0, 5
OUT &H0, 5
WaitforDMA0
END SUB

SUB SetPos (MusicChannel AS INTEGER, MP3Position AS LONG, MODOrder AS INTEGER, MODRow AS INTEGER)
WaitforDMA0
OPEN "DS4QB2.DAT" FOR BINARY AS #1
PUT #1, 1, MusicChannel
PUT #1, 5, MP3Position
PUT #1, 9, MODOrder
PUT #1, 11, MODRow
CLOSE #1
OUT &H0, 13
OUT &H0, 13
WaitforDMA0
END SUB

SUB SetRange (X1, Y1, X2, Y2)
InRegs.AX = 7
InRegs.BX = 0
InRegs.CX = X1
InRegs.DX = X2

CALL INTERRUPT(&H33, InRegs, OutRegs)

InRegs.AX = 8
InRegs.BX = 0
InRegs.CX = Y1
InRegs.DX = Y2

CALL INTERRUPT(&H33, InRegs, OutRegs)
END SUB

SUB SetSpeed
Times = 3

FOR A = 1 TO Times
Start# = TIMER
Counts& = 0
DO
Counts& = Counts& + 1
LOOP UNTIL TIMER - Start# >= 1
CompSpeed& = CompSpeed& + Counts&
NEXT A

CompSpeed& = INT(CompSpeed& / Times) * 2
END SUB

SUB SetVolume (MODVol, SAMVol, MP3Vol)
WaitforDMA0
OPEN "DS4QB2.DAT" FOR OUTPUT AS #1
PRINT #1, MODVol
PRINT #1, SAMVol
PRINT #1, MP3Vol
CLOSE #1
OUT &H0, 4
OUT &H0, 4
WaitforDMA0
END SUB

SUB ShootAirStrike
LINE (0, 179)-(319, 199), 26, B
LINE (0, 179)-(318, 198), 31, B
LINE (1, 180)-(319, 199), 22, B
LINE (1, 180)-(318, 198), 27, BF
CenterFont "SELECT YOUR TARGET", 186, 15

ShowMouse
SetRange 0, 0, 639, 178

DO
Xpos = (MouseX% / 2)
LOOP UNTIL LeftButton% = True

HideMouse

YPos = 0
Xpos = Xpos - INT(StrikeWidth / 2)
Wind = Wind * 5

FOR A = 1 TO InStrike

PA = 125 / 180 * Pi
MissileXVel#(A) = COS(PA) * 0
MissileYVel#(A) = SIN(PA) * 0
MissileXS(A) = Xpos + (INT(StrikeWidth / InStrike) * A)
MissileYS(A) = YPos
MissileFar#(A) = 0

DO

IF Yed > 0 AND Xed > 0 AND Yed < 179 AND Xed < 319 THEN FastPSET Xed, Yed, 255

Xed = MissileXS(A) + (MissileXVel#(A) * MissileFar#(A)) + (.1 * (Wind * 0) * MissileFar#(A) ^ 2)
Yed = MissileYS(A) + ((-1 * (MissileYVel#(A) * MissileFar#(A))) + (.1 * Gravity! * MissileFar#(A) ^ 2)) * (200 / 350)

IF Xed < 0 AND NOT POINT(Xed, Yed) = 255 THEN ExplodeStrikeShot: EXIT DO
IF Yed > 0 AND NOT POINT(Xed, Yed) = 255 THEN ExplodeStrikeShot: EXIT DO
IF Yed > 0 THEN FastPSET Xed, Yed, 15

MissileFar#(A) = MissileFar#(A) + .05

FOR A& = 1 TO CompSpeed& / (AmmoSpeed# * 10)
NEXT A&

LOOP UNTIL Yed > 178

NEXT A

Wind = Wind / 5
END SUB

SUB ShootCannon (StartX, StartY)
PA# = PlayerAngle(PlayerTurn) / 180 * Pi

StartXvel# = COS(PA#) * PlayerPower(PlayerTurn)
StartYvel# = SIN(PA#) * PlayerPower(PlayerTurn)

Wind = Wind * 5
T# = 0

Xed = StartX + (StartXvel# * T#) + (.1 * (Wind / 5) * T# ^ 2)
Yed = StartY + ((-1 * (StartYvel# * T#)) + (.1 * Gravity! * T# ^ 2)) * (200 / 350)

DO

IF Remst = False THEN
IF Yed > 0 THEN FastPSET Xed, Yed, 255
ELSE
Remst = False
END IF

Xed = StartX + (StartXvel# * T#) + (.1 * (Wind / 5) * T# ^ 2)
Yed = StartY + ((-1 * (StartYvel# * T#)) + (.1 * Gravity! * T# ^ 2)) * (200 / 350)

IF PlayerShield(PlayerTurn) > 0 THEN
IF Xed > ((PlayerX(PlayerTurn) + 4.5) - ShieldRadius#) - 1 AND Xed < ((PlayerX(PlayerTurn) + 4.5) + ShieldRadius#) + 1 THEN
IF Yed > ((PlayerY(PlayerTurn) + 4.5) - ShieldRadius#) - 1 AND Yed < ((PlayerY(PlayerTurn) + 4.5) + ShieldRadius#) + 1 THEN
FOR Angle = 0 TO 359 STEP 6
Theta# = Angle * (Pi / 180)
X = (PlayerX(PlayerTurn) + 4.5) + ShieldRadius# * (COS(Theta#))
Y = (PlayerY(PlayerTurn) + 4.5) - ShieldRadius# * (SIN(Theta#))
IF Xed = X AND Yed = Y THEN FastPSET Xed, Yed, 15 + (PlayerShield(PlayerTurn) * 2): Remst = True: GOTO NoCheck1
NEXT Angle
END IF
END IF
END IF

IF Yed > 178 THEN ExplodeShot: Wind = Wind / 5: EXIT SUB
IF Xed > 318 THEN ExplodeShot: Wind = Wind / 5: EXIT SUB
IF Xed < 1 THEN ExplodeShot: Wind = Wind / 5: EXIT SUB
IF Xed < 0 AND NOT POINT(Xed, Yed) = 255 THEN ExplodeShot: Wind = Wind / 5: EXIT SUB
IF Yed > 0 AND NOT POINT(Xed, Yed) = 255 THEN ExplodeShot: Wind = Wind / 5: EXIT SUB
IF Yed > 0 THEN FastPSET Xed, Yed, 15

NoCheck1:

T# = T# + .05

FOR A& = 1 TO CompSpeed& / AmmoSpeed#
NEXT A&

LOOP

Wind = Wind / 5
END SUB

SUB ShootDigger (Gt)
RemTurret PlayerTurn

LINE (0, 179)-(319, 199), 26, B
LINE (0, 179)-(318, 198), 31, B
LINE (1, 180)-(319, 199), 22, B
LINE (1, 180)-(318, 198), 27, BF
CenterFont "SELECT YOUR TARGET", 186, 15

SetRange 10, 10, 600, 158

ReDialed:
ShowMouse

DO
Xpos = (MouseX% / 2)
YPos = MouseY%
LOOP UNTIL LeftButton% = True

HideMouse

FOR Xx = 0 TO 9
FOR Yy = 0 TO 9
XP = Xx + Xpos
YP = Yy + YPos
IF NOT POINT(XP, YP) = 2 THEN GOTO ReDialed
NEXT Yy
NEXT Xx

EatDigger Xpos, YPos, Gt
END SUB

SUB ShootDirt (StartX, StartY)

PA# = PlayerAngle(PlayerTurn) / 180 * Pi
StartXvel# = COS(PA#) * PlayerPower(PlayerTurn)
StartYvel# = SIN(PA#) * PlayerPower(PlayerTurn)

Wind = Wind * 5
T# = 0

Xed = StartX + (StartXvel# * T#) + (.1 * (Wind / 5) * T# ^ 2)
Yed = StartY + ((-1 * (StartYvel# * T#)) + (.1 * Gravity! * T# ^ 2)) * (200 / 350)

DO

IF Remst = False THEN
IF Yed > 0 THEN FastPSET Xed, Yed, 255
ELSE
Remst = False
END IF

Xed = StartX + (StartXvel# * T#) + (.1 * (Wind / 5) * T# ^ 2)
Yed = StartY + ((-1 * (StartYvel# * T#)) + (.1 * Gravity! * T# ^ 2)) * (200 / 350)

IF PlayerShield(PlayerTurn) > 0 THEN
IF Xed > ((PlayerX(PlayerTurn) + 4.5) - ShieldRadius#) - 1 AND Xed < ((PlayerX(PlayerTurn) + 4.5) + ShieldRadius#) + 1 THEN
IF Yed > ((PlayerY(PlayerTurn) + 4.5) - ShieldRadius#) - 1 AND Yed < ((PlayerY(PlayerTurn) + 4.5) + ShieldRadius#) + 1 THEN
FOR Angle = 0 TO 359 STEP 6
Theta# = Angle * (Pi / 180)
X = (PlayerX(PlayerTurn) + 4.5) + ShieldRadius# * (COS(Theta#))
Y = (PlayerY(PlayerTurn) + 4.5) - ShieldRadius# * (SIN(Theta#))
IF Xed = X AND Yed = Y THEN FastPSET Xed, Yed, 15 + (PlayerShield(PlayerTurn) * 2): Remst = True: GOTO NoCheck2
NEXT Angle
END IF
END IF
END IF

IF Yed > 178 THEN ExplodeDirt (1 + ((SelWeapon - 4) * .5)): Wind = Wind / 5: EXIT SUB
IF Xed > 318 THEN ExplodeDirt (1 + ((SelWeapon - 4) * .5)): Wind = Wind / 5: EXIT SUB
IF Xed < 1 THEN ExplodeDirt (1 + ((SelWeapon - 4) * .5)): Wind = Wind / 5: EXIT SUB
IF Xed < 0 AND NOT POINT(Xed, Yed) = 255 THEN ExplodeDirt (1 + ((SelWeapon - 4) * .5)): Wind = Wind / 5: EXIT SUB
IF Yed > 0 AND NOT POINT(Xed, Yed) = 255 THEN ExplodeDirt (1 + ((SelWeapon - 4) * .5)): Wind = Wind / 5: EXIT SUB
IF Yed > 0 THEN FastPSET Xed, Yed, 15

NoCheck2:

T# = T# + .05

FOR A& = 1 TO CompSpeed& / AmmoSpeed#
NEXT A&

LOOP

Wind = Wind / 5
END SUB

SUB ShootGun
IF HomingThing = True THEN RemEnd

IF SelWeapon > 0 THEN
PlayerWeapons(PlayerTurn, SelWeapon) = PlayerWeapons(PlayerTurn, SelWeapon) - 1
ShowBar
'IF PlayerWeapons(PlayerTurn, SelWeapon) <= 0 THEN SelWeapon = 0
END IF

PrintFont "PLAYER" + STR$(PlayerTurn), 0, 0, 255
PrintFont PlayerName$(PlayerTurn), 0, 10, 255

GetStx StartX, StartY

SELECT CASE SelWeapon

CASE 0
ShootCannon StartX, StartY

CASE 1, 2, 3, 4
PlayerShield(PlayerTurn) = (SelWeapon) + 1
PlayerShieldType(PlayerTurn) = SelWeapon
PlaySample 5
ShowTanks

CASE 5, 6, 7
ShootDirt StartX, StartY

CASE 8, 9
ShootNuclear StartX, StartY

CASE 10
ShootSuicide PlayerX(PlayerTurn) + 4.5, PlayerY(PlayerTurn) + 4.5

CASE 11
ShootAirStrike

CASE 12
RandomTeleport PlayerTurn

CASE 13
SelectedTeleport PlayerTurn

CASE 14
ActiveHomer
CalcEnd
PrintFont "PLAYER" + STR$(PlayerTurn), 0, 0, 15
PrintFont PlayerName$(PlayerTurn), 0, 10, 15

CASE 15
ShootLaser

CASE 16
TimeBomb

CASE 17
RespawnPlayer

CASE 18, 19
IF PlayerAngle(PlayerTurn) = 90 THEN PlayerAngle(PlayerTurn) = 95
ShootDigger SelWeapon - 17

END SELECT
END SUB

SUB ShootLaser
IF PlayerPower(PlayerTurn) = 0 THEN PlayerPower(PlayerTurn) = 1

PA# = PlayerAngle(PlayerTurn) / 180 * Pi

StartXvel# = COS(PA#) * PlayerPower(PlayerTurn)
StartYvel# = SIN(PA#) * PlayerPower(PlayerTurn)

Wind = Wind * 5
T# = 0

Xed = StartX + (StartXvel# * T#) + (.1 * 0 * T# ^ 2)
Yed = StartY + ((-1 * (StartYvel# * T#)) + (.1 * 0 * T# ^ 2)) * (200 / 350)
Xed2 = StartX + (StartXvel# * T#) + (.1 * 0 * T# ^ 2)
Yed2 = StartY + ((-1 * (StartYvel# * T#)) + (.1 * 0 * T# ^ 2)) * (200 / 350)

DO

LINE (Xed, Yed)-(Xed2, Yed2), 255

Xed = StartX + (StartXvel# * T#) + (.1 * 0 * T# ^ 2)
Yed = StartY + ((-1 * (StartYvel# * T#)) + (.1 * 0 * T# ^ 2)) * (200 / 350)

IF T# > 0 - LaserL THEN
Xed2 = StartX + (StartXvel# * (T# - (LaserL * .05))) + (.1 * 0 * T# ^ 2)
Yed2 = StartY + ((-1 * (StartYvel# * (T# - (LaserL * .05)))) + (.1 * 0 * T# ^ 2)) * (200 / 350)
END IF

FOR A = 1 TO Players
IF NOT PlayerTank(A) = -1 AND NOT A = PlayerTurn THEN

IF Xed >= PlayerX(A) - 1 AND Xed <= PlayerX(A) + 10 THEN
IF Yed >= PlayerY(A) - 1 AND Yed <= PlayerY(A) + 10 THEN
ExplodeShot
DiePlayer A
Wind = Wind / 5
ShowTanks
EXIT SUB
END IF
END IF

END IF
NEXT A

IF Yed > 178 THEN ExplodeShot: Wind = Wind / 5: ShowTanks: EXIT SUB
IF Xed > 318 THEN ExplodeShot: Wind = Wind / 5: ShowTanks: EXIT SUB
IF Xed < 1 THEN ExplodeShot: Wind = Wind / 5: ShowTanks: EXIT SUB
IF Yed > 0 THEN LINE (Xed, Yed)-(Xed2, Yed2), 4

NoCheck9:

T# = T# + .05

FOR A& = 1 TO CompSpeed& / AmmoSpeed#
NEXT A&

LOOP

ShowTanks

Wind = Wind / 5
END SUB

SUB ShootNuclear (StartX, StartY)

PA# = PlayerAngle(PlayerTurn) / 180 * Pi
StartXvel# = COS(PA#) * PlayerPower(PlayerTurn)
StartYvel# = SIN(PA#) * PlayerPower(PlayerTurn)

Wind = Wind * 5
T# = 0

Xed = StartX + (StartXvel# * T#) + (.1 * (Wind / 5) * T# ^ 2)
Yed = StartY + ((-1 * (StartYvel# * T#)) + (.1 * Gravity! * T# ^ 2)) * (200 / 350)

DO

IF Remst = False THEN
IF Yed > 0 THEN FastPSET Xed, Yed, 255
ELSE
Remst = False
END IF

Xed = StartX + (StartXvel# * T#) + (.1 * (Wind / 5) * T# ^ 2)
Yed = StartY + ((-1 * (StartYvel# * T#)) + (.1 * Gravity! * T# ^ 2)) * (200 / 350)

IF PlayerShield(PlayerTurn) > 0 THEN
IF Xed > ((PlayerX(PlayerTurn) + 4.5) - ShieldRadius#) - 1 AND Xed < ((PlayerX(PlayerTurn) + 4.5) + ShieldRadius#) + 1 THEN
IF Yed > ((PlayerY(PlayerTurn) + 4.5) - ShieldRadius#) - 1 AND Yed < ((PlayerY(PlayerTurn) + 4.5) + ShieldRadius#) + 1 THEN
FOR Angle = 0 TO 359 STEP 6
Theta# = Angle * (Pi / 180)
X = (PlayerX(PlayerTurn) + 4.5) + ShieldRadius# * (COS(Theta#))
Y = (PlayerY(PlayerTurn) + 4.5) - ShieldRadius# * (SIN(Theta#))
IF Xed = X AND Yed = Y THEN FastPSET Xed, Yed, 15 + (PlayerShield(PlayerTurn) * 2): Remst = True: GOTO NoCheck3
NEXT Angle
END IF
END IF
END IF

IF Yed > 178 THEN ExplodeNuclear (1 + ((SelWeapon - 7) * 1)): Wind = Wind / 5: EXIT SUB
IF Xed > 318 THEN ExplodeNuclear (1 + ((SelWeapon - 7) * 1)): Wind = Wind / 5: EXIT SUB
IF Xed < 1 THEN ExplodeNuclear (1 + ((SelWeapon - 7) * 1)): Wind = Wind / 5: EXIT SUB
IF Xed < 0 AND NOT POINT(Xed, Yed) = 255 THEN ExplodeNuclear (1 + ((SelWeapon - 7) * 1)): Wind = Wind / 5: EXIT SUB
IF Yed > 0 AND NOT POINT(Xed, Yed) = 255 THEN ExplodeNuclear (1 + ((SelWeapon - 7) * 1)): Wind = Wind / 5: EXIT SUB

IF Yed > 0 THEN FastPSET Xed, Yed, 15

NoCheck3:

T# = T# + .05

FOR A& = 1 TO CompSpeed& / AmmoSpeed#
NEXT A&

LOOP

Wind = Wind / 5

END SUB

SUB ShootSuicide (Xx, Yy)
GET (0, 179)-(319, 199), Bar(1)
FastPSET Xx, Yy, 255
PlaySample INT(RND * 2) + 1

FOR A = 1 TO (ExpSize * 2)
CIRCLE (Xx, Yy), A, 4
CIRCLE (Xx + 1, Yy), A, 4
FOR B& = 1 TO CompSpeed& * 2: NEXT B&
PUT (0, 179), Bar(1), PSET
NEXT A

FOR A = 1 TO (ExpSize * 2)
CIRCLE (Xx, Yy), A, 255
CIRCLE (Xx + 1, Yy), A, 255
PUT (0, 179), Bar(1), PSET
NEXT A

Xed = Xx
Yed = Yy

ShowTanks
DoSpecialCollision (((ExpSize * 2) / 10) * 10)
FallStuff ExpSize * 2 + 2, Xx, Yy
FallTanks
ShowTanks
END SUB

SUB ShowBar
LINE (0, 179)-(319, 199), 26, B
LINE (0, 179)-(318, 198), 31, B
LINE (1, 180)-(319, 199), 22, B
LINE (1, 180)-(318, 198), 27, BF

PrintFont "ANGLE:", 4, 182, 15
PrintFont LTRIM$(STR$(PlayerAngle(PlayerTurn))), 4, 189, 15
PrintFont "POWER:", 50, 182, 15
PrintFont LTRIM$(STR$(PlayerPower(PlayerTurn))), 50, 189, 15

IF SelWeapon > 0 THEN
PrintFont "LEFT:", 256, 182, 15
PrintFont STR$(PlayerWeapons(PlayerTurn, SelWeapon)), 250, 189, 15
ELSE
PrintFont "LEFT:", 256, 182, 15
PrintFont "UNLIMITED", 256, 189, 15
END IF

PrintFont "WIND:", 100, 182, 15
PrintFont LTRIM$(STR$(Wind)), 100, 189, 15

PrintFont "PLAYER" + STR$(PlayerTurn), 0, 0, 15
PrintFont PlayerName$(PlayerTurn), 0, 10, 15

IF NOT SelWeapon = 0 THEN
PrintFont "WEAPON:", 140, 182, 15
PrintFont WeaponName$(SelWeapon), 140, 189, 15
ELSE
PrintFont "WEAPON:", 140, 182, 15
PrintFont "STANDARD CANNON", 140, 189, 15
END IF
END SUB

SUB ShowMenu
CLS
PALETTE

RANDOMIZE TIMER

ReDo3:
MakeBar 50, 20, 270, 180

CenterFont "Q T A N K S", 25, 4
CenterFont UCASE$(VersionId$), 35, 15
CenterFont "BY DENNIS MEUWISSEN", 45, 15
CenterFont "NEW TOURNAMENT", 65, 15
CenterFont "OPTIONS", 75, 15
CenterFont "READ THIS!", 85, 15
CenterFont "QUIT", 95, 15

Choice = 1
GOSUB ShowChoice

ReDo2:
DO
A$ = UCASE$(INKEY$)
IF A$ = CHR$(0) + "H" AND Choice > 1 THEN GOSUB RemChoice: Choice = Choice - 1: GOSUB ShowChoice
IF A$ = CHR$(0) + "P" AND Choice < 4 THEN GOSUB RemChoice: Choice = Choice + 1: GOSUB ShowChoice
IF A$ = " " OR A$ = CHR$(13) THEN GOTO DoChoice
LOOP

ShowChoice:
IF Choice = 1 THEN CenterFont "NEW TOURNAMENT", 65, 1
IF Choice = 2 THEN CenterFont "OPTIONS", 75, 1
IF Choice = 3 THEN CenterFont "READ THIS!", 85, 1
IF Choice = 4 THEN CenterFont "QUIT", 95, 1
RETURN

RemChoice:
IF Choice = 1 THEN CenterFont "NEW TOURNAMENT", 65, 15
IF Choice = 2 THEN CenterFont "OPTIONS", 75, 15
IF Choice = 3 THEN CenterFont "READ THIS!", 85, 15
IF Choice = 4 THEN CenterFont "QUIT", 95, 15
RETURN

DoChoice:
IF Choice = 1 THEN NewTMenu: GOTO ReDo3
IF Choice = 2 THEN OptionsMenu: GOTO ReDo3
IF Choice = 3 THEN ReadingStuff: GOTO ReDo3
IF Choice = 4 THEN EXIT SUB
GOTO ReDo2
END SUB

SUB ShowMouse
InRegs.AX = 1
InRegs.BX = 0
InRegs.CX = 0
InRegs.DX = 0

CALL INTERRUPT(&H33, InRegs, OutRegs)
END SUB

SUB ShowPower
PrintFont LTRIM$(STR$(PlayerPower(PlayerTurn))), 50, 189, 15
IF HomingThing = True THEN CalcEnd
END SUB

SUB ShowScores
FOR A = 1 TO Players
FOR B = 1 TO Players

IF ScoreList$(A) = PlayerName$(B) THEN
PlayerScore&(B) = PlayerScore&(B) + (2500 - (A * 305))
HighScore&(A) = PlayerScore&(B)
HighName$(A) = PlayerName$(B)
EXIT FOR
END IF

NEXT B
NEXT A

DO
Sorted = False
FOR A = 2 TO Players
IF HighScore&(A) > HighScore&(A - 1) THEN
SWAP HighScore&(A), HighScore&(A - 1)
SWAP HighName$(A), HighName$(A - 1)
Sorted = True
END IF
NEXT A
LOOP UNTIL Sorted = False

MakeBar 50, 50, 270, 170

CenterFont "SCORE TABLE", 60, 4
CenterFont "AFTER ROUND" + STR$(NowGame), 70, 2

FOR A = 1 TO Players
PrintFont HighName$(A), 60, 70 + (A * 10), 15
PrintFont STR$(HighScore&(A)), 260 - (LEN(STR$(HighScore&(A))) * 6), 70 + (A * 10), 15
NEXT A

WHILE INKEY$ = "": WEND
END SUB

SUB ShowShield (A)
IF PlayerShield(A) = 0 THEN EXIT SUB

FOR Angle = 0 TO 359 STEP 6
Theta# = Angle * (Pi / 180)
X = (PlayerX(A) + 4.5) + ShieldRadius# * (COS(Theta#))
Y = (PlayerY(A) + 4.5) - ShieldRadius# * (SIN(Theta#))
IF POINT(X, Y) = 255 THEN FastPSET X, Y, 15 + (PlayerShield(A) * 2)
NEXT Angle
END SUB

SUB ShowShoppe
FOR A = 1 TO Players

GottenStuff& = 0
StartList = 1
Choice = 1

MakeBar 10, 10, 310, 190

CenterFont "YE OL' WEAPON SHOPPE", 20, 4
CenterFont PlayerName$(A), 30, 2

FOR B = 1 TO 11
PrintFont WeaponName$((StartList + B) - 1), 20, 40 + (B * 10), 15
PrintFont STR$(WeaponCost&((StartList + B) - 1)), 180 - (LEN(STR$(WeaponCost&((StartList + B) - 1))) * 6), 40 + (B * 10), 15
PrintFont STR$(PlayerWeapons(A, (StartList + B) - 1)), 250 - (LEN(STR$(PlayerWeapons(A, (StartList + B) - 1))) * 6), 40 + (B * 10), 15
NEXT B

PrintFont "CASH:" + STR$(PlayerScore&(A)), 20, 170, 15

GOSUB ShowCurrent

DO
A$ = UCASE$(INKEY$)
IF A$ = CHR$(0) + "H" THEN GOSUB GetUpAh
IF A$ = CHR$(0) + "P" THEN GOSUB GetDownAh
IF A$ = CHR$(0) + "K" THEN GOSUB SellItem
IF A$ = CHR$(0) + "M" THEN GOSUB BuyItem
IF A$ = " " OR A$ = CHR$(13) THEN EXIT DO
LOOP

NEXT A

EXIT SUB

ShowCurrent:
PrintFont WeaponName$((StartList + Choice) - 1), 20, 40 + (Choice * 10), 1
PrintFont STR$(WeaponCost&((StartList + Choice) - 1)), 180 - (LEN(STR$(WeaponCost&((StartList + Choice) - 1))) * 6), 40 + (Choice * 10), 1
PrintFont STR$(PlayerWeapons(A, (StartList + Choice) - 1)), 250 - (LEN(STR$(PlayerWeapons(A, (StartList + Choice) - 1))) * 6), 40 + (Choice * 10), 1
RETURN

RemCurrent:
PrintFont WeaponName$((StartList + Choice) - 1), 20, 40 + (Choice * 10), 15
PrintFont STR$(WeaponCost&((StartList + Choice) - 1)), 180 - (LEN(STR$(WeaponCost&((StartList + Choice) - 1))) * 6), 40 + (Choice * 10), 15
PrintFont STR$(PlayerWeapons(A, (StartList + Choice) - 1)), 250 - (LEN(STR$(PlayerWeapons(A, (StartList + Choice) - 1))) * 6), 40 + (Choice * 10), 15
RETURN

DelCurrent:
PrintFont WeaponName$((StartList + Choice) - 1), 20, 40 + (Choice * 10), 27
PrintFont STR$(WeaponCost&((StartList + Choice) - 1)), 180 - (LEN(STR$(WeaponCost&((StartList + Choice) - 1))) * 6), 40 + (Choice * 10), 27
PrintFont STR$(PlayerWeapons(A, (StartList + Choice) - 1)), 250 - (LEN(STR$(PlayerWeapons(A, (StartList + Choice) - 1))) * 6), 40 + (Choice * 10), 27
RETURN

GetUpAh:
GOSUB RemCurrent
Choice = Choice - 1
IF Choice < 1 THEN
Choice = 1
StartList = StartList - 1
IF StartList < 1 THEN StartList = 1 ELSE GOSUB ReBuildList
END IF
GOSUB ShowCurrent
RETURN

GetDownAh:
GOSUB RemCurrent
Choice = Choice + 1
IF Choice > 11 THEN
Choice = 11
StartList = StartList + 1
IF StartList + 11 > Weapons + 1 THEN StartList = (Weapons + 1) - 11 ELSE GOSUB ReBuildList
END IF
GOSUB ShowCurrent
RETURN

ReBuildList:
LINE (20, 50)-(300, 160), 27, BF
FOR B = 1 TO 11
PrintFont WeaponName$((StartList + B) - 1), 20, 40 + (B * 10), 15
PrintFont STR$(WeaponCost&((StartList + B) - 1)), 180 - (LEN(STR$(WeaponCost&((StartList + B) - 1))) * 6), 40 + (B * 10), 15
PrintFont STR$(PlayerWeapons(A, (StartList + B) - 1)), 250 - (LEN(STR$(PlayerWeapons(A, (StartList + B) - 1))) * 6), 40 + (B * 10), 15
NEXT B
RETURN

SellItem:
IF PlayerWeapons(A, (StartList + Choice) - 1) = 0 THEN RETURN
GOSUB DelCurrent
PrintFont "CASH:" + STR$(PlayerScore&(A)), 20, 170, 27
PlayerWeapons(A, (StartList + Choice) - 1) = PlayerWeapons(A, (StartList + Choice) - 1) - 1
PlayerScore&(A) = PlayerScore&(A) + WeaponCost&((StartList + Choice) - 1)
GOSUB ShowCurrent
PrintFont "CASH:" + STR$(PlayerScore&(A)), 20, 170, 15
RETURN

BuyItem:
IF PlayerScore&(A) - WeaponCost&((StartList + Choice) - 1) < 0 THEN RETURN
GOSUB DelCurrent
PrintFont "CASH:" + STR$(PlayerScore&(A)), 20, 170, 27
PlayerWeapons(A, (StartList + Choice) - 1) = PlayerWeapons(A, (StartList + Choice) - 1) + 1
PlayerScore&(A) = PlayerScore&(A) - WeaponCost&((StartList + Choice) - 1)
GOSUB ShowCurrent
PrintFont "CASH:" + STR$(PlayerScore&(A)), 20, 170, 15
RETURN
END SUB

SUB ShowTanks
FOR A = 1 TO Players
IF PlayerTank(A) > 0 THEN
PUT (PlayerX(A), PlayerY(A)), Tanks(1, PlayerTank(A), 2), AND
PUT (PlayerX(A), PlayerY(A)), Tanks(1, PlayerTank(A), 1), XOR
IF PlayerShieldType(A) > 0 THEN ShowShield A
END IF
NEXT A
END SUB

SUB ShowTitle
'LoadMusic "DATA\MUSIC\MUS1.MOD", 1, 1, 1, 0
LoadGif "DATA\PICTURES\TITLE.GIF"
WHILE INKEY$ = "": WEND
END SUB

SUB ShowTurret
Xx = PlayerX(PlayerTurn)
Yy = PlayerY(PlayerTurn)
GET (Xx - 2, Yy - 2)-(Xx + 11, Yy + 11), UnderTurr(1)

Theta# = PlayerAngle(PlayerTurn) * (Pi / 180)

IF PlayerTank(PlayerTurn) = 1 THEN
Xx = PlayerX(PlayerTurn) + 5
Yy = PlayerY(PlayerTurn) + 3
END IF
IF PlayerTank(PlayerTurn) = 2 THEN
Xx = PlayerX(PlayerTurn) + 6
Yy = PlayerY(PlayerTurn) + 3
END IF
IF PlayerTank(PlayerTurn) = 3 THEN
Xx = PlayerX(PlayerTurn) + 5
Yy = PlayerY(PlayerTurn) + 3
END IF
IF PlayerTank(PlayerTurn) = 4 THEN
Xx = PlayerX(PlayerTurn) + 6
Yy = PlayerY(PlayerTurn) + 3
END IF

X = Xx + 5 * (COS(Theta#))
Y = Yy - 5 * (SIN(Theta#))
LINE (Xx, Yy)-(X, Y), 150

PrintFont LTRIM$(STR$(PlayerAngle(PlayerTurn))), 4, 189, 15

IF HomingThing = True THEN CalcEnd
END SUB

SUB ShutdownDS4QB
OUT &H0, 55
END SUB

SUB SpookyUFO
' FUNNY MESSAGE, ISN'T IMPORTANT TO THE GAME...

PrintFont "PLAYER" + STR$(PlayerTurn), 0, 0, 255
PrintFont PlayerName$(PlayerTurn), 0, 10, 255

PrintFont "DOESN'T SUCK -DM", 0, 0, 254

L = 256

DO
FOR A = 0 TO 63
PALETTE 254, 256 ^ 0 * A

FOR B& = 1 TO CompSpeed& / L
IF INKEY$ = " " THEN EXIT DO
NEXT B&

NEXT A
FOR A = 63 TO 0 STEP -1
PALETTE 254, 256 ^ 0 * A

FOR B& = 1 TO CompSpeed& / L
IF INKEY$ = " " THEN EXIT DO
NEXT B&

NEXT A
LOOP

PrintFont "RAMMSTEIN RULEZ!", 0, 0, 255
PALETTE 254, 0

PrintFont "PLAYER" + STR$(PlayerTurn), 0, 0, 15
PrintFont PlayerName$(PlayerTurn), 0, 10, 15
END SUB

SUB StartGame
ShowTanks
PlayerTurn = 0

NextPlayer:
IF Hasent = True THEN Hasent = False: GOTO Looper

HomingThing = False
IF ChangeWind = True THEN Wind = INT(RND * (MaxWind * 2)) - MaxWind
PlayerTurn = PlayerTurn + 1
IF PlayerTurn > Players THEN PlayerTurn = 1
IF PlysLeft <= 1 THEN WinGame: ShowScores: EXIT SUB
IF PlayerTank(PlayerTurn) = -1 THEN GOTO NextPlayer
SelWeapon = PlayerWasWep(PlayerTurn)
ShowBar
ShowTurret

Looper:
DO
CheckKeys

FOR Counter& = 1 TO CompSpeed& * 2
NEXT Counter&

IF Keys(72) = True AND PlayerAngle(PlayerTurn) < 180 THEN RemTurret PlayerTurn: PlayerAngle(PlayerTurn) = PlayerAngle(PlayerTurn) + 5: ShowTurret
IF Keys(80) = True AND PlayerAngle(PlayerTurn) > 0 THEN RemTurret PlayerTurn: PlayerAngle(PlayerTurn) = PlayerAngle(PlayerTurn) - 5: ShowTurret
IF Keys(75) = True AND PlayerPower(PlayerTurn) > 0 THEN RemPower: PlayerPower(PlayerTurn) = PlayerPower(PlayerTurn) - 2: ShowPower
IF Keys(77) = True AND PlayerPower(PlayerTurn) < 250 THEN RemPower: PlayerPower(PlayerTurn) = PlayerPower(PlayerTurn) + 2: ShowPower

A$ = UCASE$(INKEY$)
IF A$ = " " OR A$ = CHR$(13) THEN FireUp: GOTO NextPlayer
IF A$ = CHR$(0) + CHR$(15) THEN SpookyUFO
IF A$ = "Z" THEN GOSUB PrevWeapon
IF A$ = "X" THEN GOSUB NextWeapon
IF A$ = CHR$(27) THEN QuitIt = True: EXIT SUB
LOOP

RemWeapon:
IF NOT SelWeapon = 0 THEN
PrintFont WeaponName$(SelWeapon), 140, 189, 27
ELSE
PrintFont "STANDARD CANNON", 140, 189, 27
END IF
IF SelWeapon > 0 THEN
PrintFont "LEFT:", 256, 182, 27
PrintFont STR$(PlayerWeapons(PlayerTurn, SelWeapon)), 250, 189, 27
ELSE
PrintFont "LEFT:", 256, 182, 27
PrintFont "UNLIMITED", 256, 189, 27
END IF
RETURN

ShowWeapon:
IF NOT SelWeapon = 0 THEN
PrintFont WeaponName$(SelWeapon), 140, 189, 15
ELSE
PrintFont "STANDARD CANNON", 140, 189, 15
END IF
IF SelWeapon > 0 THEN
PrintFont "LEFT:", 256, 182, 15
PrintFont STR$(PlayerWeapons(PlayerTurn, SelWeapon)), 250, 189, 15
ELSE
PrintFont "LEFT:", 256, 182, 15
PrintFont "UNLIMITED", 256, 189, 15
END IF
RETURN

PrevWeapon:
GOSUB RemWeapon
ReMin:
SelWeapon = SelWeapon - 1
IF SelWeapon <= 0 THEN SelWeapon = 0: GOSUB ShowWeapon: RETURN
IF PlayerWeapons(PlayerTurn, SelWeapon) = 0 THEN GOTO ReMin
GOSUB ShowWeapon
RETURN
NextWeapon:
Started = SelWeapon
GOSUB RemWeapon
RePlus:
SelWeapon = SelWeapon + 1
IF SelWeapon > Weapons THEN SelWeapon = Started: GOSUB ShowWeapon: RETURN
IF PlayerWeapons(PlayerTurn, SelWeapon) = 0 THEN GOTO RePlus
GOSUB ShowWeapon
RETURN
END SUB

SUB StopSFX (SFXChannel AS INTEGER)
WaitforDMA0
OPEN "DS4QB2.DAT" FOR OUTPUT AS #1
PRINT #1, SFXChannel
CLOSE #1
OUT &H0, 6
OUT &H0, 6
WaitforDMA0
END SUB

SUB TimeBomb
LINE (0, 179)-(319, 199), 26, B
LINE (0, 179)-(318, 198), 31, B
LINE (1, 180)-(319, 199), 22, B
LINE (1, 180)-(318, 198), 27, BF
CenterFont "SELECT YOUR TARGET", 186, 15

ShowMouse
SetRange 0, 0, 639, 178

DO
Xpos = (MouseX% / 2)
LOOP UNTIL LeftButton% = True

HideMouse

YPos = 0

FOR A = 0 TO 199
FastPSET Xpos, A, 7

FOR B& = 1 TO CompSpeed& / AmmoSpeed#
NEXT B&

IF NOT POINT(Xpos, A + 1) = 255 THEN EXIT FOR

FastPSET Xpos, A, 255
NEXT A

Ba = A

FastPSET Xpos, A, 7

FOR A = 1 TO INT(RND * 7) + 3
Start# = TIMER
DO
LOOP UNTIL TIMER - Start# >= 1.5
PlaySample 7
NEXT A

Got = INT(RND * 7) + 1

SELECT CASE Got
CASE 1, 2, 4, 6, 7
Xed = Xpos
Yed = Ba
ExplodeTimeB
CASE 3, 5
PlaySample 8
FastPSET Xpos, Ba, 255
END SELECT
END SUB

SUB UInput (Length, Col, Xx, Yy, Var$, Back)
PrintFont "_", Xx, Yy, Col

Var$ = ""
Ln = 0

DO
ReDo6:
A$ = UCASE$(INKEY$)
IF NOT A$ = "" THEN
IF A$ = CHR$(8) THEN GOSUB RemChar: GOTO ReDo6
IF A$ = CHR$(13) THEN EXIT SUB
IF LEFT$(A$, 1) = CHR$(0) THEN GOTO ReDo6
IF Ln + 1 > Length THEN GOTO ReDo6
IF ASC(A$) < 1 OR ASC(A$) > 255 THEN GOTO ReDo6
Ln = Ln + 1
Var$ = Var$ + A$
GOSUB ShowText
END IF
LOOP

ShowText:
LINE (Xx, Yy)-(Xx + (LEN(Var$) * 6) + 12, Yy + 5), Back, BF
PrintFont Var$ + "_", Xx, Yy, Col
RETURN

RemChar:
IF Ln < 1 THEN RETURN

FOR A = 1 TO LEN(Var$)
IF MID$(Var$, A, 1) = " " THEN MID$(Var$, A, 1) = CHR$(0)
NEXT A

MID$(Var$, LEN(Var$), 1) = " "
Var$ = RTRIM$(Var$)

FOR A = 1 TO LEN(Var$)
IF MID$(Var$, A, 1) = CHR$(0) THEN MID$(Var$, A, 1) = " "
NEXT A

Ln = Ln - 1

GOSUB ShowText
RETURN
END SUB

SUB WaitforDMA0
DO: LOOP UNTIL INP(&H0) = 0
END SUB

SUB WinGame
LINE (0, 179)-(319, 199), 26, B
LINE (0, 179)-(318, 198), 31, B
LINE (1, 180)-(319, 199), 22, B
LINE (1, 180)-(318, 198), 27, BF

ScoreList$(1) = Winner$

Calced = 159 - (LEN(Winner$ + " IS THE WINNER!") * 6) / 2
PrintFont Winner$ + " IS THE WINNER!", Calced, 186, 15

WHILE INKEY$ = "": WEND
END SUB

SUB WinScreen
MakeBar 25, 75, 295, 115

CenterFont "C O N G R A T U L A T I O N S !", 85, 4
CenterFont HighName$(1) + " IS THE WINNER!", 95, 15

WHILE INKEY$ = "": WEND
END SUB

