DECLARE SUB ModControl ()
DECLARE SUB ModRefresh ()
DECLARE SUB HandleCMDLine ()
DECLARE SUB LevPEditControl ()
DECLARE SUB LevPRefresh ()
DECLARE SUB LInfoRefresh ()
DECLARE SUB LevelRefresh ()
DECLARE SUB LevEditControl ()
DECLARE SUB TilePEditControl ()
DECLARE SUB TilePRefresh ()
DECLARE SUB TileEditControl ()
DECLARE SUB HelpWindow (num%)
DECLARE SUB InfoRefresh ()
DECLARE SUB TilesRefresh ()
DECLARE SUB RefreshWindows (CHC%)
DECLARE SUB DrawWindow (x1%, y1%, x2%, y2%, g%)
DECLARE SUB PutFont (Xa%, Ya%, A$, C%, S%)
DECLARE SUB InitFonts ()
DECLARE SUB InitGFX ()

'Turbo-Limace module editor
DEFINT A-Z

COMMON SHARED Font(), CurrS, CurrSpr, CurrSX, CurrSY, inc1, CurrSC, K$
COMMON SHARED CurrC, CurrL, CurrCX, CurrCY, CurrLv, CurrLX, CurrLY, BgLoop, FgLoop
COMMON SHARED CurrX, CurrY, CurrLay, CurrLev, BgScroll, FgScroll, CurrTitle$

TYPE TileI
   Stand AS INTEGER
   Deadly AS INTEGER
   Misc AS INTEGER
   GFX AS INTEGER
   bumps AS INTEGER
   p1 AS INTEGER
   p2 AS INTEGER
END TYPE

TYPE SStype
   StartX AS INTEGER
   StartY AS INTEGER
   StartDir AS INTEGER
   Time AS INTEGER
   BgScroll AS INTEGER
   FgScroll AS INTEGER
   BgLoop AS INTEGER
   FgLoop AS INTEGER
   Title AS STRING * 25
   ZTitle AS STRING * 25
   Levs AS INTEGER
END TYPE

TYPE ModType
   Title AS STRING * 25
   Desc AS STRING * 40
   Zones AS INTEGER
   Zname AS STRING * 8
   Mname AS STRING * 8
   Lev1music AS INTEGER
   Lev2music AS INTEGER
   Lev3music AS INTEGER
END TYPE

COMMON SHARED Tiles(), CPS(), CS(), TileInfo() AS TileI, Level()
COMMON SHARED LevelSpecs() AS SStype, ModSpecs() AS ModType, CurrZon

DIM SHARED Font(33 TO 122, 1 TO 3, 1 TO 4)
DIM SHARED Tiles(25999), CPS(129), CS(129)
DIM SHARED TileInfo(0 TO 199) AS TileI
DIM SHARED Level(0 TO 199, 0 TO 11, 0 TO 3, 0 TO 2)
DIM SHARED LevelSpecs(2) AS SStype, ModSpecs(20) AS ModType

InitGFX
ModSpecs(0).Zones = 1: CurrZon = 1
CurrS = 1: CurrSpr = 0: CurrSX = 0: CurrSY = 0: CurrSC = 0: inc1 = 0
CurrC = 1: CurrL = 1: CurrCX = 0: CurrCY = 0: CurrLv = 1: CurrLX = 0: CurrLY = 0
CurrX = 0: CurrY = 0: CurrLay = 1: CurrLev = 1: BgScroll = 1: FgScroll = 1
FOR F = 1 TO 3
   LevelSpecs(F - 1).StartX = 0
   LevelSpecs(F - 1).StartY = 0
   LevelSpecs(F - 1).StartDir = 1
   LevelSpecs(F - 1).Time = 300
   LevelSpecs(F - 1).BgScroll = 0
   LevelSpecs(F - 1).FgScroll = 0
   LevelSpecs(F - 1).BgLoop = 0
   LevelSpecs(F - 1).FgLoop = 0
   LevelSpecs(F - 1).Title = ""
   LevelSpecs(F - 1).ZTitle = ""
   LevelSpecs(F - 1).Levs = 3
NEXT F
IF COMMAND$ <> "" THEN HandleCMDLine
InitFonts
RefreshWindows 0
HelpWindow 0
DO: LOOP WHILE INKEY$ = ""
RefreshWindows CurrS
DO
   SELECT CASE CurrS
      CASE 1
         TileEditControl
      CASE 2
         TilePEditControl
      CASE 3
         LevEditControl
      CASE 4
         LevPEditControl
      CASE 5
         ModControl
   END SELECT
   IF K$ = CHR$(0) + "?" THEN
      IF CurrS <> 1 THEN CurrS = 1: RefreshWindows CurrS
   ELSEIF K$ = CHR$(0) + "@" THEN
      IF CurrS <> 2 THEN CurrS = 2: RefreshWindows CurrS
   ELSEIF K$ = CHR$(0) + "A" THEN
      IF CurrS <> 3 THEN CurrS = 3: RefreshWindows CurrS
   ELSEIF K$ = CHR$(0) + "B" THEN
      IF CurrS <> 4 THEN CurrS = 4: RefreshWindows CurrS
   ELSEIF K$ = CHR$(0) + "C" THEN
      IF CurrS <> 5 THEN CurrS = 5: RefreshWindows CurrS
   END IF
LOOP UNTIL K$ = CHR$(0) + CHR$(134)
CLS
SCREEN 0
WIDTH 80
END

LoadError:
IF ERR = 53 THEN
   PRINT : PRINT "An error occured when looking for the file:"
   PRINT file$
   PRINT "Please ensure that the name of each element of the zone you are loading"
   PRINT "are the same, and that you have every file in the directory, and that"
   PRINT "you actually HAVE established all elements for the zone."
   PRINT
ELSE
   PRINT : PRINT : PRINT "An unknown error occured. Error"; ERR
   PRINT "Please report this error to gleb@vanhalen.com with what you did, and"
   PRINT "what the error code was. A zip of the malfunctioning articles would also"
   PRINT "be quite nice."
   PRINT
END IF
END

Phlegm:
SCREEN 0: WIDTH 80
PRINT : PRINT "An unknown error occured. Error"; ERR
PRINT "Please report this error to gleb@vanhalen.com with what you did, and"
PRINT "what the error code was. A zip of the malfunctioning articles would also"
PRINT "be quite nice."
PRINT
END

SUB DrawWindow (x1, y1, x2, y2, g)
l = g * 16 + 5
M = l + 3
h = M + 7
LINE (x1, y1)-(x2, y2), M, BF
LINE (x1, y1)-(x2, y1), h
LINE (x1, y1)-(x1, y2), h
LINE (x2, y1)-(x2, y2), l
LINE (x1, y2)-(x2, y2), l
END SUB

SUB HandleCMDLine
ON ERROR GOTO LoadError
CLS
PRINT : PRINT "Autoload "; COMMAND$
PRINT "Loading "; COMMAND$; ".TIL....";
file$ = COMMAND$ + ".TIL"
DEF SEG = VARSEG(Tiles(0))
BLOAD file$, 0
DEF SEG
PRINT "Done."
PRINT "Loading "; COMMAND$; ".TLD....";
file$ = COMMAND$ + ".TLD"
DEF SEG = VARSEG(TileInfo(0).Stand)
BLOAD file$, 0
DEF SEG
PRINT "Done."
PRINT "Loading "; COMMAND$; ".LEV....";
levfile$ = COMMAND$ + ".LEV"
DEF SEG = VARSEG(Level(0, 0, 0, 0))
BLOAD levfile$, 0
DEF SEG
PRINT "Done."
PRINT "Loading "; COMMAND$; ".LFG....";
file$ = COMMAND$ + ".LFG"
OPEN file$ FOR INPUT AS #1
   INPUT #1, LevelSpecs(0).ZTitle
   INPUT #1, LevelSpecs(0).Levs
   FOR F = 0 TO LevelSpecs(0).Levs - 1
      INPUT #1, LevelSpecs(F).Title
      INPUT #1, LevelSpecs(F).BgLoop
      INPUT #1, LevelSpecs(F).FgLoop
      INPUT #1, LevelSpecs(F).BgScroll
      INPUT #1, LevelSpecs(F).FgScroll
      INPUT #1, LevelSpecs(F).StartX
      INPUT #1, LevelSpecs(F).StartY
      INPUT #1, LevelSpecs(F).StartDir
      INPUT #1, LevelSpecs(F).Time
   NEXT F
CLOSE #1
PRINT "Done."
PRINT "All components successfully loaded."
PRINT "Press any key to continue..."
ON ERROR GOTO Phlegm
DO: LOOP WHILE INKEY$ = ""
END SUB

SUB HelpWindow (num)
DrawWindow 80, 50, 240, 150, 12
PutFont 108, 52, "Turbo-Limace Module Editor", 14, 1
PutFont 108, 56, "--------------------------", 12, 1
PutFont 82, 70, "F1 to bring up help menu", 15, 1
SELECT CASE num
   CASE 0
      PutFont 82, 80, "F5 - Tile Editor", 207, 199
      PutFont 82, 85, "F6 - Tile Property Editor", 207, 199
      PutFont 82, 90, "F7 - Level Editor", 207, 199
      PutFont 82, 95, "F8 - Level Property Editor", 207, 199
      PutFont 82, 100, "F9 - Module Editor", 207, 199
      PutFont 82, 100, "------------------", 4, 0
      PutFont 82, 105, "F12 - Exit", 207, 199
      PutFont 116, 144, "Press Any Key To Begin", 15, 1
   CASE 1
      PutFont 82, 80, "Tile Editor Help", 207, 199
      PutFont 82, 90, "Arrows - Edit tile", 207, 199
      PutFont 82, 95, "+/- - Select color element", 207, 199
      PutFont 82, 100, "PgUP/PgDN - Select color family", 207, 199
      PutFont 82, 105, "space - paint", 207, 199
      PutFont 82, 110, "L/S - Load/Save", 207, 199
      PutFont 82, 115, "X/C/V - Cut/Copy/Paste", 207, 199
      PutFont 82, 120, "F - Fill tile with color", 207, 199
      PutFont 82, 125, "B - Make black pixels black 0", 207, 199
      PutFont 82, 130, "E - Eyedropper", 207, 199
      PutFont 82, 135, "[/] - Select Tile", 207, 199
      PutFont 82, 140, "Q/W - Mirror on X/Y axis", 207, 199
      PutFont 116, 144, "Press Any Key To Close", 15, 1
   CASE 2
      PutFont 82, 80, "Tile Property Editor Help", 207, 199
      PutFont 82, 90, "Up/Down - Select property", 207, 199
      PutFont 82, 95, "Left/Right - Modify property", 207, 199
      PutFont 82, 100, "[/] - Select tile", 207, 199
      PutFont 82, 105, "L/S - Load/Save", 207, 199
      PutFont 116, 144, "Press Any Key To Close", 15, 1
   CASE 3
      PutFont 82, 80, "Level Editor Help", 207, 199
      PutFont 82, 90, "Arrows - Edit Level", 207, 199
      PutFont 82, 95, "space - put tiles", 207, 199
      PutFont 82, 100, "[/] - Select tile", 207, 199
      PutFont 82, 105, "L/S - Load/Save", 207, 199
      PutFont 82, 110, "1-3 - Select Level", 207, 199
      PutFont 82, 115, "+/- - Select layer", 207, 199
      PutFont 82, 120, "Z - set background/foreground loop", 207, 199
      PutFont 82, 125, "B - Set begin location", 207, 199
      PutFont 116, 144, "Press Any Key To Close", 15, 1
   CASE 4
      PutFont 82, 80, "Level Property Editor Help", 207, 199
      PutFont 82, 90, "Up/Down - Select Property", 207, 199
      PutFont 82, 95, "Left/Right/CR - Modify Property", 207, 199
      PutFont 82, 100, "L/S - Load/Save", 207, 199
      PutFont 116, 144, "Press Any Key To Close", 15, 1
   CASE 4
      PutFont 82, 80, "Module Editor Help", 207, 199
      PutFont 82, 90, "Up/Down - Select Property", 207, 199
      PutFont 82, 95, "Left/Right/CR - Modify Property", 207, 199
      PutFont 82, 100, "L/S - Load/Save", 207, 199
      PutFont 116, 144, "Press Any Key To Close", 15, 1
END SELECT
END SUB

SUB InfoRefresh
B$ = "Sprite:" + STR$(CurrSpr)
LINE (238, 9)-(258, 13), 184, BF
PutFont 210, 9, B$, 15, 1
B$ = "X:" + STR$(CurrSX)
LINE (218, 14)-(238, 18), 184, BF
PutFont 210, 14, B$, 15, 1
B$ = "Y:" + STR$(CurrSY)
LINE (218, 19)-(238, 23), 184, BF
PutFont 210, 19, B$, 15, 1
B$ = "Color:" + STR$(CurrSC)
LINE (234, 24)-(254, 28), 184, BF
PutFont 210, 24, B$, 15, 1

END SUB

SUB InitFonts
DEF SEG = VARSEG(Font(33, 1, 1))
BLOAD "font.bsv", 0
DEF SEG
END SUB

SUB InitGFX
SCREEN 13
FOR F = 0 TO 199
   GET (0, 0)-(15, 15), Tiles(F * 130)
NEXT F
GET (0, 0)-(15, 15), CS(0)
GET (0, 0)-(15, 15), CPS(0)
DIM Byte AS STRING * 1
OPEN "limace.pal" FOR BINARY AS #1
   FOR F = 0 TO 255
      OUT &H3C8, F
      FOR g = 1 TO 3
         GET #1, , Byte
         OUT &H3C9, ASC(Byte)
      NEXT g
   NEXT F
CLOSE #1
END SUB

SUB LevEditControl
DO
   K$ = INKEY$
   cc = 16 + (inc1 / 3)
   LINE (127 + (16 * CurrLX), (16 * CurrLY))-(143 + (16 * CurrLX), (16 * CurrLY) + 16), cc, B
   inc1 = inc1 + 1: IF inc1 = 49 THEN inc1 = 0
   WAIT &H3DA, 8: WAIT &H3DA, 8, 8
LOOP WHILE K$ = ""
K$ = UCASE$(K$)
IF K$ = CHR$(0) + ";" THEN
   HelpWindow 3
   DO: LOOP WHILE INKEY$ = ""
   RefreshWindows CurrS
ELSEIF VAL(K$) AND VAL(K$) < 4 THEN
   CurrLev = VAL(K$)
   LevelRefresh
   LInfoRefresh
ELSEIF K$ = "Z" THEN
   IF CurrLay = 0 THEN LevelSpecs(CurrLev - 1).BgLoop = CurrX + CurrLX: LInfoRefresh
   IF CurrLay = 3 THEN LevelSpecs(CurrLev - 1).FgLoop = CurrX + CurrLX: LInfoRefresh
ELSEIF K$ = "B" THEN
   LevelSpecs(CurrLev - 1).StartX = CurrX + CurrLX
   LevelSpecs(CurrLev - 1).StartY = CurrLY
   LInfoRefresh
ELSEIF K$ = " " THEN
   Level(CurrX + CurrLX, CurrLY, CurrLay, CurrLev - 1) = CurrSpr
   LevelRefresh
   LInfoRefresh
ELSEIF K$ = "[" THEN
   CurrSpr = CurrSpr - 1
   IF CurrSpr < 0 THEN CurrSpr = 199
   LInfoRefresh
ELSEIF K$ = "]" THEN
   CurrSpr = CurrSpr + 1
   IF CurrSpr > 199 THEN CurrSpr = 0
   LInfoRefresh
ELSEIF K$ = "-" THEN
   IF CurrLay > 0 THEN CurrLay = CurrLay - 1
   LevelRefresh
   LInfoRefresh
ELSEIF K$ = "=" OR K$ = "+" THEN
   IF CurrLay < 3 THEN CurrLay = CurrLay + 1
   LevelRefresh
   LInfoRefresh
ELSEIF K$ = CHR$(0) + "H" THEN
   IF CurrLY > 0 THEN
      LINE (127 + (16 * CurrLX), (16 * CurrLY))-(143 + (16 * CurrLX), (16 * CurrLY) + 16), 0, B
      CurrLY = CurrLY - 1
      LInfoRefresh
   END IF
ELSEIF K$ = CHR$(0) + "P" THEN
   IF CurrLY < 11 THEN
      LINE (127 + (16 * CurrLX), (16 * CurrLY))-(143 + (16 * CurrLX), (16 * CurrLY) + 16), 0, B
      CurrLY = CurrLY + 1
      LInfoRefresh
   END IF
ELSEIF K$ = CHR$(0) + "K" THEN
   IF CurrLX > 0 THEN
      LINE (127 + (16 * CurrLX), (16 * CurrLY))-(143 + (16 * CurrLX), (16 * CurrLY) + 16), 0, B
      CurrLX = CurrLX - 1
      LInfoRefresh
   ELSE
      IF CurrX > 0 THEN
         CurrX = CurrX - 1
         LevelRefresh
         LInfoRefresh
      END IF
   END IF
ELSEIF K$ = CHR$(0) + "M" THEN
   IF CurrLX < 11 THEN
      LINE (127 + (16 * CurrLX), (16 * CurrLY))-(143 + (16 * CurrLX), (16 * CurrLY) + 16), 0, B
      CurrLX = CurrLX + 1
      LInfoRefresh
   ELSE
      IF CurrX < 184 THEN
         CurrX = CurrX + 1
         LevelRefresh
         LInfoRefresh
      END IF
   END IF
ELSEIF K$ = "S" THEN
   PutFont 2, 180, "Save As:", 15, 1
   SaveStr$ = ""
   DO
      DO: M$ = INKEY$: LOOP WHILE M$ = ""
      LINE (34, 180)-(120, 184), 184, BF
      IF ASC(M$) >= 33 AND ASC(M$) <= 122 AND LEN(SaveStr$) < 8 THEN
         SaveStr$ = SaveStr$ + M$
      ELSEIF M$ = CHR$(8) AND LEN(SaveStr$) > 0 THEN
         SaveStr$ = LEFT$(SaveStr$, LEN(SaveStr$) - 1)
      END IF
      PutFont 38, 180, SaveStr$, 12, 1
   LOOP UNTIL M$ = CHR$(27) OR M$ = CHR$(13)
   IF M$ <> CHR$(27) THEN
      DEF SEG = VARSEG(Level(0, 0, 0, 0))
      SaveStr$ = SaveStr$ + ".lev"
      BSAVE SaveStr$, 0, 57600
      DEF SEG
   END IF
   RefreshWindows CurrS
ELSEIF K$ = "L" THEN
   PutFont 2, 180, "File:", 15, 1
   LoadStr$ = ""
   DO
      DO: M$ = INKEY$: LOOP WHILE M$ = ""
      LINE (26, 180)-(120, 184), 184, BF
      IF ASC(M$) >= 33 AND ASC(M$) <= 122 AND LEN(LoadStr$) < 8 THEN
         LoadStr$ = LoadStr$ + M$
      ELSEIF M$ = CHR$(8) AND LEN(LoadStr$) > 0 THEN
         LoadStr$ = LEFT$(LoadStr$, LEN(LoadStr$) - 1)
      END IF
      PutFont 26, 180, LoadStr$, 12, 1
   LOOP UNTIL M$ = CHR$(27) OR M$ = CHR$(13)
   IF M$ <> CHR$(27) THEN
      DEF SEG = VARSEG(Level(0, 0, 0, 0))
      LoadStr$ = LoadStr$ + ".lev"
      BLOAD LoadStr$, 0
      DEF SEG
   END IF
   RefreshWindows CurrS
END IF
END SUB

SUB LevelRefresh
FOR Y = 0 TO 11
   FOR X = 0 TO 11
      PUT (127 + (16 * X), 16 * Y), Tiles(130 * Level(CurrX + X, Y, CurrLay, CurrLev - 1)), PSET
      LINE (127 + (16 * X), 16 * Y)-(143 + (16 * X), 16 * Y + 16), 0, B
   NEXT X
NEXT Y
END SUB

SUB LevPEditControl
DO: K$ = INKEY$: LOOP WHILE K$ = ""
K$ = UCASE$(K$)
IF K$ = CHR$(0) + ";" THEN
   HelpWindow 4
   DO: LOOP WHILE INKEY$ = ""
   RefreshWindows CurrS
ELSEIF K$ = CHR$(0) + "H" THEN
   CurrC = CurrC - 1: IF CurrC < 1 THEN CurrC = 13
   LevPRefresh
ELSEIF K$ = CHR$(0) + "P" THEN
   CurrC = CurrC + 1: IF CurrC > 13 THEN CurrC = 1
   LevPRefresh
ELSEIF K$ = CHR$(0) + "K" THEN
   SELECT CASE CurrC
      CASE 2
         IF LevelSpecs(0).Levs > 1 THEN LevelSpecs(0).Levs = LevelSpecs(0).Levs - 1
      CASE 3
         IF CurrLev > 1 THEN CurrLev = CurrLev - 1
      CASE 5
         IF LevelSpecs(CurrLev - 1).BgScroll > 1 THEN LevelSpecs(CurrLev - 1).BgScroll = LevelSpecs(CurrLev - 1).BgScroll - 1
      CASE 6
         IF LevelSpecs(CurrLev - 1).FgScroll > 1 THEN LevelSpecs(CurrLev - 1).FgScroll = LevelSpecs(CurrLev - 1).FgScroll - 1
      CASE 7
         IF LevelSpecs(CurrLev - 1).BgLoop > 0 THEN LevelSpecs(CurrLev - 1).BgLoop = LevelSpecs(CurrLev - 1).BgLoop - 1
      CASE 8
         IF LevelSpecs(CurrLev - 1).FgLoop > 0 THEN LevelSpecs(CurrLev - 1).FgLoop = LevelSpecs(CurrLev - 1).FgLoop - 1
      CASE 9
         IF LevelSpecs(CurrLev - 1).StartX > 0 THEN LevelSpecs(CurrLev - 1).StartX = LevelSpecs(CurrLev - 1).StartX - 1
      CASE 10
         IF LevelSpecs(CurrLev - 1).StartY > 0 THEN LevelSpecs(CurrLev - 1).StartY = LevelSpecs(CurrLev - 1).StartY - 1
      CASE 11
         LevelSpecs(CurrLev - 1).StartDir = 0
      CASE 12
         IF LevelSpecs(CurrLev - 1).Time < 3000 THEN LevelSpecs(CurrLev - 1).Time = LevelSpecs(CurrLev - 1).Time - 1
   END SELECT
   LevPRefresh
ELSEIF K$ = CHR$(0) + "M" THEN
   SELECT CASE CurrC
      CASE 2
         IF LevelSpecs(0).Levs < 3 THEN LevelSpecs(0).Levs = LevelSpecs(0).Levs + 1
      CASE 3
         IF CurrLev < 3 THEN CurrLev = CurrLev + 1
      CASE 5
         IF LevelSpecs(CurrLev - 1).BgScroll < 20 THEN LevelSpecs(CurrLev - 1).BgScroll = LevelSpecs(CurrLev - 1).BgScroll + 1
      CASE 6
         IF LevelSpecs(CurrLev - 1).FgScroll < 10 THEN LevelSpecs(CurrLev - 1).FgScroll = LevelSpecs(CurrLev - 1).FgScroll + 1
      CASE 7
         IF LevelSpecs(CurrLev - 1).BgLoop < 199 THEN LevelSpecs(CurrLev - 1).BgLoop = LevelSpecs(CurrLev - 1).BgLoop + 1
      CASE 8
         IF LevelSpecs(CurrLev - 1).FgLoop < 199 THEN LevelSpecs(CurrLev - 1).FgLoop = LevelSpecs(CurrLev - 1).FgLoop + 1
      CASE 9
         IF LevelSpecs(CurrLev - 1).StartX < 199 THEN LevelSpecs(CurrLev - 1).StartX = LevelSpecs(CurrLev - 1).StartX + 1
      CASE 10
         IF LevelSpecs(CurrLev - 1).StartY < 15 THEN LevelSpecs(CurrLev - 1).StartY = LevelSpecs(CurrLev - 1).StartY + 1
      CASE 11
         LevelSpecs(CurrLev - 1).StartDir = 1
      CASE 12
         IF LevelSpecs(CurrLev - 1).Time < 3000 THEN LevelSpecs(CurrLev - 1).Time = LevelSpecs(CurrLev - 1).Time + 1
   END SELECT
   LevPRefresh
ELSEIF K$ = CHR$(13) THEN
   SELECT CASE CurrC
      CASE 1
         Tmpstr$ = ""
         LINE (46, 20)-(210, 24), 184, BF
         DO
            DO: M$ = INKEY$: LOOP WHILE M$ = ""
            LINE (46, 20)-(210, 24), 184, BF
            IF ASC(M$) >= 32 AND ASC(M$) <= 122 AND LEN(Tmpstr$) < 20 THEN
               Tmpstr$ = Tmpstr$ + M$
            ELSEIF M$ = CHR$(8) AND LEN(Tmpstr$) > 0 THEN
               Tmpstr$ = LEFT$(Tmpstr$, LEN(Tmpstr$) - 1)
            END IF
            PutFont 50, 20, Tmpstr$, 12, 1
         LOOP UNTIL M$ = CHR$(27) OR M$ = CHR$(13)
         IF M$ <> CHR$(27) THEN LevelSpecs(0).ZTitle = Tmpstr$
         RefreshWindows CurrS
      CASE 4
         Tmpstr$ = ""
         LINE (50, 35)-(210, 39), 184, BF
         DO
            DO: M$ = INKEY$: LOOP WHILE M$ = ""
            LINE (50, 35)-(210, 39), 184, BF
            IF ASC(M$) >= 32 AND ASC(M$) <= 122 AND LEN(Tmpstr$) < 25 THEN
               Tmpstr$ = Tmpstr$ + M$
            ELSEIF M$ = CHR$(8) AND LEN(Tmpstr$) > 0 THEN
               Tmpstr$ = LEFT$(Tmpstr$, LEN(Tmpstr$) - 1)
            END IF
            PutFont 54, 35, Tmpstr$, 12, 1
         LOOP UNTIL M$ = CHR$(27) OR M$ = CHR$(13)
         IF M$ <> CHR$(27) THEN LevelSpecs(CurrLev - 1).Title = Tmpstr$
         RefreshWindows CurrS
   END SELECT
   LevPRefresh
ELSEIF K$ = "S" THEN
   PutFont 210, 34, "Save As:", 15, 1
   SaveStr$ = ""
   DO
      DO: M$ = INKEY$: LOOP WHILE M$ = ""
      LINE (242, 34)-(289, 38), 184, BF
      IF ASC(M$) >= 33 AND ASC(M$) <= 122 AND LEN(SaveStr$) < 8 THEN
         SaveStr$ = SaveStr$ + M$
      ELSEIF M$ = CHR$(8) AND LEN(SaveStr$) > 0 THEN
         SaveStr$ = LEFT$(SaveStr$, LEN(SaveStr$) - 1)
      END IF
      PutFont 246, 34, SaveStr$, 12, 1
   LOOP UNTIL M$ = CHR$(27) OR M$ = CHR$(13)
   IF M$ <> CHR$(27) THEN
      SaveStr$ = SaveStr$ + ".lfg"
      OPEN SaveStr$ FOR OUTPUT AS #1
         PRINT #1, LevelSpecs(0).ZTitle
         PRINT #1, LevelSpecs(0).Levs
         FOR F = 0 TO LevelSpecs(0).Levs - 1
            PRINT #1, LevelSpecs(F).Title
            PRINT #1, LevelSpecs(F).BgLoop
            PRINT #1, LevelSpecs(F).FgLoop
            PRINT #1, LevelSpecs(F).BgScroll
            PRINT #1, LevelSpecs(F).FgScroll
            PRINT #1, LevelSpecs(F).StartX
            PRINT #1, LevelSpecs(F).StartY
            PRINT #1, LevelSpecs(F).StartDir
            PRINT #1, LevelSpecs(F).Time
         NEXT F
      CLOSE #1
      LINE (242, 34)-(289, 38), 184, BF
   END IF
   RefreshWindows CurrS
ELSEIF K$ = "L" THEN
   PutFont 210, 34, "File:", 15, 1
   LoadStr$ = ""
   DO
      DO: M$ = INKEY$: LOOP WHILE M$ = ""
      LINE (230, 34)-(289, 38), 184, BF
      IF ASC(M$) >= 33 AND ASC(M$) <= 122 AND LEN(LoadStr$) < 8 THEN
         LoadStr$ = LoadStr$ + M$
      ELSEIF M$ = CHR$(8) AND LEN(LoadStr$) > 0 THEN
         LoadStr$ = LEFT$(LoadStr$, LEN(LoadStr$) - 1)
      END IF
      PutFont 234, 34, LoadStr$, 12, 1
   LOOP UNTIL M$ = CHR$(27) OR M$ = CHR$(13)
   IF M$ <> CHR$(27) THEN
      LoadStr$ = LoadStr$ + ".lfg"
      OPEN LoadStr$ FOR INPUT AS #1
         INPUT #1, LevelSpecs(0).ZTitle
         INPUT #1, LevelSpecs(0).Levs
         FOR F = 0 TO LevelSpecs(0).Levs - 1
            INPUT #1, LevelSpecs(F).Title
            INPUT #1, LevelSpecs(F).BgLoop
            INPUT #1, LevelSpecs(F).FgLoop
            INPUT #1, LevelSpecs(F).BgScroll
            INPUT #1, LevelSpecs(F).FgScroll
            INPUT #1, LevelSpecs(F).StartX
            INPUT #1, LevelSpecs(F).StartY
            INPUT #1, LevelSpecs(F).StartDir
            INPUT #1, LevelSpecs(F).Time
         NEXT F
      CLOSE #1
      LINE (230, 34)-(289, 38), 184, BF
   END IF
   RefreshWindows CurrS
END IF
END SUB

SUB LevPRefresh
   PutFont 2, 20, "Zone title:", 181 + (CurrC = 1) * 166, 1
   LINE (46, 20)-(210, 24), 184, BF
   PutFont 50, 20, LevelSpecs(0).ZTitle, 9, 1
  
   PutFont 2, 25, "Levels:", 181 + (CurrC = 2) * 166, 1
   LINE (26, 25)-(210, 29), 184, BF
   PutFont 26, 25, STR$(LevelSpecs(0).Levs), 9, 1

   PutFont 2, 30, "Below properties of level:", 181 + (CurrC = 3) * 166, 1
   LINE (106, 30)-(210, 34), 184, BF
   PutFont 106, 30, STR$(CurrLev), 9, 1
  
   PutFont 2, 35, "Level title:", 181 + (CurrC = 4) * 166, 1
   LINE (50, 35)-(210, 39), 184, BF
   PutFont 54, 35, LevelSpecs(CurrLev - 1).Title, 9, 1
  
   PutFont 2, 40, "Background scrolls 1 /    as fast as level layer", 181 + (CurrC = 5) * 166, 1
   LINE (94, 40)-(102, 49), 184, BF
   PutFont 90, 40, STR$(LevelSpecs(CurrLev - 1).BgScroll), 9, 1
  
   PutFont 2, 45, "Foreground scrolls    times as fast as level layer", 181 + (CurrC = 6) * 166, 1
   LINE (78, 45)-(86, 49), 184, BF
   PutFont 74, 45, STR$(LevelSpecs(CurrLev - 1).FgScroll), 9, 1
 
   PutFont 2, 50, "Background loop:", 181 + (CurrC = 7) * 166, 1
   LINE (66, 50)-(210, 54), 184, BF
   PutFont 66, 50, STR$(LevelSpecs(CurrLev - 1).BgLoop), 9, 1
   
   PutFont 2, 55, "Foreground loop:", 181 + (CurrC = 8) * 166, 1
   LINE (66, 55)-(210, 59), 184, BF
   PutFont 66, 55, STR$(LevelSpecs(CurrLev - 1).FgLoop), 9, 1

   PutFont 2, 60, "Start location X:", 181 + (CurrC = 9) * 166, 1
   LINE (70, 60)-(210, 64), 184, BF
   PutFont 66, 60, STR$(LevelSpecs(CurrLev - 1).StartX), 9, 1

   PutFont 2, 65, "Start location Y:", 181 + (CurrC = 10) * 166, 1
   LINE (70, 65)-(210, 69), 184, BF
   PutFont 70, 65, STR$(LevelSpecs(CurrLev - 1).StartY), 9, 1

   PutFont 2, 70, "Start location Dir:", 181 + (CurrC = 11) * 166, 1
   LINE (78, 70)-(210, 74), 184, BF
   IF LevelSpecs(CurrLev - 1).StartDir = 0 THEN A$ = "left" ELSE A$ = "right"
   PutFont 82, 70, A$, 9, 1

   PutFont 2, 75, "Time per level:", 181 + (CurrC = 12) * 166, 1
   LINE (62, 75)-(210, 79), 184, BF
   PutFont 62, 75, STR$(LevelSpecs(CurrLev - 1).Time), 9, 1
END SUB

SUB LInfoRefresh
PutFont 2, 10, "Screen X:", 15, 1
LINE (38, 10)-(120, 14), 184, BF
PutFont 38, 10, STR$(CurrLX), 15, 1
PutFont 2, 15, "Screen Y:", 15, 1
LINE (38, 15)-(120, 19), 184, BF
PutFont 38, 15, STR$(CurrLY), 15, 1
PutFont 2, 20, "Level X:", 15, 1
LINE (34, 20)-(120, 24), 184, BF
PutFont 38, 20, STR$(CurrX + CurrLX), 15, 1
PutFont 2, 25, "Level Y:", 15, 1
LINE (34, 25)-(120, 29), 184, BF
PutFont 38, 25, STR$(CurrY + CurrLY), 15, 1
PutFont 2, 30, "Layer:", 15, 1
LINE (26, 30)-(120, 34), 184, BF
SELECT CASE CurrLay
   CASE 0
      PutFont 30, 30, "0 (Background layer)", 15, 1
   CASE 1
      PutFont 30, 30, "1 (Level layer)", 15, 1
   CASE 2
      PutFont 30, 30, "2 (Level layer on top)", 15, 1
   CASE 3
      PutFont 30, 30, "3 (Foreground layer)", 15, 1
END SELECT
PutFont 2, 35, "Background loop:", 15, 1
LINE (66, 35)-(120, 39), 184, BF
PutFont 66, 35, STR$(LevelSpecs(CurrLev - 1).BgLoop), 15, 1
PutFont 2, 40, "Foreground loop:", 15, 1
LINE (66, 40)-(120, 44), 184, BF
PutFont 66, 40, STR$(LevelSpecs(CurrLev - 1).FgLoop), 15, 1
PutFont 2, 45, "Current Level:", 15, 1
LINE (58, 45)-(120, 49), 184, BF
PutFont 58, 45, STR$(CurrLev), 15, 1
PutFont 2, 50, "Current Tile:", 15, 1
LINE (54, 50)-(120, 54), 184, BF
PutFont 54, 50, STR$(CurrSpr), 15, 1
PUT (3, 60), Tiles(130 * CurrSpr), PSET
PutFont 2, 80, "Slug Start X:", 15, 1
LINE (54, 80)-(120, 84), 184, BF
PutFont 54, 80, STR$(LevelSpecs(CurrLev - 1).StartX), 15, 1
PutFont 2, 85, "Slug Start Y:", 15, 1
LINE (54, 85)-(120, 89), 184, BF
PutFont 54, 85, STR$(LevelSpecs(CurrLev - 1).StartY), 15, 1
END SUB

SUB ModControl
DO: K$ = INKEY$: LOOP WHILE K$ = ""
K$ = UCASE$(K$)
IF K$ = CHR$(0) + ";" THEN
   HelpWindow 5
   DO: LOOP WHILE INKEY$ = ""
   RefreshWindows CurrS
ELSEIF K$ = CHR$(0) + "H" THEN
   CurrC = CurrC - 1: IF CurrC < 1 THEN CurrC = 9
   ModRefresh
ELSEIF K$ = CHR$(0) + "P" THEN
   CurrC = CurrC + 1: IF CurrC > 9 THEN CurrC = 1
   ModRefresh
ELSEIF K$ = CHR$(0) + "K" THEN
   SELECT CASE CurrC
      CASE 3
         IF ModSpecs(0).Zones > 1 THEN ModSpecs(0).Zones = ModSpecs(0).Zones - 1
      CASE 4
         IF CurrZon > 1 THEN CurrZon = CurrZon - 1
      CASE 7
         IF ModSpecs(CurrZon).Lev1music > 0 THEN ModSpecs(CurrZon).Lev1music = ModSpecs(CurrZon).Lev1music - 1
      CASE 8
         IF ModSpecs(CurrZon).Lev2music > 0 THEN ModSpecs(CurrZon).Lev2music = ModSpecs(CurrZon).Lev2music - 1
      CASE 9
         IF ModSpecs(CurrZon).Lev3music > 0 THEN ModSpecs(CurrZon).Lev3music = ModSpecs(CurrZon).Lev3music - 1
   END SELECT
   ModRefresh
ELSEIF K$ = CHR$(0) + "M" THEN
   SELECT CASE CurrC
      CASE 3
         IF ModSpecs(0).Zones < 20 THEN ModSpecs(0).Zones = ModSpecs(0).Zones + 1
      CASE 4
         IF CurrZon < ModSpecs(0).Zones THEN CurrZon = CurrZon + 1
      CASE 7
         IF ModSpecs(CurrZon).Lev1music < 255 THEN ModSpecs(CurrZon).Lev1music = ModSpecs(CurrZon).Lev1music + 1
      CASE 8
         IF ModSpecs(CurrZon).Lev2music < 255 THEN ModSpecs(CurrZon).Lev2music = ModSpecs(CurrZon).Lev2music + 1
      CASE 9
         IF ModSpecs(CurrZon).Lev3music < 255 THEN ModSpecs(CurrZon).Lev3music = ModSpecs(CurrZon).Lev3music + 1
   END SELECT
   ModRefresh
ELSEIF K$ = CHR$(13) THEN
   SELECT CASE CurrC
      CASE 1
         Tmpstr$ = ""
         LINE (58, 20)-(210, 24), 184, BF
         DO
            DO: M$ = INKEY$: LOOP WHILE M$ = ""
            LINE (58, 20)-(210, 24), 184, BF
            IF ASC(M$) >= 32 AND ASC(M$) <= 122 AND LEN(Tmpstr$) < 20 THEN
               Tmpstr$ = Tmpstr$ + M$
            ELSEIF M$ = CHR$(8) AND LEN(Tmpstr$) > 0 THEN
               Tmpstr$ = LEFT$(Tmpstr$, LEN(Tmpstr$) - 1)
            END IF
            PutFont 58, 20, Tmpstr$, 12, 1
         LOOP UNTIL M$ = CHR$(27) OR M$ = CHR$(13)
         IF M$ <> CHR$(27) THEN ModSpecs(0).Title = Tmpstr$
         RefreshWindows CurrS
      CASE 2
         Tmpstr$ = ""
         LINE (82, 25)-(300, 29), 184, BF
         DO
            DO: M$ = INKEY$: LOOP WHILE M$ = ""
            LINE (82, 25)-(210, 29), 184, BF
            IF ASC(M$) >= 32 AND ASC(M$) <= 122 AND LEN(Tmpstr$) < 40 THEN
               Tmpstr$ = Tmpstr$ + M$
            ELSEIF M$ = CHR$(8) AND LEN(Tmpstr$) > 0 THEN
               Tmpstr$ = LEFT$(Tmpstr$, LEN(Tmpstr$) - 1)
            END IF
            PutFont 82, 25, Tmpstr$, 12, 1
         LOOP UNTIL M$ = CHR$(27) OR M$ = CHR$(13)
         IF M$ <> CHR$(27) THEN ModSpecs(0).Desc = Tmpstr$
         RefreshWindows CurrS
      CASE 5
         Tmpstr$ = ""
         LINE (42, 40)-(210, 44), 184, BF
         DO
            DO: M$ = INKEY$: LOOP WHILE M$ = ""
            LINE (42, 40)-(210, 44), 184, BF
            IF ASC(M$) >= 32 AND ASC(M$) <= 122 AND LEN(Tmpstr$) < 8 THEN
               Tmpstr$ = Tmpstr$ + M$
            ELSEIF M$ = CHR$(8) AND LEN(Tmpstr$) > 0 THEN
               Tmpstr$ = LEFT$(Tmpstr$, LEN(Tmpstr$) - 1)
            END IF
            PutFont 42, 40, Tmpstr$, 12, 1
         LOOP UNTIL M$ = CHR$(27) OR M$ = CHR$(13)
         IF M$ <> CHR$(27) THEN ModSpecs(CurrZon).Zname = Tmpstr$
         RefreshWindows CurrS
      CASE 6
         Tmpstr$ = ""
         LINE (46, 45)-(210, 49), 184, BF
         DO
            DO: M$ = INKEY$: LOOP WHILE M$ = ""
            LINE (46, 45)-(210, 49), 184, BF
            IF ASC(M$) >= 32 AND ASC(M$) <= 122 AND LEN(Tmpstr$) < 8 THEN
               Tmpstr$ = Tmpstr$ + M$
            ELSEIF M$ = CHR$(8) AND LEN(Tmpstr$) > 0 THEN
               Tmpstr$ = LEFT$(Tmpstr$, LEN(Tmpstr$) - 1)
            END IF
            PutFont 46, 45, Tmpstr$, 12, 1
         LOOP UNTIL M$ = CHR$(27) OR M$ = CHR$(13)
         IF M$ <> CHR$(27) THEN ModSpecs(CurrZon).Mname = Tmpstr$
         RefreshWindows CurrS
   END SELECT
   ModRefresh
ELSEIF K$ = "S" THEN
   PutFont 210, 34, "Save As:", 15, 1
   SaveStr$ = ""
   DO
      DO: M$ = INKEY$: LOOP WHILE M$ = ""
      LINE (242, 34)-(289, 38), 184, BF
      IF ASC(M$) >= 33 AND ASC(M$) <= 122 AND LEN(SaveStr$) < 8 THEN
         SaveStr$ = SaveStr$ + M$
      ELSEIF M$ = CHR$(8) AND LEN(SaveStr$) > 0 THEN
         SaveStr$ = LEFT$(SaveStr$, LEN(SaveStr$) - 1)
      END IF
      PutFont 246, 34, SaveStr$, 12, 1
   LOOP UNTIL M$ = CHR$(27) OR M$ = CHR$(13)
   IF M$ <> CHR$(27) THEN
      SaveStr$ = SaveStr$ + ".tlm"
      OPEN SaveStr$ FOR OUTPUT AS #1
         PRINT #1, ModSpecs(0).Title
         PRINT #1, ModSpecs(0).Desc
         PRINT #1, ModSpecs(0).Zones
         FOR F = 1 TO ModSpecs(0).Zones
            PRINT #1, ModSpecs(F).Zname
            PRINT #1, ModSpecs(F).Mname
            PRINT #1, ModSpecs(F).Lev1music
            PRINT #1, ModSpecs(F).Lev2music
            PRINT #1, ModSpecs(F).Lev3music
         NEXT F
      CLOSE #1
      LINE (242, 34)-(289, 38), 184, BF
   END IF
   RefreshWindows CurrS
ELSEIF K$ = "L" THEN
   PutFont 210, 34, "File:", 15, 1
   LoadStr$ = ""
   DO
      DO: M$ = INKEY$: LOOP WHILE M$ = ""
      LINE (230, 34)-(289, 38), 184, BF
      IF ASC(M$) >= 33 AND ASC(M$) <= 122 AND LEN(LoadStr$) < 8 THEN
         LoadStr$ = LoadStr$ + M$
      ELSEIF M$ = CHR$(8) AND LEN(LoadStr$) > 0 THEN
         LoadStr$ = LEFT$(LoadStr$, LEN(LoadStr$) - 1)
      END IF
      PutFont 234, 34, LoadStr$, 12, 1
   LOOP UNTIL M$ = CHR$(27) OR M$ = CHR$(13)
   IF M$ <> CHR$(27) THEN
      LoadStr$ = LoadStr$ + ".tlm"
      OPEN LoadStr$ FOR INPUT AS #1
         INPUT #1, ModSpecs(0).Title
         INPUT #1, ModSpecs(0).Desc
         INPUT #1, ModSpecs(0).Zones
         FOR F = 1 TO ModSpecs(0).Zones
            INPUT #1, ModSpecs(F).Zname
            INPUT #1, ModSpecs(F).Mname
            INPUT #1, ModSpecs(F).Lev1music
            INPUT #1, ModSpecs(F).Lev2music
            INPUT #1, ModSpecs(F).Lev3music
         NEXT F
      CLOSE #1
      LINE (230, 34)-(289, 38), 184, BF
   END IF
   RefreshWindows CurrS
END IF
END SUB

SUB ModRefresh
   PutFont 2, 20, "Module title:", 181 + (CurrC = 1) * 166, 1
   LINE (54, 20)-(210, 24), 184, BF
   PutFont 58, 20, ModSpecs(0).Title, 9, 1

   PutFont 2, 25, "Module Description:", 181 + (CurrC = 2) * 166, 1
   LINE (82, 25)-(210, 29), 184, BF
   PutFont 82, 25, ModSpecs(0).Desc, 9, 1
  
   PutFont 2, 30, "Zones:", 181 + (CurrC = 3) * 166, 1
   LINE (22, 30)-(210, 34), 184, BF
   PutFont 22, 30, STR$(ModSpecs(0).Zones), 9, 1

   PutFont 2, 35, "Below properties of zone:", 181 + (CurrC = 4) * 166, 1
   LINE (102, 35)-(210, 39), 184, BF
   PutFont 102, 35, STR$(CurrZon), 9, 1
 
   PutFont 2, 40, "Zonefile:", 181 + (CurrC = 5) * 166, 1
   LINE (38, 40)-(210, 49), 184, BF
   PutFont 42, 40, ModSpecs(CurrZon).Zname, 9, 1
 
   PutFont 2, 45, "Musicfile:", 181 + (CurrC = 6) * 166, 1
   LINE (42, 45)-(210, 49), 184, BF
   PutFont 46, 45, ModSpecs(CurrZon).Mname, 9, 1

   PutFont 2, 50, "Level 1 song location:", 181 + (CurrC = 7) * 166, 1
   LINE (90, 50)-(210, 54), 184, BF
   A$ = HEX$(ModSpecs(CurrZon).Lev1music)
   IF LEN(A$) < 2 THEN A$ = "0" + A$
   PutFont 94, 50, A$, 9, 1

   PutFont 2, 55, "Level 2 song location:", 181 + (CurrC = 8) * 166, 1
   LINE (90, 55)-(210, 59), 184, BF
   A$ = HEX$(ModSpecs(CurrZon).Lev2music)
   IF LEN(A$) < 2 THEN A$ = "0" + A$
   PutFont 94, 55, A$, 9, 1
  
   PutFont 2, 60, "Level 3 song location:", 181 + (CurrC = 9) * 166, 1
   LINE (90, 60)-(210, 64), 184, BF
   A$ = HEX$(ModSpecs(CurrZon).Lev3music)
   IF LEN(A$) < 2 THEN A$ = "0" + A$
   PutFont 94, 60, A$, 9, 1
  
END SUB

SUB PutFont (Xa, Ya, A$, C, S)
A$ = UCASE$(A$)
IF Xa > 319 OR Ya > 199 THEN EXIT SUB
x2 = 0
FOR F = 1 TO LEN(A$)
   Ab = ASC(MID$(A$, F, 1))
   IF Ab >= 33 AND A <= 122 THEN
      FOR Y = 0 TO 3
         FOR X = 0 TO 2
            IF Font(Ab, X + 1, Y + 1) <> 0 THEN
               IF S THEN LINE (Xa + x2 + X, Ya + Y)-(Xa + x2 + X + 1, Ya + Y + 1), S - 1, BF
               PSET (Xa + x2 + X, Ya + Y), C
            END IF
         NEXT X
      NEXT Y
   END IF
   x2 = x2 + 4
NEXT F
END SUB

SUB RefreshWindows (CHC)
DrawWindow 0, 0, 319, 199, 11
SELECT CASE CHC
   CASE 1
      PutFont 32, 168, "PALETTE", 15, 1
      LINE (31, 174)-(289, 192), 0, BF
      LINE (31, 174)-(31, 192), 181
      LINE (31, 174)-(289, 174), 181
      LINE (31, 192)-(289, 192), 191
      LINE (289, 174)-(289, 192), 191
      A = 0
      FOR Y = 0 TO 3
         FOR X = 0 TO 63
            LINE (32 + (4 * X), 175 + (4 * Y))-(32 + (4 * X) + 3, 175 + (4 * Y) + 3), A, BF
            LINE (32 + (4 * X), 175 + (4 * Y))-(32 + (4 * X) + 4, 175 + (4 * Y) + 4), 0, B
            A = A + 1
         NEXT X
      NEXT Y
     
      PutFont 2, 2, "Tile Edit", 15, 1
      LINE (5, 9)-(135, 139), 0, BF
      LINE (5, 9)-(5, 139), 181
      LINE (5, 9)-(135, 9), 181
      LINE (5, 139)-(135, 139), 191
      LINE (135, 9)-(135, 139), 191
     
      PutFont 140, 2, "Actual", 15, 1
      LINE (140, 9)-(157, 26), 0, BF
      LINE (140, 9)-(140, 26), 181
      LINE (140, 9)-(157, 9), 181
      LINE (140, 26)-(157, 26), 191
      LINE (157, 9)-(157, 26), 191
     
      PutFont 140, 32, "Tiled", 15, 1
      LINE (140, 38)-(206, 104), 0, BF
      LINE (140, 38)-(140, 104), 181
      LINE (140, 38)-(206, 38), 181
      LINE (140, 104)-(206, 104), 191
      LINE (206, 38)-(206, 104), 191
    
      TilesRefresh
      InfoRefresh
   CASE 2
      PutFont 2, 2, "Tile Properties Edit", 15, 1
      TilePRefresh
   CASE 3
      PutFont 2, 2, "Level Edit", 15, 1
      LINE (127, 0)-(319, 199), 0, BF
      LINE (126, 0)-(126, 199), 181
     
      LINE (2, 59)-(19, 76), 0, BF
      LINE (2, 59)-(2, 76), 181
      LINE (2, 59)-(19, 59), 181
      LINE (2, 76)-(19, 76), 191
      LINE (19, 59)-(19, 76), 191

      LevelRefresh
      LInfoRefresh
   CASE 4
      PutFont 2, 2, "Level Properties Edit", 15, 1
      LevPRefresh
   CASE 5
      PutFont 2, 2, "Module Editor", 15, 1
      ModRefresh
END SELECT
END SUB

SUB TileEditControl
DO
   K$ = INKEY$
   cc = 16 + (inc1 / 3)
   LINE (6 + (8 * CurrSX), 10 + (8 * CurrSY))-(6 + (8 * CurrSX) + 8, 10 + (8 * CurrSY) + 8), cc, B
   LINE (32 + (4 * (CurrSC MOD 64)), 175 + (4 * (CurrSC \ 64)))-(32 + (4 * (CurrSC MOD 64)) + 4, 175 + (4 * (CurrSC \ 64)) + 4), cc, B
   inc1 = inc1 + 1: IF inc1 = 49 THEN inc1 = 0
   WAIT &H3DA, 8: WAIT &H3DA, 8, 8
LOOP WHILE K$ = ""
K$ = UCASE$(K$)
IF K$ = "R" THEN RefreshWindows CurrS
IF K$ = CHR$(0) + "H" THEN
   LINE (6 + (8 * CurrSX), 10 + (8 * CurrSY))-(6 + (8 * CurrSX) + 8, 10 + (8 * CurrSY) + 8), 0, B
   IF CurrSY > 0 THEN CurrSY = CurrSY - 1
   InfoRefresh
ELSEIF K$ = CHR$(0) + "P" THEN
   LINE (6 + (8 * CurrSX), 10 + (8 * CurrSY))-(6 + (8 * CurrSX) + 8, 10 + (8 * CurrSY) + 8), 0, B
   IF CurrSY < 15 THEN CurrSY = CurrSY + 1
   InfoRefresh
ELSEIF K$ = CHR$(0) + "K" THEN
   LINE (6 + (8 * CurrSX), 10 + (8 * CurrSY))-(6 + (8 * CurrSX) + 8, 10 + (8 * CurrSY) + 8), 0, B
   IF CurrSX > 0 THEN CurrSX = CurrSX - 1
   InfoRefresh
ELSEIF K$ = CHR$(0) + "M" THEN
   LINE (6 + (8 * CurrSX), 10 + (8 * CurrSY))-(6 + (8 * CurrSX) + 8, 10 + (8 * CurrSY) + 8), 0, B
   IF CurrSX < 15 THEN CurrSX = CurrSX + 1
   InfoRefresh
ELSEIF K$ = "+" OR K$ = "=" THEN
   LINE (32 + (4 * (CurrSC MOD 64)), 175 + (4 * (CurrSC \ 64)))-(32 + (4 * (CurrSC MOD 64)) + 4, 175 + (4 * (CurrSC \ 64)) + 4), 0, B
   CurrSC = CurrSC + 1: IF CurrSC > 255 THEN CurrSC = CurrSC - 256
   InfoRefresh
ELSEIF K$ = "-" THEN
   LINE (32 + (4 * (CurrSC MOD 64)), 175 + (4 * (CurrSC \ 64)))-(32 + (4 * (CurrSC MOD 64)) + 4, 175 + (4 * (CurrSC \ 64)) + 4), 0, B
   CurrSC = CurrSC - 1: IF CurrSC < 0 THEN CurrSC = CurrSC + 256
   InfoRefresh
ELSEIF K$ = CHR$(0) + "Q" THEN
   LINE (32 + (4 * (CurrSC MOD 64)), 175 + (4 * (CurrSC \ 64)))-(32 + (4 * (CurrSC MOD 64)) + 4, 175 + (4 * (CurrSC \ 64)) + 4), 0, B
   CurrSC = CurrSC + 16: IF CurrSC > 255 THEN CurrSC = CurrSC - 256
   InfoRefresh
ELSEIF K$ = CHR$(0) + "I" THEN
   LINE (32 + (4 * (CurrSC MOD 64)), 175 + (4 * (CurrSC \ 64)))-(32 + (4 * (CurrSC MOD 64)) + 4, 175 + (4 * (CurrSC \ 64)) + 4), 0, B
   CurrSC = CurrSC - 16: IF CurrSC < 0 THEN CurrSC = CurrSC + 256
   InfoRefresh
ELSEIF K$ = "Q" THEN
   DEF SEG = VARSEG(Tiles(0))
   FOR Y = 0 TO 15
      FOR X = 0 TO 7
         Ya = 4 + (CurrSpr * 260) + (Y * 16)
         A = PEEK(Ya + X)
         B = PEEK(Ya + (15 - X))
         POKE Ya + X, B
         POKE Ya + (15 - X), A
      NEXT X
   NEXT Y
   DEF SEG
   TilesRefresh
ELSEIF K$ = "W" THEN
   DEF SEG = VARSEG(Tiles(0))
   FOR Y = 0 TO 7
      FOR X = 0 TO 15
         Ya = (Y * 16)
         Xa = 4 + (CurrSpr * 260) + X
         A = PEEK(Ya + Xa)
         B = PEEK((240 - Ya) + Xa)
         POKE Ya + Xa, B
         POKE (240 - Ya) + Xa, A
      NEXT X
   NEXT Y
   DEF SEG
   TilesRefresh
ELSEIF K$ = "X" THEN
   E = CurrSpr * 130
   FOR F = 0 TO 129
      CPS(F) = Tiles(E + F)
      Tiles(E + F) = CS(F)
   NEXT F
   TilesRefresh
   InfoRefresh
ELSEIF K$ = "C" THEN
   E = CurrSpr * 130
   FOR F = 0 TO 129
      CPS(F) = Tiles(E + F)
   NEXT F
   TilesRefresh
   InfoRefresh
ELSEIF K$ = "V" THEN
   E = CurrSpr * 130
   FOR F = 0 TO 129
      Tiles(E + F) = CPS(F)
   NEXT F
   TilesRefresh
   InfoRefresh
ELSEIF K$ = "F" THEN
   DEF SEG = VARSEG(Tiles(0))
   FOR F = 4 + (260 * CurrSpr) TO 259 + (260 * CurrSpr)
      POKE F, CurrSC
   NEXT F
   DEF SEG
   TilesRefresh
   InfoRefresh
ELSEIF K$ = "B" THEN
   DEF SEG = VARSEG(Tiles(0))
   FOR F = 4 + (260 * CurrSpr) TO 259 + (260 * CurrSpr)
      E = PEEK(F)
      IF E / 16 = INT(E / 16) THEN POKE F, 0
   NEXT F
   DEF SEG
   TilesRefresh
   InfoRefresh
ELSEIF K$ = " " THEN
   DEF SEG = VARSEG(Tiles(0))
   POKE 4 + (CurrSX + CurrSY * 16) + (260 * CurrSpr), CurrSC
   DEF SEG
   TilesRefresh
ELSEIF K$ = "E" THEN
   LINE (32 + (4 * (CurrSC MOD 64)), 175 + (4 * (CurrSC \ 64)))-(32 + (4 * (CurrSC MOD 64)) + 4, 175 + (4 * (CurrSC \ 64)) + 4), 0, B
   DEF SEG = VARSEG(Tiles(0))
   CurrSC = PEEK(4 + (CurrSX + CurrSY * 16) + (260 * CurrSpr))
   DEF SEG
   TilesRefresh
ELSEIF K$ = "[" THEN
   IF CurrSpr > 0 THEN
      CurrSpr = CurrSpr - 1
      TilesRefresh
      InfoRefresh
   END IF
ELSEIF K$ = "]" THEN
   IF CurrSpr < 199 THEN
      CurrSpr = CurrSpr + 1
      TilesRefresh
      InfoRefresh
   END IF
ELSEIF K$ = "S" THEN
   PutFont 210, 34, "Save As:", 15, 1
   SaveStr$ = ""
   DO
      DO: M$ = INKEY$: LOOP WHILE M$ = ""
      LINE (242, 34)-(289, 38), 184, BF
      IF ASC(M$) >= 33 AND ASC(M$) <= 122 AND LEN(SaveStr$) < 8 THEN
         SaveStr$ = SaveStr$ + M$
      ELSEIF M$ = CHR$(8) AND LEN(SaveStr$) > 0 THEN
         SaveStr$ = LEFT$(SaveStr$, LEN(SaveStr$) - 1)
      END IF
      PutFont 246, 34, SaveStr$, 12, 1
   LOOP UNTIL M$ = CHR$(27) OR M$ = CHR$(13)
   IF M$ <> CHR$(27) THEN
      DEF SEG = VARSEG(Tiles(0))
      SaveStr$ = SaveStr$ + ".til"
      BSAVE SaveStr$, 0, 52000
      DEF SEG
      LINE (242, 34)-(289, 38), 184, BF
   END IF
   RefreshWindows CurrS
ELSEIF K$ = CHR$(0) + ";" THEN
   HelpWindow 1
   DO: LOOP WHILE INKEY$ = ""
   RefreshWindows CurrS
ELSEIF K$ = "L" THEN
   PutFont 210, 34, "File:", 15, 1
   LoadStr$ = ""
   DO
      DO: M$ = INKEY$: LOOP WHILE M$ = ""
      LINE (230, 34)-(289, 38), 184, BF
      IF ASC(M$) >= 33 AND ASC(M$) <= 122 AND LEN(LoadStr$) < 8 THEN
         LoadStr$ = LoadStr$ + M$
      ELSEIF M$ = CHR$(8) AND LEN(LoadStr$) > 0 THEN
         LoadStr$ = LEFT$(LoadStr$, LEN(LoadStr$) - 1)
      END IF
      PutFont 234, 34, LoadStr$, 12, 1
   LOOP UNTIL M$ = CHR$(27) OR M$ = CHR$(13)
   IF M$ <> CHR$(27) THEN
      DEF SEG = VARSEG(Tiles(0))
      LoadStr$ = LoadStr$ + ".til"
      BLOAD LoadStr$, 0
      DEF SEG
      LINE (230, 34)-(289, 38), 184, BF
   END IF
   RefreshWindows CurrS
END IF
END SUB

SUB TilePEditControl
DO: K$ = INKEY$: LOOP WHILE K$ = ""
K$ = UCASE$(K$)
IF K$ = CHR$(0) + ";" THEN
   HelpWindow 2
   DO: LOOP WHILE INKEY$ = ""
   RefreshWindows CurrS
ELSEIF K$ = CHR$(0) + "H" THEN
   CurrC = CurrC - 1: IF CurrC < 1 THEN CurrC = 7
   TilePRefresh
ELSEIF K$ = CHR$(0) + "P" THEN
   CurrC = CurrC + 1: IF CurrC > 7 THEN CurrC = 1
   TilePRefresh
ELSEIF K$ = CHR$(0) + "K" THEN
   SELECT CASE CurrC
      CASE 1
         IF TileInfo(CurrSpr).Stand > 0 THEN TileInfo(CurrSpr).Stand = TileInfo(CurrSpr).Stand - 1
      CASE 2
         IF TileInfo(CurrSpr).Deadly > 0 THEN TileInfo(CurrSpr).Deadly = TileInfo(CurrSpr).Deadly - 1
      CASE 3
         IF TileInfo(CurrSpr).Misc > 0 THEN TileInfo(CurrSpr).Misc = TileInfo(CurrSpr).Misc - 1
      CASE 4
         IF TileInfo(CurrSpr).GFX > 0 THEN TileInfo(CurrSpr).GFX = TileInfo(CurrSpr).GFX - 1
      CASE 5
         IF TileInfo(CurrSpr).bumps > 0 THEN TileInfo(CurrSpr).bumps = TileInfo(CurrSpr).bumps - 1
      CASE 6
         IF TileInfo(CurrSpr).p1 > 0 THEN TileInfo(CurrSpr).p1 = TileInfo(CurrSpr).p1 - 1
      CASE 7
         IF TileInfo(CurrSpr).p2 > 0 THEN TileInfo(CurrSpr).p2 = TileInfo(CurrSpr).p2 - 1
   END SELECT
   TilePRefresh
ELSEIF K$ = CHR$(0) + "M" THEN
   SELECT CASE CurrC
      CASE 1
         IF TileInfo(CurrSpr).Stand < 9 THEN TileInfo(CurrSpr).Stand = TileInfo(CurrSpr).Stand + 1
      CASE 2
         IF TileInfo(CurrSpr).Deadly < 6 THEN TileInfo(CurrSpr).Deadly = TileInfo(CurrSpr).Deadly + 1
      CASE 3
         IF TileInfo(CurrSpr).Misc < 13 THEN TileInfo(CurrSpr).Misc = TileInfo(CurrSpr).Misc + 1
      CASE 4
         IF TileInfo(CurrSpr).GFX < 7 THEN TileInfo(CurrSpr).GFX = TileInfo(CurrSpr).GFX + 1
      CASE 5
         IF TileInfo(CurrSpr).bumps < 100 THEN TileInfo(CurrSpr).bumps = TileInfo(CurrSpr).bumps + 1
      CASE 6
         IF TileInfo(CurrSpr).p1 < 15 THEN TileInfo(CurrSpr).p1 = TileInfo(CurrSpr).p1 + 1
      CASE 7
         IF TileInfo(CurrSpr).p2 < 15 THEN TileInfo(CurrSpr).p2 = TileInfo(CurrSpr).p2 + 1
   END SELECT
   TilePRefresh
ELSEIF K$ = "]" THEN
   CurrSpr = CurrSpr + 1: IF CurrSpr > 199 THEN CurrSpr = 0
   TilePRefresh
ELSEIF K$ = "[" THEN
   CurrSpr = CurrSpr - 1: IF CurrSpr < 0 THEN CurrSpr = 199
   TilePRefresh
ELSEIF K$ = "S" THEN
   PutFont 210, 34, "Save As:", 15, 1
   SaveStr$ = ""
   DO
      DO: M$ = INKEY$: LOOP WHILE M$ = ""
      LINE (242, 34)-(289, 38), 184, BF
      IF ASC(M$) >= 33 AND ASC(M$) <= 122 AND LEN(SaveStr$) < 8 THEN
         SaveStr$ = SaveStr$ + M$
      ELSEIF M$ = CHR$(8) AND LEN(SaveStr$) > 0 THEN
         SaveStr$ = LEFT$(SaveStr$, LEN(SaveStr$) - 1)
      END IF
      PutFont 246, 34, SaveStr$, 12, 1
   LOOP UNTIL M$ = CHR$(27) OR M$ = CHR$(13)
   IF M$ <> CHR$(27) THEN
      DEF SEG = VARSEG(TileInfo(0).Stand)
      SaveStr$ = SaveStr$ + ".tld"
      BSAVE SaveStr$, 0, 2800
      DEF SEG
      LINE (242, 34)-(289, 38), 184, BF
   END IF
   RefreshWindows CurrS
ELSEIF K$ = "L" THEN
   PutFont 210, 34, "File:", 15, 1
   LoadStr$ = ""
   DO
      DO: M$ = INKEY$: LOOP WHILE M$ = ""
      LINE (230, 34)-(289, 38), 184, BF
      IF ASC(M$) >= 33 AND ASC(M$) <= 122 AND LEN(LoadStr$) < 8 THEN
         LoadStr$ = LoadStr$ + M$
      ELSEIF M$ = CHR$(8) AND LEN(LoadStr$) > 0 THEN
         LoadStr$ = LEFT$(LoadStr$, LEN(LoadStr$) - 1)
      END IF
      PutFont 234, 34, LoadStr$, 12, 1
   LOOP UNTIL M$ = CHR$(27) OR M$ = CHR$(13)
   IF M$ <> CHR$(27) THEN
      DEF SEG = VARSEG(TileInfo(0).Stand)
      LoadStr$ = LoadStr$ + ".tld"
      BLOAD LoadStr$, 0
      DEF SEG
      LINE (230, 34)-(289, 38), 184, BF
   END IF
   RefreshWindows CurrS
END IF
END SUB

SUB TilePRefresh
   PutFont 2, 10, "Tile Number:", 15, 1
   LINE (54, 10)-(70, 14), 184, BF
   PutFont 50, 10, STR$(CurrSpr), 9, 1
   PutFont 2, 20, "Solidness:", 181 + (CurrC = 1) * 166, 1
   LINE (46, 20)-(210, 24), 184, BF
   SELECT CASE TileInfo(CurrSpr).Stand
      CASE 0
         A$ = "Can walk/fall right through"
      CASE 1
         A$ = "Can't walk/fall through from any way"
      CASE 2
         A$ = "Can't walk/fall through from above"
      CASE 3
         A$ = "Can't walk/fall through from below"
      CASE 4
         A$ = "Can't walk/fall through from left"
      CASE 5
         A$ = "Can't walk/fall through from right"
      CASE 6
         A$ = "Walk through any way, sticky"
      CASE 7
         A$ = "Two-point slope platform (above)"
      CASE 8
         A$ = "Two-point slope platform (below)"
      CASE 9
         A$ = "Swimmable"
   END SELECT
   PutFont 46, 20, A$, 9, 1
   PutFont 2, 25, "Deadliness:", 181 + (CurrC = 2) * 166, 1
   LINE (54, 25)-(210, 29), 184, BF
   SELECT CASE TileInfo(CurrSpr).Deadly
      CASE 0
         A$ = "not deadly"
      CASE 1
         A$ = "deadly from any way"
      CASE 2
         A$ = "deadly from above contact"
      CASE 3
         A$ = "deadly from below contact"
      CASE 4
         A$ = "deadly from left contact"
      CASE 5
         A$ = "deadly from right contact"
      CASE 6
         A$ = "deadly if in for more than 1 second"
   END SELECT
   PutFont 54, 25, A$, 9, 1
   PutFont 2, 30, "Misc:", 181 + (CurrC = 3) * 166, 1
   LINE (26, 30)-(210, 34), 184, BF
   SELECT CASE TileInfo(CurrSpr).Misc
      CASE 0
         A$ = "nothing"
      CASE 1
         A$ = "forces player to move up"
      CASE 2
         A$ = "forces player to move left"
      CASE 3
         A$ = "forces player to move right"
      CASE 4
         A$ = "forces player to accelerate up"
      CASE 5
         A$ = "forces player to accelerate left"
      CASE 6
         A$ = "forces player to accelerate right"
      CASE 7
         A$ = "bounces player same velocity of contact"
      CASE 8
         A$ = "bounces player higher velocity of contact"
      CASE 9
         A$ = "slippery"
      CASE 10
         A$ = "good flower"
      CASE 11
         A$ = "bad flower"
      CASE 12
         A$ = "mr. pants (make you go faster)"
      CASE 13
         A$ = "wings (make you jump higher)"
   END SELECT
   PutFont 26, 30, A$, 9, 1
   PutFont 2, 35, "Graphical FX:", 181 + (CurrC = 4) * 166, 1
   LINE (58, 35)-(210, 39), 184, BF
   SELECT CASE TileInfo(CurrSpr).GFX
      CASE 0
         A$ = "none"
      CASE 1
         A$ = "turns behind blue"
      CASE 2
         A$ = "turns behind red"
      CASE 3
         A$ = "turns behind gray"
      CASE 4
         A$ = "wobbles behind"
      CASE 5
         A$ = "wobbles behind, blue"
      CASE 6
         A$ = "wobbles behind, red"
      CASE 7
         A$ = "wobbles behind, brown"
   END SELECT
   PutFont 58, 35, A$, 9, 1
   PutFont 2, 40, "Bump Occurence:", 181 + (CurrC = 5) * 166, 1
   LINE (66, 40)-(210, 44), 184, BF
   A$ = STR$(TileInfo(CurrSpr).bumps) + "%"
   PutFont 66, 40, A$, 9, 1
   PutFont 2, 45, "Left Point:", 181 + (CurrC = 6) * 166, 1
   LINE (46, 45)-(210, 49), 184, BF
   PutFont 46, 45, STR$(TileInfo(CurrSpr).p1), 9, 1
   PutFont 2, 50, "Right Point:", 181 + (CurrC = 7) * 166, 1
   LINE (50, 50)-(210, 54), 184, BF
   PutFont 50, 50, STR$(TileInfo(CurrSpr).p2), 9, 1
   PutFont 2, 60, "Reference tile:", 191, 1
   LINE (5, 70)-(22, 87), 0, BF
   LINE (5, 70)-(5, 87), 181
   LINE (5, 70)-(22, 70), 181
   LINE (5, 87)-(22, 87), 191
   LINE (22, 70)-(22, 87), 191
   PUT (6, 71), Tiles(130 * CurrSpr), PSET
   PutFont 2, 90, "Slope (if any):", 191, 1
   LINE (5, 100)-(22, 117), 0, BF
   LINE (5, 100)-(5, 117), 181
   LINE (5, 100)-(22, 100), 181
   LINE (5, 117)-(22, 117), 191
   LINE (22, 100)-(22, 117), 191
   PUT (6, 101), Tiles(130 * CurrSpr), PSET
   IF TileInfo(CurrSpr).Stand = 7 OR TileInfo(CurrSpr).Stand = 8 THEN LINE (6, 116 - TileInfo(CurrSpr).p1)-(21, 116 - TileInfo(CurrSpr).p2), 15
END SUB

SUB TilesRefresh
DEF SEG = VARSEG(Tiles(0))
A = 4
FOR Y = 0 TO 15
   FOR X = 0 TO 15
      LINE (6 + (8 * X), 10 + (8 * Y))-(6 + (8 * X) + 7, 10 + (8 * Y) + 7), PEEK(A + (260& * CurrSpr)), BF
      LINE (6 + (8 * X), 10 + (8 * Y))-(6 + (8 * X) + 8, 10 + (8 * Y) + 8), 0, B
      A = A + 1
   NEXT X
NEXT Y
DEF SEG
PUT (141, 10), Tiles(CurrSpr * 130), PSET
FOR Y = 0 TO 3
   FOR X = 0 TO 3
      PUT (141 + (16 * X), 39 + (16 * Y)), Tiles(CurrSpr * 130), PSET
   NEXT X
NEXT Y
END SUB

